
--
-- Table structure for table `errors`
--

CREATE TABLE `errors` (
  `ErrorID` int(10) UNSIGNED NOT NULL,
  `ErrorDate` datetime NOT NULL,
  `UserID` smallint(5) UNSIGNED DEFAULT NULL,
  `ErrorTypeID` tinyint(3) UNSIGNED NOT NULL DEFAULT 3,
  `Page` varchar(200) NOT NULL DEFAULT '',
  `Context` varchar(200) NOT NULL DEFAULT '',
  `Error` text NOT NULL,
  `Query` text NOT NULL,
  `ErrorCode` varchar(50) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Indexes for table `errors`
--
ALTER TABLE `errors`
  ADD PRIMARY KEY (`ErrorID`);

--
-- AUTO_INCREMENT for table `errors`
--
ALTER TABLE `errors`
  MODIFY `ErrorID` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;

-- --------------------------------------------------------

--
-- Table structure for table `errortypes`
--

CREATE TABLE `errortypes` (
  `ErrorTypeID` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `ErrorType` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `errortypes`
--

INSERT INTO `errortypes` (`ErrorTypeID`, `ErrorType`) VALUES
(1, 'Install'),
(2, 'Upgrade'),
(3, 'Website'),
(4, 'CRON Job'),
(5, 'API Integration');

--
-- Indexes for table `errortypes`
--
ALTER TABLE `errortypes`
  ADD PRIMARY KEY (`ErrorTypeID`);

-- --------------------------------------------------------

--
-- Table structure for table `affiliatesources`
--

CREATE TABLE `affiliatesources` (
  `AffiliateSourceID` smallint(5) UNSIGNED NOT NULL,
  `Affiliate` varchar(100) NOT NULL,
  `RevenueParam` varchar(100) NOT NULL DEFAULT 'revenue',
  `SubIdSeparator` varchar(20) NOT NULL DEFAULT '_',
  `OfferTemplate` varchar(500) DEFAULT NULL,
  `PostbackURL` varchar(200) DEFAULT NULL,
  `PageName` varchar(100) DEFAULT NULL,
  `SubIdPlace` varchar(100) DEFAULT NULL,
  `RevenuePlace` varchar(100) DEFAULT NULL,
  `StatusPlace` varchar(100) DEFAULT NULL,
  `TransactionPlace` varchar(100) DEFAULT NULL,
  `Custom1Place` varchar(100) DEFAULT NULL,
  `Custom2Place` varchar(100) DEFAULT NULL,
  `Custom3Place` varchar(100) DEFAULT NULL,
  `Custom4Place` varchar(100) DEFAULT NULL,
  `Custom5Place` varchar(100) DEFAULT NULL,
  `StatusValues` varchar(200) DEFAULT NULL,
  `PassTsStatusValues` varchar(200) DEFAULT NULL,
  `DateAdded` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `affiliatesources`
--

INSERT INTO `affiliatesources` (`AffiliateSourceID`, `Affiliate`, `RevenueParam`, `SubIdSeparator`, `OfferTemplate`, `PostbackURL`, `PageName`, `SubIdPlace`, `RevenuePlace`, `StatusPlace`, `TransactionPlace`, `Custom1Place`, `Custom2Place`, `Custom3Place`, `Custom4Place`, `Custom5Place`, `StatusValues`, `PassTsStatusValues`, `DateAdded`) VALUES
(1, 'In-House', 'revenue', '_', '{your_offer_url}?subid={!subid!}', 'adclick.php?subid=REPLACE', 'adclick.php', '', '', '', '', '', '', '', '', '', '', NULL, '2020-01-30 00:00:00'),
(2, 'ClickBank', 'revenue', 'z', '{your_offer_url}&tid={!subid!}', 'adclick-cb70.php', 'adclick-cb70.php', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2020-01-30 00:00:00'),
(3, 'Tune (HasOffers)', 'revenue', '_', '{your_offer_url}&aff_sub={!subid!}', 'adclick.php?subid={aff_sub}&revenue={payout}&txid={transaction_id}', 'adclick.php', '{aff_sub}', '{payout}', '', '{transaction_id}', '', '', '', '', '', '', NULL, '2020-01-30 00:00:00'),
(4, 'ExpertMobi', 'revenue', '_', '{your_offer_url}?subid2={!subid!}', 'adclick.php?subid={{subid2}}', 'adclick.php', '{{subid2}}', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2020-01-30 00:00:00'),
(5, 'Max Bounty', 'revenue', '_', '{your_offer_url}&s2={!subid!}', 'adclick.php?subid=#S2#&revenue=#RATE#', 'adclick.php', '#S2#', '#RATE#', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2020-01-30 00:00:00'),
(6, 'A4D', 'revenue', '_', '{your_offer_url}&aff_sub={!subid!}', 'adclick.php?subid={aff_sub}&revenue={payout}&txid={transaction_id}', 'adclick.php', '{aff_sub}', '{payout}', '', '{transaction_id}', '', '', '', '', '', '', NULL, '2020-01-30 00:00:00'),
(7, 'Cake', 'revenue', '_', '{your_offer_url}&s2={!subid!}', 'adclick.php?subid=#s2#&revenue=#price#&txid=#tid#', 'adclick.php', '#s2#', '#price#', '', '#tid#', '', '', '', '', '', '', NULL, '2020-01-30 00:00:00'),
(8, 'Addiliate', 'revenue', '_', '{your_offer_url}&add1={!subid!}', 'adclick.php?subid=%add1%&revenue=%amount%', 'adclick.php', '%add1%', '%amount%', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2020-01-30 00:00:00'),
(9, 'MyLead', 'revenue', '_', '{your_offer_url}?ml_sub1={!subid!}', 'adclick.php?subid=[ml_sub1]&revenue=[payout_decimal]&status=[status]&txid=[transaction_id]', 'adclick.php', '[ml_sub1]', '[payout_decimal]', '[status]', '[transaction_id]', '', '', '', '', '', '', NULL, '2020-01-30 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `alertprofiles`
--

CREATE TABLE `alertprofiles` (
  `AlertProfileID` smallint(5) UNSIGNED NOT NULL,
  `AlertProfileName` varchar(100) NOT NULL,
  `DefaultProfile` tinyint(1) NOT NULL DEFAULT 0,
  `alert1Views` varchar(10) DEFAULT NULL,
  `alert1Conversion` varchar(10) DEFAULT NULL,
  `alert2Views` varchar(10) DEFAULT NULL,
  `alert2Clicks` varchar(10) DEFAULT NULL,
  `alert3Views` varchar(10) DEFAULT NULL,
  `alert3Subscribers` varchar(10) DEFAULT NULL,
  `alert4Views` varchar(10) DEFAULT NULL,
  `alert4SR` varchar(10) DEFAULT NULL,
  `alert5Views` varchar(10) DEFAULT NULL,
  `alert5CTR` varchar(10) DEFAULT NULL,
  `alert6Views` varchar(10) DEFAULT NULL,
  `alert6CR` varchar(10) DEFAULT NULL,
  `calert1Views` varchar(10) DEFAULT NULL,
  `calert2Views` varchar(10) DEFAULT NULL,
  `CreateDate` datetime NOT NULL,
  `ModifyDate` datetime DEFAULT NULL,
  `EmailAddresses` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `alertprofiles`
--

INSERT INTO `alertprofiles` (`AlertProfileID`, `AlertProfileName`, `DefaultProfile`, `alert1Views`, `alert1Conversion`, `alert2Views`, `alert2Clicks`, `alert3Views`, `alert3Subscribers`, `alert4Views`, `alert4SR`, `alert5Views`, `alert5CTR`, `alert6Views`, `alert6CR`, `calert1Views`, `calert2Views`, `CreateDate`, `ModifyDate`, `EmailAddresses`) VALUES
(1, 'Default Alert Profile', 1, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '2020-01-30 00:00:00', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `alerts`
--

CREATE TABLE `alerts` (
  `AlertID` int(10) UNSIGNED NOT NULL,
  `AlertName` varchar(45) NOT NULL,
  `AlertValue` varchar(45) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `alerts`
--

INSERT INTO `alerts` (`AlertID`, `AlertName`, `AlertValue`) VALUES
(1, 'alert1Views', ''),
(2, 'alert1Conversion', ''),
(3, 'alert2Views', ''),
(4, 'alert2Clicks', ''),
(5, 'alert3Views', ''),
(6, 'alert3Subscribers', ''),
(7, 'alert4Views', ''),
(8, 'alert4SR', ''),
(9, 'calert1Views', ''),
(10, 'calert2Views', ''),
(11, 'alert5Views', ''),
(12, 'alert5CTR', ''),
(13, 'alert6Views', ''),
(14, 'alert6CR', '');

-- --------------------------------------------------------

--
-- Table structure for table `apiintegrations`
--

CREATE TABLE `apiintegrations` (
  `ApiIntegrationID` smallint(5) UNSIGNED NOT NULL,
  `ApiIntegrationName` varchar(190) DEFAULT NULL,
  `ApiTypeID` tinyint(3) UNSIGNED DEFAULT NULL,
  `Active` tinyint(1) UNSIGNED DEFAULT NULL,
  `DateAdded` datetime DEFAULT NULL,
  `Username` varchar(190) DEFAULT NULL,
  `Password` varchar(190) DEFAULT NULL,
  `DeveloperKey` varchar(190) DEFAULT NULL,
  `AccessToken` text DEFAULT NULL,
  `CustomerID` varchar(190) DEFAULT NULL,
  `Settings` text DEFAULT NULL,
  `AccessTokenExpire` datetime DEFAULT NULL,
  `RefreshToken` text DEFAULT NULL,
  `RefreshTokenExpire` datetime DEFAULT NULL,
  `LastApiLogID` int(10) UNSIGNED DEFAULT NULL,
  `OptionSyncCosts` tinyint(1) UNSIGNED DEFAULT 1,
  `OptionPassConversions` tinyint(1) UNSIGNED DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `apilog`
--

CREATE TABLE `apilog` (
  `ApiLogID` int(10) UNSIGNED NOT NULL,
  `ApiIntegrationID` smallint(5) UNSIGNED DEFAULT NULL,
  `DateAdded` datetime DEFAULT NULL,
  `CampaignsMatchedCount` smallint(5) UNSIGNED DEFAULT NULL,
  `Status` varchar(190) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `apilogcampaigns`
--

CREATE TABLE `apilogcampaigns` (
  `ApiLogID` int(10) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `KeywordsImportedCount` int(10) UNSIGNED DEFAULT NULL,
  `Status` varchar(190) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `apilogtargets`
--

CREATE TABLE `apilogtargets` (
  `ApiLogID` int(10) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `SubIdID` int(10) UNSIGNED NOT NULL,
  `Cost` double DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `apitypes`
--

CREATE TABLE `apitypes` (
  `ApiTypeID` tinyint(3) UNSIGNED NOT NULL,
  `ApiTypeName` varchar(190) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `apitypes`
--

INSERT INTO `apitypes` (`ApiTypeID`, `ApiTypeName`) VALUES
(1, 'Microsoft (Bing) Ads');

-- --------------------------------------------------------

--
-- Table structure for table `bidads`
--

CREATE TABLE `bidads` (
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `AdValue` varchar(191) NOT NULL,
  `Cost` double NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `bidsubids`
--

CREATE TABLE `bidsubids` (
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `SubIdID` int(10) UNSIGNED NOT NULL,
  `Cost` double NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `blockedclicks`
--

CREATE TABLE `blockedclicks` (
  `ClickID` int(10) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED DEFAULT NULL,
  `SubIdID` int(10) UNSIGNED DEFAULT NULL,
  `ViewDate` datetime DEFAULT NULL,
  `BlockReason` tinyint(4) DEFAULT 1,
  `IPBinary` varbinary(16) DEFAULT NULL,
  `UserAgent` varchar(191) DEFAULT NULL,
  `Referrer` varchar(191) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `blockrules`
--

CREATE TABLE `blockrules` (
  `BlockRuleID` smallint(5) UNSIGNED NOT NULL,
  `BlockName` varchar(100) DEFAULT NULL,
  `StartIP` int(10) UNSIGNED DEFAULT NULL,
  `EndIP` int(10) UNSIGNED DEFAULT NULL,
  `BlockUA` varchar(191) DEFAULT NULL,
  `BlockReferrer` varchar(191) DEFAULT NULL,
  `Active` tinyint(1) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `blockrules`
--

INSERT INTO `blockrules` (`BlockRuleID`, `BlockName`, `StartIP`, `EndIP`, `BlockUA`, `BlockReferrer`, `Active`) VALUES
(1, 'Google IP 1', 1208926208, 1208942591, NULL, NULL, 1),
(2, 'Google IP 2', 3512041472, 3512074239, NULL, NULL, 1),
(3, 'Google IP 3', 1123631104, 1123639295, NULL, NULL, 1),
(4, 'Google IP 4', 1089052672, 1089060863, NULL, NULL, 1),
(5, 'Google IP 5', 782925824, 782893057, NULL, NULL, 1),
(6, 'Google IP 6', 1113980928, 1113985023, NULL, NULL, 1),
(7, 'Google IP 7', 1249705984, 1249771519, NULL, NULL, 1),
(8, 'Google IP 8', 3639549952, 3639558143, NULL, NULL, 1),
(9, 'MSN IP', 1093926912, 1094189055, NULL, NULL, 1),
(10, 'Microsoft IP', 3475898368, 3475963903, NULL, NULL, 1),
(11, 'Bing IP 1', 1074003968, 1074020351, NULL, NULL, 1),
(12, 'Bing IP 2', 2637561856, 2638020607, NULL, NULL, 1),
(13, 'Bing IP 3', 3477372928, 3477393407, NULL, NULL, 1),
(14, 'Yahoo IP 1', 3640418304, 3640426495, NULL, NULL, 1),
(15, 'Yahoo IP 2', 3515031552, 3515039743, NULL, NULL, 1),
(16, 'Yahoo IP 3', 3633393664, 3633397759, NULL, NULL, 1),
(17, 'Yahoo IP 4', 1209925632, 1209991167, NULL, NULL, 1),
(18, 'Yahoo IP 5', 1241907200, 1241972735, NULL, NULL, 1),
(19, 'Yahoo IP 6', 135041024, 135041279, NULL, NULL, 1),
(20, 'Yahoo IP 7', 1120157696, 1120174079, NULL, NULL, 1),
(21, 'Yahoo IP 8', 1122279424, 1122287615, NULL, NULL, 1),
(22, 'Yahoo IP 9', 1136852992, 1136918527, NULL, NULL, 1),
(23, 'Yahoo IP 10', 1150205952, 1150222335, NULL, NULL, 1),
(24, 'Yahoo IP 11', 3399528448, 3399532543, NULL, NULL, 1),
(25, 'Yahoo IP 12', 3518971904, 3518988287, NULL, NULL, 1),
(26, 'Yahoo IP 13', 3279950355, 3279950355, NULL, NULL, 1),
(27, 'L3C IP', 1094189056, 1094451199, NULL, NULL, 1),
(28, 'Google UA', NULL, NULL, 'Googlebot', NULL, 1),
(29, 'Yahoo UA 1', NULL, NULL, 'Yahoo! Slurp', NULL, 1),
(30, 'Yahoo UA 2', NULL, NULL, 'YahooSeeker', NULL, 1),
(31, 'MSN UA', NULL, NULL, 'msnbot', NULL, 1),
(32, 'Bing UA', NULL, NULL, 'bingbot', NULL, 1),
(33, 'PSI IP', 637534208, 654311423, NULL, NULL, 0),
(34, 'AdOn IP', 204456961, 204457215, NULL, NULL, 1),
(35, 'Google Ads Bot UA', NULL, NULL, 'AdsBot-Google', NULL, 1),
(36, 'Facebook External Hit UA', NULL, NULL, 'facebookexternalhit', NULL, 1),
(37, 'Facebook Catalog UA', NULL, NULL, 'facebookcatalog', NULL, 1),
(38, 'BitlyBot UA', NULL, NULL, 'bitlybot', NULL, 1),
(39, 'Facebook IP 1', 520972032, 520972287, NULL, NULL, 1),
(40, 'Facebook IP 2', 520975104, 520975359, NULL, NULL, 1),
(41, 'Facebook IP 3', 520978176, 520978431, NULL, NULL, 1),
(42, 'Facebook IP 4', 1027990784, 1027991039, NULL, NULL, 1),
(43, 'Facebook IP 5', 1121752320, 1121752575, NULL, NULL, 1),
(44, 'Facebook IP 6', 1121752320, 1121752575, NULL, NULL, 1),
(45, 'Facebook IP 7', 1168898304, 1168898559, NULL, NULL, 1),
(46, 'Facebook IP 8', 1168898816, 1168899071, NULL, NULL, 1),
(47, 'Facebook IP 9', 1161803776, 1161804031, NULL, NULL, 1),
(48, 'Facebook IP 10', 1161805056, 1161805311, NULL, NULL, 1),
(49, 'Facebook IP 11', 2919000832, 2919001087, NULL, NULL, 1),
(50, 'Facebook IP 12', 2919005952, 2919006207, NULL, NULL, 1),
(51, 'Facebook IP 13', 2918995712, 2918995967, NULL, NULL, 1),
(52, 'Facebook IP 14', 2918997760, 2918998015, NULL, NULL, 1),
(53, 'Bing IP 4', 676186302, 676186311, NULL, NULL, 1),
(54, 'Bing IP 5', 755874424, 755874433, NULL, NULL, 1),
(55, 'Bing IP 6', 676182528, 676182783, NULL, NULL, 1),
(56, 'Bing IP 7', 676170496, 676170751, NULL, NULL, 1),
(57, 'Bing IP 8', 677256704, 677256959, NULL, NULL, 1),
(58, 'Bing IP 9', 677256960, 677257215, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `cachead`
--

CREATE TABLE `cachead` (
  `CacheID` int(10) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `DateInterval` date NOT NULL,
  `Extra1ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra2ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra3ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra4ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra5ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra6ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra7ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra8ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra9ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra10ID` int(10) UNSIGNED DEFAULT NULL,
  `AdValueID` int(10) UNSIGNED DEFAULT NULL,
  `Views` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Engages` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Clicks` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Conversion` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Subscribers` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Cost` float NOT NULL DEFAULT 0,
  `Revenue` float NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cachecampaign`
--

CREATE TABLE `cachecampaign` (
  `CacheID` int(10) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `DateInterval` date NOT NULL,
  `Views` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Clicks` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Conversion` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Subscribers` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Cost` float NOT NULL DEFAULT 0,
  `Revenue` float NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cacheconversion`
--

CREATE TABLE `cacheconversion` (
  `ClickID` bigint(20) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `SubIdID` int(10) UNSIGNED NOT NULL,
  `DestinationID` mediumint(8) UNSIGNED NOT NULL,
  `OfferID` mediumint(8) UNSIGNED DEFAULT NULL,
  `ReferrerID` int(10) UNSIGNED NOT NULL DEFAULT 1,
  `Extra1ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra2ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra3ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra4ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra5ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra6ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra7ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra8ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra9ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra10ID` int(10) UNSIGNED DEFAULT NULL,
  `AdValueID` int(10) UNSIGNED DEFAULT NULL,
  `DeviceID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `IspID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `ViewDate` datetime NOT NULL,
  `ConversionDate` datetime NOT NULL,
  `Revenue` double DEFAULT NULL,
  `IPBinary` varbinary(16) DEFAULT NULL,
  `UserAgentID` int(10) UNSIGNED NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cachedevice`
--

CREATE TABLE `cachedevice` (
  `CacheID` int(10) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `DateInterval` date NOT NULL,
  `DeviceID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `Views` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Clicks` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Conversion` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Subscribers` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Cost` float NOT NULL DEFAULT 0,
  `Revenue` float NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cachegeo`
--

CREATE TABLE `cachegeo` (
  `CacheID` int(10) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `DateInterval` date NOT NULL,
  `SubIdID` int(10) UNSIGNED NOT NULL,
  `DestinationID` mediumint(8) UNSIGNED NOT NULL,
  `OfferID` mediumint(8) UNSIGNED DEFAULT NULL,
  `AdValueID` int(10) UNSIGNED DEFAULT NULL,
  `DeviceID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `IspID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `CityID` mediumint(8) UNSIGNED DEFAULT 1,
  `Views` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Clicks` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Conversion` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Subscribers` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Cost` float NOT NULL DEFAULT 0,
  `Revenue` float NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cacheisp`
--

CREATE TABLE `cacheisp` (
  `CacheID` int(10) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `DateInterval` date NOT NULL,
  `IspID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `Views` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Clicks` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Conversion` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Subscribers` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Cost` float NOT NULL DEFAULT 0,
  `Revenue` float NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cachelanding`
--

CREATE TABLE `cachelanding` (
  `CacheID` int(10) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `DateInterval` date NOT NULL,
  `DestinationID` mediumint(8) UNSIGNED NOT NULL,
  `OfferID` mediumint(8) UNSIGNED DEFAULT NULL,
  `Level` tinyint(3) NOT NULL DEFAULT 1,
  `Views` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Engages` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Clicks` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Conversion` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Subscribers` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Cost` float NOT NULL DEFAULT 0,
  `Revenue` float NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cacheoffer`
--

CREATE TABLE `cacheoffer` (
  `CacheID` int(10) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `DateInterval` date NOT NULL,
  `OfferID` mediumint(8) UNSIGNED DEFAULT NULL,
  `Views` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Clicks` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Conversion` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Cost` float NOT NULL DEFAULT 0,
  `Revenue` float NOT NULL DEFAULT 0,
  `ConversionTime` float UNSIGNED NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cacherelation`
--

CREATE TABLE `cacherelation` (
  `ClickID` bigint(20) UNSIGNED NOT NULL,
  `CacheTarget` int(10) UNSIGNED DEFAULT NULL,
  `CacheAd` int(10) UNSIGNED DEFAULT NULL,
  `CacheLanding` int(10) UNSIGNED DEFAULT NULL,
  `CacheLevels` varchar(200) DEFAULT NULL,
  `CacheAfter` int(10) UNSIGNED DEFAULT NULL,
  `CacheThankYou` int(10) UNSIGNED DEFAULT NULL,
  `CacheOffer` int(10) UNSIGNED DEFAULT NULL,
  `CacheCampaign` int(10) UNSIGNED DEFAULT NULL,
  `CacheTraffic` int(10) UNSIGNED DEFAULT NULL,
  `CacheDevice` int(10) UNSIGNED DEFAULT NULL,
  `CacheIsp` int(10) UNSIGNED DEFAULT NULL,
  `CacheTrendDay` int(10) UNSIGNED DEFAULT NULL,
  `CacheTrendHour` int(10) UNSIGNED DEFAULT NULL,
  `CacheGeo` int(10) UNSIGNED DEFAULT NULL,
  `DateAdded` date DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cachesubscriber`
--

CREATE TABLE `cachesubscriber` (
  `ClickID` bigint(20) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `SubIdID` int(10) UNSIGNED NOT NULL,
  `DestinationID` mediumint(8) UNSIGNED NOT NULL,
  `OfferID` mediumint(8) UNSIGNED DEFAULT NULL,
  `ReferrerID` int(10) UNSIGNED NOT NULL DEFAULT 1,
  `Extra1ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra2ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra3ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra4ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra5ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra6ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra7ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra8ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra9ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra10ID` int(10) UNSIGNED DEFAULT NULL,
  `AdValueID` int(10) UNSIGNED DEFAULT NULL,
  `DeviceID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `IspID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `ViewDate` datetime NOT NULL,
  `SubscribeDate` datetime NOT NULL,
  `Revenue` double DEFAULT NULL,
  `IPBinary` varbinary(16) DEFAULT NULL,
  `UserAgentID` int(10) UNSIGNED NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cachetarget`
--

CREATE TABLE `cachetarget` (
  `CacheID` int(10) UNSIGNED NOT NULL,
  `CacheHash` char(32) NOT NULL DEFAULT '',
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `DateInterval` date NOT NULL,
  `SubIdID` int(10) UNSIGNED NOT NULL,
  `DestinationID` mediumint(8) UNSIGNED NOT NULL,
  `OfferID` mediumint(8) UNSIGNED DEFAULT NULL,
  `ReferrerID` int(10) UNSIGNED NOT NULL DEFAULT 1,
  `SiteCategoryID` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `Extra1ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra2ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra3ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra4ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra5ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra6ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra7ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra8ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra9ID` int(10) UNSIGNED DEFAULT NULL,
  `Extra10ID` int(10) UNSIGNED DEFAULT NULL,
  `AdValueID` int(10) UNSIGNED DEFAULT NULL,
  `DeviceID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `IspID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `IsDirectTraffic` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `IsMobileTraffic` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `Views` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Engages` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Clicks` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Conversion` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Subscribers` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Cost` float NOT NULL DEFAULT 0,
  `Revenue` float NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cachethankyou`
--

CREATE TABLE `cachethankyou` (
  `CacheID` int(10) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `DateInterval` date NOT NULL,
  `Views` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Engages` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Clicks` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Conversion` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Cost` float NOT NULL DEFAULT 0,
  `Revenue` float NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cachetotals`
--

CREATE TABLE `cachetotals` (
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `Views` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Clicks` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Conversion` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Subscribers` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Cost` float NOT NULL DEFAULT 0,
  `Revenue` float NOT NULL DEFAULT 0,
  `Profit` float NOT NULL DEFAULT 0,
  `ROI` float NOT NULL DEFAULT 0,
  `NewViews` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `NewSubscribers` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `NewProfit` float NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cachetraffic`
--

CREATE TABLE `cachetraffic` (
  `CacheID` int(10) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `DateInterval` date NOT NULL,
  `IsDirectTraffic` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `IsMobileTraffic` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `Views` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Clicks` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Conversion` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Subscribers` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Cost` float NOT NULL DEFAULT 0,
  `Revenue` float NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cachetrendday`
--

CREATE TABLE `cachetrendday` (
  `CacheID` int(10) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `DateInterval` date NOT NULL,
  `SubIdID` int(10) UNSIGNED NOT NULL,
  `DestinationID` mediumint(8) UNSIGNED NOT NULL,
  `OfferID` mediumint(8) UNSIGNED DEFAULT NULL,
  `Views` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Engages` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Clicks` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Conversion` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Subscribers` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Cost` float NOT NULL DEFAULT 0,
  `Revenue` float NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cachetrendhour`
--

CREATE TABLE `cachetrendhour` (
  `CacheID` int(10) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `DateInterval` date NOT NULL,
  `HourInterval` tinyint(4) UNSIGNED NOT NULL,
  `HourIntervalName` varchar(4) NOT NULL,
  `SubIdID` int(10) UNSIGNED NOT NULL,
  `DestinationID` mediumint(8) UNSIGNED NOT NULL,
  `OfferID` mediumint(8) UNSIGNED DEFAULT NULL,
  `Views` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Engages` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Clicks` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Conversion` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Subscribers` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Cost` float NOT NULL DEFAULT 0,
  `Revenue` float NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `campaigngroups`
--

CREATE TABLE `campaigngroups` (
  `CampaignGroupID` smallint(5) UNSIGNED NOT NULL,
  `CampaignGroup` varchar(100) DEFAULT NULL,
  `CreateDate` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `campaignlevels`
--

CREATE TABLE `campaignlevels` (
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `LevelID` tinyint(3) NOT NULL DEFAULT 1,
  `LevelName` varchar(100) DEFAULT NULL,
  `LevelLinks` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `campaignoptions`
--

CREATE TABLE `campaignoptions` (
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `OptionID` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `OptionName` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `campaigns`
--

CREATE TABLE `campaigns` (
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `CampaignName` text DEFAULT NULL,
  `CampaignTypeID` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `SourceID` varchar(10) NOT NULL DEFAULT '',
  `Source` varchar(100) NOT NULL DEFAULT '',
  `EngageSeconds` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `CreateDate` datetime NOT NULL,
  `CreateUserID` smallint(5) UNSIGNED NOT NULL,
  `ModifyDate` datetime DEFAULT NULL,
  `ModifyUserID` smallint(5) UNSIGNED DEFAULT NULL,
  `DeleteDate` datetime DEFAULT NULL,
  `DeleteUserID` smallint(5) UNSIGNED DEFAULT NULL,
  `LastViews` int(11) NOT NULL DEFAULT 0,
  `LastViewsNew` int(11) NOT NULL DEFAULT 0,
  `LastConversion` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `LastProfit` double NOT NULL DEFAULT 0,
  `LastProfitNew` double NOT NULL DEFAULT 0,
  `LastROI` double NOT NULL DEFAULT 0,
  `LastReportUpdate` datetime DEFAULT NULL,
  `RealTimeCPV` double NOT NULL DEFAULT 0,
  `CostTypeID` tinyint(4) NOT NULL DEFAULT 1,
  `DestinationType` tinyint(4) NOT NULL DEFAULT 1,
  `TrackingType` tinyint(4) NOT NULL DEFAULT 2,
  `FunnelSetup` tinyint(4) NOT NULL DEFAULT 0,
  `AssignedTo` int(11) NOT NULL DEFAULT 0,
  `PassTarget` tinyint(1) NOT NULL DEFAULT 0,
  `PassTargetParam` varchar(45) NOT NULL DEFAULT 'target',
  `PassTargetOffer` tinyint(1) NOT NULL DEFAULT 0,
  `PassTargetOfferParam` varchar(45) NOT NULL DEFAULT 'target',
  `PassSubIdLP` tinyint(1) NOT NULL DEFAULT 0,
  `PassSubId` tinyint(1) NOT NULL DEFAULT 0,
  `PassCookie` tinyint(1) NOT NULL DEFAULT 0,
  `PassCookieParam` varchar(45) NOT NULL DEFAULT 'cookie',
  `RedirectType` tinyint(3) UNSIGNED NOT NULL DEFAULT 2,
  `KeyCode` varchar(45) NOT NULL DEFAULT '',
  `FailurePage` text DEFAULT NULL,
  `GroupID` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `Inactive` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `HideBlankPages` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `TrackingDomain` varchar(191) NOT NULL DEFAULT '',
  `SplitShare` tinyint(4) NOT NULL DEFAULT 50,
  `ShareLanding` tinyint(4) NOT NULL DEFAULT 0,
  `ShareOffer` tinyint(4) NOT NULL DEFAULT 0,
  `Priority` smallint(5) UNSIGNED NOT NULL DEFAULT 1,
  `OptimizationProfileID` smallint(5) UNSIGNED NOT NULL DEFAULT 1,
  `AlertProfileID` smallint(5) UNSIGNED NOT NULL DEFAULT 1,
  `CaptureReferrer` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `CaptureMobileDetails` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `CaptureNonMobileDetails` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `CaptureResolutionDetails` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `CaptureLanguageHeader` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `CaptureISP` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `CaptureGeo` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `CaptureUserAgent` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `CaptureIP` tinyint(1) UNSIGNED NOT NULL DEFAULT 1,
  `ExtraTokens` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `Notes` text DEFAULT NULL,
  `LpProtectType` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `LpProtectKey` varchar(100) DEFAULT NULL,
  `LpProtectParameter` varchar(30) DEFAULT 'sig',
  `LpProtectMessage` text DEFAULT NULL,
  `LpProtectRedirect` text DEFAULT NULL,
  `LastEditOption` tinyint(3) UNSIGNED DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `campaignscustomviews`
--

CREATE TABLE `campaignscustomviews` (
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `UserID` smallint(5) UNSIGNED NOT NULL,
  `CustomViewID` smallint(5) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `campaignscustomviews`
--

INSERT INTO `campaignscustomviews` (`CampaignID`, `UserID`, `CustomViewID`) VALUES
(1, 1, 1),
(2, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `campaignstokens`
--

CREATE TABLE `campaignstokens` (
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `KeywordTokenParam` varchar(30) DEFAULT NULL,
  `KeywordTokenPlace` varchar(90) DEFAULT NULL,
  `CostTokenParam` varchar(30) DEFAULT NULL,
  `CostTokenPlace` varchar(90) DEFAULT NULL,
  `UniqueTokenParam` varchar(30) DEFAULT NULL,
  `UniqueTokenPlace` varchar(90) DEFAULT NULL,
  `UniqueTokenPass` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName1` varchar(40) DEFAULT NULL,
  `ExtraTokenParam1` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace1` varchar(90) DEFAULT NULL,
  `ExtraTokenPass1` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName2` varchar(40) DEFAULT NULL,
  `ExtraTokenParam2` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace2` varchar(90) DEFAULT NULL,
  `ExtraTokenPass2` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName3` varchar(40) DEFAULT NULL,
  `ExtraTokenParam3` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace3` varchar(90) DEFAULT NULL,
  `ExtraTokenPass3` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName4` varchar(40) DEFAULT NULL,
  `ExtraTokenParam4` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace4` varchar(90) DEFAULT NULL,
  `ExtraTokenPass4` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName5` varchar(40) DEFAULT NULL,
  `ExtraTokenParam5` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace5` varchar(90) DEFAULT NULL,
  `ExtraTokenPass5` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName6` varchar(40) DEFAULT NULL,
  `ExtraTokenParam6` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace6` varchar(90) DEFAULT NULL,
  `ExtraTokenPass6` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName7` varchar(40) DEFAULT NULL,
  `ExtraTokenParam7` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace7` varchar(90) DEFAULT NULL,
  `ExtraTokenPass7` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName8` varchar(40) DEFAULT NULL,
  `ExtraTokenParam8` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace8` varchar(90) DEFAULT NULL,
  `ExtraTokenPass8` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName9` varchar(40) DEFAULT NULL,
  `ExtraTokenParam9` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace9` varchar(90) DEFAULT NULL,
  `ExtraTokenPass9` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName10` varchar(40) DEFAULT NULL,
  `ExtraTokenParam10` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace10` varchar(90) DEFAULT NULL,
  `ExtraTokenPass10` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName11` varchar(40) DEFAULT NULL,
  `ExtraTokenParam11` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace11` varchar(90) DEFAULT NULL,
  `ExtraTokenPass11` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName12` varchar(40) DEFAULT NULL,
  `ExtraTokenParam12` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace12` varchar(90) DEFAULT NULL,
  `ExtraTokenPass12` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName13` varchar(40) DEFAULT NULL,
  `ExtraTokenParam13` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace13` varchar(90) DEFAULT NULL,
  `ExtraTokenPass13` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName14` varchar(40) DEFAULT NULL,
  `ExtraTokenParam14` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace14` varchar(90) DEFAULT NULL,
  `ExtraTokenPass14` tinyint(4) NOT NULL DEFAULT 0,
  `ExtraTokenName15` varchar(40) DEFAULT NULL,
  `ExtraTokenParam15` varchar(30) DEFAULT NULL,
  `ExtraTokenPlace15` varchar(90) DEFAULT NULL,
  `ExtraTokenPass15` tinyint(4) NOT NULL DEFAULT 0,
  `AdTokenName` varchar(40) DEFAULT NULL,
  `AdTokenParam` varchar(30) DEFAULT NULL,
  `AdTokenPlace` varchar(90) DEFAULT NULL,
  `AdTokenPass` tinyint(4) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `campaigntypes`
--

CREATE TABLE `campaigntypes` (
  `CampaignTypeID` tinyint(3) UNSIGNED NOT NULL,
  `CampaignType` varchar(100) NOT NULL,
  `CampaignTypeShort` varchar(100) DEFAULT NULL,
  `CampaignTypeAbbr` varchar(100) DEFAULT NULL,
  `OrderIndex` tinyint(3) UNSIGNED NOT NULL,
  `PageName` varchar(100) DEFAULT NULL,
  `SubTitleImage` varchar(100) DEFAULT NULL,
  `AnchorText` varchar(100) DEFAULT NULL,
  `MenuText` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `campaigntypes`
--

INSERT INTO `campaigntypes` (`CampaignTypeID`, `CampaignType`, `CampaignTypeShort`, `CampaignTypeAbbr`, `OrderIndex`, `PageName`, `SubTitleImage`, `AnchorText`, `MenuText`) VALUES
(4, 'Lead Capture / Opt-In Campaign', 'Lead Capture', 'LC', 5, 'lead-capture-campaign.php', 'lead_cap_sub_title.png', 'LeadCapture', 'Lead Capture'),
(5, 'Multiple Path Campaign', 'Multiple Path', 'MP', 3, 'multiple-path-campaign.php', 'multiple path sub title original.png', 'MultiplePaths', 'Multiple Paths'),
(6, 'Landing Page Sequence Campaign', 'Landing Page Sequence', 'LPS', 4, 'landing-page-sequence-campaign.php', 'landing_page_sequence_campaign_title.png', 'LPSequence', 'Landing Page Sequence'),
(7, 'Multiple Option Campaign', 'Multiple Option', 'MO', 2, 'multiple-cta-campaign.php', 'multiple_cta_campaign_title.png', 'MultipleCta', 'Multiple Options'),
(8, 'Direct Link & Landing Page Campaign', 'Direct Link & Landing Page', 'DLLP', 1, 'direct-and-landing-campaign.php', 'directlink_vs_lp_sub_title.png', 'DirectAndLanding', 'Direct Link & Landing Page'),
(9, 'Email Follow-Up Campaign', 'Email Follow-up', 'Email', 6, 'email-follow-up-campaign.php', 'email_followup_sub_title.png', 'EmailFollowUp', 'Email Follow-Up');

-- --------------------------------------------------------

--
-- Table structure for table `clicks`
--

CREATE TABLE `clicks` (
  `ClickID` bigint(20) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `SubIdID` int(10) UNSIGNED NOT NULL,
  `DestinationID` mediumint(8) UNSIGNED NOT NULL,
  `OfferID` mediumint(8) UNSIGNED DEFAULT NULL,
  `ViewDate` datetime NOT NULL,
  `EngageDate` datetime DEFAULT NULL,
  `ClickDate` datetime DEFAULT NULL,
  `ConversionDate` datetime DEFAULT NULL,
  `SubscribeDate` datetime DEFAULT NULL,
  `ConversionDateReport` datetime DEFAULT NULL,
  `IPBinary` varbinary(16) DEFAULT NULL,
  `Cost` double DEFAULT NULL,
  `Revenue` double DEFAULT NULL,
  `IsDup` tinyint(4) NOT NULL DEFAULT 0,
  `ReferrerID` int(10) UNSIGNED NOT NULL DEFAULT 1,
  `SiteCategoryID` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `DeviceID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `IspID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `DirectTraffic` tinyint(4) NOT NULL DEFAULT 0,
  `MobileDevice` tinyint(4) NOT NULL DEFAULT 0,
  `BrowserLanguageCode` char(2) CHARACTER SET ascii DEFAULT NULL,
  `CityID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `UserAgentID` int(10) UNSIGNED NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `clicksextra`
--

CREATE TABLE `clicksextra` (
  `ClickID` bigint(20) UNSIGNED NOT NULL,
  `Extra1` varchar(191) DEFAULT NULL,
  `Extra2` varchar(191) DEFAULT NULL,
  `Extra3` varchar(191) DEFAULT NULL,
  `Extra4` varchar(191) DEFAULT NULL,
  `Extra5` varchar(191) DEFAULT NULL,
  `Extra6` varchar(191) DEFAULT NULL,
  `Extra7` varchar(191) DEFAULT NULL,
  `Extra8` varchar(191) DEFAULT NULL,
  `Extra9` varchar(191) DEFAULT NULL,
  `Extra10` varchar(191) DEFAULT NULL,
  `Extra11` varchar(191) DEFAULT NULL,
  `Extra12` varchar(191) DEFAULT NULL,
  `Extra13` varchar(191) DEFAULT NULL,
  `Extra14` varchar(191) DEFAULT NULL,
  `Extra15` varchar(191) DEFAULT NULL,
  `AdValue` varchar(191) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `clicksips`
--

CREATE TABLE `clicksips` (
  `IPBinary` varbinary(16) NOT NULL,
  `ClickDetails` varchar(50) NOT NULL DEFAULT '',
  `ClickLevel` tinyint(4) NOT NULL DEFAULT 1,
  `AssociatedClicks` varchar(191) NOT NULL DEFAULT '',
  `DateAdded` date NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `clickslp`
--

CREATE TABLE `clickslp` (
  `ClickID` bigint(20) UNSIGNED NOT NULL,
  `Level` tinyint(4) NOT NULL,
  `DestinationID` mediumint(8) UNSIGNED DEFAULT NULL,
  `ClickDate` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `clickstscode`
--

CREATE TABLE `clickstscode` (
  `ClickID` bigint(20) UNSIGNED NOT NULL,
  `UniqueCode` varchar(500) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `columncategories`
--

CREATE TABLE `columncategories` (
  `ColumnCategoryID` tinyint(3) UNSIGNED NOT NULL,
  `ColumnCategory` varchar(100) DEFAULT NULL,
  `ColumnCategoryIndex` tinyint(3) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `columncategories`
--

INSERT INTO `columncategories` (`ColumnCategoryID`, `ColumnCategory`, `ColumnCategoryIndex`) VALUES
(1, 'Campaign Data', 10),
(2, 'Clicks & Conversions', 20),
(3, 'Custom Tokens', 30),
(4, 'Revenue Data', 40),
(5, 'Referrers', 50),
(6, 'Time & Day', 60),
(7, 'Mobile Browser', 70),
(8, 'Content Support', 80),
(9, 'Device Info', 90),
(10, 'Device Usage', 100),
(11, 'Visitor Data', 25);

-- --------------------------------------------------------

--
-- Table structure for table `columns`
--

CREATE TABLE `columns` (
  `ColumnID` tinyint(3) UNSIGNED NOT NULL,
  `ColumnName` varchar(100) NOT NULL,
  `ColumnSort` varchar(100) NOT NULL,
  `ClassName` varchar(100) NOT NULL DEFAULT '',
  `ColumnColor` varchar(10) NOT NULL DEFAULT '034CB5',
  `DecimalPlaces` tinyint(4) NOT NULL DEFAULT -1,
  `IsPercent` tinyint(1) NOT NULL DEFAULT 0,
  `IsDollar` tinyint(1) NOT NULL DEFAULT 0,
  `IsDateTime` tinyint(1) NOT NULL DEFAULT 0,
  `IsSortable` tinyint(1) NOT NULL DEFAULT 1,
  `IsDatabaseSortable` tinyint(1) NOT NULL DEFAULT 0,
  `IsFixed` tinyint(1) NOT NULL DEFAULT 0,
  `IsTotal` tinyint(1) NOT NULL DEFAULT 0,
  `IsLongColumn` tinyint(1) NOT NULL DEFAULT 0,
  `IsMobile` tinyint(1) NOT NULL DEFAULT 0,
  `IsColorColumn` tinyint(1) NOT NULL DEFAULT 0,
  `YesValue` varchar(50) NOT NULL DEFAULT '',
  `ColumnCategoryID` tinyint(3) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `columns`
--

INSERT INTO `columns` (`ColumnID`, `ColumnName`, `ColumnSort`, `ClassName`, `ColumnColor`, `DecimalPlaces`, `IsPercent`, `IsDollar`, `IsDateTime`, `IsSortable`, `IsDatabaseSortable`, `IsFixed`, `IsTotal`, `IsLongColumn`, `IsMobile`, `IsColorColumn`, `YesValue`, `ColumnCategoryID`) VALUES
(1, 'CampaignID', 'CampaignID', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 1),
(2, 'Offer', 'Offer', 'tc-l cmlnd', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 1),
(3, 'Url', 'Url', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 1),
(4, 'Keyword', 'Keyword', 'tc-l cmkey', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 1),
(5, 'Views', 'Views', 'tc-r', '034CB5', 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, '', 2),
(6, 'Cost', 'Cost', 'tc-r', '034CB5', 3, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, '', 4),
(7, 'CPV', 'CPV', 'tc-r', '034CB5', 3, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, '', 4),
(8, 'Clicks', 'Clicks', 'tc-r', '034CB5', 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, '', 2),
(9, 'CTR', 'CTR', 'tc-r', '034CB5', 2, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, '', 2),
(10, 'CPC', 'CPC', 'tc-r', '034CB5', 3, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, '', 2),
(11, 'Conversion', 'Conversion', 'tc-r', '034CB5', 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, '', 2),
(12, 'CR', 'CR', 'tc-r', '034CB5', 2, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, '', 2),
(13, 'Revenue', 'Revenue', 'tc-r', '034CB5', 2, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, '', 4),
(14, 'EPV', 'EPV', 'tc-r', '034CB5', 3, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, '', 4),
(15, 'PPV', 'PPV', 'tc-r', '034CB5', 3, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, '', 4),
(16, 'eCPM', 'eCPM', 'tc-r', '034CB5', 2, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, '', 4),
(17, 'Profit', 'Profit', 'tc-r', '034CB5', 2, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, '', 4),
(18, 'ROI', 'ROI', 'tc-r', '034CB5', 2, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, '', 4),
(19, 'EngageRate', 'EngageRate', 'tc-r', '034CB5', 2, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, '', 2),
(20, 'TheIntervalName', 'TheIntervalName', 'tc-l tc-b', '034CB5', -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '', NULL),
(21, 'Offer2', 'Offer2', 'tc-l cmofr', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 1),
(22, 'Url2', 'Url2', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 1),
(23, 'CostRevenueProfit', 'CostRevenueProfit', 'tc-l', '034CB5', 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, '', NULL),
(24, 'Sent', 'Sent', 'tc-r', '034CB5', -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, '', 2),
(25, 'EPS', 'EPS', 'tc-r', '034CB5', 2, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, '', 4),
(26, 'Embed', 'Embed', 'tc-r', '034CB5', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, '', 2),
(27, 'EmbedPercent', 'EmbedPercent', 'tc-r', '034CB5', 2, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, '', 2),
(28, 'Popup', 'Popup', 'tc-r', '034CB5', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, '', 2),
(29, 'PopupPercent', 'PopupPercent', 'tc-r', '034CB5', 2, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, '', 2),
(30, 'Exit', 'Exit', 'tc-r', '034CB5', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, '', 2),
(31, 'ExitPercent', 'ExitPercent', 'tc-r', '034CB5', 2, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, '', 2),
(32, 'DestinationID', 'DestinationID', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, '', NULL),
(33, 'Email', 'Email', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 1),
(34, 'Subscribers', 'Subscribers', 'tc-r', '034CB5', 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, '', 2),
(35, 'SR', 'SR', 'tc-r', '034CB5', 2, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, '', 2),
(36, 'CPSUB', 'CPSUB', 'tc-r', '034CB5', 3, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, '', 2),
(37, 'Extra1', 'Extra1', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(38, 'Extra2', 'Extra2', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(39, 'Extra3', 'Extra3', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(40, 'Extra4', 'Extra4', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(41, 'Extra5', 'Extra5', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(42, 'Extra6', 'Extra6', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(43, 'Extra7', 'Extra7', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(44, 'Extra8', 'Extra8', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(45, 'Extra9', 'Extra9', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(46, 'Extra10', 'Extra10', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(47, 'CPA', 'CPA', 'tc-r', '034CB5', 3, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, '', 2),
(48, 'ViewDate', 'ViewDate', 'tc-l cmdat', '034CB5', -1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, '', 2),
(49, 'Source', 'Source', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 1),
(50, 'CampaignName', 'CampaignName', 'tc-l cmcmp', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 1),
(51, 'IP', 'IPBinary', 'tc-l cmipa', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 11),
(52, 'ClickDate', 'ClickDate', 'tc-l', '034CB5', -1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, '', 2),
(53, 'ClickStatus', 'ClickStatus', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 2),
(54, 'Referrer', 'Referrer', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 5),
(55, 'ReferrerDomain', 'ReferrerDomain', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 5),
(56, 'ConversionDate', 'ConversionDate', 'tc-l cmdat', '034CB5', -1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, '', 2),
(57, 'ConversionStatus', 'ConversionStatus', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 2),
(58, 'SubId', 'SubId', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 11),
(59, 'CountryName', 'CountryName', 'tc-l cmcnt', '034CB5', -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, '', 11),
(60, 'RegionName', 'RegionName', 'tc-l cmreg', '034CB5', -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, '', 11),
(61, 'CityName', 'CityName', 'tc-l cmcty', '034CB5', -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, '', 11),
(62, 'LandingPageID', 'LandingPageID', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, '', 1),
(63, 'SiteCategory', 'SiteCategory', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, '', 5),
(64, 'AdValue', 'AdValue', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 1),
(65, 'Inactive', 'Inactive', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, '', 1),
(66, 'CampaignGroup', 'CampaignGroup', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, '', 1),
(67, 'CostTypeID', 'CostTypeID', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, '', 1),
(68, 'CreateDate', 'CreateDate', 'tc-l', '034CB5', -1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, '', 1),
(69, 'LastReportUpdate', 'LastReportUpdate', 'tc-l', '034CB5', -1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, '', 1),
(70, 'ViewDay', 'ViewDay', 'tc-r', '034CB5', 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, '', 6),
(71, 'ViewHour', 'ViewHour', 'tc-r', '034CB5', 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 6),
(72, 'DeviceType', 'DeviceType', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, '', 9),
(73, 'BrandName', 'BrandName', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, '', 9),
(74, 'DeviceName', 'DeviceName', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, '', 9),
(75, 'DeviceModel', 'DeviceModel', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, '', 9),
(76, 'MarketingName', 'MarketingName', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, '', 9),
(77, 'OperatingSystem', 'OperatingSystem', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, '', 9),
(78, 'BrowserName', 'BrowserName', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, '', 7),
(79, 'DataRateText', 'DataRateText', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, '', 9),
(80, 'DisplaySize', 'DisplaySize', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, '', 9),
(81, 'Resolution', 'Resolution', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, '', 9),
(82, 'IspName', 'IspName', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 9),
(83, 'PointingMethod', 'PointingMethod', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, '', 10),
(84, 'SmsSupport', 'SmsSupport', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-message.png', 8),
(85, 'MmsSupport', 'MmsSupport', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-message.png', 8),
(86, 'PdfSupport', 'PdfSupport', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-pdf.png', 8),
(87, 'RssSupport', 'RssSupport', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-rss.png', 8),
(88, 'PushSupport', 'PushSupport', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-message.png', 8),
(89, 'FlashSupport', 'FlashSupport', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-flash.png', 8),
(90, 'ClickToCall', 'ClickToCall', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-clickcall.png', 8),
(91, 'DualOrientation', 'DualOrientation', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-dualscreen.png', 10),
(92, 'QwertyKeyword', 'QwertyKeyword', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-qwerty.png', 10),
(93, 'NumberSupport', 'NumberSupport', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-phonenum.png', 10),
(94, 'WifiSupport', 'WifiSupport', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-wifi.png', 9),
(95, 'IframeSupport', 'IframeSupport', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-iframe.png', 7),
(96, 'CookieSupport', 'CookieSupport', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-cookie.png', 7),
(97, 'PartyCookieSupport', 'PartyCookieSupport', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-cookie.png', 7),
(98, 'EmbeddedVideo', 'EmbeddedVideo', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-playback.png', 7),
(99, 'JavaScriptSupport', 'JavaScriptSupport', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-java.png', 7),
(103, 'PlaybackMp4', 'PlaybackMp4', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-playback.png', 8),
(104, 'PlaybackMov', 'PlaybackMov', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-playback.png', 8),
(105, 'PlaybackFlv', 'PlaybackFlv', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 'mark-playback.png', 8),
(106, 'ConversionDuration', 'ConversionDuration', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 6),
(107, 'OperatingSystemVersion', 'OperatingSystemVersion', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, '', 9),
(108, 'BrowserVersion', 'BrowserVersion', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, '', 7),
(109, 'ContinentName', 'ContinentName', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, '', 11),
(110, 'UserAgent', 'UserAgent', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 11),
(111, 'DeepClicks', 'DeepClicks', 'tc-r', '034CB5', 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, '', 2),
(112, 'UniqueCode', 'UniqueCode', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(113, 'Status', 'Status', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 2),
(114, 'TransactionID', 'TransactionID', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 2),
(115, 'Custom1', 'Custom1', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(116, 'Custom2', 'Custom2', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(117, 'Custom3', 'Custom3', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(118, 'Custom4', 'Custom4', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(119, 'Custom5', 'Custom5', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(120, 'SubscribeDate', 'SubscribeDate', 'tc-l cmdat', '034CB5', -1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, '', 2),
(121, 'SubscribeStatus', 'SubscribeStatus', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 2),
(122, 'SubscribeDuration', 'SubscribeDuration', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 6),
(123, 'Extra11', 'Extra11', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(124, 'Extra12', 'Extra12', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(125, 'Extra13', 'Extra13', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(126, 'Extra14', 'Extra14', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(127, 'Extra15', 'Extra15', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, '', 3),
(128, 'EngageDate', 'EngageDate', 'tc-l', '034CB5', -1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, '', 2),
(129, 'EngageStatus', 'EngageStatus', 'tc-c', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 2),
(130, 'AOV', 'AOV', 'tc-r', '034CB5', 2, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, '', 4),
(131, 'BrowserLanguage', 'BrowserLanguage', 'tc-l', '034CB5', -1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, '', 9);

-- --------------------------------------------------------

--
-- Table structure for table `columnscharts`
--

CREATE TABLE `columnscharts` (
  `ColumnID` tinyint(3) UNSIGNED NOT NULL,
  `CampaignTypeID` tinyint(3) UNSIGNED NOT NULL,
  `ReportTypeID` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `ColumnCaption` varchar(100) NOT NULL,
  `ColumnCaption2` varchar(100) NOT NULL,
  `ColumnIndex` smallint(5) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `columnscharts`
--

INSERT INTO `columnscharts` (`ColumnID`, `CampaignTypeID`, `ReportTypeID`, `ColumnCaption`, `ColumnCaption2`, `ColumnIndex`) VALUES
(5, 4, 4, 'Views', 'Visitors', 100),
(5, 4, 5, 'Views', 'Visitors', 100),
(5, 4, 7, 'Views', 'Visitors', 100),
(5, 4, 8, 'Views', 'Visitors', 100),
(5, 4, 13, 'Views', 'Visitors', 100),
(5, 4, 16, 'Views', 'Ad Clicks', 100),
(5, 4, 22, 'Views', 'Visitors', 100),
(5, 5, 4, 'Views', 'Visitors', 100),
(5, 5, 5, 'Views', 'Visitors', 100),
(5, 5, 7, 'Views', 'Visitors', 100),
(5, 5, 8, 'Views', 'Visitors', 100),
(5, 5, 13, 'Views', 'Visitors', 100),
(5, 5, 16, 'Views', 'Ad Clicks', 100),
(5, 5, 22, 'Views', 'Visitors', 100),
(5, 6, 4, 'Views', 'Visitors', 100),
(5, 6, 5, 'Views', 'Visitors', 100),
(5, 6, 7, 'Views', 'Visitors', 100),
(5, 6, 8, 'Views', 'Visitors', 100),
(5, 6, 13, 'Views', 'Visitors', 100),
(5, 6, 16, 'Views', 'Ad Clicks', 100),
(5, 6, 22, 'Views', 'Visitors', 100),
(5, 7, 4, 'Views', 'Visitors', 100),
(5, 7, 5, 'Views', 'Visitors', 100),
(5, 7, 7, 'Views', 'Visitors', 100),
(5, 7, 8, 'Views', 'Visitors', 100),
(5, 7, 13, 'Views', 'Visitors', 100),
(5, 7, 16, 'Views', 'Ad Clicks', 100),
(5, 7, 22, 'Views', 'Visitors', 100),
(5, 8, 4, 'Views', 'Visitors', 100),
(5, 8, 5, 'Views', 'Visitors', 100),
(5, 8, 7, 'Views', 'Visitors', 100),
(5, 8, 8, 'Views', 'Visitors', 100),
(5, 8, 13, 'Views', 'Visitors', 100),
(5, 8, 16, 'Views', 'Ad Clicks', 100),
(5, 8, 22, 'Views', 'Visitors', 100),
(5, 9, 5, 'Views', 'Views', 100),
(5, 9, 7, 'Views', 'Views', 100),
(5, 9, 8, 'Views', 'Views', 100),
(5, 9, 13, 'Views', 'Views', 100),
(5, 9, 22, 'Views', 'Views', 100),
(8, 4, 4, 'Clicks', 'LP Clicks', 300),
(8, 4, 5, 'Clicks', 'LP Clicks', 300),
(8, 4, 6, 'Visitors', 'Visitors', 200),
(8, 4, 16, 'Clicks', 'LP Clicks', 300),
(8, 5, 4, 'Clicks', 'LP Clicks', 300),
(8, 5, 5, 'Clicks', 'LP Clicks', 300),
(8, 5, 6, 'Visitors', 'Visitors', 200),
(8, 5, 7, 'Clicks', 'LP Clicks', 200),
(8, 5, 8, 'Clicks', 'LP Clicks', 200),
(8, 5, 13, 'Clicks', 'LP Clicks', 200),
(8, 5, 16, 'Clicks', 'LP Clicks', 300),
(8, 6, 4, 'Clicks', 'LP Clicks', 300),
(8, 6, 5, 'Clicks', 'LP Clicks', 300),
(8, 6, 6, 'Visitors', 'Visitors', 200),
(8, 6, 7, 'Clicks', 'LP Clicks', 200),
(8, 6, 8, 'Clicks', 'LP Clicks', 200),
(8, 6, 13, 'Clicks', 'LP Clicks', 200),
(8, 6, 16, 'Clicks', 'LP Clicks', 300),
(8, 7, 4, 'Clicks', 'LP Clicks', 300),
(8, 7, 5, 'Clicks', 'LP Clicks', 300),
(8, 7, 6, 'Visitors', 'Visitors', 200),
(8, 7, 7, 'Clicks', 'LP Clicks', 200),
(8, 7, 8, 'Clicks', 'LP Clicks', 200),
(8, 7, 13, 'Clicks', 'LP Clicks', 200),
(8, 7, 16, 'Clicks', 'LP Clicks', 300),
(8, 8, 4, 'Clicks', 'LP Clicks', 300),
(8, 8, 5, 'Clicks', 'LP Clicks', 300),
(8, 8, 6, 'Visitors', 'Visitors', 200),
(8, 8, 7, 'Clicks', 'LP Clicks', 200),
(8, 8, 8, 'Clicks', 'LP Clicks', 200),
(8, 8, 13, 'Clicks', 'LP Clicks', 200),
(8, 8, 16, 'Clicks', 'LP Clicks', 300),
(8, 9, 4, 'Clicks', 'Clicks', 100),
(8, 9, 5, 'Clicks', 'Clicks', 300),
(8, 9, 6, 'Visitors', 'Visitors', 100),
(8, 9, 7, 'Clicks', 'Clicks', 200),
(8, 9, 8, 'Clicks', 'Clicks', 200),
(8, 9, 13, 'Clicks', 'Clicks', 200),
(9, 4, 4, 'CTR%', 'LP CTR%', 400),
(9, 4, 5, 'CTR%', 'LP CTR%', 400),
(9, 4, 16, 'CTR%', 'LP CTR%', 400),
(9, 4, 22, 'CTR%', 'LP CTR%', 400),
(9, 4, 23, 'CTR%', 'LP CTR%', 400),
(9, 5, 4, 'CTR%', 'LP CTR%', 400),
(9, 5, 5, 'CTR%', 'LP CTR%', 400),
(9, 5, 7, 'CTR%', 'LP CTR%', 300),
(9, 5, 8, 'CTR%', 'LP CTR%', 300),
(9, 5, 13, 'CTR%', 'LP CTR%', 300),
(9, 5, 16, 'CTR%', 'LP CTR%', 400),
(9, 5, 22, 'CTR%', 'LP CTR%', 400),
(9, 5, 23, 'CTR%', 'LP CTR%', 400),
(9, 6, 4, 'CTR%', 'LP CTR%', 400),
(9, 6, 5, 'CTR%', 'LP CTR%', 400),
(9, 6, 7, 'CTR%', 'LP CTR%', 300),
(9, 6, 8, 'CTR%', 'LP CTR%', 300),
(9, 6, 13, 'CTR%', 'LP CTR%', 300),
(9, 6, 16, 'CTR%', 'LP CTR%', 400),
(9, 6, 22, 'CTR%', 'LP CTR%', 400),
(9, 6, 23, 'CTR%', 'LP CTR%', 400),
(9, 7, 4, 'CTR%', 'LP CTR%', 400),
(9, 7, 5, 'CTR%', 'LP CTR%', 400),
(9, 7, 7, 'CTR%', 'LP CTR%', 300),
(9, 7, 8, 'CTR%', 'LP CTR%', 300),
(9, 7, 13, 'CTR%', 'LP CTR%', 300),
(9, 7, 16, 'CTR%', 'LP CTR%', 400),
(9, 7, 22, 'CTR%', 'LP CTR%', 400),
(9, 7, 23, 'CTR%', 'LP CTR%', 400),
(9, 8, 4, 'CTR%', 'LP CTR%', 400),
(9, 8, 5, 'CTR%', 'LP CTR%', 400),
(9, 8, 7, 'CTR%', 'LP CTR%', 300),
(9, 8, 8, 'CTR%', 'LP CTR%', 300),
(9, 8, 13, 'CTR%', 'LP CTR%', 300),
(9, 8, 16, 'CTR%', 'LP CTR%', 400),
(9, 8, 22, 'CTR%', 'LP CTR%', 400),
(9, 8, 23, 'CTR%', 'LP CTR%', 400),
(9, 9, 4, 'CTR%', 'CTR%', 200),
(9, 9, 5, 'CTR%', 'CTR%', 400),
(9, 9, 7, 'CTR%', 'CTR%', 300),
(9, 9, 8, 'CTR%', 'CTR%', 300),
(9, 9, 13, 'CTR%', 'CTR%', 300),
(9, 9, 22, 'CTR%', 'CTR%', 400),
(9, 9, 23, 'CTR%', 'CTR%', 400),
(10, 4, 4, 'CPC', 'LP CPC', 500),
(10, 4, 5, 'CPC', 'LP CPC', 500),
(10, 4, 6, 'CPC', 'CPC', 300),
(10, 4, 16, 'CPC', 'LP CPC', 500),
(10, 5, 4, 'CPC', 'LP CPC', 500),
(10, 5, 5, 'CPC', 'LP CPC', 500),
(10, 5, 6, 'CPC', 'CPC', 300),
(10, 5, 16, 'CPC', 'LP CPC', 500),
(10, 6, 4, 'CPC', 'LP CPC', 500),
(10, 6, 5, 'CPC', 'LP CPC', 500),
(10, 6, 6, 'CPC', 'CPC', 300),
(10, 6, 16, 'CPC', 'LP CPC', 500),
(10, 7, 4, 'CPC', 'LP CPC', 500),
(10, 7, 5, 'CPC', 'LP CPC', 500),
(10, 7, 6, 'CPC', 'CPC', 300),
(10, 7, 16, 'CPC', 'LP CPC', 500),
(10, 8, 4, 'CPC', 'LP CPC', 500),
(10, 8, 5, 'CPC', 'LP CPC', 500),
(10, 8, 6, 'CPC', 'CPC', 300),
(10, 8, 16, 'CPC', 'LP CPC', 500),
(11, 4, 4, 'Conversions', 'Conversions', 900),
(11, 4, 5, 'Conversions', 'Conversions', 900),
(11, 4, 6, 'Conversions', 'Conversions', 400),
(11, 4, 7, 'Conversions', 'Conversions', 500),
(11, 4, 8, 'Conversions', 'Conversions', 500),
(11, 4, 13, 'Conversions', 'Conversions', 500),
(11, 4, 16, 'Conversions', 'Conversions', 900),
(11, 5, 4, 'Conversions', 'Conversions', 600),
(11, 5, 5, 'Conversions', 'Conversions', 600),
(11, 5, 6, 'Conversions', 'Conversions', 400),
(11, 5, 7, 'Conversions', 'Conversions', 400),
(11, 5, 8, 'Conversions', 'Conversions', 400),
(11, 5, 13, 'Conversions', 'Conversions', 400),
(11, 5, 16, 'Conversions', 'Conversions', 600),
(11, 6, 4, 'Conversions', 'Conversions', 900),
(11, 6, 5, 'Conversions', 'Conversions', 900),
(11, 6, 6, 'Conversions', 'Conversions', 400),
(11, 6, 7, 'Conversions', 'Conversions', 700),
(11, 6, 8, 'Conversions', 'Conversions', 700),
(11, 6, 13, 'Conversions', 'Conversions', 700),
(11, 6, 16, 'Conversions', 'Conversions', 900),
(11, 7, 4, 'Conversions', 'Conversions', 600),
(11, 7, 5, 'Conversions', 'Conversions', 600),
(11, 7, 6, 'Conversions', 'Conversions', 400),
(11, 7, 7, 'Conversions', 'Conversions', 400),
(11, 7, 8, 'Conversions', 'Conversions', 400),
(11, 7, 13, 'Conversions', 'Conversions', 400),
(11, 7, 16, 'Conversions', 'Conversions', 600),
(11, 8, 4, 'Conversions', 'Conversions', 600),
(11, 8, 5, 'Conversions', 'Conversions', 600),
(11, 8, 6, 'Conversions', 'Conversions', 400),
(11, 8, 7, 'Conversions', 'Conversions', 400),
(11, 8, 8, 'Conversions', 'Conversions', 400),
(11, 8, 13, 'Conversions', 'Conversions', 400),
(11, 8, 16, 'Conversions', 'Conversions', 600),
(11, 9, 4, 'Conversions', 'Conversions', 300),
(11, 9, 6, 'Conversions', 'Conversions', 200),
(11, 9, 7, 'Conversions', 'Conversions', 400),
(11, 9, 8, 'Conversions', 'Conversions', 400),
(11, 9, 13, 'Conversions', 'Conversions', 400),
(12, 4, 4, 'CR%', 'CR%', 1000),
(12, 4, 5, 'CR%', 'CR%', 1000),
(12, 4, 6, 'CR%', 'CR%', 600),
(12, 4, 16, 'CR%', 'CR%', 1000),
(12, 4, 22, 'CR%', 'CR%', 700),
(12, 4, 23, 'CR%', 'CR%', 700),
(12, 5, 4, 'CR%', 'CR%', 700),
(12, 5, 5, 'CR%', 'CR%', 700),
(12, 5, 6, 'CR%', 'CR%', 600),
(12, 5, 7, 'CR%', 'CR%', 500),
(12, 5, 8, 'CR%', 'CR%', 500),
(12, 5, 13, 'CR%', 'CR%', 500),
(12, 5, 16, 'CR%', 'CR%', 700),
(12, 5, 22, 'CR%', 'CR%', 700),
(12, 5, 23, 'CR%', 'CR%', 700),
(12, 6, 4, 'CR%', 'CR%', 1000),
(12, 6, 5, 'CR%', 'CR%', 1000),
(12, 6, 6, 'CR%', 'CR%', 600),
(12, 6, 7, 'CR%', 'CR%', 800),
(12, 6, 8, 'CR%', 'CR%', 800),
(12, 6, 13, 'CR%', 'CR%', 800),
(12, 6, 16, 'CR%', 'CR%', 1000),
(12, 6, 22, 'CR%', 'CR%', 700),
(12, 6, 23, 'CR%', 'CR%', 700),
(12, 7, 4, 'CR%', 'CR%', 700),
(12, 7, 5, 'CR%', 'CR%', 700),
(12, 7, 6, 'CR%', 'CR%', 600),
(12, 7, 7, 'CR%', 'CR%', 500),
(12, 7, 8, 'CR%', 'CR%', 500),
(12, 7, 13, 'CR%', 'CR%', 500),
(12, 7, 16, 'CR%', 'CR%', 700),
(12, 7, 22, 'CR%', 'CR%', 700),
(12, 7, 23, 'CR%', 'CR%', 700),
(12, 8, 4, 'CR%', 'CR%', 700),
(12, 8, 5, 'CR%', 'CR%', 700),
(12, 8, 6, 'CR%', 'CR%', 600),
(12, 8, 7, 'CR%', 'CR%', 500),
(12, 8, 8, 'CR%', 'CR%', 500),
(12, 8, 13, 'CR%', 'CR%', 500),
(12, 8, 16, 'CR%', 'CR%', 700),
(12, 8, 22, 'CR%', 'CR%', 700),
(12, 8, 23, 'CR%', 'CR%', 700),
(12, 9, 4, 'CR%', 'CR%', 400),
(12, 9, 6, 'CR%', 'CR%', 300),
(12, 9, 7, 'CR%', 'CR%', 500),
(12, 9, 8, 'CR%', 'CR%', 500),
(12, 9, 13, 'CR%', 'CR%', 500),
(12, 9, 22, 'CR%', 'CR%', 700),
(12, 9, 23, 'CR%', 'CR%', 700),
(13, 9, 4, 'Revenue', 'Revenue', 600),
(13, 9, 5, 'Revenue', 'Revenue', 500),
(13, 9, 6, 'Revenue', 'Revenue', 500),
(13, 9, 7, 'Revenue', 'Revenue', 800),
(13, 9, 8, 'Revenue', 'Revenue', 800),
(13, 9, 13, 'Revenue', 'Revenue', 800),
(14, 4, 4, 'EPV', 'EPC', 1200),
(14, 4, 5, 'EPV', 'EPC', 1200),
(14, 4, 16, 'EPV', 'EPC', 1200),
(14, 4, 22, 'EPV', 'EPC', 1600),
(14, 5, 4, 'EPV', 'EPC', 900),
(14, 5, 5, 'EPV', 'EPC', 900),
(14, 5, 6, 'EPV', 'EPV', 800),
(14, 5, 7, 'EPV', 'EPC', 600),
(14, 5, 8, 'EPV', 'EPC', 600),
(14, 5, 13, 'EPV', 'EPC', 600),
(14, 5, 16, 'EPV', 'EPC', 900),
(14, 5, 22, 'EPV', 'EPC', 1600),
(14, 6, 4, 'EPV', 'EPC', 1200),
(14, 6, 5, 'EPV', 'EPC', 1200),
(14, 6, 7, 'EPV', 'EPC', 900),
(14, 6, 8, 'EPV', 'EPC', 900),
(14, 6, 13, 'EPV', 'EPC', 900),
(14, 6, 16, 'EPV', 'EPC', 1200),
(14, 6, 22, 'EPV', 'EPC', 1600),
(14, 7, 4, 'EPV', 'EPC', 900),
(14, 7, 5, 'EPV', 'EPC', 900),
(14, 7, 6, 'EPV', 'EPV', 800),
(14, 7, 7, 'EPV', 'EPC', 600),
(14, 7, 8, 'EPV', 'EPC', 600),
(14, 7, 13, 'EPV', 'EPC', 600),
(14, 7, 16, 'EPV', 'EPC', 900),
(14, 7, 22, 'EPV', 'EPC', 1600),
(14, 8, 4, 'EPV', 'EPC', 900),
(14, 8, 5, 'EPV', 'EPC', 900),
(14, 8, 6, 'EPV', 'EPV', 800),
(14, 8, 7, 'EPV', 'EPC', 600),
(14, 8, 8, 'EPV', 'EPC', 600),
(14, 8, 13, 'EPV', 'EPC', 600),
(14, 8, 16, 'EPV', 'EPC', 900),
(14, 8, 22, 'EPV', 'EPC', 1600),
(14, 9, 7, 'EPV', 'EPV', 600),
(14, 9, 8, 'EPV', 'EPV', 600),
(14, 9, 13, 'EPV', 'EPV', 600),
(15, 4, 4, 'PPV', 'PPC', 1300),
(15, 4, 5, 'PPV', 'PPC', 1300),
(15, 4, 16, 'PPV', 'PPC', 1300),
(15, 5, 4, 'PPV', 'PPC', 1000),
(15, 5, 5, 'PPV', 'PPC', 1000),
(15, 5, 6, 'PPV', 'PPV', 900),
(15, 5, 7, 'PPV', 'PPC', 700),
(15, 5, 8, 'PPV', 'PPC', 700),
(15, 5, 13, 'PPV', 'PPC', 700),
(15, 5, 16, 'PPV', 'PPC', 1000),
(15, 6, 4, 'PPV', 'PPC', 1300),
(15, 6, 5, 'PPV', 'PPC', 1300),
(15, 6, 7, 'PPV', 'PPC', 1000),
(15, 6, 8, 'PPV', 'PPC', 1000),
(15, 6, 13, 'PPV', 'PPC', 1000),
(15, 6, 16, 'PPV', 'PPC', 1300),
(15, 7, 4, 'PPV', 'PPC', 1000),
(15, 7, 5, 'PPV', 'PPC', 1000),
(15, 7, 6, 'PPV', 'PPV', 900),
(15, 7, 7, 'PPV', 'PPC', 700),
(15, 7, 8, 'PPV', 'PPC', 700),
(15, 7, 13, 'PPV', 'PPC', 700),
(15, 7, 16, 'PPV', 'PPC', 1000),
(15, 8, 4, 'PPV', 'PPC', 1000),
(15, 8, 5, 'PPV', 'PPC', 1000),
(15, 8, 6, 'PPV', 'PPV', 900),
(15, 8, 7, 'PPV', 'PPC', 700),
(15, 8, 8, 'PPV', 'PPC', 700),
(15, 8, 13, 'PPV', 'PPC', 700),
(15, 8, 16, 'PPV', 'PPC', 1000),
(15, 9, 7, 'PPV', 'PPV', 700),
(15, 9, 8, 'PPV', 'PPV', 700),
(15, 9, 13, 'PPV', 'PPV', 700),
(16, 5, 6, 'eCPM', 'eCPM', 500),
(16, 7, 6, 'eCPM', 'eCPM', 500),
(16, 8, 6, 'eCPM', 'eCPM', 500),
(17, 4, 7, 'P/L', 'P/L', 600),
(17, 4, 8, 'P/L', 'P/L', 600),
(17, 4, 13, 'P/L', 'P/L', 600),
(17, 4, 22, 'P/L', 'P/L', 1300),
(17, 4, 23, 'P/L', 'P/L', 1300),
(17, 5, 7, 'P/L', 'P/L', 800),
(17, 5, 8, 'P/L', 'P/L', 800),
(17, 5, 13, 'P/L', 'P/L', 800),
(17, 5, 22, 'P/L', 'P/L', 1300),
(17, 5, 23, 'P/L', 'P/L', 1300),
(17, 6, 7, 'P/L', 'P/L', 1100),
(17, 6, 8, 'P/L', 'P/L', 1100),
(17, 6, 13, 'P/L', 'P/L', 1100),
(17, 6, 22, 'P/L', 'P/L', 1300),
(17, 6, 23, 'P/L', 'P/L', 1300),
(17, 7, 7, 'P/L', 'P/L', 800),
(17, 7, 8, 'P/L', 'P/L', 800),
(17, 7, 13, 'P/L', 'P/L', 800),
(17, 7, 22, 'P/L', 'P/L', 1300),
(17, 7, 23, 'P/L', 'P/L', 1300),
(17, 8, 7, 'P/L', 'P/L', 800),
(17, 8, 8, 'P/L', 'P/L', 800),
(17, 8, 13, 'P/L', 'P/L', 800),
(17, 8, 22, 'P/L', 'P/L', 1300),
(17, 8, 23, 'P/L', 'P/L', 1300),
(17, 9, 22, 'P/L', 'P/L', 1300),
(17, 9, 23, 'P/L', 'P/L', 1300),
(18, 4, 4, 'ROI%', 'ROI%', 1400),
(18, 4, 5, 'ROI%', 'ROI%', 1400),
(18, 4, 6, 'ROI%', 'ROI%', 1000),
(18, 4, 16, 'ROI%', 'ROI%', 1400),
(18, 4, 22, 'ROI%', 'ROI%', 1000),
(18, 4, 23, 'ROI%', 'ROI%', 1600),
(18, 5, 4, 'ROI%', 'ROI%', 1100),
(18, 5, 5, 'ROI%', 'ROI%', 1100),
(18, 5, 6, 'ROI%', 'ROI%', 1000),
(18, 5, 16, 'ROI%', 'ROI%', 1100),
(18, 5, 22, 'ROI%', 'ROI%', 1000),
(18, 5, 23, 'ROI%', 'ROI%', 1600),
(18, 6, 4, 'ROI%', 'ROI%', 1400),
(18, 6, 5, 'ROI%', 'ROI%', 1400),
(18, 6, 6, 'ROI%', 'ROI%', 1000),
(18, 6, 16, 'ROI%', 'ROI%', 1400),
(18, 6, 22, 'ROI%', 'ROI%', 1000),
(18, 6, 23, 'ROI%', 'ROI%', 1600),
(18, 7, 4, 'ROI%', 'ROI%', 1100),
(18, 7, 5, 'ROI%', 'ROI%', 1100),
(18, 7, 6, 'ROI%', 'ROI%', 1000),
(18, 7, 16, 'ROI%', 'ROI%', 1100),
(18, 7, 22, 'ROI%', 'ROI%', 1000),
(18, 7, 23, 'ROI%', 'ROI%', 1600),
(18, 8, 4, 'ROI%', 'ROI%', 1100),
(18, 8, 5, 'ROI%', 'ROI%', 1100),
(18, 8, 6, 'ROI%', 'ROI%', 1000),
(18, 8, 16, 'ROI%', 'ROI%', 1100),
(18, 8, 22, 'ROI%', 'ROI%', 1000),
(18, 8, 23, 'ROI%', 'ROI%', 1600),
(19, 4, 4, 'Engage%', 'Engage%', 200),
(19, 4, 5, 'Engage%', 'Engage%', 200),
(19, 4, 16, 'Engage%', 'Engage%', 200),
(19, 5, 4, 'Engage%', 'Engage%', 200),
(19, 5, 5, 'Engage%', 'Engage%', 200),
(19, 5, 16, 'Engage%', 'Engage%', 200),
(19, 6, 4, 'Engage%', 'Engage%', 200),
(19, 6, 5, 'Engage%', 'Engage%', 200),
(19, 6, 16, 'Engage%', 'Engage%', 200),
(19, 7, 4, 'Engage%', 'Engage%', 200),
(19, 7, 5, 'Engage%', 'Engage%', 200),
(19, 7, 16, 'Engage%', 'Engage%', 200),
(19, 8, 4, 'Engage%', 'Engage%', 200),
(19, 8, 5, 'Engage%', 'Engage%', 200),
(19, 8, 16, 'Engage%', 'Engage%', 200),
(19, 9, 5, 'Engage%', 'Engage%', 200),
(23, 4, 4, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1500),
(23, 4, 5, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1500),
(23, 4, 6, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 4, 10, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 4, 16, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1500),
(23, 5, 4, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 5, 5, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 5, 6, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 5, 10, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 5, 16, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 6, 4, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1500),
(23, 6, 5, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1500),
(23, 6, 6, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 6, 10, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 6, 16, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1500),
(23, 7, 4, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 7, 5, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 7, 6, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 7, 10, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 7, 16, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 8, 4, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 8, 5, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 8, 6, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 8, 10, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 8, 16, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(23, 9, 10, 'Revenue-Cost-P/L', 'Revenue-Cost-P/L', 1200),
(34, 4, 4, 'Subscribers', 'Subscribers', 600),
(34, 4, 5, 'Subscribers', 'Subscribers', 600),
(34, 4, 7, 'Subscribers', 'Subscribers', 200),
(34, 4, 8, 'Subscribers', 'Subscribers', 200),
(34, 4, 13, 'Subscribers', 'Subscribers', 200),
(34, 4, 16, 'Subscribers', 'Subscribers', 600),
(34, 6, 4, 'Subscribers', 'Subscribers', 600),
(34, 6, 5, 'Subscribers', 'Subscribers', 600),
(34, 6, 7, 'Subscribers', 'Subscribers', 400),
(34, 6, 8, 'Subscribers', 'Subscribers', 400),
(34, 6, 13, 'Subscribers', 'Subscribers', 400),
(34, 6, 16, 'Subscribers', 'Subscribers', 600),
(35, 4, 4, 'SR%', 'SR%', 700),
(35, 4, 5, 'SR%', 'SR%', 700),
(35, 4, 7, 'SR%', 'SR%', 300),
(35, 4, 8, 'SR%', 'SR%', 300),
(35, 4, 13, 'SR%', 'SR%', 300),
(35, 4, 16, 'SR%', 'SR%', 700),
(35, 4, 22, 'SR%', 'SR%', 1100),
(35, 4, 23, 'SR%', 'SR%', 1000),
(35, 6, 4, 'SR%', 'SR%', 700),
(35, 6, 5, 'SR%', 'SR%', 700),
(35, 6, 7, 'SR%', 'SR%', 500),
(35, 6, 8, 'SR%', 'SR%', 500),
(35, 6, 13, 'SR%', 'SR%', 500),
(35, 6, 16, 'SR%', 'SR%', 700),
(35, 6, 22, 'SR%', 'SR%', 1100),
(35, 6, 23, 'SR%', 'SR%', 1000),
(36, 4, 4, 'CPSUB', 'CPSUB', 800),
(36, 4, 5, 'CPSUB', 'CPSUB', 800),
(36, 4, 7, 'CPSUB', 'CPSUB', 400),
(36, 4, 8, 'CPSUB', 'CPSUB', 400),
(36, 4, 13, 'CPSUB', 'CPSUB', 400),
(36, 4, 16, 'CPSUB', 'CPSUB', 800),
(36, 4, 23, 'CPSUB', 'CPSUB', 2200),
(36, 6, 4, 'CPSUB', 'CPSUB', 800),
(36, 6, 5, 'CPSUB', 'CPSUB', 800),
(36, 6, 7, 'CPSUB', 'CPSUB', 600),
(36, 6, 8, 'CPSUB', 'CPSUB', 600),
(36, 6, 13, 'CPSUB', 'CPSUB', 600),
(36, 6, 16, 'CPSUB', 'CPSUB', 800),
(36, 6, 23, 'CPSUB', 'CPSUB', 2200),
(47, 4, 4, 'CPA', 'CPA', 1100),
(47, 4, 5, 'CPA', 'CPA', 1100),
(47, 4, 6, 'CPA', 'CPA', 700),
(47, 4, 16, 'CPA', 'CPA', 1100),
(47, 4, 22, 'CPA', 'CPA', 1900),
(47, 4, 23, 'CPA', 'CPA', 1900),
(47, 5, 4, 'CPA', 'CPA', 800),
(47, 5, 5, 'CPA', 'CPA', 800),
(47, 5, 6, 'CPA', 'CPA', 700),
(47, 5, 16, 'CPA', 'CPA', 800),
(47, 5, 22, 'CPA', 'CPA', 1900),
(47, 5, 23, 'CPA', 'CPA', 1900),
(47, 6, 4, 'CPA', 'CPA', 1100),
(47, 6, 5, 'CPA', 'CPA', 1100),
(47, 6, 6, 'CPA', 'CPA', 700),
(47, 6, 16, 'CPA', 'CPA', 1100),
(47, 6, 22, 'CPA', 'CPA', 1900),
(47, 6, 23, 'CPA', 'CPA', 1900),
(47, 7, 4, 'CPA', 'CPA', 800),
(47, 7, 5, 'CPA', 'CPA', 800),
(47, 7, 6, 'CPA', 'CPA', 700),
(47, 7, 16, 'CPA', 'CPA', 800),
(47, 7, 22, 'CPA', 'CPA', 1900),
(47, 7, 23, 'CPA', 'CPA', 1900),
(47, 8, 4, 'CPA', 'CPA', 800),
(47, 8, 5, 'CPA', 'CPA', 800),
(47, 8, 6, 'CPA', 'CPA', 700),
(47, 8, 16, 'CPA', 'CPA', 800),
(47, 8, 22, 'CPA', 'CPA', 1900),
(47, 8, 23, 'CPA', 'CPA', 1900),
(47, 9, 4, 'CPA', 'CPA', 500),
(47, 9, 6, 'CPA', 'CPA', 400),
(47, 9, 23, 'CPA', 'CPA', 1900);

-- --------------------------------------------------------

--
-- Table structure for table `columnschartsuser`
--

CREATE TABLE `columnschartsuser` (
  `ColumnID` tinyint(3) UNSIGNED NOT NULL,
  `CampaignTypeID` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `ReportTypeID` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `UserID` smallint(5) UNSIGNED NOT NULL DEFAULT 1,
  `IsVisible` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `columnschartsuser`
--

INSERT INTO `columnschartsuser` (`ColumnID`, `CampaignTypeID`, `ReportTypeID`, `UserID`, `IsVisible`) VALUES
(5, 4, 4, 1, 1),
(5, 5, 4, 1, 1),
(5, 7, 4, 1, 1),
(8, 9, 4, 1, 1),
(15, 6, 4, 1, 1),
(23, 8, 4, 1, 1),
(5, 4, 5, 1, 1),
(5, 5, 5, 1, 1),
(5, 6, 5, 1, 1),
(5, 7, 5, 1, 1),
(5, 8, 5, 1, 1),
(5, 9, 5, 1, 1),
(8, 4, 6, 1, 1),
(8, 5, 6, 1, 1),
(8, 6, 6, 1, 1),
(8, 7, 6, 1, 1),
(8, 8, 6, 1, 1),
(8, 9, 6, 1, 1),
(5, 4, 7, 1, 1),
(5, 5, 7, 1, 1),
(5, 6, 7, 1, 1),
(5, 7, 7, 1, 1),
(5, 8, 7, 1, 1),
(5, 9, 7, 1, 1),
(5, 4, 8, 1, 1),
(5, 5, 8, 1, 1),
(5, 6, 8, 1, 1),
(5, 7, 8, 1, 1),
(5, 8, 8, 1, 1),
(5, 9, 8, 1, 1),
(5, 4, 13, 1, 1),
(5, 5, 13, 1, 1),
(5, 6, 13, 1, 1),
(5, 7, 13, 1, 1),
(5, 8, 13, 1, 1),
(5, 9, 13, 1, 1),
(5, 4, 16, 1, 1),
(5, 5, 16, 1, 1),
(5, 7, 16, 1, 1),
(15, 6, 16, 1, 1),
(23, 8, 16, 1, 1),
(5, 4, 22, 1, 1),
(5, 5, 22, 1, 1),
(5, 6, 22, 1, 1),
(5, 7, 22, 1, 1),
(5, 8, 22, 1, 1),
(5, 9, 22, 1, 1),
(9, 4, 23, 1, 1),
(9, 5, 23, 1, 1),
(9, 6, 23, 1, 1),
(9, 7, 23, 1, 1),
(9, 8, 23, 1, 1),
(9, 9, 23, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `columnstypes`
--

CREATE TABLE `columnstypes` (
  `ColumnID` tinyint(3) UNSIGNED NOT NULL,
  `CampaignTypeID` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `ReportTypeID` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `ColumnCaption` varchar(100) NOT NULL,
  `ColumnCaption2` varchar(100) NOT NULL,
  `ColumnHeader` varchar(100) NOT NULL DEFAULT '',
  `ColumnHeader2` varchar(100) NOT NULL DEFAULT '',
  `ColumnIndexList` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `ColumnIndex` smallint(5) UNSIGNED NOT NULL,
  `DefaultState` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `columnstypes`
--

INSERT INTO `columnstypes` (`ColumnID`, `CampaignTypeID`, `ReportTypeID`, `ColumnCaption`, `ColumnCaption2`, `ColumnHeader`, `ColumnHeader2`, `ColumnIndexList`, `ColumnIndex`, `DefaultState`) VALUES
(1, 1, 14, 'ID', 'ID', 'ID', 'ID', 300, 300, 0),
(1, 1, 17, 'ID', 'ID', 'ID', 'ID', 300, 300, 0),
(1, 1, 24, 'ID', 'ID', 'ID', 'ID', 300, 300, 0),
(1, 1, 25, 'ID', 'ID', 'ID', 'ID', 300, 300, 0),
(1, 4, 1, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 4, 4, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 4, 9, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 4, 10, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 4, 12, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 5, 1, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 5, 4, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 5, 9, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 5, 10, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 6, 1, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 6, 4, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 6, 9, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 6, 10, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 6, 12, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 7, 1, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 7, 4, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 7, 9, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 7, 10, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 8, 1, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 8, 4, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 8, 9, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 8, 10, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 9, 1, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 9, 4, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 9, 9, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(1, 9, 10, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(2, 1, 14, 'Page', 'Page', 'Page', 'Page', 2100, 2100, 1),
(2, 1, 17, 'Page', 'Page', 'Page', 'Page', 2100, 2100, 0),
(2, 1, 24, 'Page', 'Page', 'Page', 'Page', 2100, 2100, 0),
(2, 1, 25, 'Page', 'Page', 'Page', 'Page', 2100, 2100, 1),
(2, 4, 4, 'Page', 'Page', 'Page', 'Page', 200, 200, 0),
(2, 4, 5, 'Page', 'Page', 'Page', 'Page', 200, 200, 1),
(2, 4, 6, 'Offer', 'Offer', 'Offer', 'Offer', 200, 200, 1),
(2, 4, 9, 'Name', 'Name', 'Name', 'Name', 200, 200, 1),
(2, 4, 10, 'Name', 'Name', 'Name', 'Name', 200, 200, 1),
(2, 4, 12, 'Name', 'Name', 'Name', 'Name', 200, 200, 1),
(2, 4, 19, 'Page', 'Page', 'Page', 'Page', 500, 500, 0),
(2, 4, 20, 'Page', 'Page', 'Page', 'Page', 500, 500, 0),
(2, 5, 4, 'Page', 'Page', 'Page', 'Page', 200, 200, 0),
(2, 5, 5, 'Page', 'Page', 'Page', 'Page', 200, 200, 1),
(2, 5, 6, 'Offer', 'Offer', 'Offer', 'Offer', 200, 200, 1),
(2, 5, 9, 'Name', 'Name', 'Name', 'Name', 200, 200, 1),
(2, 5, 10, 'Name', 'Name', 'Name', 'Name', 200, 200, 1),
(2, 5, 19, 'Page', 'Page', 'Page', 'Page', 500, 500, 0),
(2, 5, 20, 'Page', 'Page', 'Page', 'Page', 500, 500, 0),
(2, 6, 4, 'Page', 'Page', 'Page', 'Page', 200, 200, 0),
(2, 6, 5, 'Page', 'Page', 'Page', 'Page', 200, 200, 1),
(2, 6, 6, 'Offer', 'Offer', 'Offer', 'Offer', 200, 200, 1),
(2, 6, 9, 'Name', 'Name', 'Name', 'Name', 200, 200, 1),
(2, 6, 10, 'Name', 'Name', 'Name', 'Name', 200, 200, 1),
(2, 6, 12, 'Name', 'Name', 'Name', 'Name', 200, 200, 1),
(2, 6, 19, 'Page', 'Page', 'Page', 'Page', 500, 500, 0),
(2, 6, 20, 'Page', 'Page', 'Page', 'Page', 500, 500, 0),
(2, 7, 4, 'Page', 'Page', 'Page', 'Page', 200, 200, 0),
(2, 7, 5, 'Page', 'Page', 'Page', 'Page', 200, 200, 1),
(2, 7, 6, 'Offer', 'Offer', 'Offer', 'Offer', 200, 200, 1),
(2, 7, 9, 'Name', 'Name', 'Name', 'Name', 200, 200, 1),
(2, 7, 10, 'Name', 'Name', 'Name', 'Name', 200, 200, 1),
(2, 7, 19, 'Page', 'Page', 'Page', 'Page', 500, 500, 0),
(2, 7, 20, 'Page', 'Page', 'Page', 'Page', 500, 500, 0),
(2, 8, 4, 'Page', 'Page', 'Page', 'Page', 200, 200, 0),
(2, 8, 5, 'Page', 'Page', 'Page', 'Page', 200, 200, 1),
(2, 8, 6, 'Offer', 'Offer', 'Offer', 'Offer', 200, 200, 1),
(2, 8, 9, 'Name', 'Name', 'Name', 'Name', 200, 200, 1),
(2, 8, 10, 'Name', 'Name', 'Name', 'Name', 200, 200, 1),
(2, 8, 19, 'Page', 'Page', 'Page', 'Page', 500, 500, 0),
(2, 8, 20, 'Page', 'Page', 'Page', 'Page', 500, 500, 0),
(2, 9, 5, 'Page', 'Page', 'Page', 'Page', 200, 200, 1),
(2, 9, 6, 'Offer', 'Offer', 'Offer', 'Offer', 200, 200, 1),
(2, 9, 9, 'Name', 'Name', 'Name', 'Name', 100, 100, 1),
(2, 9, 10, 'Name', 'Name', 'Name', 'Name', 200, 200, 1),
(2, 9, 19, 'Page', 'Page', 'Page', 'Page', 500, 500, 0),
(2, 9, 20, 'Page', 'Page', 'Page', 'Page', 500, 500, 1),
(3, 1, 14, 'Page URL', 'Page URL', 'URL', 'URL', 2200, 2200, 0),
(3, 1, 17, 'Page URL', 'Page URL', 'URL', 'URL', 2200, 2200, 0),
(3, 1, 24, 'Page URL', 'Page URL', 'URL', 'URL', 2200, 2200, 0),
(3, 1, 25, 'Page URL', 'Page URL', 'URL', 'URL', 2200, 2200, 0),
(3, 4, 4, 'Page URL', 'Page URL', 'URL', 'URL', 300, 300, 0),
(3, 4, 5, 'Page URL', 'Page URL', 'URL', 'URL', 300, 300, 0),
(3, 4, 6, 'Offer URL', 'Offer URL', 'URL', 'URL', 300, 300, 0),
(3, 4, 19, 'Page URL', 'Page URL', 'URL', 'URL', 600, 600, 0),
(3, 4, 20, 'Page URL', 'Page URL', 'URL', 'URL', 600, 600, 0),
(3, 5, 4, 'Page URL', 'Page URL', 'URL', 'URL', 300, 300, 0),
(3, 5, 5, 'Page URL', 'Page URL', 'URL', 'URL', 300, 300, 0),
(3, 5, 6, 'Offer URL', 'Offer URL', 'URL', 'URL', 300, 300, 0),
(3, 5, 19, 'Page URL', 'Page URL', 'URL', 'URL', 600, 600, 0),
(3, 5, 20, 'Page URL', 'Page URL', 'URL', 'URL', 600, 600, 0),
(3, 6, 4, 'Page URL', 'Page URL', 'URL', 'URL', 300, 300, 0),
(3, 6, 5, 'Page URL', 'Page URL', 'URL', 'URL', 300, 300, 0),
(3, 6, 6, 'Offer URL', 'Offer URL', 'URL', 'URL', 300, 300, 0),
(3, 6, 19, 'Page URL', 'Page URL', 'URL', 'URL', 600, 600, 0),
(3, 6, 20, 'Page URL', 'Page URL', 'URL', 'URL', 600, 600, 0),
(3, 7, 4, 'Page URL', 'Page URL', 'URL', 'URL', 300, 300, 0),
(3, 7, 5, 'Page URL', 'Page URL', 'URL', 'URL', 300, 300, 0),
(3, 7, 6, 'Offer URL', 'Offer URL', 'URL', 'URL', 300, 300, 0),
(3, 7, 19, 'Page URL', 'Page URL', 'URL', 'URL', 600, 600, 0),
(3, 7, 20, 'Page URL', 'Page URL', 'URL', 'URL', 600, 600, 0),
(3, 8, 4, 'Page URL', 'Page URL', 'URL', 'URL', 300, 300, 0),
(3, 8, 5, 'Page URL', 'Page URL', 'URL', 'URL', 300, 300, 0),
(3, 8, 6, 'Offer URL', 'Offer URL', 'URL', 'URL', 300, 300, 0),
(3, 8, 19, 'Page URL', 'Page URL', 'URL', 'URL', 600, 600, 0),
(3, 8, 20, 'Page URL', 'Page URL', 'URL', 'URL', 600, 600, 0),
(3, 9, 5, 'Page URL', 'Page URL', 'URL', 'URL', 300, 300, 0),
(3, 9, 6, 'Offer URL', 'Offer URL', 'URL', 'URL', 300, 300, 0),
(4, 1, 14, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 500, 500, 1),
(4, 1, 17, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 500, 500, 1),
(4, 1, 24, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 500, 500, 1),
(4, 1, 25, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 500, 500, 1),
(4, 4, 1, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 400, 400, 1),
(4, 4, 4, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 400, 400, 1),
(4, 4, 19, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 700, 700, 0),
(4, 4, 20, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 700, 700, 1),
(4, 5, 1, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 400, 400, 1),
(4, 5, 4, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 400, 400, 1),
(4, 5, 19, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 700, 700, 0),
(4, 5, 20, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 700, 700, 1),
(4, 6, 1, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 400, 400, 1),
(4, 6, 4, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 400, 400, 1),
(4, 6, 19, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 700, 700, 0),
(4, 6, 20, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 700, 700, 1),
(4, 7, 1, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 400, 400, 1),
(4, 7, 4, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 400, 400, 1),
(4, 7, 19, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 700, 700, 0),
(4, 7, 20, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 700, 700, 1),
(4, 8, 1, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 400, 400, 1),
(4, 8, 4, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 400, 400, 1),
(4, 8, 19, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 700, 700, 0),
(4, 8, 20, 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 'Keyword/Target', 700, 700, 1),
(5, 4, 1, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 4, 4, 'Views', 'Visitors', 'Views', 'Visitors', 2700, 2700, 1),
(5, 4, 5, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 4, 7, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 4, 8, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 4, 9, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 4, 10, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 4, 12, 'Visitors', 'Visitors', 'Visitors', 'Visitors', 500, 500, 1),
(5, 4, 13, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 4, 16, 'Views', 'Ad Clicks', 'Views', 'Ad Clicks', 2700, 2700, 1),
(5, 4, 19, 'Views', 'Visitors', 'Views', 'Visitors', 7500, 7500, 1),
(5, 4, 20, 'Views', 'Visitors', 'Views', 'Visitors', 7500, 7500, 1),
(5, 5, 1, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 5, 4, 'Views', 'Visitors', 'Views', 'Visitors', 2700, 2700, 1),
(5, 5, 5, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 5, 7, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 5, 8, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 5, 9, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 5, 10, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 5, 13, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 5, 16, 'Views', 'Ad Clicks', 'Views', 'Ad Clicks', 2700, 2700, 1),
(5, 5, 19, 'Views', 'Visitors', 'Views', 'Visitors', 7500, 7500, 1),
(5, 5, 20, 'Views', 'Visitors', 'Views', 'Visitors', 7500, 7500, 1),
(5, 6, 1, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 6, 4, 'Views', 'Visitors', 'Views', 'Visitors', 2700, 2700, 1),
(5, 6, 5, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 6, 7, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 6, 8, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 6, 9, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 6, 10, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 6, 12, 'Visitors', 'Visitors', 'Visitors', 'Visitors', 500, 500, 1),
(5, 6, 13, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 6, 16, 'Views', 'Ad Clicks', 'Views', 'Ad Clicks', 2700, 2700, 1),
(5, 6, 19, 'Views', 'Visitors', 'Views', 'Visitors', 7500, 7500, 1),
(5, 6, 20, 'Views', 'Visitors', 'Views', 'Visitors', 7500, 7500, 1),
(5, 7, 1, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 7, 4, 'Views', 'Visitors', 'Views', 'Visitors', 2700, 2700, 1),
(5, 7, 5, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 7, 7, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 7, 8, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 7, 9, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 7, 10, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 7, 13, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 7, 16, 'Views', 'Ad Clicks', 'Views', 'Ad Clicks', 2700, 2700, 1),
(5, 7, 19, 'Views', 'Visitors', 'Views', 'Visitors', 7500, 7500, 1),
(5, 7, 20, 'Views', 'Visitors', 'Views', 'Visitors', 7500, 7500, 1),
(5, 8, 1, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 8, 4, 'Views', 'Visitors', 'Views', 'Visitors', 2700, 2700, 1),
(5, 8, 5, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 8, 7, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 8, 8, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 8, 9, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 8, 10, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 8, 13, 'Views', 'Visitors', 'Views', 'Visitors', 500, 500, 1),
(5, 8, 16, 'Views', 'Ad Clicks', 'Views', 'Ad Clicks', 2700, 2700, 1),
(5, 8, 19, 'Views', 'Visitors', 'Views', 'Visitors', 7500, 7500, 1),
(5, 8, 20, 'Views', 'Visitors', 'Views', 'Visitors', 7500, 7500, 1),
(5, 9, 1, '# Sent', '# Sent', '# Sent', '# Sent', 500, 500, 1),
(5, 9, 4, '# Sent', '# Sent', '# Sent', '# Sent', 2700, 2700, 1),
(5, 9, 5, 'Views', 'Views', 'Views', 'Views', 500, 500, 1),
(5, 9, 7, 'Views', 'Views', 'Views', 'Views', 500, 500, 1),
(5, 9, 8, 'Views', 'Views', 'Views', 'Views', 500, 500, 1),
(5, 9, 9, '# Sent', '# Sent', '# Sent', '# Sent', 400, 400, 1),
(5, 9, 10, '# Sent', '# Sent', '# Sent', '# Sent', 500, 500, 1),
(5, 9, 13, 'Views', 'Views', 'Views', 'Views', 500, 500, 1),
(5, 9, 19, 'Views', 'Views', 'Views', 'Views', 7500, 7500, 1),
(5, 9, 20, 'Views', 'Views', 'Views', 'Views', 7500, 7500, 1),
(6, 1, 14, 'Cost', 'Cost', 'Cost', 'Cost', 2440, 2440, 0),
(6, 1, 25, 'Cost', 'Cost', 'Cost', 'Cost', 2440, 2440, 0),
(6, 4, 1, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 4, 4, 'Cost', 'Cost', 'Cost', 'Cost', 2900, 2900, 1),
(6, 4, 5, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 4, 6, 'Cost', 'Cost', 'Cost', 'Cost', 900, 900, 1),
(6, 4, 7, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 4, 8, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 4, 9, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 4, 10, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 4, 12, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 4, 13, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 4, 16, 'Cost', 'Cost', 'Cost', 'Cost', 2900, 2900, 1),
(6, 4, 19, 'Cost', 'Cost', 'Cost', 'Cost', 7700, 7700, 1),
(6, 4, 20, 'Cost', 'Cost', 'Cost', 'Cost', 7700, 7700, 1),
(6, 5, 1, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 5, 4, 'Cost', 'Cost', 'Cost', 'Cost', 2900, 2900, 1),
(6, 5, 5, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 5, 6, 'Cost', 'Cost', 'Cost', 'Cost', 900, 900, 1),
(6, 5, 7, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 5, 8, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 5, 9, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 5, 10, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 5, 13, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 5, 16, 'Cost', 'Cost', 'Cost', 'Cost', 2900, 2900, 1),
(6, 5, 19, 'Cost', 'Cost', 'Cost', 'Cost', 7700, 7700, 1),
(6, 5, 20, 'Cost', 'Cost', 'Cost', 'Cost', 7700, 7700, 1),
(6, 6, 1, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 6, 4, 'Cost', 'Cost', 'Cost', 'Cost', 2900, 2900, 1),
(6, 6, 5, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 6, 6, 'Cost', 'Cost', 'Cost', 'Cost', 900, 900, 1),
(6, 6, 7, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 6, 8, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 6, 9, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 6, 10, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 6, 12, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 6, 13, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 6, 16, 'Cost', 'Cost', 'Cost', 'Cost', 2900, 2900, 1),
(6, 6, 19, 'Cost', 'Cost', 'Cost', 'Cost', 7700, 7700, 1),
(6, 6, 20, 'Cost', 'Cost', 'Cost', 'Cost', 7700, 7700, 1),
(6, 7, 1, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 7, 4, 'Cost', 'Cost', 'Cost', 'Cost', 2900, 2900, 1),
(6, 7, 5, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 7, 6, 'Cost', 'Cost', 'Cost', 'Cost', 900, 900, 1),
(6, 7, 7, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 7, 8, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 7, 9, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 7, 10, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 7, 13, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 7, 16, 'Cost', 'Cost', 'Cost', 'Cost', 2900, 2900, 1),
(6, 7, 19, 'Cost', 'Cost', 'Cost', 'Cost', 7700, 7700, 1),
(6, 7, 20, 'Cost', 'Cost', 'Cost', 'Cost', 7700, 7700, 1),
(6, 8, 1, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 8, 4, 'Cost', 'Cost', 'Cost', 'Cost', 2900, 2900, 1),
(6, 8, 5, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 8, 6, 'Cost', 'Cost', 'Cost', 'Cost', 900, 900, 1),
(6, 8, 7, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 8, 8, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 8, 9, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 8, 10, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 8, 13, 'Cost', 'Cost', 'Cost', 'Cost', 700, 700, 1),
(6, 8, 16, 'Cost', 'Cost', 'Cost', 'Cost', 2900, 2900, 1),
(6, 8, 19, 'Cost', 'Cost', 'Cost', 'Cost', 7700, 7700, 1),
(6, 8, 20, 'Cost', 'Cost', 'Cost', 'Cost', 7700, 7700, 1),
(7, 4, 1, 'CPV', 'CPC', 'CPV', 'CPC', 800, 800, 1),
(7, 4, 4, 'CPV', 'CPC', 'CPV', 'CPC', 3000, 3000, 1),
(7, 4, 5, 'CPV', 'CPC', 'CPV', 'CPC', 800, 800, 1),
(7, 4, 7, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 4, 8, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 4, 13, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 4, 16, 'CPV', 'CPC', 'CPV', 'CPC', 3000, 3000, 1),
(7, 4, 19, 'CPV', 'CPC', 'CPV', 'CPC', 7800, 7800, 1),
(7, 4, 20, 'CPV', 'CPC', 'CPV', 'CPC', 7800, 7800, 1),
(7, 5, 1, 'CPV', 'CPC', 'CPV', 'CPC', 800, 800, 1),
(7, 5, 4, 'CPV', 'CPC', 'CPV', 'CPC', 3000, 3000, 1),
(7, 5, 5, 'CPV', 'CPC', 'CPV', 'CPC', 800, 800, 1),
(7, 5, 7, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 5, 8, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 5, 13, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 5, 16, 'CPV', 'CPC', 'CPV', 'CPC', 3000, 3000, 1),
(7, 5, 19, 'CPV', 'CPC', 'CPV', 'CPC', 7800, 7800, 1),
(7, 5, 20, 'CPV', 'CPC', 'CPV', 'CPC', 7800, 7800, 1),
(7, 6, 1, 'CPV', 'CPC', 'CPV', 'CPC', 800, 800, 1),
(7, 6, 4, 'CPV', 'CPC', 'CPV', 'CPC', 3000, 3000, 1),
(7, 6, 5, 'CPV', 'CPC', 'CPV', 'CPC', 800, 800, 1),
(7, 6, 7, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 6, 8, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 6, 13, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 6, 16, 'CPV', 'CPC', 'CPV', 'CPC', 3000, 3000, 1),
(7, 6, 19, 'CPV', 'CPC', 'CPV', 'CPC', 7800, 7800, 1),
(7, 6, 20, 'CPV', 'CPC', 'CPV', 'CPC', 7800, 7800, 1),
(7, 7, 1, 'CPV', 'CPC', 'CPV', 'CPC', 800, 800, 1),
(7, 7, 4, 'CPV', 'CPC', 'CPV', 'CPC', 3000, 3000, 1),
(7, 7, 5, 'CPV', 'CPC', 'CPV', 'CPC', 800, 800, 1),
(7, 7, 7, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 7, 8, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 7, 13, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 7, 16, 'CPV', 'CPC', 'CPV', 'CPC', 3000, 3000, 1),
(7, 7, 19, 'CPV', 'CPC', 'CPV', 'CPC', 7800, 7800, 1),
(7, 7, 20, 'CPV', 'CPC', 'CPV', 'CPC', 7800, 7800, 1),
(7, 8, 1, 'CPV', 'CPC', 'CPV', 'CPC', 800, 800, 1),
(7, 8, 4, 'CPV', 'CPC', 'CPV', 'CPC', 3000, 3000, 1),
(7, 8, 5, 'CPV', 'CPC', 'CPV', 'CPC', 800, 800, 1),
(7, 8, 7, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 8, 8, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 8, 13, 'CPV', 'Ad CPC', 'CPV', 'Ad CPC', 800, 800, 1),
(7, 8, 16, 'CPV', 'CPC', 'CPV', 'CPC', 3000, 3000, 1),
(7, 8, 19, 'CPV', 'CPC', 'CPV', 'CPC', 7800, 7800, 1),
(7, 8, 20, 'CPV', 'CPC', 'CPV', 'CPC', 7800, 7800, 1),
(8, 4, 1, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 4, 4, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 2800, 3100, 1),
(8, 4, 5, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 600, 900, 1),
(8, 4, 6, 'Visitors', 'Visitors', 'Visitors', 'Visitors', 700, 700, 1),
(8, 4, 12, 'Clicks', 'Clicks', 'Clicks', 'Clicks', 800, 800, 1),
(8, 4, 19, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 7600, 7900, 1),
(8, 4, 20, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 7600, 7900, 1),
(8, 5, 1, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 5, 4, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 2800, 3100, 1),
(8, 5, 5, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 600, 900, 1),
(8, 5, 6, 'Visitors', 'Visitors', 'Visitors', 'Visitors', 700, 700, 1),
(8, 5, 7, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 5, 8, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 5, 13, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 5, 16, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 2800, 3100, 1),
(8, 5, 19, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 7600, 7900, 1),
(8, 5, 20, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 7600, 7900, 1),
(8, 6, 1, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 6, 4, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 2800, 3100, 1),
(8, 6, 5, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 600, 900, 1),
(8, 6, 6, 'Visitors', 'Visitors', 'Visitors', 'Visitors', 700, 700, 1),
(8, 6, 7, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 6, 8, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 6, 12, 'Clicks', 'Clicks', 'Clicks', 'Clicks', 800, 800, 1),
(8, 6, 13, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 6, 16, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 2800, 3100, 1),
(8, 6, 19, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 7600, 7900, 1),
(8, 6, 20, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 7600, 7900, 1),
(8, 7, 1, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 7, 4, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 2800, 3100, 1),
(8, 7, 5, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 600, 900, 1),
(8, 7, 6, 'Visitors', 'Visitors', 'Visitors', 'Visitors', 700, 700, 1),
(8, 7, 7, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 7, 8, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 7, 13, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 7, 16, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 2800, 3100, 1),
(8, 7, 19, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 7600, 7900, 1),
(8, 7, 20, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 7600, 7900, 1),
(8, 8, 1, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 8, 4, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 2800, 3100, 1),
(8, 8, 5, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 600, 900, 1),
(8, 8, 6, 'Visitors', 'Visitors', 'Visitors', 'Visitors', 700, 700, 1),
(8, 8, 7, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 8, 8, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 8, 13, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 900, 900, 1),
(8, 8, 16, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 2800, 3100, 1),
(8, 8, 19, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 7600, 7900, 1),
(8, 8, 20, 'Clicks', 'LP Clicks', 'Clicks', 'LP Clicks', 7600, 7900, 1),
(8, 9, 1, 'Clicks', 'Clicks', 'Clicks', 'Clicks', 900, 900, 1),
(8, 9, 4, 'Clicks', 'Clicks', 'Clicks', 'Clicks', 2800, 3100, 1),
(8, 9, 5, 'Clicks', 'Clicks', 'Clicks', 'Clicks', 600, 900, 1),
(8, 9, 6, 'Visitors', 'Visitors', 'Visitors', 'Visitors', 700, 700, 1),
(8, 9, 7, 'Clicks', 'Clicks', 'Clicks', 'Clicks', 900, 900, 1),
(8, 9, 8, 'Clicks', 'Clicks', 'Clicks', 'Clicks', 900, 900, 1),
(8, 9, 9, 'Clicks', 'Clicks', 'Clicks', 'Clicks', 900, 900, 1),
(8, 9, 10, 'Clicks', 'Clicks', 'Clicks', 'Clicks', 900, 900, 1),
(8, 9, 13, 'Clicks', 'Clicks', 'Clicks', 'Clicks', 900, 900, 1),
(8, 9, 19, 'Clicks', 'Clicks', 'Clicks', 'Clicks', 7600, 7900, 1),
(8, 9, 20, 'Clicks', 'Clicks', 'Clicks', 'Clicks', 7600, 7900, 1),
(9, 4, 1, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 4, 4, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 2900, 3200, 1),
(9, 4, 5, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 700, 1000, 1),
(9, 4, 12, 'CTR', 'CTR', 'CTR', 'CTR', 900, 900, 1),
(9, 4, 18, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 200, 200, 0),
(9, 4, 19, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 7700, 8000, 1),
(9, 4, 20, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 7700, 8000, 1),
(9, 5, 1, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 5, 4, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 2900, 3200, 1),
(9, 5, 5, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 700, 1000, 1),
(9, 5, 7, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 5, 8, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 5, 13, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 5, 16, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 2900, 3200, 1),
(9, 5, 18, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 200, 200, 0),
(9, 5, 19, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 7700, 8000, 1),
(9, 5, 20, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 7700, 8000, 1),
(9, 6, 1, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 6, 4, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 2900, 3200, 1),
(9, 6, 5, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 700, 1000, 1),
(9, 6, 7, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 6, 8, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 6, 12, 'CTR', 'CTR', 'CTR', 'CTR', 900, 900, 1),
(9, 6, 13, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 6, 16, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 2900, 3200, 1),
(9, 6, 18, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 200, 200, 0),
(9, 6, 19, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 7700, 8000, 1),
(9, 6, 20, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 7700, 8000, 1),
(9, 7, 1, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 7, 4, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 2900, 3200, 1),
(9, 7, 5, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 700, 1000, 1),
(9, 7, 7, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 7, 8, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 7, 13, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 7, 16, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 2900, 3200, 1),
(9, 7, 18, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 200, 200, 0),
(9, 7, 19, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 7700, 8000, 1),
(9, 7, 20, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 7700, 8000, 1),
(9, 8, 1, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 8, 4, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 2900, 3200, 1),
(9, 8, 5, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 700, 1000, 1),
(9, 8, 7, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 8, 8, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 8, 13, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 1000, 1000, 1),
(9, 8, 16, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 2900, 3200, 1),
(9, 8, 18, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 200, 200, 0),
(9, 8, 19, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 7700, 8000, 1),
(9, 8, 20, 'CTR', 'LP CTR', 'CTR', 'LP CTR', 7700, 8000, 1),
(9, 9, 1, 'CTR', 'CTR', 'CTR', 'CTR', 1000, 1000, 1),
(9, 9, 4, 'CTR', 'CTR', 'CTR', 'CTR', 2900, 3200, 1),
(9, 9, 5, 'CTR', 'CTR', 'CTR', 'CTR', 700, 1000, 1),
(9, 9, 7, 'CTR', 'CTR', 'CTR', 'CTR', 1000, 1000, 1),
(9, 9, 8, 'CTR', 'CTR', 'CTR', 'CTR', 1000, 1000, 1),
(9, 9, 9, 'CTR', 'CTR', 'CTR', 'CTR', 1000, 1000, 1),
(9, 9, 10, 'CTR', 'CTR', 'CTR', 'CTR', 1000, 1000, 1),
(9, 9, 13, 'CTR', 'CTR', 'CTR', 'CTR', 1000, 1000, 1),
(9, 9, 18, 'CTR', 'CTR', 'CTR', 'CTR', 200, 200, 0),
(9, 9, 19, 'CTR', 'CTR', 'CTR', 'CTR', 7700, 8000, 1),
(9, 9, 20, 'CTR', 'CTR', 'CTR', 'CTR', 7700, 8000, 1),
(10, 4, 1, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 4, 4, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 3000, 3300, 1),
(10, 4, 5, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 800, 1100, 1),
(10, 4, 6, 'CPC', 'CPC', 'CPC', 'CPC', 1100, 1100, 1),
(10, 4, 19, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 7800, 8100, 1),
(10, 4, 20, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 7800, 8100, 1),
(10, 5, 1, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 5, 4, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 3000, 3300, 1),
(10, 5, 5, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 800, 1100, 1),
(10, 5, 6, 'CPC', 'CPC', 'CPC', 'CPC', 1100, 1100, 1),
(10, 5, 7, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 5, 8, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 5, 13, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 5, 16, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 3000, 3300, 1),
(10, 5, 19, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 7800, 8100, 1),
(10, 5, 20, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 7800, 8100, 1),
(10, 6, 1, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 6, 4, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 3000, 3300, 1),
(10, 6, 5, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 800, 1100, 1),
(10, 6, 6, 'CPC', 'CPC', 'CPC', 'CPC', 1100, 1100, 1),
(10, 6, 7, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 6, 8, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 6, 13, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 6, 16, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 3000, 3300, 1),
(10, 6, 19, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 7800, 8100, 1),
(10, 6, 20, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 7800, 8100, 1),
(10, 7, 1, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 7, 4, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 3000, 3300, 1),
(10, 7, 5, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 800, 1100, 1),
(10, 7, 6, 'CPC', 'CPC', 'CPC', 'CPC', 1100, 1100, 1),
(10, 7, 7, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 7, 8, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 7, 13, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 7, 16, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 3000, 3300, 1),
(10, 7, 19, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 7800, 8100, 1),
(10, 7, 20, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 7800, 8100, 1),
(10, 8, 1, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 8, 4, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 3000, 3300, 1),
(10, 8, 5, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 800, 1100, 1),
(10, 8, 6, 'CPC', 'CPC', 'CPC', 'CPC', 1100, 1100, 1),
(10, 8, 7, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 8, 8, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 8, 13, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 1100, 1100, 1),
(10, 8, 16, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 3000, 3300, 1),
(10, 8, 19, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 7800, 8100, 1),
(10, 8, 20, 'CPC', 'LP CPC', 'CPC', 'LP CPC', 7800, 8100, 1),
(11, 4, 1, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 4, 4, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 3200, 3400, 1),
(11, 4, 5, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1000, 1200, 1),
(11, 4, 6, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 4, 7, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 4, 8, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 4, 10, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 4, 12, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1100, 1100, 1),
(11, 4, 13, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 4, 16, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 3200, 3400, 1),
(11, 4, 19, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 8000, 8200, 1),
(11, 4, 20, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 8000, 8200, 1),
(11, 5, 1, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 5, 4, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 3200, 3400, 1),
(11, 5, 5, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1000, 1200, 1),
(11, 5, 6, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 5, 7, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 5, 8, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 5, 10, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 5, 13, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 5, 16, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 3200, 3400, 1),
(11, 5, 19, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 8000, 8200, 1),
(11, 5, 20, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 8000, 8200, 1),
(11, 6, 1, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 6, 4, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 3200, 3400, 1),
(11, 6, 5, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1000, 1200, 1),
(11, 6, 6, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 6, 7, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 6, 8, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 6, 10, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 6, 12, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1100, 1100, 1),
(11, 6, 13, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 6, 16, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 3200, 3400, 1),
(11, 6, 19, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 8000, 8200, 1),
(11, 6, 20, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 8000, 8200, 1),
(11, 7, 1, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 7, 4, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 3200, 3400, 1),
(11, 7, 5, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1000, 1200, 1),
(11, 7, 6, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 7, 7, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 7, 8, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 7, 10, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 7, 13, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 7, 16, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 3200, 3400, 1),
(11, 7, 19, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 8000, 8200, 1),
(11, 7, 20, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 8000, 8200, 1),
(11, 8, 1, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 8, 4, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 3200, 3400, 1),
(11, 8, 5, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1000, 1200, 1),
(11, 8, 6, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 8, 7, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 8, 8, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 8, 10, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 8, 13, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 8, 16, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 3200, 3400, 1),
(11, 8, 19, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 8000, 8200, 1),
(11, 8, 20, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 8000, 8200, 1),
(11, 9, 1, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 9, 4, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 3200, 3400, 1),
(11, 9, 5, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1000, 1200, 1),
(11, 9, 6, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 9, 7, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 9, 8, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 9, 9, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 9, 10, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 9, 13, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 1200, 1200, 1),
(11, 9, 19, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 8000, 8200, 1),
(11, 9, 20, 'Conversions', 'Conversions', 'Conversions', 'Conversions', 8000, 8200, 1),
(12, 4, 1, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 4, 4, 'CR', 'CR', 'CR', 'CR', 3300, 3500, 1),
(12, 4, 5, 'CR', 'CR', 'CR', 'CR', 1100, 1300, 1),
(12, 4, 6, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 4, 7, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 4, 8, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 4, 12, 'CR', 'CR', 'CR', 'CR', 1200, 1200, 1),
(12, 4, 13, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 4, 16, 'CR', 'CR', 'CR', 'CR', 3300, 3500, 1),
(12, 4, 18, 'CR', 'CR', 'CR', 'CR', 100, 100, 1),
(12, 4, 19, 'CR', 'CR', 'CR', 'CR', 8100, 8300, 1),
(12, 4, 20, 'CR', 'CR', 'CR', 'CR', 8100, 8300, 1),
(12, 5, 1, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 5, 4, 'CR', 'CR', 'CR', 'CR', 3300, 3500, 1),
(12, 5, 5, 'CR', 'CR', 'CR', 'CR', 1100, 1300, 1),
(12, 5, 6, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 5, 7, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 5, 8, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 5, 13, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 5, 16, 'CR', 'CR', 'CR', 'CR', 3300, 3500, 1),
(12, 5, 18, 'CR', 'CR', 'CR', 'CR', 100, 100, 1),
(12, 5, 19, 'CR', 'CR', 'CR', 'CR', 8100, 8300, 1),
(12, 5, 20, 'CR', 'CR', 'CR', 'CR', 8100, 8300, 1),
(12, 6, 1, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 6, 4, 'CR', 'CR', 'CR', 'CR', 3300, 3500, 1),
(12, 6, 5, 'CR', 'CR', 'CR', 'CR', 1100, 1300, 1),
(12, 6, 6, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 6, 7, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 6, 8, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 6, 12, 'CR', 'CR', 'CR', 'CR', 1200, 1200, 1),
(12, 6, 13, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 6, 16, 'CR', 'CR', 'CR', 'CR', 3300, 3500, 1),
(12, 6, 18, 'CR', 'CR', 'CR', 'CR', 100, 100, 1),
(12, 6, 19, 'CR', 'CR', 'CR', 'CR', 8100, 8300, 1),
(12, 6, 20, 'CR', 'CR', 'CR', 'CR', 8100, 8300, 1),
(12, 7, 1, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 7, 4, 'CR', 'CR', 'CR', 'CR', 3300, 3500, 1),
(12, 7, 5, 'CR', 'CR', 'CR', 'CR', 1100, 1300, 1),
(12, 7, 6, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 7, 7, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 7, 8, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 7, 13, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 7, 16, 'CR', 'CR', 'CR', 'CR', 3300, 3500, 1),
(12, 7, 18, 'CR', 'CR', 'CR', 'CR', 100, 100, 1),
(12, 7, 19, 'CR', 'CR', 'CR', 'CR', 8100, 8300, 1),
(12, 7, 20, 'CR', 'CR', 'CR', 'CR', 8100, 8300, 1),
(12, 8, 1, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 8, 4, 'CR', 'CR', 'CR', 'CR', 3300, 3500, 1),
(12, 8, 5, 'CR', 'CR', 'CR', 'CR', 1100, 1300, 1),
(12, 8, 6, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 8, 7, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 8, 8, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 8, 13, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 8, 16, 'CR', 'CR', 'CR', 'CR', 3300, 3500, 1),
(12, 8, 18, 'CR', 'CR', 'CR', 'CR', 100, 100, 1),
(12, 8, 19, 'CR', 'CR', 'CR', 'CR', 8100, 8300, 1),
(12, 8, 20, 'CR', 'CR', 'CR', 'CR', 8100, 8300, 1),
(12, 9, 1, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 9, 4, 'CR', 'CR', 'CR', 'CR', 3300, 3500, 1),
(12, 9, 5, 'CR', 'CR', 'CR', 'CR', 1100, 1300, 1),
(12, 9, 6, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 9, 7, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 9, 8, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 9, 9, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 9, 10, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 9, 13, 'CR', 'CR', 'CR', 'CR', 1300, 1300, 1),
(12, 9, 18, 'CR', 'CR', 'CR', 'CR', 100, 100, 1),
(12, 9, 19, 'CR', 'CR', 'CR', 'CR', 8100, 8300, 1),
(12, 9, 20, 'CR', 'CR', 'CR', 'CR', 8100, 8300, 1),
(13, 1, 14, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 2450, 2450, 0),
(13, 1, 17, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 2650, 2650, 1),
(13, 1, 24, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 2650, 2650, 1),
(13, 1, 25, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 2450, 2450, 0),
(13, 4, 1, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 4, 4, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 3900, 3900, 1),
(13, 4, 5, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1700, 1700, 1),
(13, 4, 6, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 4, 7, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 4, 8, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 4, 9, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1400, 1400, 1),
(13, 4, 10, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1400, 1400, 1),
(13, 4, 12, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1400, 1400, 1),
(13, 4, 13, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 4, 16, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 3900, 3900, 1),
(13, 4, 19, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 8700, 8700, 1),
(13, 4, 20, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 8700, 8700, 1),
(13, 5, 1, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 5, 4, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 3900, 3900, 1),
(13, 5, 5, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1700, 1700, 1),
(13, 5, 6, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 5, 7, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 5, 8, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 5, 9, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1400, 1400, 1),
(13, 5, 10, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1400, 1400, 1),
(13, 5, 13, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 5, 16, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 3900, 3900, 1),
(13, 5, 19, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 8700, 8700, 1),
(13, 5, 20, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 8700, 8700, 1),
(13, 6, 1, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 6, 4, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 3900, 3900, 1),
(13, 6, 5, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1700, 1700, 1),
(13, 6, 6, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 6, 7, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 6, 8, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 6, 9, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1400, 1400, 1),
(13, 6, 10, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1400, 1400, 1),
(13, 6, 12, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1400, 1400, 1),
(13, 6, 13, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 6, 16, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 3900, 3900, 1),
(13, 6, 19, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 8700, 8700, 1),
(13, 6, 20, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 8700, 8700, 1),
(13, 7, 1, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 7, 4, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 3900, 3900, 1),
(13, 7, 5, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1700, 1700, 1),
(13, 7, 6, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 7, 7, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 7, 8, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 7, 9, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1400, 1400, 1),
(13, 7, 10, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1400, 1400, 1),
(13, 7, 13, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 7, 16, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 3900, 3900, 1),
(13, 7, 19, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 8700, 8700, 1),
(13, 7, 20, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 8700, 8700, 1),
(13, 8, 1, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 8, 4, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 3900, 3900, 1),
(13, 8, 5, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1700, 1700, 1),
(13, 8, 6, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 8, 7, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 8, 8, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 8, 9, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1400, 1400, 1),
(13, 8, 10, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1400, 1400, 1),
(13, 8, 13, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 8, 16, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 3900, 3900, 1),
(13, 8, 19, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 8700, 8700, 1),
(13, 8, 20, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 8700, 8700, 1),
(13, 9, 1, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 9, 4, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 3900, 3900, 1),
(13, 9, 5, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1700, 1700, 1),
(13, 9, 6, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 9, 7, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 9, 8, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 9, 9, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 9, 10, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1400, 1400, 1),
(13, 9, 13, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 1500, 1500, 1),
(13, 9, 19, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 8700, 8700, 1),
(13, 9, 20, 'Revenue', 'Revenue', 'Revenue', 'Revenue', 8700, 8700, 1),
(14, 4, 1, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 4, 4, 'EPV', 'EPC', 'EPV', 'EPC', 4100, 4000, 1),
(14, 4, 5, 'EPV', 'EPC', 'EPV', 'EPC', 1900, 1800, 1),
(14, 4, 7, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 4, 8, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 4, 9, 'EPV', 'EPC', 'EPV', 'EPC', 1500, 1500, 1),
(14, 4, 13, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 4, 16, 'EPV', 'EPC', 'EPV', 'EPC', 4100, 4000, 1),
(14, 4, 19, 'EPV', 'EPC', 'EPV', 'EPC', 8900, 8800, 1),
(14, 4, 20, 'EPV', 'EPC', 'EPV', 'EPC', 8900, 8800, 1),
(14, 5, 1, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 5, 4, 'EPV', 'EPC', 'EPV', 'EPC', 4100, 4000, 1),
(14, 5, 5, 'EPV', 'EPC', 'EPV', 'EPC', 1900, 1800, 1),
(14, 5, 7, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 5, 8, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 5, 9, 'EPV', 'EPC', 'EPV', 'EPC', 1500, 1500, 1),
(14, 5, 10, 'EPV', 'EPC', 'EPV', 'EPC', 1500, 1500, 1),
(14, 5, 13, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 5, 16, 'EPV', 'EPC', 'EPV', 'EPC', 4100, 4000, 1),
(14, 5, 19, 'EPV', 'EPC', 'EPV', 'EPC', 8900, 8800, 1),
(14, 5, 20, 'EPV', 'EPC', 'EPV', 'EPC', 8900, 8800, 1),
(14, 6, 1, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 6, 4, 'EPV', 'EPC', 'EPV', 'EPC', 4100, 4000, 1),
(14, 6, 5, 'EPV', 'EPC', 'EPV', 'EPC', 1900, 1800, 1),
(14, 6, 7, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 6, 8, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 6, 9, 'EPV', 'EPC', 'EPV', 'EPC', 1500, 1500, 1),
(14, 6, 10, 'EPV', 'EPC', 'EPV', 'EPC', 1500, 1500, 1),
(14, 6, 13, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 6, 16, 'EPV', 'EPC', 'EPV', 'EPC', 4100, 4000, 1),
(14, 6, 19, 'EPV', 'EPC', 'EPV', 'EPC', 8900, 8800, 1),
(14, 6, 20, 'EPV', 'EPC', 'EPV', 'EPC', 8900, 8800, 1),
(14, 7, 1, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 7, 4, 'EPV', 'EPC', 'EPV', 'EPC', 4100, 4000, 1),
(14, 7, 5, 'EPV', 'EPC', 'EPV', 'EPC', 1900, 1800, 1),
(14, 7, 7, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 7, 8, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 7, 9, 'EPV', 'EPC', 'EPV', 'EPC', 1500, 1500, 1),
(14, 7, 10, 'EPV', 'EPC', 'EPV', 'EPC', 1500, 1500, 1),
(14, 7, 13, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 7, 16, 'EPV', 'EPC', 'EPV', 'EPC', 4100, 4000, 1),
(14, 7, 19, 'EPV', 'EPC', 'EPV', 'EPC', 8900, 8800, 1),
(14, 7, 20, 'EPV', 'EPC', 'EPV', 'EPC', 8900, 8800, 1),
(14, 8, 1, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 8, 4, 'EPV', 'EPC', 'EPV', 'EPC', 4100, 4000, 1),
(14, 8, 5, 'EPV', 'EPC', 'EPV', 'EPC', 1900, 1800, 1),
(14, 8, 7, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 8, 8, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 8, 9, 'EPV', 'EPC', 'EPV', 'EPC', 1500, 1500, 1),
(14, 8, 10, 'EPV', 'EPC', 'EPV', 'EPC', 1500, 1500, 1),
(14, 8, 13, 'EPV', 'EPC', 'EPV', 'EPC', 1600, 1600, 1),
(14, 8, 16, 'EPV', 'EPC', 'EPV', 'EPC', 4100, 4000, 1),
(14, 8, 19, 'EPV', 'EPC', 'EPV', 'EPC', 8900, 8800, 1),
(14, 8, 20, 'EPV', 'EPC', 'EPV', 'EPC', 8900, 8800, 1),
(15, 4, 1, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 4, 4, 'PPV', 'PPC', 'PPV', 'PPC', 4200, 4100, 1),
(15, 4, 5, 'PPV', 'PPC', 'PPV', 'PPC', 2000, 1900, 1),
(15, 4, 7, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 4, 8, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 4, 9, 'PPV', 'PPV', 'PPV', 'PPV', 1600, 1600, 1),
(15, 4, 13, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 4, 16, 'PPV', 'PPC', 'PPV', 'PPC', 4200, 4100, 1),
(15, 4, 19, 'PPV', 'PPC', 'PPV', 'PPC', 9000, 8900, 1),
(15, 4, 20, 'PPV', 'PPC', 'PPV', 'PPC', 9000, 8900, 1),
(15, 5, 1, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 5, 4, 'PPV', 'PPC', 'PPV', 'PPC', 4200, 4100, 1),
(15, 5, 5, 'PPV', 'PPC', 'PPV', 'PPC', 2000, 1900, 1),
(15, 5, 7, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 5, 8, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 5, 9, 'PPV', 'PPC', 'PPV', 'PPC', 1600, 1600, 1),
(15, 5, 10, 'PPV', 'PPC', 'PPV', 'PPC', 1600, 1600, 1),
(15, 5, 13, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 5, 16, 'PPV', 'PPC', 'PPV', 'PPC', 4200, 4100, 1),
(15, 5, 19, 'PPV', 'PPC', 'PPV', 'PPC', 9000, 8900, 1),
(15, 5, 20, 'PPV', 'PPC', 'PPV', 'PPC', 9000, 8900, 1),
(15, 6, 1, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 6, 4, 'PPV', 'PPC', 'PPV', 'PPC', 4200, 4100, 1),
(15, 6, 5, 'PPV', 'PPC', 'PPV', 'PPC', 2000, 1900, 1),
(15, 6, 7, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 6, 8, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 6, 9, 'PPV', 'PPC', 'PPV', 'PPC', 1600, 1600, 1),
(15, 6, 10, 'PPV', 'PPC', 'PPV', 'PPC', 1600, 1600, 1),
(15, 6, 13, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 6, 16, 'PPV', 'PPC', 'PPV', 'PPC', 4200, 4100, 1),
(15, 6, 19, 'PPV', 'PPC', 'PPV', 'PPC', 9000, 8900, 1),
(15, 6, 20, 'PPV', 'PPC', 'PPV', 'PPC', 9000, 8900, 1),
(15, 7, 1, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 7, 4, 'PPV', 'PPC', 'PPV', 'PPC', 4200, 4100, 1),
(15, 7, 5, 'PPV', 'PPC', 'PPV', 'PPC', 2000, 1900, 1),
(15, 7, 7, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 7, 8, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 7, 9, 'PPV', 'PPC', 'PPV', 'PPC', 1600, 1600, 1),
(15, 7, 10, 'PPV', 'PPC', 'PPV', 'PPC', 1600, 1600, 1),
(15, 7, 13, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 7, 16, 'PPV', 'PPC', 'PPV', 'PPC', 4200, 4100, 1),
(15, 7, 19, 'PPV', 'PPC', 'PPV', 'PPC', 9000, 8900, 1),
(15, 7, 20, 'PPV', 'PPC', 'PPV', 'PPC', 9000, 8900, 1),
(15, 8, 1, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 8, 4, 'PPV', 'PPC', 'PPV', 'PPC', 4200, 4100, 1),
(15, 8, 5, 'PPV', 'PPC', 'PPV', 'PPC', 2000, 1900, 1),
(15, 8, 7, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 8, 8, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 8, 9, 'PPV', 'PPC', 'PPV', 'PPC', 1600, 1600, 1),
(15, 8, 10, 'PPV', 'PPC', 'PPV', 'PPC', 1600, 1600, 1),
(15, 8, 13, 'PPV', 'PPC', 'PPV', 'PPC', 1700, 1700, 1),
(15, 8, 16, 'PPV', 'PPC', 'PPV', 'PPC', 4200, 4100, 1),
(15, 8, 19, 'PPV', 'PPC', 'PPV', 'PPC', 9000, 8900, 1),
(15, 8, 20, 'PPV', 'PPC', 'PPV', 'PPC', 9000, 8900, 1),
(16, 4, 1, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 4, 4, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 4300, 4300, 1),
(16, 4, 5, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 2100, 2100, 1),
(16, 4, 7, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 4, 8, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 4, 13, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 4, 16, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 4300, 4300, 1),
(16, 4, 19, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 9100, 9100, 1),
(16, 4, 20, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 9100, 9100, 1),
(16, 5, 1, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 5, 4, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 4300, 4300, 1),
(16, 5, 5, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 2100, 2100, 1),
(16, 5, 7, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 5, 8, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 5, 13, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 5, 16, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 4300, 4300, 1),
(16, 5, 19, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 9100, 9100, 1);
INSERT INTO `columnstypes` (`ColumnID`, `CampaignTypeID`, `ReportTypeID`, `ColumnCaption`, `ColumnCaption2`, `ColumnHeader`, `ColumnHeader2`, `ColumnIndexList`, `ColumnIndex`, `DefaultState`) VALUES
(16, 5, 20, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 9100, 9100, 1),
(16, 6, 1, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 6, 4, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 4300, 4300, 1),
(16, 6, 5, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 2100, 2100, 1),
(16, 6, 7, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 6, 8, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 6, 13, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 6, 16, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 4300, 4300, 1),
(16, 6, 19, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 9100, 9100, 1),
(16, 6, 20, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 9100, 9100, 1),
(16, 7, 1, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 7, 4, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 4300, 4300, 1),
(16, 7, 5, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 2100, 2100, 1),
(16, 7, 7, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 7, 8, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 7, 13, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 7, 16, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 4300, 4300, 1),
(16, 7, 19, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 9100, 9100, 1),
(16, 7, 20, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 9100, 9100, 1),
(16, 8, 1, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 8, 4, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 4300, 4300, 1),
(16, 8, 5, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 2100, 2100, 1),
(16, 8, 7, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 8, 8, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 8, 13, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 1900, 1900, 1),
(16, 8, 16, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 4300, 4300, 1),
(16, 8, 19, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 9100, 9100, 1),
(16, 8, 20, 'eCPM', 'eCPM', 'eCPM', 'eCPM', 9100, 9100, 1),
(17, 4, 1, 'P/L', 'P/L', 'P/L', 'P/L', 1550, 1800, 1),
(17, 4, 4, 'P/L', 'P/L', 'P/L', 'P/L', 4000, 4200, 1),
(17, 4, 5, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 2000, 1),
(17, 4, 6, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 4, 7, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 4, 8, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 4, 9, 'P/L', 'P/L', 'P/L', 'P/L', 1700, 1700, 1),
(17, 4, 10, 'P/L', 'P/L', 'P/L', 'P/L', 1450, 1700, 1),
(17, 4, 13, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 4, 16, 'P/L', 'P/L', 'P/L', 'P/L', 4000, 4200, 1),
(17, 4, 18, 'P/L', 'P/L', 'P/L', 'P/L', 300, 300, 0),
(17, 4, 19, 'P/L', 'P/L', 'P/L', 'P/L', 8800, 9000, 1),
(17, 4, 20, 'P/L', 'P/L', 'P/L', 'P/L', 8800, 9000, 1),
(17, 5, 1, 'P/L', 'P/L', 'P/L', 'P/L', 1550, 1800, 1),
(17, 5, 4, 'P/L', 'P/L', 'P/L', 'P/L', 4000, 4200, 1),
(17, 5, 5, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 2000, 1),
(17, 5, 6, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 5, 7, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 5, 8, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 5, 9, 'P/L', 'P/L', 'P/L', 'P/L', 1700, 1700, 1),
(17, 5, 10, 'P/L', 'P/L', 'P/L', 'P/L', 1450, 1700, 1),
(17, 5, 13, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 5, 16, 'P/L', 'P/L', 'P/L', 'P/L', 4000, 4200, 1),
(17, 5, 18, 'P/L', 'P/L', 'P/L', 'P/L', 300, 300, 0),
(17, 5, 19, 'P/L', 'P/L', 'P/L', 'P/L', 8800, 9000, 1),
(17, 5, 20, 'P/L', 'P/L', 'P/L', 'P/L', 8800, 9000, 1),
(17, 6, 1, 'P/L', 'P/L', 'P/L', 'P/L', 1550, 1800, 1),
(17, 6, 4, 'P/L', 'P/L', 'P/L', 'P/L', 4000, 4200, 1),
(17, 6, 5, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 2000, 1),
(17, 6, 6, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 6, 7, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 6, 8, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 6, 9, 'P/L', 'P/L', 'P/L', 'P/L', 1700, 1700, 1),
(17, 6, 10, 'P/L', 'P/L', 'P/L', 'P/L', 1450, 1700, 1),
(17, 6, 13, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 6, 16, 'P/L', 'P/L', 'P/L', 'P/L', 4000, 4200, 1),
(17, 6, 18, 'P/L', 'P/L', 'P/L', 'P/L', 300, 300, 0),
(17, 6, 19, 'P/L', 'P/L', 'P/L', 'P/L', 8800, 9000, 1),
(17, 6, 20, 'P/L', 'P/L', 'P/L', 'P/L', 8800, 9000, 1),
(17, 7, 1, 'P/L', 'P/L', 'P/L', 'P/L', 1550, 1800, 1),
(17, 7, 4, 'P/L', 'P/L', 'P/L', 'P/L', 4000, 4200, 1),
(17, 7, 5, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 2000, 1),
(17, 7, 6, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 7, 7, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 7, 8, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 7, 9, 'P/L', 'P/L', 'P/L', 'P/L', 1700, 1700, 1),
(17, 7, 10, 'P/L', 'P/L', 'P/L', 'P/L', 1450, 1700, 1),
(17, 7, 13, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 7, 16, 'P/L', 'P/L', 'P/L', 'P/L', 4000, 4200, 1),
(17, 7, 18, 'P/L', 'P/L', 'P/L', 'P/L', 300, 300, 0),
(17, 7, 19, 'P/L', 'P/L', 'P/L', 'P/L', 8800, 9000, 1),
(17, 7, 20, 'P/L', 'P/L', 'P/L', 'P/L', 8800, 9000, 1),
(17, 8, 1, 'P/L', 'P/L', 'P/L', 'P/L', 1550, 1800, 1),
(17, 8, 4, 'P/L', 'P/L', 'P/L', 'P/L', 4000, 4200, 1),
(17, 8, 5, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 2000, 1),
(17, 8, 6, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 8, 7, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 8, 8, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 8, 9, 'P/L', 'P/L', 'P/L', 'P/L', 1700, 1700, 1),
(17, 8, 10, 'P/L', 'P/L', 'P/L', 'P/L', 1450, 1700, 1),
(17, 8, 13, 'P/L', 'P/L', 'P/L', 'P/L', 1800, 1800, 1),
(17, 8, 16, 'P/L', 'P/L', 'P/L', 'P/L', 4000, 4200, 1),
(17, 8, 18, 'P/L', 'P/L', 'P/L', 'P/L', 300, 300, 0),
(17, 8, 19, 'P/L', 'P/L', 'P/L', 'P/L', 8800, 9000, 1),
(17, 8, 20, 'P/L', 'P/L', 'P/L', 'P/L', 8800, 9000, 1),
(17, 9, 18, 'P/L', 'P/L', 'P/L', 'P/L', 300, 300, 0),
(18, 4, 1, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 4, 4, 'ROI', 'ROI', 'ROI', 'ROI', 4400, 4400, 1),
(18, 4, 5, 'ROI', 'ROI', 'ROI', 'ROI', 2200, 2200, 1),
(18, 4, 6, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 4, 7, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 4, 8, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 4, 9, 'ROI', 'ROI', 'ROI', 'ROI', 1900, 1900, 1),
(18, 4, 10, 'ROI', 'ROI', 'ROI', 'ROI', 1900, 1900, 1),
(18, 4, 13, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 4, 16, 'ROI', 'ROI', 'ROI', 'ROI', 4400, 4400, 1),
(18, 4, 18, 'ROI', 'ROI', 'ROI', 'ROI', 400, 400, 0),
(18, 4, 19, 'ROI', 'ROI', 'ROI', 'ROI', 9200, 9200, 1),
(18, 4, 20, 'ROI', 'ROI', 'ROI', 'ROI', 9200, 9200, 1),
(18, 5, 1, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 5, 4, 'ROI', 'ROI', 'ROI', 'ROI', 4400, 4400, 1),
(18, 5, 5, 'ROI', 'ROI', 'ROI', 'ROI', 2200, 2200, 1),
(18, 5, 6, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 5, 7, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 5, 8, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 5, 9, 'ROI', 'ROI', 'ROI', 'ROI', 1900, 1900, 1),
(18, 5, 10, 'ROI', 'ROI', 'ROI', 'ROI', 1900, 1900, 1),
(18, 5, 13, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 5, 16, 'ROI', 'ROI', 'ROI', 'ROI', 4400, 4400, 1),
(18, 5, 18, 'ROI', 'ROI', 'ROI', 'ROI', 400, 400, 0),
(18, 5, 19, 'ROI', 'ROI', 'ROI', 'ROI', 9200, 9200, 1),
(18, 5, 20, 'ROI', 'ROI', 'ROI', 'ROI', 9200, 9200, 1),
(18, 6, 1, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 6, 4, 'ROI', 'ROI', 'ROI', 'ROI', 4400, 4400, 1),
(18, 6, 5, 'ROI', 'ROI', 'ROI', 'ROI', 2200, 2200, 1),
(18, 6, 6, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 6, 7, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 6, 8, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 6, 9, 'ROI', 'ROI', 'ROI', 'ROI', 1900, 1900, 1),
(18, 6, 10, 'ROI', 'ROI', 'ROI', 'ROI', 1900, 1900, 1),
(18, 6, 13, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 6, 16, 'ROI', 'ROI', 'ROI', 'ROI', 4400, 4400, 1),
(18, 6, 18, 'ROI', 'ROI', 'ROI', 'ROI', 400, 400, 0),
(18, 6, 19, 'ROI', 'ROI', 'ROI', 'ROI', 9200, 9200, 1),
(18, 6, 20, 'ROI', 'ROI', 'ROI', 'ROI', 9200, 9200, 1),
(18, 7, 1, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 7, 4, 'ROI', 'ROI', 'ROI', 'ROI', 4400, 4400, 1),
(18, 7, 5, 'ROI', 'ROI', 'ROI', 'ROI', 2200, 2200, 1),
(18, 7, 6, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 7, 7, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 7, 8, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 7, 9, 'ROI', 'ROI', 'ROI', 'ROI', 1900, 1900, 1),
(18, 7, 10, 'ROI', 'ROI', 'ROI', 'ROI', 1900, 1900, 1),
(18, 7, 13, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 7, 16, 'ROI', 'ROI', 'ROI', 'ROI', 4400, 4400, 1),
(18, 7, 18, 'ROI', 'ROI', 'ROI', 'ROI', 400, 400, 0),
(18, 7, 19, 'ROI', 'ROI', 'ROI', 'ROI', 9200, 9200, 1),
(18, 7, 20, 'ROI', 'ROI', 'ROI', 'ROI', 9200, 9200, 1),
(18, 8, 1, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 8, 4, 'ROI', 'ROI', 'ROI', 'ROI', 4400, 4400, 1),
(18, 8, 5, 'ROI', 'ROI', 'ROI', 'ROI', 2200, 2200, 1),
(18, 8, 6, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 8, 7, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 8, 8, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 8, 9, 'ROI', 'ROI', 'ROI', 'ROI', 1900, 1900, 1),
(18, 8, 10, 'ROI', 'ROI', 'ROI', 'ROI', 1900, 1900, 1),
(18, 8, 13, 'ROI', 'ROI', 'ROI', 'ROI', 2000, 2000, 1),
(18, 8, 16, 'ROI', 'ROI', 'ROI', 'ROI', 4400, 4400, 1),
(18, 8, 18, 'ROI', 'ROI', 'ROI', 'ROI', 400, 400, 0),
(18, 8, 19, 'ROI', 'ROI', 'ROI', 'ROI', 9200, 9200, 1),
(18, 8, 20, 'ROI', 'ROI', 'ROI', 'ROI', 9200, 9200, 1),
(18, 9, 18, 'ROI', 'ROI', 'ROI', 'ROI', 400, 400, 0),
(19, 4, 4, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 3100, 2800, 1),
(19, 4, 5, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 900, 600, 1),
(19, 4, 7, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 4, 8, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 4, 13, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 4, 16, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 3100, 2800, 1),
(19, 5, 4, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 3100, 2800, 1),
(19, 5, 5, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 900, 600, 1),
(19, 5, 7, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 5, 8, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 5, 13, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 5, 16, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 3100, 2800, 1),
(19, 6, 4, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 3100, 2800, 1),
(19, 6, 5, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 900, 600, 1),
(19, 6, 7, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 6, 8, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 6, 13, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 6, 16, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 3100, 2800, 1),
(19, 7, 4, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 3100, 2800, 1),
(19, 7, 5, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 900, 600, 1),
(19, 7, 7, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 7, 8, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 7, 13, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 7, 16, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 3100, 2800, 1),
(19, 8, 4, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 3100, 2800, 1),
(19, 8, 5, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 900, 600, 1),
(19, 8, 7, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 8, 8, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 8, 13, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 8, 16, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 3100, 2800, 1),
(19, 9, 5, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 900, 600, 1),
(19, 9, 7, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 9, 8, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(19, 9, 13, 'Engage%', 'Engage%', 'Engage%', 'Engage%', 600, 600, 1),
(20, 4, 7, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 4, 8, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 4, 13, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 5, 7, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 5, 8, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 5, 13, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 6, 7, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 6, 8, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 6, 13, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 7, 7, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 7, 8, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 7, 13, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 8, 7, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 8, 8, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 8, 13, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 9, 7, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 9, 8, ' ', ' ', ' ', ' ', 100, 100, 1),
(20, 9, 13, ' ', ' ', ' ', ' ', 100, 100, 1),
(21, 1, 14, 'Offer', 'Offer', 'Offer', 'Offer', 2500, 2500, 1),
(21, 1, 17, 'Offer', 'Offer', 'Offer', 'Offer', 2500, 2500, 1),
(21, 1, 24, 'Offer', 'Offer', 'Offer', 'Offer', 2500, 2500, 1),
(21, 1, 25, 'Offer', 'Offer', 'Offer', 'Offer', 2500, 2500, 1),
(21, 4, 4, 'Offer', 'Offer', 'Offer', 'Offer', 3700, 3700, 0),
(21, 4, 5, 'Offer', 'Offer', 'Offer', 'Offer', 1500, 1500, 0),
(21, 4, 19, 'Offer', 'Offer', 'Offer', 'Offer', 800, 800, 0),
(21, 4, 20, 'Offer', 'Offer', 'Offer', 'Offer', 800, 800, 0),
(21, 5, 4, 'Offer', 'Offer', 'Offer', 'Offer', 3700, 3700, 0),
(21, 5, 5, 'Offer', 'Offer', 'Offer', 'Offer', 1500, 1500, 0),
(21, 5, 19, 'Offer', 'Offer', 'Offer', 'Offer', 800, 800, 0),
(21, 5, 20, 'Offer', 'Offer', 'Offer', 'Offer', 800, 800, 0),
(21, 6, 4, 'Offer', 'Offer', 'Offer', 'Offer', 3700, 3700, 0),
(21, 6, 5, 'Offer', 'Offer', 'Offer', 'Offer', 1500, 1500, 0),
(21, 6, 19, 'Offer', 'Offer', 'Offer', 'Offer', 800, 800, 0),
(21, 6, 20, 'Offer', 'Offer', 'Offer', 'Offer', 800, 800, 0),
(21, 7, 4, 'Offer', 'Offer', 'Offer', 'Offer', 3700, 3700, 0),
(21, 7, 5, 'Offer', 'Offer', 'Offer', 'Offer', 1500, 1500, 0),
(21, 7, 19, 'Offer', 'Offer', 'Offer', 'Offer', 800, 800, 0),
(21, 7, 20, 'Offer', 'Offer', 'Offer', 'Offer', 800, 800, 0),
(21, 8, 4, 'Offer', 'Offer', 'Offer', 'Offer', 3700, 3700, 0),
(21, 8, 5, 'Offer', 'Offer', 'Offer', 'Offer', 1500, 1500, 0),
(21, 8, 19, 'Offer', 'Offer', 'Offer', 'Offer', 800, 800, 0),
(21, 8, 20, 'Offer', 'Offer', 'Offer', 'Offer', 800, 800, 0),
(21, 9, 4, 'Offer', 'Offer', 'Offer', 'Offer', 3700, 3700, 0),
(21, 9, 5, 'Offer', 'Offer', 'Offer', 'Offer', 1500, 1500, 0),
(21, 9, 19, 'Offer', 'Offer', 'Offer', 'Offer', 800, 800, 0),
(21, 9, 20, 'Offer', 'Offer', 'Offer', 'Offer', 800, 800, 0),
(22, 1, 14, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 2600, 2600, 0),
(22, 1, 17, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 2600, 2600, 0),
(22, 1, 24, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 2600, 2600, 0),
(22, 1, 25, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 2600, 2600, 0),
(22, 4, 4, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 3800, 3800, 0),
(22, 4, 5, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 1600, 1600, 0),
(22, 4, 19, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 900, 900, 0),
(22, 4, 20, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 900, 900, 0),
(22, 5, 4, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 3800, 3800, 0),
(22, 5, 5, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 1600, 1600, 0),
(22, 5, 19, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 900, 900, 0),
(22, 5, 20, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 900, 900, 0),
(22, 6, 4, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 3800, 3800, 0),
(22, 6, 5, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 1600, 1600, 0),
(22, 6, 19, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 900, 900, 0),
(22, 6, 20, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 900, 900, 0),
(22, 7, 4, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 3800, 3800, 0),
(22, 7, 5, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 1600, 1600, 0),
(22, 7, 19, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 900, 900, 0),
(22, 7, 20, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 900, 900, 0),
(22, 8, 4, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 3800, 3800, 0),
(22, 8, 5, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 1600, 1600, 0),
(22, 8, 19, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 900, 900, 0),
(22, 8, 20, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 900, 900, 0),
(22, 9, 4, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 3800, 3800, 0),
(22, 9, 5, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 1600, 1600, 0),
(22, 9, 19, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 900, 900, 0),
(22, 9, 20, 'Offer URL', 'Offer URL', 'Offer URL', 'Offer URL', 900, 900, 0),
(25, 9, 1, 'EPS', 'EPS', 'EPS', 'EPS', 1900, 1900, 1),
(25, 9, 4, 'EPS', 'EPS', 'EPS', 'EPS', 4100, 4100, 1),
(25, 9, 9, 'EPS', 'EPS', 'EPS', 'EPS', 1900, 1900, 1),
(25, 9, 10, 'EPS', 'EPS', 'EPS', 'EPS', 1900, 1900, 1),
(33, 9, 1, 'Email', 'Email', 'Email', 'Email', 200, 200, 1),
(33, 9, 4, 'Email', 'Email', 'Email', 'Email', 200, 200, 1),
(33, 9, 5, 'Email', 'Email', 'Email', 'Email', 150, 150, 1),
(33, 9, 6, 'Email', 'Email', 'Email', 'Email', 150, 150, 1),
(34, 4, 4, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 3440, 3320, 1),
(34, 4, 5, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 1440, 820, 1),
(34, 4, 7, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 900, 900, 1),
(34, 4, 8, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 900, 900, 1),
(34, 4, 10, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 2000, 2000, 1),
(34, 4, 13, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 900, 900, 1),
(34, 4, 16, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 3440, 3320, 1),
(34, 4, 19, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 8440, 7820, 0),
(34, 4, 20, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 8440, 7820, 0),
(34, 6, 4, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 3440, 3320, 1),
(34, 6, 5, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 1440, 820, 0),
(34, 6, 7, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 11200, 1120, 1),
(34, 6, 8, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 1120, 1120, 1),
(34, 6, 10, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 2000, 2000, 0),
(34, 6, 13, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 1120, 1120, 1),
(34, 6, 16, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 3440, 3320, 1),
(34, 6, 19, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 8440, 7820, 0),
(34, 6, 20, 'Subscribers', 'Subscribers', 'Subscribers', 'Subscribers', 8440, 7820, 0),
(35, 4, 4, 'SR', 'SR', 'SR', 'SR', 3460, 3340, 1),
(35, 4, 5, 'SR', 'SR', 'SR', 'SR', 1460, 840, 1),
(35, 4, 7, 'SR', 'SR', 'SR', 'SR', 1000, 1000, 1),
(35, 4, 8, 'SR', 'SR', 'SR', 'SR', 1000, 1000, 1),
(35, 4, 10, 'SR', 'SR', 'SR', 'SR', 2100, 2100, 1),
(35, 4, 13, 'SR', 'SR', 'SR', 'SR', 1000, 1000, 1),
(35, 4, 16, 'SR', 'SR', 'SR', 'SR', 3460, 3340, 1),
(35, 4, 18, 'SR', 'SR', 'SR', 'SR', 500, 500, 0),
(35, 4, 19, 'SR', 'SR', 'SR', 'SR', 8460, 7840, 0),
(35, 4, 20, 'SR', 'SR', 'SR', 'SR', 8460, 7840, 0),
(35, 6, 4, 'SR', 'SR', 'SR', 'SR', 3460, 3340, 1),
(35, 6, 5, 'SR', 'SR', 'SR', 'SR', 1460, 840, 0),
(35, 6, 7, 'SR', 'SR', 'SR', 'SR', 1140, 1140, 1),
(35, 6, 8, 'SR', 'SR', 'SR', 'SR', 1140, 1140, 1),
(35, 6, 10, 'SR', 'SR', 'SR', 'SR', 2100, 2100, 0),
(35, 6, 13, 'SR', 'SR', 'SR', 'SR', 1140, 1140, 1),
(35, 6, 16, 'SR', 'SR', 'SR', 'SR', 3460, 3340, 1),
(35, 6, 18, 'SR', 'SR', 'SR', 'SR', 500, 500, 0),
(35, 6, 19, 'SR', 'SR', 'SR', 'SR', 8460, 7840, 0),
(35, 6, 20, 'SR', 'SR', 'SR', 'SR', 8460, 7840, 0),
(36, 4, 4, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 3420, 3360, 1),
(36, 4, 5, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 1420, 860, 1),
(36, 4, 7, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 1100, 1100, 1),
(36, 4, 8, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 1100, 1100, 1),
(36, 4, 10, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 2200, 2200, 1),
(36, 4, 13, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 1100, 1100, 1),
(36, 4, 16, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 3420, 3360, 1),
(36, 4, 19, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 8420, 7860, 0),
(36, 4, 20, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 8420, 7860, 0),
(36, 6, 4, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 3420, 3360, 1),
(36, 6, 5, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 1420, 860, 0),
(36, 6, 7, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 1160, 1160, 1),
(36, 6, 8, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 1160, 1160, 1),
(36, 6, 10, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 2200, 2200, 0),
(36, 6, 13, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 1160, 1160, 1),
(36, 6, 16, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 3420, 3360, 1),
(36, 6, 19, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 8420, 7860, 0),
(36, 6, 20, 'CPSUB', 'CPSUB', 'CPSUB', 'CPSUB', 8420, 7860, 0),
(37, 1, 14, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 600, 600, 0),
(37, 1, 17, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 600, 600, 0),
(37, 1, 24, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 600, 600, 0),
(37, 1, 25, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 600, 600, 0),
(37, 4, 4, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 1100, 1100, 1),
(37, 4, 5, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 310, 310, 0),
(37, 4, 6, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 310, 310, 0),
(37, 4, 16, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 1100, 1100, 1),
(37, 5, 4, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 1100, 1100, 1),
(37, 5, 5, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 310, 310, 0),
(37, 5, 6, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 310, 310, 0),
(37, 5, 16, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 1100, 1100, 1),
(37, 6, 4, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 1100, 1100, 1),
(37, 6, 5, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 310, 310, 0),
(37, 6, 6, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 310, 310, 0),
(37, 6, 16, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 1100, 1100, 1),
(37, 7, 4, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 1100, 1100, 1),
(37, 7, 5, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 310, 310, 0),
(37, 7, 6, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 310, 310, 0),
(37, 7, 16, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 1100, 1100, 1),
(37, 8, 4, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 1100, 1100, 1),
(37, 8, 5, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 310, 310, 0),
(37, 8, 6, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 310, 310, 0),
(37, 8, 16, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 1100, 1100, 1),
(37, 9, 4, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 1100, 1100, 1),
(37, 9, 5, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 310, 310, 0),
(37, 9, 6, 'Extra1', 'Extra1', 'Extra1', 'Extra1', 310, 310, 0),
(38, 1, 14, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 700, 700, 0),
(38, 1, 17, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 700, 700, 0),
(38, 1, 24, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 700, 700, 0),
(38, 1, 25, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 700, 700, 0),
(38, 4, 4, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 1200, 1200, 1),
(38, 4, 5, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 320, 320, 0),
(38, 4, 6, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 320, 320, 0),
(38, 4, 16, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 1200, 1200, 1),
(38, 5, 4, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 1200, 1200, 1),
(38, 5, 5, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 320, 320, 0),
(38, 5, 6, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 320, 320, 0),
(38, 5, 16, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 1200, 1200, 1),
(38, 6, 4, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 1200, 1200, 1),
(38, 6, 5, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 320, 320, 0),
(38, 6, 6, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 320, 320, 0),
(38, 6, 16, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 1200, 1200, 1),
(38, 7, 4, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 1200, 1200, 1),
(38, 7, 5, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 320, 320, 0),
(38, 7, 6, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 320, 320, 0),
(38, 7, 16, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 1200, 1200, 1),
(38, 8, 4, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 1200, 1200, 1),
(38, 8, 5, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 320, 320, 0),
(38, 8, 6, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 320, 320, 0),
(38, 8, 16, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 1200, 1200, 1),
(38, 9, 4, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 1200, 1200, 1),
(38, 9, 5, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 320, 320, 0),
(38, 9, 6, 'Extra2', 'Extra2', 'Extra2', 'Extra2', 320, 320, 0),
(39, 1, 14, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 800, 800, 0),
(39, 1, 17, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 800, 800, 0),
(39, 1, 24, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 800, 800, 0),
(39, 1, 25, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 800, 800, 0),
(39, 4, 4, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 1300, 1300, 1),
(39, 4, 5, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 330, 330, 0),
(39, 4, 6, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 330, 330, 0),
(39, 4, 16, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 1300, 1300, 1),
(39, 5, 4, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 1300, 1300, 1),
(39, 5, 5, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 330, 330, 0),
(39, 5, 6, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 330, 330, 0),
(39, 5, 16, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 1300, 1300, 1),
(39, 6, 4, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 1300, 1300, 1),
(39, 6, 5, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 330, 330, 0),
(39, 6, 6, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 330, 330, 0),
(39, 6, 16, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 1300, 1300, 1),
(39, 7, 4, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 1300, 1300, 1),
(39, 7, 5, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 330, 330, 0),
(39, 7, 6, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 330, 330, 0),
(39, 7, 16, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 1300, 1300, 1),
(39, 8, 4, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 1300, 1300, 1),
(39, 8, 5, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 330, 330, 0),
(39, 8, 6, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 330, 330, 0),
(39, 8, 16, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 1300, 1300, 1),
(39, 9, 4, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 1300, 1300, 1),
(39, 9, 5, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 330, 330, 0),
(39, 9, 6, 'Extra3', 'Extra3', 'Extra3', 'Extra3', 330, 330, 0),
(40, 1, 14, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 900, 900, 0),
(40, 1, 17, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 900, 900, 0),
(40, 1, 24, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 900, 900, 0),
(40, 1, 25, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 900, 900, 0),
(40, 4, 4, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 1400, 1400, 1),
(40, 4, 5, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 340, 340, 0),
(40, 4, 6, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 340, 340, 0),
(40, 4, 16, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 1400, 1400, 1),
(40, 5, 4, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 1400, 1400, 1),
(40, 5, 5, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 340, 340, 0),
(40, 5, 6, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 340, 340, 0),
(40, 5, 16, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 1400, 1400, 1),
(40, 6, 4, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 1400, 1400, 1),
(40, 6, 5, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 340, 340, 0),
(40, 6, 6, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 340, 340, 0),
(40, 6, 16, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 1400, 1400, 1),
(40, 7, 4, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 1400, 1400, 1),
(40, 7, 5, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 340, 340, 0),
(40, 7, 6, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 340, 340, 0),
(40, 7, 16, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 1400, 1400, 1),
(40, 8, 4, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 1400, 1400, 1),
(40, 8, 5, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 340, 340, 0),
(40, 8, 6, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 340, 340, 0),
(40, 8, 16, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 1400, 1400, 1),
(40, 9, 4, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 1400, 1400, 1),
(40, 9, 5, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 340, 340, 0),
(40, 9, 6, 'Extra4', 'Extra4', 'Extra4', 'Extra4', 340, 340, 0),
(41, 1, 14, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1000, 1000, 0),
(41, 1, 17, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1000, 1000, 0),
(41, 1, 24, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1000, 1000, 0),
(41, 1, 25, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1000, 1000, 0),
(41, 4, 4, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1500, 1500, 1),
(41, 4, 5, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 350, 350, 0),
(41, 4, 6, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 350, 350, 0),
(41, 4, 16, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1500, 1500, 1),
(41, 5, 4, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1500, 1500, 1),
(41, 5, 5, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 350, 350, 0),
(41, 5, 6, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 350, 350, 0),
(41, 5, 16, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1500, 1500, 1),
(41, 6, 4, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1500, 1500, 1),
(41, 6, 5, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 350, 350, 0),
(41, 6, 6, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 350, 350, 0),
(41, 6, 16, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1500, 1500, 1),
(41, 7, 4, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1500, 1500, 1),
(41, 7, 5, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 350, 350, 0),
(41, 7, 6, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 350, 350, 0),
(41, 7, 16, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1500, 1500, 1),
(41, 8, 4, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1500, 1500, 1),
(41, 8, 5, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 350, 350, 0),
(41, 8, 6, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 350, 350, 0),
(41, 8, 16, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1500, 1500, 1),
(41, 9, 4, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 1500, 1500, 1),
(41, 9, 5, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 350, 350, 0),
(41, 9, 6, 'Extra5', 'Extra5', 'Extra5', 'Extra5', 350, 350, 0),
(42, 1, 14, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1100, 1100, 0),
(42, 1, 17, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1100, 1100, 0),
(42, 1, 24, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1100, 1100, 0),
(42, 1, 25, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1100, 1100, 0),
(42, 4, 4, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1600, 1600, 1),
(42, 4, 5, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 360, 360, 0),
(42, 4, 6, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 360, 360, 0),
(42, 4, 16, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1600, 1600, 1),
(42, 5, 4, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1600, 1600, 1),
(42, 5, 5, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 360, 360, 0),
(42, 5, 6, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 360, 360, 0),
(42, 5, 16, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1600, 1600, 1),
(42, 6, 4, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1600, 1600, 1),
(42, 6, 5, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 360, 360, 0),
(42, 6, 6, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 360, 360, 0),
(42, 6, 16, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1600, 1600, 1),
(42, 7, 4, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1600, 1600, 1),
(42, 7, 5, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 360, 360, 0),
(42, 7, 6, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 360, 360, 0),
(42, 7, 16, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1600, 1600, 1),
(42, 8, 4, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1600, 1600, 1),
(42, 8, 5, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 360, 360, 0),
(42, 8, 6, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 360, 360, 0),
(42, 8, 16, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1600, 1600, 1),
(42, 9, 4, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 1600, 1600, 1),
(42, 9, 5, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 360, 360, 0),
(42, 9, 6, 'Extra6', 'Extra6', 'Extra6', 'Extra6', 360, 360, 0),
(43, 1, 14, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1200, 1200, 0),
(43, 1, 17, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1200, 1200, 0),
(43, 1, 24, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1200, 1200, 0),
(43, 1, 25, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1200, 1200, 0),
(43, 4, 4, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1700, 1700, 1),
(43, 4, 5, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 370, 370, 0),
(43, 4, 6, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 370, 370, 0),
(43, 4, 16, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1700, 1700, 1),
(43, 5, 4, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1700, 1700, 1),
(43, 5, 5, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 370, 370, 0),
(43, 5, 6, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 370, 370, 0),
(43, 5, 16, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1700, 1700, 1),
(43, 6, 4, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1700, 1700, 1),
(43, 6, 5, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 370, 370, 0),
(43, 6, 6, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 370, 370, 0),
(43, 6, 16, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1700, 1700, 1),
(43, 7, 4, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1700, 1700, 1),
(43, 7, 5, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 370, 370, 0),
(43, 7, 6, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 370, 370, 0),
(43, 7, 16, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1700, 1700, 1),
(43, 8, 4, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1700, 1700, 1),
(43, 8, 5, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 370, 370, 0),
(43, 8, 6, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 370, 370, 0),
(43, 8, 16, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1700, 1700, 1),
(43, 9, 4, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 1700, 1700, 1),
(43, 9, 5, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 370, 370, 0),
(43, 9, 6, 'Extra7', 'Extra7', 'Extra7', 'Extra7', 370, 370, 0),
(44, 1, 14, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1300, 1300, 0),
(44, 1, 17, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1300, 1300, 0),
(44, 1, 24, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1300, 1300, 0),
(44, 1, 25, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1300, 1300, 0),
(44, 4, 4, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1800, 1800, 1),
(44, 4, 5, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 380, 380, 0),
(44, 4, 6, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 380, 380, 0),
(44, 4, 16, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1800, 1800, 1),
(44, 5, 4, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1800, 1800, 1),
(44, 5, 5, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 380, 380, 0),
(44, 5, 6, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 380, 380, 0),
(44, 5, 16, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1800, 1800, 1),
(44, 6, 4, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1800, 1800, 1),
(44, 6, 5, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 380, 380, 0),
(44, 6, 6, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 380, 380, 0),
(44, 6, 16, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1800, 1800, 1),
(44, 7, 4, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1800, 1800, 1),
(44, 7, 5, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 380, 380, 0),
(44, 7, 6, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 380, 380, 0),
(44, 7, 16, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1800, 1800, 1),
(44, 8, 4, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1800, 1800, 1),
(44, 8, 5, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 380, 380, 0),
(44, 8, 6, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 380, 380, 0),
(44, 8, 16, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1800, 1800, 1),
(44, 9, 4, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 1800, 1800, 1),
(44, 9, 5, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 380, 380, 0),
(44, 9, 6, 'Extra8', 'Extra8', 'Extra8', 'Extra8', 380, 380, 0),
(45, 1, 14, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1400, 1400, 0),
(45, 1, 17, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1400, 1400, 0),
(45, 1, 24, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1400, 1400, 0),
(45, 1, 25, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1400, 1400, 0),
(45, 4, 4, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1900, 1900, 1),
(45, 4, 5, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 390, 390, 0),
(45, 4, 6, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 390, 390, 0),
(45, 4, 16, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1900, 1900, 1),
(45, 5, 4, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1900, 1900, 1),
(45, 5, 5, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 390, 390, 0),
(45, 5, 6, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 390, 390, 0),
(45, 5, 16, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1900, 1900, 1),
(45, 6, 4, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1900, 1900, 1),
(45, 6, 5, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 390, 390, 0),
(45, 6, 6, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 390, 390, 0),
(45, 6, 16, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1900, 1900, 1),
(45, 7, 4, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1900, 1900, 1),
(45, 7, 5, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 390, 390, 0),
(45, 7, 6, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 390, 390, 0),
(45, 7, 16, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1900, 1900, 1),
(45, 8, 4, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1900, 1900, 1),
(45, 8, 5, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 390, 390, 0),
(45, 8, 6, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 390, 390, 0),
(45, 8, 16, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1900, 1900, 1),
(45, 9, 4, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 1900, 1900, 1),
(45, 9, 5, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 390, 390, 0),
(45, 9, 6, 'Extra9', 'Extra9', 'Extra9', 'Extra9', 390, 390, 0),
(46, 1, 14, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 1500, 1500, 0),
(46, 1, 17, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 1500, 1500, 0),
(46, 1, 24, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 1500, 1500, 0),
(46, 1, 25, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 1500, 1500, 0),
(46, 4, 4, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 2000, 2000, 1),
(46, 4, 5, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 400, 400, 0),
(46, 4, 6, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 400, 400, 0),
(46, 4, 16, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 2000, 2000, 1),
(46, 5, 4, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 2000, 2000, 1),
(46, 5, 5, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 400, 400, 0),
(46, 5, 6, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 400, 400, 0),
(46, 5, 16, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 2000, 2000, 1),
(46, 6, 4, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 2000, 2000, 1),
(46, 6, 5, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 400, 400, 0),
(46, 6, 6, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 400, 400, 0),
(46, 6, 16, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 2000, 2000, 1),
(46, 7, 4, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 2000, 2000, 1),
(46, 7, 5, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 400, 400, 0),
(46, 7, 6, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 400, 400, 0),
(46, 7, 16, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 2000, 2000, 1),
(46, 8, 4, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 2000, 2000, 1),
(46, 8, 5, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 400, 400, 0),
(46, 8, 6, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 400, 400, 0),
(46, 8, 16, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 2000, 2000, 1),
(46, 9, 4, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 2000, 2000, 1),
(46, 9, 5, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 400, 400, 0),
(46, 9, 6, 'Extra10', 'Extra10', 'Extra10', 'Extra10', 400, 400, 0),
(47, 4, 1, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 4, 4, 'CPA', 'CPA', 'CPA', 'CPA', 3400, 3600, 1),
(47, 4, 5, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 4, 6, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 4, 7, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 4, 8, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 4, 12, 'CPA', 'CPA', 'CPA', 'CPA', 1300, 1300, 1),
(47, 4, 13, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 4, 16, 'CPA', 'CPA', 'CPA', 'CPA', 3400, 3600, 1),
(47, 4, 19, 'CPA', 'CPA', 'CPA', 'CPA', 8400, 8400, 1),
(47, 4, 20, 'CPA', 'CPA', 'CPA', 'CPA', 8400, 8400, 1),
(47, 5, 1, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 5, 4, 'CPA', 'CPA', 'CPA', 'CPA', 3400, 3600, 1),
(47, 5, 5, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 5, 6, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 5, 7, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 5, 8, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 5, 13, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 5, 16, 'CPA', 'CPA', 'CPA', 'CPA', 3400, 3600, 1),
(47, 5, 19, 'CPA', 'CPA', 'CPA', 'CPA', 8400, 8400, 1),
(47, 5, 20, 'CPA', 'CPA', 'CPA', 'CPA', 8400, 8400, 1),
(47, 6, 1, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 6, 4, 'CPA', 'CPA', 'CPA', 'CPA', 3400, 3600, 1),
(47, 6, 5, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 6, 6, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 6, 7, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 6, 8, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 6, 12, 'CPA', 'CPA', 'CPA', 'CPA', 1300, 1300, 1),
(47, 6, 13, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 6, 16, 'CPA', 'CPA', 'CPA', 'CPA', 3400, 3600, 1),
(47, 6, 19, 'CPA', 'CPA', 'CPA', 'CPA', 8400, 8400, 1),
(47, 6, 20, 'CPA', 'CPA', 'CPA', 'CPA', 8400, 8400, 1),
(47, 7, 1, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 7, 4, 'CPA', 'CPA', 'CPA', 'CPA', 3400, 3600, 1),
(47, 7, 5, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 7, 6, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 7, 7, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 7, 8, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 7, 13, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 7, 16, 'CPA', 'CPA', 'CPA', 'CPA', 3400, 3600, 1),
(47, 7, 19, 'CPA', 'CPA', 'CPA', 'CPA', 8400, 8400, 1),
(47, 7, 20, 'CPA', 'CPA', 'CPA', 'CPA', 8400, 8400, 1),
(47, 8, 1, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 8, 4, 'CPA', 'CPA', 'CPA', 'CPA', 3400, 3600, 1),
(47, 8, 5, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 8, 6, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 8, 7, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 8, 8, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 8, 13, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 8, 16, 'CPA', 'CPA', 'CPA', 'CPA', 3400, 3600, 1),
(47, 8, 19, 'CPA', 'CPA', 'CPA', 'CPA', 8400, 8400, 1),
(47, 8, 20, 'CPA', 'CPA', 'CPA', 'CPA', 8400, 8400, 1),
(47, 9, 1, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 9, 4, 'CPA', 'CPA', 'CPA', 'CPA', 3400, 3600, 1),
(47, 9, 5, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 9, 6, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 9, 7, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 9, 8, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 9, 9, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 9, 10, 'CPA', 'CPA', 'CPA', 'CPA', 1500, 1500, 1),
(47, 9, 13, 'CPA', 'CPA', 'CPA', 'CPA', 1400, 1400, 1),
(47, 9, 19, 'CPA', 'CPA', 'CPA', 'CPA', 8400, 8400, 1),
(47, 9, 20, 'CPA', 'CPA', 'CPA', 'CPA', 8400, 8400, 1),
(48, 1, 14, 'Date/Time', 'Date/Time', 'Date/Time', 'Date/Time', 100, 100, 1),
(48, 1, 17, 'Visit Date', 'Visit Date', 'Visit Date', 'Visit Date', 50, 50, 0),
(48, 1, 24, 'Visit Date', 'Visit Date', 'Visit Date', 'Visit Date', 50, 50, 0),
(48, 1, 25, 'Date/Time', 'Date/Time', 'Date/Time', 'Date/Time', 100, 100, 1),
(49, 1, 14, 'Source', 'Source', 'Source', 'Source', 2650, 200, 1),
(49, 1, 15, 'Traffic Source', 'Traffic Source', 'Traffic Source', 'Traffic Source', 2000, 2000, 1),
(49, 1, 25, 'Source', 'Source', 'Source', 'Source', 2650, 200, 1),
(50, 1, 14, 'Campaign', 'Campaign', 'Campaign', 'Campaign', 400, 400, 1),
(50, 1, 17, 'Campaign', 'Campaign', 'Campaign', 'Campaign', 400, 400, 1),
(50, 1, 24, 'Campaign', 'Campaign', 'Campaign', 'Campaign', 400, 400, 1),
(50, 1, 25, 'Campaign', 'Campaign', 'Campaign', 'Campaign', 400, 400, 1),
(51, 1, 14, 'IP', 'IP', 'IP', 'IP', 1600, 1600, 1),
(51, 1, 17, 'IP', 'IP', 'IP', 'IP', 1600, 1600, 1),
(51, 1, 24, 'IP', 'IP', 'IP', 'IP', 1600, 1600, 1),
(51, 1, 25, 'IP', 'IP', 'IP', 'IP', 1600, 1600, 1),
(52, 1, 14, 'Click Date', 'Click Date', 'Click Date', 'Click Date', 1700, 1700, 0),
(52, 1, 25, 'Click Date', 'Click Date', 'Click Date', 'Click Date', 1700, 1700, 0),
(53, 1, 14, 'Click', 'Click', 'Click', 'Click', 1800, 1800, 1),
(53, 1, 25, 'Click', 'Click', 'Click', 'Click', 1800, 1800, 1),
(54, 1, 14, 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 2050, 1900, 0),
(54, 1, 17, 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 1900, 1900, 0),
(54, 1, 24, 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 1900, 1900, 0),
(54, 1, 25, 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 2050, 1900, 0),
(54, 4, 4, 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 600, 500, 0),
(54, 5, 4, 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 600, 500, 0),
(54, 6, 4, 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 600, 500, 0),
(54, 7, 4, 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 600, 500, 0),
(54, 8, 4, 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 600, 500, 0),
(54, 9, 4, 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 'Referrer-Page', 600, 500, 0),
(55, 1, 14, 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 2000, 2000, 1),
(55, 1, 17, 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 1800, 2000, 0),
(55, 1, 24, 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 1800, 2000, 0),
(55, 1, 25, 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 2000, 2000, 1),
(55, 4, 4, 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 500, 600, 0),
(55, 5, 4, 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 500, 600, 0),
(55, 6, 4, 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 500, 600, 0),
(55, 7, 4, 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 500, 600, 0),
(55, 8, 4, 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 500, 600, 0),
(55, 9, 4, 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 'Referrer-Domain', 500, 600, 0),
(56, 1, 14, 'Conversion Date', 'Conversion Date', 'Conversion Date', 'Conversion Date', 2300, 2300, 0),
(56, 1, 17, 'Conversion Date', 'Conversion Date', 'Conversion Date', 'Conversion Date', 100, 100, 1),
(56, 1, 25, 'Conversion Date', 'Conversion Date', 'Conversion Date', 'Conversion Date', 2300, 2300, 0),
(57, 1, 14, 'Conversion', 'Conversion', 'Conversion', 'Conversion', 2400, 2400, 1),
(57, 1, 25, 'Conversion', 'Conversion', 'Conversion', 'Conversion', 2400, 2400, 1),
(58, 1, 14, 'SubId', 'SubId', 'SubId', 'SubId', 2700, 2700, 1),
(58, 1, 17, 'SubId', 'SubId', 'SubId', 'SubId', 2700, 2700, 1),
(58, 1, 24, 'SubId', 'SubId', 'SubId', 'SubId', 2700, 2700, 1),
(58, 1, 25, 'SubId', 'SubId', 'SubId', 'SubId', 2700, 2700, 1),
(59, 1, 14, 'Country', 'Country', 'Country', 'Country', 2800, 2800, 1),
(59, 1, 17, 'Country', 'Country', 'Country', 'Country', 2800, 2800, 1),
(59, 1, 24, 'Country', 'Country', 'Country', 'Country', 2800, 2800, 1),
(59, 4, 19, 'Country', 'Country', 'Country', 'Country', 300, 300, 1),
(59, 5, 19, 'Country', 'Country', 'Country', 'Country', 300, 300, 1),
(59, 6, 19, 'Country', 'Country', 'Country', 'Country', 300, 300, 1),
(59, 7, 19, 'Country', 'Country', 'Country', 'Country', 300, 300, 1),
(59, 8, 19, 'Country', 'Country', 'Country', 'Country', 300, 300, 1),
(59, 9, 19, 'Country', 'Country', 'Country', 'Country', 300, 300, 1),
(60, 1, 14, 'State', 'State', 'State', 'State', 2900, 2900, 1),
(60, 1, 17, 'State', 'State', 'State', 'State', 2900, 2900, 1),
(60, 1, 24, 'State', 'State', 'State', 'State', 2900, 2900, 1),
(60, 4, 19, 'State/Region', 'State/Region', 'State/Region', 'State/Region', 200, 200, 1),
(60, 5, 19, 'State/Region', 'State/Region', 'State/Region', 'State/Region', 200, 200, 1),
(60, 6, 19, 'State/Region', 'State/Region', 'State/Region', 'State/Region', 200, 200, 1),
(60, 7, 19, 'State/Region', 'State/Region', 'State/Region', 'State/Region', 200, 200, 1),
(60, 8, 19, 'State/Region', 'State/Region', 'State/Region', 'State/Region', 200, 200, 1),
(60, 9, 19, 'State/Region', 'State/Region', 'State/Region', 'State/Region', 200, 200, 1),
(61, 1, 14, 'City', 'City', 'City', 'City', 3000, 3000, 1),
(61, 1, 17, 'City', 'City', 'City', 'City', 3000, 3000, 1),
(61, 1, 24, 'City', 'City', 'City', 'City', 3000, 3000, 1),
(61, 4, 19, 'City', 'City', 'City', 'City', 100, 100, 1),
(61, 5, 19, 'City', 'City', 'City', 'City', 100, 100, 1),
(61, 6, 19, 'City', 'City', 'City', 'City', 100, 100, 1),
(61, 7, 19, 'City', 'City', 'City', 'City', 100, 100, 1),
(61, 8, 19, 'City', 'City', 'City', 'City', 100, 100, 1),
(61, 9, 19, 'City', 'City', 'City', 'City', 100, 100, 1),
(62, 4, 5, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(62, 4, 6, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(62, 5, 5, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(62, 5, 6, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(62, 6, 5, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(62, 6, 6, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(62, 7, 5, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(62, 7, 6, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(62, 8, 5, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(62, 8, 6, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(62, 9, 5, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(62, 9, 6, 'ID', 'ID', 'ID', 'ID', 100, 100, 1),
(63, 4, 4, 'Category', 'Category', 'Category', 'Category', 700, 700, 0),
(63, 5, 4, 'Category', 'Category', 'Category', 'Category', 700, 700, 0),
(63, 6, 4, 'Category', 'Category', 'Category', 'Category', 700, 700, 0),
(63, 7, 4, 'Category', 'Category', 'Category', 'Category', 700, 700, 0),
(63, 8, 4, 'Category', 'Category', 'Category', 'Category', 700, 700, 0),
(63, 9, 4, 'Category', 'Category', 'Category', 'Category', 700, 700, 0),
(64, 1, 14, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 550, 550, 0),
(64, 1, 17, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 550, 550, 0),
(64, 1, 24, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 550, 550, 0),
(64, 1, 25, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 550, 550, 0),
(64, 4, 4, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 1),
(64, 4, 5, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 305, 305, 0),
(64, 4, 6, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 305, 305, 0),
(64, 4, 16, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 1),
(64, 4, 19, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 0),
(64, 4, 20, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 0),
(64, 5, 4, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 1),
(64, 5, 5, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 305, 305, 0),
(64, 5, 6, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 305, 305, 0),
(64, 5, 16, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 1),
(64, 5, 19, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 0),
(64, 5, 20, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 0),
(64, 6, 4, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 1),
(64, 6, 5, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 305, 305, 0),
(64, 6, 6, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 305, 305, 0),
(64, 6, 16, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 1),
(64, 6, 19, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 0),
(64, 6, 20, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 0),
(64, 7, 4, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 1),
(64, 7, 5, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 305, 305, 0),
(64, 7, 6, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 305, 305, 0),
(64, 7, 16, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 1),
(64, 7, 19, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 0),
(64, 7, 20, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 0),
(64, 8, 4, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 1),
(64, 8, 5, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 305, 305, 0),
(64, 8, 6, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 305, 305, 0),
(64, 8, 16, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 1),
(64, 8, 19, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 0),
(64, 8, 20, 'Ad/Creative', 'Ad/Creative', 'Ad', 'Ad', 1000, 1000, 0),
(65, 1, 15, 'Status', 'Status', 'Status', 'Status', 1000, 1000, 0),
(66, 1, 15, 'Group', 'Group', 'Group', 'Group', 3000, 3000, 1),
(67, 1, 15, 'Bidding', 'Bidding', 'Bidding', 'Bidding', 4000, 4000, 0);
INSERT INTO `columnstypes` (`ColumnID`, `CampaignTypeID`, `ReportTypeID`, `ColumnCaption`, `ColumnCaption2`, `ColumnHeader`, `ColumnHeader2`, `ColumnIndexList`, `ColumnIndex`, `DefaultState`) VALUES
(68, 1, 15, 'Date Added', 'Date Added', 'Date Added', 'Date Added', 5000, 5000, 1),
(69, 1, 15, 'Last Update', 'Last Update', 'Last Update', 'Last Update', 6000, 6000, 0),
(70, 4, 4, 'Day', 'Day', 'Day', 'Day', 2500, 2500, 0),
(70, 5, 4, 'Day', 'Day', 'Day', 'Day', 2500, 2500, 0),
(70, 6, 4, 'Day', 'Day', 'Day', 'Day', 2500, 2500, 0),
(70, 7, 4, 'Day', 'Day', 'Day', 'Day', 2500, 2500, 0),
(70, 8, 4, 'Day', 'Day', 'Day', 'Day', 2500, 2500, 0),
(71, 4, 4, 'Hour', 'Hour', 'Hour', 'Hour', 2600, 2600, 0),
(71, 5, 4, 'Hour', 'Hour', 'Hour', 'Hour', 2600, 2600, 0),
(71, 6, 4, 'Hour', 'Hour', 'Hour', 'Hour', 2600, 2600, 0),
(71, 7, 4, 'Hour', 'Hour', 'Hour', 'Hour', 2600, 2600, 0),
(71, 8, 4, 'Hour', 'Hour', 'Hour', 'Hour', 2600, 2600, 0),
(72, 1, 14, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 1, 17, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 1, 24, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 1, 25, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 4, 4, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 4, 19, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 4, 20, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 5, 4, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 5, 19, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 5, 20, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 6, 4, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 6, 19, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 6, 20, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 7, 4, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 7, 19, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 7, 20, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 8, 4, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 8, 19, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 8, 20, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 9, 4, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 9, 19, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(72, 9, 20, 'Device Type', 'Device Type', 'Device Type', 'Device Type', 5400, 5000, 0),
(73, 1, 14, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 1, 17, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 1, 24, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 1, 25, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 4, 4, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 4, 19, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 4, 20, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 5, 4, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 5, 19, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 5, 20, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 6, 4, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 6, 19, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 6, 20, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 7, 4, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 7, 19, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 7, 20, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 8, 4, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 8, 19, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 8, 20, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 9, 4, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 9, 19, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(73, 9, 20, 'Brand', 'Brand', 'Brand', 'Brand', 5000, 5100, 0),
(74, 1, 14, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 1, 17, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 1, 24, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 1, 25, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 4, 4, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 4, 19, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 4, 20, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 5, 4, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 5, 19, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 5, 20, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 6, 4, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 6, 19, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 6, 20, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 7, 4, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 7, 19, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 7, 20, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 8, 4, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 8, 19, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 8, 20, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 9, 4, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 9, 19, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(74, 9, 20, 'Device Name', 'Device Name', 'Device', 'Device', 5300, 5200, 0),
(75, 1, 14, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 1, 17, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 1, 24, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 1, 25, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 4, 4, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 4, 19, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 4, 20, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 5, 4, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 5, 19, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 5, 20, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 6, 4, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 6, 19, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 6, 20, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 7, 4, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 7, 19, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 7, 20, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 8, 4, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 8, 19, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 8, 20, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 9, 4, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 9, 19, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(75, 9, 20, 'Device Model', 'Device Model', 'Model', 'Model', 5200, 5300, 0),
(76, 1, 14, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 1, 17, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 1, 24, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 1, 25, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 4, 4, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 4, 19, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 4, 20, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 5, 4, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 5, 19, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 5, 20, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 6, 4, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 6, 19, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 6, 20, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 7, 4, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 7, 19, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 7, 20, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 8, 4, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 8, 19, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 8, 20, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 9, 4, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 9, 19, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(76, 9, 20, 'Market Name', 'Market Name', 'Market Name', 'Market Name', 5600, 5400, 0),
(77, 1, 14, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 1, 17, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 1, 24, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 1, 25, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 4, 4, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 4, 19, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 4, 20, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 5, 4, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 5, 19, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 5, 20, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 6, 4, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 6, 19, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 6, 20, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 7, 4, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 7, 19, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 7, 20, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 8, 4, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 8, 19, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 8, 20, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 9, 4, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 9, 19, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(77, 9, 20, 'OS', 'OS', 'OS', 'OS', 5700, 5700, 0),
(78, 1, 14, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 1, 17, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 1, 24, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 1, 25, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 4, 4, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 4, 19, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 4, 20, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 5, 4, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 5, 19, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 5, 20, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 6, 4, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 6, 19, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 6, 20, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 7, 4, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 7, 19, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 7, 20, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 8, 4, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 8, 19, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 8, 20, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 9, 4, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 9, 19, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(78, 9, 20, 'Browser', 'Browser', 'Browser', 'Browser', 6100, 5600, 0),
(79, 1, 14, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 1, 17, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 1, 24, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 1, 25, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 4, 4, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 4, 19, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 4, 20, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 5, 4, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 5, 19, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 5, 20, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 6, 4, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 6, 19, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 6, 20, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 7, 4, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 7, 19, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 7, 20, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 8, 4, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 8, 19, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 8, 20, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 9, 4, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 9, 19, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(79, 9, 20, 'Data Rate', 'Data Rate', 'Data Rate', 'Data Rate', 5100, 5760, 0),
(80, 4, 4, 'Screen Size', 'Screen Size', 'Screen Size', 'Screen Size', 5900, 5800, 0),
(80, 5, 4, 'Screen Size', 'Screen Size', 'Screen Size', 'Screen Size', 5900, 5800, 0),
(80, 6, 4, 'Screen Size', 'Screen Size', 'Screen Size', 'Screen Size', 5900, 5800, 0),
(80, 7, 4, 'Screen Size', 'Screen Size', 'Screen Size', 'Screen Size', 5900, 5800, 0),
(80, 8, 4, 'Screen Size', 'Screen Size', 'Screen Size', 'Screen Size', 5900, 5800, 0),
(80, 9, 4, 'Screen Size', 'Screen Size', 'Screen Size', 'Screen Size', 5900, 5800, 0),
(81, 1, 14, 'Screen Resolution', 'Screen Resolution', 'Screen Res.', 'Screen Res.', 5800, 5900, 0),
(81, 1, 17, 'Screen Resolution', 'Screen Resolution', 'Screen Res.', 'Screen Res.', 5800, 5900, 0),
(81, 1, 24, 'Screen Resolution', 'Screen Resolution', 'Screen Res.', 'Screen Res.', 5800, 5900, 0),
(81, 4, 4, 'Screen Resolution', 'Screen Resolution', 'Screen Res.', 'Screen Res.', 5800, 5900, 0),
(81, 5, 4, 'Screen Resolution', 'Screen Resolution', 'Screen Res.', 'Screen Res.', 5800, 5900, 0),
(81, 6, 4, 'Screen Resolution', 'Screen Resolution', 'Screen Res.', 'Screen Res.', 5800, 5900, 0),
(81, 7, 4, 'Screen Resolution', 'Screen Resolution', 'Screen Res.', 'Screen Res.', 5800, 5900, 0),
(81, 8, 4, 'Screen Resolution', 'Screen Resolution', 'Screen Res.', 'Screen Res.', 5800, 5900, 0),
(81, 9, 4, 'Screen Resolution', 'Screen Resolution', 'Screen Res.', 'Screen Res.', 5800, 5900, 0),
(82, 1, 14, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 1650, 1650, 0),
(82, 1, 17, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 1650, 1650, 0),
(82, 1, 24, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 1650, 1650, 0),
(82, 1, 25, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 1650, 1650, 0),
(82, 4, 4, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 4, 19, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 4, 20, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 5, 4, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 5, 19, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 5, 20, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 6, 4, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 6, 19, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 6, 20, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 7, 4, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 7, 19, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 7, 20, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 8, 4, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 8, 19, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 8, 20, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 9, 4, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 9, 19, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(82, 9, 20, 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 'ISP/Carrier', 5500, 6000, 0),
(83, 4, 4, 'Pointing Method', 'Pointing Method', 'Pointing', 'Pointing', 7900, 6100, 0),
(83, 5, 4, 'Pointing Method', 'Pointing Method', 'Pointing', 'Pointing', 7900, 6100, 0),
(83, 6, 4, 'Pointing Method', 'Pointing Method', 'Pointing', 'Pointing', 7900, 6100, 0),
(83, 7, 4, 'Pointing Method', 'Pointing Method', 'Pointing', 'Pointing', 7900, 6100, 0),
(83, 8, 4, 'Pointing Method', 'Pointing Method', 'Pointing', 'Pointing', 7900, 6100, 0),
(83, 9, 4, 'Pointing Method', 'Pointing Method', 'Pointing', 'Pointing', 7900, 6100, 0),
(84, 4, 4, 'Receive SMS', 'Receive SMS', 'SMS', 'SMS', 7500, 6200, 0),
(84, 5, 4, 'Receive SMS', 'Receive SMS', 'SMS', 'SMS', 7500, 6200, 0),
(84, 6, 4, 'Receive SMS', 'Receive SMS', 'SMS', 'SMS', 7500, 6200, 0),
(84, 7, 4, 'Receive SMS', 'Receive SMS', 'SMS', 'SMS', 7500, 6200, 0),
(84, 8, 4, 'Receive SMS', 'Receive SMS', 'SMS', 'SMS', 7500, 6200, 0),
(84, 9, 4, 'Receive SMS', 'Receive SMS', 'SMS', 'SMS', 7500, 6200, 0),
(85, 4, 4, 'Receive MMS', 'Receive MMS', 'MMS', 'MMS', 7300, 6300, 0),
(85, 5, 4, 'Receive MMS', 'Receive MMS', 'MMS', 'MMS', 7300, 6300, 0),
(85, 6, 4, 'Receive MMS', 'Receive MMS', 'MMS', 'MMS', 7300, 6300, 0),
(85, 7, 4, 'Receive MMS', 'Receive MMS', 'MMS', 'MMS', 7300, 6300, 0),
(85, 8, 4, 'Receive MMS', 'Receive MMS', 'MMS', 'MMS', 7300, 6300, 0),
(85, 9, 4, 'Receive MMS', 'Receive MMS', 'MMS', 'MMS', 7300, 6300, 0),
(86, 4, 4, 'PDF Support', 'PDF Support', 'PDF', 'PDF', 7200, 6400, 0),
(86, 5, 4, 'PDF Support', 'PDF Support', 'PDF', 'PDF', 7200, 6400, 0),
(86, 6, 4, 'PDF Support', 'PDF Support', 'PDF', 'PDF', 7200, 6400, 0),
(86, 7, 4, 'PDF Support', 'PDF Support', 'PDF', 'PDF', 7200, 6400, 0),
(86, 8, 4, 'PDF Support', 'PDF Support', 'PDF', 'PDF', 7200, 6400, 0),
(86, 9, 4, 'PDF Support', 'PDF Support', 'PDF', 'PDF', 7200, 6400, 0),
(87, 4, 4, 'RSS Reader', 'RSS Reader', 'RSS', 'RSS', 7600, 6500, 0),
(87, 5, 4, 'RSS Reader', 'RSS Reader', 'RSS', 'RSS', 7600, 6500, 0),
(87, 6, 4, 'RSS Reader', 'RSS Reader', 'RSS', 'RSS', 7600, 6500, 0),
(87, 7, 4, 'RSS Reader', 'RSS Reader', 'RSS', 'RSS', 7600, 6500, 0),
(87, 8, 4, 'RSS Reader', 'RSS Reader', 'RSS', 'RSS', 7600, 6500, 0),
(87, 9, 4, 'RSS Reader', 'RSS Reader', 'RSS', 'RSS', 7600, 6500, 0),
(88, 4, 4, 'Receive PUSH', 'Receive PUSH', 'PUSH', 'PUSH', 7400, 6600, 0),
(88, 5, 4, 'Receive PUSH', 'Receive PUSH', 'PUSH', 'PUSH', 7400, 6600, 0),
(88, 6, 4, 'Receive PUSH', 'Receive PUSH', 'PUSH', 'PUSH', 7400, 6600, 0),
(88, 7, 4, 'Receive PUSH', 'Receive PUSH', 'PUSH', 'PUSH', 7400, 6600, 0),
(88, 8, 4, 'Receive PUSH', 'Receive PUSH', 'PUSH', 'PUSH', 7400, 6600, 0),
(88, 9, 4, 'Receive PUSH', 'Receive PUSH', 'PUSH', 'PUSH', 7400, 6600, 0),
(89, 4, 4, 'Flash Support', 'Flash Support', 'Flash', 'Flash', 6800, 6700, 0),
(89, 5, 4, 'Flash Support', 'Flash Support', 'Flash', 'Flash', 6800, 6700, 0),
(89, 6, 4, 'Flash Support', 'Flash Support', 'Flash', 'Flash', 6800, 6700, 0),
(89, 7, 4, 'Flash Support', 'Flash Support', 'Flash', 'Flash', 6800, 6700, 0),
(89, 8, 4, 'Flash Support', 'Flash Support', 'Flash', 'Flash', 6800, 6700, 0),
(89, 9, 4, 'Flash Support', 'Flash Support', 'Flash', 'Flash', 6800, 6700, 0),
(90, 4, 4, 'Click to Call', 'Click to Call', 'ClickToCall', 'ClickToCall', 6700, 6800, 0),
(90, 5, 4, 'Click to Call', 'Click to Call', 'ClickToCall', 'ClickToCall', 6700, 6800, 0),
(90, 6, 4, 'Click to Call', 'Click to Call', 'ClickToCall', 'ClickToCall', 6700, 6800, 0),
(90, 7, 4, 'Click to Call', 'Click to Call', 'ClickToCall', 'ClickToCall', 6700, 6800, 0),
(90, 8, 4, 'Click to Call', 'Click to Call', 'ClickToCall', 'ClickToCall', 6700, 6800, 0),
(90, 9, 4, 'Click to Call', 'Click to Call', 'ClickToCall', 'ClickToCall', 6700, 6800, 0),
(91, 4, 4, 'Dual Orientation', 'Dual Orientation', 'Dual Ori.', 'Dual Ori.', 7700, 6900, 0),
(91, 5, 4, 'Dual Orientation', 'Dual Orientation', 'Dual Ori.', 'Dual Ori.', 7700, 6900, 0),
(91, 6, 4, 'Dual Orientation', 'Dual Orientation', 'Dual Ori.', 'Dual Ori.', 7700, 6900, 0),
(91, 7, 4, 'Dual Orientation', 'Dual Orientation', 'Dual Ori.', 'Dual Ori.', 7700, 6900, 0),
(91, 8, 4, 'Dual Orientation', 'Dual Orientation', 'Dual Ori.', 'Dual Ori.', 7700, 6900, 0),
(91, 9, 4, 'Dual Orientation', 'Dual Orientation', 'Dual Ori.', 'Dual Ori.', 7700, 6900, 0),
(92, 4, 4, 'QWERTY Keyboard', 'QWERTY Keyboard', 'QWERTY', 'QWERTY', 8000, 7000, 0),
(92, 5, 4, 'QWERTY Keyboard', 'QWERTY Keyboard', 'QWERTY', 'QWERTY', 8000, 7000, 0),
(92, 6, 4, 'QWERTY Keyboard', 'QWERTY Keyboard', 'QWERTY', 'QWERTY', 8000, 7000, 0),
(92, 7, 4, 'QWERTY Keyboard', 'QWERTY Keyboard', 'QWERTY', 'QWERTY', 8000, 7000, 0),
(92, 8, 4, 'QWERTY Keyboard', 'QWERTY Keyboard', 'QWERTY', 'QWERTY', 8000, 7000, 0),
(92, 9, 4, 'QWERTY Keyboard', 'QWERTY Keyboard', 'QWERTY', 'QWERTY', 8000, 7000, 0),
(93, 4, 4, 'Phone # Support', 'Phone # Support', 'Phone#', 'Phone#', 7800, 7100, 0),
(93, 5, 4, 'Phone # Support', 'Phone # Support', 'Phone#', 'Phone#', 7800, 7100, 0),
(93, 6, 4, 'Phone # Support', 'Phone # Support', 'Phone#', 'Phone#', 7800, 7100, 0),
(93, 7, 4, 'Phone # Support', 'Phone # Support', 'Phone#', 'Phone#', 7800, 7100, 0),
(93, 8, 4, 'Phone # Support', 'Phone # Support', 'Phone#', 'Phone#', 7800, 7100, 0),
(93, 9, 4, 'Phone # Support', 'Phone # Support', 'Phone#', 'Phone#', 7800, 7100, 0),
(94, 4, 4, 'Wifi Support', 'Wifi Support', 'Wifi', 'Wifi', 6000, 7200, 0),
(94, 5, 4, 'Wifi Support', 'Wifi Support', 'Wifi', 'Wifi', 6000, 7200, 0),
(94, 6, 4, 'Wifi Support', 'Wifi Support', 'Wifi', 'Wifi', 6000, 7200, 0),
(94, 7, 4, 'Wifi Support', 'Wifi Support', 'Wifi', 'Wifi', 6000, 7200, 0),
(94, 8, 4, 'Wifi Support', 'Wifi Support', 'Wifi', 'Wifi', 6000, 7200, 0),
(94, 9, 4, 'Wifi Support', 'Wifi Support', 'Wifi', 'Wifi', 6000, 7200, 0),
(95, 4, 4, 'IFrames Support', 'IFrames Support', 'IFrames', 'IFrames', 6500, 7300, 0),
(95, 5, 4, 'IFrames Support', 'IFrames Support', 'IFrames', 'IFrames', 6500, 7300, 0),
(95, 6, 4, 'IFrames Support', 'IFrames Support', 'IFrames', 'IFrames', 6500, 7300, 0),
(95, 7, 4, 'IFrames Support', 'IFrames Support', 'IFrames', 'IFrames', 6500, 7300, 0),
(95, 8, 4, 'IFrames Support', 'IFrames Support', 'IFrames', 'IFrames', 6500, 7300, 0),
(95, 9, 4, 'IFrames Support', 'IFrames Support', 'IFrames', 'IFrames', 6500, 7300, 0),
(96, 4, 4, 'Cookie Support', 'Cookie Support', 'Cookie', 'Cookie', 6200, 7400, 0),
(96, 5, 4, 'Cookie Support', 'Cookie Support', 'Cookie', 'Cookie', 6200, 7400, 0),
(96, 6, 4, 'Cookie Support', 'Cookie Support', 'Cookie', 'Cookie', 6200, 7400, 0),
(96, 7, 4, 'Cookie Support', 'Cookie Support', 'Cookie', 'Cookie', 6200, 7400, 0),
(96, 8, 4, 'Cookie Support', 'Cookie Support', 'Cookie', 'Cookie', 6200, 7400, 0),
(96, 9, 4, 'Cookie Support', 'Cookie Support', 'Cookie', 'Cookie', 6200, 7400, 0),
(97, 4, 4, '3rd Party Cookies', '3rd Party Cookies', '3rd Party', '3rd Party', 6300, 7500, 0),
(97, 5, 4, '3rd Party Cookies', '3rd Party Cookies', '3rd Party', '3rd Party', 6300, 7500, 0),
(97, 6, 4, '3rd Party Cookies', '3rd Party Cookies', '3rd Party', '3rd Party', 6300, 7500, 0),
(97, 7, 4, '3rd Party Cookies', '3rd Party Cookies', '3rd Party', '3rd Party', 6300, 7500, 0),
(97, 8, 4, '3rd Party Cookies', '3rd Party Cookies', '3rd Party', '3rd Party', 6300, 7500, 0),
(97, 9, 4, '3rd Party Cookies', '3rd Party Cookies', '3rd Party', '3rd Party', 6300, 7500, 0),
(98, 4, 4, 'Embedded Video', 'Embedded Video', 'Embed. Vid.', 'Embed. Vid.', 6400, 7600, 0),
(98, 5, 4, 'Embedded Video', 'Embedded Video', 'Embed. Vid.', 'Embed. Vid.', 6400, 7600, 0),
(98, 6, 4, 'Embedded Video', 'Embedded Video', 'Embed. Vid.', 'Embed. Vid.', 6400, 7600, 0),
(98, 7, 4, 'Embedded Video', 'Embedded Video', 'Embed. Vid.', 'Embed. Vid.', 6400, 7600, 0),
(98, 8, 4, 'Embedded Video', 'Embedded Video', 'Embed. Vid.', 'Embed. Vid.', 6400, 7600, 0),
(98, 9, 4, 'Embedded Video', 'Embedded Video', 'Embed. Vid.', 'Embed. Vid.', 6400, 7600, 0),
(99, 4, 4, 'Javascript Support', 'Javascript Support', 'JavaScript', 'JavaScript', 6600, 7700, 0),
(99, 5, 4, 'Javascript Support', 'Javascript Support', 'JavaScript', 'JavaScript', 6600, 7700, 0),
(99, 6, 4, 'Javascript Support', 'Javascript Support', 'JavaScript', 'JavaScript', 6600, 7700, 0),
(99, 7, 4, 'Javascript Support', 'Javascript Support', 'JavaScript', 'JavaScript', 6600, 7700, 0),
(99, 8, 4, 'Javascript Support', 'Javascript Support', 'JavaScript', 'JavaScript', 6600, 7700, 0),
(99, 9, 4, 'Javascript Support', 'Javascript Support', 'JavaScript', 'JavaScript', 6600, 7700, 0),
(103, 4, 4, 'MP4 Playback', 'MP4 Playback', 'MP4', 'MP4', 7100, 8200, 0),
(103, 5, 4, 'MP4 Playback', 'MP4 Playback', 'MP4', 'MP4', 7100, 8200, 0),
(103, 6, 4, 'MP4 Playback', 'MP4 Playback', 'MP4', 'MP4', 7100, 8200, 0),
(103, 7, 4, 'MP4 Playback', 'MP4 Playback', 'MP4', 'MP4', 7100, 8200, 0),
(103, 8, 4, 'MP4 Playback', 'MP4 Playback', 'MP4', 'MP4', 7100, 8200, 0),
(103, 9, 4, 'MP4 Playback', 'MP4 Playback', 'MP4', 'MP4', 7100, 8200, 0),
(104, 4, 4, 'MOV Playback', 'MOV Playback', 'MOV', 'MOV', 7000, 8100, 0),
(104, 5, 4, 'MOV Playback', 'MOV Playback', 'MOV', 'MOV', 7000, 8100, 0),
(104, 6, 4, 'MOV Playback', 'MOV Playback', 'MOV', 'MOV', 7000, 8100, 0),
(104, 7, 4, 'MOV Playback', 'MOV Playback', 'MOV', 'MOV', 7000, 8100, 0),
(104, 8, 4, 'MOV Playback', 'MOV Playback', 'MOV', 'MOV', 7000, 8100, 0),
(104, 9, 4, 'MOV Playback', 'MOV Playback', 'MOV', 'MOV', 7000, 8100, 0),
(105, 4, 4, 'FLV Playback', 'FLV Playback', 'FLV', 'FLV', 6900, 8000, 0),
(105, 5, 4, 'FLV Playback', 'FLV Playback', 'FLV', 'FLV', 6900, 8000, 0),
(105, 6, 4, 'FLV Playback', 'FLV Playback', 'FLV', 'FLV', 6900, 8000, 0),
(105, 7, 4, 'FLV Playback', 'FLV Playback', 'FLV', 'FLV', 6900, 8000, 0),
(105, 8, 4, 'FLV Playback', 'FLV Playback', 'FLV', 'FLV', 6900, 8000, 0),
(105, 9, 4, 'FLV Playback', 'FLV Playback', 'FLV', 'FLV', 6900, 8000, 0),
(106, 1, 17, 'Conversion Duration', 'Conversion Duration', 'Conversion Duration', 'Conversion Duration', 200, 200, 0),
(106, 4, 6, 'Avg. Conversion Duration', 'Avg. Conversion Duration', 'Avg. Conversion Duration', 'Avg. Conversion Duration', 500, 500, 0),
(106, 5, 6, 'Avg. Conversion Duration', 'Avg. Conversion Duration', 'Avg. Conversion Duration', 'Avg. Conversion Duration', 500, 500, 0),
(106, 6, 6, 'Avg. Conversion Duration', 'Avg. Conversion Duration', 'Avg. Conversion Duration', 'Avg. Conversion Duration', 500, 500, 0),
(106, 7, 6, 'Avg. Conversion Duration', 'Avg. Conversion Duration', 'Avg. Conversion Duration', 'Avg. Conversion Duration', 500, 500, 0),
(106, 8, 6, 'Avg. Conversion Duration', 'Avg. Conversion Duration', 'Avg. Conversion Duration', 'Avg. Conversion Duration', 500, 500, 0),
(106, 9, 6, 'Avg. Conversion Duration', 'Avg. Conversion Duration', 'Avg. Conversion Duration', 'Avg. Conversion Duration', 500, 500, 0),
(107, 1, 14, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 1, 17, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 1, 24, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 1, 25, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 4, 4, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 4, 19, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 4, 20, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 5, 4, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 5, 19, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 5, 20, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 6, 4, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 6, 19, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 6, 20, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 7, 4, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 7, 19, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 7, 20, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 8, 4, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 8, 19, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 8, 20, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 9, 4, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 9, 19, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(107, 9, 20, 'OS Version', 'OS Version', 'OS Version', 'OS Version', 5720, 5720, 0),
(108, 1, 14, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 1, 17, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 1, 24, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 1, 25, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 4, 4, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 4, 19, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 4, 20, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 5, 4, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 5, 19, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 5, 20, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 6, 4, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 6, 19, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 6, 20, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 7, 4, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 7, 19, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 7, 20, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 8, 4, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 8, 19, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 8, 20, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 9, 4, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 9, 19, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(108, 9, 20, 'Browser Version', 'Browser Version', 'Browser Version', 'Browser Version', 6120, 5620, 0),
(109, 4, 19, 'Continent', 'Continent', 'Continent', 'Continent', 400, 400, 1),
(109, 5, 19, 'Continent', 'Continent', 'Continent', 'Continent', 400, 400, 1),
(109, 6, 19, 'Continent', 'Continent', 'Continent', 'Continent', 400, 400, 1),
(109, 7, 19, 'Continent', 'Continent', 'Continent', 'Continent', 400, 400, 1),
(109, 8, 19, 'Continent', 'Continent', 'Continent', 'Continent', 400, 400, 1),
(109, 9, 19, 'Continent', 'Continent', 'Continent', 'Continent', 400, 400, 1),
(110, 1, 14, 'User Agent', 'User Agent', 'User Agent', 'User Agent', 3100, 3100, 0),
(110, 1, 17, 'User Agent', 'User Agent', 'User Agent', 'User Agent', 3100, 3100, 0),
(110, 1, 24, 'User Agent', 'User Agent', 'User Agent', 'User Agent', 3100, 3100, 0),
(110, 1, 25, 'User Agent', 'User Agent', 'User Agent', 'User Agent', 3100, 3100, 0),
(111, 6, 4, 'Deep Clicks', 'Deep Clicks', 'Deep Clicks', 'Deep Clicks', 2950, 3250, 1),
(112, 1, 14, 'TS Code', 'TS Code', 'TS Code', 'TS Code', 1550, 1550, 0),
(112, 1, 17, 'TS Code', 'TS Code', 'TS Code', 'TS Code', 1550, 1550, 0),
(112, 1, 24, 'TS Code', 'TS Code', 'TS Code', 'TS Code', 1550, 1550, 0),
(112, 1, 25, 'TS Code', 'TS Code', 'TS Code', 'TS Code', 1550, 1550, 0),
(113, 1, 14, 'Conversion Status', 'Conversion Status', 'Status', 'Status', 2710, 2710, 0),
(113, 1, 17, 'Conversion Status', 'Conversion Status', 'Status', 'Status', 2710, 2710, 0),
(113, 1, 25, 'Conversion Status', 'Conversion Status', 'Status', 'Status', 2710, 2710, 0),
(114, 1, 14, 'TransactionID', 'TransactionID', 'TransactionID', 'TransactionID', 2720, 2720, 0),
(114, 1, 17, 'TransactionID', 'TransactionID', 'TransactionID', 'TransactionID', 2720, 2720, 0),
(114, 1, 25, 'TransactionID', 'TransactionID', 'TransactionID', 'TransactionID', 2720, 2720, 0),
(115, 1, 14, 'Custom1', 'Custom1', 'Custom1', 'Custom1', 2730, 2730, 0),
(115, 1, 17, 'Custom1', 'Custom1', 'Custom1', 'Custom1', 2730, 2730, 0),
(115, 1, 25, 'Custom1', 'Custom1', 'Custom1', 'Custom1', 2730, 2730, 0),
(116, 1, 14, 'Custom2', 'Custom2', 'Custom2', 'Custom2', 2740, 2740, 0),
(116, 1, 17, 'Custom2', 'Custom2', 'Custom2', 'Custom2', 2740, 2740, 0),
(116, 1, 25, 'Custom2', 'Custom2', 'Custom2', 'Custom2', 2740, 2740, 0),
(117, 1, 14, 'Custom3', 'Custom3', 'Custom3', 'Custom3', 2750, 2750, 0),
(117, 1, 17, 'Custom3', 'Custom3', 'Custom3', 'Custom3', 2750, 2750, 0),
(117, 1, 25, 'Custom3', 'Custom3', 'Custom3', 'Custom3', 2750, 2750, 0),
(118, 1, 14, 'Custom4', 'Custom4', 'Custom4', 'Custom4', 2760, 2760, 0),
(118, 1, 17, 'Custom4', 'Custom4', 'Custom4', 'Custom4', 2760, 2760, 0),
(118, 1, 25, 'Custom4', 'Custom4', 'Custom4', 'Custom4', 2760, 2760, 0),
(119, 1, 14, 'Custom5', 'Custom5', 'Custom5', 'Custom5', 2770, 2770, 0),
(119, 1, 17, 'Custom5', 'Custom5', 'Custom5', 'Custom5', 2770, 2770, 0),
(119, 1, 25, 'Custom5', 'Custom5', 'Custom5', 'Custom5', 2770, 2770, 0),
(120, 1, 14, 'Subscribe Date', 'Subscribe Date', 'Subscribe Date', 'Subscribe Date', 2460, 2460, 0),
(120, 1, 24, 'Subscribe Date', 'Subscribe Date', 'Subscribe Date', 'Subscribe Date', 100, 100, 1),
(120, 1, 25, 'Subscribe Date', 'Subscribe Date', 'Subscribe Date', 'Subscribe Date', 2460, 2460, 0),
(121, 1, 14, 'Subscriber', 'Subscriber', 'Subscriber', 'Subscriber', 2470, 2470, 1),
(121, 1, 25, 'Subscriber', 'Subscriber', 'Subscriber', 'Subscriber', 2470, 2470, 1),
(122, 1, 24, 'Subscribe Duration', 'Subscribe Duration', 'Subscribe Duration', 'Subscribe Duration', 200, 200, 0),
(123, 1, 14, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 1502, 1502, 0),
(123, 1, 17, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 1502, 1502, 0),
(123, 1, 24, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 1502, 1502, 0),
(123, 1, 25, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 1502, 1502, 0),
(123, 4, 4, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 2010, 2010, 1),
(123, 4, 5, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 405, 405, 0),
(123, 4, 6, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 405, 405, 0),
(123, 4, 16, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 2010, 2010, 1),
(123, 5, 4, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 2010, 2010, 1),
(123, 5, 5, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 405, 405, 0),
(123, 5, 6, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 405, 405, 0),
(123, 5, 16, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 2010, 2010, 1),
(123, 6, 4, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 2010, 2010, 1),
(123, 6, 5, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 405, 405, 0),
(123, 6, 6, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 405, 405, 0),
(123, 6, 16, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 2010, 2010, 1),
(123, 7, 4, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 2010, 2010, 1),
(123, 7, 5, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 405, 405, 0),
(123, 7, 6, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 405, 405, 0),
(123, 7, 16, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 2010, 2010, 1),
(123, 8, 4, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 2010, 2010, 1),
(123, 8, 5, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 405, 405, 0),
(123, 8, 6, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 405, 405, 0),
(123, 8, 16, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 2010, 2010, 1),
(123, 9, 4, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 2010, 2010, 1),
(123, 9, 5, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 405, 405, 0),
(123, 9, 6, 'Extra11', 'Extra11', 'Extra11', 'Extra11', 405, 405, 0),
(124, 1, 14, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 1504, 1504, 0),
(124, 1, 17, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 1504, 1504, 0),
(124, 1, 24, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 1504, 1504, 0),
(124, 1, 25, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 1504, 1504, 0),
(124, 4, 4, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 2020, 2020, 1),
(124, 4, 5, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 410, 410, 0),
(124, 4, 6, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 410, 410, 0),
(124, 4, 16, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 2020, 2020, 1),
(124, 5, 4, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 2020, 2020, 1),
(124, 5, 5, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 410, 410, 0),
(124, 5, 6, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 410, 410, 0),
(124, 5, 16, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 2020, 2020, 1),
(124, 6, 4, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 2020, 2020, 1),
(124, 6, 5, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 410, 410, 0),
(124, 6, 6, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 410, 410, 0),
(124, 6, 16, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 2020, 2020, 1),
(124, 7, 4, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 2020, 2020, 1),
(124, 7, 5, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 410, 410, 0),
(124, 7, 6, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 410, 410, 0),
(124, 7, 16, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 2020, 2020, 1),
(124, 8, 4, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 2020, 2020, 1),
(124, 8, 5, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 410, 410, 0),
(124, 8, 6, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 410, 410, 0),
(124, 8, 16, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 2020, 2020, 1),
(124, 9, 4, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 2020, 2020, 1),
(124, 9, 5, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 410, 410, 0),
(124, 9, 6, 'Extra12', 'Extra12', 'Extra12', 'Extra12', 410, 410, 0),
(125, 1, 14, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 1506, 1506, 0),
(125, 1, 17, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 1506, 1506, 0),
(125, 1, 24, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 1506, 1506, 0),
(125, 1, 25, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 1506, 1506, 0),
(125, 4, 4, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 2030, 2030, 1),
(125, 4, 5, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 415, 415, 0),
(125, 4, 6, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 415, 415, 0),
(125, 4, 16, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 2030, 2030, 1),
(125, 5, 4, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 2030, 2030, 1),
(125, 5, 5, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 415, 415, 0),
(125, 5, 6, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 415, 415, 0),
(125, 5, 16, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 2030, 2030, 1),
(125, 6, 4, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 2030, 2030, 1),
(125, 6, 5, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 415, 415, 0),
(125, 6, 6, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 415, 415, 0),
(125, 6, 16, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 2030, 2030, 1),
(125, 7, 4, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 2030, 2030, 1),
(125, 7, 5, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 415, 415, 0),
(125, 7, 6, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 415, 415, 0),
(125, 7, 16, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 2030, 2030, 1),
(125, 8, 4, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 2030, 2030, 1),
(125, 8, 5, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 415, 415, 0),
(125, 8, 6, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 415, 415, 0),
(125, 8, 16, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 2030, 2030, 1),
(125, 9, 4, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 2030, 2030, 1),
(125, 9, 5, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 415, 415, 0),
(125, 9, 6, 'Extra13', 'Extra13', 'Extra13', 'Extra13', 415, 415, 0),
(126, 1, 14, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 1508, 1508, 0),
(126, 1, 17, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 1508, 1508, 0),
(126, 1, 24, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 1508, 1508, 0),
(126, 1, 25, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 1508, 1508, 0),
(126, 4, 4, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 2040, 2040, 1),
(126, 4, 5, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 420, 420, 0),
(126, 4, 6, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 420, 420, 0),
(126, 4, 16, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 2040, 2040, 1),
(126, 5, 4, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 2040, 2040, 1),
(126, 5, 5, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 420, 420, 0),
(126, 5, 6, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 420, 420, 0),
(126, 5, 16, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 2040, 2040, 1),
(126, 6, 4, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 2040, 2040, 1),
(126, 6, 5, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 420, 420, 0),
(126, 6, 6, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 420, 420, 0),
(126, 6, 16, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 2040, 2040, 1),
(126, 7, 4, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 2040, 2040, 1),
(126, 7, 5, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 420, 420, 0),
(126, 7, 6, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 420, 420, 0),
(126, 7, 16, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 2040, 2040, 1),
(126, 8, 4, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 2040, 2040, 1),
(126, 8, 5, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 420, 420, 0),
(126, 8, 6, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 420, 420, 0),
(126, 8, 16, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 2040, 2040, 1),
(126, 9, 4, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 2040, 2040, 1),
(126, 9, 5, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 420, 420, 0),
(126, 9, 6, 'Extra14', 'Extra14', 'Extra14', 'Extra14', 420, 420, 0),
(127, 1, 14, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 1510, 1510, 0),
(127, 1, 17, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 1510, 1510, 0),
(127, 1, 24, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 1510, 1510, 0),
(127, 1, 25, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 1510, 1510, 0),
(127, 4, 4, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 2050, 2050, 1),
(127, 4, 5, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 425, 425, 0),
(127, 4, 6, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 425, 425, 0),
(127, 4, 16, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 2050, 2050, 1),
(127, 5, 4, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 2050, 2050, 1),
(127, 5, 5, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 425, 425, 0),
(127, 5, 6, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 425, 425, 0),
(127, 5, 16, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 2050, 2050, 1),
(127, 6, 4, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 2050, 2050, 1),
(127, 6, 5, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 425, 425, 0),
(127, 6, 6, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 425, 425, 0),
(127, 6, 16, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 2050, 2050, 1),
(127, 7, 4, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 2050, 2050, 1),
(127, 7, 5, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 425, 425, 0),
(127, 7, 6, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 425, 425, 0),
(127, 7, 16, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 2050, 2050, 1),
(127, 8, 4, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 2050, 2050, 1),
(127, 8, 5, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 425, 425, 0),
(127, 8, 6, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 425, 425, 0),
(127, 8, 16, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 2050, 2050, 1),
(127, 9, 4, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 2050, 2050, 1),
(127, 9, 5, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 425, 425, 0),
(127, 9, 6, 'Extra15', 'Extra15', 'Extra15', 'Extra15', 425, 425, 0),
(128, 1, 14, 'Engage Date', 'Engage Date', 'Engage Date', 'Engage Date', 1690, 1690, 0),
(128, 1, 25, 'Engage Date', 'Engage Date', 'Engage Date', 'Engage Date', 1690, 1690, 0),
(129, 1, 14, 'Engage', 'Engage', 'Engage', 'Engage', 1693, 1693, 0),
(129, 1, 25, 'Engage', 'Engage', 'Engage', 'Engage', 1693, 1693, 0),
(130, 4, 1, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 0),
(130, 4, 4, 'AOV', 'AOV', 'AOV', 'AOV', 4320, 4320, 0),
(130, 4, 5, 'AOV', 'AOV', 'AOV', 'AOV', 2120, 2120, 0),
(130, 4, 6, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 0),
(130, 4, 7, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 4, 8, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 4, 10, 'AOV', 'AOV', 'AOV', 'AOV', 1820, 1820, 1),
(130, 4, 13, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 4, 16, 'AOV', 'AOV', 'AOV', 'AOV', 4320, 4320, 0),
(130, 4, 19, 'AOV', 'AOV', 'AOV', 'AOV', 9120, 9120, 0),
(130, 4, 20, 'AOV', 'AOV', 'AOV', 'AOV', 9120, 9120, 0),
(130, 5, 1, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 0),
(130, 5, 4, 'AOV', 'AOV', 'AOV', 'AOV', 4320, 4320, 0),
(130, 5, 5, 'AOV', 'AOV', 'AOV', 'AOV', 2120, 2120, 0),
(130, 5, 6, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 0),
(130, 5, 7, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 5, 8, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 5, 10, 'AOV', 'AOV', 'AOV', 'AOV', 1820, 1820, 1),
(130, 5, 13, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 5, 16, 'AOV', 'AOV', 'AOV', 'AOV', 4320, 4320, 0),
(130, 5, 19, 'AOV', 'AOV', 'AOV', 'AOV', 9120, 9120, 0),
(130, 5, 20, 'AOV', 'AOV', 'AOV', 'AOV', 9120, 9120, 0),
(130, 6, 1, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 0),
(130, 6, 4, 'AOV', 'AOV', 'AOV', 'AOV', 4320, 4320, 0),
(130, 6, 5, 'AOV', 'AOV', 'AOV', 'AOV', 2120, 2120, 0),
(130, 6, 6, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 0),
(130, 6, 7, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 6, 8, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 6, 10, 'AOV', 'AOV', 'AOV', 'AOV', 1820, 1820, 1),
(130, 6, 13, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 6, 16, 'AOV', 'AOV', 'AOV', 'AOV', 4320, 4320, 0),
(130, 6, 19, 'AOV', 'AOV', 'AOV', 'AOV', 9120, 9120, 0),
(130, 6, 20, 'AOV', 'AOV', 'AOV', 'AOV', 9120, 9120, 0),
(130, 7, 1, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 0),
(130, 7, 4, 'AOV', 'AOV', 'AOV', 'AOV', 4320, 4320, 0),
(130, 7, 5, 'AOV', 'AOV', 'AOV', 'AOV', 2120, 2120, 0),
(130, 7, 6, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 0),
(130, 7, 7, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 7, 8, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 7, 10, 'AOV', 'AOV', 'AOV', 'AOV', 1820, 1820, 1),
(130, 7, 13, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 7, 16, 'AOV', 'AOV', 'AOV', 'AOV', 4320, 4320, 0),
(130, 7, 19, 'AOV', 'AOV', 'AOV', 'AOV', 9120, 9120, 0),
(130, 7, 20, 'AOV', 'AOV', 'AOV', 'AOV', 9120, 9120, 0),
(130, 8, 1, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 0),
(130, 8, 4, 'AOV', 'AOV', 'AOV', 'AOV', 4320, 4320, 0),
(130, 8, 5, 'AOV', 'AOV', 'AOV', 'AOV', 2120, 2120, 0),
(130, 8, 6, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 0),
(130, 8, 7, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 8, 8, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 8, 10, 'AOV', 'AOV', 'AOV', 'AOV', 1820, 1820, 1),
(130, 8, 13, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 8, 16, 'AOV', 'AOV', 'AOV', 'AOV', 4320, 4320, 0),
(130, 8, 19, 'AOV', 'AOV', 'AOV', 'AOV', 9120, 9120, 0),
(130, 8, 20, 'AOV', 'AOV', 'AOV', 'AOV', 9120, 9120, 0),
(130, 9, 1, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 0),
(130, 9, 4, 'AOV', 'AOV', 'AOV', 'AOV', 4320, 4320, 0),
(130, 9, 5, 'AOV', 'AOV', 'AOV', 'AOV', 2120, 2120, 0),
(130, 9, 6, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 0),
(130, 9, 7, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 9, 8, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 9, 10, 'AOV', 'AOV', 'AOV', 'AOV', 1820, 1820, 1),
(130, 9, 13, 'AOV', 'AOV', 'AOV', 'AOV', 1920, 1920, 1),
(130, 9, 16, 'AOV', 'AOV', 'AOV', 'AOV', 4320, 4320, 0),
(130, 9, 19, 'AOV', 'AOV', 'AOV', 'AOV', 9120, 9120, 0),
(130, 9, 20, 'AOV', 'AOV', 'AOV', 'AOV', 9120, 9120, 0),
(131, 1, 14, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 1, 17, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 1, 24, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 1, 25, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 4, 4, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 4, 19, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 4, 20, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 5, 4, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 5, 19, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 5, 20, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 6, 4, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 6, 19, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 6, 20, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 7, 4, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 7, 19, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 7, 20, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0);
INSERT INTO `columnstypes` (`ColumnID`, `CampaignTypeID`, `ReportTypeID`, `ColumnCaption`, `ColumnCaption2`, `ColumnHeader`, `ColumnHeader2`, `ColumnIndexList`, `ColumnIndex`, `DefaultState`) VALUES
(131, 8, 4, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 8, 19, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 8, 20, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 9, 4, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 9, 19, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0),
(131, 9, 20, 'Browser Language', 'Browser Language', 'Browser Language', 'Browser Language', 5740, 5740, 0);

-- --------------------------------------------------------

--
-- Table structure for table `columnstypesuser`
--

CREATE TABLE `columnstypesuser` (
  `ColumnID` tinyint(3) UNSIGNED NOT NULL,
  `CampaignTypeID` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `ReportTypeID` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `UserID` smallint(5) UNSIGNED NOT NULL DEFAULT 1,
  `IsVisible` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `columnstypesuser`
--

INSERT INTO `columnstypesuser` (`ColumnID`, `CampaignTypeID`, `ReportTypeID`, `UserID`, `IsVisible`) VALUES
(1, 4, 1, 1, 1),
(1, 5, 1, 1, 1),
(1, 6, 1, 1, 1),
(1, 7, 1, 1, 1),
(1, 8, 1, 1, 1),
(1, 9, 1, 1, 1),
(4, 4, 1, 1, 1),
(4, 5, 1, 1, 1),
(4, 6, 1, 1, 1),
(4, 7, 1, 1, 1),
(4, 8, 1, 1, 1),
(5, 4, 1, 1, 1),
(5, 5, 1, 1, 1),
(5, 6, 1, 1, 1),
(5, 7, 1, 1, 1),
(5, 8, 1, 1, 1),
(5, 9, 1, 1, 1),
(6, 4, 1, 1, 1),
(6, 5, 1, 1, 1),
(6, 6, 1, 1, 1),
(6, 7, 1, 1, 1),
(6, 8, 1, 1, 1),
(7, 4, 1, 1, 1),
(7, 5, 1, 1, 1),
(7, 6, 1, 1, 1),
(7, 7, 1, 1, 1),
(7, 8, 1, 1, 1),
(8, 4, 1, 1, 1),
(8, 5, 1, 1, 1),
(8, 6, 1, 1, 1),
(8, 7, 1, 1, 1),
(8, 8, 1, 1, 1),
(8, 9, 1, 1, 1),
(9, 4, 1, 1, 1),
(9, 5, 1, 1, 1),
(9, 6, 1, 1, 1),
(9, 7, 1, 1, 1),
(9, 8, 1, 1, 1),
(9, 9, 1, 1, 1),
(10, 4, 1, 1, 1),
(10, 5, 1, 1, 1),
(10, 6, 1, 1, 1),
(10, 7, 1, 1, 1),
(10, 8, 1, 1, 1),
(11, 4, 1, 1, 1),
(11, 5, 1, 1, 1),
(11, 6, 1, 1, 1),
(11, 7, 1, 1, 1),
(11, 8, 1, 1, 1),
(11, 9, 1, 1, 1),
(12, 4, 1, 1, 1),
(12, 5, 1, 1, 1),
(12, 6, 1, 1, 1),
(12, 7, 1, 1, 1),
(12, 8, 1, 1, 1),
(12, 9, 1, 1, 1),
(13, 4, 1, 1, 1),
(13, 5, 1, 1, 1),
(13, 6, 1, 1, 1),
(13, 7, 1, 1, 1),
(13, 8, 1, 1, 1),
(13, 9, 1, 1, 1),
(14, 4, 1, 1, 1),
(14, 5, 1, 1, 1),
(14, 6, 1, 1, 1),
(14, 7, 1, 1, 1),
(14, 8, 1, 1, 1),
(15, 4, 1, 1, 1),
(15, 5, 1, 1, 1),
(15, 6, 1, 1, 1),
(15, 7, 1, 1, 1),
(15, 8, 1, 1, 1),
(16, 4, 1, 1, 1),
(16, 5, 1, 1, 1),
(16, 6, 1, 1, 1),
(16, 7, 1, 1, 1),
(16, 8, 1, 1, 1),
(17, 4, 1, 1, 1),
(17, 5, 1, 1, 1),
(17, 6, 1, 1, 1),
(17, 7, 1, 1, 1),
(17, 8, 1, 1, 1),
(18, 4, 1, 1, 1),
(18, 5, 1, 1, 1),
(18, 6, 1, 1, 1),
(18, 7, 1, 1, 1),
(18, 8, 1, 1, 1),
(25, 9, 1, 1, 1),
(33, 9, 1, 1, 1),
(47, 4, 1, 1, 1),
(47, 5, 1, 1, 1),
(47, 6, 1, 1, 1),
(47, 7, 1, 1, 1),
(47, 8, 1, 1, 1),
(47, 9, 1, 1, 1),
(1, 4, 4, 1, 1),
(1, 5, 4, 1, 1),
(1, 6, 4, 1, 1),
(1, 7, 4, 1, 1),
(1, 8, 4, 1, 1),
(1, 9, 4, 1, 1),
(4, 4, 4, 1, 1),
(4, 5, 4, 1, 1),
(4, 6, 4, 1, 1),
(4, 7, 4, 1, 1),
(4, 8, 4, 1, 1),
(5, 4, 4, 1, 1),
(5, 5, 4, 1, 1),
(5, 6, 4, 1, 1),
(5, 7, 4, 1, 1),
(5, 8, 4, 1, 1),
(5, 9, 4, 1, 1),
(6, 4, 4, 1, 1),
(6, 5, 4, 1, 1),
(6, 6, 4, 1, 1),
(6, 7, 4, 1, 1),
(6, 8, 4, 1, 1),
(7, 4, 4, 1, 1),
(7, 5, 4, 1, 1),
(7, 6, 4, 1, 1),
(7, 7, 4, 1, 1),
(7, 8, 4, 1, 1),
(8, 4, 4, 1, 1),
(8, 5, 4, 1, 1),
(8, 6, 4, 1, 1),
(8, 7, 4, 1, 1),
(8, 8, 4, 1, 1),
(8, 9, 4, 1, 1),
(9, 4, 4, 1, 1),
(9, 5, 4, 1, 1),
(9, 6, 4, 1, 1),
(9, 7, 4, 1, 1),
(9, 8, 4, 1, 1),
(9, 9, 4, 1, 1),
(10, 4, 4, 1, 1),
(10, 5, 4, 1, 1),
(10, 6, 4, 1, 1),
(10, 7, 4, 1, 1),
(10, 8, 4, 1, 1),
(11, 4, 4, 1, 1),
(11, 5, 4, 1, 1),
(11, 6, 4, 1, 1),
(11, 7, 4, 1, 1),
(11, 8, 4, 1, 1),
(11, 9, 4, 1, 1),
(12, 4, 4, 1, 1),
(12, 5, 4, 1, 1),
(12, 6, 4, 1, 1),
(12, 7, 4, 1, 1),
(12, 8, 4, 1, 1),
(12, 9, 4, 1, 1),
(13, 4, 4, 1, 1),
(13, 5, 4, 1, 1),
(13, 6, 4, 1, 1),
(13, 7, 4, 1, 1),
(13, 8, 4, 1, 1),
(13, 9, 4, 1, 1),
(14, 4, 4, 1, 1),
(14, 5, 4, 1, 1),
(14, 6, 4, 1, 1),
(14, 7, 4, 1, 1),
(14, 8, 4, 1, 1),
(15, 4, 4, 1, 1),
(15, 5, 4, 1, 1),
(15, 6, 4, 1, 1),
(15, 7, 4, 1, 1),
(15, 8, 4, 1, 1),
(16, 4, 4, 1, 1),
(16, 5, 4, 1, 1),
(16, 6, 4, 1, 1),
(16, 7, 4, 1, 1),
(16, 8, 4, 1, 1),
(17, 4, 4, 1, 1),
(17, 5, 4, 1, 1),
(17, 6, 4, 1, 1),
(17, 7, 4, 1, 1),
(17, 8, 4, 1, 1),
(18, 4, 4, 1, 1),
(18, 5, 4, 1, 1),
(18, 6, 4, 1, 1),
(18, 7, 4, 1, 1),
(18, 8, 4, 1, 1),
(19, 4, 4, 1, 1),
(19, 5, 4, 1, 1),
(19, 6, 4, 1, 1),
(19, 7, 4, 1, 1),
(19, 8, 4, 1, 1),
(25, 9, 4, 1, 1),
(33, 9, 4, 1, 1),
(34, 4, 4, 1, 1),
(34, 6, 4, 1, 1),
(35, 4, 4, 1, 1),
(35, 6, 4, 1, 1),
(36, 4, 4, 1, 1),
(36, 6, 4, 1, 1),
(37, 4, 4, 1, 1),
(37, 5, 4, 1, 1),
(37, 6, 4, 1, 1),
(37, 7, 4, 1, 1),
(37, 8, 4, 1, 1),
(37, 9, 4, 1, 1),
(38, 4, 4, 1, 1),
(38, 5, 4, 1, 1),
(38, 6, 4, 1, 1),
(38, 7, 4, 1, 1),
(38, 8, 4, 1, 1),
(38, 9, 4, 1, 1),
(39, 4, 4, 1, 1),
(39, 5, 4, 1, 1),
(39, 6, 4, 1, 1),
(39, 7, 4, 1, 1),
(39, 8, 4, 1, 1),
(39, 9, 4, 1, 1),
(40, 4, 4, 1, 1),
(40, 5, 4, 1, 1),
(40, 6, 4, 1, 1),
(40, 7, 4, 1, 1),
(40, 8, 4, 1, 1),
(40, 9, 4, 1, 1),
(41, 4, 4, 1, 1),
(41, 5, 4, 1, 1),
(41, 6, 4, 1, 1),
(41, 7, 4, 1, 1),
(41, 8, 4, 1, 1),
(41, 9, 4, 1, 1),
(42, 4, 4, 1, 1),
(42, 5, 4, 1, 1),
(42, 6, 4, 1, 1),
(42, 7, 4, 1, 1),
(42, 8, 4, 1, 1),
(42, 9, 4, 1, 1),
(43, 4, 4, 1, 1),
(43, 5, 4, 1, 1),
(43, 6, 4, 1, 1),
(43, 7, 4, 1, 1),
(43, 8, 4, 1, 1),
(43, 9, 4, 1, 1),
(44, 4, 4, 1, 1),
(44, 5, 4, 1, 1),
(44, 6, 4, 1, 1),
(44, 7, 4, 1, 1),
(44, 8, 4, 1, 1),
(44, 9, 4, 1, 1),
(45, 4, 4, 1, 1),
(45, 5, 4, 1, 1),
(45, 6, 4, 1, 1),
(45, 7, 4, 1, 1),
(45, 8, 4, 1, 1),
(45, 9, 4, 1, 1),
(46, 4, 4, 1, 1),
(46, 5, 4, 1, 1),
(46, 6, 4, 1, 1),
(46, 7, 4, 1, 1),
(46, 8, 4, 1, 1),
(46, 9, 4, 1, 1),
(47, 4, 4, 1, 1),
(47, 5, 4, 1, 1),
(47, 6, 4, 1, 1),
(47, 7, 4, 1, 1),
(47, 8, 4, 1, 1),
(47, 9, 4, 1, 1),
(64, 4, 4, 1, 1),
(64, 5, 4, 1, 1),
(64, 6, 4, 1, 1),
(64, 7, 4, 1, 1),
(64, 8, 4, 1, 1),
(111, 6, 4, 1, 1),
(2, 4, 5, 1, 1),
(2, 5, 5, 1, 1),
(2, 6, 5, 1, 1),
(2, 7, 5, 1, 1),
(2, 8, 5, 1, 1),
(2, 9, 5, 1, 1),
(5, 4, 5, 1, 1),
(5, 5, 5, 1, 1),
(5, 6, 5, 1, 1),
(5, 7, 5, 1, 1),
(5, 8, 5, 1, 1),
(5, 9, 5, 1, 1),
(6, 4, 5, 1, 1),
(6, 5, 5, 1, 1),
(6, 6, 5, 1, 1),
(6, 7, 5, 1, 1),
(6, 8, 5, 1, 1),
(7, 4, 5, 1, 1),
(7, 5, 5, 1, 1),
(7, 6, 5, 1, 1),
(7, 7, 5, 1, 1),
(7, 8, 5, 1, 1),
(8, 4, 5, 1, 1),
(8, 5, 5, 1, 1),
(8, 6, 5, 1, 1),
(8, 7, 5, 1, 1),
(8, 8, 5, 1, 1),
(8, 9, 5, 1, 1),
(9, 4, 5, 1, 1),
(9, 5, 5, 1, 1),
(9, 6, 5, 1, 1),
(9, 7, 5, 1, 1),
(9, 8, 5, 1, 1),
(9, 9, 5, 1, 1),
(10, 4, 5, 1, 1),
(10, 5, 5, 1, 1),
(10, 6, 5, 1, 1),
(10, 7, 5, 1, 1),
(10, 8, 5, 1, 1),
(11, 4, 5, 1, 1),
(11, 5, 5, 1, 1),
(11, 6, 5, 1, 1),
(11, 7, 5, 1, 1),
(11, 8, 5, 1, 1),
(11, 9, 5, 1, 1),
(12, 4, 5, 1, 1),
(12, 5, 5, 1, 1),
(12, 6, 5, 1, 1),
(12, 7, 5, 1, 1),
(12, 8, 5, 1, 1),
(12, 9, 5, 1, 1),
(13, 4, 5, 1, 1),
(13, 5, 5, 1, 1),
(13, 6, 5, 1, 1),
(13, 7, 5, 1, 1),
(13, 8, 5, 1, 1),
(13, 9, 5, 1, 1),
(14, 4, 5, 1, 1),
(14, 5, 5, 1, 1),
(14, 6, 5, 1, 1),
(14, 7, 5, 1, 1),
(14, 8, 5, 1, 1),
(15, 4, 5, 1, 1),
(15, 5, 5, 1, 1),
(15, 6, 5, 1, 1),
(15, 7, 5, 1, 1),
(15, 8, 5, 1, 1),
(16, 4, 5, 1, 1),
(16, 5, 5, 1, 1),
(16, 6, 5, 1, 1),
(16, 7, 5, 1, 1),
(16, 8, 5, 1, 1),
(17, 4, 5, 1, 1),
(17, 5, 5, 1, 1),
(17, 6, 5, 1, 1),
(17, 7, 5, 1, 1),
(17, 8, 5, 1, 1),
(18, 4, 5, 1, 1),
(18, 5, 5, 1, 1),
(18, 6, 5, 1, 1),
(18, 7, 5, 1, 1),
(18, 8, 5, 1, 1),
(19, 4, 5, 1, 1),
(19, 5, 5, 1, 1),
(19, 6, 5, 1, 1),
(19, 7, 5, 1, 1),
(19, 8, 5, 1, 1),
(19, 9, 5, 1, 1),
(33, 9, 5, 1, 1),
(34, 4, 5, 1, 1),
(35, 4, 5, 1, 1),
(36, 4, 5, 1, 1),
(47, 4, 5, 1, 1),
(47, 5, 5, 1, 1),
(47, 6, 5, 1, 1),
(47, 7, 5, 1, 1),
(47, 8, 5, 1, 1),
(47, 9, 5, 1, 1),
(62, 4, 5, 1, 1),
(62, 5, 5, 1, 1),
(62, 6, 5, 1, 1),
(62, 7, 5, 1, 1),
(62, 8, 5, 1, 1),
(62, 9, 5, 1, 1),
(2, 4, 6, 1, 1),
(2, 5, 6, 1, 1),
(2, 6, 6, 1, 1),
(2, 7, 6, 1, 1),
(2, 8, 6, 1, 1),
(2, 9, 6, 1, 1),
(6, 4, 6, 1, 1),
(6, 5, 6, 1, 1),
(6, 6, 6, 1, 1),
(6, 7, 6, 1, 1),
(6, 8, 6, 1, 1),
(8, 4, 6, 1, 1),
(8, 5, 6, 1, 1),
(8, 6, 6, 1, 1),
(8, 7, 6, 1, 1),
(8, 8, 6, 1, 1),
(8, 9, 6, 1, 1),
(10, 4, 6, 1, 1),
(10, 5, 6, 1, 1),
(10, 6, 6, 1, 1),
(10, 7, 6, 1, 1),
(10, 8, 6, 1, 1),
(11, 4, 6, 1, 1),
(11, 5, 6, 1, 1),
(11, 6, 6, 1, 1),
(11, 7, 6, 1, 1),
(11, 8, 6, 1, 1),
(11, 9, 6, 1, 1),
(12, 4, 6, 1, 1),
(12, 5, 6, 1, 1),
(12, 6, 6, 1, 1),
(12, 7, 6, 1, 1),
(12, 8, 6, 1, 1),
(12, 9, 6, 1, 1),
(13, 4, 6, 1, 1),
(13, 5, 6, 1, 1),
(13, 6, 6, 1, 1),
(13, 7, 6, 1, 1),
(13, 8, 6, 1, 1),
(13, 9, 6, 1, 1),
(17, 4, 6, 1, 1),
(17, 5, 6, 1, 1),
(17, 6, 6, 1, 1),
(17, 7, 6, 1, 1),
(17, 8, 6, 1, 1),
(18, 4, 6, 1, 1),
(18, 5, 6, 1, 1),
(18, 6, 6, 1, 1),
(18, 7, 6, 1, 1),
(18, 8, 6, 1, 1),
(33, 9, 6, 1, 1),
(47, 4, 6, 1, 1),
(47, 5, 6, 1, 1),
(47, 6, 6, 1, 1),
(47, 7, 6, 1, 1),
(47, 8, 6, 1, 1),
(47, 9, 6, 1, 1),
(62, 4, 6, 1, 1),
(62, 5, 6, 1, 1),
(62, 6, 6, 1, 1),
(62, 7, 6, 1, 1),
(62, 8, 6, 1, 1),
(62, 9, 6, 1, 1),
(5, 4, 7, 1, 1),
(5, 5, 7, 1, 1),
(5, 6, 7, 1, 1),
(5, 7, 7, 1, 1),
(5, 8, 7, 1, 1),
(5, 9, 7, 1, 1),
(6, 4, 7, 1, 1),
(6, 5, 7, 1, 1),
(6, 6, 7, 1, 1),
(6, 7, 7, 1, 1),
(6, 8, 7, 1, 1),
(7, 4, 7, 1, 1),
(7, 5, 7, 1, 1),
(7, 6, 7, 1, 1),
(7, 7, 7, 1, 1),
(7, 8, 7, 1, 1),
(8, 5, 7, 1, 1),
(8, 6, 7, 1, 1),
(8, 7, 7, 1, 1),
(8, 8, 7, 1, 1),
(8, 9, 7, 1, 1),
(9, 5, 7, 1, 1),
(9, 6, 7, 1, 1),
(9, 7, 7, 1, 1),
(9, 8, 7, 1, 1),
(9, 9, 7, 1, 1),
(10, 5, 7, 1, 1),
(10, 6, 7, 1, 1),
(10, 7, 7, 1, 1),
(10, 8, 7, 1, 1),
(11, 4, 7, 1, 1),
(11, 5, 7, 1, 1),
(11, 6, 7, 1, 1),
(11, 7, 7, 1, 1),
(11, 8, 7, 1, 1),
(11, 9, 7, 1, 1),
(12, 4, 7, 1, 1),
(12, 5, 7, 1, 1),
(12, 6, 7, 1, 1),
(12, 7, 7, 1, 1),
(12, 8, 7, 1, 1),
(12, 9, 7, 1, 1),
(13, 4, 7, 1, 1),
(13, 5, 7, 1, 1),
(13, 6, 7, 1, 1),
(13, 7, 7, 1, 1),
(13, 8, 7, 1, 1),
(13, 9, 7, 1, 1),
(14, 4, 7, 1, 1),
(14, 5, 7, 1, 1),
(14, 6, 7, 1, 1),
(14, 7, 7, 1, 1),
(14, 8, 7, 1, 1),
(15, 4, 7, 1, 1),
(15, 5, 7, 1, 1),
(15, 6, 7, 1, 1),
(15, 7, 7, 1, 1),
(15, 8, 7, 1, 1),
(16, 4, 7, 1, 1),
(16, 5, 7, 1, 1),
(16, 6, 7, 1, 1),
(16, 7, 7, 1, 1),
(16, 8, 7, 1, 1),
(17, 4, 7, 1, 1),
(17, 5, 7, 1, 1),
(17, 6, 7, 1, 1),
(17, 7, 7, 1, 1),
(17, 8, 7, 1, 1),
(18, 4, 7, 1, 1),
(18, 5, 7, 1, 1),
(18, 6, 7, 1, 1),
(18, 7, 7, 1, 1),
(18, 8, 7, 1, 1),
(19, 4, 7, 1, 1),
(19, 5, 7, 1, 1),
(19, 6, 7, 1, 1),
(19, 7, 7, 1, 1),
(19, 8, 7, 1, 1),
(19, 9, 7, 1, 1),
(20, 4, 7, 1, 1),
(20, 5, 7, 1, 1),
(20, 6, 7, 1, 1),
(20, 7, 7, 1, 1),
(20, 8, 7, 1, 1),
(20, 9, 7, 1, 1),
(34, 4, 7, 1, 1),
(34, 6, 7, 1, 1),
(35, 4, 7, 1, 1),
(35, 6, 7, 1, 1),
(36, 4, 7, 1, 1),
(36, 6, 7, 1, 1),
(47, 4, 7, 1, 1),
(47, 5, 7, 1, 1),
(47, 6, 7, 1, 1),
(47, 7, 7, 1, 1),
(47, 8, 7, 1, 1),
(47, 9, 7, 1, 1),
(130, 4, 7, 1, 1),
(130, 5, 7, 1, 1),
(130, 6, 7, 1, 1),
(130, 7, 7, 1, 1),
(130, 8, 7, 1, 1),
(130, 9, 7, 1, 1),
(5, 4, 8, 1, 1),
(5, 5, 8, 1, 1),
(5, 6, 8, 1, 1),
(5, 7, 8, 1, 1),
(5, 8, 8, 1, 1),
(5, 9, 8, 1, 1),
(6, 4, 8, 1, 1),
(6, 5, 8, 1, 1),
(6, 6, 8, 1, 1),
(6, 7, 8, 1, 1),
(6, 8, 8, 1, 1),
(7, 4, 8, 1, 1),
(7, 5, 8, 1, 1),
(7, 6, 8, 1, 1),
(7, 7, 8, 1, 1),
(7, 8, 8, 1, 1),
(8, 5, 8, 1, 1),
(8, 6, 8, 1, 1),
(8, 7, 8, 1, 1),
(8, 8, 8, 1, 1),
(8, 9, 8, 1, 1),
(9, 5, 8, 1, 1),
(9, 6, 8, 1, 1),
(9, 7, 8, 1, 1),
(9, 8, 8, 1, 1),
(9, 9, 8, 1, 1),
(10, 5, 8, 1, 1),
(10, 6, 8, 1, 1),
(10, 7, 8, 1, 1),
(10, 8, 8, 1, 1),
(11, 4, 8, 1, 1),
(11, 5, 8, 1, 1),
(11, 6, 8, 1, 1),
(11, 7, 8, 1, 1),
(11, 8, 8, 1, 1),
(11, 9, 8, 1, 1),
(12, 4, 8, 1, 1),
(12, 5, 8, 1, 1),
(12, 6, 8, 1, 1),
(12, 7, 8, 1, 1),
(12, 8, 8, 1, 1),
(12, 9, 8, 1, 1),
(13, 4, 8, 1, 1),
(13, 5, 8, 1, 1),
(13, 6, 8, 1, 1),
(13, 7, 8, 1, 1),
(13, 8, 8, 1, 1),
(13, 9, 8, 1, 1),
(14, 4, 8, 1, 1),
(14, 5, 8, 1, 1),
(14, 6, 8, 1, 1),
(14, 7, 8, 1, 1),
(14, 8, 8, 1, 1),
(15, 4, 8, 1, 1),
(15, 5, 8, 1, 1),
(15, 6, 8, 1, 1),
(15, 7, 8, 1, 1),
(15, 8, 8, 1, 1),
(16, 4, 8, 1, 1),
(16, 5, 8, 1, 1),
(16, 6, 8, 1, 1),
(16, 7, 8, 1, 1),
(16, 8, 8, 1, 1),
(17, 4, 8, 1, 1),
(17, 5, 8, 1, 1),
(17, 6, 8, 1, 1),
(17, 7, 8, 1, 1),
(17, 8, 8, 1, 1),
(18, 4, 8, 1, 1),
(18, 5, 8, 1, 1),
(18, 6, 8, 1, 1),
(18, 7, 8, 1, 1),
(18, 8, 8, 1, 1),
(19, 4, 8, 1, 1),
(19, 5, 8, 1, 1),
(19, 6, 8, 1, 1),
(19, 7, 8, 1, 1),
(19, 8, 8, 1, 1),
(19, 9, 8, 1, 1),
(20, 4, 8, 1, 1),
(20, 5, 8, 1, 1),
(20, 6, 8, 1, 1),
(20, 7, 8, 1, 1),
(20, 8, 8, 1, 1),
(20, 9, 8, 1, 1),
(34, 4, 8, 1, 1),
(34, 6, 8, 1, 1),
(35, 4, 8, 1, 1),
(35, 6, 8, 1, 1),
(36, 4, 8, 1, 1),
(36, 6, 8, 1, 1),
(47, 4, 8, 1, 1),
(47, 5, 8, 1, 1),
(47, 6, 8, 1, 1),
(47, 7, 8, 1, 1),
(47, 8, 8, 1, 1),
(47, 9, 8, 1, 1),
(130, 4, 8, 1, 1),
(130, 5, 8, 1, 1),
(130, 6, 8, 1, 1),
(130, 7, 8, 1, 1),
(130, 8, 8, 1, 1),
(130, 9, 8, 1, 1),
(1, 4, 9, 1, 1),
(1, 5, 9, 1, 1),
(1, 6, 9, 1, 1),
(1, 7, 9, 1, 1),
(1, 8, 9, 1, 1),
(1, 9, 9, 1, 1),
(2, 4, 9, 1, 1),
(2, 5, 9, 1, 1),
(2, 6, 9, 1, 1),
(2, 7, 9, 1, 1),
(2, 8, 9, 1, 1),
(2, 9, 9, 1, 1),
(5, 4, 9, 1, 1),
(5, 5, 9, 1, 1),
(5, 6, 9, 1, 1),
(5, 7, 9, 1, 1),
(5, 8, 9, 1, 1),
(5, 9, 9, 1, 1),
(6, 4, 9, 1, 1),
(6, 5, 9, 1, 1),
(6, 6, 9, 1, 1),
(6, 7, 9, 1, 1),
(6, 8, 9, 1, 1),
(8, 9, 9, 1, 1),
(9, 9, 9, 1, 1),
(11, 9, 9, 1, 1),
(12, 9, 9, 1, 1),
(13, 4, 9, 1, 1),
(13, 5, 9, 1, 1),
(13, 6, 9, 1, 1),
(13, 7, 9, 1, 1),
(13, 8, 9, 1, 1),
(13, 9, 9, 1, 1),
(14, 4, 9, 1, 1),
(14, 5, 9, 1, 1),
(14, 6, 9, 1, 1),
(14, 7, 9, 1, 1),
(14, 8, 9, 1, 1),
(15, 4, 9, 1, 1),
(15, 5, 9, 1, 1),
(15, 6, 9, 1, 1),
(15, 7, 9, 1, 1),
(15, 8, 9, 1, 1),
(17, 4, 9, 1, 1),
(17, 5, 9, 1, 1),
(17, 6, 9, 1, 1),
(17, 7, 9, 1, 1),
(17, 8, 9, 1, 1),
(18, 4, 9, 1, 1),
(18, 5, 9, 1, 1),
(18, 6, 9, 1, 1),
(18, 7, 9, 1, 1),
(18, 8, 9, 1, 1),
(25, 9, 9, 1, 1),
(47, 9, 9, 1, 1),
(1, 4, 10, 1, 1),
(1, 5, 10, 1, 1),
(1, 6, 10, 1, 1),
(1, 7, 10, 1, 1),
(1, 8, 10, 1, 1),
(1, 9, 10, 1, 1),
(2, 4, 10, 1, 1),
(2, 5, 10, 1, 1),
(2, 6, 10, 1, 1),
(2, 7, 10, 1, 1),
(2, 8, 10, 1, 1),
(2, 9, 10, 1, 1),
(5, 4, 10, 1, 1),
(5, 5, 10, 1, 1),
(5, 6, 10, 1, 1),
(5, 7, 10, 1, 1),
(5, 8, 10, 1, 1),
(5, 9, 10, 1, 1),
(6, 4, 10, 1, 1),
(6, 5, 10, 1, 1),
(6, 6, 10, 1, 1),
(6, 7, 10, 1, 1),
(6, 8, 10, 1, 1),
(8, 9, 10, 1, 1),
(9, 9, 10, 1, 1),
(11, 9, 10, 1, 1),
(12, 9, 10, 1, 1),
(13, 4, 10, 1, 1),
(13, 5, 10, 1, 1),
(13, 6, 10, 1, 1),
(13, 7, 10, 1, 1),
(13, 8, 10, 1, 1),
(13, 9, 10, 1, 1),
(14, 5, 10, 1, 1),
(14, 6, 10, 1, 1),
(14, 7, 10, 1, 1),
(14, 8, 10, 1, 1),
(15, 5, 10, 1, 1),
(15, 6, 10, 1, 1),
(15, 7, 10, 1, 1),
(15, 8, 10, 1, 1),
(17, 4, 10, 1, 1),
(17, 5, 10, 1, 1),
(17, 6, 10, 1, 1),
(17, 7, 10, 1, 1),
(17, 8, 10, 1, 1),
(18, 4, 10, 1, 1),
(18, 5, 10, 1, 1),
(18, 6, 10, 1, 1),
(18, 7, 10, 1, 1),
(18, 8, 10, 1, 1),
(25, 9, 10, 1, 1),
(34, 4, 10, 1, 1),
(35, 4, 10, 1, 1),
(36, 4, 10, 1, 1),
(47, 9, 10, 1, 1),
(1, 4, 12, 1, 1),
(1, 6, 12, 1, 1),
(2, 4, 12, 1, 1),
(2, 6, 12, 1, 1),
(5, 4, 12, 1, 1),
(5, 6, 12, 1, 1),
(6, 4, 12, 1, 1),
(6, 6, 12, 1, 1),
(8, 4, 12, 1, 1),
(8, 6, 12, 1, 1),
(9, 4, 12, 1, 1),
(9, 6, 12, 1, 1),
(11, 4, 12, 1, 1),
(11, 6, 12, 1, 1),
(12, 4, 12, 1, 1),
(12, 6, 12, 1, 1),
(13, 4, 12, 1, 1),
(13, 6, 12, 1, 1),
(47, 4, 12, 1, 1),
(47, 6, 12, 1, 1),
(5, 4, 13, 1, 1),
(5, 5, 13, 1, 1),
(5, 6, 13, 1, 1),
(5, 7, 13, 1, 1),
(5, 8, 13, 1, 1),
(5, 9, 13, 1, 1),
(6, 4, 13, 1, 1),
(6, 5, 13, 1, 1),
(6, 6, 13, 1, 1),
(6, 7, 13, 1, 1),
(6, 8, 13, 1, 1),
(7, 4, 13, 1, 1),
(7, 5, 13, 1, 1),
(7, 6, 13, 1, 1),
(7, 7, 13, 1, 1),
(7, 8, 13, 1, 1),
(8, 5, 13, 1, 1),
(8, 6, 13, 1, 1),
(8, 7, 13, 1, 1),
(8, 8, 13, 1, 1),
(8, 9, 13, 1, 1),
(9, 5, 13, 1, 1),
(9, 6, 13, 1, 1),
(9, 7, 13, 1, 1),
(9, 8, 13, 1, 1),
(9, 9, 13, 1, 1),
(10, 5, 13, 1, 1),
(10, 6, 13, 1, 1),
(10, 7, 13, 1, 1),
(10, 8, 13, 1, 1),
(11, 4, 13, 1, 1),
(11, 5, 13, 1, 1),
(11, 6, 13, 1, 1),
(11, 7, 13, 1, 1),
(11, 8, 13, 1, 1),
(11, 9, 13, 1, 1),
(12, 4, 13, 1, 1),
(12, 5, 13, 1, 1),
(12, 6, 13, 1, 1),
(12, 7, 13, 1, 1),
(12, 8, 13, 1, 1),
(12, 9, 13, 1, 1),
(13, 4, 13, 1, 1),
(13, 5, 13, 1, 1),
(13, 6, 13, 1, 1),
(13, 7, 13, 1, 1),
(13, 8, 13, 1, 1),
(13, 9, 13, 1, 1),
(14, 4, 13, 1, 1),
(14, 5, 13, 1, 1),
(14, 6, 13, 1, 1),
(14, 7, 13, 1, 1),
(14, 8, 13, 1, 1),
(15, 4, 13, 1, 1),
(15, 5, 13, 1, 1),
(15, 6, 13, 1, 1),
(15, 7, 13, 1, 1),
(15, 8, 13, 1, 1),
(16, 4, 13, 1, 1),
(16, 5, 13, 1, 1),
(16, 6, 13, 1, 1),
(16, 7, 13, 1, 1),
(16, 8, 13, 1, 1),
(17, 4, 13, 1, 1),
(17, 5, 13, 1, 1),
(17, 6, 13, 1, 1),
(17, 7, 13, 1, 1),
(17, 8, 13, 1, 1),
(18, 4, 13, 1, 1),
(18, 5, 13, 1, 1),
(18, 6, 13, 1, 1),
(18, 7, 13, 1, 1),
(18, 8, 13, 1, 1),
(19, 4, 13, 1, 1),
(19, 5, 13, 1, 1),
(19, 6, 13, 1, 1),
(19, 7, 13, 1, 1),
(19, 8, 13, 1, 1),
(19, 9, 13, 1, 1),
(20, 4, 13, 1, 1),
(20, 5, 13, 1, 1),
(20, 6, 13, 1, 1),
(20, 7, 13, 1, 1),
(20, 8, 13, 1, 1),
(20, 9, 13, 1, 1),
(34, 4, 13, 1, 1),
(34, 6, 13, 1, 1),
(35, 4, 13, 1, 1),
(35, 6, 13, 1, 1),
(36, 4, 13, 1, 1),
(36, 6, 13, 1, 1),
(47, 4, 13, 1, 1),
(47, 5, 13, 1, 1),
(47, 6, 13, 1, 1),
(47, 7, 13, 1, 1),
(47, 8, 13, 1, 1),
(47, 9, 13, 1, 1),
(130, 4, 13, 1, 1),
(130, 5, 13, 1, 1),
(130, 6, 13, 1, 1),
(130, 7, 13, 1, 1),
(130, 8, 13, 1, 1),
(130, 9, 13, 1, 1),
(2, 1, 14, 1, 1),
(4, 1, 14, 1, 1),
(21, 1, 14, 1, 1),
(48, 1, 14, 1, 1),
(49, 1, 14, 1, 1),
(50, 1, 14, 1, 1),
(51, 1, 14, 1, 1),
(53, 1, 14, 1, 1),
(55, 1, 14, 1, 1),
(57, 1, 14, 1, 1),
(58, 1, 14, 1, 1),
(59, 1, 14, 1, 1),
(60, 1, 14, 1, 1),
(61, 1, 14, 1, 1),
(121, 1, 14, 1, 1),
(49, 1, 15, 1, 1),
(66, 1, 15, 1, 1),
(68, 1, 15, 1, 1),
(5, 4, 16, 1, 1),
(5, 5, 16, 1, 1),
(5, 6, 16, 1, 1),
(5, 7, 16, 1, 1),
(5, 8, 16, 1, 1),
(6, 4, 16, 1, 1),
(6, 5, 16, 1, 1),
(6, 6, 16, 1, 1),
(6, 7, 16, 1, 1),
(6, 8, 16, 1, 1),
(7, 4, 16, 1, 1),
(7, 5, 16, 1, 1),
(7, 6, 16, 1, 1),
(7, 7, 16, 1, 1),
(7, 8, 16, 1, 1),
(8, 5, 16, 1, 1),
(8, 6, 16, 1, 1),
(8, 7, 16, 1, 1),
(8, 8, 16, 1, 1),
(9, 5, 16, 1, 1),
(9, 6, 16, 1, 1),
(9, 7, 16, 1, 1),
(9, 8, 16, 1, 1),
(10, 5, 16, 1, 1),
(10, 6, 16, 1, 1),
(10, 7, 16, 1, 1),
(10, 8, 16, 1, 1),
(11, 4, 16, 1, 1),
(11, 5, 16, 1, 1),
(11, 6, 16, 1, 1),
(11, 7, 16, 1, 1),
(11, 8, 16, 1, 1),
(12, 4, 16, 1, 1),
(12, 5, 16, 1, 1),
(12, 6, 16, 1, 1),
(12, 7, 16, 1, 1),
(12, 8, 16, 1, 1),
(13, 4, 16, 1, 1),
(13, 5, 16, 1, 1),
(13, 6, 16, 1, 1),
(13, 7, 16, 1, 1),
(13, 8, 16, 1, 1),
(14, 4, 16, 1, 1),
(14, 5, 16, 1, 1),
(14, 6, 16, 1, 1),
(14, 7, 16, 1, 1),
(14, 8, 16, 1, 1),
(15, 4, 16, 1, 1),
(15, 5, 16, 1, 1),
(15, 6, 16, 1, 1),
(15, 7, 16, 1, 1),
(15, 8, 16, 1, 1),
(16, 4, 16, 1, 1),
(16, 5, 16, 1, 1),
(16, 6, 16, 1, 1),
(16, 7, 16, 1, 1),
(16, 8, 16, 1, 1),
(17, 4, 16, 1, 1),
(17, 5, 16, 1, 1),
(17, 6, 16, 1, 1),
(17, 7, 16, 1, 1),
(17, 8, 16, 1, 1),
(18, 4, 16, 1, 1),
(18, 5, 16, 1, 1),
(18, 6, 16, 1, 1),
(18, 7, 16, 1, 1),
(18, 8, 16, 1, 1),
(19, 4, 16, 1, 1),
(19, 5, 16, 1, 1),
(19, 6, 16, 1, 1),
(19, 7, 16, 1, 1),
(19, 8, 16, 1, 1),
(34, 4, 16, 1, 1),
(34, 6, 16, 1, 1),
(35, 4, 16, 1, 1),
(35, 6, 16, 1, 1),
(36, 4, 16, 1, 1),
(36, 6, 16, 1, 1),
(37, 4, 16, 1, 1),
(37, 5, 16, 1, 1),
(37, 6, 16, 1, 1),
(37, 7, 16, 1, 1),
(37, 8, 16, 1, 1),
(38, 4, 16, 1, 1),
(38, 5, 16, 1, 1),
(38, 6, 16, 1, 1),
(38, 7, 16, 1, 1),
(38, 8, 16, 1, 1),
(39, 4, 16, 1, 1),
(39, 5, 16, 1, 1),
(39, 6, 16, 1, 1),
(39, 7, 16, 1, 1),
(39, 8, 16, 1, 1),
(40, 4, 16, 1, 1),
(40, 5, 16, 1, 1),
(40, 6, 16, 1, 1),
(40, 7, 16, 1, 1),
(40, 8, 16, 1, 1),
(41, 4, 16, 1, 1),
(41, 5, 16, 1, 1),
(41, 6, 16, 1, 1),
(41, 7, 16, 1, 1),
(41, 8, 16, 1, 1),
(42, 4, 16, 1, 1),
(42, 5, 16, 1, 1),
(42, 6, 16, 1, 1),
(42, 7, 16, 1, 1),
(42, 8, 16, 1, 1),
(43, 4, 16, 1, 1),
(43, 5, 16, 1, 1),
(43, 6, 16, 1, 1),
(43, 7, 16, 1, 1),
(43, 8, 16, 1, 1),
(44, 4, 16, 1, 1),
(44, 5, 16, 1, 1),
(44, 6, 16, 1, 1),
(44, 7, 16, 1, 1),
(44, 8, 16, 1, 1),
(45, 4, 16, 1, 1),
(45, 5, 16, 1, 1),
(45, 6, 16, 1, 1),
(45, 7, 16, 1, 1),
(45, 8, 16, 1, 1),
(46, 4, 16, 1, 1),
(46, 5, 16, 1, 1),
(46, 6, 16, 1, 1),
(46, 7, 16, 1, 1),
(46, 8, 16, 1, 1),
(47, 4, 16, 1, 1),
(47, 5, 16, 1, 1),
(47, 6, 16, 1, 1),
(47, 7, 16, 1, 1),
(47, 8, 16, 1, 1),
(64, 4, 16, 1, 1),
(64, 5, 16, 1, 1),
(64, 6, 16, 1, 1),
(64, 7, 16, 1, 1),
(64, 8, 16, 1, 1),
(4, 1, 17, 1, 1),
(13, 1, 17, 1, 1),
(21, 1, 17, 1, 1),
(50, 1, 17, 1, 1),
(51, 1, 17, 1, 1),
(56, 1, 17, 1, 1),
(58, 1, 17, 1, 1),
(59, 1, 17, 1, 1),
(60, 1, 17, 1, 1),
(61, 1, 17, 1, 1),
(12, 4, 18, 1, 1),
(12, 5, 18, 1, 1),
(12, 6, 18, 1, 1),
(12, 7, 18, 1, 1),
(12, 8, 18, 1, 1),
(12, 9, 18, 1, 1),
(5, 4, 19, 1, 1),
(5, 5, 19, 1, 1),
(5, 6, 19, 1, 1),
(5, 7, 19, 1, 1),
(5, 8, 19, 1, 1),
(5, 9, 19, 1, 1),
(6, 4, 19, 1, 1),
(6, 5, 19, 1, 1),
(6, 6, 19, 1, 1),
(6, 7, 19, 1, 1),
(6, 8, 19, 1, 1),
(7, 4, 19, 1, 1),
(7, 5, 19, 1, 1),
(7, 6, 19, 1, 1),
(7, 7, 19, 1, 1),
(7, 8, 19, 1, 1),
(8, 4, 19, 1, 1),
(8, 5, 19, 1, 1),
(8, 6, 19, 1, 1),
(8, 7, 19, 1, 1),
(8, 8, 19, 1, 1),
(8, 9, 19, 1, 1),
(9, 4, 19, 1, 1),
(9, 5, 19, 1, 1),
(9, 6, 19, 1, 1),
(9, 7, 19, 1, 1),
(9, 8, 19, 1, 1),
(9, 9, 19, 1, 1),
(10, 4, 19, 1, 1),
(10, 5, 19, 1, 1),
(10, 6, 19, 1, 1),
(10, 7, 19, 1, 1),
(10, 8, 19, 1, 1),
(11, 4, 19, 1, 1),
(11, 5, 19, 1, 1),
(11, 6, 19, 1, 1),
(11, 7, 19, 1, 1),
(11, 8, 19, 1, 1),
(11, 9, 19, 1, 1),
(12, 4, 19, 1, 1),
(12, 5, 19, 1, 1),
(12, 6, 19, 1, 1),
(12, 7, 19, 1, 1),
(12, 8, 19, 1, 1),
(12, 9, 19, 1, 1),
(13, 4, 19, 1, 1),
(13, 5, 19, 1, 1),
(13, 6, 19, 1, 1),
(13, 7, 19, 1, 1),
(13, 8, 19, 1, 1),
(13, 9, 19, 1, 1),
(14, 4, 19, 1, 1),
(14, 5, 19, 1, 1),
(14, 6, 19, 1, 1),
(14, 7, 19, 1, 1),
(14, 8, 19, 1, 1),
(15, 4, 19, 1, 1),
(15, 5, 19, 1, 1),
(15, 6, 19, 1, 1),
(15, 7, 19, 1, 1),
(15, 8, 19, 1, 1),
(16, 4, 19, 1, 1),
(16, 5, 19, 1, 1),
(16, 6, 19, 1, 1),
(16, 7, 19, 1, 1),
(16, 8, 19, 1, 1),
(17, 4, 19, 1, 1),
(17, 5, 19, 1, 1),
(17, 6, 19, 1, 1),
(17, 7, 19, 1, 1),
(17, 8, 19, 1, 1),
(18, 4, 19, 1, 1),
(18, 5, 19, 1, 1),
(18, 6, 19, 1, 1),
(18, 7, 19, 1, 1),
(18, 8, 19, 1, 1),
(47, 4, 19, 1, 1),
(47, 5, 19, 1, 1),
(47, 6, 19, 1, 1),
(47, 7, 19, 1, 1),
(47, 8, 19, 1, 1),
(47, 9, 19, 1, 1),
(59, 4, 19, 1, 1),
(59, 5, 19, 1, 1),
(59, 6, 19, 1, 1),
(59, 7, 19, 1, 1),
(59, 8, 19, 1, 1),
(59, 9, 19, 1, 1),
(60, 4, 19, 1, 1),
(60, 5, 19, 1, 1),
(60, 6, 19, 1, 1),
(60, 7, 19, 1, 1),
(60, 8, 19, 1, 1),
(60, 9, 19, 1, 1),
(61, 4, 19, 1, 1),
(61, 5, 19, 1, 1),
(61, 6, 19, 1, 1),
(61, 7, 19, 1, 1),
(61, 8, 19, 1, 1),
(61, 9, 19, 1, 1),
(109, 4, 19, 1, 1),
(109, 5, 19, 1, 1),
(109, 6, 19, 1, 1),
(109, 7, 19, 1, 1),
(109, 8, 19, 1, 1),
(109, 9, 19, 1, 1),
(2, 9, 20, 1, 1),
(4, 4, 20, 1, 1),
(4, 5, 20, 1, 1),
(4, 6, 20, 1, 1),
(4, 7, 20, 1, 1),
(4, 8, 20, 1, 1),
(5, 4, 20, 1, 1),
(5, 5, 20, 1, 1),
(5, 6, 20, 1, 1),
(5, 7, 20, 1, 1),
(5, 8, 20, 1, 1),
(5, 9, 20, 1, 1),
(6, 4, 20, 1, 1),
(6, 5, 20, 1, 1),
(6, 6, 20, 1, 1),
(6, 7, 20, 1, 1),
(6, 8, 20, 1, 1),
(7, 4, 20, 1, 1),
(7, 5, 20, 1, 1),
(7, 6, 20, 1, 1),
(7, 7, 20, 1, 1),
(7, 8, 20, 1, 1),
(8, 4, 20, 1, 1),
(8, 5, 20, 1, 1),
(8, 6, 20, 1, 1),
(8, 7, 20, 1, 1),
(8, 8, 20, 1, 1),
(8, 9, 20, 1, 1),
(9, 4, 20, 1, 1),
(9, 5, 20, 1, 1),
(9, 6, 20, 1, 1),
(9, 7, 20, 1, 1),
(9, 8, 20, 1, 1),
(9, 9, 20, 1, 1),
(10, 4, 20, 1, 1),
(10, 5, 20, 1, 1),
(10, 6, 20, 1, 1),
(10, 7, 20, 1, 1),
(10, 8, 20, 1, 1),
(11, 4, 20, 1, 1),
(11, 5, 20, 1, 1),
(11, 6, 20, 1, 1),
(11, 7, 20, 1, 1),
(11, 8, 20, 1, 1),
(11, 9, 20, 1, 1),
(12, 4, 20, 1, 1),
(12, 5, 20, 1, 1),
(12, 6, 20, 1, 1),
(12, 7, 20, 1, 1),
(12, 8, 20, 1, 1),
(12, 9, 20, 1, 1),
(13, 4, 20, 1, 1),
(13, 5, 20, 1, 1),
(13, 6, 20, 1, 1),
(13, 7, 20, 1, 1),
(13, 8, 20, 1, 1),
(13, 9, 20, 1, 1),
(14, 4, 20, 1, 1),
(14, 5, 20, 1, 1),
(14, 6, 20, 1, 1),
(14, 7, 20, 1, 1),
(14, 8, 20, 1, 1),
(15, 4, 20, 1, 1),
(15, 5, 20, 1, 1),
(15, 6, 20, 1, 1),
(15, 7, 20, 1, 1),
(15, 8, 20, 1, 1),
(16, 4, 20, 1, 1),
(16, 5, 20, 1, 1),
(16, 6, 20, 1, 1),
(16, 7, 20, 1, 1),
(16, 8, 20, 1, 1),
(17, 4, 20, 1, 1),
(17, 5, 20, 1, 1),
(17, 6, 20, 1, 1),
(17, 7, 20, 1, 1),
(17, 8, 20, 1, 1),
(18, 4, 20, 1, 1),
(18, 5, 20, 1, 1),
(18, 6, 20, 1, 1),
(18, 7, 20, 1, 1),
(18, 8, 20, 1, 1),
(47, 4, 20, 1, 1),
(47, 5, 20, 1, 1),
(47, 6, 20, 1, 1),
(47, 7, 20, 1, 1),
(47, 8, 20, 1, 1),
(47, 9, 20, 1, 1),
(4, 1, 22, 1, 1),
(13, 1, 22, 1, 1),
(21, 1, 22, 1, 1),
(48, 1, 22, 1, 1),
(50, 1, 22, 1, 1),
(51, 1, 22, 1, 1),
(58, 1, 22, 1, 1),
(59, 1, 22, 1, 1),
(60, 1, 22, 1, 1),
(61, 1, 22, 1, 1),
(73, 1, 22, 1, 1),
(78, 1, 22, 1, 1),
(112, 1, 22, 1, 1),
(120, 1, 22, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `columnsvisible`
--

CREATE TABLE `columnsvisible` (
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `ReportTypeID` tinyint(3) UNSIGNED NOT NULL,
  `ColumnID` tinyint(3) UNSIGNED NOT NULL,
  `UserID` smallint(5) UNSIGNED NOT NULL DEFAULT 1,
  `ColumnIndex` smallint(5) UNSIGNED NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `config`
--

CREATE TABLE `config` (
  `Name` varchar(100) NOT NULL,
  `Value` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `config`
--

INSERT INTO `config` (`Name`, `Value`) VALUES
('blockedclicksremove', '30'),
('cachelastindex', '0'),
('CaptureGeo', '0'),
('CaptureISP', '0'),
('CaptureMobileDetails', '0'),
('CaptureNonMobileDetails', '0'),
('CaptureReferrer', '0'),
('CaptureResolutionDetails', '0'),
('CaptureUserAgent', '0'),
('chartgeneralview', '1'),
('chartgeodetailsview', '1'),
('clicksipsremove', '60'),
('cronbrowscaplastdbtime', 'Sat, 04 Mar 2023 22:08:02 GMT'),
('croncampaigns', '0'),
('croncampaignslastid', '0'),
('cronip2prxlastdbtime', 'Sat, 04 Mar 2023 22:05:21 GMT'),
('cronmmcitylastdbtime', 'Fri, 10 Mar 2023 05:22:04 GMT'),
('cronmmisplastdbtime', 'Sat, 11 Mar 2023 12:58:31 GMT'),
('cronwurfllastdbtime', 'Mon, 07 May 2018 23:19:54 GMT'),
('cronwurfllastindex', '-1'),
('dailymaintenancelastdate', '2014-01-01'),
('errorlogremove', '30'),
('filterstatus', '-1'),
('geolastindex', '0'),
('loginpage', 'login.php'),
('notemplateaction', '{blank}'),
('version', '10.0');

-- --------------------------------------------------------

--
-- Table structure for table `configtext`
--

CREATE TABLE `configtext` (
  `Name` varchar(100) NOT NULL,
  `Value` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `conversionextra`
--

CREATE TABLE `conversionextra` (
  `ClickID` bigint(20) UNSIGNED NOT NULL,
  `Status` varchar(190) DEFAULT NULL,
  `TransactionID` varchar(190) DEFAULT NULL,
  `Custom1` varchar(190) DEFAULT NULL,
  `Custom2` varchar(190) DEFAULT NULL,
  `Custom3` varchar(190) DEFAULT NULL,
  `Custom4` varchar(190) DEFAULT NULL,
  `Custom5` varchar(190) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `cpvsources`
--

CREATE TABLE `cpvsources` (
  `CpvSourceID` smallint(5) UNSIGNED NOT NULL,
  `Source` varchar(100) NOT NULL,
  `SourceID` varchar(100) NOT NULL,
  `KeywordToken` varchar(100) NOT NULL,
  `KeywordTokenPlace` varchar(100) NOT NULL DEFAULT '',
  `CostToken` varchar(100) NOT NULL DEFAULT '',
  `CostTokenPlace` varchar(100) NOT NULL DEFAULT '',
  `UniqueToken` varchar(100) NOT NULL DEFAULT '',
  `UniqueTokenPlace` varchar(100) NOT NULL DEFAULT '',
  `AppendToken` varchar(191) NOT NULL DEFAULT '',
  `Timezone` varchar(100) NOT NULL DEFAULT 'America/New_York',
  `CostTypeID` tinyint(4) NOT NULL DEFAULT 1,
  `AdTokenName` varchar(100) NOT NULL DEFAULT '',
  `AdTokenUrl` varchar(100) NOT NULL DEFAULT '',
  `AdTokenParam` varchar(100) NOT NULL DEFAULT '',
  `AdTokenPlace` varchar(100) NOT NULL DEFAULT '',
  `PostbackUrl` varchar(500) DEFAULT NULL,
  `DateAdded` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `cpvsources`
--

INSERT INTO `cpvsources` (`CpvSourceID`, `Source`, `SourceID`, `KeywordToken`, `KeywordTokenPlace`, `CostToken`, `CostTokenPlace`, `UniqueToken`, `UniqueTokenPlace`, `AppendToken`, `Timezone`, `CostTypeID`, `AdTokenName`, `AdTokenUrl`, `AdTokenParam`, `AdTokenPlace`, `PostbackUrl`, `DateAdded`) VALUES
(1, 'Propel Media (Trafficvance)', 'propmed', 'kw', '{keywordID}', 'bid', '{bid}', 'clkid', '{token}', '', 'America/Los_Angeles', 1, '', '', '', '', 'https://tracking.propelmedia.com/?id=REPLACE&value={!revenue!}&token={!tscode!}', '2021-06-03 07:07:12'),
(2, 'Facebook', 'fba', 'source', '{{site_source_name}}', '', '', 'fbclid', '', '', 'America/Los_Angeles', 2, 'Ad ID', '', 'ad_id', '{{ad.id}}', '', '2021-06-03 07:07:27'),
(3, 'TrafficJunky', 'tjy', 'siten', '{SiteName}', 'bid', '{BidValue}', 'clkid', '{ACLID}', '', 'America/New_York', 2, 'Ad / Creative', '', 'adid', '{AdID}', 'http://ads.trafficjunky.net/tj_ads_pt?a=XXXXXXXX&member_id=YYYYY&cti=[TRANSACTION_UNIQ_ID]&ctv={!revenue!}&ctd=[TRANSACTION_DESCRIPTION]&aclid={!tscode!}', '2021-06-03 07:07:41'),
(4, 'Bing Ads', 'bng', 'keyword', '{keyword}', '', '', 'msclkid', '', '', 'America/Los_Angeles', 2, 'Ad / Creative', '', 'ad', '{AdId}', '', '2021-06-03 07:07:52'),
(5, 'PopCash', 'pcs', 'site', '[siteid]', 'bid', '[bid]', 'clk', '[clickid]', '', 'Europe/Bucharest', 1, '', '', '', '', 'https://ct.popcash.net/click?aid=123456&clickid={!tscode!}&payout={!revenue!}', '2021-06-03 07:08:03'),
(6, 'Google Ads - Search', 'adwds', 'keyword', '{keyword}', '', '', 'gclid', '', '', 'America/Los_Angeles', 2, 'Ad / Creative', '', 'ad', '{creative}', '', '2021-06-03 07:08:18');

-- --------------------------------------------------------

--
-- Table structure for table `cpvsourcestokens`
--

CREATE TABLE `cpvsourcestokens` (
  `CpvSourceTokenID` smallint(5) UNSIGNED NOT NULL,
  `CpvSourceID` smallint(5) UNSIGNED NOT NULL,
  `ExtraTokenName` varchar(100) NOT NULL,
  `ExtraTokenUrl` varchar(100) DEFAULT NULL,
  `ExtraTokenParam` varchar(100) NOT NULL,
  `ExtraTokenPlace` varchar(100) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `cpvsourcestokens`
--

INSERT INTO `cpvsourcestokens` (`CpvSourceTokenID`, `CpvSourceID`, `ExtraTokenName`, `ExtraTokenUrl`, `ExtraTokenParam`, `ExtraTokenPlace`) VALUES
(1, 1, 'CreativeName', NULL, 'crtname', '{creativeName}'),
(2, 1, 'CampaignName', NULL, 'cmpname', '{campaignName}'),
(3, 1, 'CampaignID', NULL, 'cmpid', '{campaignID}'),
(4, 1, 'CreativeID', NULL, 'crtid', '{creativeID}'),
(5, 1, 'ClickStatus', NULL, 'sts', '{clickStatus}'),
(6, 1, 'City', NULL, 'ct', '{city}'),
(7, 1, 'CityState', NULL, 'ctst', '{citystate}'),
(8, 1, 'State', NULL, 'st', '{state}'),
(9, 1, 'StateLong', NULL, 'stl', '{statelong}'),
(10, 1, 'TargetDomain', NULL, 'tdom', '{targetingDomainId}'),
(11, 2, 'Adset ID', NULL, 'adset_id', '{{adset.id}}'),
(12, 2, 'Campaign ID', NULL, 'campaign_id', '{{campaign.id}}'),
(13, 2, 'Ad Name', NULL, 'ad_name', '{{ad.name}}'),
(14, 2, 'Adset Name', NULL, 'adset_name', '{{adset.name}}'),
(15, 2, 'Campaign Name', NULL, 'campaign_name', '{{campaign.name}}'),
(16, 2, 'Placement', NULL, 'placement', '{{placement}}'),
(17, 3, 'Campaign ID', NULL, 'campid', '{CampaignID}'),
(18, 3, 'Keyword', NULL, 'kw', '{Keyword}'),
(19, 3, 'Location', NULL, 'loc', '{Location}'),
(20, 3, 'Spot Name', NULL, 'spotn', '{SpotName}'),
(21, 3, 'Ban ID', NULL, 'banid', '{BanID}'),
(22, 3, 'Ban Name', NULL, 'banname', '{BanName}'),
(23, 3, 'Spot ID', NULL, 'spotid', '{SpotID}'),
(24, 3, 'Campaign Name', NULL, 'campname', '{CampaignName}'),
(25, 3, 'Ad Name', NULL, 'adname', '{AdName}'),
(26, 3, 'Bid ID', NULL, 'bidid', '{BidID}'),
(27, 4, 'Ad Group ID', NULL, 'adgroup', '{AdGroupId}'),
(28, 4, 'Bid Match Type', NULL, 'bidmatch', '{BidMatchType}'),
(29, 4, 'Campaign ID', NULL, 'campid', '{CampaignId}'),
(30, 4, 'Device', NULL, 'device', '{Device}'),
(31, 4, 'Is Content', NULL, 'iscontent', '{IfContent:True}'),
(32, 4, 'Is Mobile', NULL, 'ismobile', '{IfMobile:True}'),
(33, 4, 'Match Type', NULL, 'match', '{MatchType}'),
(34, 4, 'Order Item ID', NULL, 'itemid', '{OrderItemId}'),
(35, 4, 'Product ID', NULL, 'prodid', '{ProductId}'),
(36, 4, 'Target ID', NULL, 'targetid', '{TargetId}'),
(37, 4, 'Is Native', NULL, 'isnative', '{IfNative:True}'),
(38, 4, 'Is Search', NULL, 'issearch', '{IfSearch:True}'),
(39, 4, 'QueryString', NULL, 'querys', '{QueryString}'),
(40, 4, 'Network', NULL, 'network', '{Network}'),
(41, 4, 'Campaign Name', NULL, 'campn', '{Campaign}'),
(42, 4, 'Ad Group', NULL, 'adgroupn', '{AdGroup}'),
(43, 5, 'Category', NULL, 'cat', '[category]'),
(44, 5, 'Country', NULL, 'cc', '[cc]'),
(45, 5, 'Carrier', NULL, 'carrier', '[carrier]'),
(46, 5, 'Operating System', NULL, 'os', '[operatingsystem]'),
(47, 5, 'Campaign ID', NULL, 'campid', '[campaignid]'),
(48, 5, 'Connection', NULL, 'conn', '[connection]'),
(49, 5, 'Device', NULL, 'device', '[device]'),
(50, 5, 'Browser', NULL, 'brow', '[browser]'),
(51, 6, 'Match Type', NULL, 'match', '{matchtype}'),
(52, 6, 'Ad Position', NULL, 'adpos', '{adposition}'),
(53, 6, 'Network', NULL, 'network', '{network}'),
(54, 6, 'Mobile', NULL, 'mobl', '{ifmobile:True}'),
(55, 6, 'Search', NULL, 'srchn', '{ifsearch:True}'),
(56, 6, 'Not Mobile', NULL, 'notmobl', '{ifnotmobile:True}'),
(57, 6, 'Campaign ID', NULL, 'campid', '{campaignid}'),
(58, 6, 'Ad Group ID', NULL, 'adgroupid', '{adgroupid}'),
(59, 6, 'Feed Item ID', NULL, 'itemid', '{feeditemid}'),
(60, 6, 'Keyword ID', NULL, 'targetid', '{targetid}'),
(61, 6, 'Device Model', NULL, 'devmod', '{devicemodel}');

-- --------------------------------------------------------

--
-- Table structure for table `cpvtemplates`
--

CREATE TABLE `cpvtemplates` (
  `CpvTemplateID` smallint(5) UNSIGNED NOT NULL,
  `CpvTemplate` varchar(100) NOT NULL,
  `RowsToSkip` smallint(5) UNSIGNED NOT NULL,
  `KeywordColumn` varchar(100) NOT NULL,
  `AdColumn` varchar(100) NOT NULL DEFAULT '',
  `ViewsColumn` varchar(100) NOT NULL,
  `CostColumn` varchar(100) NOT NULL,
  `CpcColumn` varchar(100) NOT NULL DEFAULT '',
  `CampaignIDColumn` varchar(100) NOT NULL DEFAULT 'CampaignID',
  `CampaignNameColumn` varchar(100) NOT NULL DEFAULT 'Campaign',
  `Active` tinyint(1) NOT NULL,
  `CpvSourceID` smallint(5) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `cpvtemplates`
--

INSERT INTO `cpvtemplates` (`CpvTemplateID`, `CpvTemplate`, `RowsToSkip`, `KeywordColumn`, `AdColumn`, `ViewsColumn`, `CostColumn`, `CpcColumn`, `CampaignIDColumn`, `CampaignNameColumn`, `Active`, `CpvSourceID`) VALUES
(5, 'Trafficvance - Daily Targets Export', 0, 'Target', '', 'Impressions', 'Cost', '', 'CampaignID', 'Campaign', 1, 1),
(6, 'Trafficvance - Monthly Targets Export', 0, 'Target', '', 'Impressions', 'Cost', '', 'CampaignID', 'Campaign', 1, 1),
(9, 'Facebook', 0, 'Ad Name', '', 'Clicks', 'Spent', '', '', '', 1, 2),
(10, 'Traffic Junky CPM Report by ID', 0, 'id', '', 'clicks', 'cost', '', '', '', 1, 3),
(11, 'Traffic Junky CPM Report by Ad', 0, 'name', '', 'clicks', 'cost', '', '', '', 1, 3),
(12, 'Bing Keyword Report', 0, 'keyword', '', 'impressions', 'spent', '', '', '', 1, 4);

-- --------------------------------------------------------

--
-- Table structure for table `cronresults`
--

CREATE TABLE `cronresults` (
  `CronResultID` int(11) NOT NULL,
  `CronKey` varchar(100) NOT NULL,
  `CronValue` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `cronresults`
--

INSERT INTO `cronresults` (`CronResultID`, `CronKey`, `CronValue`) VALUES
(1, 'ViewsToday', '0'),
(2, 'ViewsYesterday', '0'),
(3, 'ViewsWeek', '0'),
(4, 'ViewsMonth', '0'),
(5, 'RevenueToday', '0'),
(6, 'RevenueYesterday', '0'),
(7, 'RevenueWeek', '0'),
(8, 'RevenueMonth', '0');

-- --------------------------------------------------------

--
-- Table structure for table `customdomains`
--

CREATE TABLE `customdomains` (
  `CustomDomainID` smallint(5) UNSIGNED NOT NULL,
  `CustomDomain` varchar(100) DEFAULT NULL,
  `DateAdded` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `customviews`
--

CREATE TABLE `customviews` (
  `CustomViewID` smallint(5) UNSIGNED NOT NULL,
  `CustomViewName` varchar(100) NOT NULL,
  `CustomViewDescription` varchar(191) NOT NULL,
  `ColumnsNumber` tinyint(3) UNSIGNED NOT NULL,
  `DefaultProfile` tinyint(1) NOT NULL DEFAULT 0,
  `CreateDate` datetime NOT NULL,
  `ModifyDate` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `customviews`
--

INSERT INTO `customviews` (`CustomViewID`, `CustomViewName`, `CustomViewDescription`, `ColumnsNumber`, `DefaultProfile`, `CreateDate`, `ModifyDate`) VALUES
(1, ' -Primary Metrics (default)', 'Default Metrics', 11, 1, '2020-01-30 00:00:00', NULL),
(2, ' -Primary Metrics w/Mobile', 'Default Metrics with Mobile Data', 13, 0, '2020-01-30 00:00:00', NULL),
(9, 'by ISP/Carrier ', '', 9, 0, '2020-01-30 00:00:00', NULL),
(10, 'by Browser', '', 9, 0, '2020-01-30 00:00:00', NULL),
(11, 'by Device Type', '', 9, 0, '2020-01-30 00:00:00', NULL),
(12, 'by Operating System (OS)', '', 9, 0, '2020-01-30 00:00:00', NULL),
(13, 'by Device Market Name', '', 9, 0, '2020-01-30 00:00:00', NULL),
(14, 'by Device Brand', '', 9, 0, '2020-01-30 00:00:00', NULL),
(15, 'by Device Model', '', 9, 0, '2020-01-30 00:00:00', NULL),
(16, 'by Device Name', '', 9, 0, '2020-01-30 00:00:00', NULL),
(17, ' Keyword > Page', '', 10, 0, '2020-01-30 00:00:00', NULL),
(18, ' Ad > Keyword > Page > Offer', '', 12, 0, '2020-01-30 00:00:00', NULL),
(19, ' Keyword > Page > Offer', '', 11, 0, '2020-01-30 00:00:00', NULL),
(20, ' Keyword > Offer', '', 10, 0, '2020-01-30 00:00:00', NULL),
(21, ' Ad > Page > Offer', '', 11, 0, '2020-01-30 00:00:00', NULL),
(22, ' Ad > Keyword > Offer', '', 11, 0, '2020-01-30 00:00:00', NULL),
(23, ' Ad > Keyword', '', 10, 0, '2020-01-30 00:00:00', NULL),
(24, ' Ad > Page', '', 10, 0, '2020-01-30 00:00:00', NULL),
(25, ' Ad > Offer', '', 10, 0, '2020-01-30 00:00:00', NULL),
(26, ' Page > Offer', '', 10, 0, '2020-01-30 00:00:00', NULL),
(27, 'by Referrer (Domain)', '', 9, 0, '2020-01-30 00:00:00', NULL),
(28, ' Ad > Keyword > Page', '', 11, 0, '2020-01-30 00:00:00', NULL),
(29, 'by Device Usage', '', 10, 0, '2020-01-30 00:00:00', NULL),
(30, 'by Screen Size', '', 9, 0, '2020-01-30 00:00:00', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customviewscolumns`
--

CREATE TABLE `customviewscolumns` (
  `CustomViewID` smallint(5) UNSIGNED NOT NULL,
  `ColumnID` tinyint(3) UNSIGNED NOT NULL,
  `ColumnIndex` smallint(5) UNSIGNED NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `customviewscolumns`
--

INSERT INTO `customviewscolumns` (`CustomViewID`, `ColumnID`, `ColumnIndex`) VALUES
(1, 4, 100),
(1, 5, 200),
(1, 6, 300),
(1, 8, 400),
(1, 9, 500),
(1, 11, 600),
(1, 12, 700),
(1, 13, 900),
(1, 17, 1000),
(1, 18, 1100),
(1, 47, 800),
(2, 4, 100),
(2, 5, 200),
(2, 6, 300),
(2, 8, 400),
(2, 9, 500),
(2, 11, 600),
(2, 12, 700),
(2, 13, 900),
(2, 17, 1000),
(2, 18, 1100),
(2, 47, 800),
(2, 74, 1200),
(2, 82, 1300),
(9, 5, 200),
(9, 9, 300),
(9, 12, 400),
(9, 13, 700),
(9, 14, 600),
(9, 17, 800),
(9, 18, 900),
(9, 47, 500),
(9, 82, 100),
(10, 5, 200),
(10, 9, 300),
(10, 12, 400),
(10, 13, 700),
(10, 14, 600),
(10, 17, 800),
(10, 18, 900),
(10, 47, 500),
(10, 78, 100),
(11, 5, 200),
(11, 9, 300),
(11, 12, 400),
(11, 13, 700),
(11, 14, 600),
(11, 17, 800),
(11, 18, 900),
(11, 47, 500),
(11, 72, 100),
(12, 5, 200),
(12, 9, 300),
(12, 12, 400),
(12, 13, 700),
(12, 14, 600),
(12, 17, 800),
(12, 18, 900),
(12, 47, 500),
(12, 77, 100),
(13, 5, 200),
(13, 9, 300),
(13, 12, 400),
(13, 13, 700),
(13, 14, 600),
(13, 17, 800),
(13, 18, 900),
(13, 47, 500),
(13, 76, 100),
(14, 5, 200),
(14, 9, 300),
(14, 12, 400),
(14, 13, 700),
(14, 14, 600),
(14, 17, 800),
(14, 18, 900),
(14, 47, 500),
(14, 73, 100),
(15, 5, 200),
(15, 9, 300),
(15, 12, 400),
(15, 13, 700),
(15, 14, 600),
(15, 17, 800),
(15, 18, 900),
(15, 47, 500),
(15, 75, 100),
(16, 5, 200),
(16, 9, 300),
(16, 12, 400),
(16, 13, 700),
(16, 14, 600),
(16, 17, 800),
(16, 18, 900),
(16, 47, 500),
(16, 74, 100),
(17, 2, 200),
(17, 4, 100),
(17, 5, 300),
(17, 9, 400),
(17, 12, 500),
(17, 13, 800),
(17, 14, 700),
(17, 17, 900),
(17, 18, 1000),
(17, 47, 600),
(18, 2, 300),
(18, 4, 200),
(18, 5, 500),
(18, 9, 600),
(18, 12, 700),
(18, 13, 1000),
(18, 14, 900),
(18, 17, 1100),
(18, 18, 1200),
(18, 21, 400),
(18, 47, 800),
(18, 64, 100),
(19, 2, 200),
(19, 4, 100),
(19, 5, 400),
(19, 9, 500),
(19, 12, 600),
(19, 13, 900),
(19, 14, 800),
(19, 17, 1000),
(19, 18, 1100),
(19, 21, 300),
(19, 47, 700),
(20, 4, 100),
(20, 5, 300),
(20, 9, 400),
(20, 12, 500),
(20, 13, 800),
(20, 14, 700),
(20, 17, 900),
(20, 18, 1000),
(20, 21, 200),
(20, 47, 600),
(21, 2, 200),
(21, 5, 400),
(21, 9, 500),
(21, 12, 600),
(21, 13, 900),
(21, 14, 800),
(21, 17, 1000),
(21, 18, 1100),
(21, 21, 300),
(21, 47, 700),
(21, 64, 100),
(22, 4, 200),
(22, 5, 400),
(22, 9, 500),
(22, 12, 600),
(22, 13, 900),
(22, 14, 800),
(22, 17, 1000),
(22, 18, 1100),
(22, 21, 300),
(22, 47, 700),
(22, 64, 100),
(23, 4, 200),
(23, 5, 300),
(23, 9, 400),
(23, 12, 500),
(23, 13, 800),
(23, 14, 700),
(23, 17, 900),
(23, 18, 1000),
(23, 47, 600),
(23, 64, 100),
(24, 2, 200),
(24, 5, 300),
(24, 9, 400),
(24, 12, 500),
(24, 13, 800),
(24, 14, 700),
(24, 17, 900),
(24, 18, 1000),
(24, 47, 600),
(24, 64, 100),
(25, 5, 300),
(25, 9, 400),
(25, 12, 500),
(25, 13, 800),
(25, 14, 700),
(25, 17, 900),
(25, 18, 1000),
(25, 21, 200),
(25, 47, 600),
(25, 64, 100),
(26, 2, 100),
(26, 5, 300),
(26, 9, 400),
(26, 12, 500),
(26, 13, 800),
(26, 14, 700),
(26, 17, 900),
(26, 18, 1000),
(26, 21, 200),
(26, 47, 600),
(27, 5, 200),
(27, 9, 300),
(27, 12, 400),
(27, 13, 700),
(27, 14, 600),
(27, 17, 800),
(27, 18, 900),
(27, 47, 500),
(27, 55, 100),
(28, 2, 300),
(28, 4, 200),
(28, 5, 400),
(28, 9, 500),
(28, 12, 600),
(28, 13, 900),
(28, 14, 800),
(28, 17, 1000),
(28, 18, 1100),
(28, 47, 700),
(28, 64, 100),
(29, 5, 300),
(29, 9, 400),
(29, 12, 500),
(29, 13, 800),
(29, 14, 700),
(29, 17, 900),
(29, 18, 1000),
(29, 47, 600),
(29, 83, 100),
(29, 92, 200),
(30, 5, 200),
(30, 9, 300),
(30, 12, 400),
(30, 13, 700),
(30, 14, 600),
(30, 17, 800),
(30, 18, 900),
(30, 47, 500),
(30, 80, 100);

-- --------------------------------------------------------

--
-- Table structure for table `destinations`
--

CREATE TABLE `destinations` (
  `DestinationID` mediumint(8) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `PathID` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `Offer` varchar(500) NOT NULL,
  `Url` varchar(500) NOT NULL,
  `Payout` double NOT NULL DEFAULT 0,
  `Share` tinyint(4) NOT NULL DEFAULT 0,
  `CurrentShare` tinyint(4) NOT NULL DEFAULT 0,
  `LandingPageID` int(11) NOT NULL DEFAULT 0,
  `AffiliateSourceID` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `PredefLpID` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `PredefOfferID` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `Level` tinyint(4) NOT NULL DEFAULT 1,
  `Sent` int(11) NOT NULL DEFAULT 0,
  `SharePath` tinyint(4) NOT NULL DEFAULT 50,
  `CurrentSharePath` tinyint(4) NOT NULL DEFAULT 0,
  `Inactive` tinyint(1) UNSIGNED NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `hiddencampaignalerts`
--

CREATE TABLE `hiddencampaignalerts` (
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `Views` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `hiddentargetalerts`
--

CREATE TABLE `hiddentargetalerts` (
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `SubIdID` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `inactiveads`
--

CREATE TABLE `inactiveads` (
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `AdValue` varchar(191) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `inactivesubids`
--

CREATE TABLE `inactivesubids` (
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `SubIdID` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `landingpagegroups`
--

CREATE TABLE `landingpagegroups` (
  `LandingPageGroupID` smallint(5) UNSIGNED NOT NULL,
  `LandingPageGroup` varchar(100) DEFAULT NULL,
  `CreateDate` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `landingpagegroups`
--

INSERT INTO `landingpagegroups` (`LandingPageGroupID`, `LandingPageGroup`, `CreateDate`) VALUES
(1, 'Default', '2023-03-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `logins`
--

CREATE TABLE `logins` (
  `LoginID` int(10) UNSIGNED NOT NULL,
  `LoginDate` datetime DEFAULT NULL,
  `IPBinary` varbinary(16) DEFAULT NULL,
  `Username` varchar(100) DEFAULT '',
  `Password` varchar(100) DEFAULT '',
  `LoginType` tinyint(1) DEFAULT 0,
  `UserAgent` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `mmbots`
--

CREATE TABLE `mmbots` (
  `BotID` smallint(5) UNSIGNED NOT NULL,
  `BotName` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `mmbots`
--

INSERT INTO `mmbots` (`BotID`, `BotName`) VALUES
(1, '360Spider'),
(2, 'Aboundexbot'),
(3, 'Acoon'),
(4, 'AddThis.com'),
(5, 'ADMantX'),
(6, 'aHrefs Bot'),
(7, 'Alexa Crawler'),
(8, 'Alexa Site Audit'),
(9, 'Amorank Spider'),
(10, 'Analytics SEO Crawler'),
(11, 'ApacheBench'),
(12, 'Applebot'),
(13, 'Arachni'),
(14, 'archive.org bot'),
(15, 'Ask Jeeves'),
(16, 'Backlink-Check.de'),
(17, 'BacklinkCrawler'),
(18, 'Baidu Spider'),
(19, 'BazQux Reader'),
(20, 'BingBot'),
(21, 'BitlyBot'),
(22, 'Blekkobot'),
(23, 'BLEXBot Crawler'),
(24, 'Bloglovin'),
(25, 'Blogtrottr'),
(26, 'Bountii Bot'),
(27, 'Browsershots'),
(28, 'BUbiNG'),
(29, 'Butterfly Robot'),
(30, 'CareerBot'),
(31, 'Castro 2'),
(32, 'Catchpoint'),
(33, 'ccBot crawler'),
(34, 'Charlotte'),
(35, 'Cliqzbot'),
(36, 'CloudFlare Always Online'),
(37, 'CloudFlare AMP Fetcher'),
(38, 'Collectd'),
(39, 'CommaFeed'),
(40, 'CSS Certificate Spider'),
(41, 'C?c C?c Bot'),
(42, 'Datadog Agent'),
(43, 'Dataprovider'),
(44, 'Daum'),
(45, 'Dazoobot'),
(46, 'Discobot'),
(47, 'Domain Re-Animator Bot'),
(48, 'DotBot'),
(49, 'DuckDuckGo Bot'),
(50, 'Easou Spider'),
(51, 'EMail Exractor'),
(52, 'EmailWolf'),
(53, 'evc-batch'),
(54, 'ExaBot'),
(55, 'ExactSeek Crawler'),
(56, 'Ezooms'),
(57, 'Facebook External Hit'),
(58, 'Feedbin'),
(59, 'FeedBurner'),
(60, 'Feedly'),
(61, 'Feedspot'),
(62, 'Feed Wrangler'),
(63, 'Fever'),
(64, 'Findxbot'),
(65, 'Flipboard'),
(66, 'Generic Bot'),
(67, 'Generic Bot'),
(68, 'Genieo Web filter'),
(69, 'Gigablast'),
(70, 'Gigabot'),
(71, 'Gluten Free Crawler'),
(72, 'Gmail Image Proxy'),
(73, 'Goo'),
(74, 'Googlebot'),
(75, 'Google PageSpeed Insights'),
(76, 'Google Partner Monitoring'),
(77, 'Google Search Console'),
(78, 'Google Structured Data Testing Tool'),
(79, 'Grapeshot'),
(80, 'Heritrix'),
(81, 'Heureka Feed'),
(82, 'HTTPMon'),
(83, 'HubPages'),
(84, 'HubSpot'),
(85, 'ICC-Crawler'),
(86, 'ichiro'),
(87, 'IIS Site Analysis'),
(88, 'Inktomi Slurp'),
(89, 'IP-Guide Crawler'),
(90, 'IPS Agent'),
(91, 'Kouio'),
(92, 'Larbin web crawler'),
(93, 'Let\'s Encrypt Validation'),
(94, 'Lighthouse'),
(95, 'Linkdex Bot'),
(96, 'LinkedIn Bot'),
(97, 'LTX71'),
(98, 'Lycos'),
(99, 'Magpie-Crawler'),
(100, 'MagpieRSS'),
(101, 'Mail.Ru Bot'),
(102, 'masscan'),
(103, 'Meanpath Bot'),
(104, 'MetaInspector'),
(105, 'MetaJobBot'),
(106, 'Mixrank Bot'),
(107, 'MJ12 Bot'),
(108, 'Mnogosearch'),
(109, 'MojeekBot'),
(110, 'Monitor.Us'),
(111, 'Munin'),
(112, 'Nagios check_http'),
(113, 'NalezenCzBot'),
(114, 'Netcraft Survey Bot'),
(115, 'netEstate'),
(116, 'NetLyzer FastProbe'),
(117, 'NetResearchServer'),
(118, 'Netvibes'),
(119, 'NewsBlur'),
(120, 'NewsGator'),
(121, 'NLCrawler'),
(122, 'Nmap'),
(123, 'Nutch-based Bot'),
(124, 'Octopus'),
(125, 'Omgili bot'),
(126, 'Openindex Spider'),
(127, 'OpenLinkProfiler'),
(128, 'OpenWebSpider'),
(129, 'Orange Bot'),
(130, 'Outbrain'),
(131, 'PagePeeker'),
(132, 'PaperLiBot'),
(133, 'Phantomas'),
(134, 'PHP Server Monitor'),
(135, 'Picsearch bot'),
(136, 'Pingdom Bot'),
(137, 'Pinterest'),
(138, 'PocketParser'),
(139, 'Pompos'),
(140, 'PritTorrent'),
(141, 'QuerySeekerSpider'),
(142, 'Quora Link Preview'),
(143, 'Qwantify'),
(144, 'Rainmeter'),
(145, 'RamblerMail Image Proxy'),
(146, 'Reddit Bot'),
(147, 'Riddler'),
(148, 'Rogerbot'),
(149, 'ROI Hunter'),
(150, 'SafeDNSBot'),
(151, 'Scooter'),
(152, 'ScoutJet'),
(153, 'Scrapy'),
(154, 'Screaming Frog SEO Spider'),
(155, 'ScreenerBot'),
(156, 'Semrush Bot'),
(157, 'Sensika Bot'),
(158, 'Sentry Bot'),
(159, 'SEOENGBot'),
(160, 'SEOkicks-Robot'),
(161, 'Seoscanners.net'),
(162, 'Server Density'),
(163, 'Seznam Bot'),
(164, 'Seznam Email Proxy'),
(165, 'Seznam Zbozi.cz'),
(166, 'ShopAlike'),
(167, 'ShopWiki'),
(168, 'SilverReader'),
(169, 'SimplePie'),
(170, 'SISTRIX Crawler'),
(171, 'Site24x7 Website Monitoring'),
(172, 'SiteSucker'),
(173, 'Sixy.ch'),
(174, 'Skype URI Preview'),
(175, 'Slackbot'),
(176, 'Snapchat Proxy'),
(177, 'Sogou Spider'),
(178, 'Soso Spider'),
(179, 'Sparkler'),
(180, 'Speedy'),
(181, 'Spinn3r'),
(182, 'Sputnik Bot'),
(183, 'sqlmap'),
(184, 'SSL Labs'),
(185, 'StatusCake'),
(186, 'Superfeedr Bot'),
(187, 'Survey Bot'),
(188, 'Tarmot Gezgin'),
(189, 'TelgramBot'),
(190, 'TinEye Crawler'),
(191, 'Tiny Tiny RSS'),
(192, 'TLSProbe'),
(193, 'Trendiction Bot'),
(194, 'TurnitinBot'),
(195, 'TweetedTimes Bot'),
(196, 'Tweetmeme Bot'),
(197, 'Twitterbot'),
(198, 'UkrNet Mail Proxy'),
(199, 'UniversalFeedParser'),
(200, 'Uptimebot'),
(201, 'Uptime Robot'),
(202, 'URLAppendBot'),
(203, 'Vagabondo'),
(204, 'Visual Site Mapper Crawler'),
(205, 'VK Share Button'),
(206, 'W3C CSS Validator'),
(207, 'W3C I18N Checker'),
(208, 'W3C Link Checker'),
(209, 'W3C Markup Validation Service'),
(210, 'W3C MobileOK Checker'),
(211, 'W3C Unified Validator'),
(212, 'Wappalyzer'),
(213, 'WebbCrawler'),
(214, 'WebPageTest'),
(215, 'WebSitePulse'),
(216, 'WebThumbnail'),
(217, 'WeSEE:Search'),
(218, 'Willow Internet Crawler'),
(219, 'WordPress'),
(220, 'Wotbox'),
(221, 'YaCy'),
(222, 'Yahoo! Cache System'),
(223, 'Yahoo! Link Preview'),
(224, 'Yahoo! Slurp'),
(225, 'Yahoo Gemini'),
(226, 'Yandex Bot'),
(227, 'Yeti/Naverbot'),
(228, 'Yottaa Site Monitor'),
(229, 'Youdao Bot'),
(230, 'Yourls'),
(231, 'Yunyun Bot'),
(232, 'Zao'),
(233, 'zgrab'),
(234, 'Zookabot'),
(235, 'ZumBot');

-- --------------------------------------------------------

--
-- Table structure for table `mmbottypes`
--

CREATE TABLE `mmbottypes` (
  `BotTypeID` tinyint(3) UNSIGNED NOT NULL,
  `BotType` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `mmbottypes`
--

INSERT INTO `mmbottypes` (`BotTypeID`, `BotType`) VALUES
(1, 'Search bot'),
(2, 'Social Media Agent'),
(3, 'Crawler'),
(4, 'Site Monitor'),
(5, 'Benchmark'),
(6, 'Security Checker'),
(7, 'Service Agent'),
(8, 'Feed Fetcher'),
(9, 'Validator'),
(10, 'crawler'),
(11, 'Feed Parser'),
(12, 'Analytics SEO Crawler'),
(13, 'Read-it-later Service'),
(14, 'Security search bot'),
(15, 'Search tools');

-- --------------------------------------------------------

--
-- Table structure for table `mmcities`
--

CREATE TABLE `mmcities` (
  `CityID` mediumint(8) UNSIGNED NOT NULL,
  `CityName` varchar(100) NOT NULL,
  `RegionID` smallint(5) UNSIGNED NOT NULL DEFAULT 1,
  `CountryCode` varchar(2) NOT NULL DEFAULT '',
  `RegionCode` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `mmcities`
--

INSERT INTO `mmcities` (`CityID`, `CityName`, `RegionID`, `CountryCode`, `RegionCode`) VALUES
(1, '', 1, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `mmcontinents`
--

CREATE TABLE `mmcontinents` (
  `ContinentID` tinyint(3) UNSIGNED NOT NULL,
  `ContinentCode` varchar(2) NOT NULL,
  `ContinentName` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `mmcontinents`
--

INSERT INTO `mmcontinents` (`ContinentID`, `ContinentCode`, `ContinentName`) VALUES
(1, '--', ''),
(2, 'AS', 'Asia'),
(3, 'EU', 'Europe'),
(4, 'NA', 'North America'),
(5, 'AF', 'Africa'),
(6, 'AN', 'Antarctica'),
(7, 'SA', 'South America'),
(8, 'OC', 'Oceania');

-- --------------------------------------------------------

--
-- Table structure for table `mmcountries`
--

CREATE TABLE `mmcountries` (
  `CountryID` smallint(5) UNSIGNED NOT NULL,
  `CountryCode` varchar(2) NOT NULL,
  `CountryCode3` varchar(3) NOT NULL,
  `CountryName` varchar(100) NOT NULL,
  `IsEU` tinyint(4) NOT NULL DEFAULT 0,
  `ContinentID` tinyint(3) UNSIGNED NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `mmcountries`
--

INSERT INTO `mmcountries` (`CountryID`, `CountryCode`, `CountryCode3`, `CountryName`, `IsEU`, `ContinentID`) VALUES
(1, '', '', '', 0, 1),
(2, 'AP', 'AP', 'Asia/Pacific Region', 0, 2),
(3, 'EU', 'EU', 'Europe', 0, 3),
(4, 'AD', 'AND', 'Andorra', 0, 3),
(5, 'AE', 'ARE', 'United Arab Emirates', 0, 2),
(6, 'AF', 'AFG', 'Afghanistan', 0, 2),
(7, 'AG', 'ATG', 'Antigua and Barbuda', 0, 4),
(8, 'AI', 'AIA', 'Anguilla', 0, 4),
(9, 'AL', 'ALB', 'Albania', 0, 3),
(10, 'AM', 'ARM', 'Armenia', 0, 2),
(11, 'AN', 'ANT', 'Netherlands Antilles', 0, 4),
(12, 'AO', 'AGO', 'Angola', 0, 5),
(13, 'AQ', 'ATA', 'Antarctica', 0, 6),
(14, 'AR', 'ARG', 'Argentina', 0, 7),
(15, 'AS', 'ASM', 'American Samoa', 0, 8),
(16, 'AT', 'AUT', 'Austria', 1, 3),
(17, 'AU', 'AUS', 'Australia', 0, 8),
(18, 'AW', 'ABW', 'Aruba', 0, 4),
(19, 'AZ', 'AZE', 'Azerbaijan', 0, 2),
(20, 'BA', 'BIH', 'Bosnia and Herzegovina', 0, 3),
(21, 'BB', 'BRB', 'Barbados', 0, 4),
(22, 'BD', 'BGD', 'Bangladesh', 0, 2),
(23, 'BE', 'BEL', 'Belgium', 1, 3),
(24, 'BF', 'BFA', 'Burkina Faso', 0, 5),
(25, 'BG', 'BGR', 'Bulgaria', 1, 3),
(26, 'BH', 'BHR', 'Bahrain', 0, 2),
(27, 'BI', 'BDI', 'Burundi', 0, 5),
(28, 'BJ', 'BEN', 'Benin', 0, 5),
(29, 'BM', 'BMU', 'Bermuda', 0, 4),
(30, 'BN', 'BRN', 'Brunei Darussalam', 0, 2),
(31, 'BO', 'BOL', 'Bolivia', 0, 7),
(32, 'BR', 'BRA', 'Brazil', 0, 7),
(33, 'BS', 'BHS', 'Bahamas', 0, 4),
(34, 'BT', 'BTN', 'Bhutan', 0, 2),
(35, 'BV', 'BVT', 'Bouvet Island', 0, 6),
(36, 'BW', 'BWA', 'Botswana', 0, 5),
(37, 'BY', 'BLR', 'Belarus', 0, 3),
(38, 'BZ', 'BLZ', 'Belize', 0, 4),
(39, 'CA', 'CAN', 'Canada', 0, 4),
(40, 'CC', 'CCK', 'Cocos (Keeling) Islands', 0, 2),
(41, 'CD', 'COD', 'Congo, The Democratic Republic of the', 0, 5),
(42, 'CF', 'CAF', 'Central African Republic', 0, 5),
(43, 'CG', 'COG', 'Congo', 0, 5),
(44, 'CH', 'CHE', 'Switzerland', 0, 3),
(45, 'CI', 'CIV', 'Cote D\'Ivoire', 0, 5),
(46, 'CK', 'COK', 'Cook Islands', 0, 8),
(47, 'CL', 'CHL', 'Chile', 0, 7),
(48, 'CM', 'CMR', 'Cameroon', 0, 5),
(49, 'CN', 'CHN', 'China', 0, 2),
(50, 'CO', 'COL', 'Colombia', 0, 7),
(51, 'CR', 'CRI', 'Costa Rica', 0, 4),
(52, 'CU', 'CUB', 'Cuba', 0, 4),
(53, 'CV', 'CPV', 'Cape Verde', 0, 5),
(54, 'CX', 'CXR', 'Christmas Island', 0, 2),
(55, 'CY', 'CYP', 'Cyprus', 1, 2),
(56, 'CZ', 'CZE', 'Czech Republic', 1, 3),
(57, 'DE', 'DEU', 'Germany', 1, 3),
(58, 'DJ', 'DJI', 'Djibouti', 0, 5),
(59, 'DK', 'DNK', 'Denmark', 1, 3),
(60, 'DM', 'DMA', 'Dominica', 0, 4),
(61, 'DO', 'DOM', 'Dominican Republic', 0, 4),
(62, 'DZ', 'DZA', 'Algeria', 0, 5),
(63, 'EC', 'ECU', 'Ecuador', 0, 7),
(64, 'EE', 'EST', 'Estonia', 1, 3),
(65, 'EG', 'EGY', 'Egypt', 0, 5),
(66, 'EH', 'ESH', 'Western Sahara', 0, 5),
(67, 'ER', 'ERI', 'Eritrea', 0, 5),
(68, 'ES', 'ESP', 'Spain', 1, 3),
(69, 'ET', 'ETH', 'Ethiopia', 0, 5),
(70, 'FI', 'FIN', 'Finland', 1, 3),
(71, 'FJ', 'FJI', 'Fiji', 0, 8),
(72, 'FK', 'FLK', 'Falkland Islands (Malvinas)', 0, 7),
(73, 'FM', 'FSM', 'Micronesia, Federated States of', 0, 8),
(74, 'FO', 'FRO', 'Faroe Islands', 0, 3),
(75, 'FR', 'FRA', 'France', 1, 3),
(76, 'FX', 'FX', 'France, Metropolitan', 0, 3),
(77, 'GA', 'GAB', 'Gabon', 0, 5),
(78, 'GB', 'GBR', 'United Kingdom', 1, 3),
(79, 'GD', 'GRD', 'Grenada', 0, 4),
(80, 'GE', 'GEO', 'Georgia', 0, 2),
(81, 'GF', 'GUF', 'French Guiana', 0, 7),
(82, 'GH', 'GHA', 'Ghana', 0, 5),
(83, 'GI', 'GIB', 'Gibraltar', 0, 3),
(84, 'GL', 'GRL', 'Greenland', 0, 4),
(85, 'GM', 'GMB', 'Gambia', 0, 5),
(86, 'GN', 'GIN', 'Guinea', 0, 5),
(87, 'GP', 'GLP', 'Guadeloupe', 0, 4),
(88, 'GQ', 'GNQ', 'Equatorial Guinea', 0, 5),
(89, 'GR', 'GRC', 'Greece', 1, 3),
(90, 'GS', 'SGS', 'South Georgia and the South Sandwich Islands', 0, 6),
(91, 'GT', 'GTM', 'Guatemala', 0, 4),
(92, 'GU', 'GUM', 'Guam', 0, 8),
(93, 'GW', 'GNB', 'Guinea-Bissau', 0, 5),
(94, 'GY', 'GUY', 'Guyana', 0, 7),
(95, 'HK', 'HKG', 'Hong Kong', 0, 2),
(96, 'HM', 'HMD', 'Heard Island and McDonald Islands', 0, 6),
(97, 'HN', 'HND', 'Honduras', 0, 4),
(98, 'HR', 'HRV', 'Croatia', 1, 3),
(99, 'HT', 'HTI', 'Haiti', 0, 4),
(100, 'HU', 'HUN', 'Hungary', 1, 3),
(101, 'ID', 'IDN', 'Indonesia', 0, 2),
(102, 'IE', 'IRL', 'Ireland', 1, 3),
(103, 'IL', 'ISR', 'Israel', 0, 2),
(104, 'IN', 'IND', 'India', 0, 2),
(105, 'IO', 'IOT', 'British Indian Ocean Territory', 0, 2),
(106, 'IQ', 'IRQ', 'Iraq', 0, 2),
(107, 'IR', 'IRN', 'Iran, Islamic Republic of', 0, 2),
(108, 'IS', 'ISL', 'Iceland', 0, 3),
(109, 'IT', 'ITA', 'Italy', 1, 3),
(110, 'JM', 'JAM', 'Jamaica', 0, 4),
(111, 'JO', 'JOR', 'Jordan', 0, 2),
(112, 'JP', 'JPN', 'Japan', 0, 2),
(113, 'KE', 'KEN', 'Kenya', 0, 5),
(114, 'KG', 'KGZ', 'Kyrgyzstan', 0, 2),
(115, 'KH', 'KHM', 'Cambodia', 0, 2),
(116, 'KI', 'KIR', 'Kiribati', 0, 8),
(117, 'KM', 'COM', 'Comoros', 0, 5),
(118, 'KN', 'KNA', 'Saint Kitts and Nevis', 0, 4),
(119, 'KP', 'PRK', 'Korea, Democratic People\'s Republic of', 0, 2),
(120, 'KR', 'KOR', 'Korea, Republic of', 0, 2),
(121, 'KW', 'KWT', 'Kuwait', 0, 2),
(122, 'KY', 'CYM', 'Cayman Islands', 0, 4),
(123, 'KZ', 'KAZ', 'Kazakhstan', 0, 2),
(124, 'LA', 'LAO', 'Lao People\'s Democratic Republic', 0, 2),
(125, 'LB', 'LBN', 'Lebanon', 0, 2),
(126, 'LC', 'LCA', 'Saint Lucia', 0, 4),
(127, 'LI', 'LIE', 'Liechtenstein', 0, 3),
(128, 'LK', 'LKA', 'Sri Lanka', 0, 2),
(129, 'LR', 'LBR', 'Liberia', 0, 5),
(130, 'LS', 'LSO', 'Lesotho', 0, 5),
(131, 'LT', 'LTU', 'Lithuania', 1, 3),
(132, 'LU', 'LUX', 'Luxembourg', 1, 3),
(133, 'LV', 'LVA', 'Latvia', 1, 3),
(134, 'LY', 'LBY', 'Libyan Arab Jamahiriya', 0, 5),
(135, 'MA', 'MAR', 'Morocco', 0, 5),
(136, 'MC', 'MCO', 'Monaco', 0, 3),
(137, 'MD', 'MDA', 'Moldova, Republic of', 0, 3),
(138, 'MG', 'MDG', 'Madagascar', 0, 5),
(139, 'MH', 'MHL', 'Marshall Islands', 0, 8),
(140, 'MK', 'MKD', 'Macedonia', 0, 3),
(141, 'ML', 'MLI', 'Mali', 0, 5),
(142, 'MM', 'MMR', 'Myanmar', 0, 2),
(143, 'MN', 'MNG', 'Mongolia', 0, 2),
(144, 'MO', 'MAC', 'Macau', 0, 2),
(145, 'MP', 'MNP', 'Northern Mariana Islands', 0, 8),
(146, 'MQ', 'MTQ', 'Martinique', 0, 4),
(147, 'MR', 'MRT', 'Mauritania', 0, 5),
(148, 'MS', 'MSR', 'Montserrat', 0, 4),
(149, 'MT', 'MLT', 'Malta', 1, 3),
(150, 'MU', 'MUS', 'Mauritius', 0, 5),
(151, 'MV', 'MDV', 'Maldives', 0, 2),
(152, 'MW', 'MWI', 'Malawi', 0, 5),
(153, 'MX', 'MEX', 'Mexico', 0, 4),
(154, 'MY', 'MYS', 'Malaysia', 0, 2),
(155, 'MZ', 'MOZ', 'Mozambique', 0, 5),
(156, 'NA', 'NAM', 'Namibia', 0, 5),
(157, 'NC', 'NCL', 'New Caledonia', 0, 8),
(158, 'NE', 'NER', 'Niger', 0, 5),
(159, 'NF', 'NFK', 'Norfolk Island', 0, 8),
(160, 'NG', 'NGA', 'Nigeria', 0, 5),
(161, 'NI', 'NIC', 'Nicaragua', 0, 4),
(162, 'NL', 'NLD', 'Netherlands', 1, 3),
(163, 'NO', 'NOR', 'Norway', 0, 3),
(164, 'NP', 'NPL', 'Nepal', 0, 2),
(165, 'NR', 'NRU', 'Nauru', 0, 8),
(166, 'NU', 'NIU', 'Niue', 0, 8),
(167, 'NZ', 'NZL', 'New Zealand', 0, 8),
(168, 'OM', 'OMN', 'Oman', 0, 2),
(169, 'PA', 'PAN', 'Panama', 0, 4),
(170, 'PE', 'PER', 'Peru', 0, 7),
(171, 'PF', 'PYF', 'French Polynesia', 0, 8),
(172, 'PG', 'PNG', 'Papua New Guinea', 0, 8),
(173, 'PH', 'PHL', 'Philippines', 0, 2),
(174, 'PK', 'PAK', 'Pakistan', 0, 2),
(175, 'PL', 'POL', 'Poland', 1, 3),
(176, 'PM', 'SPM', 'Saint Pierre and Miquelon', 0, 4),
(177, 'PN', 'PCN', 'Pitcairn Islands', 0, 8),
(178, 'PR', 'PRI', 'Puerto Rico', 0, 4),
(179, 'PS', 'PSE', 'Palestinian Territory', 0, 2),
(180, 'PT', 'PRT', 'Portugal', 1, 3),
(181, 'PW', 'PLW', 'Palau', 0, 8),
(182, 'PY', 'PRY', 'Paraguay', 0, 7),
(183, 'QA', 'QAT', 'Qatar', 0, 2),
(184, 'RE', 'REU', 'Reunion', 0, 5),
(185, 'RO', 'ROU', 'Romania', 1, 3),
(186, 'RU', 'RUS', 'Russian Federation', 0, 3),
(187, 'RW', 'RWA', 'Rwanda', 0, 5),
(188, 'SA', 'SAU', 'Saudi Arabia', 0, 2),
(189, 'SB', 'SLB', 'Solomon Islands', 0, 8),
(190, 'SC', 'SYC', 'Seychelles', 0, 5),
(191, 'SD', 'SDN', 'Sudan', 0, 5),
(192, 'SE', 'SWE', 'Sweden', 1, 3),
(193, 'SG', 'SGP', 'Singapore', 0, 2),
(194, 'SH', 'SHN', 'Saint Helena', 0, 5),
(195, 'SI', 'SVN', 'Slovenia', 1, 3),
(196, 'SJ', 'SJM', 'Svalbard and Jan Mayen', 0, 3),
(197, 'SK', 'SVK', 'Slovakia', 1, 3),
(198, 'SL', 'SLE', 'Sierra Leone', 0, 5),
(199, 'SM', 'SMR', 'San Marino', 0, 3),
(200, 'SN', 'SEN', 'Senegal', 0, 5),
(201, 'SO', 'SOM', 'Somalia', 0, 5),
(202, 'SR', 'SUR', 'Suriname', 0, 7),
(203, 'ST', 'STP', 'Sao Tome and Principe', 0, 5),
(204, 'SV', 'SLV', 'El Salvador', 0, 4),
(205, 'SY', 'SYR', 'Syrian Arab Republic', 0, 2),
(206, 'SZ', 'SWZ', 'Swaziland', 0, 5),
(207, 'TC', 'TCA', 'Turks and Caicos Islands', 0, 4),
(208, 'TD', 'TCD', 'Chad', 0, 5),
(209, 'TF', 'ATF', 'French Southern Territories', 0, 6),
(210, 'TG', 'TGO', 'Togo', 0, 5),
(211, 'TH', 'THA', 'Thailand', 0, 2),
(212, 'TJ', 'TJK', 'Tajikistan', 0, 2),
(213, 'TK', 'TKL', 'Tokelau', 0, 8),
(214, 'TM', 'TLS', 'Turkmenistan', 0, 2),
(215, 'TN', 'TKM', 'Tunisia', 0, 5),
(216, 'TO', 'TUN', 'Tonga', 0, 8),
(217, 'TL', 'TON', 'Timor-Leste', 0, 2),
(218, 'TR', 'TUR', 'Turkey', 0, 3),
(219, 'TT', 'TTO', 'Trinidad and Tobago', 0, 4),
(220, 'TV', 'TUV', 'Tuvalu', 0, 8),
(221, 'TW', 'TWN', 'Taiwan', 0, 2),
(222, 'TZ', 'TZA', 'Tanzania, United Republic of', 0, 5),
(223, 'UA', 'UKR', 'Ukraine', 0, 3),
(224, 'UG', 'UGA', 'Uganda', 0, 5),
(225, 'UM', 'UMI', 'United States Minor Outlying Islands', 0, 8),
(226, 'US', 'USA', 'United States', 0, 4),
(227, 'UY', 'URY', 'Uruguay', 0, 7),
(228, 'UZ', 'UZB', 'Uzbekistan', 0, 2),
(229, 'VA', 'VAT', 'Holy See (Vatican City State)', 0, 3),
(230, 'VC', 'VCT', 'Saint Vincent and the Grenadines', 0, 4),
(231, 'VE', 'VEN', 'Venezuela', 0, 7),
(232, 'VG', 'VGB', 'Virgin Islands, British', 0, 4),
(233, 'VI', 'VIR', 'Virgin Islands, U.S.', 0, 4),
(234, 'VN', 'VNM', 'Vietnam', 0, 2),
(235, 'VU', 'VUT', 'Vanuatu', 0, 8),
(236, 'WF', 'WLF', 'Wallis and Futuna', 0, 8),
(237, 'WS', 'WSM', 'Samoa', 0, 8),
(238, 'YE', 'YEM', 'Yemen', 0, 2),
(239, 'YT', 'MYT', 'Mayotte', 0, 5),
(240, 'RS', 'SRB', 'Serbia', 0, 3),
(241, 'ZA', 'ZAF', 'South Africa', 0, 5),
(242, 'ZM', 'ZMB', 'Zambia', 0, 5),
(243, 'ME', 'MNE', 'Montenegro', 0, 3),
(244, 'ZW', 'ZWE', 'Zimbabwe', 0, 5),
(245, 'A1', 'A1', 'Anonymous Proxy', 0, 1),
(246, 'A2', 'A2', 'Satellite Provider', 0, 1),
(247, 'O1', 'O1', 'Other', 0, 1),
(248, 'AX', 'ALA', 'Aland Islands', 0, 3),
(249, 'GG', 'GGY', 'Guernsey', 0, 3),
(250, 'IM', 'IMN', 'Isle of Man', 0, 3),
(251, 'JE', 'JEY', 'Jersey', 0, 3),
(252, 'BL', 'BLM', 'Saint Barthelemy', 0, 4),
(253, 'MF', 'MAF', 'Saint Martin', 0, 4),
(254, 'CW', 'CUW', 'Curacao', 0, 4),
(255, 'SX', 'SXM', 'Sint Maarten (Dutch part)', 0, 4),
(256, 'BQ', 'BES', 'Bonaire, Saint Eustatius and Saba', 0, 4),
(257, 'SS', 'SSD', 'South Sudan', 0, 5);

-- --------------------------------------------------------

--
-- Table structure for table `mmisps`
--

CREATE TABLE `mmisps` (
  `IspID` mediumint(8) UNSIGNED NOT NULL,
  `IspName` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `mmisps`
--

INSERT INTO `mmisps` (`IspID`, `IspName`) VALUES
(1, '');

-- --------------------------------------------------------

--
-- Table structure for table `mmispscondition`
--

CREATE TABLE `mmispscondition` (
  `IspID` mediumint(8) UNSIGNED NOT NULL,
  `IspName` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `mmispscondition`
--

INSERT INTO `mmispscondition` (`IspID`, `IspName`) VALUES
(1, 'AT&T Internet Services'),
(2, 'AT&T Mobility LLC'),
(3, 'AT&T Services'),
(4, 'AT&T U-verse'),
(5, 'AT&T Wi-Fi Services'),
(6, 'AT&T Wireless'),
(7, 'Cellular South'),
(8, 'Charter Communications'),
(9, 'Clear Wireless'),
(10, 'Cox Communications'),
(11, 'Cricket Communications'),
(12, 'Frontier Communications'),
(13, 'Jasper Wireless'),
(14, 'MetroPCS Wireless'),
(15, 'Sprint PCS'),
(17, 'T-Mobile USA'),
(16, 'TDS Telecom'),
(18, 'Uscarrier Telecom, LLC.'),
(19, 'Verizon Wireless'),
(20, 'Windstream Communications');

-- --------------------------------------------------------

--
-- Table structure for table `mmregions`
--

CREATE TABLE `mmregions` (
  `RegionID` smallint(5) UNSIGNED NOT NULL,
  `RegionCode` varchar(10) NOT NULL,
  `RegionName` varchar(100) NOT NULL,
  `CountryID` smallint(5) UNSIGNED NOT NULL DEFAULT 1,
  `CountryCode` varchar(2) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `mmregions`
--

INSERT INTO `mmregions` (`RegionID`, `RegionCode`, `RegionName`, `CountryID`, `CountryCode`) VALUES
(1, '', '', 1, ''),
(2, '02', 'Canillo', 4, 'AD'),
(3, '03', 'Encamp', 4, 'AD'),
(4, '04', 'La Massana', 4, 'AD'),
(5, '05', 'Ordino', 4, 'AD'),
(6, '06', 'Sant Julia de Loria', 4, 'AD'),
(7, '07', 'Andorra la Vella', 4, 'AD'),
(8, '08', 'Escaldes-Engordany', 4, 'AD'),
(9, '01', 'Abu Dhabi', 5, 'AE'),
(10, '02', 'Ajman', 5, 'AE'),
(11, '03', 'Dubai', 5, 'AE'),
(12, '04', 'Fujairah', 5, 'AE'),
(13, '05', 'Ras Al Khaimah', 5, 'AE'),
(14, '06', 'Sharjah', 5, 'AE'),
(15, '07', 'Umm Al Quwain', 5, 'AE'),
(16, '01', 'Badakhshan', 6, 'AF'),
(17, '02', 'Badghis', 6, 'AF'),
(18, '03', 'Baghlan', 6, 'AF'),
(19, '05', 'Bamian', 6, 'AF'),
(20, '06', 'Farah', 6, 'AF'),
(21, '07', 'Faryab', 6, 'AF'),
(22, '08', 'Ghazni', 6, 'AF'),
(23, '09', 'Ghowr', 6, 'AF'),
(24, '10', 'Helmand', 6, 'AF'),
(25, '11', 'Herat', 6, 'AF'),
(26, '13', 'Kabol', 6, 'AF'),
(27, '14', 'Kapisa', 6, 'AF'),
(28, '17', 'Lowgar', 6, 'AF'),
(29, '18', 'Nangarhar', 6, 'AF'),
(30, '19', 'Nimruz', 6, 'AF'),
(31, '23', 'Kandahar', 6, 'AF'),
(32, '24', 'Kondoz', 6, 'AF'),
(33, '26', 'Takhar', 6, 'AF'),
(34, '27', 'Vardak', 6, 'AF'),
(35, '28', 'Zabol', 6, 'AF'),
(36, '29', 'Paktika', 6, 'AF'),
(37, '30', 'Balkh', 6, 'AF'),
(38, '31', 'Jowzjan', 6, 'AF'),
(39, '32', 'Samangan', 6, 'AF'),
(40, '33', 'Sar-e Pol', 6, 'AF'),
(41, '34', 'Konar', 6, 'AF'),
(42, '35', 'Laghman', 6, 'AF'),
(43, '36', 'Paktia', 6, 'AF'),
(44, '37', 'Khowst', 6, 'AF'),
(45, '38', 'Nurestan', 6, 'AF'),
(46, '39', 'Oruzgan', 6, 'AF'),
(47, '40', 'Parvan', 6, 'AF'),
(48, '41', 'Daykondi', 6, 'AF'),
(49, '42', 'Panjshir', 6, 'AF'),
(50, '01', 'Barbuda', 7, 'AG'),
(51, '03', 'Saint George', 7, 'AG'),
(52, '04', 'Saint John', 7, 'AG'),
(53, '05', 'Saint Mary', 7, 'AG'),
(54, '06', 'Saint Paul', 7, 'AG'),
(55, '07', 'Saint Peter', 7, 'AG'),
(56, '08', 'Saint Philip', 7, 'AG'),
(57, '09', 'Redonda', 7, 'AG'),
(58, '40', 'Berat', 9, 'AL'),
(59, '41', 'Diber', 9, 'AL'),
(60, '42', 'Durres', 9, 'AL'),
(61, '43', 'Elbasan', 9, 'AL'),
(62, '44', 'Fier', 9, 'AL'),
(63, '45', 'Gjirokaster', 9, 'AL'),
(64, '46', 'Korce', 9, 'AL'),
(65, '47', 'Kukes', 9, 'AL'),
(66, '48', 'Lezhe', 9, 'AL'),
(67, '49', 'Shkoder', 9, 'AL'),
(68, '50', 'Tirane', 9, 'AL'),
(69, '51', 'Vlore', 9, 'AL'),
(70, '01', 'Aragatsotn', 10, 'AM'),
(71, '02', 'Ararat', 10, 'AM'),
(72, '03', 'Armavir', 10, 'AM'),
(73, '04', 'Geghark\'unik\'', 10, 'AM'),
(74, '05', 'Kotayk\'', 10, 'AM'),
(75, '06', 'Lorri', 10, 'AM'),
(76, '07', 'Shirak', 10, 'AM'),
(77, '08', 'Syunik\'', 10, 'AM'),
(78, '09', 'Tavush', 10, 'AM'),
(79, '10', 'Vayots\' Dzor', 10, 'AM'),
(80, '11', 'Yerevan', 10, 'AM'),
(81, '01', 'Benguela', 12, 'AO'),
(82, '02', 'Bie', 12, 'AO'),
(83, '03', 'Cabinda', 12, 'AO'),
(84, '04', 'Cuando Cubango', 12, 'AO'),
(85, '05', 'Cuanza Norte', 12, 'AO'),
(86, '06', 'Cuanza Sul', 12, 'AO'),
(87, '07', 'Cunene', 12, 'AO'),
(88, '08', 'Huambo', 12, 'AO'),
(89, '09', 'Huila', 12, 'AO'),
(90, '12', 'Malanje', 12, 'AO'),
(91, '13', 'Namibe', 12, 'AO'),
(92, '14', 'Moxico', 12, 'AO'),
(93, '15', 'Uige', 12, 'AO'),
(94, '16', 'Zaire', 12, 'AO'),
(95, '17', 'Lunda Norte', 12, 'AO'),
(96, '18', 'Lunda Sul', 12, 'AO'),
(97, '19', 'Bengo', 12, 'AO'),
(98, '20', 'Luanda', 12, 'AO'),
(99, '01', 'Buenos Aires', 14, 'AR'),
(100, '02', 'Catamarca', 14, 'AR'),
(101, '03', 'Chaco', 14, 'AR'),
(102, '04', 'Chubut', 14, 'AR'),
(103, '05', 'Cordoba', 14, 'AR'),
(104, '06', 'Corrientes', 14, 'AR'),
(105, '07', 'Distrito Federal', 14, 'AR'),
(106, '08', 'Entre Rios', 14, 'AR'),
(107, '09', 'Formosa', 14, 'AR'),
(108, '10', 'Jujuy', 14, 'AR'),
(109, '11', 'La Pampa', 14, 'AR'),
(110, '12', 'La Rioja', 14, 'AR'),
(111, '13', 'Mendoza', 14, 'AR'),
(112, '14', 'Misiones', 14, 'AR'),
(113, '15', 'Neuquen', 14, 'AR'),
(114, '16', 'Rio Negro', 14, 'AR'),
(115, '17', 'Salta', 14, 'AR'),
(116, '18', 'San Juan', 14, 'AR'),
(117, '19', 'San Luis', 14, 'AR'),
(118, '20', 'Santa Cruz', 14, 'AR'),
(119, '21', 'Santa Fe', 14, 'AR'),
(120, '22', 'Santiago del Estero', 14, 'AR'),
(121, '23', 'Tierra del Fuego', 14, 'AR'),
(122, '24', 'Tucuman', 14, 'AR'),
(123, '01', 'Burgenland', 16, 'AT'),
(124, '02', 'Karnten', 16, 'AT'),
(125, '03', 'Niederosterreich', 16, 'AT'),
(126, '04', 'Oberosterreich', 16, 'AT'),
(127, '05', 'Salzburg', 16, 'AT'),
(128, '06', 'Steiermark', 16, 'AT'),
(129, '07', 'Tirol', 16, 'AT'),
(130, '08', 'Vorarlberg', 16, 'AT'),
(131, '09', 'Wien', 16, 'AT'),
(132, '01', 'Australian Capital Territory', 17, 'AU'),
(133, '02', 'New South Wales', 17, 'AU'),
(134, '03', 'Northern Territory', 17, 'AU'),
(135, '04', 'Queensland', 17, 'AU'),
(136, '05', 'South Australia', 17, 'AU'),
(137, '06', 'Tasmania', 17, 'AU'),
(138, '07', 'Victoria', 17, 'AU'),
(139, '08', 'Western Australia', 17, 'AU'),
(140, '01', 'Abseron', 19, 'AZ'),
(141, '02', 'Agcabadi', 19, 'AZ'),
(142, '03', 'Agdam', 19, 'AZ'),
(143, '04', 'Agdas', 19, 'AZ'),
(144, '05', 'Agstafa', 19, 'AZ'),
(145, '06', 'Agsu', 19, 'AZ'),
(146, '07', 'Ali Bayramli', 19, 'AZ'),
(147, '08', 'Astara', 19, 'AZ'),
(148, '09', 'Baki', 19, 'AZ'),
(149, '10', 'Balakan', 19, 'AZ'),
(150, '11', 'Barda', 19, 'AZ'),
(151, '12', 'Beylaqan', 19, 'AZ'),
(152, '13', 'Bilasuvar', 19, 'AZ'),
(153, '14', 'Cabrayil', 19, 'AZ'),
(154, '15', 'Calilabad', 19, 'AZ'),
(155, '16', 'Daskasan', 19, 'AZ'),
(156, '17', 'Davaci', 19, 'AZ'),
(157, '18', 'Fuzuli', 19, 'AZ'),
(158, '19', 'Gadabay', 19, 'AZ'),
(159, '20', 'Ganca', 19, 'AZ'),
(160, '21', 'Goranboy', 19, 'AZ'),
(161, '22', 'Goycay', 19, 'AZ'),
(162, '23', 'Haciqabul', 19, 'AZ'),
(163, '24', 'Imisli', 19, 'AZ'),
(164, '25', 'Ismayilli', 19, 'AZ'),
(165, '26', 'Kalbacar', 19, 'AZ'),
(166, '27', 'Kurdamir', 19, 'AZ'),
(167, '28', 'Lacin', 19, 'AZ'),
(168, '29', 'Lankaran', 19, 'AZ'),
(169, '30', 'Lankaran', 19, 'AZ'),
(170, '31', 'Lerik', 19, 'AZ'),
(171, '32', 'Masalli', 19, 'AZ'),
(172, '33', 'Mingacevir', 19, 'AZ'),
(173, '34', 'Naftalan', 19, 'AZ'),
(174, '35', 'Naxcivan', 19, 'AZ'),
(175, '36', 'Neftcala', 19, 'AZ'),
(176, '37', 'Oguz', 19, 'AZ'),
(177, '38', 'Qabala', 19, 'AZ'),
(178, '39', 'Qax', 19, 'AZ'),
(179, '40', 'Qazax', 19, 'AZ'),
(180, '41', 'Qobustan', 19, 'AZ'),
(181, '42', 'Quba', 19, 'AZ'),
(182, '43', 'Qubadli', 19, 'AZ'),
(183, '44', 'Qusar', 19, 'AZ'),
(184, '45', 'Saatli', 19, 'AZ'),
(185, '46', 'Sabirabad', 19, 'AZ'),
(186, '47', 'Saki', 19, 'AZ'),
(187, '48', 'Saki', 19, 'AZ'),
(188, '49', 'Salyan', 19, 'AZ'),
(189, '50', 'Samaxi', 19, 'AZ'),
(190, '51', 'Samkir', 19, 'AZ'),
(191, '52', 'Samux', 19, 'AZ'),
(192, '53', 'Siyazan', 19, 'AZ'),
(193, '54', 'Sumqayit', 19, 'AZ'),
(194, '55', 'Susa', 19, 'AZ'),
(195, '56', 'Susa', 19, 'AZ'),
(196, '57', 'Tartar', 19, 'AZ'),
(197, '58', 'Tovuz', 19, 'AZ'),
(198, '59', 'Ucar', 19, 'AZ'),
(199, '60', 'Xacmaz', 19, 'AZ'),
(200, '61', 'Xankandi', 19, 'AZ'),
(201, '62', 'Xanlar', 19, 'AZ'),
(202, '63', 'Xizi', 19, 'AZ'),
(203, '64', 'Xocali', 19, 'AZ'),
(204, '65', 'Xocavand', 19, 'AZ'),
(205, '66', 'Yardimli', 19, 'AZ'),
(206, '67', 'Yevlax', 19, 'AZ'),
(207, '68', 'Yevlax', 19, 'AZ'),
(208, '69', 'Zangilan', 19, 'AZ'),
(209, '70', 'Zaqatala', 19, 'AZ'),
(210, '71', 'Zardab', 19, 'AZ'),
(211, '01', 'Federation of Bosnia and Herzegovina', 20, 'BA'),
(212, '02', 'Republika Srpska', 20, 'BA'),
(213, '01', 'Christ Church', 21, 'BB'),
(214, '02', 'Saint Andrew', 21, 'BB'),
(215, '03', 'Saint George', 21, 'BB'),
(216, '04', 'Saint James', 21, 'BB'),
(217, '05', 'Saint John', 21, 'BB'),
(218, '06', 'Saint Joseph', 21, 'BB'),
(219, '07', 'Saint Lucy', 21, 'BB'),
(220, '08', 'Saint Michael', 21, 'BB'),
(221, '09', 'Saint Peter', 21, 'BB'),
(222, '10', 'Saint Philip', 21, 'BB'),
(223, '11', 'Saint Thomas', 21, 'BB'),
(224, '81', 'Dhaka', 22, 'BD'),
(225, '82', 'Khulna', 22, 'BD'),
(226, '83', 'Rajshahi', 22, 'BD'),
(227, '84', 'Chittagong', 22, 'BD'),
(228, '85', 'Barisal', 22, 'BD'),
(229, '86', 'Sylhet', 22, 'BD'),
(230, '01', 'Antwerpen', 23, 'BE'),
(231, '03', 'Hainaut', 23, 'BE'),
(232, '04', 'Liege', 23, 'BE'),
(233, '05', 'Limburg', 23, 'BE'),
(234, '06', 'Luxembourg', 23, 'BE'),
(235, '07', 'Namur', 23, 'BE'),
(236, '08', 'Oost-Vlaanderen', 23, 'BE'),
(237, '09', 'West-Vlaanderen', 23, 'BE'),
(238, '10', 'Brabant Wallon', 23, 'BE'),
(239, '11', 'Brussels Hoofdstedelijk Gewest', 23, 'BE'),
(240, '12', 'Vlaams-Brabant', 23, 'BE'),
(241, '15', 'Bam', 24, 'BF'),
(242, '19', 'Boulkiemde', 24, 'BF'),
(243, '20', 'Ganzourgou', 24, 'BF'),
(244, '21', 'Gnagna', 24, 'BF'),
(245, '28', 'Kouritenga', 24, 'BF'),
(246, '33', 'Oudalan', 24, 'BF'),
(247, '34', 'Passore', 24, 'BF'),
(248, '36', 'Sanguie', 24, 'BF'),
(249, '40', 'Soum', 24, 'BF'),
(250, '42', 'Tapoa', 24, 'BF'),
(251, '44', 'Zoundweogo', 24, 'BF'),
(252, '45', 'Bale', 24, 'BF'),
(253, '46', 'Banwa', 24, 'BF'),
(254, '47', 'Bazega', 24, 'BF'),
(255, '48', 'Bougouriba', 24, 'BF'),
(256, '49', 'Boulgou', 24, 'BF'),
(257, '50', 'Gourma', 24, 'BF'),
(258, '51', 'Houet', 24, 'BF'),
(259, '52', 'Ioba', 24, 'BF'),
(260, '53', 'Kadiogo', 24, 'BF'),
(261, '54', 'Kenedougou', 24, 'BF'),
(262, '55', 'Komoe', 24, 'BF'),
(263, '56', 'Komondjari', 24, 'BF'),
(264, '57', 'Kompienga', 24, 'BF'),
(265, '58', 'Kossi', 24, 'BF'),
(266, '59', 'Koulpelogo', 24, 'BF'),
(267, '60', 'Kourweogo', 24, 'BF'),
(268, '61', 'Leraba', 24, 'BF'),
(269, '62', 'Loroum', 24, 'BF'),
(270, '63', 'Mouhoun', 24, 'BF'),
(271, '64', 'Namentenga', 24, 'BF'),
(272, '65', 'Naouri', 24, 'BF'),
(273, '66', 'Nayala', 24, 'BF'),
(274, '67', 'Noumbiel', 24, 'BF'),
(275, '68', 'Oubritenga', 24, 'BF'),
(276, '69', 'Poni', 24, 'BF'),
(277, '70', 'Sanmatenga', 24, 'BF'),
(278, '71', 'Seno', 24, 'BF'),
(279, '72', 'Sissili', 24, 'BF'),
(280, '73', 'Sourou', 24, 'BF'),
(281, '74', 'Tuy', 24, 'BF'),
(282, '75', 'Yagha', 24, 'BF'),
(283, '76', 'Yatenga', 24, 'BF'),
(284, '77', 'Ziro', 24, 'BF'),
(285, '78', 'Zondoma', 24, 'BF'),
(286, '33', 'Mikhaylovgrad', 25, 'BG'),
(287, '38', 'Blagoevgrad', 25, 'BG'),
(288, '39', 'Burgas', 25, 'BG'),
(289, '40', 'Dobrich', 25, 'BG'),
(290, '41', 'Gabrovo', 25, 'BG'),
(291, '42', 'Grad Sofiya', 25, 'BG'),
(292, '43', 'Khaskovo', 25, 'BG'),
(293, '44', 'Kurdzhali', 25, 'BG'),
(294, '45', 'Kyustendil', 25, 'BG'),
(295, '46', 'Lovech', 25, 'BG'),
(296, '47', 'Montana', 25, 'BG'),
(297, '48', 'Pazardzhik', 25, 'BG'),
(298, '49', 'Pernik', 25, 'BG'),
(299, '50', 'Pleven', 25, 'BG'),
(300, '51', 'Plovdiv', 25, 'BG'),
(301, '52', 'Razgrad', 25, 'BG'),
(302, '53', 'Ruse', 25, 'BG'),
(303, '54', 'Shumen', 25, 'BG'),
(304, '55', 'Silistra', 25, 'BG'),
(305, '56', 'Sliven', 25, 'BG'),
(306, '57', 'Smolyan', 25, 'BG'),
(307, '58', 'Sofiya', 25, 'BG'),
(308, '59', 'Stara Zagora', 25, 'BG'),
(309, '60', 'Turgovishte', 25, 'BG'),
(310, '61', 'Varna', 25, 'BG'),
(311, '62', 'Veliko Turnovo', 25, 'BG'),
(312, '63', 'Vidin', 25, 'BG'),
(313, '64', 'Vratsa', 25, 'BG'),
(314, '65', 'Yambol', 25, 'BG'),
(315, '01', 'Al Hadd', 26, 'BH'),
(316, '02', 'Al Manamah', 26, 'BH'),
(317, '05', 'Jidd Hafs', 26, 'BH'),
(318, '06', 'Sitrah', 26, 'BH'),
(319, '08', 'Al Mintaqah al Gharbiyah', 26, 'BH'),
(320, '09', 'Mintaqat Juzur Hawar', 26, 'BH'),
(321, '10', 'Al Mintaqah ash Shamaliyah', 26, 'BH'),
(322, '11', 'Al Mintaqah al Wusta', 26, 'BH'),
(323, '12', 'Madinat', 26, 'BH'),
(324, '13', 'Ar Rifa', 26, 'BH'),
(325, '14', 'Madinat Hamad', 26, 'BH'),
(326, '15', 'Al Muharraq', 26, 'BH'),
(327, '16', 'Al Asimah', 26, 'BH'),
(328, '17', 'Al Janubiyah', 26, 'BH'),
(329, '18', 'Ash Shamaliyah', 26, 'BH'),
(330, '19', 'Al Wusta', 26, 'BH'),
(331, '02', 'Bujumbura', 27, 'BI'),
(332, '09', 'Bubanza', 27, 'BI'),
(333, '10', 'Bururi', 27, 'BI'),
(334, '11', 'Cankuzo', 27, 'BI'),
(335, '12', 'Cibitoke', 27, 'BI'),
(336, '13', 'Gitega', 27, 'BI'),
(337, '14', 'Karuzi', 27, 'BI'),
(338, '15', 'Kayanza', 27, 'BI'),
(339, '16', 'Kirundo', 27, 'BI'),
(340, '17', 'Makamba', 27, 'BI'),
(341, '18', 'Muyinga', 27, 'BI'),
(342, '19', 'Ngozi', 27, 'BI'),
(343, '20', 'Rutana', 27, 'BI'),
(344, '21', 'Ruyigi', 27, 'BI'),
(345, '22', 'Muramvya', 27, 'BI'),
(346, '23', 'Mwaro', 27, 'BI'),
(347, '07', 'Alibori', 28, 'BJ'),
(348, '08', 'Atakora', 28, 'BJ'),
(349, '09', 'Atlanyique', 28, 'BJ'),
(350, '10', 'Borgou', 28, 'BJ'),
(351, '11', 'Collines', 28, 'BJ'),
(352, '12', 'Kouffo', 28, 'BJ'),
(353, '13', 'Donga', 28, 'BJ'),
(354, '14', 'Littoral', 28, 'BJ'),
(355, '15', 'Mono', 28, 'BJ'),
(356, '16', 'Oueme', 28, 'BJ'),
(357, '17', 'Plateau', 28, 'BJ'),
(358, '18', 'Zou', 28, 'BJ'),
(359, '01', 'Devonshire', 29, 'BM'),
(360, '02', 'Hamilton', 29, 'BM'),
(361, '03', 'Hamilton', 29, 'BM'),
(362, '04', 'Paget', 29, 'BM'),
(363, '05', 'Pembroke', 29, 'BM'),
(364, '06', 'Saint George', 29, 'BM'),
(365, '07', 'Saint George\'s', 29, 'BM'),
(366, '08', 'Sandys', 29, 'BM'),
(367, '09', 'Smiths', 29, 'BM'),
(368, '10', 'Southampton', 29, 'BM'),
(369, '11', 'Warwick', 29, 'BM'),
(370, '07', 'Alibori', 30, 'BN'),
(371, '08', 'Belait', 30, 'BN'),
(372, '09', 'Brunei and Muara', 30, 'BN'),
(373, '10', 'Temburong', 30, 'BN'),
(374, '11', 'Collines', 30, 'BN'),
(375, '12', 'Kouffo', 30, 'BN'),
(376, '13', 'Donga', 30, 'BN'),
(377, '14', 'Littoral', 30, 'BN'),
(378, '15', 'Tutong', 30, 'BN'),
(379, '16', 'Oueme', 30, 'BN'),
(380, '17', 'Plateau', 30, 'BN'),
(381, '18', 'Zou', 30, 'BN'),
(382, '01', 'Chuquisaca', 31, 'BO'),
(383, '02', 'Cochabamba', 31, 'BO'),
(384, '03', 'El Beni', 31, 'BO'),
(385, '04', 'La Paz', 31, 'BO'),
(386, '05', 'Oruro', 31, 'BO'),
(387, '06', 'Pando', 31, 'BO'),
(388, '07', 'Potosi', 31, 'BO'),
(389, '08', 'Santa Cruz', 31, 'BO'),
(390, '09', 'Tarija', 31, 'BO'),
(391, '01', 'Acre', 32, 'BR'),
(392, '02', 'Alagoas', 32, 'BR'),
(393, '03', 'Amapa', 32, 'BR'),
(394, '04', 'Amazonas', 32, 'BR'),
(395, '05', 'Bahia', 32, 'BR'),
(396, '06', 'Ceara', 32, 'BR'),
(397, '07', 'Distrito Federal', 32, 'BR'),
(398, '08', 'Espirito Santo', 32, 'BR'),
(399, '11', 'Mato Grosso do Sul', 32, 'BR'),
(400, '13', 'Maranhao', 32, 'BR'),
(401, '14', 'Mato Grosso', 32, 'BR'),
(402, '15', 'Minas Gerais', 32, 'BR'),
(403, '16', 'Para', 32, 'BR'),
(404, '17', 'Paraiba', 32, 'BR'),
(405, '18', 'Parana', 32, 'BR'),
(406, '20', 'Piaui', 32, 'BR'),
(407, '21', 'Rio de Janeiro', 32, 'BR'),
(408, '22', 'Rio Grande do Norte', 32, 'BR'),
(409, '23', 'Rio Grande do Sul', 32, 'BR'),
(410, '24', 'Rondonia', 32, 'BR'),
(411, '25', 'Roraima', 32, 'BR'),
(412, '26', 'Santa Catarina', 32, 'BR'),
(413, '27', 'Sao Paulo', 32, 'BR'),
(414, '28', 'Sergipe', 32, 'BR'),
(415, '29', 'Goias', 32, 'BR'),
(416, '30', 'Pernambuco', 32, 'BR'),
(417, '31', 'Tocantins', 32, 'BR'),
(418, '05', 'Bimini', 33, 'BS'),
(419, '06', 'Cat Island', 33, 'BS'),
(420, '10', 'Exuma', 33, 'BS'),
(421, '13', 'Inagua', 33, 'BS'),
(422, '15', 'Long Island', 33, 'BS'),
(423, '16', 'Mayaguana', 33, 'BS'),
(424, '18', 'Ragged Island', 33, 'BS'),
(425, '22', 'Harbour Island', 33, 'BS'),
(426, '23', 'New Providence', 33, 'BS'),
(427, '24', 'Acklins and Crooked Islands', 33, 'BS'),
(428, '25', 'Freeport', 33, 'BS'),
(429, '26', 'Fresh Creek', 33, 'BS'),
(430, '27', 'Governor\'s Harbour', 33, 'BS'),
(431, '28', 'Green Turtle Cay', 33, 'BS'),
(432, '29', 'High Rock', 33, 'BS'),
(433, '30', 'Kemps Bay', 33, 'BS'),
(434, '31', 'Marsh Harbour', 33, 'BS'),
(435, '32', 'Nichollstown and Berry Islands', 33, 'BS'),
(436, '33', 'Rock Sound', 33, 'BS'),
(437, '34', 'Sandy Point', 33, 'BS'),
(438, '35', 'San Salvador and Rum Cay', 33, 'BS'),
(439, '05', 'Bumthang', 34, 'BT'),
(440, '06', 'Chhukha', 34, 'BT'),
(441, '07', 'Chirang', 34, 'BT'),
(442, '08', 'Daga', 34, 'BT'),
(443, '09', 'Geylegphug', 34, 'BT'),
(444, '10', 'Ha', 34, 'BT'),
(445, '11', 'Lhuntshi', 34, 'BT'),
(446, '12', 'Mongar', 34, 'BT'),
(447, '13', 'Paro', 34, 'BT'),
(448, '14', 'Pemagatsel', 34, 'BT'),
(449, '15', 'Punakha', 34, 'BT'),
(450, '16', 'Samchi', 34, 'BT'),
(451, '17', 'Samdrup', 34, 'BT'),
(452, '18', 'Shemgang', 34, 'BT'),
(453, '19', 'Tashigang', 34, 'BT'),
(454, '20', 'Thimphu', 34, 'BT'),
(455, '21', 'Tongsa', 34, 'BT'),
(456, '22', 'Wangdi Phodrang', 34, 'BT'),
(457, '01', 'Central', 36, 'BW'),
(458, '03', 'Ghanzi', 36, 'BW'),
(459, '04', 'Kgalagadi', 36, 'BW'),
(460, '05', 'Kgatleng', 36, 'BW'),
(461, '06', 'Kweneng', 36, 'BW'),
(462, '08', 'North-East', 36, 'BW'),
(463, '09', 'South-East', 36, 'BW'),
(464, '10', 'Southern', 36, 'BW'),
(465, '11', 'North-West', 36, 'BW'),
(466, '01', 'Brestskaya Voblasts\'', 37, 'BY'),
(467, '02', 'Homyel\'skaya Voblasts\'', 37, 'BY'),
(468, '03', 'Hrodzyenskaya Voblasts\'', 37, 'BY'),
(469, '04', 'Minsk', 37, 'BY'),
(470, '05', 'Minskaya Voblasts\'', 37, 'BY'),
(471, '06', 'Mahilyowskaya Voblasts\'', 37, 'BY'),
(472, '07', 'Vitsyebskaya Voblasts\'', 37, 'BY'),
(473, '01', 'Belize', 38, 'BZ'),
(474, '02', 'Cayo', 38, 'BZ'),
(475, '03', 'Corozal', 38, 'BZ'),
(476, '04', 'Orange Walk', 38, 'BZ'),
(477, '05', 'Stann Creek', 38, 'BZ'),
(478, '06', 'Toledo', 38, 'BZ'),
(479, 'AB', 'Alberta', 39, 'CA'),
(480, 'BC', 'British Columbia', 39, 'CA'),
(481, 'MB', 'Manitoba', 39, 'CA'),
(482, 'NB', 'New Brunswick', 39, 'CA'),
(483, 'NL', 'Newfoundland', 39, 'CA'),
(484, 'NS', 'Nova Scotia', 39, 'CA'),
(485, 'NT', 'Northwest Territories', 39, 'CA'),
(486, 'NU', 'Nunavut', 39, 'CA'),
(487, 'ON', 'Ontario', 39, 'CA'),
(488, 'PE', 'Prince Edward Island', 39, 'CA'),
(489, 'QC', 'Quebec', 39, 'CA'),
(490, 'SK', 'Saskatchewan', 39, 'CA'),
(491, 'YT', 'Yukon Territory', 39, 'CA'),
(492, '01', 'Bandundu', 41, 'CD'),
(493, '02', 'Equateur', 41, 'CD'),
(494, '04', 'Kasai-Oriental', 41, 'CD'),
(495, '05', 'Katanga', 41, 'CD'),
(496, '06', 'Kinshasa', 41, 'CD'),
(497, '08', 'Bas-Congo', 41, 'CD'),
(498, '09', 'Orientale', 41, 'CD'),
(499, '10', 'Maniema', 41, 'CD'),
(500, '11', 'Nord-Kivu', 41, 'CD'),
(501, '12', 'Sud-Kivu', 41, 'CD'),
(502, '01', 'Bamingui-Bangoran', 42, 'CF'),
(503, '02', 'Basse-Kotto', 42, 'CF'),
(504, '03', 'Haute-Kotto', 42, 'CF'),
(505, '04', 'Mambere-Kadei', 42, 'CF'),
(506, '05', 'Haut-Mbomou', 42, 'CF'),
(507, '06', 'Kemo', 42, 'CF'),
(508, '07', 'Lobaye', 42, 'CF'),
(509, '08', 'Mbomou', 42, 'CF'),
(510, '09', 'Nana-Mambere', 42, 'CF'),
(511, '11', 'Ouaka', 42, 'CF'),
(512, '12', 'Ouham', 42, 'CF'),
(513, '13', 'Ouham-Pende', 42, 'CF'),
(514, '14', 'Cuvette-Ouest', 42, 'CF'),
(515, '15', 'Nana-Grebizi', 42, 'CF'),
(516, '16', 'Sangha-Mbaere', 42, 'CF'),
(517, '17', 'Ombella-Mpoko', 42, 'CF'),
(518, '18', 'Bangui', 42, 'CF'),
(519, '01', 'Bouenza', 43, 'CG'),
(520, '04', 'Kouilou', 43, 'CG'),
(521, '05', 'Lekoumou', 43, 'CG'),
(522, '06', 'Likouala', 43, 'CG'),
(523, '07', 'Niari', 43, 'CG'),
(524, '08', 'Plateaux', 43, 'CG'),
(525, '10', 'Sangha', 43, 'CG'),
(526, '11', 'Pool', 43, 'CG'),
(527, '12', 'Brazzaville', 43, 'CG'),
(528, '13', 'Cuvette', 43, 'CG'),
(529, '14', 'Cuvette-Ouest', 43, 'CG'),
(530, '01', 'Aargau', 44, 'CH'),
(531, '02', 'Ausser-Rhoden', 44, 'CH'),
(532, '03', 'Basel-Landschaft', 44, 'CH'),
(533, '04', 'Basel-Stadt', 44, 'CH'),
(534, '05', 'Bern', 44, 'CH'),
(535, '06', 'Fribourg', 44, 'CH'),
(536, '07', 'Geneve', 44, 'CH'),
(537, '08', 'Glarus', 44, 'CH'),
(538, '09', 'Graubunden', 44, 'CH'),
(539, '10', 'Inner-Rhoden', 44, 'CH'),
(540, '11', 'Luzern', 44, 'CH'),
(541, '12', 'Neuchatel', 44, 'CH'),
(542, '13', 'Nidwalden', 44, 'CH'),
(543, '14', 'Obwalden', 44, 'CH'),
(544, '15', 'Sankt Gallen', 44, 'CH'),
(545, '16', 'Schaffhausen', 44, 'CH'),
(546, '17', 'Schwyz', 44, 'CH'),
(547, '18', 'Solothurn', 44, 'CH'),
(548, '19', 'Thurgau', 44, 'CH'),
(549, '20', 'Ticino', 44, 'CH'),
(550, '21', 'Uri', 44, 'CH'),
(551, '22', 'Valais', 44, 'CH'),
(552, '23', 'Vaud', 44, 'CH'),
(553, '24', 'Zug', 44, 'CH'),
(554, '25', 'Zurich', 44, 'CH'),
(555, '26', 'Jura', 44, 'CH'),
(556, '74', 'Agneby', 45, 'CI'),
(557, '75', 'Bafing', 45, 'CI'),
(558, '76', 'Bas-Sassandra', 45, 'CI'),
(559, '77', 'Denguele', 45, 'CI'),
(560, '78', 'Dix-Huit Montagnes', 45, 'CI'),
(561, '79', 'Fromager', 45, 'CI'),
(562, '80', 'Haut-Sassandra', 45, 'CI'),
(563, '81', 'Lacs', 45, 'CI'),
(564, '82', 'Lagunes', 45, 'CI'),
(565, '83', 'Marahoue', 45, 'CI'),
(566, '84', 'Moyen-Cavally', 45, 'CI'),
(567, '85', 'Moyen-Comoe', 45, 'CI'),
(568, '86', 'N\'zi-Comoe', 45, 'CI'),
(569, '87', 'Savanes', 45, 'CI'),
(570, '88', 'Sud-Bandama', 45, 'CI'),
(571, '89', 'Sud-Comoe', 45, 'CI'),
(572, '90', 'Vallee du Bandama', 45, 'CI'),
(573, '91', 'Worodougou', 45, 'CI'),
(574, '92', 'Zanzan', 45, 'CI'),
(575, '01', 'Valparaiso', 47, 'CL'),
(576, '02', 'Aisen del General Carlos Ibanez del Campo', 47, 'CL'),
(577, '03', 'Antofagasta', 47, 'CL'),
(578, '04', 'Araucania', 47, 'CL'),
(579, '05', 'Atacama', 47, 'CL'),
(580, '06', 'Bio-Bio', 47, 'CL'),
(581, '07', 'Coquimbo', 47, 'CL'),
(582, '08', 'Libertador General Bernardo O\'Higgins', 47, 'CL'),
(583, '09', 'Los Lagos', 47, 'CL'),
(584, '10', 'Magallanes y de la Antartica Chilena', 47, 'CL'),
(585, '11', 'Maule', 47, 'CL'),
(586, '12', 'Region Metropolitana', 47, 'CL'),
(587, '13', 'Tarapaca', 47, 'CL'),
(588, '14', 'Los Lagos', 47, 'CL'),
(589, '15', 'Tarapaca', 47, 'CL'),
(590, '16', 'Arica y Parinacota', 47, 'CL'),
(591, '17', 'Los Rios', 47, 'CL'),
(592, '04', 'Est', 48, 'CM'),
(593, '05', 'Littoral', 48, 'CM'),
(594, '07', 'Nord-Ouest', 48, 'CM'),
(595, '08', 'Ouest', 48, 'CM'),
(596, '09', 'Sud-Ouest', 48, 'CM'),
(597, '10', 'Adamaoua', 48, 'CM'),
(598, '11', 'Centre', 48, 'CM'),
(599, '12', 'Extreme-Nord', 48, 'CM'),
(600, '13', 'Nord', 48, 'CM'),
(601, '14', 'Sud', 48, 'CM'),
(602, '01', 'Anhui', 49, 'CN'),
(603, '02', 'Zhejiang', 49, 'CN'),
(604, '03', 'Jiangxi', 49, 'CN'),
(605, '04', 'Jiangsu', 49, 'CN'),
(606, '05', 'Jilin', 49, 'CN'),
(607, '06', 'Qinghai', 49, 'CN'),
(608, '07', 'Fujian', 49, 'CN'),
(609, '08', 'Heilongjiang', 49, 'CN'),
(610, '09', 'Henan', 49, 'CN'),
(611, '10', 'Hebei', 49, 'CN'),
(612, '11', 'Hunan', 49, 'CN'),
(613, '12', 'Hubei', 49, 'CN'),
(614, '13', 'Xinjiang', 49, 'CN'),
(615, '14', 'Xizang', 49, 'CN'),
(616, '15', 'Gansu', 49, 'CN'),
(617, '16', 'Guangxi', 49, 'CN'),
(618, '18', 'Guizhou', 49, 'CN'),
(619, '19', 'Liaoning', 49, 'CN'),
(620, '20', 'Nei Mongol', 49, 'CN'),
(621, '21', 'Ningxia', 49, 'CN'),
(622, '22', 'Beijing', 49, 'CN'),
(623, '23', 'Shanghai', 49, 'CN'),
(624, '24', 'Shanxi', 49, 'CN'),
(625, '25', 'Shandong', 49, 'CN'),
(626, '26', 'Shaanxi', 49, 'CN'),
(627, '28', 'Tianjin', 49, 'CN'),
(628, '29', 'Yunnan', 49, 'CN'),
(629, '30', 'Guangdong', 49, 'CN'),
(630, '31', 'Hainan', 49, 'CN'),
(631, '32', 'Sichuan', 49, 'CN'),
(632, '33', 'Chongqing', 49, 'CN'),
(633, '01', 'Amazonas', 50, 'CO'),
(634, '02', 'Antioquia', 50, 'CO'),
(635, '03', 'Arauca', 50, 'CO'),
(636, '04', 'Atlantico', 50, 'CO'),
(637, '05', 'Bolivar Department', 50, 'CO'),
(638, '06', 'Boyaca Department', 50, 'CO'),
(639, '07', 'Caldas Department', 50, 'CO'),
(640, '08', 'Caqueta', 50, 'CO'),
(641, '09', 'Cauca', 50, 'CO'),
(642, '10', 'Cesar', 50, 'CO'),
(643, '11', 'Choco', 50, 'CO'),
(644, '12', 'Cordoba', 50, 'CO'),
(645, '14', 'Guaviare', 50, 'CO'),
(646, '15', 'Guainia', 50, 'CO'),
(647, '16', 'Huila', 50, 'CO'),
(648, '17', 'La Guajira', 50, 'CO'),
(649, '18', 'Magdalena Department', 50, 'CO'),
(650, '19', 'Meta', 50, 'CO'),
(651, '20', 'Narino', 50, 'CO'),
(652, '21', 'Norte de Santander', 50, 'CO'),
(653, '22', 'Putumayo', 50, 'CO'),
(654, '23', 'Quindio', 50, 'CO'),
(655, '24', 'Risaralda', 50, 'CO'),
(656, '25', 'San Andres y Providencia', 50, 'CO'),
(657, '26', 'Santander', 50, 'CO'),
(658, '27', 'Sucre', 50, 'CO'),
(659, '28', 'Tolima', 50, 'CO'),
(660, '29', 'Valle del Cauca', 50, 'CO'),
(661, '30', 'Vaupes', 50, 'CO'),
(662, '31', 'Vichada', 50, 'CO'),
(663, '32', 'Casanare', 50, 'CO'),
(664, '33', 'Cundinamarca', 50, 'CO'),
(665, '34', 'Distrito Especial', 50, 'CO'),
(666, '35', 'Bolivar', 50, 'CO'),
(667, '36', 'Boyaca', 50, 'CO'),
(668, '37', 'Caldas', 50, 'CO'),
(669, '38', 'Magdalena', 50, 'CO'),
(670, '01', 'Alajuela', 51, 'CR'),
(671, '02', 'Cartago', 51, 'CR'),
(672, '03', 'Guanacaste', 51, 'CR'),
(673, '04', 'Heredia', 51, 'CR'),
(674, '06', 'Limon', 51, 'CR'),
(675, '07', 'Puntarenas', 51, 'CR'),
(676, '08', 'San Jose', 51, 'CR'),
(677, '01', 'Pinar del Rio', 52, 'CU'),
(678, '02', 'Ciudad de la Habana', 52, 'CU'),
(679, '03', 'Matanzas', 52, 'CU'),
(680, '04', 'Isla de la Juventud', 52, 'CU'),
(681, '05', 'Camaguey', 52, 'CU'),
(682, '07', 'Ciego de Avila', 52, 'CU'),
(683, '08', 'Cienfuegos', 52, 'CU'),
(684, '09', 'Granma', 52, 'CU'),
(685, '10', 'Guantanamo', 52, 'CU'),
(686, '11', 'La Habana', 52, 'CU'),
(687, '12', 'Holguin', 52, 'CU'),
(688, '13', 'Las Tunas', 52, 'CU'),
(689, '14', 'Sancti Spiritus', 52, 'CU'),
(690, '15', 'Santiago de Cuba', 52, 'CU'),
(691, '16', 'Villa Clara', 52, 'CU'),
(692, '01', 'Boa Vista', 53, 'CV'),
(693, '02', 'Brava', 53, 'CV'),
(694, '04', 'Maio', 53, 'CV'),
(695, '05', 'Paul', 53, 'CV'),
(696, '07', 'Ribeira Grande', 53, 'CV'),
(697, '08', 'Sal', 53, 'CV'),
(698, '10', 'Sao Nicolau', 53, 'CV'),
(699, '11', 'Sao Vicente', 53, 'CV'),
(700, '13', 'Mosteiros', 53, 'CV'),
(701, '14', 'Praia', 53, 'CV'),
(702, '15', 'Santa Catarina', 53, 'CV'),
(703, '16', 'Santa Cruz', 53, 'CV'),
(704, '17', 'Sao Domingos', 53, 'CV'),
(705, '18', 'Sao Filipe', 53, 'CV'),
(706, '19', 'Sao Miguel', 53, 'CV'),
(707, '20', 'Tarrafal', 53, 'CV'),
(708, '01', 'Famagusta', 55, 'CY'),
(709, '02', 'Kyrenia', 55, 'CY'),
(710, '03', 'Larnaca', 55, 'CY'),
(711, '04', 'Nicosia', 55, 'CY'),
(712, '05', 'Limassol', 55, 'CY'),
(713, '06', 'Paphos', 55, 'CY'),
(714, '52', 'Hlavni mesto Praha', 56, 'CZ'),
(715, '78', 'Jihomoravsky kraj', 56, 'CZ'),
(716, '79', 'Jihocesky kraj', 56, 'CZ'),
(717, '80', 'Vysocina', 56, 'CZ'),
(718, '81', 'Karlovarsky kraj', 56, 'CZ'),
(719, '82', 'Kralovehradecky kraj', 56, 'CZ'),
(720, '83', 'Liberecky kraj', 56, 'CZ'),
(721, '84', 'Olomoucky kraj', 56, 'CZ'),
(722, '85', 'Moravskoslezsky kraj', 56, 'CZ'),
(723, '86', 'Pardubicky kraj', 56, 'CZ'),
(724, '87', 'Plzensky kraj', 56, 'CZ'),
(725, '88', 'Stredocesky kraj', 56, 'CZ'),
(726, '89', 'Ustecky kraj', 56, 'CZ'),
(727, '90', 'Zlinsky kraj', 56, 'CZ'),
(728, '01', 'Baden-Wurttemberg', 57, 'DE'),
(729, '02', 'Bayern', 57, 'DE'),
(730, '03', 'Bremen', 57, 'DE'),
(731, '04', 'Hamburg', 57, 'DE'),
(732, '05', 'Hessen', 57, 'DE'),
(733, '06', 'Niedersachsen', 57, 'DE'),
(734, '07', 'Nordrhein-Westfalen', 57, 'DE'),
(735, '08', 'Rheinland-Pfalz', 57, 'DE'),
(736, '09', 'Saarland', 57, 'DE'),
(737, '10', 'Schleswig-Holstein', 57, 'DE'),
(738, '11', 'Brandenburg', 57, 'DE'),
(739, '12', 'Mecklenburg-Vorpommern', 57, 'DE'),
(740, '13', 'Sachsen', 57, 'DE'),
(741, '14', 'Sachsen-Anhalt', 57, 'DE'),
(742, '15', 'Thuringen', 57, 'DE'),
(743, '16', 'Berlin', 57, 'DE'),
(744, '01', 'Ali Sabieh', 58, 'DJ'),
(745, '04', 'Obock', 58, 'DJ'),
(746, '05', 'Tadjoura', 58, 'DJ'),
(747, '06', 'Dikhil', 58, 'DJ'),
(748, '07', 'Djibouti', 58, 'DJ'),
(749, '08', 'Arta', 58, 'DJ'),
(750, '17', 'Hovedstaden', 59, 'DK'),
(751, '18', 'Midtjylland', 59, 'DK'),
(752, '19', 'Nordjylland', 59, 'DK'),
(753, '20', 'Sjelland', 59, 'DK'),
(754, '21', 'Syddanmark', 59, 'DK'),
(755, '02', 'Saint Andrew', 60, 'DM'),
(756, '03', 'Saint David', 60, 'DM'),
(757, '04', 'Saint George', 60, 'DM'),
(758, '05', 'Saint John', 60, 'DM'),
(759, '06', 'Saint Joseph', 60, 'DM'),
(760, '07', 'Saint Luke', 60, 'DM'),
(761, '08', 'Saint Mark', 60, 'DM'),
(762, '09', 'Saint Patrick', 60, 'DM'),
(763, '10', 'Saint Paul', 60, 'DM'),
(764, '11', 'Saint Peter', 60, 'DM'),
(765, '01', 'Azua', 61, 'DO'),
(766, '02', 'Baoruco', 61, 'DO'),
(767, '03', 'Barahona', 61, 'DO'),
(768, '04', 'Dajabon', 61, 'DO'),
(769, '05', 'Distrito Nacional', 61, 'DO'),
(770, '06', 'Duarte', 61, 'DO'),
(771, '08', 'Espaillat', 61, 'DO'),
(772, '09', 'Independencia', 61, 'DO'),
(773, '10', 'La Altagracia', 61, 'DO'),
(774, '11', 'Elias Pina', 61, 'DO'),
(775, '12', 'La Romana', 61, 'DO'),
(776, '14', 'Maria Trinidad Sanchez', 61, 'DO'),
(777, '15', 'Monte Cristi', 61, 'DO'),
(778, '16', 'Pedernales', 61, 'DO'),
(779, '17', 'Peravia', 61, 'DO'),
(780, '18', 'Puerto Plata', 61, 'DO'),
(781, '19', 'Salcedo', 61, 'DO'),
(782, '20', 'Samana', 61, 'DO'),
(783, '21', 'Sanchez Ramirez', 61, 'DO'),
(784, '23', 'San Juan', 61, 'DO'),
(785, '24', 'San Pedro De Macoris', 61, 'DO'),
(786, '25', 'Santiago', 61, 'DO'),
(787, '26', 'Santiago Rodriguez', 61, 'DO'),
(788, '27', 'Valverde', 61, 'DO'),
(789, '28', 'El Seibo', 61, 'DO'),
(790, '29', 'Hato Mayor', 61, 'DO'),
(791, '30', 'La Vega', 61, 'DO'),
(792, '31', 'Monsenor Nouel', 61, 'DO'),
(793, '32', 'Monte Plata', 61, 'DO'),
(794, '33', 'San Cristobal', 61, 'DO'),
(795, '34', 'Distrito Nacional', 61, 'DO'),
(796, '35', 'Peravia', 61, 'DO'),
(797, '36', 'San Jose de Ocoa', 61, 'DO'),
(798, '37', 'Santo Domingo', 61, 'DO'),
(799, '01', 'Alger', 62, 'DZ'),
(800, '03', 'Batna', 62, 'DZ'),
(801, '04', 'Constantine', 62, 'DZ'),
(802, '06', 'Medea', 62, 'DZ'),
(803, '07', 'Mostaganem', 62, 'DZ'),
(804, '09', 'Oran', 62, 'DZ'),
(805, '10', 'Saida', 62, 'DZ'),
(806, '12', 'Setif', 62, 'DZ'),
(807, '13', 'Tiaret', 62, 'DZ'),
(808, '14', 'Tizi Ouzou', 62, 'DZ'),
(809, '15', 'Tlemcen', 62, 'DZ'),
(810, '18', 'Bejaia', 62, 'DZ'),
(811, '19', 'Biskra', 62, 'DZ'),
(812, '20', 'Blida', 62, 'DZ'),
(813, '21', 'Bouira', 62, 'DZ'),
(814, '22', 'Djelfa', 62, 'DZ'),
(815, '23', 'Guelma', 62, 'DZ'),
(816, '24', 'Jijel', 62, 'DZ'),
(817, '25', 'Laghouat', 62, 'DZ'),
(818, '26', 'Mascara', 62, 'DZ'),
(819, '27', 'M\'sila', 62, 'DZ'),
(820, '29', 'Oum el Bouaghi', 62, 'DZ'),
(821, '30', 'Sidi Bel Abbes', 62, 'DZ'),
(822, '31', 'Skikda', 62, 'DZ'),
(823, '33', 'Tebessa', 62, 'DZ'),
(824, '34', 'Adrar', 62, 'DZ'),
(825, '35', 'Ain Defla', 62, 'DZ'),
(826, '36', 'Ain Temouchent', 62, 'DZ'),
(827, '37', 'Annaba', 62, 'DZ'),
(828, '38', 'Bechar', 62, 'DZ'),
(829, '39', 'Bordj Bou Arreridj', 62, 'DZ'),
(830, '40', 'Boumerdes', 62, 'DZ'),
(831, '41', 'Chlef', 62, 'DZ'),
(832, '42', 'El Bayadh', 62, 'DZ'),
(833, '43', 'El Oued', 62, 'DZ'),
(834, '44', 'El Tarf', 62, 'DZ'),
(835, '45', 'Ghardaia', 62, 'DZ'),
(836, '46', 'Illizi', 62, 'DZ'),
(837, '47', 'Khenchela', 62, 'DZ'),
(838, '48', 'Mila', 62, 'DZ'),
(839, '49', 'Naama', 62, 'DZ'),
(840, '50', 'Ouargla', 62, 'DZ'),
(841, '51', 'Relizane', 62, 'DZ'),
(842, '52', 'Souk Ahras', 62, 'DZ'),
(843, '53', 'Tamanghasset', 62, 'DZ'),
(844, '54', 'Tindouf', 62, 'DZ'),
(845, '55', 'Tipaza', 62, 'DZ'),
(846, '56', 'Tissemsilt', 62, 'DZ'),
(847, '01', 'Galapagos', 63, 'EC'),
(848, '02', 'Azuay', 63, 'EC'),
(849, '03', 'Bolivar', 63, 'EC'),
(850, '04', 'Canar', 63, 'EC'),
(851, '05', 'Carchi', 63, 'EC'),
(852, '06', 'Chimborazo', 63, 'EC'),
(853, '07', 'Cotopaxi', 63, 'EC'),
(854, '08', 'El Oro', 63, 'EC'),
(855, '09', 'Esmeraldas', 63, 'EC'),
(856, '10', 'Guayas', 63, 'EC'),
(857, '11', 'Imbabura', 63, 'EC'),
(858, '12', 'Loja', 63, 'EC'),
(859, '13', 'Los Rios', 63, 'EC'),
(860, '14', 'Manabi', 63, 'EC'),
(861, '15', 'Morona-Santiago', 63, 'EC'),
(862, '17', 'Pastaza', 63, 'EC'),
(863, '18', 'Pichincha', 63, 'EC'),
(864, '19', 'Tungurahua', 63, 'EC'),
(865, '20', 'Zamora-Chinchipe', 63, 'EC'),
(866, '22', 'Sucumbios', 63, 'EC'),
(867, '23', 'Napo', 63, 'EC'),
(868, '24', 'Orellana', 63, 'EC'),
(869, '01', 'Harjumaa', 64, 'EE'),
(870, '02', 'Hiiumaa', 64, 'EE'),
(871, '03', 'Ida-Virumaa', 64, 'EE'),
(872, '04', 'Jarvamaa', 64, 'EE'),
(873, '05', 'Jogevamaa', 64, 'EE'),
(874, '06', 'Kohtla-Jarve', 64, 'EE'),
(875, '07', 'Laanemaa', 64, 'EE'),
(876, '08', 'Laane-Virumaa', 64, 'EE'),
(877, '09', 'Narva', 64, 'EE'),
(878, '10', 'Parnu', 64, 'EE'),
(879, '11', 'Parnumaa', 64, 'EE'),
(880, '12', 'Polvamaa', 64, 'EE'),
(881, '13', 'Raplamaa', 64, 'EE'),
(882, '14', 'Saaremaa', 64, 'EE'),
(883, '15', 'Sillamae', 64, 'EE'),
(884, '16', 'Tallinn', 64, 'EE'),
(885, '17', 'Tartu', 64, 'EE'),
(886, '18', 'Tartumaa', 64, 'EE'),
(887, '19', 'Valgamaa', 64, 'EE'),
(888, '20', 'Viljandimaa', 64, 'EE'),
(889, '21', 'Vorumaa', 64, 'EE'),
(890, '01', 'Ad Daqahliyah', 65, 'EG'),
(891, '02', 'Al Bahr al Ahmar', 65, 'EG'),
(892, '03', 'Al Buhayrah', 65, 'EG'),
(893, '04', 'Al Fayyum', 65, 'EG'),
(894, '05', 'Al Gharbiyah', 65, 'EG'),
(895, '06', 'Al Iskandariyah', 65, 'EG'),
(896, '07', 'Al Isma\'iliyah', 65, 'EG'),
(897, '08', 'Al Jizah', 65, 'EG'),
(898, '09', 'Al Minufiyah', 65, 'EG'),
(899, '10', 'Al Minya', 65, 'EG'),
(900, '11', 'Al Qahirah', 65, 'EG'),
(901, '12', 'Al Qalyubiyah', 65, 'EG'),
(902, '13', 'Al Wadi al Jadid', 65, 'EG'),
(903, '14', 'Ash Sharqiyah', 65, 'EG'),
(904, '15', 'As Suways', 65, 'EG'),
(905, '16', 'Aswan', 65, 'EG'),
(906, '17', 'Asyut', 65, 'EG'),
(907, '18', 'Bani Suwayf', 65, 'EG'),
(908, '19', 'Bur Sa\'id', 65, 'EG'),
(909, '20', 'Dumyat', 65, 'EG'),
(910, '21', 'Kafr ash Shaykh', 65, 'EG'),
(911, '22', 'Matruh', 65, 'EG'),
(912, '23', 'Qina', 65, 'EG'),
(913, '24', 'Suhaj', 65, 'EG'),
(914, '26', 'Janub Sina\'', 65, 'EG'),
(915, '27', 'Shamal Sina\'', 65, 'EG'),
(916, '01', 'Anseba', 67, 'ER'),
(917, '02', 'Debub', 67, 'ER'),
(918, '03', 'Debubawi K\'eyih Bahri', 67, 'ER'),
(919, '04', 'Gash Barka', 67, 'ER'),
(920, '05', 'Ma\'akel', 67, 'ER'),
(921, '06', 'Semenawi K\'eyih Bahri', 67, 'ER'),
(922, '07', 'Islas Baleares', 68, 'ES'),
(923, '27', 'La Rioja', 68, 'ES'),
(924, '29', 'Madrid', 68, 'ES'),
(925, '31', 'Murcia', 68, 'ES'),
(926, '32', 'Navarra', 68, 'ES'),
(927, '34', 'Asturias', 68, 'ES'),
(928, '39', 'Cantabria', 68, 'ES'),
(929, '51', 'Andalucia', 68, 'ES'),
(930, '52', 'Aragon', 68, 'ES'),
(931, '53', 'Canarias', 68, 'ES'),
(932, '54', 'Castilla-La Mancha', 68, 'ES'),
(933, '55', 'Castilla y Leon', 68, 'ES'),
(934, '56', 'Catalonia', 68, 'ES'),
(935, '57', 'Extremadura', 68, 'ES'),
(936, '58', 'Galicia', 68, 'ES'),
(937, '59', 'Pais Vasco', 68, 'ES'),
(938, '60', 'Comunidad Valenciana', 68, 'ES'),
(939, '44', 'Adis Abeba', 69, 'ET'),
(940, '45', 'Afar', 69, 'ET'),
(941, '46', 'Amara', 69, 'ET'),
(942, '47', 'Binshangul Gumuz', 69, 'ET'),
(943, '48', 'Dire Dawa', 69, 'ET'),
(944, '49', 'Gambela Hizboch', 69, 'ET'),
(945, '50', 'Hareri Hizb', 69, 'ET'),
(946, '51', 'Oromiya', 69, 'ET'),
(947, '52', 'Sumale', 69, 'ET'),
(948, '53', 'Tigray', 69, 'ET'),
(949, '54', 'YeDebub Biheroch Bihereseboch na Hizboch', 69, 'ET'),
(950, '01', 'Aland', 70, 'FI'),
(951, '06', 'Lapland', 70, 'FI'),
(952, '08', 'Oulu', 70, 'FI'),
(953, '13', 'Southern Finland', 70, 'FI'),
(954, '14', 'Eastern Finland', 70, 'FI'),
(955, '15', 'Western Finland', 70, 'FI'),
(956, '01', 'Central', 71, 'FJ'),
(957, '02', 'Eastern', 71, 'FJ'),
(958, '03', 'Northern', 71, 'FJ'),
(959, '04', 'Rotuma', 71, 'FJ'),
(960, '05', 'Western', 71, 'FJ'),
(961, '01', 'Kosrae', 73, 'FM'),
(962, '02', 'Pohnpei', 73, 'FM'),
(963, '03', 'Chuuk', 73, 'FM'),
(964, '04', 'Yap', 73, 'FM'),
(965, '97', 'Aquitaine', 75, 'FR'),
(966, '98', 'Auvergne', 75, 'FR'),
(967, '99', 'Basse-Normandie', 75, 'FR'),
(968, 'A1', 'Bourgogne', 75, 'FR'),
(969, 'A2', 'Bretagne', 75, 'FR'),
(970, 'A3', 'Centre', 75, 'FR'),
(971, 'A4', 'Champagne-Ardenne', 75, 'FR'),
(972, 'A5', 'Corse', 75, 'FR'),
(973, 'A6', 'Franche-Comte', 75, 'FR'),
(974, 'A7', 'Haute-Normandie', 75, 'FR'),
(975, 'A8', 'Ile-de-France', 75, 'FR'),
(976, 'A9', 'Languedoc-Roussillon', 75, 'FR'),
(977, 'B1', 'Limousin', 75, 'FR'),
(978, 'B2', 'Lorraine', 75, 'FR'),
(979, 'B3', 'Midi-Pyrenees', 75, 'FR'),
(980, 'B4', 'Nord-Pas-de-Calais', 75, 'FR'),
(981, 'B5', 'Pays de la Loire', 75, 'FR'),
(982, 'B6', 'Picardie', 75, 'FR'),
(983, 'B7', 'Poitou-Charentes', 75, 'FR'),
(984, 'B8', 'Provence-Alpes-Cote d\'Azur', 75, 'FR'),
(985, 'B9', 'Rhone-Alpes', 75, 'FR'),
(986, 'C1', 'Alsace', 75, 'FR'),
(987, '01', 'Estuaire', 77, 'GA'),
(988, '02', 'Haut-Ogooue', 77, 'GA'),
(989, '03', 'Moyen-Ogooue', 77, 'GA'),
(990, '04', 'Ngounie', 77, 'GA'),
(991, '05', 'Nyanga', 77, 'GA'),
(992, '06', 'Ogooue-Ivindo', 77, 'GA'),
(993, '07', 'Ogooue-Lolo', 77, 'GA'),
(994, '08', 'Ogooue-Maritime', 77, 'GA'),
(995, '09', 'Woleu-Ntem', 77, 'GA'),
(996, 'A1', 'Barking and Dagenham', 78, 'GB'),
(997, 'A2', 'Barnet', 78, 'GB'),
(998, 'A3', 'Barnsley', 78, 'GB'),
(999, 'A4', 'Bath and North East Somerset', 78, 'GB'),
(1000, 'A5', 'Bedfordshire', 78, 'GB'),
(1001, 'A6', 'Bexley', 78, 'GB'),
(1002, 'A7', 'Birmingham', 78, 'GB'),
(1003, 'A8', 'Blackburn with Darwen', 78, 'GB'),
(1004, 'A9', 'Blackpool', 78, 'GB'),
(1005, 'B1', 'Bolton', 78, 'GB'),
(1006, 'B2', 'Bournemouth', 78, 'GB'),
(1007, 'B3', 'Bracknell Forest', 78, 'GB'),
(1008, 'B4', 'Bradford', 78, 'GB'),
(1009, 'B5', 'Brent', 78, 'GB'),
(1010, 'B6', 'Brighton and Hove', 78, 'GB'),
(1011, 'B7', 'Bristol, City of', 78, 'GB'),
(1012, 'B8', 'Bromley', 78, 'GB'),
(1013, 'B9', 'Buckinghamshire', 78, 'GB'),
(1014, 'C1', 'Bury', 78, 'GB'),
(1015, 'C2', 'Calderdale', 78, 'GB'),
(1016, 'C3', 'Cambridgeshire', 78, 'GB'),
(1017, 'C4', 'Camden', 78, 'GB'),
(1018, 'C5', 'Cheshire', 78, 'GB'),
(1019, 'C6', 'Cornwall', 78, 'GB'),
(1020, 'C7', 'Coventry', 78, 'GB'),
(1021, 'C8', 'Croydon', 78, 'GB'),
(1022, 'C9', 'Cumbria', 78, 'GB'),
(1023, 'D1', 'Darlington', 78, 'GB'),
(1024, 'D2', 'Derby', 78, 'GB'),
(1025, 'D3', 'Derbyshire', 78, 'GB'),
(1026, 'D4', 'Devon', 78, 'GB'),
(1027, 'D5', 'Doncaster', 78, 'GB'),
(1028, 'D6', 'Dorset', 78, 'GB'),
(1029, 'D7', 'Dudley', 78, 'GB'),
(1030, 'D8', 'Durham', 78, 'GB'),
(1031, 'D9', 'Ealing', 78, 'GB'),
(1032, 'E1', 'East Riding of Yorkshire', 78, 'GB'),
(1033, 'E2', 'East Sussex', 78, 'GB'),
(1034, 'E3', 'Enfield', 78, 'GB'),
(1035, 'E4', 'Essex', 78, 'GB'),
(1036, 'E5', 'Gateshead', 78, 'GB'),
(1037, 'E6', 'Gloucestershire', 78, 'GB'),
(1038, 'E7', 'Greenwich', 78, 'GB'),
(1039, 'E8', 'Hackney', 78, 'GB'),
(1040, 'E9', 'Halton', 78, 'GB'),
(1041, 'F1', 'Hammersmith and Fulham', 78, 'GB'),
(1042, 'F2', 'Hampshire', 78, 'GB'),
(1043, 'F3', 'Haringey', 78, 'GB'),
(1044, 'F4', 'Harrow', 78, 'GB'),
(1045, 'F5', 'Hartlepool', 78, 'GB'),
(1046, 'F6', 'Havering', 78, 'GB'),
(1047, 'F7', 'Herefordshire', 78, 'GB'),
(1048, 'F8', 'Hertford', 78, 'GB'),
(1049, 'F9', 'Hillingdon', 78, 'GB'),
(1050, 'G1', 'Hounslow', 78, 'GB'),
(1051, 'G2', 'Isle of Wight', 78, 'GB'),
(1052, 'G3', 'Islington', 78, 'GB'),
(1053, 'G4', 'Kensington and Chelsea', 78, 'GB'),
(1054, 'G5', 'Kent', 78, 'GB'),
(1055, 'G6', 'Kingston upon Hull, City of', 78, 'GB'),
(1056, 'G7', 'Kingston upon Thames', 78, 'GB'),
(1057, 'G8', 'Kirklees', 78, 'GB'),
(1058, 'G9', 'Knowsley', 78, 'GB'),
(1059, 'H1', 'Lambeth', 78, 'GB'),
(1060, 'H2', 'Lancashire', 78, 'GB'),
(1061, 'H3', 'Leeds', 78, 'GB'),
(1062, 'H4', 'Leicester', 78, 'GB'),
(1063, 'H5', 'Leicestershire', 78, 'GB'),
(1064, 'H6', 'Lewisham', 78, 'GB'),
(1065, 'H7', 'Lincolnshire', 78, 'GB'),
(1066, 'H8', 'Liverpool', 78, 'GB'),
(1067, 'H9', 'London, City of', 78, 'GB'),
(1068, 'I1', 'Luton', 78, 'GB'),
(1069, 'I2', 'Manchester', 78, 'GB'),
(1070, 'I3', 'Medway', 78, 'GB'),
(1071, 'I4', 'Merton', 78, 'GB'),
(1072, 'I5', 'Middlesbrough', 78, 'GB'),
(1073, 'I6', 'Milton Keynes', 78, 'GB'),
(1074, 'I7', 'Newcastle upon Tyne', 78, 'GB'),
(1075, 'I8', 'Newham', 78, 'GB'),
(1076, 'I9', 'Norfolk', 78, 'GB'),
(1077, 'J1', 'Northamptonshire', 78, 'GB'),
(1078, 'J2', 'North East Lincolnshire', 78, 'GB'),
(1079, 'J3', 'North Lincolnshire', 78, 'GB'),
(1080, 'J4', 'North Somerset', 78, 'GB'),
(1081, 'J5', 'North Tyneside', 78, 'GB'),
(1082, 'J6', 'Northumberland', 78, 'GB'),
(1083, 'J7', 'North Yorkshire', 78, 'GB'),
(1084, 'J8', 'Nottingham', 78, 'GB'),
(1085, 'J9', 'Nottinghamshire', 78, 'GB'),
(1086, 'K1', 'Oldham', 78, 'GB'),
(1087, 'K2', 'Oxfordshire', 78, 'GB'),
(1088, 'K3', 'Peterborough', 78, 'GB'),
(1089, 'K4', 'Plymouth', 78, 'GB'),
(1090, 'K5', 'Poole', 78, 'GB'),
(1091, 'K6', 'Portsmouth', 78, 'GB'),
(1092, 'K7', 'Reading', 78, 'GB'),
(1093, 'K8', 'Redbridge', 78, 'GB'),
(1094, 'K9', 'Redcar and Cleveland', 78, 'GB'),
(1095, 'L1', 'Richmond upon Thames', 78, 'GB'),
(1096, 'L2', 'Rochdale', 78, 'GB'),
(1097, 'L3', 'Rotherham', 78, 'GB'),
(1098, 'L4', 'Rutland', 78, 'GB'),
(1099, 'L5', 'Salford', 78, 'GB'),
(1100, 'L6', 'Shropshire', 78, 'GB'),
(1101, 'L7', 'Sandwell', 78, 'GB'),
(1102, 'L8', 'Sefton', 78, 'GB'),
(1103, 'L9', 'Sheffield', 78, 'GB'),
(1104, 'M1', 'Slough', 78, 'GB'),
(1105, 'M2', 'Solihull', 78, 'GB'),
(1106, 'M3', 'Somerset', 78, 'GB'),
(1107, 'M4', 'Southampton', 78, 'GB'),
(1108, 'M5', 'Southend-on-Sea', 78, 'GB'),
(1109, 'M6', 'South Gloucestershire', 78, 'GB'),
(1110, 'M7', 'South Tyneside', 78, 'GB'),
(1111, 'M8', 'Southwark', 78, 'GB'),
(1112, 'M9', 'Staffordshire', 78, 'GB'),
(1113, 'N1', 'St. Helens', 78, 'GB'),
(1114, 'N2', 'Stockport', 78, 'GB'),
(1115, 'N3', 'Stockton-on-Tees', 78, 'GB'),
(1116, 'N4', 'Stoke-on-Trent', 78, 'GB'),
(1117, 'N5', 'Suffolk', 78, 'GB'),
(1118, 'N6', 'Sunderland', 78, 'GB'),
(1119, 'N7', 'Surrey', 78, 'GB'),
(1120, 'N8', 'Sutton', 78, 'GB'),
(1121, 'N9', 'Swindon', 78, 'GB'),
(1122, 'O1', 'Tameside', 78, 'GB'),
(1123, 'O2', 'Telford and Wrekin', 78, 'GB'),
(1124, 'O3', 'Thurrock', 78, 'GB'),
(1125, 'O4', 'Torbay', 78, 'GB'),
(1126, 'O5', 'Tower Hamlets', 78, 'GB'),
(1127, 'O6', 'Trafford', 78, 'GB'),
(1128, 'O7', 'Wakefield', 78, 'GB'),
(1129, 'O8', 'Walsall', 78, 'GB'),
(1130, 'O9', 'Waltham Forest', 78, 'GB'),
(1131, 'P1', 'Wandsworth', 78, 'GB'),
(1132, 'P2', 'Warrington', 78, 'GB'),
(1133, 'P3', 'Warwickshire', 78, 'GB'),
(1134, 'P4', 'West Berkshire', 78, 'GB'),
(1135, 'P5', 'Westminster', 78, 'GB'),
(1136, 'P6', 'West Sussex', 78, 'GB'),
(1137, 'P7', 'Wigan', 78, 'GB'),
(1138, 'P8', 'Wiltshire', 78, 'GB'),
(1139, 'P9', 'Windsor and Maidenhead', 78, 'GB'),
(1140, 'Q1', 'Wirral', 78, 'GB'),
(1141, 'Q2', 'Wokingham', 78, 'GB'),
(1142, 'Q3', 'Wolverhampton', 78, 'GB'),
(1143, 'Q4', 'Worcestershire', 78, 'GB'),
(1144, 'Q5', 'York', 78, 'GB'),
(1145, 'Q6', 'Antrim', 78, 'GB'),
(1146, 'Q7', 'Ards', 78, 'GB'),
(1147, 'Q8', 'Armagh', 78, 'GB'),
(1148, 'Q9', 'Ballymena', 78, 'GB'),
(1149, 'R1', 'Ballymoney', 78, 'GB'),
(1150, 'R2', 'Banbridge', 78, 'GB'),
(1151, 'R3', 'Belfast', 78, 'GB'),
(1152, 'R4', 'Carrickfergus', 78, 'GB'),
(1153, 'R5', 'Castlereagh', 78, 'GB'),
(1154, 'R6', 'Coleraine', 78, 'GB'),
(1155, 'R7', 'Cookstown', 78, 'GB'),
(1156, 'R8', 'Craigavon', 78, 'GB'),
(1157, 'R9', 'Down', 78, 'GB'),
(1158, 'S1', 'Dungannon', 78, 'GB'),
(1159, 'S2', 'Fermanagh', 78, 'GB'),
(1160, 'S3', 'Larne', 78, 'GB'),
(1161, 'S4', 'Limavady', 78, 'GB'),
(1162, 'S5', 'Lisburn', 78, 'GB'),
(1163, 'S6', 'Derry', 78, 'GB'),
(1164, 'S7', 'Magherafelt', 78, 'GB'),
(1165, 'S8', 'Moyle', 78, 'GB'),
(1166, 'S9', 'Newry and Mourne', 78, 'GB'),
(1167, 'T1', 'Newtownabbey', 78, 'GB'),
(1168, 'T2', 'North Down', 78, 'GB'),
(1169, 'T3', 'Omagh', 78, 'GB'),
(1170, 'T4', 'Strabane', 78, 'GB'),
(1171, 'T5', 'Aberdeen City', 78, 'GB'),
(1172, 'T6', 'Aberdeenshire', 78, 'GB'),
(1173, 'T7', 'Angus', 78, 'GB'),
(1174, 'T8', 'Argyll and Bute', 78, 'GB'),
(1175, 'T9', 'Scottish Borders, The', 78, 'GB'),
(1176, 'U1', 'Clackmannanshire', 78, 'GB'),
(1177, 'U2', 'Dumfries and Galloway', 78, 'GB'),
(1178, 'U3', 'Dundee City', 78, 'GB'),
(1179, 'U4', 'East Ayrshire', 78, 'GB'),
(1180, 'U5', 'East Dunbartonshire', 78, 'GB'),
(1181, 'U6', 'East Lothian', 78, 'GB'),
(1182, 'U7', 'East Renfrewshire', 78, 'GB'),
(1183, 'U8', 'Edinburgh, City of', 78, 'GB'),
(1184, 'U9', 'Falkirk', 78, 'GB'),
(1185, 'V1', 'Fife', 78, 'GB'),
(1186, 'V2', 'Glasgow City', 78, 'GB'),
(1187, 'V3', 'Highland', 78, 'GB'),
(1188, 'V4', 'Inverclyde', 78, 'GB'),
(1189, 'V5', 'Midlothian', 78, 'GB'),
(1190, 'V6', 'Moray', 78, 'GB'),
(1191, 'V7', 'North Ayrshire', 78, 'GB'),
(1192, 'V8', 'North Lanarkshire', 78, 'GB'),
(1193, 'V9', 'Orkney', 78, 'GB'),
(1194, 'W1', 'Perth and Kinross', 78, 'GB'),
(1195, 'W2', 'Renfrewshire', 78, 'GB'),
(1196, 'W3', 'Shetland Islands', 78, 'GB'),
(1197, 'W4', 'South Ayrshire', 78, 'GB'),
(1198, 'W5', 'South Lanarkshire', 78, 'GB'),
(1199, 'W6', 'Stirling', 78, 'GB'),
(1200, 'W7', 'West Dunbartonshire', 78, 'GB'),
(1201, 'W8', 'Eilean Siar', 78, 'GB'),
(1202, 'W9', 'West Lothian', 78, 'GB'),
(1203, 'X1', 'Isle of Anglesey', 78, 'GB'),
(1204, 'X2', 'Blaenau Gwent', 78, 'GB'),
(1205, 'X3', 'Bridgend', 78, 'GB'),
(1206, 'X4', 'Caerphilly', 78, 'GB'),
(1207, 'X5', 'Cardiff', 78, 'GB'),
(1208, 'X6', 'Ceredigion', 78, 'GB'),
(1209, 'X7', 'Carmarthenshire', 78, 'GB'),
(1210, 'X8', 'Conwy', 78, 'GB'),
(1211, 'X9', 'Denbighshire', 78, 'GB'),
(1212, 'Y1', 'Flintshire', 78, 'GB'),
(1213, 'Y2', 'Gwynedd', 78, 'GB'),
(1214, 'Y3', 'Merthyr Tydfil', 78, 'GB'),
(1215, 'Y4', 'Monmouthshire', 78, 'GB'),
(1216, 'Y5', 'Neath Port Talbot', 78, 'GB'),
(1217, 'Y6', 'Newport', 78, 'GB'),
(1218, 'Y7', 'Pembrokeshire', 78, 'GB'),
(1219, 'Y8', 'Powys', 78, 'GB'),
(1220, 'Y9', 'Rhondda Cynon Taff', 78, 'GB'),
(1221, 'Z1', 'Swansea', 78, 'GB'),
(1222, 'Z2', 'Torfaen', 78, 'GB'),
(1223, 'Z3', 'Vale of Glamorgan, The', 78, 'GB'),
(1224, 'Z4', 'Wrexham', 78, 'GB'),
(1225, '01', 'Saint Andrew', 79, 'GD'),
(1226, '02', 'Saint David', 79, 'GD'),
(1227, '03', 'Saint George', 79, 'GD'),
(1228, '04', 'Saint John', 79, 'GD'),
(1229, '05', 'Saint Mark', 79, 'GD'),
(1230, '06', 'Saint Patrick', 79, 'GD'),
(1231, '01', 'Abashis Raioni', 80, 'GE'),
(1232, '02', 'Abkhazia', 80, 'GE'),
(1233, '03', 'Adigenis Raioni', 80, 'GE'),
(1234, '04', 'Ajaria', 80, 'GE'),
(1235, '05', 'Akhalgoris Raioni', 80, 'GE'),
(1236, '06', 'Akhalk\'alak\'is Raioni', 80, 'GE'),
(1237, '07', 'Akhalts\'ikhis Raioni', 80, 'GE'),
(1238, '08', 'Akhmetis Raioni', 80, 'GE'),
(1239, '09', 'Ambrolauris Raioni', 80, 'GE'),
(1240, '10', 'Aspindzis Raioni', 80, 'GE'),
(1241, '11', 'Baghdat\'is Raioni', 80, 'GE'),
(1242, '12', 'Bolnisis Raioni', 80, 'GE'),
(1243, '13', 'Borjomis Raioni', 80, 'GE'),
(1244, '14', 'Chiat\'ura', 80, 'GE'),
(1245, '15', 'Ch\'khorotsqus Raioni', 80, 'GE'),
(1246, '16', 'Ch\'okhatauris Raioni', 80, 'GE'),
(1247, '17', 'Dedop\'listsqaros Raioni', 80, 'GE'),
(1248, '18', 'Dmanisis Raioni', 80, 'GE'),
(1249, '19', 'Dushet\'is Raioni', 80, 'GE'),
(1250, '20', 'Gardabanis Raioni', 80, 'GE'),
(1251, '21', 'Gori', 80, 'GE'),
(1252, '22', 'Goris Raioni', 80, 'GE'),
(1253, '23', 'Gurjaanis Raioni', 80, 'GE'),
(1254, '24', 'Javis Raioni', 80, 'GE'),
(1255, '25', 'K\'arelis Raioni', 80, 'GE'),
(1256, '26', 'Kaspis Raioni', 80, 'GE'),
(1257, '27', 'Kharagaulis Raioni', 80, 'GE'),
(1258, '28', 'Khashuris Raioni', 80, 'GE'),
(1259, '29', 'Khobis Raioni', 80, 'GE'),
(1260, '30', 'Khonis Raioni', 80, 'GE'),
(1261, '31', 'K\'ut\'aisi', 80, 'GE'),
(1262, '32', 'Lagodekhis Raioni', 80, 'GE'),
(1263, '33', 'Lanch\'khut\'is Raioni', 80, 'GE'),
(1264, '34', 'Lentekhis Raioni', 80, 'GE'),
(1265, '35', 'Marneulis Raioni', 80, 'GE'),
(1266, '36', 'Martvilis Raioni', 80, 'GE'),
(1267, '37', 'Mestiis Raioni', 80, 'GE'),
(1268, '38', 'Mts\'khet\'is Raioni', 80, 'GE'),
(1269, '39', 'Ninotsmindis Raioni', 80, 'GE'),
(1270, '40', 'Onis Raioni', 80, 'GE'),
(1271, '41', 'Ozurget\'is Raioni', 80, 'GE'),
(1272, '42', 'P\'ot\'i', 80, 'GE'),
(1273, '43', 'Qazbegis Raioni', 80, 'GE'),
(1274, '44', 'Qvarlis Raioni', 80, 'GE'),
(1275, '45', 'Rust\'avi', 80, 'GE'),
(1276, '46', 'Sach\'kheris Raioni', 80, 'GE'),
(1277, '47', 'Sagarejos Raioni', 80, 'GE'),
(1278, '48', 'Samtrediis Raioni', 80, 'GE'),
(1279, '49', 'Senakis Raioni', 80, 'GE'),
(1280, '50', 'Sighnaghis Raioni', 80, 'GE'),
(1281, '51', 'T\'bilisi', 80, 'GE'),
(1282, '52', 'T\'elavis Raioni', 80, 'GE'),
(1283, '53', 'T\'erjolis Raioni', 80, 'GE'),
(1284, '54', 'T\'et\'ritsqaros Raioni', 80, 'GE'),
(1285, '55', 'T\'ianet\'is Raioni', 80, 'GE'),
(1286, '56', 'Tqibuli', 80, 'GE'),
(1287, '57', 'Ts\'ageris Raioni', 80, 'GE'),
(1288, '58', 'Tsalenjikhis Raioni', 80, 'GE'),
(1289, '59', 'Tsalkis Raioni', 80, 'GE'),
(1290, '60', 'Tsqaltubo', 80, 'GE'),
(1291, '61', 'Vanis Raioni', 80, 'GE'),
(1292, '62', 'Zestap\'onis Raioni', 80, 'GE'),
(1293, '63', 'Zugdidi', 80, 'GE'),
(1294, '64', 'Zugdidis Raioni', 80, 'GE'),
(1295, '01', 'Greater Accra', 82, 'GH'),
(1296, '02', 'Ashanti', 82, 'GH'),
(1297, '03', 'Brong-Ahafo', 82, 'GH'),
(1298, '04', 'Central', 82, 'GH'),
(1299, '05', 'Eastern', 82, 'GH'),
(1300, '06', 'Northern', 82, 'GH'),
(1301, '08', 'Volta', 82, 'GH'),
(1302, '09', 'Western', 82, 'GH'),
(1303, '10', 'Upper East', 82, 'GH'),
(1304, '11', 'Upper West', 82, 'GH'),
(1305, '01', 'Nordgronland', 84, 'GL'),
(1306, '02', 'Ostgronland', 84, 'GL'),
(1307, '03', 'Vestgronland', 84, 'GL'),
(1308, '01', 'Banjul', 85, 'GM'),
(1309, '02', 'Lower River', 85, 'GM'),
(1310, '03', 'Central River', 85, 'GM'),
(1311, '04', 'Upper River', 85, 'GM'),
(1312, '05', 'Western', 85, 'GM'),
(1313, '07', 'North Bank', 85, 'GM'),
(1314, '01', 'Beyla', 86, 'GN'),
(1315, '02', 'Boffa', 86, 'GN'),
(1316, '03', 'Boke', 86, 'GN'),
(1317, '04', 'Conakry', 86, 'GN'),
(1318, '05', 'Dabola', 86, 'GN'),
(1319, '06', 'Dalaba', 86, 'GN'),
(1320, '07', 'Dinguiraye', 86, 'GN'),
(1321, '09', 'Faranah', 86, 'GN'),
(1322, '10', 'Forecariah', 86, 'GN'),
(1323, '11', 'Fria', 86, 'GN'),
(1324, '12', 'Gaoual', 86, 'GN'),
(1325, '13', 'Gueckedou', 86, 'GN'),
(1326, '15', 'Kerouane', 86, 'GN'),
(1327, '16', 'Kindia', 86, 'GN'),
(1328, '17', 'Kissidougou', 86, 'GN'),
(1329, '18', 'Koundara', 86, 'GN'),
(1330, '19', 'Kouroussa', 86, 'GN'),
(1331, '21', 'Macenta', 86, 'GN'),
(1332, '22', 'Mali', 86, 'GN'),
(1333, '23', 'Mamou', 86, 'GN'),
(1334, '25', 'Pita', 86, 'GN'),
(1335, '27', 'Telimele', 86, 'GN'),
(1336, '28', 'Tougue', 86, 'GN'),
(1337, '29', 'Yomou', 86, 'GN'),
(1338, '30', 'Coyah', 86, 'GN'),
(1339, '31', 'Dubreka', 86, 'GN'),
(1340, '32', 'Kankan', 86, 'GN'),
(1341, '33', 'Koubia', 86, 'GN'),
(1342, '34', 'Labe', 86, 'GN'),
(1343, '35', 'Lelouma', 86, 'GN'),
(1344, '36', 'Lola', 86, 'GN'),
(1345, '37', 'Mandiana', 86, 'GN'),
(1346, '38', 'Nzerekore', 86, 'GN'),
(1347, '39', 'Siguiri', 86, 'GN'),
(1348, '03', 'Annobon', 88, 'GQ'),
(1349, '04', 'Bioko Norte', 88, 'GQ'),
(1350, '05', 'Bioko Sur', 88, 'GQ'),
(1351, '06', 'Centro Sur', 88, 'GQ'),
(1352, '07', 'Kie-Ntem', 88, 'GQ'),
(1353, '08', 'Litoral', 88, 'GQ'),
(1354, '09', 'Wele-Nzas', 88, 'GQ'),
(1355, '01', 'Evros', 89, 'GR'),
(1356, '02', 'Rodhopi', 89, 'GR'),
(1357, '03', 'Xanthi', 89, 'GR'),
(1358, '04', 'Drama', 89, 'GR'),
(1359, '05', 'Serrai', 89, 'GR'),
(1360, '06', 'Kilkis', 89, 'GR'),
(1361, '07', 'Pella', 89, 'GR'),
(1362, '08', 'Florina', 89, 'GR'),
(1363, '09', 'Kastoria', 89, 'GR'),
(1364, '10', 'Grevena', 89, 'GR'),
(1365, '11', 'Kozani', 89, 'GR'),
(1366, '12', 'Imathia', 89, 'GR'),
(1367, '13', 'Thessaloniki', 89, 'GR'),
(1368, '14', 'Kavala', 89, 'GR'),
(1369, '15', 'Khalkidhiki', 89, 'GR'),
(1370, '16', 'Pieria', 89, 'GR'),
(1371, '17', 'Ioannina', 89, 'GR'),
(1372, '18', 'Thesprotia', 89, 'GR'),
(1373, '19', 'Preveza', 89, 'GR'),
(1374, '20', 'Arta', 89, 'GR'),
(1375, '21', 'Larisa', 89, 'GR'),
(1376, '22', 'Trikala', 89, 'GR'),
(1377, '23', 'Kardhitsa', 89, 'GR'),
(1378, '24', 'Magnisia', 89, 'GR'),
(1379, '25', 'Kerkira', 89, 'GR'),
(1380, '26', 'Levkas', 89, 'GR'),
(1381, '27', 'Kefallinia', 89, 'GR'),
(1382, '28', 'Zakinthos', 89, 'GR'),
(1383, '29', 'Fthiotis', 89, 'GR'),
(1384, '30', 'Evritania', 89, 'GR'),
(1385, '31', 'Aitolia kai Akarnania', 89, 'GR'),
(1386, '32', 'Fokis', 89, 'GR'),
(1387, '33', 'Voiotia', 89, 'GR'),
(1388, '34', 'Evvoia', 89, 'GR'),
(1389, '35', 'Attiki', 89, 'GR'),
(1390, '36', 'Argolis', 89, 'GR'),
(1391, '37', 'Korinthia', 89, 'GR'),
(1392, '38', 'Akhaia', 89, 'GR'),
(1393, '39', 'Ilia', 89, 'GR'),
(1394, '40', 'Messinia', 89, 'GR'),
(1395, '41', 'Arkadhia', 89, 'GR'),
(1396, '42', 'Lakonia', 89, 'GR'),
(1397, '43', 'Khania', 89, 'GR'),
(1398, '44', 'Rethimni', 89, 'GR'),
(1399, '45', 'Iraklion', 89, 'GR'),
(1400, '46', 'Lasithi', 89, 'GR'),
(1401, '47', 'Dhodhekanisos', 89, 'GR'),
(1402, '48', 'Samos', 89, 'GR'),
(1403, '49', 'Kikladhes', 89, 'GR'),
(1404, '50', 'Khios', 89, 'GR'),
(1405, '51', 'Lesvos', 89, 'GR'),
(1406, '01', 'Alta Verapaz', 91, 'GT'),
(1407, '02', 'Baja Verapaz', 91, 'GT'),
(1408, '03', 'Chimaltenango', 91, 'GT'),
(1409, '04', 'Chiquimula', 91, 'GT'),
(1410, '05', 'El Progreso', 91, 'GT'),
(1411, '06', 'Escuintla', 91, 'GT'),
(1412, '07', 'Guatemala', 91, 'GT'),
(1413, '08', 'Huehuetenango', 91, 'GT'),
(1414, '09', 'Izabal', 91, 'GT'),
(1415, '10', 'Jalapa', 91, 'GT'),
(1416, '11', 'Jutiapa', 91, 'GT'),
(1417, '12', 'Peten', 91, 'GT'),
(1418, '13', 'Quetzaltenango', 91, 'GT'),
(1419, '14', 'Quiche', 91, 'GT'),
(1420, '15', 'Retalhuleu', 91, 'GT'),
(1421, '16', 'Sacatepequez', 91, 'GT'),
(1422, '17', 'San Marcos', 91, 'GT'),
(1423, '18', 'Santa Rosa', 91, 'GT'),
(1424, '19', 'Solola', 91, 'GT'),
(1425, '20', 'Suchitepequez', 91, 'GT'),
(1426, '21', 'Totonicapan', 91, 'GT'),
(1427, '22', 'Zacapa', 91, 'GT'),
(1428, '01', 'Bafata', 93, 'GW'),
(1429, '02', 'Quinara', 93, 'GW'),
(1430, '04', 'Oio', 93, 'GW'),
(1431, '05', 'Bolama', 93, 'GW'),
(1432, '06', 'Cacheu', 93, 'GW'),
(1433, '07', 'Tombali', 93, 'GW'),
(1434, '10', 'Gabu', 93, 'GW'),
(1435, '11', 'Bissau', 93, 'GW'),
(1436, '12', 'Biombo', 93, 'GW'),
(1437, '10', 'Barima-Waini', 94, 'GY'),
(1438, '11', 'Cuyuni-Mazaruni', 94, 'GY');
INSERT INTO `mmregions` (`RegionID`, `RegionCode`, `RegionName`, `CountryID`, `CountryCode`) VALUES
(1439, '12', 'Demerara-Mahaica', 94, 'GY'),
(1440, '13', 'East Berbice-Corentyne', 94, 'GY'),
(1441, '14', 'Essequibo Islands-West Demerara', 94, 'GY'),
(1442, '15', 'Mahaica-Berbice', 94, 'GY'),
(1443, '16', 'Pomeroon-Supenaam', 94, 'GY'),
(1444, '17', 'Potaro-Siparuni', 94, 'GY'),
(1445, '18', 'Upper Demerara-Berbice', 94, 'GY'),
(1446, '19', 'Upper Takutu-Upper Essequibo', 94, 'GY'),
(1447, '01', 'Atlantida', 97, 'HN'),
(1448, '02', 'Choluteca', 97, 'HN'),
(1449, '03', 'Colon', 97, 'HN'),
(1450, '04', 'Comayagua', 97, 'HN'),
(1451, '05', 'Copan', 97, 'HN'),
(1452, '06', 'Cortes', 97, 'HN'),
(1453, '07', 'El Paraiso', 97, 'HN'),
(1454, '08', 'Francisco Morazan', 97, 'HN'),
(1455, '09', 'Gracias a Dios', 97, 'HN'),
(1456, '10', 'Intibuca', 97, 'HN'),
(1457, '11', 'Islas de la Bahia', 97, 'HN'),
(1458, '12', 'La Paz', 97, 'HN'),
(1459, '13', 'Lempira', 97, 'HN'),
(1460, '14', 'Ocotepeque', 97, 'HN'),
(1461, '15', 'Olancho', 97, 'HN'),
(1462, '16', 'Santa Barbara', 97, 'HN'),
(1463, '17', 'Valle', 97, 'HN'),
(1464, '18', 'Yoro', 97, 'HN'),
(1465, '01', 'Bjelovarsko-Bilogorska', 98, 'HR'),
(1466, '02', 'Brodsko-Posavska', 98, 'HR'),
(1467, '03', 'Dubrovacko-Neretvanska', 98, 'HR'),
(1468, '04', 'Istarska', 98, 'HR'),
(1469, '05', 'Karlovacka', 98, 'HR'),
(1470, '06', 'Koprivnicko-Krizevacka', 98, 'HR'),
(1471, '07', 'Krapinsko-Zagorska', 98, 'HR'),
(1472, '08', 'Licko-Senjska', 98, 'HR'),
(1473, '09', 'Medimurska', 98, 'HR'),
(1474, '10', 'Osjecko-Baranjska', 98, 'HR'),
(1475, '11', 'Pozesko-Slavonska', 98, 'HR'),
(1476, '12', 'Primorsko-Goranska', 98, 'HR'),
(1477, '13', 'Sibensko-Kninska', 98, 'HR'),
(1478, '14', 'Sisacko-Moslavacka', 98, 'HR'),
(1479, '15', 'Splitsko-Dalmatinska', 98, 'HR'),
(1480, '16', 'Varazdinska', 98, 'HR'),
(1481, '17', 'Viroviticko-Podravska', 98, 'HR'),
(1482, '18', 'Vukovarsko-Srijemska', 98, 'HR'),
(1483, '19', 'Zadarska', 98, 'HR'),
(1484, '20', 'Zagrebacka', 98, 'HR'),
(1485, '21', 'Grad Zagreb', 98, 'HR'),
(1486, '03', 'Nord-Ouest', 99, 'HT'),
(1487, '06', 'Artibonite', 99, 'HT'),
(1488, '07', 'Centre', 99, 'HT'),
(1489, '09', 'Nord', 99, 'HT'),
(1490, '10', 'Nord-Est', 99, 'HT'),
(1491, '11', 'Ouest', 99, 'HT'),
(1492, '12', 'Sud', 99, 'HT'),
(1493, '13', 'Sud-Est', 99, 'HT'),
(1494, '14', 'Grand\' Anse', 99, 'HT'),
(1495, '15', 'Nippes', 99, 'HT'),
(1496, '01', 'Bacs-Kiskun', 100, 'HU'),
(1497, '02', 'Baranya', 100, 'HU'),
(1498, '03', 'Bekes', 100, 'HU'),
(1499, '04', 'Borsod-Abauj-Zemplen', 100, 'HU'),
(1500, '05', 'Budapest', 100, 'HU'),
(1501, '06', 'Csongrad', 100, 'HU'),
(1502, '07', 'Debrecen', 100, 'HU'),
(1503, '08', 'Fejer', 100, 'HU'),
(1504, '09', 'Gyor-Moson-Sopron', 100, 'HU'),
(1505, '10', 'Hajdu-Bihar', 100, 'HU'),
(1506, '11', 'Heves', 100, 'HU'),
(1507, '12', 'Komarom-Esztergom', 100, 'HU'),
(1508, '13', 'Miskolc', 100, 'HU'),
(1509, '14', 'Nograd', 100, 'HU'),
(1510, '15', 'Pecs', 100, 'HU'),
(1511, '16', 'Pest', 100, 'HU'),
(1512, '17', 'Somogy', 100, 'HU'),
(1513, '18', 'Szabolcs-Szatmar-Bereg', 100, 'HU'),
(1514, '19', 'Szeged', 100, 'HU'),
(1515, '20', 'Jasz-Nagykun-Szolnok', 100, 'HU'),
(1516, '21', 'Tolna', 100, 'HU'),
(1517, '22', 'Vas', 100, 'HU'),
(1518, '23', 'Veszprem', 100, 'HU'),
(1519, '24', 'Zala', 100, 'HU'),
(1520, '25', 'Gyor', 100, 'HU'),
(1521, '26', 'Bekescsaba', 100, 'HU'),
(1522, '27', 'Dunaujvaros', 100, 'HU'),
(1523, '28', 'Eger', 100, 'HU'),
(1524, '29', 'Hodmezovasarhely', 100, 'HU'),
(1525, '30', 'Kaposvar', 100, 'HU'),
(1526, '31', 'Kecskemet', 100, 'HU'),
(1527, '32', 'Nagykanizsa', 100, 'HU'),
(1528, '33', 'Nyiregyhaza', 100, 'HU'),
(1529, '34', 'Sopron', 100, 'HU'),
(1530, '35', 'Szekesfehervar', 100, 'HU'),
(1531, '36', 'Szolnok', 100, 'HU'),
(1532, '37', 'Szombathely', 100, 'HU'),
(1533, '38', 'Tatabanya', 100, 'HU'),
(1534, '39', 'Veszprem', 100, 'HU'),
(1535, '40', 'Zalaegerszeg', 100, 'HU'),
(1536, '41', 'Salgotarjan', 100, 'HU'),
(1537, '42', 'Szekszard', 100, 'HU'),
(1538, '43', 'Erd', 100, 'HU'),
(1539, '01', 'Aceh', 101, 'ID'),
(1540, '02', 'Bali', 101, 'ID'),
(1541, '03', 'Bengkulu', 101, 'ID'),
(1542, '04', 'Jakarta Raya', 101, 'ID'),
(1543, '05', 'Jambi', 101, 'ID'),
(1544, '06', 'Jawa Barat', 101, 'ID'),
(1545, '07', 'Jawa Tengah', 101, 'ID'),
(1546, '08', 'Jawa Timur', 101, 'ID'),
(1547, '09', 'Papua', 101, 'ID'),
(1548, '10', 'Yogyakarta', 101, 'ID'),
(1549, '11', 'Kalimantan Barat', 101, 'ID'),
(1550, '12', 'Kalimantan Selatan', 101, 'ID'),
(1551, '13', 'Kalimantan Tengah', 101, 'ID'),
(1552, '14', 'Kalimantan Timur', 101, 'ID'),
(1553, '15', 'Lampung', 101, 'ID'),
(1554, '16', 'Maluku', 101, 'ID'),
(1555, '17', 'Nusa Tenggara Barat', 101, 'ID'),
(1556, '18', 'Nusa Tenggara Timur', 101, 'ID'),
(1557, '19', 'Riau', 101, 'ID'),
(1558, '20', 'Sulawesi Selatan', 101, 'ID'),
(1559, '21', 'Sulawesi Tengah', 101, 'ID'),
(1560, '22', 'Sulawesi Tenggara', 101, 'ID'),
(1561, '23', 'Sulawesi Utara', 101, 'ID'),
(1562, '24', 'Sumatera Barat', 101, 'ID'),
(1563, '25', 'Sumatera Selatan', 101, 'ID'),
(1564, '26', 'Sumatera Utara', 101, 'ID'),
(1565, '28', 'Maluku', 101, 'ID'),
(1566, '29', 'Maluku Utara', 101, 'ID'),
(1567, '30', 'Jawa Barat', 101, 'ID'),
(1568, '31', 'Sulawesi Utara', 101, 'ID'),
(1569, '32', 'Sumatera Selatan', 101, 'ID'),
(1570, '33', 'Banten', 101, 'ID'),
(1571, '34', 'Gorontalo', 101, 'ID'),
(1572, '35', 'Kepulauan Bangka Belitung', 101, 'ID'),
(1573, '36', 'Papua', 101, 'ID'),
(1574, '37', 'Riau', 101, 'ID'),
(1575, '38', 'Sulawesi Selatan', 101, 'ID'),
(1576, '39', 'Irian Jaya Barat', 101, 'ID'),
(1577, '40', 'Kepulauan Riau', 101, 'ID'),
(1578, '41', 'Sulawesi Barat', 101, 'ID'),
(1579, '01', 'Carlow', 102, 'IE'),
(1580, '02', 'Cavan', 102, 'IE'),
(1581, '03', 'Clare', 102, 'IE'),
(1582, '04', 'Cork', 102, 'IE'),
(1583, '06', 'Donegal', 102, 'IE'),
(1584, '07', 'Dublin', 102, 'IE'),
(1585, '10', 'Galway', 102, 'IE'),
(1586, '11', 'Kerry', 102, 'IE'),
(1587, '12', 'Kildare', 102, 'IE'),
(1588, '13', 'Kilkenny', 102, 'IE'),
(1589, '14', 'Leitrim', 102, 'IE'),
(1590, '15', 'Laois', 102, 'IE'),
(1591, '16', 'Limerick', 102, 'IE'),
(1592, '18', 'Longford', 102, 'IE'),
(1593, '19', 'Louth', 102, 'IE'),
(1594, '20', 'Mayo', 102, 'IE'),
(1595, '21', 'Meath', 102, 'IE'),
(1596, '22', 'Monaghan', 102, 'IE'),
(1597, '23', 'Offaly', 102, 'IE'),
(1598, '24', 'Roscommon', 102, 'IE'),
(1599, '25', 'Sligo', 102, 'IE'),
(1600, '26', 'Tipperary', 102, 'IE'),
(1601, '27', 'Waterford', 102, 'IE'),
(1602, '29', 'Westmeath', 102, 'IE'),
(1603, '30', 'Wexford', 102, 'IE'),
(1604, '31', 'Wicklow', 102, 'IE'),
(1605, '01', 'HaDarom', 103, 'IL'),
(1606, '02', 'HaMerkaz', 103, 'IL'),
(1607, '03', 'HaZafon', 103, 'IL'),
(1608, '04', 'Hefa', 103, 'IL'),
(1609, '05', 'Tel Aviv', 103, 'IL'),
(1610, '06', 'Yerushalayim', 103, 'IL'),
(1611, '01', 'Andaman and Nicobar Islands', 104, 'IN'),
(1612, '02', 'Andhra Pradesh', 104, 'IN'),
(1613, '03', 'Assam', 104, 'IN'),
(1614, '05', 'Chandigarh', 104, 'IN'),
(1615, '06', 'Dadra and Nagar Haveli', 104, 'IN'),
(1616, '07', 'Delhi', 104, 'IN'),
(1617, '09', 'Gujarat', 104, 'IN'),
(1618, '10', 'Haryana', 104, 'IN'),
(1619, '11', 'Himachal Pradesh', 104, 'IN'),
(1620, '12', 'Jammu and Kashmir', 104, 'IN'),
(1621, '13', 'Kerala', 104, 'IN'),
(1622, '14', 'Lakshadweep', 104, 'IN'),
(1623, '16', 'Maharashtra', 104, 'IN'),
(1624, '17', 'Manipur', 104, 'IN'),
(1625, '18', 'Meghalaya', 104, 'IN'),
(1626, '19', 'Karnataka', 104, 'IN'),
(1627, '20', 'Nagaland', 104, 'IN'),
(1628, '21', 'Orissa', 104, 'IN'),
(1629, '22', 'Puducherry', 104, 'IN'),
(1630, '23', 'Punjab', 104, 'IN'),
(1631, '24', 'Rajasthan', 104, 'IN'),
(1632, '25', 'Tamil Nadu', 104, 'IN'),
(1633, '26', 'Tripura', 104, 'IN'),
(1634, '28', 'West Bengal', 104, 'IN'),
(1635, '29', 'Sikkim', 104, 'IN'),
(1636, '30', 'Arunachal Pradesh', 104, 'IN'),
(1637, '31', 'Mizoram', 104, 'IN'),
(1638, '32', 'Daman and Diu', 104, 'IN'),
(1639, '33', 'Goa', 104, 'IN'),
(1640, '34', 'Bihar', 104, 'IN'),
(1641, '35', 'Madhya Pradesh', 104, 'IN'),
(1642, '36', 'Uttar Pradesh', 104, 'IN'),
(1643, '37', 'Chhattisgarh', 104, 'IN'),
(1644, '38', 'Jharkhand', 104, 'IN'),
(1645, '39', 'Uttarakhand', 104, 'IN'),
(1646, '01', 'Al Anbar', 106, 'IQ'),
(1647, '02', 'Al Basrah', 106, 'IQ'),
(1648, '03', 'Al Muthanna', 106, 'IQ'),
(1649, '04', 'Al Qadisiyah', 106, 'IQ'),
(1650, '05', 'As Sulaymaniyah', 106, 'IQ'),
(1651, '06', 'Babil', 106, 'IQ'),
(1652, '07', 'Baghdad', 106, 'IQ'),
(1653, '08', 'Dahuk', 106, 'IQ'),
(1654, '09', 'Dhi Qar', 106, 'IQ'),
(1655, '10', 'Diyala', 106, 'IQ'),
(1656, '11', 'Arbil', 106, 'IQ'),
(1657, '12', 'Karbala\'', 106, 'IQ'),
(1658, '13', 'At Ta\'mim', 106, 'IQ'),
(1659, '14', 'Maysan', 106, 'IQ'),
(1660, '15', 'Ninawa', 106, 'IQ'),
(1661, '16', 'Wasit', 106, 'IQ'),
(1662, '17', 'An Najaf', 106, 'IQ'),
(1663, '18', 'Salah ad Din', 106, 'IQ'),
(1664, '01', 'Azarbayjan-e Bakhtari', 107, 'IR'),
(1665, '03', 'Chahar Mahall va Bakhtiari', 107, 'IR'),
(1666, '04', 'Sistan va Baluchestan', 107, 'IR'),
(1667, '05', 'Kohkiluyeh va Buyer Ahmadi', 107, 'IR'),
(1668, '07', 'Fars', 107, 'IR'),
(1669, '08', 'Gilan', 107, 'IR'),
(1670, '09', 'Hamadan', 107, 'IR'),
(1671, '10', 'Ilam', 107, 'IR'),
(1672, '11', 'Hormozgan', 107, 'IR'),
(1673, '12', 'Kerman', 107, 'IR'),
(1674, '13', 'Bakhtaran', 107, 'IR'),
(1675, '15', 'Khuzestan', 107, 'IR'),
(1676, '16', 'Kordestan', 107, 'IR'),
(1677, '17', 'Mazandaran', 107, 'IR'),
(1678, '18', 'Semnan Province', 107, 'IR'),
(1679, '19', 'Markazi', 107, 'IR'),
(1680, '21', 'Zanjan', 107, 'IR'),
(1681, '22', 'Bushehr', 107, 'IR'),
(1682, '23', 'Lorestan', 107, 'IR'),
(1683, '24', 'Markazi', 107, 'IR'),
(1684, '25', 'Semnan', 107, 'IR'),
(1685, '26', 'Tehran', 107, 'IR'),
(1686, '27', 'Zanjan', 107, 'IR'),
(1687, '28', 'Esfahan', 107, 'IR'),
(1688, '29', 'Kerman', 107, 'IR'),
(1689, '30', 'Khorasan', 107, 'IR'),
(1690, '31', 'Yazd', 107, 'IR'),
(1691, '32', 'Ardabil', 107, 'IR'),
(1692, '33', 'East Azarbaijan', 107, 'IR'),
(1693, '34', 'Markazi', 107, 'IR'),
(1694, '35', 'Mazandaran', 107, 'IR'),
(1695, '36', 'Zanjan', 107, 'IR'),
(1696, '37', 'Golestan', 107, 'IR'),
(1697, '38', 'Qazvin', 107, 'IR'),
(1698, '39', 'Qom', 107, 'IR'),
(1699, '40', 'Yazd', 107, 'IR'),
(1700, '41', 'Khorasan-e Janubi', 107, 'IR'),
(1701, '42', 'Khorasan-e Razavi', 107, 'IR'),
(1702, '43', 'Khorasan-e Shemali', 107, 'IR'),
(1703, '03', 'Arnessysla', 108, 'IS'),
(1704, '05', 'Austur-Hunavatnssysla', 108, 'IS'),
(1705, '06', 'Austur-Skaftafellssysla', 108, 'IS'),
(1706, '07', 'Borgarfjardarsysla', 108, 'IS'),
(1707, '09', 'Eyjafjardarsysla', 108, 'IS'),
(1708, '10', 'Gullbringusysla', 108, 'IS'),
(1709, '15', 'Kjosarsysla', 108, 'IS'),
(1710, '17', 'Myrasysla', 108, 'IS'),
(1711, '20', 'Nordur-Mulasysla', 108, 'IS'),
(1712, '21', 'Nordur-Tingeyjarsysla', 108, 'IS'),
(1713, '23', 'Rangarvallasysla', 108, 'IS'),
(1714, '28', 'Skagafjardarsysla', 108, 'IS'),
(1715, '29', 'Snafellsnes- og Hnappadalssysla', 108, 'IS'),
(1716, '30', 'Strandasysla', 108, 'IS'),
(1717, '31', 'Sudur-Mulasysla', 108, 'IS'),
(1718, '32', 'Sudur-Tingeyjarsysla', 108, 'IS'),
(1719, '34', 'Vestur-Bardastrandarsysla', 108, 'IS'),
(1720, '35', 'Vestur-Hunavatnssysla', 108, 'IS'),
(1721, '36', 'Vestur-Isafjardarsysla', 108, 'IS'),
(1722, '37', 'Vestur-Skaftafellssysla', 108, 'IS'),
(1723, '40', 'Norourland Eystra', 108, 'IS'),
(1724, '41', 'Norourland Vestra', 108, 'IS'),
(1725, '42', 'Suourland', 108, 'IS'),
(1726, '43', 'Suournes', 108, 'IS'),
(1727, '44', 'Vestfiroir', 108, 'IS'),
(1728, '45', 'Vesturland', 108, 'IS'),
(1729, '01', 'Abruzzi', 109, 'IT'),
(1730, '02', 'Basilicata', 109, 'IT'),
(1731, '03', 'Calabria', 109, 'IT'),
(1732, '04', 'Campania', 109, 'IT'),
(1733, '05', 'Emilia-Romagna', 109, 'IT'),
(1734, '06', 'Friuli-Venezia Giulia', 109, 'IT'),
(1735, '07', 'Lazio', 109, 'IT'),
(1736, '08', 'Liguria', 109, 'IT'),
(1737, '09', 'Lombardia', 109, 'IT'),
(1738, '10', 'Marche', 109, 'IT'),
(1739, '11', 'Molise', 109, 'IT'),
(1740, '12', 'Piemonte', 109, 'IT'),
(1741, '13', 'Puglia', 109, 'IT'),
(1742, '14', 'Sardegna', 109, 'IT'),
(1743, '15', 'Sicilia', 109, 'IT'),
(1744, '16', 'Toscana', 109, 'IT'),
(1745, '17', 'Trentino-Alto Adige', 109, 'IT'),
(1746, '18', 'Umbria', 109, 'IT'),
(1747, '19', 'Valle d\'Aosta', 109, 'IT'),
(1748, '20', 'Veneto', 109, 'IT'),
(1749, '01', 'Clarendon', 110, 'JM'),
(1750, '02', 'Hanover', 110, 'JM'),
(1751, '04', 'Manchester', 110, 'JM'),
(1752, '07', 'Portland', 110, 'JM'),
(1753, '08', 'Saint Andrew', 110, 'JM'),
(1754, '09', 'Saint Ann', 110, 'JM'),
(1755, '10', 'Saint Catherine', 110, 'JM'),
(1756, '11', 'Saint Elizabeth', 110, 'JM'),
(1757, '12', 'Saint James', 110, 'JM'),
(1758, '13', 'Saint Mary', 110, 'JM'),
(1759, '14', 'Saint Thomas', 110, 'JM'),
(1760, '15', 'Trelawny', 110, 'JM'),
(1761, '16', 'Westmoreland', 110, 'JM'),
(1762, '17', 'Kingston', 110, 'JM'),
(1763, '02', 'Al Balqa\'', 111, 'JO'),
(1764, '07', 'Ma', 111, 'JO'),
(1765, '09', 'Al Karak', 111, 'JO'),
(1766, '10', 'Al Mafraq', 111, 'JO'),
(1767, '11', 'Amman Governorate', 111, 'JO'),
(1768, '12', 'At Tafilah', 111, 'JO'),
(1769, '13', 'Az Zarqa', 111, 'JO'),
(1770, '14', 'Irbid', 111, 'JO'),
(1771, '16', 'Amman', 111, 'JO'),
(1772, '01', 'Aichi', 112, 'JP'),
(1773, '02', 'Akita', 112, 'JP'),
(1774, '03', 'Aomori', 112, 'JP'),
(1775, '04', 'Chiba', 112, 'JP'),
(1776, '05', 'Ehime', 112, 'JP'),
(1777, '06', 'Fukui', 112, 'JP'),
(1778, '07', 'Fukuoka', 112, 'JP'),
(1779, '08', 'Fukushima', 112, 'JP'),
(1780, '09', 'Gifu', 112, 'JP'),
(1781, '10', 'Gumma', 112, 'JP'),
(1782, '11', 'Hiroshima', 112, 'JP'),
(1783, '12', 'Hokkaido', 112, 'JP'),
(1784, '13', 'Hyogo', 112, 'JP'),
(1785, '14', 'Ibaraki', 112, 'JP'),
(1786, '15', 'Ishikawa', 112, 'JP'),
(1787, '16', 'Iwate', 112, 'JP'),
(1788, '17', 'Kagawa', 112, 'JP'),
(1789, '18', 'Kagoshima', 112, 'JP'),
(1790, '19', 'Kanagawa', 112, 'JP'),
(1791, '20', 'Kochi', 112, 'JP'),
(1792, '21', 'Kumamoto', 112, 'JP'),
(1793, '22', 'Kyoto', 112, 'JP'),
(1794, '23', 'Mie', 112, 'JP'),
(1795, '24', 'Miyagi', 112, 'JP'),
(1796, '25', 'Miyazaki', 112, 'JP'),
(1797, '26', 'Nagano', 112, 'JP'),
(1798, '27', 'Nagasaki', 112, 'JP'),
(1799, '28', 'Nara', 112, 'JP'),
(1800, '29', 'Niigata', 112, 'JP'),
(1801, '30', 'Oita', 112, 'JP'),
(1802, '31', 'Okayama', 112, 'JP'),
(1803, '32', 'Osaka', 112, 'JP'),
(1804, '33', 'Saga', 112, 'JP'),
(1805, '34', 'Saitama', 112, 'JP'),
(1806, '35', 'Shiga', 112, 'JP'),
(1807, '36', 'Shimane', 112, 'JP'),
(1808, '37', 'Shizuoka', 112, 'JP'),
(1809, '38', 'Tochigi', 112, 'JP'),
(1810, '39', 'Tokushima', 112, 'JP'),
(1811, '40', 'Tokyo', 112, 'JP'),
(1812, '41', 'Tottori', 112, 'JP'),
(1813, '42', 'Toyama', 112, 'JP'),
(1814, '43', 'Wakayama', 112, 'JP'),
(1815, '44', 'Yamagata', 112, 'JP'),
(1816, '45', 'Yamaguchi', 112, 'JP'),
(1817, '46', 'Yamanashi', 112, 'JP'),
(1818, '47', 'Okinawa', 112, 'JP'),
(1819, '01', 'Central', 113, 'KE'),
(1820, '02', 'Coast', 113, 'KE'),
(1821, '03', 'Eastern', 113, 'KE'),
(1822, '05', 'Nairobi Area', 113, 'KE'),
(1823, '06', 'North-Eastern', 113, 'KE'),
(1824, '07', 'Nyanza', 113, 'KE'),
(1825, '08', 'Rift Valley', 113, 'KE'),
(1826, '09', 'Western', 113, 'KE'),
(1827, '01', 'Bishkek', 114, 'KG'),
(1828, '02', 'Chuy', 114, 'KG'),
(1829, '03', 'Jalal-Abad', 114, 'KG'),
(1830, '04', 'Naryn', 114, 'KG'),
(1831, '05', 'Osh', 114, 'KG'),
(1832, '06', 'Talas', 114, 'KG'),
(1833, '07', 'Ysyk-Kol', 114, 'KG'),
(1834, '08', 'Osh', 114, 'KG'),
(1835, '09', 'Batken', 114, 'KG'),
(1836, '01', 'Batdambang', 115, 'KH'),
(1837, '02', 'Kampong Cham', 115, 'KH'),
(1838, '03', 'Kampong Chhnang', 115, 'KH'),
(1839, '04', 'Kampong Speu', 115, 'KH'),
(1840, '05', 'Kampong Thum', 115, 'KH'),
(1841, '06', 'Kampot', 115, 'KH'),
(1842, '07', 'Kandal', 115, 'KH'),
(1843, '08', 'Koh Kong', 115, 'KH'),
(1844, '09', 'Kracheh', 115, 'KH'),
(1845, '10', 'Mondulkiri', 115, 'KH'),
(1846, '11', 'Phnum Penh', 115, 'KH'),
(1847, '12', 'Pursat', 115, 'KH'),
(1848, '13', 'Preah Vihear', 115, 'KH'),
(1849, '14', 'Prey Veng', 115, 'KH'),
(1850, '15', 'Ratanakiri Kiri', 115, 'KH'),
(1851, '16', 'Siem Reap', 115, 'KH'),
(1852, '17', 'Stung Treng', 115, 'KH'),
(1853, '18', 'Svay Rieng', 115, 'KH'),
(1854, '19', 'Takeo', 115, 'KH'),
(1855, '25', 'Banteay Meanchey', 115, 'KH'),
(1856, '29', 'Batdambang', 115, 'KH'),
(1857, '30', 'Pailin', 115, 'KH'),
(1858, '01', 'Gilbert Islands', 116, 'KI'),
(1859, '02', 'Line Islands', 116, 'KI'),
(1860, '03', 'Phoenix Islands', 116, 'KI'),
(1861, '01', 'Anjouan', 117, 'KM'),
(1862, '02', 'Grande Comore', 117, 'KM'),
(1863, '03', 'Moheli', 117, 'KM'),
(1864, '01', 'Christ Church Nichola Town', 118, 'KN'),
(1865, '02', 'Saint Anne Sandy Point', 118, 'KN'),
(1866, '03', 'Saint George Basseterre', 118, 'KN'),
(1867, '04', 'Saint George Gingerland', 118, 'KN'),
(1868, '05', 'Saint James Windward', 118, 'KN'),
(1869, '06', 'Saint John Capisterre', 118, 'KN'),
(1870, '07', 'Saint John Figtree', 118, 'KN'),
(1871, '08', 'Saint Mary Cayon', 118, 'KN'),
(1872, '09', 'Saint Paul Capisterre', 118, 'KN'),
(1873, '10', 'Saint Paul Charlestown', 118, 'KN'),
(1874, '11', 'Saint Peter Basseterre', 118, 'KN'),
(1875, '12', 'Saint Thomas Lowland', 118, 'KN'),
(1876, '13', 'Saint Thomas Middle Island', 118, 'KN'),
(1877, '15', 'Trinity Palmetto Point', 118, 'KN'),
(1878, '01', 'Chagang-do', 119, 'KP'),
(1879, '03', 'Hamgyong-namdo', 119, 'KP'),
(1880, '06', 'Hwanghae-namdo', 119, 'KP'),
(1881, '07', 'Hwanghae-bukto', 119, 'KP'),
(1882, '08', 'Kaesong-si', 119, 'KP'),
(1883, '09', 'Kangwon-do', 119, 'KP'),
(1884, '11', 'P\'yongan-bukto', 119, 'KP'),
(1885, '12', 'P\'yongyang-si', 119, 'KP'),
(1886, '13', 'Yanggang-do', 119, 'KP'),
(1887, '14', 'Namp\'o-si', 119, 'KP'),
(1888, '15', 'P\'yongan-namdo', 119, 'KP'),
(1889, '17', 'Hamgyong-bukto', 119, 'KP'),
(1890, '18', 'Najin Sonbong-si', 119, 'KP'),
(1891, '01', 'Cheju-do', 120, 'KR'),
(1892, '03', 'Cholla-bukto', 120, 'KR'),
(1893, '05', 'Ch\'ungch\'ong-bukto', 120, 'KR'),
(1894, '06', 'Kangwon-do', 120, 'KR'),
(1895, '10', 'Pusan-jikhalsi', 120, 'KR'),
(1896, '11', 'Seoul-t\'ukpyolsi', 120, 'KR'),
(1897, '12', 'Inch\'on-jikhalsi', 120, 'KR'),
(1898, '13', 'Kyonggi-do', 120, 'KR'),
(1899, '14', 'Kyongsang-bukto', 120, 'KR'),
(1900, '15', 'Taegu-jikhalsi', 120, 'KR'),
(1901, '16', 'Cholla-namdo', 120, 'KR'),
(1902, '17', 'Ch\'ungch\'ong-namdo', 120, 'KR'),
(1903, '18', 'Kwangju-jikhalsi', 120, 'KR'),
(1904, '19', 'Taejon-jikhalsi', 120, 'KR'),
(1905, '20', 'Kyongsang-namdo', 120, 'KR'),
(1906, '21', 'Ulsan-gwangyoksi', 120, 'KR'),
(1907, '01', 'Al Ahmadi', 121, 'KW'),
(1908, '02', 'Al Kuwayt', 121, 'KW'),
(1909, '05', 'Al Jahra', 121, 'KW'),
(1910, '07', 'Al Farwaniyah', 121, 'KW'),
(1911, '08', 'Hawalli', 121, 'KW'),
(1912, '09', 'Mubarak al Kabir', 121, 'KW'),
(1913, '01', 'Creek', 122, 'KY'),
(1914, '02', 'Eastern', 122, 'KY'),
(1915, '03', 'Midland', 122, 'KY'),
(1916, '04', 'South Town', 122, 'KY'),
(1917, '05', 'Spot Bay', 122, 'KY'),
(1918, '06', 'Stake Bay', 122, 'KY'),
(1919, '07', 'West End', 122, 'KY'),
(1920, '08', 'Western', 122, 'KY'),
(1921, '01', 'Almaty', 123, 'KZ'),
(1922, '02', 'Almaty City', 123, 'KZ'),
(1923, '03', 'Aqmola', 123, 'KZ'),
(1924, '04', 'Aqtobe', 123, 'KZ'),
(1925, '05', 'Astana', 123, 'KZ'),
(1926, '06', 'Atyrau', 123, 'KZ'),
(1927, '07', 'West Kazakhstan', 123, 'KZ'),
(1928, '08', 'Bayqonyr', 123, 'KZ'),
(1929, '09', 'Mangghystau', 123, 'KZ'),
(1930, '10', 'South Kazakhstan', 123, 'KZ'),
(1931, '11', 'Pavlodar', 123, 'KZ'),
(1932, '12', 'Qaraghandy', 123, 'KZ'),
(1933, '13', 'Qostanay', 123, 'KZ'),
(1934, '14', 'Qyzylorda', 123, 'KZ'),
(1935, '15', 'East Kazakhstan', 123, 'KZ'),
(1936, '16', 'North Kazakhstan', 123, 'KZ'),
(1937, '17', 'Zhambyl', 123, 'KZ'),
(1938, '01', 'Attapu', 124, 'LA'),
(1939, '02', 'Champasak', 124, 'LA'),
(1940, '03', 'Houaphan', 124, 'LA'),
(1941, '04', 'Khammouan', 124, 'LA'),
(1942, '05', 'Louang Namtha', 124, 'LA'),
(1943, '07', 'Oudomxai', 124, 'LA'),
(1944, '08', 'Phongsali', 124, 'LA'),
(1945, '09', 'Saravan', 124, 'LA'),
(1946, '10', 'Savannakhet', 124, 'LA'),
(1947, '11', 'Vientiane', 124, 'LA'),
(1948, '13', 'Xaignabouri', 124, 'LA'),
(1949, '14', 'Xiangkhoang', 124, 'LA'),
(1950, '17', 'Louangphrabang', 124, 'LA'),
(1951, '01', 'Beqaa', 125, 'LB'),
(1952, '02', 'Al Janub', 125, 'LB'),
(1953, '03', 'Liban-Nord', 125, 'LB'),
(1954, '04', 'Beyrouth', 125, 'LB'),
(1955, '05', 'Mont-Liban', 125, 'LB'),
(1956, '06', 'Liban-Sud', 125, 'LB'),
(1957, '07', 'Nabatiye', 125, 'LB'),
(1958, '08', 'Beqaa', 125, 'LB'),
(1959, '09', 'Liban-Nord', 125, 'LB'),
(1960, '10', 'Aakk,r', 125, 'LB'),
(1961, '11', 'Baalbek-Hermel', 125, 'LB'),
(1962, '01', 'Anse-la-Raye', 126, 'LC'),
(1963, '02', 'Dauphin', 126, 'LC'),
(1964, '03', 'Castries', 126, 'LC'),
(1965, '04', 'Choiseul', 126, 'LC'),
(1966, '05', 'Dennery', 126, 'LC'),
(1967, '06', 'Gros-Islet', 126, 'LC'),
(1968, '07', 'Laborie', 126, 'LC'),
(1969, '08', 'Micoud', 126, 'LC'),
(1970, '09', 'Soufriere', 126, 'LC'),
(1971, '10', 'Vieux-Fort', 126, 'LC'),
(1972, '11', 'Praslin', 126, 'LC'),
(1973, '01', 'Balzers', 127, 'LI'),
(1974, '02', 'Eschen', 127, 'LI'),
(1975, '03', 'Gamprin', 127, 'LI'),
(1976, '04', 'Mauren', 127, 'LI'),
(1977, '05', 'Planken', 127, 'LI'),
(1978, '06', 'Ruggell', 127, 'LI'),
(1979, '07', 'Schaan', 127, 'LI'),
(1980, '08', 'Schellenberg', 127, 'LI'),
(1981, '09', 'Triesen', 127, 'LI'),
(1982, '10', 'Triesenberg', 127, 'LI'),
(1983, '11', 'Vaduz', 127, 'LI'),
(1984, '21', 'Gbarpolu', 127, 'LI'),
(1985, '22', 'River Gee', 127, 'LI'),
(1986, '01', 'Amparai', 128, 'LK'),
(1987, '02', 'Anuradhapura', 128, 'LK'),
(1988, '03', 'Badulla', 128, 'LK'),
(1989, '04', 'Batticaloa', 128, 'LK'),
(1990, '06', 'Galle', 128, 'LK'),
(1991, '07', 'Hambantota', 128, 'LK'),
(1992, '09', 'Kalutara', 128, 'LK'),
(1993, '10', 'Kandy', 128, 'LK'),
(1994, '11', 'Kegalla', 128, 'LK'),
(1995, '12', 'Kurunegala', 128, 'LK'),
(1996, '14', 'Matale', 128, 'LK'),
(1997, '15', 'Matara', 128, 'LK'),
(1998, '16', 'Moneragala', 128, 'LK'),
(1999, '17', 'Nuwara Eliya', 128, 'LK'),
(2000, '18', 'Polonnaruwa', 128, 'LK'),
(2001, '19', 'Puttalam', 128, 'LK'),
(2002, '20', 'Ratnapura', 128, 'LK'),
(2003, '21', 'Trincomalee', 128, 'LK'),
(2004, '23', 'Colombo', 128, 'LK'),
(2005, '24', 'Gampaha', 128, 'LK'),
(2006, '25', 'Jaffna', 128, 'LK'),
(2007, '26', 'Mannar', 128, 'LK'),
(2008, '27', 'Mullaittivu', 128, 'LK'),
(2009, '28', 'Vavuniya', 128, 'LK'),
(2010, '29', 'Central', 128, 'LK'),
(2011, '30', 'North Central', 128, 'LK'),
(2012, '31', 'Northern', 128, 'LK'),
(2013, '32', 'North Western', 128, 'LK'),
(2014, '33', 'Sabaragamuwa', 128, 'LK'),
(2015, '34', 'Southern', 128, 'LK'),
(2016, '35', 'Uva', 128, 'LK'),
(2017, '36', 'Western', 128, 'LK'),
(2018, '01', 'Bong', 129, 'LR'),
(2019, '04', 'Grand Cape Mount', 129, 'LR'),
(2020, '05', 'Lofa', 129, 'LR'),
(2021, '06', 'Maryland', 129, 'LR'),
(2022, '07', 'Monrovia', 129, 'LR'),
(2023, '09', 'Nimba', 129, 'LR'),
(2024, '10', 'Sino', 129, 'LR'),
(2025, '11', 'Grand Bassa', 129, 'LR'),
(2026, '12', 'Grand Cape Mount', 129, 'LR'),
(2027, '13', 'Maryland', 129, 'LR'),
(2028, '14', 'Montserrado', 129, 'LR'),
(2029, '17', 'Margibi', 129, 'LR'),
(2030, '18', 'River Cess', 129, 'LR'),
(2031, '19', 'Grand Gedeh', 129, 'LR'),
(2032, '20', 'Lofa', 129, 'LR'),
(2033, '21', 'Gbarpolu', 129, 'LR'),
(2034, '22', 'River Gee', 129, 'LR'),
(2035, '10', 'Berea', 130, 'LS'),
(2036, '11', 'Butha-Buthe', 130, 'LS'),
(2037, '12', 'Leribe', 130, 'LS'),
(2038, '13', 'Mafeteng', 130, 'LS'),
(2039, '14', 'Maseru', 130, 'LS'),
(2040, '15', 'Mohales Hoek', 130, 'LS'),
(2041, '16', 'Mokhotlong', 130, 'LS'),
(2042, '17', 'Qachas Nek', 130, 'LS'),
(2043, '18', 'Quthing', 130, 'LS'),
(2044, '19', 'Thaba-Tseka', 130, 'LS'),
(2045, '56', 'Alytaus Apskritis', 131, 'LT'),
(2046, '57', 'Kauno Apskritis', 131, 'LT'),
(2047, '58', 'Klaipedos Apskritis', 131, 'LT'),
(2048, '59', 'Marijampoles Apskritis', 131, 'LT'),
(2049, '60', 'Panevezio Apskritis', 131, 'LT'),
(2050, '61', 'Siauliu Apskritis', 131, 'LT'),
(2051, '62', 'Taurages Apskritis', 131, 'LT'),
(2052, '63', 'Telsiu Apskritis', 131, 'LT'),
(2053, '64', 'Utenos Apskritis', 131, 'LT'),
(2054, '65', 'Vilniaus Apskritis', 131, 'LT'),
(2055, '01', 'Diekirch', 132, 'LU'),
(2056, '02', 'Grevenmacher', 132, 'LU'),
(2057, '03', 'Luxembourg', 132, 'LU'),
(2058, '01', 'Aizkraukles', 133, 'LV'),
(2059, '02', 'Aluksnes', 133, 'LV'),
(2060, '03', 'Balvu', 133, 'LV'),
(2061, '04', 'Bauskas', 133, 'LV'),
(2062, '05', 'Cesu', 133, 'LV'),
(2063, '06', 'Daugavpils', 133, 'LV'),
(2064, '07', 'Daugavpils', 133, 'LV'),
(2065, '08', 'Dobeles', 133, 'LV'),
(2066, '09', 'Gulbenes', 133, 'LV'),
(2067, '10', 'Jekabpils', 133, 'LV'),
(2068, '11', 'Jelgava', 133, 'LV'),
(2069, '12', 'Jelgavas', 133, 'LV'),
(2070, '13', 'Jurmala', 133, 'LV'),
(2071, '14', 'Kraslavas', 133, 'LV'),
(2072, '15', 'Kuldigas', 133, 'LV'),
(2073, '16', 'Liepaja', 133, 'LV'),
(2074, '17', 'Liepajas', 133, 'LV'),
(2075, '18', 'Limbazu', 133, 'LV'),
(2076, '19', 'Ludzas', 133, 'LV'),
(2077, '20', 'Madonas', 133, 'LV'),
(2078, '21', 'Ogres', 133, 'LV'),
(2079, '22', 'Preilu', 133, 'LV'),
(2080, '23', 'Rezekne', 133, 'LV'),
(2081, '24', 'Rezeknes', 133, 'LV'),
(2082, '25', 'Riga', 133, 'LV'),
(2083, '26', 'Rigas', 133, 'LV'),
(2084, '27', 'Saldus', 133, 'LV'),
(2085, '28', 'Talsu', 133, 'LV'),
(2086, '29', 'Tukuma', 133, 'LV'),
(2087, '30', 'Valkas', 133, 'LV'),
(2088, '31', 'Valmieras', 133, 'LV'),
(2089, '32', 'Ventspils', 133, 'LV'),
(2090, '33', 'Ventspils', 133, 'LV'),
(2091, '03', 'Al Aziziyah', 134, 'LY'),
(2092, '05', 'Al Jufrah', 134, 'LY'),
(2093, '08', 'Al Kufrah', 134, 'LY'),
(2094, '13', 'Ash Shati\'', 134, 'LY'),
(2095, '30', 'Murzuq', 134, 'LY'),
(2096, '34', 'Sabha', 134, 'LY'),
(2097, '41', 'Tarhunah', 134, 'LY'),
(2098, '42', 'Tubruq', 134, 'LY'),
(2099, '45', 'Zlitan', 134, 'LY'),
(2100, '47', 'Ajdabiya', 134, 'LY'),
(2101, '48', 'Al Fatih', 134, 'LY'),
(2102, '49', 'Al Jabal al Akhdar', 134, 'LY'),
(2103, '50', 'Al Khums', 134, 'LY'),
(2104, '51', 'An Nuqat al Khams', 134, 'LY'),
(2105, '52', 'Awbari', 134, 'LY'),
(2106, '53', 'Az Zawiyah', 134, 'LY'),
(2107, '54', 'Banghazi', 134, 'LY'),
(2108, '55', 'Darnah', 134, 'LY'),
(2109, '56', 'Ghadamis', 134, 'LY'),
(2110, '57', 'Gharyan', 134, 'LY'),
(2111, '58', 'Misratah', 134, 'LY'),
(2112, '59', 'Sawfajjin', 134, 'LY'),
(2113, '60', 'Surt', 134, 'LY'),
(2114, '61', 'Tarabulus', 134, 'LY'),
(2115, '62', 'Yafran', 134, 'LY'),
(2116, '45', 'Grand Casablanca', 135, 'MA'),
(2117, '46', 'Fes-Boulemane', 135, 'MA'),
(2118, '47', 'Marrakech-Tensift-Al Haouz', 135, 'MA'),
(2119, '48', 'Meknes-Tafilalet', 135, 'MA'),
(2120, '49', 'Rabat-Sale-Zemmour-Zaer', 135, 'MA'),
(2121, '50', 'Chaouia-Ouardigha', 135, 'MA'),
(2122, '51', 'Doukkala-Abda', 135, 'MA'),
(2123, '52', 'Gharb-Chrarda-Beni Hssen', 135, 'MA'),
(2124, '53', 'Guelmim-Es Smara', 135, 'MA'),
(2125, '54', 'Oriental', 135, 'MA'),
(2126, '55', 'Souss-Massa-Dr,a', 135, 'MA'),
(2127, '56', 'Tadla-Azilal', 135, 'MA'),
(2128, '57', 'Tanger-Tetouan', 135, 'MA'),
(2129, '58', 'Taza-Al Hoceima-Taounate', 135, 'MA'),
(2130, '59', 'La,youne-Boujdour-Sakia El Hamra', 135, 'MA'),
(2131, '01', 'La Condamine', 136, 'MC'),
(2132, '02', 'Monaco', 136, 'MC'),
(2133, '03', 'Monte-Carlo', 136, 'MC'),
(2134, '51', 'Gagauzia', 137, 'MD'),
(2135, '57', 'Chisinau', 137, 'MD'),
(2136, '58', 'Stinga Nistrului', 137, 'MD'),
(2137, '59', 'Anenii Noi', 137, 'MD'),
(2138, '60', 'Balti', 137, 'MD'),
(2139, '61', 'Basarabeasca', 137, 'MD'),
(2140, '62', 'Bender', 137, 'MD'),
(2141, '63', 'Briceni', 137, 'MD'),
(2142, '64', 'Cahul', 137, 'MD'),
(2143, '65', 'Cantemir', 137, 'MD'),
(2144, '66', 'Calarasi', 137, 'MD'),
(2145, '67', 'Causeni', 137, 'MD'),
(2146, '68', 'Cimislia', 137, 'MD'),
(2147, '69', 'Criuleni', 137, 'MD'),
(2148, '70', 'Donduseni', 137, 'MD'),
(2149, '71', 'Drochia', 137, 'MD'),
(2150, '72', 'Dubasari', 137, 'MD'),
(2151, '73', 'Edinet', 137, 'MD'),
(2152, '74', 'Falesti', 137, 'MD'),
(2153, '75', 'Floresti', 137, 'MD'),
(2154, '76', 'Glodeni', 137, 'MD'),
(2155, '77', 'Hincesti', 137, 'MD'),
(2156, '78', 'Ialoveni', 137, 'MD'),
(2157, '79', 'Leova', 137, 'MD'),
(2158, '80', 'Nisporeni', 137, 'MD'),
(2159, '81', 'Ocnita', 137, 'MD'),
(2160, '83', 'Rezina', 137, 'MD'),
(2161, '84', 'Riscani', 137, 'MD'),
(2162, '85', 'Singerei', 137, 'MD'),
(2163, '86', 'Soldanesti', 137, 'MD'),
(2164, '87', 'Soroca', 137, 'MD'),
(2165, '88', 'Stefan-Voda', 137, 'MD'),
(2166, '89', 'Straseni', 137, 'MD'),
(2167, '90', 'Taraclia', 137, 'MD'),
(2168, '91', 'Telenesti', 137, 'MD'),
(2169, '92', 'Ungheni', 137, 'MD'),
(2170, '01', 'Antsiranana', 138, 'MG'),
(2171, '02', 'Fianarantsoa', 138, 'MG'),
(2172, '03', 'Mahajanga', 138, 'MG'),
(2173, '04', 'Toamasina', 138, 'MG'),
(2174, '05', 'Antananarivo', 138, 'MG'),
(2175, '06', 'Toliara', 138, 'MG'),
(2176, '01', 'Aracinovo', 140, 'MK'),
(2177, '02', 'Bac', 140, 'MK'),
(2178, '03', 'Belcista', 140, 'MK'),
(2179, '04', 'Berovo', 140, 'MK'),
(2180, '05', 'Bistrica', 140, 'MK'),
(2181, '06', 'Bitola', 140, 'MK'),
(2182, '07', 'Blatec', 140, 'MK'),
(2183, '08', 'Bogdanci', 140, 'MK'),
(2184, '09', 'Bogomila', 140, 'MK'),
(2185, '10', 'Bogovinje', 140, 'MK'),
(2186, '11', 'Bosilovo', 140, 'MK'),
(2187, '12', 'Brvenica', 140, 'MK'),
(2188, '13', 'Cair', 140, 'MK'),
(2189, '14', 'Capari', 140, 'MK'),
(2190, '15', 'Caska', 140, 'MK'),
(2191, '16', 'Cegrane', 140, 'MK'),
(2192, '17', 'Centar', 140, 'MK'),
(2193, '18', 'Centar Zupa', 140, 'MK'),
(2194, '19', 'Cesinovo', 140, 'MK'),
(2195, '20', 'Cucer-Sandevo', 140, 'MK'),
(2196, '21', 'Debar', 140, 'MK'),
(2197, '22', 'Delcevo', 140, 'MK'),
(2198, '23', 'Delogozdi', 140, 'MK'),
(2199, '24', 'Demir Hisar', 140, 'MK'),
(2200, '25', 'Demir Kapija', 140, 'MK'),
(2201, '26', 'Dobrusevo', 140, 'MK'),
(2202, '27', 'Dolna Banjica', 140, 'MK'),
(2203, '28', 'Dolneni', 140, 'MK'),
(2204, '29', 'Dorce Petrov', 140, 'MK'),
(2205, '30', 'Drugovo', 140, 'MK'),
(2206, '31', 'Dzepciste', 140, 'MK'),
(2207, '32', 'Gazi Baba', 140, 'MK'),
(2208, '33', 'Gevgelija', 140, 'MK'),
(2209, '34', 'Gostivar', 140, 'MK'),
(2210, '35', 'Gradsko', 140, 'MK'),
(2211, '36', 'Ilinden', 140, 'MK'),
(2212, '37', 'Izvor', 140, 'MK'),
(2213, '38', 'Jegunovce', 140, 'MK'),
(2214, '39', 'Kamenjane', 140, 'MK'),
(2215, '40', 'Karbinci', 140, 'MK'),
(2216, '41', 'Karpos', 140, 'MK'),
(2217, '42', 'Kavadarci', 140, 'MK'),
(2218, '43', 'Kicevo', 140, 'MK'),
(2219, '44', 'Kisela Voda', 140, 'MK'),
(2220, '45', 'Klecevce', 140, 'MK'),
(2221, '46', 'Kocani', 140, 'MK'),
(2222, '47', 'Konce', 140, 'MK'),
(2223, '48', 'Kondovo', 140, 'MK'),
(2224, '49', 'Konopiste', 140, 'MK'),
(2225, '50', 'Kosel', 140, 'MK'),
(2226, '51', 'Kratovo', 140, 'MK'),
(2227, '52', 'Kriva Palanka', 140, 'MK'),
(2228, '53', 'Krivogastani', 140, 'MK'),
(2229, '54', 'Krusevo', 140, 'MK'),
(2230, '55', 'Kuklis', 140, 'MK'),
(2231, '56', 'Kukurecani', 140, 'MK'),
(2232, '57', 'Kumanovo', 140, 'MK'),
(2233, '58', 'Labunista', 140, 'MK'),
(2234, '59', 'Lipkovo', 140, 'MK'),
(2235, '60', 'Lozovo', 140, 'MK'),
(2236, '61', 'Lukovo', 140, 'MK'),
(2237, '62', 'Makedonska Kamenica', 140, 'MK'),
(2238, '63', 'Makedonski Brod', 140, 'MK'),
(2239, '64', 'Mavrovi Anovi', 140, 'MK'),
(2240, '65', 'Meseista', 140, 'MK'),
(2241, '66', 'Miravci', 140, 'MK'),
(2242, '67', 'Mogila', 140, 'MK'),
(2243, '68', 'Murtino', 140, 'MK'),
(2244, '69', 'Negotino', 140, 'MK'),
(2245, '70', 'Negotino-Polosko', 140, 'MK'),
(2246, '71', 'Novaci', 140, 'MK'),
(2247, '72', 'Novo Selo', 140, 'MK'),
(2248, '73', 'Oblesevo', 140, 'MK'),
(2249, '74', 'Ohrid', 140, 'MK'),
(2250, '75', 'Orasac', 140, 'MK'),
(2251, '76', 'Orizari', 140, 'MK'),
(2252, '77', 'Oslomej', 140, 'MK'),
(2253, '78', 'Pehcevo', 140, 'MK'),
(2254, '79', 'Petrovec', 140, 'MK'),
(2255, '80', 'Plasnica', 140, 'MK'),
(2256, '81', 'Podares', 140, 'MK'),
(2257, '82', 'Prilep', 140, 'MK'),
(2258, '83', 'Probistip', 140, 'MK'),
(2259, '84', 'Radovis', 140, 'MK'),
(2260, '85', 'Rankovce', 140, 'MK'),
(2261, '86', 'Resen', 140, 'MK'),
(2262, '87', 'Rosoman', 140, 'MK'),
(2263, '88', 'Rostusa', 140, 'MK'),
(2264, '89', 'Samokov', 140, 'MK'),
(2265, '90', 'Saraj', 140, 'MK'),
(2266, '91', 'Sipkovica', 140, 'MK'),
(2267, '92', 'Sopiste', 140, 'MK'),
(2268, '93', 'Sopotnica', 140, 'MK'),
(2269, '94', 'Srbinovo', 140, 'MK'),
(2270, '95', 'Staravina', 140, 'MK'),
(2271, '96', 'Star Dojran', 140, 'MK'),
(2272, '97', 'Staro Nagoricane', 140, 'MK'),
(2273, '98', 'Stip', 140, 'MK'),
(2274, '99', 'Struga', 140, 'MK'),
(2275, 'A1', 'Strumica', 140, 'MK'),
(2276, 'A2', 'Studenicani', 140, 'MK'),
(2277, 'A3', 'Suto Orizari', 140, 'MK'),
(2278, 'A4', 'Sveti Nikole', 140, 'MK'),
(2279, 'A5', 'Tearce', 140, 'MK'),
(2280, 'A6', 'Tetovo', 140, 'MK'),
(2281, 'A7', 'Topolcani', 140, 'MK'),
(2282, 'A8', 'Valandovo', 140, 'MK'),
(2283, 'A9', 'Vasilevo', 140, 'MK'),
(2284, 'B1', 'Veles', 140, 'MK'),
(2285, 'B2', 'Velesta', 140, 'MK'),
(2286, 'B3', 'Vevcani', 140, 'MK'),
(2287, 'B4', 'Vinica', 140, 'MK'),
(2288, 'B5', 'Vitoliste', 140, 'MK'),
(2289, 'B6', 'Vranestica', 140, 'MK'),
(2290, 'B7', 'Vrapciste', 140, 'MK'),
(2291, 'B8', 'Vratnica', 140, 'MK'),
(2292, 'B9', 'Vrutok', 140, 'MK'),
(2293, 'C1', 'Zajas', 140, 'MK'),
(2294, 'C2', 'Zelenikovo', 140, 'MK'),
(2295, 'C3', 'Zelino', 140, 'MK'),
(2296, 'C4', 'Zitose', 140, 'MK'),
(2297, 'C5', 'Zletovo', 140, 'MK'),
(2298, 'C6', 'Zrnovci', 140, 'MK'),
(2299, '01', 'Bamako', 141, 'ML'),
(2300, '03', 'Kayes', 141, 'ML'),
(2301, '04', 'Mopti', 141, 'ML'),
(2302, '05', 'Segou', 141, 'ML'),
(2303, '06', 'Sikasso', 141, 'ML'),
(2304, '07', 'Koulikoro', 141, 'ML'),
(2305, '08', 'Tombouctou', 141, 'ML'),
(2306, '09', 'Gao', 141, 'ML'),
(2307, '10', 'Kidal', 141, 'ML'),
(2308, '01', 'Rakhine State', 142, 'MM'),
(2309, '02', 'Chin State', 142, 'MM'),
(2310, '03', 'Irrawaddy', 142, 'MM'),
(2311, '04', 'Kachin State', 142, 'MM'),
(2312, '05', 'Karan State', 142, 'MM'),
(2313, '06', 'Kayah State', 142, 'MM'),
(2314, '07', 'Magwe', 142, 'MM'),
(2315, '08', 'Mandalay', 142, 'MM'),
(2316, '09', 'Pegu', 142, 'MM'),
(2317, '10', 'Sagaing', 142, 'MM'),
(2318, '11', 'Shan State', 142, 'MM'),
(2319, '12', 'Tenasserim', 142, 'MM'),
(2320, '13', 'Mon State', 142, 'MM'),
(2321, '14', 'Rangoon', 142, 'MM'),
(2322, '17', 'Yangon', 142, 'MM'),
(2323, '01', 'Arhangay', 143, 'MN'),
(2324, '02', 'Bayanhongor', 143, 'MN'),
(2325, '03', 'Bayan-Olgiy', 143, 'MN'),
(2326, '05', 'Darhan', 143, 'MN'),
(2327, '06', 'Dornod', 143, 'MN'),
(2328, '07', 'Dornogovi', 143, 'MN'),
(2329, '08', 'Dundgovi', 143, 'MN'),
(2330, '09', 'Dzavhan', 143, 'MN'),
(2331, '10', 'Govi-Altay', 143, 'MN'),
(2332, '11', 'Hentiy', 143, 'MN'),
(2333, '12', 'Hovd', 143, 'MN'),
(2334, '13', 'Hovsgol', 143, 'MN'),
(2335, '14', 'Omnogovi', 143, 'MN'),
(2336, '15', 'Ovorhangay', 143, 'MN'),
(2337, '16', 'Selenge', 143, 'MN'),
(2338, '17', 'Suhbaatar', 143, 'MN'),
(2339, '18', 'Tov', 143, 'MN'),
(2340, '19', 'Uvs', 143, 'MN'),
(2341, '20', 'Ulaanbaatar', 143, 'MN'),
(2342, '21', 'Bulgan', 143, 'MN'),
(2343, '22', 'Erdenet', 143, 'MN'),
(2344, '23', 'Darhan-Uul', 143, 'MN'),
(2345, '24', 'Govisumber', 143, 'MN'),
(2346, '25', 'Orhon', 143, 'MN'),
(2347, '01', 'Ilhas', 144, 'MO'),
(2348, '02', 'Macau', 144, 'MO'),
(2349, '01', 'Hodh Ech Chargui', 147, 'MR'),
(2350, '02', 'Hodh El Gharbi', 147, 'MR'),
(2351, '03', 'Assaba', 147, 'MR'),
(2352, '04', 'Gorgol', 147, 'MR'),
(2353, '05', 'Brakna', 147, 'MR'),
(2354, '06', 'Trarza', 147, 'MR'),
(2355, '07', 'Adrar', 147, 'MR'),
(2356, '08', 'Dakhlet Nouadhibou', 147, 'MR'),
(2357, '09', 'Tagant', 147, 'MR'),
(2358, '10', 'Guidimaka', 147, 'MR'),
(2359, '11', 'Tiris Zemmour', 147, 'MR'),
(2360, '12', 'Inchiri', 147, 'MR'),
(2361, '01', 'Saint Anthony', 148, 'MS'),
(2362, '02', 'Saint Georges', 148, 'MS'),
(2363, '03', 'Saint Peter', 148, 'MS'),
(2364, '12', 'Black River', 150, 'MU'),
(2365, '13', 'Flacq', 150, 'MU'),
(2366, '14', 'Grand Port', 150, 'MU'),
(2367, '15', 'Moka', 150, 'MU'),
(2368, '16', 'Pamplemousses', 150, 'MU'),
(2369, '17', 'Plaines Wilhems', 150, 'MU'),
(2370, '18', 'Port Louis', 150, 'MU'),
(2371, '19', 'Riviere du Rempart', 150, 'MU'),
(2372, '20', 'Savanne', 150, 'MU'),
(2373, '21', 'Agalega Islands', 150, 'MU'),
(2374, '22', 'Cargados Carajos', 150, 'MU'),
(2375, '23', 'Rodrigues', 150, 'MU'),
(2376, '01', 'Seenu', 151, 'MV'),
(2377, '05', 'Laamu', 151, 'MV'),
(2378, '30', 'Alifu', 151, 'MV'),
(2379, '31', 'Baa', 151, 'MV'),
(2380, '32', 'Dhaalu', 151, 'MV'),
(2381, '33', 'Faafu ', 151, 'MV'),
(2382, '34', 'Gaafu Alifu', 151, 'MV'),
(2383, '35', 'Gaafu Dhaalu', 151, 'MV'),
(2384, '36', 'Haa Alifu', 151, 'MV'),
(2385, '37', 'Haa Dhaalu', 151, 'MV'),
(2386, '38', 'Kaafu', 151, 'MV'),
(2387, '39', 'Lhaviyani', 151, 'MV'),
(2388, '40', 'Maale', 151, 'MV'),
(2389, '41', 'Meemu', 151, 'MV'),
(2390, '42', 'Gnaviyani', 151, 'MV'),
(2391, '43', 'Noonu', 151, 'MV'),
(2392, '44', 'Raa', 151, 'MV'),
(2393, '45', 'Shaviyani', 151, 'MV'),
(2394, '46', 'Thaa', 151, 'MV'),
(2395, '47', 'Vaavu', 151, 'MV'),
(2396, '02', 'Chikwawa', 152, 'MW'),
(2397, '03', 'Chiradzulu', 152, 'MW'),
(2398, '04', 'Chitipa', 152, 'MW'),
(2399, '05', 'Thyolo', 152, 'MW'),
(2400, '06', 'Dedza', 152, 'MW'),
(2401, '07', 'Dowa', 152, 'MW'),
(2402, '08', 'Karonga', 152, 'MW'),
(2403, '09', 'Kasungu', 152, 'MW'),
(2404, '11', 'Lilongwe', 152, 'MW'),
(2405, '12', 'Mangochi', 152, 'MW'),
(2406, '13', 'Mchinji', 152, 'MW'),
(2407, '15', 'Mzimba', 152, 'MW'),
(2408, '16', 'Ntcheu', 152, 'MW'),
(2409, '17', 'Nkhata Bay', 152, 'MW'),
(2410, '18', 'Nkhotakota', 152, 'MW'),
(2411, '19', 'Nsanje', 152, 'MW'),
(2412, '20', 'Ntchisi', 152, 'MW'),
(2413, '21', 'Rumphi', 152, 'MW'),
(2414, '22', 'Salima', 152, 'MW'),
(2415, '23', 'Zomba', 152, 'MW'),
(2416, '24', 'Blantyre', 152, 'MW'),
(2417, '25', 'Mwanza', 152, 'MW'),
(2418, '26', 'Balaka', 152, 'MW'),
(2419, '27', 'Likoma', 152, 'MW'),
(2420, '28', 'Machinga', 152, 'MW'),
(2421, '29', 'Mulanje', 152, 'MW'),
(2422, '30', 'Phalombe', 152, 'MW'),
(2423, '01', 'Aguascalientes', 153, 'MX'),
(2424, '02', 'Baja California', 153, 'MX'),
(2425, '03', 'Baja California Sur', 153, 'MX'),
(2426, '04', 'Campeche', 153, 'MX'),
(2427, '05', 'Chiapas', 153, 'MX'),
(2428, '06', 'Chihuahua', 153, 'MX'),
(2429, '07', 'Coahuila de Zaragoza', 153, 'MX'),
(2430, '08', 'Colima', 153, 'MX'),
(2431, '09', 'Distrito Federal', 153, 'MX'),
(2432, '10', 'Durango', 153, 'MX'),
(2433, '11', 'Guanajuato', 153, 'MX'),
(2434, '12', 'Guerrero', 153, 'MX'),
(2435, '13', 'Hidalgo', 153, 'MX'),
(2436, '14', 'Jalisco', 153, 'MX'),
(2437, '15', 'Mexico', 153, 'MX'),
(2438, '16', 'Michoacan de Ocampo', 153, 'MX'),
(2439, '17', 'Morelos', 153, 'MX'),
(2440, '18', 'Nayarit', 153, 'MX'),
(2441, '19', 'Nuevo Leon', 153, 'MX'),
(2442, '20', 'Oaxaca', 153, 'MX'),
(2443, '21', 'Puebla', 153, 'MX'),
(2444, '22', 'Queretaro de Arteaga', 153, 'MX'),
(2445, '23', 'Quintana Roo', 153, 'MX'),
(2446, '24', 'San Luis Potosi', 153, 'MX'),
(2447, '25', 'Sinaloa', 153, 'MX'),
(2448, '26', 'Sonora', 153, 'MX'),
(2449, '27', 'Tabasco', 153, 'MX'),
(2450, '28', 'Tamaulipas', 153, 'MX'),
(2451, '29', 'Tlaxcala', 153, 'MX'),
(2452, '30', 'Veracruz-Llave', 153, 'MX'),
(2453, '31', 'Yucatan', 153, 'MX'),
(2454, '32', 'Zacatecas', 153, 'MX'),
(2455, '01', 'Johor', 154, 'MY'),
(2456, '02', 'Kedah', 154, 'MY'),
(2457, '03', 'Kelantan', 154, 'MY'),
(2458, '04', 'Melaka', 154, 'MY'),
(2459, '05', 'Negeri Sembilan', 154, 'MY'),
(2460, '06', 'Pahang', 154, 'MY'),
(2461, '07', 'Perak', 154, 'MY'),
(2462, '08', 'Perlis', 154, 'MY'),
(2463, '09', 'Pulau Pinang', 154, 'MY'),
(2464, '11', 'Sarawak', 154, 'MY'),
(2465, '12', 'Selangor', 154, 'MY'),
(2466, '13', 'Terengganu', 154, 'MY'),
(2467, '14', 'Kuala Lumpur', 154, 'MY'),
(2468, '15', 'Labuan', 154, 'MY'),
(2469, '16', 'Sabah', 154, 'MY'),
(2470, '17', 'Putrajaya', 154, 'MY'),
(2471, '01', 'Cabo Delgado', 155, 'MZ'),
(2472, '02', 'Gaza', 155, 'MZ'),
(2473, '03', 'Inhambane', 155, 'MZ'),
(2474, '04', 'Maputo', 155, 'MZ'),
(2475, '05', 'Sofala', 155, 'MZ'),
(2476, '06', 'Nampula', 155, 'MZ'),
(2477, '07', 'Niassa', 155, 'MZ'),
(2478, '08', 'Tete', 155, 'MZ'),
(2479, '09', 'Zambezia', 155, 'MZ'),
(2480, '10', 'Manica', 155, 'MZ'),
(2481, '11', 'Maputo', 155, 'MZ'),
(2482, '01', 'Bethanien', 156, 'NA'),
(2483, '02', 'Caprivi Oos', 156, 'NA'),
(2484, '03', 'Boesmanland', 156, 'NA'),
(2485, '04', 'Gobabis', 156, 'NA'),
(2486, '05', 'Grootfontein', 156, 'NA'),
(2487, '06', 'Kaokoland', 156, 'NA'),
(2488, '07', 'Karibib', 156, 'NA'),
(2489, '08', 'Keetmanshoop', 156, 'NA'),
(2490, '09', 'Luderitz', 156, 'NA'),
(2491, '10', 'Maltahohe', 156, 'NA'),
(2492, '11', 'Okahandja', 156, 'NA'),
(2493, '12', 'Omaruru', 156, 'NA'),
(2494, '13', 'Otjiwarongo', 156, 'NA'),
(2495, '14', 'Outjo', 156, 'NA'),
(2496, '15', 'Owambo', 156, 'NA'),
(2497, '16', 'Rehoboth', 156, 'NA'),
(2498, '17', 'Swakopmund', 156, 'NA'),
(2499, '18', 'Tsumeb', 156, 'NA'),
(2500, '20', 'Karasburg', 156, 'NA'),
(2501, '21', 'Windhoek', 156, 'NA'),
(2502, '22', 'Damaraland', 156, 'NA'),
(2503, '23', 'Hereroland Oos', 156, 'NA'),
(2504, '24', 'Hereroland Wes', 156, 'NA'),
(2505, '25', 'Kavango', 156, 'NA'),
(2506, '26', 'Mariental', 156, 'NA'),
(2507, '27', 'Namaland', 156, 'NA'),
(2508, '28', 'Caprivi', 156, 'NA'),
(2509, '29', 'Erongo', 156, 'NA'),
(2510, '30', 'Hardap', 156, 'NA'),
(2511, '31', 'Karas', 156, 'NA'),
(2512, '32', 'Kunene', 156, 'NA'),
(2513, '33', 'Ohangwena', 156, 'NA'),
(2514, '34', 'Okavango', 156, 'NA'),
(2515, '35', 'Omaheke', 156, 'NA'),
(2516, '36', 'Omusati', 156, 'NA'),
(2517, '37', 'Oshana', 156, 'NA'),
(2518, '38', 'Oshikoto', 156, 'NA'),
(2519, '39', 'Otjozondjupa', 156, 'NA'),
(2520, '01', 'Agadez', 158, 'NE'),
(2521, '02', 'Diffa', 158, 'NE'),
(2522, '03', 'Dosso', 158, 'NE'),
(2523, '04', 'Maradi', 158, 'NE'),
(2524, '05', 'Niamey', 158, 'NE'),
(2525, '06', 'Tahoua', 158, 'NE'),
(2526, '07', 'Zinder', 158, 'NE'),
(2527, '08', 'Niamey', 158, 'NE'),
(2528, '05', 'Lagos', 160, 'NG'),
(2529, '11', 'Federal Capital Territory', 160, 'NG'),
(2530, '16', 'Ogun', 160, 'NG'),
(2531, '21', 'Akwa Ibom', 160, 'NG'),
(2532, '22', 'Cross River', 160, 'NG'),
(2533, '23', 'Kaduna', 160, 'NG'),
(2534, '24', 'Katsina', 160, 'NG'),
(2535, '25', 'Anambra', 160, 'NG'),
(2536, '26', 'Benue', 160, 'NG'),
(2537, '27', 'Borno', 160, 'NG'),
(2538, '28', 'Imo', 160, 'NG'),
(2539, '29', 'Kano', 160, 'NG'),
(2540, '30', 'Kwara', 160, 'NG'),
(2541, '31', 'Niger', 160, 'NG'),
(2542, '32', 'Oyo', 160, 'NG'),
(2543, '35', 'Adamawa', 160, 'NG'),
(2544, '36', 'Delta', 160, 'NG'),
(2545, '37', 'Edo', 160, 'NG'),
(2546, '39', 'Jigawa', 160, 'NG'),
(2547, '40', 'Kebbi', 160, 'NG'),
(2548, '41', 'Kogi', 160, 'NG'),
(2549, '42', 'Osun', 160, 'NG'),
(2550, '43', 'Taraba', 160, 'NG'),
(2551, '44', 'Yobe', 160, 'NG'),
(2552, '45', 'Abia', 160, 'NG'),
(2553, '46', 'Bauchi', 160, 'NG'),
(2554, '47', 'Enugu', 160, 'NG'),
(2555, '48', 'Ondo', 160, 'NG'),
(2556, '49', 'Plateau', 160, 'NG'),
(2557, '50', 'Rivers', 160, 'NG'),
(2558, '51', 'Sokoto', 160, 'NG'),
(2559, '52', 'Bayelsa', 160, 'NG'),
(2560, '53', 'Ebonyi', 160, 'NG'),
(2561, '54', 'Ekiti', 160, 'NG'),
(2562, '55', 'Gombe', 160, 'NG'),
(2563, '56', 'Nassarawa', 160, 'NG'),
(2564, '57', 'Zamfara', 160, 'NG'),
(2565, '01', 'Boaco', 161, 'NI'),
(2566, '02', 'Carazo', 161, 'NI'),
(2567, '03', 'Chinandega', 161, 'NI'),
(2568, '04', 'Chontales', 161, 'NI'),
(2569, '05', 'Esteli', 161, 'NI'),
(2570, '06', 'Granada', 161, 'NI'),
(2571, '07', 'Jinotega', 161, 'NI'),
(2572, '08', 'Leon', 161, 'NI'),
(2573, '09', 'Madriz', 161, 'NI'),
(2574, '10', 'Managua', 161, 'NI'),
(2575, '11', 'Masaya', 161, 'NI'),
(2576, '12', 'Matagalpa', 161, 'NI'),
(2577, '13', 'Nueva Segovia', 161, 'NI'),
(2578, '14', 'Rio San Juan', 161, 'NI'),
(2579, '15', 'Rivas', 161, 'NI'),
(2580, '16', 'Zelaya', 161, 'NI'),
(2581, '17', 'Autonoma Atlantico Norte', 161, 'NI'),
(2582, '18', 'Region Autonoma Atlantico Sur', 161, 'NI'),
(2583, '01', 'Drenthe', 162, 'NL'),
(2584, '02', 'Friesland', 162, 'NL'),
(2585, '03', 'Gelderland', 162, 'NL'),
(2586, '04', 'Groningen', 162, 'NL'),
(2587, '05', 'Limburg', 162, 'NL'),
(2588, '06', 'Noord-Brabant', 162, 'NL'),
(2589, '07', 'Noord-Holland', 162, 'NL'),
(2590, '08', 'Overijssel', 162, 'NL'),
(2591, '09', 'Utrecht', 162, 'NL'),
(2592, '10', 'Zeeland', 162, 'NL'),
(2593, '11', 'Zuid-Holland', 162, 'NL'),
(2594, '15', 'Overijssel', 162, 'NL'),
(2595, '16', 'Flevoland', 162, 'NL'),
(2596, '01', 'Akershus', 163, 'NO'),
(2597, '02', 'Aust-Agder', 163, 'NO'),
(2598, '04', 'Buskerud', 163, 'NO'),
(2599, '05', 'Finnmark', 163, 'NO'),
(2600, '06', 'Hedmark', 163, 'NO'),
(2601, '07', 'Hordaland', 163, 'NO'),
(2602, '08', 'More og Romsdal', 163, 'NO'),
(2603, '09', 'Nordland', 163, 'NO'),
(2604, '10', 'Nord-Trondelag', 163, 'NO'),
(2605, '11', 'Oppland', 163, 'NO'),
(2606, '12', 'Oslo', 163, 'NO'),
(2607, '13', 'Ostfold', 163, 'NO'),
(2608, '14', 'Rogaland', 163, 'NO'),
(2609, '15', 'Sogn og Fjordane', 163, 'NO'),
(2610, '16', 'Sor-Trondelag', 163, 'NO'),
(2611, '17', 'Telemark', 163, 'NO'),
(2612, '18', 'Troms', 163, 'NO'),
(2613, '19', 'Vest-Agder', 163, 'NO'),
(2614, '20', 'Vestfold', 163, 'NO'),
(2615, '01', 'Bagmati', 164, 'NP'),
(2616, '02', 'Bheri', 164, 'NP'),
(2617, '03', 'Dhawalagiri', 164, 'NP'),
(2618, '04', 'Gandaki', 164, 'NP'),
(2619, '05', 'Janakpur', 164, 'NP'),
(2620, '06', 'Karnali', 164, 'NP'),
(2621, '07', 'Kosi', 164, 'NP'),
(2622, '08', 'Lumbini', 164, 'NP'),
(2623, '09', 'Mahakali', 164, 'NP'),
(2624, '10', 'Mechi', 164, 'NP'),
(2625, '11', 'Narayani', 164, 'NP'),
(2626, '12', 'Rapti', 164, 'NP'),
(2627, '13', 'Sagarmatha', 164, 'NP'),
(2628, '14', 'Seti', 164, 'NP'),
(2629, '01', 'Aiwo', 165, 'NR'),
(2630, '02', 'Anabar', 165, 'NR'),
(2631, '03', 'Anetan', 165, 'NR'),
(2632, '04', 'Anibare', 165, 'NR'),
(2633, '05', 'Baiti', 165, 'NR'),
(2634, '06', 'Boe', 165, 'NR'),
(2635, '07', 'Buada', 165, 'NR'),
(2636, '08', 'Denigomodu', 165, 'NR'),
(2637, '09', 'Ewa', 165, 'NR'),
(2638, '10', 'Ijuw', 165, 'NR'),
(2639, '11', 'Meneng', 165, 'NR'),
(2640, '12', 'Nibok', 165, 'NR'),
(2641, '13', 'Uaboe', 165, 'NR'),
(2642, '14', 'Yaren', 165, 'NR'),
(2643, '10', 'Chatham Islands', 167, 'NZ'),
(2644, 'E7', 'Auckland', 167, 'NZ'),
(2645, 'E8', 'Bay of Plenty', 167, 'NZ'),
(2646, 'E9', 'Canterbury', 167, 'NZ'),
(2647, 'F1', 'Gisborne', 167, 'NZ'),
(2648, 'F2', 'Hawke\'s Bay', 167, 'NZ'),
(2649, 'F3', 'Manawatu-Wanganui', 167, 'NZ'),
(2650, 'F4', 'Marlborough', 167, 'NZ'),
(2651, 'F5', 'Nelson', 167, 'NZ'),
(2652, 'F6', 'Northland', 167, 'NZ'),
(2653, 'F7', 'Otago', 167, 'NZ'),
(2654, 'F8', 'Southland', 167, 'NZ'),
(2655, 'F9', 'Taranaki', 167, 'NZ'),
(2656, 'G1', 'Waikato', 167, 'NZ'),
(2657, 'G2', 'Wellington', 167, 'NZ'),
(2658, 'G3', 'West Coast', 167, 'NZ'),
(2659, '01', 'Ad Dakhiliyah', 168, 'OM'),
(2660, '02', 'Al Batinah', 168, 'OM'),
(2661, '03', 'Al Wusta', 168, 'OM'),
(2662, '04', 'Ash Sharqiyah', 168, 'OM'),
(2663, '05', 'Az Zahirah', 168, 'OM'),
(2664, '06', 'Masqat', 168, 'OM'),
(2665, '07', 'Musandam', 168, 'OM'),
(2666, '08', 'Zufar', 168, 'OM'),
(2667, '01', 'Bocas del Toro', 169, 'PA'),
(2668, '02', 'Chiriqui', 169, 'PA'),
(2669, '03', 'Cocle', 169, 'PA'),
(2670, '04', 'Colon', 169, 'PA'),
(2671, '05', 'Darien', 169, 'PA'),
(2672, '06', 'Herrera', 169, 'PA'),
(2673, '07', 'Los Santos', 169, 'PA'),
(2674, '08', 'Panama', 169, 'PA'),
(2675, '09', 'San Blas', 169, 'PA'),
(2676, '10', 'Veraguas', 169, 'PA'),
(2677, '01', 'Amazonas', 170, 'PE'),
(2678, '02', 'Ancash', 170, 'PE'),
(2679, '03', 'Apurimac', 170, 'PE'),
(2680, '04', 'Arequipa', 170, 'PE'),
(2681, '05', 'Ayacucho', 170, 'PE'),
(2682, '06', 'Cajamarca', 170, 'PE'),
(2683, '07', 'Callao', 170, 'PE'),
(2684, '08', 'Cusco', 170, 'PE'),
(2685, '09', 'Huancavelica', 170, 'PE'),
(2686, '10', 'Huanuco', 170, 'PE'),
(2687, '11', 'Ica', 170, 'PE'),
(2688, '12', 'Junin', 170, 'PE'),
(2689, '13', 'La Libertad', 170, 'PE'),
(2690, '14', 'Lambayeque', 170, 'PE'),
(2691, '15', 'Lima', 170, 'PE'),
(2692, '16', 'Loreto', 170, 'PE'),
(2693, '17', 'Madre de Dios', 170, 'PE'),
(2694, '18', 'Moquegua', 170, 'PE'),
(2695, '19', 'Pasco', 170, 'PE'),
(2696, '20', 'Piura', 170, 'PE'),
(2697, '21', 'Puno', 170, 'PE'),
(2698, '22', 'San Martin', 170, 'PE'),
(2699, '23', 'Tacna', 170, 'PE'),
(2700, '24', 'Tumbes', 170, 'PE'),
(2701, '25', 'Ucayali', 170, 'PE'),
(2702, '01', 'Central', 172, 'PG'),
(2703, '02', 'Gulf', 172, 'PG'),
(2704, '03', 'Milne Bay', 172, 'PG'),
(2705, '04', 'Northern', 172, 'PG'),
(2706, '05', 'Southern Highlands', 172, 'PG'),
(2707, '06', 'Western', 172, 'PG'),
(2708, '07', 'North Solomons', 172, 'PG'),
(2709, '08', 'Chimbu', 172, 'PG'),
(2710, '09', 'Eastern Highlands', 172, 'PG'),
(2711, '10', 'East New Britain', 172, 'PG'),
(2712, '11', 'East Sepik', 172, 'PG'),
(2713, '12', 'Madang', 172, 'PG'),
(2714, '13', 'Manus', 172, 'PG'),
(2715, '14', 'Morobe', 172, 'PG'),
(2716, '15', 'New Ireland', 172, 'PG'),
(2717, '16', 'Western Highlands', 172, 'PG'),
(2718, '17', 'West New Britain', 172, 'PG'),
(2719, '18', 'Sandaun', 172, 'PG'),
(2720, '19', 'Enga', 172, 'PG'),
(2721, '20', 'National Capital', 172, 'PG'),
(2722, '01', 'Abra', 173, 'PH'),
(2723, '02', 'Agusan del Norte', 173, 'PH'),
(2724, '03', 'Agusan del Sur', 173, 'PH'),
(2725, '04', 'Aklan', 173, 'PH'),
(2726, '05', 'Albay', 173, 'PH'),
(2727, '06', 'Antique', 173, 'PH'),
(2728, '07', 'Bataan', 173, 'PH'),
(2729, '08', 'Batanes', 173, 'PH'),
(2730, '09', 'Batangas', 173, 'PH'),
(2731, '10', 'Benguet', 173, 'PH'),
(2732, '11', 'Bohol', 173, 'PH'),
(2733, '12', 'Bukidnon', 173, 'PH'),
(2734, '13', 'Bulacan', 173, 'PH'),
(2735, '14', 'Cagayan', 173, 'PH'),
(2736, '15', 'Camarines Norte', 173, 'PH'),
(2737, '16', 'Camarines Sur', 173, 'PH'),
(2738, '17', 'Camiguin', 173, 'PH'),
(2739, '18', 'Capiz', 173, 'PH'),
(2740, '19', 'Catanduanes', 173, 'PH'),
(2741, '20', 'Cavite', 173, 'PH'),
(2742, '21', 'Cebu', 173, 'PH'),
(2743, '22', 'Basilan', 173, 'PH'),
(2744, '23', 'Eastern Samar', 173, 'PH'),
(2745, '24', 'Davao', 173, 'PH'),
(2746, '25', 'Davao del Sur', 173, 'PH'),
(2747, '26', 'Davao Oriental', 173, 'PH'),
(2748, '27', 'Ifugao', 173, 'PH'),
(2749, '28', 'Ilocos Norte', 173, 'PH'),
(2750, '29', 'Ilocos Sur', 173, 'PH'),
(2751, '30', 'Iloilo', 173, 'PH'),
(2752, '31', 'Isabela', 173, 'PH'),
(2753, '32', 'Kalinga-Apayao', 173, 'PH'),
(2754, '33', 'Laguna', 173, 'PH'),
(2755, '34', 'Lanao del Norte', 173, 'PH'),
(2756, '35', 'Lanao del Sur', 173, 'PH'),
(2757, '36', 'La Union', 173, 'PH'),
(2758, '37', 'Leyte', 173, 'PH'),
(2759, '38', 'Marinduque', 173, 'PH'),
(2760, '39', 'Masbate', 173, 'PH'),
(2761, '40', 'Mindoro Occidental', 173, 'PH'),
(2762, '41', 'Mindoro Oriental', 173, 'PH'),
(2763, '42', 'Misamis Occidental', 173, 'PH'),
(2764, '43', 'Misamis Oriental', 173, 'PH'),
(2765, '44', 'Mountain', 173, 'PH'),
(2766, '45', 'Negros Occidental', 173, 'PH'),
(2767, '46', 'Negros Oriental', 173, 'PH'),
(2768, '47', 'Nueva Ecija', 173, 'PH'),
(2769, '48', 'Nueva Vizcaya', 173, 'PH'),
(2770, '49', 'Palawan', 173, 'PH'),
(2771, '50', 'Pampanga', 173, 'PH'),
(2772, '51', 'Pangasinan', 173, 'PH'),
(2773, '53', 'Rizal', 173, 'PH'),
(2774, '54', 'Romblon', 173, 'PH'),
(2775, '55', 'Samar', 173, 'PH'),
(2776, '56', 'Maguindanao', 173, 'PH'),
(2777, '57', 'North Cotabato', 173, 'PH'),
(2778, '58', 'Sorsogon', 173, 'PH'),
(2779, '59', 'Southern Leyte', 173, 'PH'),
(2780, '60', 'Sulu', 173, 'PH'),
(2781, '61', 'Surigao del Norte', 173, 'PH'),
(2782, '62', 'Surigao del Sur', 173, 'PH'),
(2783, '63', 'Tarlac', 173, 'PH'),
(2784, '64', 'Zambales', 173, 'PH'),
(2785, '65', 'Zamboanga del Norte', 173, 'PH'),
(2786, '66', 'Zamboanga del Sur', 173, 'PH'),
(2787, '67', 'Northern Samar', 173, 'PH'),
(2788, '68', 'Quirino', 173, 'PH'),
(2789, '69', 'Siquijor', 173, 'PH'),
(2790, '70', 'South Cotabato', 173, 'PH'),
(2791, '71', 'Sultan Kudarat', 173, 'PH'),
(2792, '72', 'Tawitawi', 173, 'PH'),
(2793, 'A1', 'Angeles', 173, 'PH'),
(2794, 'A2', 'Bacolod', 173, 'PH'),
(2795, 'A3', 'Bago', 173, 'PH'),
(2796, 'A4', 'Baguio', 173, 'PH'),
(2797, 'A5', 'Bais', 173, 'PH'),
(2798, 'A6', 'Basilan City', 173, 'PH'),
(2799, 'A7', 'Batangas City', 173, 'PH'),
(2800, 'A8', 'Butuan', 173, 'PH'),
(2801, 'A9', 'Cabanatuan', 173, 'PH'),
(2802, 'B1', 'Cadiz', 173, 'PH'),
(2803, 'B2', 'Cagayan de Oro', 173, 'PH'),
(2804, 'B3', 'Calbayog', 173, 'PH'),
(2805, 'B4', 'Caloocan', 173, 'PH'),
(2806, 'B5', 'Canlaon', 173, 'PH'),
(2807, 'B6', 'Cavite City', 173, 'PH'),
(2808, 'B7', 'Cebu City', 173, 'PH'),
(2809, 'B8', 'Cotabato', 173, 'PH'),
(2810, 'B9', 'Dagupan', 173, 'PH'),
(2811, 'C1', 'Danao', 173, 'PH'),
(2812, 'C2', 'Dapitan', 173, 'PH'),
(2813, 'C3', 'Davao City', 173, 'PH'),
(2814, 'C4', 'Dipolog', 173, 'PH'),
(2815, 'C5', 'Dumaguete', 173, 'PH');
INSERT INTO `mmregions` (`RegionID`, `RegionCode`, `RegionName`, `CountryID`, `CountryCode`) VALUES
(2816, 'C6', 'General Santos', 173, 'PH'),
(2817, 'C7', 'Gingoog', 173, 'PH'),
(2818, 'C8', 'Iligan', 173, 'PH'),
(2819, 'C9', 'Iloilo City', 173, 'PH'),
(2820, 'D1', 'Iriga', 173, 'PH'),
(2821, 'D2', 'La Carlota', 173, 'PH'),
(2822, 'D3', 'Laoag', 173, 'PH'),
(2823, 'D4', 'Lapu-Lapu', 173, 'PH'),
(2824, 'D5', 'Legaspi', 173, 'PH'),
(2825, 'D6', 'Lipa', 173, 'PH'),
(2826, 'D7', 'Lucena', 173, 'PH'),
(2827, 'D8', 'Mandaue', 173, 'PH'),
(2828, 'D9', 'Manila', 173, 'PH'),
(2829, 'E1', 'Marawi', 173, 'PH'),
(2830, 'E2', 'Naga', 173, 'PH'),
(2831, 'E3', 'Olongapo', 173, 'PH'),
(2832, 'E4', 'Ormoc', 173, 'PH'),
(2833, 'E5', 'Oroquieta', 173, 'PH'),
(2834, 'E6', 'Ozamis', 173, 'PH'),
(2835, 'E7', 'Pagadian', 173, 'PH'),
(2836, 'E8', 'Palayan', 173, 'PH'),
(2837, 'E9', 'Pasay', 173, 'PH'),
(2838, 'F1', 'Puerto Princesa', 173, 'PH'),
(2839, 'F2', 'Quezon City', 173, 'PH'),
(2840, 'F3', 'Roxas', 173, 'PH'),
(2841, 'F4', 'San Carlos', 173, 'PH'),
(2842, 'F5', 'San Carlos', 173, 'PH'),
(2843, 'F6', 'San Jose', 173, 'PH'),
(2844, 'F7', 'San Pablo', 173, 'PH'),
(2845, 'F8', 'Silay', 173, 'PH'),
(2846, 'F9', 'Surigao', 173, 'PH'),
(2847, 'G1', 'Tacloban', 173, 'PH'),
(2848, 'G2', 'Tagaytay', 173, 'PH'),
(2849, 'G3', 'Tagbilaran', 173, 'PH'),
(2850, 'G4', 'Tangub', 173, 'PH'),
(2851, 'G5', 'Toledo', 173, 'PH'),
(2852, 'G6', 'Trece Martires', 173, 'PH'),
(2853, 'G7', 'Zamboanga', 173, 'PH'),
(2854, 'G8', 'Aurora', 173, 'PH'),
(2855, 'H2', 'Quezon', 173, 'PH'),
(2856, 'H3', 'Negros Occidental', 173, 'PH'),
(2857, '01', 'Federally Administered Tribal Areas', 174, 'PK'),
(2858, '02', 'Balochistan', 174, 'PK'),
(2859, '03', 'North-West Frontier', 174, 'PK'),
(2860, '04', 'Punjab', 174, 'PK'),
(2861, '05', 'Sindh', 174, 'PK'),
(2862, '06', 'Azad Kashmir', 174, 'PK'),
(2863, '07', 'Northern Areas', 174, 'PK'),
(2864, '08', 'Islamabad', 174, 'PK'),
(2865, '72', 'Dolnoslaskie', 175, 'PL'),
(2866, '73', 'Kujawsko-Pomorskie', 175, 'PL'),
(2867, '74', 'Lodzkie', 175, 'PL'),
(2868, '75', 'Lubelskie', 175, 'PL'),
(2869, '76', 'Lubuskie', 175, 'PL'),
(2870, '77', 'Malopolskie', 175, 'PL'),
(2871, '78', 'Mazowieckie', 175, 'PL'),
(2872, '79', 'Opolskie', 175, 'PL'),
(2873, '80', 'Podkarpackie', 175, 'PL'),
(2874, '81', 'Podlaskie', 175, 'PL'),
(2875, '82', 'Pomorskie', 175, 'PL'),
(2876, '83', 'Slaskie', 175, 'PL'),
(2877, '84', 'Swietokrzyskie', 175, 'PL'),
(2878, '85', 'Warminsko-Mazurskie', 175, 'PL'),
(2879, '86', 'Wielkopolskie', 175, 'PL'),
(2880, '87', 'Zachodniopomorskie', 175, 'PL'),
(2881, 'GZ', 'Gaza', 179, 'PS'),
(2882, 'WE', 'West Bank', 179, 'PS'),
(2883, '02', 'Aveiro', 180, 'PT'),
(2884, '03', 'Beja', 180, 'PT'),
(2885, '04', 'Braga', 180, 'PT'),
(2886, '05', 'Braganca', 180, 'PT'),
(2887, '06', 'Castelo Branco', 180, 'PT'),
(2888, '07', 'Coimbra', 180, 'PT'),
(2889, '08', 'Evora', 180, 'PT'),
(2890, '09', 'Faro', 180, 'PT'),
(2891, '10', 'Madeira', 180, 'PT'),
(2892, '11', 'Guarda', 180, 'PT'),
(2893, '13', 'Leiria', 180, 'PT'),
(2894, '14', 'Lisboa', 180, 'PT'),
(2895, '16', 'Portalegre', 180, 'PT'),
(2896, '17', 'Porto', 180, 'PT'),
(2897, '18', 'Santarem', 180, 'PT'),
(2898, '19', 'Setubal', 180, 'PT'),
(2899, '20', 'Viana do Castelo', 180, 'PT'),
(2900, '21', 'Vila Real', 180, 'PT'),
(2901, '22', 'Viseu', 180, 'PT'),
(2902, '23', 'Azores', 180, 'PT'),
(2903, '01', 'Alto Parana', 182, 'PY'),
(2904, '02', 'Amambay', 182, 'PY'),
(2905, '03', 'Boqueron', 182, 'PY'),
(2906, '04', 'Caaguazu', 182, 'PY'),
(2907, '05', 'Caazapa', 182, 'PY'),
(2908, '06', 'Central', 182, 'PY'),
(2909, '07', 'Concepcion', 182, 'PY'),
(2910, '08', 'Cordillera', 182, 'PY'),
(2911, '10', 'Guaira', 182, 'PY'),
(2912, '11', 'Itapua', 182, 'PY'),
(2913, '12', 'Misiones', 182, 'PY'),
(2914, '13', 'Neembucu', 182, 'PY'),
(2915, '15', 'Paraguari', 182, 'PY'),
(2916, '16', 'Presidente Hayes', 182, 'PY'),
(2917, '17', 'San Pedro', 182, 'PY'),
(2918, '19', 'Canindeyu', 182, 'PY'),
(2919, '20', 'Chaco', 182, 'PY'),
(2920, '21', 'Nueva Asuncion', 182, 'PY'),
(2921, '23', 'Alto Paraguay', 182, 'PY'),
(2922, '01', 'Ad Dawhah', 183, 'QA'),
(2923, '02', 'Al Ghuwariyah', 183, 'QA'),
(2924, '03', 'Al Jumaliyah', 183, 'QA'),
(2925, '04', 'Al Khawr', 183, 'QA'),
(2926, '05', 'Al Wakrah Municipality', 183, 'QA'),
(2927, '06', 'Ar Rayyan', 183, 'QA'),
(2928, '08', 'Madinat ach Shamal', 183, 'QA'),
(2929, '09', 'Umm Salal', 183, 'QA'),
(2930, '10', 'Al Wakrah', 183, 'QA'),
(2931, '11', 'Jariyan al Batnah', 183, 'QA'),
(2932, '12', 'Umm Sa\'id', 183, 'QA'),
(2933, '01', 'Alba', 185, 'RO'),
(2934, '02', 'Arad', 185, 'RO'),
(2935, '03', 'Arges', 185, 'RO'),
(2936, '04', 'Bacau', 185, 'RO'),
(2937, '05', 'Bihor', 185, 'RO'),
(2938, '06', 'Bistrita-Nasaud', 185, 'RO'),
(2939, '07', 'Botosani', 185, 'RO'),
(2940, '08', 'Braila', 185, 'RO'),
(2941, '09', 'Brasov', 185, 'RO'),
(2942, '10', 'Bucuresti', 185, 'RO'),
(2943, '11', 'Buzau', 185, 'RO'),
(2944, '12', 'Caras-Severin', 185, 'RO'),
(2945, '13', 'Cluj', 185, 'RO'),
(2946, '14', 'Constanta', 185, 'RO'),
(2947, '15', 'Covasna', 185, 'RO'),
(2948, '16', 'Dambovita', 185, 'RO'),
(2949, '17', 'Dolj', 185, 'RO'),
(2950, '18', 'Galati', 185, 'RO'),
(2951, '19', 'Gorj', 185, 'RO'),
(2952, '20', 'Harghita', 185, 'RO'),
(2953, '21', 'Hunedoara', 185, 'RO'),
(2954, '22', 'Ialomita', 185, 'RO'),
(2955, '23', 'Iasi', 185, 'RO'),
(2956, '25', 'Maramures', 185, 'RO'),
(2957, '26', 'Mehedinti', 185, 'RO'),
(2958, '27', 'Mures', 185, 'RO'),
(2959, '28', 'Neamt', 185, 'RO'),
(2960, '29', 'Olt', 185, 'RO'),
(2961, '30', 'Prahova', 185, 'RO'),
(2962, '31', 'Salaj', 185, 'RO'),
(2963, '32', 'Satu Mare', 185, 'RO'),
(2964, '33', 'Sibiu', 185, 'RO'),
(2965, '34', 'Suceava', 185, 'RO'),
(2966, '35', 'Teleorman', 185, 'RO'),
(2967, '36', 'Timis', 185, 'RO'),
(2968, '37', 'Tulcea', 185, 'RO'),
(2969, '38', 'Vaslui', 185, 'RO'),
(2970, '39', 'Valcea', 185, 'RO'),
(2971, '40', 'Vrancea', 185, 'RO'),
(2972, '41', 'Calarasi', 185, 'RO'),
(2973, '42', 'Giurgiu', 185, 'RO'),
(2974, '43', 'Ilfov', 185, 'RO'),
(2975, '01', 'Kosovo', 240, 'RS'),
(2976, '02', 'Vojvodina', 240, 'RS'),
(2977, '01', 'Adygeya, Republic of', 186, 'RU'),
(2978, '02', 'Aginsky Buryatsky AO', 186, 'RU'),
(2979, '03', 'Gorno-Altay', 186, 'RU'),
(2980, '04', 'Altaisky krai', 186, 'RU'),
(2981, '05', 'Amur', 186, 'RU'),
(2982, '06', 'Arkhangel\'sk', 186, 'RU'),
(2983, '07', 'Astrakhan\'', 186, 'RU'),
(2984, '08', 'Bashkortostan', 186, 'RU'),
(2985, '09', 'Belgorod', 186, 'RU'),
(2986, '10', 'Bryansk', 186, 'RU'),
(2987, '11', 'Buryat', 186, 'RU'),
(2988, '12', 'Chechnya', 186, 'RU'),
(2989, '13', 'Chelyabinsk', 186, 'RU'),
(2990, '14', 'Chita', 186, 'RU'),
(2991, '15', 'Chukot', 186, 'RU'),
(2992, '16', 'Chuvashia', 186, 'RU'),
(2993, '17', 'Dagestan', 186, 'RU'),
(2994, '18', 'Evenk', 186, 'RU'),
(2995, '19', 'Ingush', 186, 'RU'),
(2996, '20', 'Irkutsk', 186, 'RU'),
(2997, '21', 'Ivanovo', 186, 'RU'),
(2998, '22', 'Kabardin-Balkar', 186, 'RU'),
(2999, '23', 'Kaliningrad', 186, 'RU'),
(3000, '24', 'Kalmyk', 186, 'RU'),
(3001, '25', 'Kaluga', 186, 'RU'),
(3002, '26', 'Kamchatka', 186, 'RU'),
(3003, '27', 'Karachay-Cherkess', 186, 'RU'),
(3004, '28', 'Karelia', 186, 'RU'),
(3005, '29', 'Kemerovo', 186, 'RU'),
(3006, '30', 'Khabarovsk', 186, 'RU'),
(3007, '31', 'Khakass', 186, 'RU'),
(3008, '32', 'Khanty-Mansiy', 186, 'RU'),
(3009, '33', 'Kirov', 186, 'RU'),
(3010, '34', 'Komi', 186, 'RU'),
(3011, '35', 'Komi-Permyak', 186, 'RU'),
(3012, '36', 'Koryak', 186, 'RU'),
(3013, '37', 'Kostroma', 186, 'RU'),
(3014, '38', 'Krasnodar', 186, 'RU'),
(3015, '39', 'Krasnoyarsk', 186, 'RU'),
(3016, '40', 'Kurgan', 186, 'RU'),
(3017, '41', 'Kursk', 186, 'RU'),
(3018, '42', 'Leningrad', 186, 'RU'),
(3019, '43', 'Lipetsk', 186, 'RU'),
(3020, '44', 'Magadan', 186, 'RU'),
(3021, '45', 'Mariy-El', 186, 'RU'),
(3022, '46', 'Mordovia', 186, 'RU'),
(3023, '47', 'Moskva', 186, 'RU'),
(3024, '48', 'Moscow City', 186, 'RU'),
(3025, '49', 'Murmansk', 186, 'RU'),
(3026, '50', 'Nenets', 186, 'RU'),
(3027, '51', 'Nizhegorod', 186, 'RU'),
(3028, '52', 'Novgorod', 186, 'RU'),
(3029, '53', 'Novosibirsk', 186, 'RU'),
(3030, '54', 'Omsk', 186, 'RU'),
(3031, '55', 'Orenburg', 186, 'RU'),
(3032, '56', 'Orel', 186, 'RU'),
(3033, '57', 'Penza', 186, 'RU'),
(3034, '58', 'Perm\'', 186, 'RU'),
(3035, '59', 'Primor\'ye', 186, 'RU'),
(3036, '60', 'Pskov', 186, 'RU'),
(3037, '61', 'Rostov', 186, 'RU'),
(3038, '62', 'Ryazan\'', 186, 'RU'),
(3039, '63', 'Sakha', 186, 'RU'),
(3040, '64', 'Sakhalin', 186, 'RU'),
(3041, '65', 'Samara', 186, 'RU'),
(3042, '66', 'Saint Petersburg City', 186, 'RU'),
(3043, '67', 'Saratov', 186, 'RU'),
(3044, '68', 'North Ossetia', 186, 'RU'),
(3045, '69', 'Smolensk', 186, 'RU'),
(3046, '70', 'Stavropol\'', 186, 'RU'),
(3047, '71', 'Sverdlovsk', 186, 'RU'),
(3048, '72', 'Tambovskaya oblast', 186, 'RU'),
(3049, '73', 'Tatarstan', 186, 'RU'),
(3050, '74', 'Taymyr', 186, 'RU'),
(3051, '75', 'Tomsk', 186, 'RU'),
(3052, '76', 'Tula', 186, 'RU'),
(3053, '77', 'Tver\'', 186, 'RU'),
(3054, '78', 'Tyumen\'', 186, 'RU'),
(3055, '79', 'Tuva', 186, 'RU'),
(3056, '80', 'Udmurt', 186, 'RU'),
(3057, '81', 'Ul\'yanovsk', 186, 'RU'),
(3058, '82', 'Ust-Orda Buryat', 186, 'RU'),
(3059, '83', 'Vladimir', 186, 'RU'),
(3060, '84', 'Volgograd', 186, 'RU'),
(3061, '85', 'Vologda', 186, 'RU'),
(3062, '86', 'Voronezh', 186, 'RU'),
(3063, '87', 'Yamal-Nenets', 186, 'RU'),
(3064, '88', 'Yaroslavl\'', 186, 'RU'),
(3065, '89', 'Yevrey', 186, 'RU'),
(3066, '90', 'Permskiy Kray', 186, 'RU'),
(3067, '91', 'Krasnoyarskiy Kray', 186, 'RU'),
(3068, 'CI', 'Chechnya Republic', 186, 'RU'),
(3069, '01', 'Butare', 187, 'RW'),
(3070, '06', 'Gitarama', 187, 'RW'),
(3071, '07', 'Kibungo', 187, 'RW'),
(3072, '09', 'Kigali', 187, 'RW'),
(3073, '11', 'Est', 187, 'RW'),
(3074, '12', 'Kigali', 187, 'RW'),
(3075, '13', 'Nord', 187, 'RW'),
(3076, '14', 'Ouest', 187, 'RW'),
(3077, '15', 'Sud', 187, 'RW'),
(3078, '02', 'Al Bahah', 188, 'SA'),
(3079, '03', 'Al Jawf', 188, 'SA'),
(3080, '05', 'Al Madinah', 188, 'SA'),
(3081, '06', 'Ash Sharqiyah', 188, 'SA'),
(3082, '08', 'Al Qasim', 188, 'SA'),
(3083, '09', 'Al Qurayyat', 188, 'SA'),
(3084, '10', 'Ar Riyad', 188, 'SA'),
(3085, '13', 'Ha\'il', 188, 'SA'),
(3086, '14', 'Makkah', 188, 'SA'),
(3087, '15', 'Al Hudud ash Shamaliyah', 188, 'SA'),
(3088, '16', 'Najran', 188, 'SA'),
(3089, '17', 'Jizan', 188, 'SA'),
(3090, '19', 'Tabuk', 188, 'SA'),
(3091, '20', 'Al Jawf', 188, 'SA'),
(3092, '03', 'Malaita', 189, 'SB'),
(3093, '06', 'Guadalcanal', 189, 'SB'),
(3094, '07', 'Isabel', 189, 'SB'),
(3095, '08', 'Makira', 189, 'SB'),
(3096, '09', 'Temotu', 189, 'SB'),
(3097, '10', 'Central', 189, 'SB'),
(3098, '11', 'Western', 189, 'SB'),
(3099, '12', 'Choiseul', 189, 'SB'),
(3100, '13', 'Rennell and Bellona', 189, 'SB'),
(3101, '01', 'Anse aux Pins', 190, 'SC'),
(3102, '02', 'Anse Boileau', 190, 'SC'),
(3103, '03', 'Anse Etoile', 190, 'SC'),
(3104, '04', 'Anse Louis', 190, 'SC'),
(3105, '05', 'Anse Royale', 190, 'SC'),
(3106, '06', 'Baie Lazare', 190, 'SC'),
(3107, '07', 'Baie Sainte Anne', 190, 'SC'),
(3108, '08', 'Beau Vallon', 190, 'SC'),
(3109, '09', 'Bel Air', 190, 'SC'),
(3110, '10', 'Bel Ombre', 190, 'SC'),
(3111, '11', 'Cascade', 190, 'SC'),
(3112, '12', 'Glacis', 190, 'SC'),
(3113, '13', 'Grand\' Anse', 190, 'SC'),
(3114, '14', 'Grand\' Anse', 190, 'SC'),
(3115, '15', 'La Digue', 190, 'SC'),
(3116, '16', 'La Riviere Anglaise', 190, 'SC'),
(3117, '17', 'Mont Buxton', 190, 'SC'),
(3118, '18', 'Mont Fleuri', 190, 'SC'),
(3119, '19', 'Plaisance', 190, 'SC'),
(3120, '20', 'Pointe La Rue', 190, 'SC'),
(3121, '21', 'Port Glaud', 190, 'SC'),
(3122, '22', 'Saint Louis', 190, 'SC'),
(3123, '23', 'Takamaka', 190, 'SC'),
(3124, '27', 'Al Wusta', 191, 'SD'),
(3125, '28', 'Al Istiwa\'iyah', 191, 'SD'),
(3126, '29', 'Al Khartum', 191, 'SD'),
(3127, '30', 'Ash Shamaliyah', 191, 'SD'),
(3128, '31', 'Ash Sharqiyah', 191, 'SD'),
(3129, '32', 'Bahr al Ghazal', 191, 'SD'),
(3130, '33', 'Darfur', 191, 'SD'),
(3131, '34', 'Kurdufan', 191, 'SD'),
(3132, '35', 'Upper Nile', 191, 'SD'),
(3133, '40', 'Al Wahadah State', 191, 'SD'),
(3134, '44', 'Central Equatoria State', 191, 'SD'),
(3135, '02', 'Blekinge Lan', 192, 'SE'),
(3136, '03', 'Gavleborgs Lan', 192, 'SE'),
(3137, '05', 'Gotlands Lan', 192, 'SE'),
(3138, '06', 'Hallands Lan', 192, 'SE'),
(3139, '07', 'Jamtlands Lan', 192, 'SE'),
(3140, '08', 'Jonkopings Lan', 192, 'SE'),
(3141, '09', 'Kalmar Lan', 192, 'SE'),
(3142, '10', 'Dalarnas Lan', 192, 'SE'),
(3143, '12', 'Kronobergs Lan', 192, 'SE'),
(3144, '14', 'Norrbottens Lan', 192, 'SE'),
(3145, '15', 'Orebro Lan', 192, 'SE'),
(3146, '16', 'Ostergotlands Lan', 192, 'SE'),
(3147, '18', 'Sodermanlands Lan', 192, 'SE'),
(3148, '21', 'Uppsala Lan', 192, 'SE'),
(3149, '22', 'Varmlands Lan', 192, 'SE'),
(3150, '23', 'Vasterbottens Lan', 192, 'SE'),
(3151, '24', 'Vasternorrlands Lan', 192, 'SE'),
(3152, '25', 'Vastmanlands Lan', 192, 'SE'),
(3153, '26', 'Stockholms Lan', 192, 'SE'),
(3154, '27', 'Skane Lan', 192, 'SE'),
(3155, '28', 'Vastra Gotaland', 192, 'SE'),
(3156, '01', 'Ascension', 194, 'SH'),
(3157, '02', 'Saint Helena', 194, 'SH'),
(3158, '03', 'Tristan da Cunha', 194, 'SH'),
(3159, '01', 'Ajdovscina', 195, 'SI'),
(3160, '02', 'Beltinci', 195, 'SI'),
(3161, '03', 'Bled', 195, 'SI'),
(3162, '04', 'Bohinj', 195, 'SI'),
(3163, '05', 'Borovnica', 195, 'SI'),
(3164, '06', 'Bovec', 195, 'SI'),
(3165, '07', 'Brda', 195, 'SI'),
(3166, '08', 'Brezice', 195, 'SI'),
(3167, '09', 'Brezovica', 195, 'SI'),
(3168, '11', 'Celje', 195, 'SI'),
(3169, '12', 'Cerklje na Gorenjskem', 195, 'SI'),
(3170, '13', 'Cerknica', 195, 'SI'),
(3171, '14', 'Cerkno', 195, 'SI'),
(3172, '15', 'Crensovci', 195, 'SI'),
(3173, '16', 'Crna na Koroskem', 195, 'SI'),
(3174, '17', 'Crnomelj', 195, 'SI'),
(3175, '19', 'Divaca', 195, 'SI'),
(3176, '20', 'Dobrepolje', 195, 'SI'),
(3177, '22', 'Dol pri Ljubljani', 195, 'SI'),
(3178, '24', 'Dornava', 195, 'SI'),
(3179, '25', 'Dravograd', 195, 'SI'),
(3180, '26', 'Duplek', 195, 'SI'),
(3181, '27', 'Gorenja Vas-Poljane', 195, 'SI'),
(3182, '28', 'Gorisnica', 195, 'SI'),
(3183, '29', 'Gornja Radgona', 195, 'SI'),
(3184, '30', 'Gornji Grad', 195, 'SI'),
(3185, '31', 'Gornji Petrovci', 195, 'SI'),
(3186, '32', 'Grosuplje', 195, 'SI'),
(3187, '34', 'Hrastnik', 195, 'SI'),
(3188, '35', 'Hrpelje-Kozina', 195, 'SI'),
(3189, '36', 'Idrija', 195, 'SI'),
(3190, '37', 'Ig', 195, 'SI'),
(3191, '38', 'Ilirska Bistrica', 195, 'SI'),
(3192, '39', 'Ivancna Gorica', 195, 'SI'),
(3193, '40', 'Izola-Isola', 195, 'SI'),
(3194, '42', 'Jursinci', 195, 'SI'),
(3195, '44', 'Kanal', 195, 'SI'),
(3196, '45', 'Kidricevo', 195, 'SI'),
(3197, '46', 'Kobarid', 195, 'SI'),
(3198, '47', 'Kobilje', 195, 'SI'),
(3199, '49', 'Komen', 195, 'SI'),
(3200, '50', 'Koper-Capodistria', 195, 'SI'),
(3201, '51', 'Kozje', 195, 'SI'),
(3202, '52', 'Kranj', 195, 'SI'),
(3203, '53', 'Kranjska Gora', 195, 'SI'),
(3204, '54', 'Krsko', 195, 'SI'),
(3205, '55', 'Kungota', 195, 'SI'),
(3206, '57', 'Lasko', 195, 'SI'),
(3207, '61', 'Ljubljana', 195, 'SI'),
(3208, '62', 'Ljubno', 195, 'SI'),
(3209, '64', 'Logatec', 195, 'SI'),
(3210, '66', 'Loski Potok', 195, 'SI'),
(3211, '68', 'Lukovica', 195, 'SI'),
(3212, '71', 'Medvode', 195, 'SI'),
(3213, '72', 'Menges', 195, 'SI'),
(3214, '73', 'Metlika', 195, 'SI'),
(3215, '74', 'Mezica', 195, 'SI'),
(3216, '76', 'Mislinja', 195, 'SI'),
(3217, '77', 'Moravce', 195, 'SI'),
(3218, '78', 'Moravske Toplice', 195, 'SI'),
(3219, '79', 'Mozirje', 195, 'SI'),
(3220, '80', 'Murska Sobota', 195, 'SI'),
(3221, '81', 'Muta', 195, 'SI'),
(3222, '82', 'Naklo', 195, 'SI'),
(3223, '83', 'Nazarje', 195, 'SI'),
(3224, '84', 'Nova Gorica', 195, 'SI'),
(3225, '86', 'Odranci', 195, 'SI'),
(3226, '87', 'Ormoz', 195, 'SI'),
(3227, '88', 'Osilnica', 195, 'SI'),
(3228, '89', 'Pesnica', 195, 'SI'),
(3229, '91', 'Pivka', 195, 'SI'),
(3230, '92', 'Podcetrtek', 195, 'SI'),
(3231, '94', 'Postojna', 195, 'SI'),
(3232, '97', 'Puconci', 195, 'SI'),
(3233, '98', 'Racam', 195, 'SI'),
(3234, '99', 'Radece', 195, 'SI'),
(3235, 'A1', 'Radenci', 195, 'SI'),
(3236, 'A2', 'Radlje ob Dravi', 195, 'SI'),
(3237, 'A3', 'Radovljica', 195, 'SI'),
(3238, 'A6', 'Rogasovci', 195, 'SI'),
(3239, 'A7', 'Rogaska Slatina', 195, 'SI'),
(3240, 'A8', 'Rogatec', 195, 'SI'),
(3241, 'B1', 'Semic', 195, 'SI'),
(3242, 'B2', 'Sencur', 195, 'SI'),
(3243, 'B3', 'Sentilj', 195, 'SI'),
(3244, 'B4', 'Sentjernej', 195, 'SI'),
(3245, 'B6', 'Sevnica', 195, 'SI'),
(3246, 'B7', 'Sezana', 195, 'SI'),
(3247, 'B8', 'Skocjan', 195, 'SI'),
(3248, 'B9', 'Skofja Loka', 195, 'SI'),
(3249, 'C1', 'Skofljica', 195, 'SI'),
(3250, 'C2', 'Slovenj Gradec', 195, 'SI'),
(3251, 'C4', 'Slovenske Konjice', 195, 'SI'),
(3252, 'C5', 'Smarje pri Jelsah', 195, 'SI'),
(3253, 'C6', 'Smartno ob Paki', 195, 'SI'),
(3254, 'C7', 'Sostanj', 195, 'SI'),
(3255, 'C8', 'Starse', 195, 'SI'),
(3256, 'C9', 'Store', 195, 'SI'),
(3257, 'D1', 'Sveti Jurij', 195, 'SI'),
(3258, 'D2', 'Tolmin', 195, 'SI'),
(3259, 'D3', 'Trbovlje', 195, 'SI'),
(3260, 'D4', 'Trebnje', 195, 'SI'),
(3261, 'D5', 'Trzic', 195, 'SI'),
(3262, 'D6', 'Turnisce', 195, 'SI'),
(3263, 'D7', 'Velenje', 195, 'SI'),
(3264, 'D8', 'Velike Lasce', 195, 'SI'),
(3265, 'E1', 'Vipava', 195, 'SI'),
(3266, 'E2', 'Vitanje', 195, 'SI'),
(3267, 'E3', 'Vodice', 195, 'SI'),
(3268, 'E5', 'Vrhnika', 195, 'SI'),
(3269, 'E6', 'Vuzenica', 195, 'SI'),
(3270, 'E7', 'Zagorje ob Savi', 195, 'SI'),
(3271, 'E9', 'Zavrc', 195, 'SI'),
(3272, 'F1', 'Zelezniki', 195, 'SI'),
(3273, 'F2', 'Ziri', 195, 'SI'),
(3274, 'F3', 'Zrece', 195, 'SI'),
(3275, 'G4', 'Dobrova-Horjul-Polhov Gradec', 195, 'SI'),
(3276, 'G7', 'Domzale', 195, 'SI'),
(3277, 'H4', 'Jesenice', 195, 'SI'),
(3278, 'H6', 'Kamnik', 195, 'SI'),
(3279, 'H7', 'Kocevje', 195, 'SI'),
(3280, 'I2', 'Kuzma', 195, 'SI'),
(3281, 'I3', 'Lenart', 195, 'SI'),
(3282, 'I5', 'Litija', 195, 'SI'),
(3283, 'I6', 'Ljutomer', 195, 'SI'),
(3284, 'I7', 'Loska Dolina', 195, 'SI'),
(3285, 'I9', 'Luce', 195, 'SI'),
(3286, 'J1', 'Majsperk', 195, 'SI'),
(3287, 'J2', 'Maribor', 195, 'SI'),
(3288, 'J5', 'Miren-Kostanjevica', 195, 'SI'),
(3289, 'J7', 'Novo Mesto', 195, 'SI'),
(3290, 'J9', 'Piran', 195, 'SI'),
(3291, 'K5', 'Preddvor', 195, 'SI'),
(3292, 'K7', 'Ptuj', 195, 'SI'),
(3293, 'L1', 'Ribnica', 195, 'SI'),
(3294, 'L3', 'Ruse', 195, 'SI'),
(3295, 'L7', 'Sentjur pri Celju', 195, 'SI'),
(3296, 'L8', 'Slovenska Bistrica', 195, 'SI'),
(3297, 'N2', 'Videm', 195, 'SI'),
(3298, 'N3', 'Vojnik', 195, 'SI'),
(3299, 'N5', 'Zalec', 195, 'SI'),
(3300, '01', 'Banska Bystrica', 197, 'SK'),
(3301, '02', 'Bratislava', 197, 'SK'),
(3302, '03', 'Kosice', 197, 'SK'),
(3303, '04', 'Nitra', 197, 'SK'),
(3304, '05', 'Presov', 197, 'SK'),
(3305, '06', 'Trencin', 197, 'SK'),
(3306, '07', 'Trnava', 197, 'SK'),
(3307, '08', 'Zilina', 197, 'SK'),
(3308, '01', 'Eastern', 198, 'SL'),
(3309, '02', 'Northern', 198, 'SL'),
(3310, '03', 'Southern', 198, 'SL'),
(3311, '04', 'Western Area', 198, 'SL'),
(3312, '01', 'Acquaviva', 199, 'SM'),
(3313, '02', 'Chiesanuova', 199, 'SM'),
(3314, '03', 'Domagnano', 199, 'SM'),
(3315, '04', 'Faetano', 199, 'SM'),
(3316, '05', 'Fiorentino', 199, 'SM'),
(3317, '06', 'Borgo Maggiore', 199, 'SM'),
(3318, '07', 'San Marino', 199, 'SM'),
(3319, '08', 'Monte Giardino', 199, 'SM'),
(3320, '09', 'Serravalle', 199, 'SM'),
(3321, '01', 'Dakar', 200, 'SN'),
(3322, '03', 'Diourbel', 200, 'SN'),
(3323, '05', 'Tambacounda', 200, 'SN'),
(3324, '07', 'Thies', 200, 'SN'),
(3325, '09', 'Fatick', 200, 'SN'),
(3326, '10', 'Kaolack', 200, 'SN'),
(3327, '11', 'Kolda', 200, 'SN'),
(3328, '12', 'Ziguinchor', 200, 'SN'),
(3329, '13', 'Louga', 200, 'SN'),
(3330, '14', 'Saint-Louis', 200, 'SN'),
(3331, '15', 'Matam', 200, 'SN'),
(3332, '01', 'Bakool', 201, 'SO'),
(3333, '02', 'Banaadir', 201, 'SO'),
(3334, '03', 'Bari', 201, 'SO'),
(3335, '04', 'Bay', 201, 'SO'),
(3336, '05', 'Galguduud', 201, 'SO'),
(3337, '06', 'Gedo', 201, 'SO'),
(3338, '07', 'Hiiraan', 201, 'SO'),
(3339, '08', 'Jubbada Dhexe', 201, 'SO'),
(3340, '09', 'Jubbada Hoose', 201, 'SO'),
(3341, '10', 'Mudug', 201, 'SO'),
(3342, '11', 'Nugaal', 201, 'SO'),
(3343, '12', 'Sanaag', 201, 'SO'),
(3344, '13', 'Shabeellaha Dhexe', 201, 'SO'),
(3345, '14', 'Shabeellaha Hoose', 201, 'SO'),
(3346, '16', 'Woqooyi Galbeed', 201, 'SO'),
(3347, '18', 'Nugaal', 201, 'SO'),
(3348, '19', 'Togdheer', 201, 'SO'),
(3349, '20', 'Woqooyi Galbeed', 201, 'SO'),
(3350, '21', 'Awdal', 201, 'SO'),
(3351, '22', 'Sool', 201, 'SO'),
(3352, '10', 'Brokopondo', 202, 'SR'),
(3353, '11', 'Commewijne', 202, 'SR'),
(3354, '12', 'Coronie', 202, 'SR'),
(3355, '13', 'Marowijne', 202, 'SR'),
(3356, '14', 'Nickerie', 202, 'SR'),
(3357, '15', 'Para', 202, 'SR'),
(3358, '16', 'Paramaribo', 202, 'SR'),
(3359, '17', 'Saramacca', 202, 'SR'),
(3360, '18', 'Sipaliwini', 202, 'SR'),
(3361, '19', 'Wanica', 202, 'SR'),
(3362, '01', 'Principe', 203, 'ST'),
(3363, '02', 'Sao Tome', 203, 'ST'),
(3364, '01', 'Ahuachapan', 204, 'SV'),
(3365, '02', 'Cabanas', 204, 'SV'),
(3366, '03', 'Chalatenango', 204, 'SV'),
(3367, '04', 'Cuscatlan', 204, 'SV'),
(3368, '05', 'La Libertad', 204, 'SV'),
(3369, '06', 'La Paz', 204, 'SV'),
(3370, '07', 'La Union', 204, 'SV'),
(3371, '08', 'Morazan', 204, 'SV'),
(3372, '09', 'San Miguel', 204, 'SV'),
(3373, '10', 'San Salvador', 204, 'SV'),
(3374, '11', 'Santa Ana', 204, 'SV'),
(3375, '12', 'San Vicente', 204, 'SV'),
(3376, '13', 'Sonsonate', 204, 'SV'),
(3377, '14', 'Usulutan', 204, 'SV'),
(3378, '01', 'Al Hasakah', 205, 'SY'),
(3379, '02', 'Al Ladhiqiyah', 205, 'SY'),
(3380, '03', 'Al Qunaytirah', 205, 'SY'),
(3381, '04', 'Ar Raqqah', 205, 'SY'),
(3382, '05', 'As Suwayda\'', 205, 'SY'),
(3383, '06', 'Dar', 205, 'SY'),
(3384, '07', 'Dayr az Zawr', 205, 'SY'),
(3385, '08', 'Rif Dimashq', 205, 'SY'),
(3386, '09', 'Halab', 205, 'SY'),
(3387, '10', 'Hamah', 205, 'SY'),
(3388, '11', 'Hims', 205, 'SY'),
(3389, '12', 'Idlib', 205, 'SY'),
(3390, '13', 'Dimashq', 205, 'SY'),
(3391, '14', 'Tartus', 205, 'SY'),
(3392, '01', 'Hhohho', 206, 'SZ'),
(3393, '02', 'Lubombo', 206, 'SZ'),
(3394, '03', 'Manzini', 206, 'SZ'),
(3395, '04', 'Shiselweni', 206, 'SZ'),
(3396, '05', 'Praslin', 206, 'SZ'),
(3397, '01', 'Batha', 208, 'TD'),
(3398, '02', 'Biltine', 208, 'TD'),
(3399, '03', 'Borkou-Ennedi-Tibesti', 208, 'TD'),
(3400, '04', 'Chari-Baguirmi', 208, 'TD'),
(3401, '05', 'Guera', 208, 'TD'),
(3402, '06', 'Kanem', 208, 'TD'),
(3403, '07', 'Lac', 208, 'TD'),
(3404, '08', 'Logone Occidental', 208, 'TD'),
(3405, '09', 'Logone Oriental', 208, 'TD'),
(3406, '10', 'Mayo-Kebbi', 208, 'TD'),
(3407, '11', 'Moyen-Chari', 208, 'TD'),
(3408, '12', 'Ouaddai', 208, 'TD'),
(3409, '13', 'Salamat', 208, 'TD'),
(3410, '14', 'Tandjile', 208, 'TD'),
(3411, '22', 'Centrale', 210, 'TG'),
(3412, '23', 'Kara', 210, 'TG'),
(3413, '24', 'Maritime', 210, 'TG'),
(3414, '25', 'Plateaux', 210, 'TG'),
(3415, '26', 'Savanes', 210, 'TG'),
(3416, '01', 'Mae Hong Son', 211, 'TH'),
(3417, '02', 'Chiang Mai', 211, 'TH'),
(3418, '03', 'Chiang Rai', 211, 'TH'),
(3419, '04', 'Nan', 211, 'TH'),
(3420, '05', 'Lamphun', 211, 'TH'),
(3421, '06', 'Lampang', 211, 'TH'),
(3422, '07', 'Phrae', 211, 'TH'),
(3423, '08', 'Tak', 211, 'TH'),
(3424, '09', 'Sukhothai', 211, 'TH'),
(3425, '10', 'Uttaradit', 211, 'TH'),
(3426, '11', 'Kamphaeng Phet', 211, 'TH'),
(3427, '12', 'Phitsanulok', 211, 'TH'),
(3428, '13', 'Phichit', 211, 'TH'),
(3429, '14', 'Phetchabun', 211, 'TH'),
(3430, '15', 'Uthai Thani', 211, 'TH'),
(3431, '16', 'Nakhon Sawan', 211, 'TH'),
(3432, '17', 'Nong Khai', 211, 'TH'),
(3433, '18', 'Loei', 211, 'TH'),
(3434, '20', 'Sakon Nakhon', 211, 'TH'),
(3435, '21', 'Nakhon Phanom', 211, 'TH'),
(3436, '22', 'Khon Kaen', 211, 'TH'),
(3437, '23', 'Kalasin', 211, 'TH'),
(3438, '24', 'Maha Sarakham', 211, 'TH'),
(3439, '25', 'Roi Et', 211, 'TH'),
(3440, '26', 'Chaiyaphum', 211, 'TH'),
(3441, '27', 'Nakhon Ratchasima', 211, 'TH'),
(3442, '28', 'Buriram', 211, 'TH'),
(3443, '29', 'Surin', 211, 'TH'),
(3444, '30', 'Sisaket', 211, 'TH'),
(3445, '31', 'Narathiwat', 211, 'TH'),
(3446, '32', 'Chai Nat', 211, 'TH'),
(3447, '33', 'Sing Buri', 211, 'TH'),
(3448, '34', 'Lop Buri', 211, 'TH'),
(3449, '35', 'Ang Thong', 211, 'TH'),
(3450, '36', 'Phra Nakhon Si Ayutthaya', 211, 'TH'),
(3451, '37', 'Saraburi', 211, 'TH'),
(3452, '38', 'Nonthaburi', 211, 'TH'),
(3453, '39', 'Pathum Thani', 211, 'TH'),
(3454, '40', 'Krung Thep', 211, 'TH'),
(3455, '41', 'Phayao', 211, 'TH'),
(3456, '42', 'Samut Prakan', 211, 'TH'),
(3457, '43', 'Nakhon Nayok', 211, 'TH'),
(3458, '44', 'Chachoengsao', 211, 'TH'),
(3459, '45', 'Prachin Buri', 211, 'TH'),
(3460, '46', 'Chon Buri', 211, 'TH'),
(3461, '47', 'Rayong', 211, 'TH'),
(3462, '48', 'Chanthaburi', 211, 'TH'),
(3463, '49', 'Trat', 211, 'TH'),
(3464, '50', 'Kanchanaburi', 211, 'TH'),
(3465, '51', 'Suphan Buri', 211, 'TH'),
(3466, '52', 'Ratchaburi', 211, 'TH'),
(3467, '53', 'Nakhon Pathom', 211, 'TH'),
(3468, '54', 'Samut Songkhram', 211, 'TH'),
(3469, '55', 'Samut Sakhon', 211, 'TH'),
(3470, '56', 'Phetchaburi', 211, 'TH'),
(3471, '57', 'Prachuap Khiri Khan', 211, 'TH'),
(3472, '58', 'Chumphon', 211, 'TH'),
(3473, '59', 'Ranong', 211, 'TH'),
(3474, '60', 'Surat Thani', 211, 'TH'),
(3475, '61', 'Phangnga', 211, 'TH'),
(3476, '62', 'Phuket', 211, 'TH'),
(3477, '63', 'Krabi', 211, 'TH'),
(3478, '64', 'Nakhon Si Thammarat', 211, 'TH'),
(3479, '65', 'Trang', 211, 'TH'),
(3480, '66', 'Phatthalung', 211, 'TH'),
(3481, '67', 'Satun', 211, 'TH'),
(3482, '68', 'Songkhla', 211, 'TH'),
(3483, '69', 'Pattani', 211, 'TH'),
(3484, '70', 'Yala', 211, 'TH'),
(3485, '71', 'Ubon Ratchathani', 211, 'TH'),
(3486, '72', 'Yasothon', 211, 'TH'),
(3487, '73', 'Nakhon Phanom', 211, 'TH'),
(3488, '75', 'Ubon Ratchathani', 211, 'TH'),
(3489, '76', 'Udon Thani', 211, 'TH'),
(3490, '77', 'Amnat Charoen', 211, 'TH'),
(3491, '78', 'Mukdahan', 211, 'TH'),
(3492, '79', 'Nong Bua Lamphu', 211, 'TH'),
(3493, '80', 'Sa Kaeo', 211, 'TH'),
(3494, '01', 'Kuhistoni Badakhshon', 212, 'TJ'),
(3495, '02', 'Khatlon', 212, 'TJ'),
(3496, '03', 'Sughd', 212, 'TJ'),
(3497, '01', 'Ahal', 214, 'TM'),
(3498, '02', 'Balkan', 214, 'TM'),
(3499, '03', 'Dashoguz', 214, 'TM'),
(3500, '04', 'Lebap', 214, 'TM'),
(3501, '05', 'Mary', 214, 'TM'),
(3502, '02', 'Kasserine', 215, 'TN'),
(3503, '03', 'Kairouan', 215, 'TN'),
(3504, '06', 'Jendouba', 215, 'TN'),
(3505, '10', 'Qafsah', 215, 'TN'),
(3506, '14', 'El Kef', 215, 'TN'),
(3507, '15', 'Al Mahdia', 215, 'TN'),
(3508, '16', 'Al Munastir', 215, 'TN'),
(3509, '17', 'Bajah', 215, 'TN'),
(3510, '18', 'Bizerte', 215, 'TN'),
(3511, '19', 'Nabeul', 215, 'TN'),
(3512, '22', 'Siliana', 215, 'TN'),
(3513, '23', 'Sousse', 215, 'TN'),
(3514, '27', 'Ben Arous', 215, 'TN'),
(3515, '28', 'Madanin', 215, 'TN'),
(3516, '29', 'Gabes', 215, 'TN'),
(3517, '31', 'Kebili', 215, 'TN'),
(3518, '32', 'Sfax', 215, 'TN'),
(3519, '33', 'Sidi Bou Zid', 215, 'TN'),
(3520, '34', 'Tataouine', 215, 'TN'),
(3521, '35', 'Tozeur', 215, 'TN'),
(3522, '36', 'Tunis', 215, 'TN'),
(3523, '37', 'Zaghouan', 215, 'TN'),
(3524, '38', 'Aiana', 215, 'TN'),
(3525, '39', 'Manouba', 215, 'TN'),
(3526, '01', 'Ha', 216, 'TO'),
(3527, '02', 'Tongatapu', 216, 'TO'),
(3528, '03', 'Vava', 216, 'TO'),
(3529, '02', 'Adiyaman', 218, 'TR'),
(3530, '03', 'Afyonkarahisar', 218, 'TR'),
(3531, '04', 'Agri', 218, 'TR'),
(3532, '05', 'Amasya', 218, 'TR'),
(3533, '07', 'Antalya', 218, 'TR'),
(3534, '08', 'Artvin', 218, 'TR'),
(3535, '09', 'Aydin', 218, 'TR'),
(3536, '10', 'Balikesir', 218, 'TR'),
(3537, '11', 'Bilecik', 218, 'TR'),
(3538, '12', 'Bingol', 218, 'TR'),
(3539, '13', 'Bitlis', 218, 'TR'),
(3540, '14', 'Bolu', 218, 'TR'),
(3541, '15', 'Burdur', 218, 'TR'),
(3542, '16', 'Bursa', 218, 'TR'),
(3543, '17', 'Canakkale', 218, 'TR'),
(3544, '19', 'Corum', 218, 'TR'),
(3545, '20', 'Denizli', 218, 'TR'),
(3546, '21', 'Diyarbakir', 218, 'TR'),
(3547, '22', 'Edirne', 218, 'TR'),
(3548, '23', 'Elazig', 218, 'TR'),
(3549, '24', 'Erzincan', 218, 'TR'),
(3550, '25', 'Erzurum', 218, 'TR'),
(3551, '26', 'Eskisehir', 218, 'TR'),
(3552, '28', 'Giresun', 218, 'TR'),
(3553, '31', 'Hatay', 218, 'TR'),
(3554, '32', 'Mersin', 218, 'TR'),
(3555, '33', 'Isparta', 218, 'TR'),
(3556, '34', 'Istanbul', 218, 'TR'),
(3557, '35', 'Izmir', 218, 'TR'),
(3558, '37', 'Kastamonu', 218, 'TR'),
(3559, '38', 'Kayseri', 218, 'TR'),
(3560, '39', 'Kirklareli', 218, 'TR'),
(3561, '40', 'Kirsehir', 218, 'TR'),
(3562, '41', 'Kocaeli', 218, 'TR'),
(3563, '43', 'Kutahya', 218, 'TR'),
(3564, '44', 'Malatya', 218, 'TR'),
(3565, '45', 'Manisa', 218, 'TR'),
(3566, '46', 'Kahramanmaras', 218, 'TR'),
(3567, '48', 'Mugla', 218, 'TR'),
(3568, '49', 'Mus', 218, 'TR'),
(3569, '50', 'Nevsehir', 218, 'TR'),
(3570, '52', 'Ordu', 218, 'TR'),
(3571, '53', 'Rize', 218, 'TR'),
(3572, '54', 'Sakarya', 218, 'TR'),
(3573, '55', 'Samsun', 218, 'TR'),
(3574, '57', 'Sinop', 218, 'TR'),
(3575, '58', 'Sivas', 218, 'TR'),
(3576, '59', 'Tekirdag', 218, 'TR'),
(3577, '60', 'Tokat', 218, 'TR'),
(3578, '61', 'Trabzon', 218, 'TR'),
(3579, '62', 'Tunceli', 218, 'TR'),
(3580, '63', 'Sanliurfa', 218, 'TR'),
(3581, '64', 'Usak', 218, 'TR'),
(3582, '65', 'Van', 218, 'TR'),
(3583, '66', 'Yozgat', 218, 'TR'),
(3584, '68', 'Ankara', 218, 'TR'),
(3585, '69', 'Gumushane', 218, 'TR'),
(3586, '70', 'Hakkari', 218, 'TR'),
(3587, '71', 'Konya', 218, 'TR'),
(3588, '72', 'Mardin', 218, 'TR'),
(3589, '73', 'Nigde', 218, 'TR'),
(3590, '74', 'Siirt', 218, 'TR'),
(3591, '75', 'Aksaray', 218, 'TR'),
(3592, '76', 'Batman', 218, 'TR'),
(3593, '77', 'Bayburt', 218, 'TR'),
(3594, '78', 'Karaman', 218, 'TR'),
(3595, '79', 'Kirikkale', 218, 'TR'),
(3596, '80', 'Sirnak', 218, 'TR'),
(3597, '81', 'Adana', 218, 'TR'),
(3598, '82', 'Cankiri', 218, 'TR'),
(3599, '83', 'Gaziantep', 218, 'TR'),
(3600, '84', 'Kars', 218, 'TR'),
(3601, '85', 'Zonguldak', 218, 'TR'),
(3602, '86', 'Ardahan', 218, 'TR'),
(3603, '87', 'Bartin', 218, 'TR'),
(3604, '88', 'Igdir', 218, 'TR'),
(3605, '89', 'Karabuk', 218, 'TR'),
(3606, '90', 'Kilis', 218, 'TR'),
(3607, '91', 'Osmaniye', 218, 'TR'),
(3608, '92', 'Yalova', 218, 'TR'),
(3609, '93', 'Duzce', 218, 'TR'),
(3610, '01', 'Arima', 219, 'TT'),
(3611, '02', 'Caroni', 219, 'TT'),
(3612, '03', 'Mayaro', 219, 'TT'),
(3613, '04', 'Nariva', 219, 'TT'),
(3614, '05', 'Port-of-Spain', 219, 'TT'),
(3615, '06', 'Saint Andrew', 219, 'TT'),
(3616, '07', 'Saint David', 219, 'TT'),
(3617, '08', 'Saint George', 219, 'TT'),
(3618, '09', 'Saint Patrick', 219, 'TT'),
(3619, '10', 'San Fernando', 219, 'TT'),
(3620, '11', 'Tobago', 219, 'TT'),
(3621, '12', 'Victoria', 219, 'TT'),
(3622, '01', 'Fu-chien', 221, 'TW'),
(3623, '02', 'Kao-hsiung', 221, 'TW'),
(3624, '03', 'T\'ai-pei', 221, 'TW'),
(3625, '04', 'T\'ai-wan', 221, 'TW'),
(3626, '02', 'Pwani', 222, 'TZ'),
(3627, '03', 'Dodoma', 222, 'TZ'),
(3628, '04', 'Iringa', 222, 'TZ'),
(3629, '05', 'Kigoma', 222, 'TZ'),
(3630, '06', 'Kilimanjaro', 222, 'TZ'),
(3631, '07', 'Lindi', 222, 'TZ'),
(3632, '08', 'Mara', 222, 'TZ'),
(3633, '09', 'Mbeya', 222, 'TZ'),
(3634, '10', 'Morogoro', 222, 'TZ'),
(3635, '11', 'Mtwara', 222, 'TZ'),
(3636, '12', 'Mwanza', 222, 'TZ'),
(3637, '13', 'Pemba North', 222, 'TZ'),
(3638, '14', 'Ruvuma', 222, 'TZ'),
(3639, '15', 'Shinyanga', 222, 'TZ'),
(3640, '16', 'Singida', 222, 'TZ'),
(3641, '17', 'Tabora', 222, 'TZ'),
(3642, '18', 'Tanga', 222, 'TZ'),
(3643, '19', 'Kagera', 222, 'TZ'),
(3644, '20', 'Pemba South', 222, 'TZ'),
(3645, '21', 'Zanzibar Central', 222, 'TZ'),
(3646, '22', 'Zanzibar North', 222, 'TZ'),
(3647, '23', 'Dar es Salaam', 222, 'TZ'),
(3648, '24', 'Rukwa', 222, 'TZ'),
(3649, '25', 'Zanzibar Urban', 222, 'TZ'),
(3650, '26', 'Arusha', 222, 'TZ'),
(3651, '27', 'Manyara', 222, 'TZ'),
(3652, '01', 'Cherkas\'ka Oblast\'', 223, 'UA'),
(3653, '02', 'Chernihivs\'ka Oblast\'', 223, 'UA'),
(3654, '03', 'Chernivets\'ka Oblast\'', 223, 'UA'),
(3655, '04', 'Dnipropetrovs\'ka Oblast\'', 223, 'UA'),
(3656, '05', 'Donets\'ka Oblast\'', 223, 'UA'),
(3657, '06', 'Ivano-Frankivs\'ka Oblast\'', 223, 'UA'),
(3658, '07', 'Kharkivs\'ka Oblast\'', 223, 'UA'),
(3659, '08', 'Khersons\'ka Oblast\'', 223, 'UA'),
(3660, '09', 'Khmel\'nyts\'ka Oblast\'', 223, 'UA'),
(3661, '10', 'Kirovohrads\'ka Oblast\'', 223, 'UA'),
(3662, '11', 'Krym', 223, 'UA'),
(3663, '12', 'Kyyiv', 223, 'UA'),
(3664, '13', 'Kyyivs\'ka Oblast\'', 223, 'UA'),
(3665, '14', 'Luhans\'ka Oblast\'', 223, 'UA'),
(3666, '15', 'L\'vivs\'ka Oblast\'', 223, 'UA'),
(3667, '16', 'Mykolayivs\'ka Oblast\'', 223, 'UA'),
(3668, '17', 'Odes\'ka Oblast\'', 223, 'UA'),
(3669, '18', 'Poltavs\'ka Oblast\'', 223, 'UA'),
(3670, '19', 'Rivnens\'ka Oblast\'', 223, 'UA'),
(3671, '20', 'Sevastopol\'', 223, 'UA'),
(3672, '21', 'Sums\'ka Oblast\'', 223, 'UA'),
(3673, '22', 'Ternopil\'s\'ka Oblast\'', 223, 'UA'),
(3674, '23', 'Vinnyts\'ka Oblast\'', 223, 'UA'),
(3675, '24', 'Volyns\'ka Oblast\'', 223, 'UA'),
(3676, '25', 'Zakarpats\'ka Oblast\'', 223, 'UA'),
(3677, '26', 'Zaporiz\'ka Oblast\'', 223, 'UA'),
(3678, '27', 'Zhytomyrs\'ka Oblast\'', 223, 'UA'),
(3679, '26', 'Apac', 224, 'UG'),
(3680, '28', 'Bundibugyo', 224, 'UG'),
(3681, '29', 'Bushenyi', 224, 'UG'),
(3682, '30', 'Gulu', 224, 'UG'),
(3683, '31', 'Hoima', 224, 'UG'),
(3684, '33', 'Jinja', 224, 'UG'),
(3685, '36', 'Kalangala', 224, 'UG'),
(3686, '37', 'Kampala', 224, 'UG'),
(3687, '38', 'Kamuli', 224, 'UG'),
(3688, '39', 'Kapchorwa', 224, 'UG'),
(3689, '40', 'Kasese', 224, 'UG'),
(3690, '41', 'Kibale', 224, 'UG'),
(3691, '42', 'Kiboga', 224, 'UG'),
(3692, '43', 'Kisoro', 224, 'UG'),
(3693, '45', 'Kotido', 224, 'UG'),
(3694, '46', 'Kumi', 224, 'UG'),
(3695, '47', 'Lira', 224, 'UG'),
(3696, '50', 'Masindi', 224, 'UG'),
(3697, '52', 'Mbarara', 224, 'UG'),
(3698, '56', 'Mubende', 224, 'UG'),
(3699, '58', 'Nebbi', 224, 'UG'),
(3700, '59', 'Ntungamo', 224, 'UG'),
(3701, '60', 'Pallisa', 224, 'UG'),
(3702, '61', 'Rakai', 224, 'UG'),
(3703, '65', 'Adjumani', 224, 'UG'),
(3704, '66', 'Bugiri', 224, 'UG'),
(3705, '67', 'Busia', 224, 'UG'),
(3706, '69', 'Katakwi', 224, 'UG'),
(3707, '70', 'Luwero', 224, 'UG'),
(3708, '71', 'Masaka', 224, 'UG'),
(3709, '72', 'Moyo', 224, 'UG'),
(3710, '73', 'Nakasongola', 224, 'UG'),
(3711, '74', 'Sembabule', 224, 'UG'),
(3712, '76', 'Tororo', 224, 'UG'),
(3713, '77', 'Arua', 224, 'UG'),
(3714, '78', 'Iganga', 224, 'UG'),
(3715, '79', 'Kabarole', 224, 'UG'),
(3716, '80', 'Kaberamaido', 224, 'UG'),
(3717, '81', 'Kamwenge', 224, 'UG'),
(3718, '82', 'Kanungu', 224, 'UG'),
(3719, '83', 'Kayunga', 224, 'UG'),
(3720, '84', 'Kitgum', 224, 'UG'),
(3721, '85', 'Kyenjojo', 224, 'UG'),
(3722, '86', 'Mayuge', 224, 'UG'),
(3723, '87', 'Mbale', 224, 'UG'),
(3724, '88', 'Moroto', 224, 'UG'),
(3725, '89', 'Mpigi', 224, 'UG'),
(3726, '90', 'Mukono', 224, 'UG'),
(3727, '91', 'Nakapiripirit', 224, 'UG'),
(3728, '92', 'Pader', 224, 'UG'),
(3729, '93', 'Rukungiri', 224, 'UG'),
(3730, '94', 'Sironko', 224, 'UG'),
(3731, '95', 'Soroti', 224, 'UG'),
(3732, '96', 'Wakiso', 224, 'UG'),
(3733, '97', 'Yumbe', 224, 'UG'),
(3734, 'AA', 'Armed Forces Americas', 226, 'US'),
(3735, 'AE', 'Armed Forces Europe, Middle East, & Canada', 226, 'US'),
(3736, 'AK', 'Alaska', 226, 'US'),
(3737, 'AL', 'Alabama', 226, 'US'),
(3738, 'AP', 'Armed Forces Pacific', 226, 'US'),
(3739, 'AR', 'Arkansas', 226, 'US'),
(3740, 'AS', 'American Samoa', 226, 'US'),
(3741, 'AZ', 'Arizona', 226, 'US'),
(3742, 'CA', 'California', 226, 'US'),
(3743, 'CO', 'Colorado', 226, 'US'),
(3744, 'CT', 'Connecticut', 226, 'US'),
(3745, 'DC', 'District of Columbia', 226, 'US'),
(3746, 'DE', 'Delaware', 226, 'US'),
(3747, 'FL', 'Florida', 226, 'US'),
(3748, 'FM', 'Federated States of Micronesia', 226, 'US'),
(3749, 'GA', 'Georgia', 226, 'US'),
(3750, 'GU', 'Guam', 226, 'US'),
(3751, 'HI', 'Hawaii', 226, 'US'),
(3752, 'IA', 'Iowa', 226, 'US'),
(3753, 'ID', 'Idaho', 226, 'US'),
(3754, 'IL', 'Illinois', 226, 'US'),
(3755, 'IN', 'Indiana', 226, 'US'),
(3756, 'KS', 'Kansas', 226, 'US'),
(3757, 'KY', 'Kentucky', 226, 'US'),
(3758, 'LA', 'Louisiana', 226, 'US'),
(3759, 'MA', 'Massachusetts', 226, 'US'),
(3760, 'MD', 'Maryland', 226, 'US'),
(3761, 'ME', 'Maine', 226, 'US'),
(3762, 'MH', 'Marshall Islands', 226, 'US'),
(3763, 'MI', 'Michigan', 226, 'US'),
(3764, 'MN', 'Minnesota', 226, 'US'),
(3765, 'MO', 'Missouri', 226, 'US'),
(3766, 'MP', 'Northern Mariana Islands', 226, 'US'),
(3767, 'MS', 'Mississippi', 226, 'US'),
(3768, 'MT', 'Montana', 226, 'US'),
(3769, 'NC', 'North Carolina', 226, 'US'),
(3770, 'ND', 'North Dakota', 226, 'US'),
(3771, 'NE', 'Nebraska', 226, 'US'),
(3772, 'NH', 'New Hampshire', 226, 'US'),
(3773, 'NJ', 'New Jersey', 226, 'US'),
(3774, 'NM', 'New Mexico', 226, 'US'),
(3775, 'NV', 'Nevada', 226, 'US'),
(3776, 'NY', 'New York', 226, 'US'),
(3777, 'OH', 'Ohio', 226, 'US'),
(3778, 'OK', 'Oklahoma', 226, 'US'),
(3779, 'OR', 'Oregon', 226, 'US'),
(3780, 'PA', 'Pennsylvania', 226, 'US'),
(3781, 'PR', 'Puerto Rico', 226, 'US'),
(3782, 'PW', 'Palau', 226, 'US'),
(3783, 'RI', 'Rhode Island', 226, 'US'),
(3784, 'SC', 'South Carolina', 226, 'US'),
(3785, 'SD', 'South Dakota', 226, 'US'),
(3786, 'TN', 'Tennessee', 226, 'US'),
(3787, 'TX', 'Texas', 226, 'US'),
(3788, 'UT', 'Utah', 226, 'US'),
(3789, 'VA', 'Virginia', 226, 'US'),
(3790, 'VI', 'Virgin Islands', 226, 'US'),
(3791, 'VT', 'Vermont', 226, 'US'),
(3792, 'WA', 'Washington', 226, 'US'),
(3793, 'WI', 'Wisconsin', 226, 'US'),
(3794, 'WV', 'West Virginia', 226, 'US'),
(3795, 'WY', 'Wyoming', 226, 'US'),
(3796, '01', 'Artigas', 227, 'UY'),
(3797, '02', 'Canelones', 227, 'UY'),
(3798, '03', 'Cerro Largo', 227, 'UY'),
(3799, '04', 'Colonia', 227, 'UY'),
(3800, '05', 'Durazno', 227, 'UY'),
(3801, '06', 'Flores', 227, 'UY'),
(3802, '07', 'Florida', 227, 'UY'),
(3803, '08', 'Lavalleja', 227, 'UY'),
(3804, '09', 'Maldonado', 227, 'UY'),
(3805, '10', 'Montevideo', 227, 'UY'),
(3806, '11', 'Paysandu', 227, 'UY'),
(3807, '12', 'Rio Negro', 227, 'UY'),
(3808, '13', 'Rivera', 227, 'UY'),
(3809, '14', 'Rocha', 227, 'UY'),
(3810, '15', 'Salto', 227, 'UY'),
(3811, '16', 'San Jose', 227, 'UY'),
(3812, '17', 'Soriano', 227, 'UY'),
(3813, '18', 'Tacuarembo', 227, 'UY'),
(3814, '19', 'Treinta y Tres', 227, 'UY'),
(3815, '01', 'Andijon', 228, 'UZ'),
(3816, '02', 'Bukhoro', 228, 'UZ'),
(3817, '03', 'Farghona', 228, 'UZ'),
(3818, '04', 'Jizzakh', 228, 'UZ'),
(3819, '05', 'Khorazm', 228, 'UZ'),
(3820, '06', 'Namangan', 228, 'UZ'),
(3821, '07', 'Nawoiy', 228, 'UZ'),
(3822, '08', 'Qashqadaryo', 228, 'UZ'),
(3823, '09', 'Qoraqalpoghiston', 228, 'UZ'),
(3824, '10', 'Samarqand', 228, 'UZ'),
(3825, '11', 'Sirdaryo', 228, 'UZ'),
(3826, '12', 'Surkhondaryo', 228, 'UZ'),
(3827, '13', 'Toshkent', 228, 'UZ'),
(3828, '14', 'Toshkent', 228, 'UZ'),
(3829, '01', 'Charlotte', 230, 'VC'),
(3830, '02', 'Saint Andrew', 230, 'VC'),
(3831, '03', 'Saint David', 230, 'VC'),
(3832, '04', 'Saint George', 230, 'VC'),
(3833, '05', 'Saint Patrick', 230, 'VC'),
(3834, '06', 'Grenadines', 230, 'VC'),
(3835, '01', 'Amazonas', 231, 'VE'),
(3836, '02', 'Anzoategui', 231, 'VE'),
(3837, '03', 'Apure', 231, 'VE'),
(3838, '04', 'Aragua', 231, 'VE'),
(3839, '05', 'Barinas', 231, 'VE'),
(3840, '06', 'Bolivar', 231, 'VE'),
(3841, '07', 'Carabobo', 231, 'VE'),
(3842, '08', 'Cojedes', 231, 'VE'),
(3843, '09', 'Delta Amacuro', 231, 'VE'),
(3844, '11', 'Falcon', 231, 'VE'),
(3845, '12', 'Guarico', 231, 'VE'),
(3846, '13', 'Lara', 231, 'VE'),
(3847, '14', 'Merida', 231, 'VE'),
(3848, '15', 'Miranda', 231, 'VE'),
(3849, '16', 'Monagas', 231, 'VE'),
(3850, '17', 'Nueva Esparta', 231, 'VE'),
(3851, '18', 'Portuguesa', 231, 'VE'),
(3852, '19', 'Sucre', 231, 'VE'),
(3853, '20', 'Tachira', 231, 'VE'),
(3854, '21', 'Trujillo', 231, 'VE'),
(3855, '22', 'Yaracuy', 231, 'VE'),
(3856, '23', 'Zulia', 231, 'VE'),
(3857, '24', 'Dependencias Federales', 231, 'VE'),
(3858, '25', 'Distrito Federal', 231, 'VE'),
(3859, '26', 'Vargas', 231, 'VE'),
(3860, '01', 'An Giang', 234, 'VN'),
(3861, '03', 'Ben Tre', 234, 'VN'),
(3862, '05', 'Cao Bang', 234, 'VN'),
(3863, '09', 'Dong Thap', 234, 'VN'),
(3864, '13', 'Hai Phong', 234, 'VN'),
(3865, '20', 'Ho Chi Minh', 234, 'VN'),
(3866, '21', 'Kien Giang', 234, 'VN'),
(3867, '23', 'Lam Dong', 234, 'VN'),
(3868, '24', 'Long An', 234, 'VN'),
(3869, '30', 'Quang Ninh', 234, 'VN'),
(3870, '32', 'Son La', 234, 'VN'),
(3871, '33', 'Tay Ninh', 234, 'VN'),
(3872, '34', 'Thanh Hoa', 234, 'VN'),
(3873, '35', 'Thai Binh', 234, 'VN'),
(3874, '37', 'Tien Giang', 234, 'VN'),
(3875, '39', 'Lang Son', 234, 'VN'),
(3876, '43', 'An Giang', 234, 'VN'),
(3877, '44', 'Dac Lac', 234, 'VN'),
(3878, '45', 'Dong Nai', 234, 'VN'),
(3879, '46', 'Dong Thap', 234, 'VN'),
(3880, '47', 'Kien Giang', 234, 'VN'),
(3881, '49', 'Song Be', 234, 'VN'),
(3882, '50', 'Vinh Phu', 234, 'VN'),
(3883, '51', 'Ha Noi', 234, 'VN'),
(3884, '52', 'Ho Chi Minh', 234, 'VN'),
(3885, '53', 'Ba Ria-Vung Tau', 234, 'VN'),
(3886, '54', 'Binh Dinh', 234, 'VN'),
(3887, '55', 'Binh Thuan', 234, 'VN'),
(3888, '58', 'Ha Giang', 234, 'VN'),
(3889, '59', 'Ha Tay', 234, 'VN'),
(3890, '60', 'Ha Tinh', 234, 'VN'),
(3891, '61', 'Hoa Binh', 234, 'VN'),
(3892, '62', 'Khanh Hoa', 234, 'VN'),
(3893, '63', 'Kon Tum', 234, 'VN'),
(3894, '64', 'Quang Tri', 234, 'VN'),
(3895, '65', 'Nam Ha', 234, 'VN'),
(3896, '66', 'Nghe An', 234, 'VN'),
(3897, '67', 'Ninh Binh', 234, 'VN'),
(3898, '68', 'Ninh Thuan', 234, 'VN'),
(3899, '69', 'Phu Yen', 234, 'VN'),
(3900, '70', 'Quang Binh', 234, 'VN'),
(3901, '71', 'Quang Ngai', 234, 'VN'),
(3902, '72', 'Quang Tri', 234, 'VN'),
(3903, '73', 'Soc Trang', 234, 'VN'),
(3904, '74', 'Thua Thien', 234, 'VN'),
(3905, '75', 'Tra Vinh', 234, 'VN'),
(3906, '76', 'Tuyen Quang', 234, 'VN'),
(3907, '77', 'Vinh Long', 234, 'VN'),
(3908, '78', 'Da Nang', 234, 'VN'),
(3909, '79', 'Hai Duong', 234, 'VN'),
(3910, '80', 'Ha Nam', 234, 'VN'),
(3911, '81', 'Hung Yen', 234, 'VN'),
(3912, '82', 'Nam Dinh', 234, 'VN'),
(3913, '83', 'Phu Tho', 234, 'VN'),
(3914, '84', 'Quang Nam', 234, 'VN'),
(3915, '85', 'Thai Nguyen', 234, 'VN'),
(3916, '86', 'Vinh Puc Province', 234, 'VN'),
(3917, '87', 'Can Tho', 234, 'VN'),
(3918, '88', 'Dak Lak', 234, 'VN'),
(3919, '89', 'Lai Chau', 234, 'VN'),
(3920, '90', 'Lao Cai', 234, 'VN'),
(3921, '91', 'Dak Nong', 234, 'VN'),
(3922, '92', 'Dien Bien', 234, 'VN'),
(3923, '93', 'Hau Giang', 234, 'VN'),
(3924, '05', 'Ambrym', 235, 'VU'),
(3925, '06', 'Aoba', 235, 'VU'),
(3926, '07', 'Torba', 235, 'VU'),
(3927, '08', 'Efate', 235, 'VU'),
(3928, '09', 'Epi', 235, 'VU'),
(3929, '10', 'Malakula', 235, 'VU'),
(3930, '11', 'Paama', 235, 'VU'),
(3931, '12', 'Pentecote', 235, 'VU'),
(3932, '13', 'Sanma', 235, 'VU'),
(3933, '14', 'Shepherd', 235, 'VU'),
(3934, '15', 'Tafea', 235, 'VU'),
(3935, '16', 'Malampa', 235, 'VU'),
(3936, '17', 'Penama', 235, 'VU'),
(3937, '18', 'Shefa', 235, 'VU'),
(3938, '02', 'Aiga-i-le-Tai', 237, 'WS'),
(3939, '03', 'Atua', 237, 'WS'),
(3940, '04', 'Fa', 237, 'WS'),
(3941, '05', 'Gaga', 237, 'WS'),
(3942, '06', 'Va', 237, 'WS'),
(3943, '07', 'Gagaifomauga', 237, 'WS'),
(3944, '08', 'Palauli', 237, 'WS'),
(3945, '09', 'Satupa', 237, 'WS'),
(3946, '10', 'Tuamasaga', 237, 'WS'),
(3947, '11', 'Vaisigano', 237, 'WS'),
(3948, '01', 'Abyan', 238, 'YE'),
(3949, '02', 'Adan', 238, 'YE'),
(3950, '03', 'Al Mahrah', 238, 'YE'),
(3951, '04', 'Hadramawt', 238, 'YE'),
(3952, '05', 'Shabwah', 238, 'YE'),
(3953, '06', 'Al Ghaydah', 238, 'YE'),
(3954, '08', 'Al Hudaydah', 238, 'YE'),
(3955, '10', 'Al Mahwit', 238, 'YE'),
(3956, '11', 'Dhamar', 238, 'YE'),
(3957, '14', 'Ma\'rib', 238, 'YE'),
(3958, '15', 'Sa', 238, 'YE'),
(3959, '16', 'San', 238, 'YE'),
(3960, '20', 'Al Bayda\'', 238, 'YE'),
(3961, '21', 'Al Jawf', 238, 'YE'),
(3962, '22', 'Hajjah', 238, 'YE'),
(3963, '23', 'Ibb', 238, 'YE'),
(3964, '24', 'Lahij', 238, 'YE'),
(3965, '25', 'Ta', 238, 'YE'),
(3966, '01', 'North-Western Province', 241, 'ZA'),
(3967, '02', 'KwaZulu-Natal', 241, 'ZA'),
(3968, '03', 'Free State', 241, 'ZA'),
(3969, '05', 'Eastern Cape', 241, 'ZA'),
(3970, '06', 'Gauteng', 241, 'ZA'),
(3971, '07', 'Mpumalanga', 241, 'ZA'),
(3972, '08', 'Northern Cape', 241, 'ZA'),
(3973, '09', 'Limpopo', 241, 'ZA'),
(3974, '10', 'North-West', 241, 'ZA'),
(3975, '11', 'Western Cape', 241, 'ZA'),
(3976, '01', 'Western', 242, 'ZM'),
(3977, '02', 'Central', 242, 'ZM'),
(3978, '03', 'Eastern', 242, 'ZM'),
(3979, '04', 'Luapula', 242, 'ZM'),
(3980, '05', 'Northern', 242, 'ZM'),
(3981, '06', 'North-Western', 242, 'ZM'),
(3982, '07', 'Southern', 242, 'ZM'),
(3983, '08', 'Copperbelt', 242, 'ZM'),
(3984, '09', 'Lusaka', 242, 'ZM'),
(3985, '01', 'Manicaland', 244, 'ZW'),
(3986, '02', 'Midlands', 244, 'ZW'),
(3987, '03', 'Mashonaland Central', 244, 'ZW'),
(3988, '04', 'Mashonaland East', 244, 'ZW'),
(3989, '05', 'Mashonaland West', 244, 'ZW'),
(3990, '06', 'Matabeleland North', 244, 'ZW'),
(3991, '07', 'Matabeleland South', 244, 'ZW'),
(3992, '08', 'Masvingo', 244, 'ZW'),
(3993, '09', 'Bulawayo', 244, 'ZW'),
(3994, '10', 'Harare', 244, 'ZW'),
(3995, '', '', 226, 'US'),
(3996, '', '', 113, 'KE'),
(3997, '', '', 120, 'KR'),
(3998, '', '', 185, 'RO'),
(3999, '', '', 78, 'GB'),
(4000, '', '', 23, 'BE'),
(4001, '', '', 112, 'JP');

-- --------------------------------------------------------

--
-- Table structure for table `offergroups`
--

CREATE TABLE `offergroups` (
  `OfferGroupID` smallint(5) UNSIGNED NOT NULL,
  `OfferGroup` varchar(100) DEFAULT NULL,
  `CreateDate` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `offergroups`
--

INSERT INTO `offergroups` (`OfferGroupID`, `OfferGroup`, `CreateDate`) VALUES
(1, 'Default', '2023-03-01 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `optimizationprofiles`
--

CREATE TABLE `optimizationprofiles` (
  `OptimizationProfileID` smallint(5) UNSIGNED NOT NULL,
  `OptimizationProfileName` varchar(100) NOT NULL,
  `DefaultProfile` tinyint(1) NOT NULL DEFAULT 0,
  `topt1ROI` varchar(10) DEFAULT NULL,
  `topt1PPV` varchar(10) DEFAULT NULL,
  `lopt2ROI` varchar(10) DEFAULT NULL,
  `lopt2PPV` varchar(10) DEFAULT NULL,
  `oopt3ROI` varchar(10) DEFAULT NULL,
  `topt4Views` varchar(10) DEFAULT NULL,
  `topt4Clicks` varchar(10) DEFAULT NULL,
  `topt5Views` varchar(10) DEFAULT NULL,
  `topt5Conversion` varchar(10) DEFAULT NULL,
  `topt6Views` varchar(10) DEFAULT NULL,
  `topt6ROI` varchar(10) DEFAULT NULL,
  `topt6PPV` varchar(10) DEFAULT NULL,
  `lopt7Views` varchar(10) DEFAULT NULL,
  `lopt7Clicks` varchar(10) DEFAULT NULL,
  `lopt8Views` varchar(10) DEFAULT NULL,
  `lopt8Conversion` varchar(10) DEFAULT NULL,
  `oopt9Views` varchar(10) DEFAULT NULL,
  `oopt9Conversion` varchar(10) DEFAULT NULL,
  `oopt10Visitors` varchar(10) DEFAULT NULL,
  `oopt10Conversion` varchar(10) DEFAULT NULL,
  `CreateDate` datetime NOT NULL,
  `ModifyDate` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `optimizationprofiles`
--

INSERT INTO `optimizationprofiles` (`OptimizationProfileID`, `OptimizationProfileName`, `DefaultProfile`, `topt1ROI`, `topt1PPV`, `lopt2ROI`, `lopt2PPV`, `oopt3ROI`, `topt4Views`, `topt4Clicks`, `topt5Views`, `topt5Conversion`, `topt6Views`, `topt6ROI`, `topt6PPV`, `lopt7Views`, `lopt7Clicks`, `lopt8Views`, `lopt8Conversion`, `oopt9Views`, `oopt9Conversion`, `oopt10Visitors`, `oopt10Conversion`, `CreateDate`, `ModifyDate`) VALUES
(1, 'Default Optimization Profile', 1, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '2020-01-30 00:00:00', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `optimizations`
--

CREATE TABLE `optimizations` (
  `OptimizeID` int(10) UNSIGNED NOT NULL,
  `OptimizeName` varchar(45) NOT NULL,
  `OptimizeValue` varchar(45) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `optimizations`
--

INSERT INTO `optimizations` (`OptimizeID`, `OptimizeName`, `OptimizeValue`) VALUES
(1, 'topt1ROI', ''),
(2, 'topt1PPV', ''),
(3, 'lopt2ROI', ''),
(4, 'lopt2PPV', ''),
(5, 'oopt3ROI', ''),
(6, 'topt4Views', ''),
(7, 'topt4Clicks', ''),
(8, 'topt5Views', ''),
(9, 'topt5Conversion', ''),
(10, 'topt6Views', ''),
(11, 'topt6ROI', ''),
(12, 'topt6PPV', ''),
(13, 'lopt7Views', ''),
(14, 'lopt7Clicks', ''),
(15, 'lopt8Views', ''),
(16, 'lopt8Conversion', ''),
(17, 'oopt9Views', ''),
(18, 'oopt9Conversion', ''),
(19, 'oopt10Visitors', ''),
(20, 'oopt10Conversion', '');

-- --------------------------------------------------------

--
-- Table structure for table `pagesettings`
--

CREATE TABLE `pagesettings` (
  `PageName` varchar(100) NOT NULL,
  `UserID` smallint(5) UNSIGNED NOT NULL DEFAULT 1,
  `WidgetSettings` text DEFAULT NULL,
  `WidgetPosition` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `parsingtemplates`
--

CREATE TABLE `parsingtemplates` (
  `ParsingTemplateID` smallint(5) UNSIGNED NOT NULL,
  `ReferrerName` varchar(191) NOT NULL,
  `Parameter` varchar(191) NOT NULL,
  `SiteCategoryID` smallint(6) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `parsingtemplates`
--

INSERT INTO `parsingtemplates` (`ParsingTemplateID`, `ReferrerName`, `Parameter`, `SiteCategoryID`) VALUES
(1, 'digg.com', 's', 3),
(2, 'twitter.com', 'q', 23),
(3, 'cnet.com', 'query', 22),
(4, 'autopartswarehouse.com', 'Ntt', 22),
(5, 'autozone.com', 'searchText', 22),
(6, 'slickdeals.net', 'search', 4),
(7, 'cheapuncle.com', 'k/', 4),
(8, 'fatwallet.com', 'query', 4),
(9, 'retailmenot.com', 'query', 4),
(10, 'wikipedia.org', 'wiki/', 20),
(11, 'earnmydegree.com', 'q', 7),
(12, 'billboard.com', 'search/', 8),
(13, 'download.cnet.com', 'query', 6),
(14, 'filehippo.com', 'q', 6),
(15, '4shared.com', '1/', 6),
(16, 'thepiratebay.org', 'search/', 6),
(17, 'filestube.com', 'q', 6),
(18, 'ign.com', 'query', 10),
(19, 'ezinearticles.com', 'q', 2),
(20, 'findarticles.com', 'qt', 2),
(21, 'ftc.gov', 'q', 20),
(22, 'answers.com', 'topic/', 17),
(23, 'associatedcontent.com', 'article/', 2),
(24, 'doityourself.com', 'qt', 5),
(25, 'ehow.com', 's', 5),
(26, 'howstuffworks.com', 'terms', 5),
(27, 'scribd.com', 'q', 20),
(28, 'aolhealth.com', 'q1', 11),
(29, 'drugs.com', 'searchterm', 11),
(30, 'healthboards.com', 'searchid', 11),
(31, 'healthgrades.com', 'q', 11),
(32, 'mayoclinic.com', 'search/', 11),
(33, 'webmd.com', 'query', 11),
(34, 'wellness.com', 'q,q_base', 11),
(35, 'wikihow.com', 'q', 20),
(36, 'about.com', 'terms', 20),
(37, 'servicemagic.com', 'query', 12),
(38, 'businessweek.com', 'searchTerm', 13),
(39, 'people.com', 'search', 13),
(40, 'cosmopolitan.com', 'search_term', 13),
(41, 'maxim.com', 'keywords', 13),
(42, 'motortrend.com', 'SearchText', 13),
(43, 'parenting.com', 'q', 13),
(44, 'pcmag.com', 'qry', 13),
(45, 'popularmechanics.com', 'search_term', 13),
(46, 'rollingstone.com', 'searchText', 13),
(47, 'askmen.com', 'q', 14),
(48, 'boxofficemojo.com', 'q', 8),
(49, 'fandango.com', 'q', 8),
(50, 'imdb.com', 'q', 8),
(51, 'moviefone.com', 'search/', 8),
(52, 'movieline.com', 'search', 8),
(53, 'rhapsody.com', 'query', 8),
(54, 'abcnews.go.com', 'searchtext', 15),
(55, 'mashable.com', 's', 15),
(56, 'foxsports.com', 'sp_q', 15),
(57, 'nytimes.com', 'query', 15),
(58, 'bbc.co.uk', 'q', 15),
(59, 'cnbc.com', 'keywords', 15),
(60, 'philly.com', 'q', 15),
(61, 'businessinsider.com', 'q', 15),
(62, 'cbsnews.com', 'query', 15),
(63, 'cnn.com', 'query', 15),
(64, 'consumerreports.org', 'query', 15),
(65, 'foxnews.com', 'q', 15),
(66, 'hollywoodreporter.com', 'keyword', 15),
(67, 'huffingtonpost.com', 'q', 15),
(68, 'msnbc.msn.com', 'q', 15),
(69, 'pcworld.com', 'qt', 15),
(70, 'reuters.com', 'blob', 15),
(71, 'usatoday.com', 'q', 15),
(72, 'usmagazine.com', 'q', 15),
(73, 'washingtonpost.com', 'st', 15),
(74, 'washingtontimes.com', 'q', 15),
(75, 'imageshack.us', 'q', 27),
(76, 'megavideo.com', 's', 27),
(77, 'fotolog.com', 'q', 27),
(78, 'tinypic.com', 'tag', 27),
(79, 'vimeo.com', 'videos/', 27),
(80, 'break.com', 'findvideo/', 27),
(81, 'dailymotion.com', 'search/', 27),
(82, 'flickr.com', 'q', 27),
(83, 'metacafe.com', 'topics/', 27),
(84, 'photobucket.com', 'images/', 27),
(85, 'veoh.com', 'videos/', 27),
(86, 'webshots.com', 'query', 27),
(87, 'bizrate.com', 'bizrate.com/', 16),
(88, 'epinions.com', 'search_string', 16),
(89, 'mysimon.com', 'find/', 16),
(90, 'nextag.com', 'nextag.com/', 16),
(91, 'pricegrabber.com', 'pricegrabber.com/', 16),
(92, 'shopzilla.com', '.shopzilla.com/', 16),
(93, 'techbargains.com', 'techbargains.com/', 16),
(94, 'dealtime.com', 'KW', 16),
(95, 'hud.gov', 'q', 18),
(96, 'allrecipes.com', 'WithTerm', 19),
(97, 'myrecipes.com', 'Ntt', 19),
(98, 'simplyrecipes.com', 'q', 19),
(99, 'bettycrocker.com', 'term', 19),
(100, 'cooking.com', 'Keywords', 19),
(101, 'cooks.com', 'q', 19),
(102, '.google.', 'q,as_q', 21),
(103, '.yahoo.', 'p,va', 21),
(104, 'bing.com', 'q', 21),
(105, 'ask.com', 'q', 21),
(106, 'aol.com', 'q', 21),
(107, 'comcast.net', 'q', 21),
(108, 'lycos.com', 'query', 21),
(109, 'comcast.com', 'q', 21),
(110, 'amazon.com', 'field-keywords', 22),
(111, 'ebay.com', '_nkw,_nkwusc', 22),
(112, 'barnesandnoble.com', 'WRD', 22),
(113, 'sephora.com', 'attr1', 22),
(114, 'ae.com', 'question', 22),
(115, 'babycenter.com', 'q', 22),
(116, 'basspro.com', 'hvarSearchString', 22),
(117, 'bedbathandbeyond.com', 'sstr', 22),
(118, 'bestbuy.com', 'st', 22),
(119, 'bhphotovideo.com', 'Ntt', 22),
(120, 'bidz.com', 'txt', 22),
(121, 'buy.com', 'qu', 22),
(122, 'childrensplace.com', 'Ntt', 22),
(123, 'cvs.com', 'addFacet', 22),
(124, 'drugstore.com', 'Ntt', 22),
(125, 'eastbay.com', 'keyword', 22),
(126, 'guitarcenter.com', 'src', 22),
(127, 'homedepot.com', 'keyword', 22),
(128, 'kaboodle.com', 'q', 22),
(129, 'kohls.com', 'searchTerm', 22),
(130, 'llbean.com', 'freeText', 22),
(131, 'lowes.com', 'Ntt', 22),
(132, 'musiciansfriend.com', 'q', 22),
(133, 'mysears.com', 'q', 22),
(134, 'overstock.com', 'keywords', 22),
(135, 'petsmart.com', 'kw', 22),
(136, 'sears.com', 'keyword', 22),
(137, 'shop.com', 'shop.com/', 22),
(138, 'shopping.com', 'KW', 22),
(139, 'sportsauthority.com', 'kw,origkw', 22),
(140, 'staples.com', 'searchKey', 22),
(141, 'target.com', 'keywords', 22),
(142, 'tigerdirect.com', 'keywords', 22),
(143, 'toysrus.com', 'kw,origkw', 22),
(144, 'vitacost.com', 'Ntt', 22),
(145, 'walgreens.com', 'Ntt', 22),
(146, 'walmart.com', 'search_query', 22),
(147, 'zappos.com', 'zappos.com/', 22),
(148, 'macys.com', 'Keyword', 22),
(149, 'jcpenney.com', 'SearchString', 22),
(150, 'mlb.com', 'query', 24),
(151, 'espn.go.com', 'espn.go.com/', 24),
(152, 'fifa.com', 'q', 24),
(153, 'nascar.com', 'text', 24),
(154, 'nba.com', 'text', 24),
(155, 'nfl.com', 'query', 24),
(156, 'aol.com', 'q', 9),
(157, 'bloomberg.com', 'q', 9),
(158, 'forbes.com', 'MT', 9),
(159, 'fool.com', 'q', 9),
(160, 'investors.com', 'Ntt', 9),
(161, 'marketwatch.com', 'q', 9),
(162, 'sharebuilder.com', 'QueryText', 9),
(163, 'tdameritrade.com', 'q,is', 9),
(164, 'stubhub.com', 'searchStr', 25),
(165, 'ticketmaster.com', 'q', 25),
(166, 'tickets.com', 'q', 25),
(167, 'ticketsnow.com', 'WHAT', 25),
(168, 'abc.go.com', 'search', 26),
(169, 'abcfamily.go.com', 'search', 26),
(170, 'animal.discovery.com', 'query', 26),
(171, 'disney.go.com', 'q', 26),
(172, 'planetgreen.discovery.com', 'query', 26),
(173, 'travelchannel.com', 'q', 26),
(174, 'usanetwork.com', 'q', 26),
(175, 'tlc.discovery.com', 'query', 26),
(176, 'aetv.com', 'keywords', 26),
(177, 'bravotv.com', 'query', 26),
(178, 'cartoonnetwork.com', 'keywords', 26),
(179, 'cbs.com', 'query', 26),
(180, 'comedycentral.com', 'term', 26),
(181, 'eonline.com', 'searchString', 26),
(182, 'fancast.com', 's', 26),
(183, 'foodnetwork.com', 'fnSearchString', 26),
(184, 'history.com', 'search-field', 26),
(185, 'hulu.com', 'query', 26),
(186, 'mtv.com', 'q', 26),
(187, 'mylifetime.com', 'q,as_q', 26),
(188, 'mystyle.com', 'searchKeyword', 26),
(189, 'nbc.com', 'searchString', 26),
(190, 'nick.com', 'term', 26),
(191, 'spike.com', 'query', 26),
(192, 'starz.com', 'starz/', 26),
(193, 'sundancechannel.com', 'words', 26),
(194, 'tbs.com', 'query', 26),
(195, 'thewb.com', 'q', 26),
(196, 'tnt.tv', 'query', 26),
(197, 'tvguide.com', 'keyword', 26),
(198, 'vh1.com', 'q', 26),
(199, 'youtube.com', 'search_query', 27),
(200, 'theknot.com', 'q', 28);

-- --------------------------------------------------------

--
-- Table structure for table `predeflps`
--

CREATE TABLE `predeflps` (
  `PredefLpID` mediumint(8) UNSIGNED NOT NULL,
  `LpName` varchar(500) NOT NULL,
  `LpUrl` varchar(500) NOT NULL,
  `Inactive` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `Notes` text NOT NULL,
  `GroupID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `DateAdded` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `predefoffers`
--

CREATE TABLE `predefoffers` (
  `PredefOfferID` mediumint(8) UNSIGNED NOT NULL,
  `OfferName` varchar(500) NOT NULL,
  `OfferUrl` varchar(500) NOT NULL,
  `Payout` double NOT NULL DEFAULT 0,
  `AffiliateSourceID` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `Inactive` tinyint(1) UNSIGNED NOT NULL DEFAULT 0,
  `Notes` text NOT NULL,
  `GroupID` mediumint(8) UNSIGNED NOT NULL DEFAULT 1,
  `DateAdded` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `redirectconditions`
--

CREATE TABLE `redirectconditions` (
  `RedirectConditionID` mediumint(8) UNSIGNED NOT NULL,
  `RedirectProfileID` mediumint(8) UNSIGNED NOT NULL,
  `OrderIndex` smallint(5) UNSIGNED NOT NULL,
  `RedirectTypeID` tinyint(3) UNSIGNED NOT NULL,
  `RedirectOperatorID` tinyint(3) UNSIGNED NOT NULL DEFAULT 1,
  `ValueCondition` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `redirectconditiontypes`
--

CREATE TABLE `redirectconditiontypes` (
  `RedirectConditionTypeID` tinyint(3) UNSIGNED NOT NULL,
  `Caption` varchar(100) NOT NULL,
  `LookupTable` varchar(100) DEFAULT NULL,
  `LookupIDField` varchar(100) DEFAULT NULL,
  `LookupValueField` varchar(100) DEFAULT NULL,
  `OrderIndex` tinyint(3) UNSIGNED NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `redirectconditiontypes`
--

INSERT INTO `redirectconditiontypes` (`RedirectConditionTypeID`, `Caption`, `LookupTable`, `LookupIDField`, `LookupValueField`, `OrderIndex`) VALUES
(1, 'Device Brand', 'smbrands', 'BrandID', 'BrandName', 45),
(2, 'Device Model', 'smdevicenames', 'DeviceNameID', 'DeviceModel', 50),
(3, 'Market Name', 'smdevicenames', 'DeviceNameID', 'MarketingName', 95),
(4, 'Device OS', 'smos', 'OperatingSystemID', 'OperatingSystem', 55),
(5, 'Pointing Method', 'smpointingmethod', 'PointingMethodID', 'PointingMethod', 115),
(6, 'Browser', 'smbrowsers', 'BrowserID', 'BrowserName', 25),
(7, 'Continent', 'mmcontinents', 'ContinentID', 'ContinentName', 5),
(8, 'Country', 'mmcountries', 'CountryID', 'CountryName', 10),
(9, 'State/Region', 'mmregions', 'RegionID', 'RegionName', 15),
(10, 'Screen Size', 'smdisplays', 'DisplaySizeID', 'concat(DisplayWidth, \'x\', DisplayHeight)', 135),
(11, 'Screen Resolution', 'smresolutions', 'ResolutionID', 'concat(ResolutionWidth, \'x\', ResolutionHeight)', 140),
(12, 'IFrames Support', 'smdevices', 'yesno', 'IframeSupport', 80),
(13, 'Embedded Video', 'smdevices', 'yesno', 'EmbeddedVideo', 65),
(14, 'Flash Support', 'smdevices', 'yesno', 'FlashSupport', 70),
(15, 'Receive SMS', 'smdevices', 'yesno', 'SmsSupport', 130),
(16, 'Click To Call', 'smdevices', 'yesno', 'ClickToCall', 30),
(17, 'Wifi Support', 'smdevices', 'yesno', 'WifiSupport', 150),
(18, 'MP4 Playback', 'smdevices', 'yesno', 'PlaybackMp4', 105),
(19, 'MOV Playback', 'smdevices', 'yesno', 'PlaybackMov', 100),
(20, 'FLV Playback', 'smdevices', 'yesno', 'PlaybackFlv', 75),
(21, 'Type of Device', 'smdevicetypes', 'DeviceTypeID', 'DeviceType', 145),
(22, 'Data Rate', 'smdatarate', 'DataRateID', 'DataRate', 40),
(23, 'Receive MMS', 'smdevices', 'yesno', 'MmsSupport', 125),
(24, 'PDF Support', 'smdevices', 'yesno', 'PdfSupport', 110),
(25, 'Dual Orientation', 'smdevices', 'yesno', 'DualOrientation', 60),
(26, 'QWERTY Keyboard', 'smdevices', 'yesno', 'QwertyKeyword', 120),
(27, 'JavaScript Support', 'smdevices', 'yesno', 'JavaScriptSupport', 90),
(28, 'Cookie Support', 'smdevices', 'yesno', 'CookieSupport', 35),
(29, 'City', 'mmcities', 'CityID', 'CityName', 20),
(30, 'ISP/Carrier', 'mmispscondition', 'IspID', 'IspName', 85),
(31, 'OS Version', 'smosversions', 'OperatingSystemVersionID', 'OperatingSystemVersion', 57),
(32, 'Browser Version', 'smbrowserversions', 'BrowserVersionID', 'BrowserVersion', 27),
(33, 'Target/Keyword', '', 'SubIdID', 'Keyword', 155),
(34, 'IP Address', '', '', '', 177),
(35, 'User Agent', '', '', '', 180),
(40, 'Ad Token', '', '', '', 176),
(41, 'Extra Token 1', '', '', '', 161),
(42, 'Extra Token 2', '', '', '', 162),
(43, 'Extra Token 3', '', '', '', 163),
(44, 'Extra Token 4', '', '', '', 164),
(45, 'Extra Token 5', '', '', '', 165),
(46, 'Extra Token 6', '', '', '', 166),
(47, 'Extra Token 7', '', '', '', 167),
(48, 'Extra Token 8', '', '', '', 168),
(49, 'Extra Token 9', '', '', '', 169),
(50, 'Extra Token 10', '', '', '', 170),
(51, 'European Union', 'mmcountries', 'yesno', 'IsEU', 22),
(52, 'Do Not Track Header', '', 'yesno', 'HTTP_DNT', 24),
(53, 'Is Bot Traffic', '', 'yesno', 'IsBot', 190),
(54, 'Bot Name', 'mmbots', 'BotID', 'BotName', 200),
(55, 'Bot Type', 'mmbottypes', 'BotTypeID', 'BotType', 210),
(56, 'Browser Language Header', 'smbrowserlanguages', 'BrowserLanguageCode', 'BrowserLanguage', 28),
(57, 'Extra Token 11', '', '', '', 171),
(58, 'Extra Token 12', '', '', '', 172),
(59, 'Extra Token 13', '', '', '', 173),
(60, 'Extra Token 14', '', '', '', 174),
(61, 'Extra Token 15', '', '', '', 175),
(62, 'Is Proxy Traffic', '', 'yesno', 'IsBot', 220),
(63, 'Proxy Type', '', '', '', 222);

-- --------------------------------------------------------

--
-- Table structure for table `redirectprofiles`
--

CREATE TABLE `redirectprofiles` (
  `RedirectProfileID` mediumint(8) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `RedirectProfileName` varchar(100) NOT NULL,
  `ProfileOperator` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `LandingPageID` mediumint(8) DEFAULT NULL,
  `OfferID` mediumint(8) UNSIGNED DEFAULT NULL,
  `PathID` mediumint(8) UNSIGNED DEFAULT NULL,
  `RedirectUrl` varchar(500) NOT NULL DEFAULT '',
  `Active` tinyint(1) UNSIGNED NOT NULL DEFAULT 1,
  `CreateDate` datetime NOT NULL,
  `ModifyDate` datetime DEFAULT NULL,
  `RedirectTypeID` tinyint(3) UNSIGNED DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `redirectprofilestypes`
--

CREATE TABLE `redirectprofilestypes` (
  `RedirectTypeID` tinyint(3) UNSIGNED NOT NULL,
  `RedirectTypeName` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `redirectprofilestypes`
--

INSERT INTO `redirectprofilestypes` (`RedirectTypeID`, `RedirectTypeName`) VALUES
(1, 'LP'),
(2, 'Offer'),
(3, 'LP and Offer'),
(4, 'URL'),
(5, 'Path');

-- --------------------------------------------------------

--
-- Table structure for table `referrerdomains`
--

CREATE TABLE `referrerdomains` (
  `ReferrerDomainID` int(10) UNSIGNED NOT NULL,
  `ReferrerDomain` varchar(100) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `referrerdomains`
--

INSERT INTO `referrerdomains` (`ReferrerDomainID`, `ReferrerDomain`) VALUES
(1, '');

-- --------------------------------------------------------

--
-- Table structure for table `referrers`
--

CREATE TABLE `referrers` (
  `ReferrerID` int(10) UNSIGNED NOT NULL,
  `Referrer` varchar(191) NOT NULL DEFAULT '',
  `ReferrerDomainID` int(10) UNSIGNED NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `referrers`
--

INSERT INTO `referrers` (`ReferrerID`, `Referrer`, `ReferrerDomainID`) VALUES
(1, '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `reportdetailscampaign`
--

CREATE TABLE `reportdetailscampaign` (
  `ReportDetailID` mediumint(8) UNSIGNED NOT NULL,
  `ReportID` mediumint(8) UNSIGNED NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `Views` int(11) NOT NULL DEFAULT 0,
  `Clicks` int(10) UNSIGNED NOT NULL DEFAULT 0,
  `CTR` double NOT NULL DEFAULT 0,
  `Cost` double NOT NULL DEFAULT 0,
  `Revenue` double NOT NULL DEFAULT 0,
  `EPV` double NOT NULL DEFAULT 0,
  `PPV` double NOT NULL DEFAULT 0,
  `Profit` double NOT NULL DEFAULT 0,
  `ROI` double NOT NULL DEFAULT 0,
  `Conversion` int(11) NOT NULL DEFAULT 0,
  `CR` double NOT NULL DEFAULT 0,
  `CPA` double NOT NULL DEFAULT 0,
  `Sent` int(11) NOT NULL DEFAULT 0,
  `EPS` double NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `reportdetailsgroup`
--

CREATE TABLE `reportdetailsgroup` (
  `ReportDetailID` mediumint(8) UNSIGNED NOT NULL,
  `ReportID` mediumint(8) UNSIGNED NOT NULL,
  `SubIdID` int(10) UNSIGNED NOT NULL,
  `Views` int(10) UNSIGNED NOT NULL,
  `Cost` double NOT NULL,
  `CPV` double DEFAULT NULL,
  `Clicks` int(11) NOT NULL DEFAULT 0,
  `CTR` double NOT NULL DEFAULT 0,
  `CPC` double NOT NULL DEFAULT 0,
  `Conversion` int(11) NOT NULL DEFAULT 0,
  `CR` double NOT NULL DEFAULT 0,
  `CPA` double NOT NULL DEFAULT 0,
  `Revenue` double NOT NULL DEFAULT 0,
  `EPV` double DEFAULT 0,
  `PPV` double DEFAULT 0,
  `eCPM` double NOT NULL,
  `Profit` double NOT NULL,
  `ROI` double NOT NULL DEFAULT 0,
  `Engages` int(11) NOT NULL DEFAULT 0,
  `EngageRate` double NOT NULL DEFAULT 0,
  `Sent` int(11) NOT NULL DEFAULT 0,
  `EPS` double NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `reports`
--

CREATE TABLE `reports` (
  `ReportID` mediumint(8) UNSIGNED NOT NULL,
  `ReportName` varchar(100) NOT NULL,
  `CampaignID` mediumint(8) UNSIGNED NOT NULL,
  `DateAdded` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `reporttypes`
--

CREATE TABLE `reporttypes` (
  `ReportTypeID` tinyint(3) UNSIGNED NOT NULL,
  `ReportTypeName` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `reporttypes`
--

INSERT INTO `reporttypes` (`ReportTypeID`, `ReportTypeName`) VALUES
(1, 'Reports Target'),
(2, 'Reports Landing'),
(3, 'Reports Offer'),
(4, 'Stats Target'),
(5, 'Stats Landing'),
(6, 'Stats Offer'),
(7, 'Trends Time'),
(8, 'Trends Day of Week'),
(9, 'Reports Campaign'),
(10, 'Stats Campaign'),
(12, 'Stats Thank You'),
(13, 'Trends Days'),
(14, 'Visitor Stats'),
(15, 'Campaigns'),
(16, 'Ad Performance'),
(17, 'Conversions List'),
(18, 'Trends Heatmap'),
(19, 'GEO Stats'),
(20, 'GEO Details'),
(21, 'Blocked Traffic Stats'),
(22, 'Performance Geo Stats'),
(23, 'Performance Geo Details'),
(24, 'Subscribers List'),
(25, 'Visitors Lookup');

-- --------------------------------------------------------

--
-- Table structure for table `sitecategories`
--

CREATE TABLE `sitecategories` (
  `SiteCategoryID` smallint(5) UNSIGNED NOT NULL,
  `SiteCategory` varchar(100) NOT NULL,
  `CreateDate` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `sitecategories`
--

INSERT INTO `sitecategories` (`SiteCategoryID`, `SiteCategory`, `CreateDate`) VALUES
(1, 'Other', '2020-01-30 00:00:00'),
(2, 'Article Directory', '2020-01-30 00:00:00'),
(3, 'Bookmarking', '2020-01-30 00:00:00'),
(4, 'Coupons', '2020-01-30 00:00:00'),
(5, 'DIY', '2020-01-30 00:00:00'),
(6, 'Downloads & Sharing', '2020-01-30 00:00:00'),
(7, 'Education', '2020-01-30 00:00:00'),
(8, 'Entertainment', '2020-01-30 00:00:00'),
(9, 'Finance', '2020-01-30 00:00:00'),
(10, 'Gaming', '2020-01-30 00:00:00'),
(11, 'Health', '2020-01-30 00:00:00'),
(12, 'Local', '2020-01-30 00:00:00'),
(13, 'Magazine', '2020-01-30 00:00:00'),
(14, 'Mens', '2020-01-30 00:00:00'),
(15, 'News', '2020-01-30 00:00:00'),
(16, 'Price Search', '2020-01-30 00:00:00'),
(17, 'Q & A ', '2020-01-30 00:00:00'),
(18, 'Real Estate', '2020-01-30 00:00:00'),
(19, 'Recipes', '2020-01-30 00:00:00'),
(20, 'Reference', '2020-01-30 00:00:00'),
(21, 'Search Engine', '2020-01-30 00:00:00'),
(22, 'Shopping', '2020-01-30 00:00:00'),
(23, 'Social', '2020-01-30 00:00:00'),
(24, 'Sports', '2020-01-30 00:00:00'),
(25, 'Tickets', '2020-01-30 00:00:00'),
(26, 'TV', '2020-01-30 00:00:00'),
(27, 'Video / Media', '2020-01-30 00:00:00'),
(28, 'Wedding', '2020-01-30 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `smbrands`
--

CREATE TABLE `smbrands` (
  `BrandID` smallint(5) UNSIGNED NOT NULL,
  `BrandName` varchar(191) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `smbrands`
--

INSERT INTO `smbrands` (`BrandID`, `BrandName`) VALUES
(1, ''),
(137, '2 Degrees'),
(166, '35Phone'),
(254, 'Access'),
(24, 'Acer'),
(272, 'AddThis'),
(221, 'Advan'),
(605, 'AEG'),
(285, 'Ahong'),
(435, 'AI'),
(290, 'Aiko'),
(161, 'Ainol'),
(291, 'Airis'),
(286, 'Airness'),
(2, 'Alcatel'),
(222, 'AllWinner'),
(341, 'AlphaCell Wireless'),
(14, 'Amazon'),
(94, 'Amlogic'),
(198, 'AMOI'),
(580, 'Ampe'),
(69, 'Android'),
(293, 'AnexTek'),
(607, 'Anonymouse'),
(51, 'AOC'),
(132, 'Aole'),
(43, 'Apanda'),
(8, 'Apple'),
(284, 'Arcelik'),
(17, 'Archos'),
(18, 'Arnova'),
(287, 'Asmobile'),
(44, 'Asus'),
(288, 'Audiovox'),
(289, 'AVG'),
(296, 'Avvio'),
(294, 'Azumi'),
(340, 'B-Mobile'),
(54, 'Barnes and Noble'),
(136, 'BASE'),
(348, 'BayMobile'),
(190, 'BBK'),
(299, 'Becker'),
(481, 'Beeline'),
(300, 'Beetel'),
(297, 'BEKO'),
(301, 'Bellwave'),
(256, 'BenQ'),
(257, 'BenQ-Siemens'),
(200, 'Best Buy International'),
(274, 'Bing'),
(302, 'Bird'),
(253, 'BlackBerry'),
(303, 'Bleu'),
(323, 'Blue Coat'),
(93, 'Bluestar'),
(214, 'Boxchip'),
(483, 'BP'),
(170, 'BQ'),
(295, 'Brilliantel Mobile Communications'),
(581, 'Caesar'),
(191, 'Camangi'),
(311, 'Capitel'),
(84, 'Carrefour'),
(82, 'Casio'),
(308, 'CDM'),
(309, 'CECT'),
(129, 'Celkon'),
(307, 'Cellon'),
(555, 'ChangJiang'),
(251, 'CheckCom'),
(38, 'Cheer'),
(23, 'Chunghwa'),
(260, 'Cingular'),
(81, 'Ciphone'),
(366, 'Cking'),
(310, 'Claro'),
(50, 'Coby'),
(34, 'Commtiva'),
(312, 'Compal'),
(77, 'Coolpad'),
(313, 'CoralWeb'),
(139, 'Cowon'),
(201, 'Craig'),
(67, 'Creative'),
(314, 'Cricket'),
(83, 'CSL'),
(492, 'Cube'),
(595, 'Cubot'),
(212, 'Curtis'),
(19, 'Cydle'),
(332, 'Dai Telecom'),
(317, 'Dallab'),
(556, 'Danew'),
(400, 'Danger'),
(128, 'DaPeng'),
(316, 'Daxian'),
(318, 'DBTEL'),
(319, 'DC'),
(35, 'Dell'),
(329, 'Desktop'),
(320, 'Dicam'),
(573, 'Dicra'),
(235, 'DIFRNCE'),
(179, 'DiGix'),
(195, 'Diyomate'),
(333, 'Dmobo'),
(159, 'DoCoMo'),
(31, 'Dopod'),
(334, 'Doris'),
(570, 'Double Power'),
(95, 'Dropad'),
(557, 'E-tel'),
(206, 'Easypix'),
(336, 'EDL'),
(125, 'Eken'),
(467, 'Elite'),
(242, 'Elocity'),
(202, 'Elson'),
(117, 'Ematic'),
(443, 'Emblaze'),
(204, 'Emerson'),
(342, 'Emgeton'),
(397, 'Emobile'),
(119, 'Enspert'),
(358, 'Enteos'),
(118, 'Entourage'),
(88, 'Epad'),
(401, 'Epiphany'),
(25, 'Era'),
(107, 'Ereneben'),
(255, 'Ericsson'),
(338, 'Ericy'),
(394, 'ETEN'),
(468, 'eTouch'),
(558, 'Evertek'),
(339, 'EZIO'),
(282, 'Ezze'),
(469, 'FaceBook'),
(143, 'Faktor Zwei'),
(176, 'FCT'),
(579, 'Feiteng'),
(344, 'Fitel'),
(141, 'Fly'),
(47, 'Flying'),
(232, 'Flytouch'),
(223, 'Freelander'),
(216, 'Fuhu'),
(140, 'Fujitsu'),
(62, 'Fujitsu Toshiba'),
(345, 'G-Fone'),
(36, 'Garmin-Asus'),
(597, 'Gateway'),
(146, 'GeeksPhone'),
(87, 'General Mobile'),
(6, 'Generic'),
(324, 'generic content fetcher'),
(327, 'generic web browser'),
(331, 'Generic Windows'),
(207, 'Genesis Tab'),
(325, 'GHT'),
(33, 'Gigabyte'),
(92, 'Ginovo'),
(144, 'Gionee'),
(26, 'GM'),
(145, 'GO Live'),
(584, 'GOCLEVER'),
(600, 'Good'),
(27, 'Google'),
(343, 'Gradiente'),
(349, 'Grameenphone'),
(259, 'Grundig'),
(346, 'Haier'),
(233, 'Haipad'),
(239, 'Haipai'),
(559, 'Hamlet'),
(104, 'Hannspree'),
(226, 'HCL'),
(352, 'HD'),
(130, 'HDC'),
(353, 'HEDY'),
(354, 'Hei'),
(409, 'Helio'),
(109, 'Hero'),
(230, 'HiPhone'),
(240, 'Hisense'),
(357, 'Hitachi'),
(217, 'HKC'),
(147, 'HP'),
(21, 'HTC'),
(356, 'HTIL'),
(596, 'HTM'),
(250, 'Huawei'),
(355, 'Hummer'),
(241, 'Hunan Dacheng'),
(89, 'HW'),
(196, 'Hyundai'),
(261, 'i-mate'),
(70, 'i-mobile'),
(360, 'IAC OKWAP'),
(133, 'iBall'),
(485, 'Idea'),
(582, 'iDeal'),
(471, 'iKoMo'),
(361, 'IM'),
(188, 'iMiTO'),
(364, 'Infineon'),
(453, 'InfoSonics'),
(359, 'Innostream'),
(90, 'INQ Mobile'),
(495, 'Intel'),
(150, 'Intex'),
(599, 'iOcean'),
(362, 'Itelco'),
(487, 'Itoos'),
(554, 'iView'),
(363, 'IXI'),
(392, 'Japan Radio Company'),
(365, 'Java'),
(482, 'Jexaa'),
(123, 'JexTab'),
(562, 'Jiayu'),
(283, 'K-Touch'),
(209, 'Kalley'),
(224, 'Karbon'),
(91, 'Karbonn'),
(350, 'KCM'),
(103, 'KDDI'),
(486, 'KDI'),
(158, 'Keen High'),
(473, 'Kejian'),
(20, 'Kendo'),
(262, 'KGT'),
(586, 'Kingshop'),
(367, 'Kisen'),
(369, 'Klondike'),
(210, 'KN Mobile'),
(490, 'Kobalt'),
(151, 'Kobo'),
(152, 'Kogan'),
(315, 'Konka'),
(279, 'konqueror'),
(368, 'Kozi'),
(153, 'KPT'),
(86, 'KT Tech'),
(563, 'KUNO'),
(564, 'Kurio'),
(211, 'Kurio World'),
(37, 'Kyocera'),
(243, 'Lanix'),
(154, 'Lava'),
(577, 'Lazer'),
(306, 'LCT'),
(193, 'Le Pan'),
(148, 'Leader'),
(370, 'Lemon'),
(565, 'Lenco'),
(30, 'Lenovo'),
(371, 'Lexibook'),
(4, 'LG'),
(15, 'LGUPlus'),
(192, 'Lifetab'),
(16, 'Limited Label'),
(304, 'Lobster'),
(592, 'Logicom'),
(49, 'LogicPD'),
(11, 'Logitech'),
(372, 'Longcos'),
(373, 'LT'),
(387, 'LXE'),
(375, 'Lynx'),
(378, 'M3 Gate'),
(379, 'M4TEL'),
(85, 'Maipad'),
(572, 'Majestic'),
(186, 'Malata'),
(493, 'Marvell'),
(601, 'Mastone'),
(382, 'MAUI-based Generic'),
(389, 'Maxon'),
(386, 'Maxx'),
(484, 'Maxx Mobile'),
(566, 'Maylong'),
(213, 'Maylong Mobility'),
(390, 'McAfee'),
(571, 'McPad'),
(157, 'Mediacom'),
(567, 'MediaTek'),
(194, 'Medion'),
(121, 'Meizu'),
(52, 'Micromax'),
(246, 'Microsoft'),
(472, 'Mio'),
(434, 'Miracle'),
(384, 'Mitac'),
(258, 'Mitsubishi'),
(377, 'Mobell'),
(396, 'Mobile Wireless Group'),
(588, 'Mobiltab'),
(337, 'MOBISTEL'),
(488, 'Mobo'),
(374, 'ModeLabs'),
(385, 'Modottel'),
(391, 'Modu'),
(383, 'MOMO Design'),
(474, 'Morange'),
(28, 'Motorola'),
(276, 'Mozilla'),
(96, 'Mpman'),
(587, 'MT'),
(97, 'MTS'),
(98, 'Muchtel'),
(57, 'Multipad'),
(189, 'myPad'),
(403, 'MyPhone'),
(560, 'Nam-Phone'),
(99, 'NEC'),
(406, 'Nem'),
(399, 'Neonode'),
(322, 'Netfront'),
(561, 'Nevitel'),
(407, 'Newgen'),
(155, 'Newman'),
(408, 'Nexian'),
(29, 'Nextbook'),
(160, 'NGM'),
(208, 'Ninetology'),
(263, 'Nintendo'),
(3, 'Nokia'),
(405, 'Norton'),
(273, 'Novarra'),
(55, 'NTT'),
(598, 'NVIDIA'),
(162, 'NVSBL'),
(270, 'O2'),
(100, 'Odys'),
(411, 'Olive'),
(101, 'Olivetti'),
(111, 'Onda'),
(585, 'Opal'),
(277, 'Openwave'),
(245, 'Opera'),
(278, 'Opera Software'),
(116, 'Oppo'),
(412, 'Optimay'),
(56, 'Orange'),
(46, 'Origin'),
(112, 'Ouku'),
(594, 'Packard Bell'),
(269, 'Palm'),
(13, 'Panasonic'),
(413, 'Panda'),
(72, 'Pandigital'),
(60, 'Pantech'),
(131, 'PCD'),
(238, 'Pearl'),
(229, 'Pegatron'),
(220, 'PendoPad'),
(142, 'Phicomm'),
(168, 'Philips'),
(381, 'PhoneOne'),
(135, 'Pioneer'),
(236, 'PiPO'),
(414, 'Pirelli-Arcor'),
(165, 'PocketBook'),
(178, 'Point of View'),
(328, 'Polaris'),
(163, 'Polaroid'),
(415, 'Polytron'),
(416, 'Poseidon'),
(417, 'Postcom'),
(219, 'Prestigio'),
(244, 'Prixton'),
(590, 'PROSCAN'),
(418, 'Psion'),
(419, 'QCI'),
(127, 'QMobile'),
(267, 'Qtek'),
(248, 'Qualcomm'),
(124, 'QuanZhi'),
(420, 'Raks'),
(167, 'Ramos'),
(59, 'Red Bull Mobile'),
(424, 'Reporo'),
(227, 'Rich & HL'),
(164, 'RIM'),
(58, 'Ritmix'),
(271, 'Robot'),
(71, 'Rockchip'),
(425, 'Roku'),
(421, 'Ron'),
(426, 'Rover'),
(427, 'RoverPC'),
(422, 'RT'),
(265, 'Sagem'),
(470, 'SAMART'),
(7, 'Samsung'),
(589, 'Sanei'),
(268, 'Sanyo'),
(68, 'Sapo'),
(280, 'Sendo'),
(606, 'SENSEIT'),
(275, 'SEOmoz'),
(134, 'SFR'),
(9, 'Sharp'),
(215, 'Shenchuang'),
(252, 'Siemens'),
(431, 'SimplePie'),
(105, 'Simvalley'),
(102, 'SK Telesys'),
(149, 'Sky'),
(428, 'Skybee'),
(326, 'Skyfire'),
(169, 'Skypad'),
(429, 'Skyspring'),
(171, 'Skytex'),
(73, 'Skyworth'),
(458, 'SlobTrot Software'),
(32, 'Smart PAD'),
(203, 'Smartfren'),
(61, 'SmartQ'),
(456, 'SmartTrust'),
(432, 'Smile'),
(76, 'Softbank'),
(225, 'SoftwinerEvb'),
(264, 'Sonim'),
(12, 'Sony'),
(185, 'Sony Ericsson'),
(5, 'SonyEricsson'),
(430, 'SPC'),
(187, 'Spice'),
(603, 'SPRD'),
(205, 'Sprint'),
(574, 'SSI'),
(78, 'Star'),
(568, 'Start'),
(569, 'Stonex'),
(172, 'Storage Options'),
(80, 'Sunon'),
(433, 'Sunrise'),
(120, 'Superpad'),
(591, 'Supersonic'),
(106, 'Sylvania'),
(22, 'T-Mobile'),
(602, 'T-Smart'),
(63, 'Taipower'),
(39, 'Taiwan Mobile'),
(110, 'TCL'),
(439, 'Techfaith'),
(126, 'Teclast'),
(489, 'Tecmobile'),
(423, 'Tecno'),
(436, 'Tel.Me.'),
(292, 'Telecom Italia'),
(180, 'Telenor'),
(347, 'Telit'),
(173, 'Telstra'),
(583, 'Tengda'),
(181, 'ThL'),
(437, 'Tianyu'),
(496, 'TIM'),
(441, 'Tinno'),
(440, 'TiPhone'),
(553, 'Titan'),
(74, 'TMN'),
(234, 'Tomtec'),
(442, 'Toplux'),
(48, 'Toshiba'),
(330, 'Tranxcode'),
(231, 'TrekStor'),
(593, 'Trevi'),
(64, 'Tsinghua Tongfang'),
(351, 'TTPCom'),
(65, 'Turkcell'),
(460, 'tvCompass'),
(174, 'TWM'),
(438, 'TX'),
(447, 'Ubiquam'),
(321, 'UCWEB'),
(491, 'UGood'),
(444, 'UKING'),
(113, 'Ultratab'),
(79, 'Umeox'),
(476, 'Unimax'),
(445, 'Uniscope'),
(446, 'Unistar'),
(182, 'Urbetter'),
(388, 'Uriver'),
(281, 'Usha Lexus'),
(448, 'Utec'),
(305, 'UTStarcom'),
(450, 'Vacom'),
(108, 'Velocity Micro'),
(398, 'Velocity Mobile'),
(451, 'Venera'),
(45, 'Verizon'),
(228, 'Versus'),
(249, 'Vertu'),
(452, 'VeryKool'),
(335, 'VERZIOWORLD'),
(40, 'Vibo'),
(449, 'Videocon'),
(183, 'Viettel'),
(114, 'ViewSonic'),
(475, 'Virgin Mobile'),
(266, 'Vitelcom'),
(497, 'Vivo'),
(10, 'Vizio'),
(376, 'VK Mobile'),
(115, 'Vodafone'),
(298, 'Voxtel'),
(454, 'W3C'),
(404, 'Wapamp'),
(457, 'Wapsilon'),
(455, 'WAPUniverse'),
(122, 'WayteQ'),
(41, 'WellcoM'),
(138, 'Weltbild'),
(575, 'Wiko'),
(393, 'Willcom'),
(53, 'Window'),
(395, 'Windows Mobile'),
(459, 'WinWAP Technologies'),
(199, 'Wolfgang'),
(184, 'WOM'),
(461, 'Wonu'),
(218, 'Woo Comet'),
(410, 'Wynncom'),
(197, 'X10'),
(247, 'XDeviceEmulator'),
(156, 'Xiaomi'),
(462, 'XJXN'),
(402, 'XML-Sitemaps'),
(479, 'Xolo'),
(576, 'Xtouch'),
(237, 'Yarvik'),
(463, 'Yas'),
(175, 'Yitong'),
(66, 'YooTab'),
(478, 'Young Way'),
(494, 'Youwave'),
(177, 'Yushen'),
(464, 'Zen'),
(380, 'Zen Mobile'),
(75, 'Zenithink'),
(604, 'ZIGO'),
(465, 'Zonda'),
(578, 'ZOPO'),
(466, 'ZT'),
(42, 'ZTE'),
(480, 'ZTE Corporation'),
(477, 'ZXD');

-- --------------------------------------------------------

--
-- Table structure for table `smbrowserlanguages`
--

CREATE TABLE `smbrowserlanguages` (
  `BrowserLanguageCode` char(2) CHARACTER SET ascii NOT NULL,
  `BrowserLanguage` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `smbrowserlanguages`
--

INSERT INTO `smbrowserlanguages` (`BrowserLanguageCode`, `BrowserLanguage`) VALUES
('aa', 'aa -> Afar'),
('ab', 'ab -> Abkhazian'),
('ae', 'ae -> Avestan'),
('af', 'af -> Afrikaans'),
('ak', 'ak -> Akan'),
('am', 'am -> Amharic'),
('an', 'an -> Aragonese'),
('ar', 'ar -> Arabic'),
('as', 'as -> Assamese'),
('av', 'av -> Avaric'),
('ay', 'ay -> Aymara'),
('az', 'az -> Azerbaijani'),
('ba', 'ba -> Bashkir'),
('be', 'be -> Belarusian'),
('bg', 'bg -> Bulgarian'),
('bh', 'bh -> Bihari'),
('bi', 'bi -> Bislama'),
('bm', 'bm -> Bambara'),
('bn', 'bn -> Bengali (Bangla)'),
('bo', 'bo -> Tibetan'),
('br', 'br -> Breton'),
('bs', 'bs -> Bosnian'),
('ca', 'ca -> Catalan'),
('ce', 'ce -> Chechen'),
('ch', 'ch -> Chamorro'),
('co', 'co -> Corsican'),
('cr', 'cr -> Cree'),
('cs', 'cs -> Czech'),
('cu', 'cu -> Old Church Slavonic, Old Bulgarian'),
('cv', 'cv -> Chuvash'),
('cy', 'cy -> Welsh'),
('da', 'da -> Danish'),
('de', 'de -> German'),
('dv', 'dv -> Divehi, Dhivehi, Maldivian'),
('dz', 'dz -> Dzongkha'),
('ee', 'ee -> Ewe'),
('el', 'el -> Greek'),
('en', 'en -> English'),
('eo', 'eo -> Esperanto'),
('es', 'es -> Spanish'),
('et', 'et -> Estonian'),
('eu', 'eu -> Basque'),
('fa', 'fa -> Persian (Farsi)'),
('ff', 'ff -> Fula, Fulah, Pulaar, Pular'),
('fi', 'fi -> Finnish'),
('fj', 'fj -> Fijian'),
('fo', 'fo -> Faroese'),
('fr', 'fr -> French'),
('fy', 'fy -> Western Frisian'),
('ga', 'ga -> Irish'),
('gd', 'gd -> Gaelic (Scottish)'),
('gl', 'gl -> Galician'),
('gn', 'gn -> Guarani'),
('gu', 'gu -> Gujarati'),
('gv', 'gv -> Gaelic (Manx)'),
('ha', 'ha -> Hausa'),
('he', 'he -> Hebrew'),
('hi', 'hi -> Hindi'),
('ho', 'ho -> Hiri Motu'),
('hr', 'hr -> Croatian'),
('ht', 'ht -> Haitian Creole'),
('hu', 'hu -> Hungarian'),
('hy', 'hy -> Armenian'),
('hz', 'hz -> Herero'),
('ia', 'ia -> Interlingua'),
('id', 'id -> Indonesian'),
('ie', 'ie -> Interlingue'),
('ig', 'ig -> Igbo'),
('ii', 'ii -> Nuosu'),
('ik', 'ik -> Inupiak'),
('in', 'in -> Indonesian'),
('io', 'io -> Ido'),
('is', 'is -> Icelandic'),
('it', 'it -> Italian'),
('iu', 'iu -> Inuktitut'),
('ja', 'ja -> Japanese'),
('ji', 'ji -> Yiddish'),
('jv', 'jv -> Javanese'),
('ka', 'ka -> Georgian'),
('kg', 'kg -> Kongo'),
('ki', 'ki -> Kikuyu'),
('kj', 'kj -> Kwanyama'),
('kk', 'kk -> Kazakh'),
('kl', 'kl -> Kalaallisut, Greenlandic'),
('km', 'km -> Khmer'),
('kn', 'kn -> Kannada'),
('ko', 'ko -> Korean'),
('kr', 'kr -> Kanuri'),
('ks', 'ks -> Kashmiri'),
('ku', 'ku -> Kurdish'),
('kv', 'kv -> Komi'),
('kw', 'kw -> Cornish'),
('ky', 'ky -> Kyrgyz'),
('la', 'la -> Latin'),
('lb', 'lb -> Luxembourgish'),
('lg', 'lg -> Luganda, Ganda'),
('li', 'li -> Limburgish ( Limburger)'),
('ln', 'ln -> Lingala'),
('lo', 'lo -> Lao'),
('lt', 'lt -> Lithuanian'),
('lu', 'lu -> Luga-Katanga'),
('lv', 'lv -> Latvian (Lettish)'),
('mg', 'mg -> Malagasy'),
('mh', 'mh -> Marshallese'),
('mi', 'mi -> Maori'),
('mk', 'mk -> Macedonian'),
('ml', 'ml -> Malayalam'),
('mn', 'mn -> Mongolian'),
('mo', 'mo -> Moldavian'),
('mr', 'mr -> Marathi'),
('ms', 'ms -> Malay'),
('mt', 'mt -> Maltese'),
('my', 'my -> Burmese'),
('na', 'na -> Nauru'),
('nb', 'nb -> Norwegian bokmål'),
('nd', 'nd -> Northern Ndebele'),
('ne', 'ne -> Nepali'),
('ng', 'ng -> Ndonga'),
('nl', 'nl -> Dutch'),
('nn', 'nn -> Norwegian nynorsk'),
('no', 'no -> Norwegian'),
('nr', 'nr -> Southern Ndebele'),
('nv', 'nv -> Navajo'),
('ny', 'ny -> Chichewa, Chewa, Nyanja'),
('oc', 'oc -> Occitan'),
('oj', 'oj -> Ojibwe'),
('om', 'om -> Oromo (Afaan Oromo)'),
('or', 'or -> Oriya'),
('os', 'os -> Ossetian'),
('pa', 'pa -> Punjabi (Eastern)'),
('pi', 'pi -> Pāli'),
('pl', 'pl -> Polish'),
('ps', 'ps -> Pashto, Pushto'),
('pt', 'pt -> Portuguese'),
('qu', 'qu -> Quechua'),
('rm', 'rm -> Romansh'),
('rn', 'rn -> Kirundi'),
('ro', 'ro -> Romanian'),
('ru', 'ru -> Russian'),
('rw', 'rw -> Kinyarwanda (Rwanda)'),
('sa', 'sa -> Sanskrit'),
('sd', 'sd -> Sindhi'),
('se', 'se -> Sami'),
('sg', 'sg -> Sango'),
('sh', 'sh -> Serbo-Croatian'),
('si', 'si -> Sinhalese'),
('sk', 'sk -> Slovak'),
('sl', 'sl -> Slovenian'),
('sm', 'sm -> Samoan'),
('sn', 'sn -> Shona'),
('so', 'so -> Somali'),
('sq', 'sq -> Albanian'),
('sr', 'sr -> Serbian'),
('ss', 'ss -> Siswati'),
('st', 'st -> Sesotho'),
('su', 'su -> Sundanese'),
('sv', 'sv -> Swedish'),
('sw', 'sw -> Swahili (Kiswahili)'),
('ta', 'ta -> Tamil'),
('te', 'te -> Telugu'),
('tg', 'tg -> Tajik'),
('th', 'th -> Thai'),
('ti', 'ti -> Tigrinya'),
('tk', 'tk -> Turkmen'),
('tl', 'tl -> Tagalog'),
('tn', 'tn -> Setswana'),
('to', 'to -> Tonga'),
('tr', 'tr -> Turkish'),
('ts', 'ts -> Tsonga'),
('tt', 'tt -> Tatar'),
('tw', 'tw -> Twi'),
('ty', 'ty -> Tahitian'),
('ug', 'ug -> Uyghur'),
('uk', 'uk -> Ukrainian'),
('ur', 'ur -> Urdu'),
('uz', 'uz -> Uzbek'),
('ve', 've -> Venda'),
('vi', 'vi -> Vietnamese'),
('vo', 'vo -> Volapük'),
('wa', 'wa -> Wallon'),
('wo', 'wo -> Wolof'),
('xh', 'xh -> Xhosa'),
('yi', 'yi -> Yiddish'),
('yo', 'yo -> Yoruba'),
('za', 'za -> Zhuang, Chuang'),
('zh', 'zh -> Chinese'),
('zu', 'zu -> Zulu');

-- --------------------------------------------------------

--
-- Table structure for table `smbrowsers`
--

CREATE TABLE `smbrowsers` (
  `BrowserID` smallint(5) UNSIGNED NOT NULL,
  `BrowserName` varchar(191) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `smbrowsers`
--

INSERT INTO `smbrowsers` (`BrowserID`, `BrowserName`) VALUES
(1, ''),
(31, 'Access'),
(7, 'Access Netfront'),
(9, 'Android Webkit'),
(36, 'BlackBerry'),
(51, 'Blazer'),
(94, 'Bolt'),
(4, 'Chrome'),
(15, 'Chrome Lite'),
(10, 'Chrome Mobile'),
(91, 'Diigo Browser'),
(32, 'Dolfin/Jasmine Webkit'),
(52, 'Doris'),
(43, 'Embider'),
(50, 'Fennec'),
(3, 'Firefox'),
(47, 'FireFox Desktop'),
(53, 'Gecko/Fennec'),
(54, 'Gecko/Minimo'),
(55, 'Gecko/Skyfire'),
(2, 'IE'),
(20, 'IEMobile'),
(41, 'Jataayu'),
(56, 'jB5'),
(57, 'jig browser'),
(14, 'LGUPlus FaceBook'),
(12, 'LGUPlus WebKit'),
(13, 'LGUPlus Webviewer'),
(58, 'LUMI/Polaris'),
(49, 'MAUI Wap Browser'),
(21, 'Microsoft Mobile Explorer'),
(86, 'Microsoft/IE Mobile WinMo'),
(22, 'Microsoft/IE Mobile WP7'),
(59, 'Microsoft/MME'),
(87, 'Microsoft/Pocket IE'),
(95, 'mobile browser'),
(35, 'Motorola Internet Browser'),
(23, 'MQQ Browser'),
(24, 'MSIE'),
(45, 'Netfront NX'),
(16, 'NetFrontLifeBrowser'),
(61, 'Netsailor'),
(44, 'Nokia'),
(30, 'Nokia Browser'),
(29, 'Nokia BrowserNG'),
(26, 'Nokia Proxy Browser'),
(27, 'Nokia/S40Ovi'),
(37, 'Novarra nWeb'),
(28, 'Openwave Mobile Browser'),
(6, 'Opera'),
(19, 'Opera Mini'),
(17, 'Opera Mobi'),
(18, 'Opera Tablet'),
(25, 'OviBrowser (Nokia S40)'),
(93, 'Palm'),
(90, 'Phantom'),
(63, 'Pocket Internet Explorer'),
(98, 'Polaris'),
(48, 'Presto/Opera'),
(40, 'Presto/Opera Mini'),
(33, 'Presto/Opera Mobi'),
(62, 'Presto/Opera Tablet'),
(5, 'Safari'),
(34, 'Samsung'),
(38, 'Semc'),
(89, 'Skyfire'),
(96, 'SMIT Browser'),
(64, 'SonyEricsson'),
(65, 'Symphony'),
(39, 'Symphony browser'),
(8, 'Teleca-Obigo'),
(66, 'ThunderHawk'),
(92, 'TSBrowser'),
(97, 'UCWeb'),
(60, 'Uzard WEB'),
(67, 'uZard Web H'),
(68, 'uZard Web P'),
(69, 'uZard Web S'),
(42, 'wap browser'),
(11, 'WebKit/Android'),
(70, 'WebKit/Bolt'),
(71, 'WebKit/Digia'),
(72, 'WebKit/Diigo'),
(73, 'WebKit/Dolfin-Jasmine'),
(74, 'WebKit/iPhone'),
(75, 'WebKit/Iris'),
(76, 'WebKit/LG'),
(79, 'WebKit/Nokia'),
(77, 'WebKit/Nokia/MeeGo'),
(78, 'WebKit/Nokia/NG'),
(80, 'WebKit/Phantom'),
(81, 'WebKit/Polaris'),
(82, 'WebKit/Safari'),
(83, 'WebKit/Skyfire'),
(84, 'WebKit/Steel'),
(46, 'WebKit/webOS'),
(85, 'WebKit/Zetakey'),
(88, 'WinWAP');

-- --------------------------------------------------------

--
-- Table structure for table `smbrowserversions`
--

CREATE TABLE `smbrowserversions` (
  `BrowserVersionID` smallint(5) UNSIGNED NOT NULL,
  `BrowserVersion` varchar(190) NOT NULL,
  `BrowserID` smallint(5) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `smbrowserversions`
--

INSERT INTO `smbrowserversions` (`BrowserVersionID`, `BrowserVersion`, `BrowserID`) VALUES
(1, '', 1),
(391, '', 3),
(107, '', 5),
(196, '', 6),
(330, '', 7),
(237, '', 8),
(115, '', 9),
(132, '', 10),
(118, '', 11),
(119, '', 12),
(120, '', 13),
(121, '', 14),
(142, '', 17),
(145, '', 18),
(230, '', 19),
(674, '', 21),
(528, '', 23),
(687, '', 24),
(193, '', 26),
(187, '', 27),
(390, '', 28),
(219, '', 29),
(709, '', 31),
(493, '', 33),
(270, '', 34),
(286, '', 36),
(415, '', 37),
(326, '', 38),
(344, '', 39),
(345, '', 40),
(382, '', 42),
(104, '', 44),
(631, '', 45),
(406, '', 46),
(449, '', 47),
(495, '', 49),
(498, '', 50),
(523, '', 56),
(524, '', 57),
(527, '', 60),
(532, '', 61),
(569, '', 62),
(585, '', 64),
(586, '', 65),
(593, '', 67),
(596, '', 69),
(618, '', 72),
(629, '', 76),
(634, '', 79),
(639, '', 82),
(651, '', 85),
(678, '', 89),
(685, '', 90),
(695, '', 92),
(698, '', 93),
(741, '', 95),
(747, '', 96),
(131, '', 97),
(641, '0.0.1', 84),
(642, '0.0.10', 84),
(643, '0.0.11', 84),
(644, '0.0.12', 84),
(645, '0.0.19', 84),
(646, '0.0.8', 84),
(647, '0.0.9', 84),
(519, '0.1', 54),
(648, '0.1.1', 84),
(649, '0.1.6', 84),
(650, '0.1.9', 84),
(520, '0.2', 54),
(185, '0.8', 26),
(259, '0.8', 32),
(722, '0.8', 94),
(723, '0.92', 94),
(407, '1', 19),
(255, '1', 32),
(499, '1', 51),
(526, '1', 59),
(594, '1', 68),
(657, '1', 87),
(416, '1.0', 1),
(2, '1.0', 2),
(21, '1.0', 3),
(117, '1.0', 5),
(376, '1.0', 8),
(529, '1.0', 16),
(480, '1.0', 24),
(184, '1.0', 25),
(186, '1.0', 26),
(576, '1.0', 27),
(256, '1.0', 32),
(293, '1.0', 36),
(350, '1.0', 39),
(553, '1.0', 40),
(224, '1.0', 44),
(450, '1.0', 47),
(696, '1.0', 49),
(507, '1.0', 52),
(509, '1.0', 53),
(521, '1.0', 55),
(571, '1.0', 63),
(587, '1.0', 66),
(616, '1.0', 71),
(627, '1.0', 75),
(689, '1.0', 87),
(661, '1.0', 88),
(714, '1.0', 90),
(742, '1.0', 92),
(724, '1.04', 94),
(379, '1.1', 8),
(597, '1.1', 11),
(232, '1.1', 19),
(554, '1.1', 40),
(508, '1.1', 52),
(510, '1.1', 53),
(572, '1.1', 63),
(628, '1.1', 75),
(662, '1.1', 88),
(730, '1.2', 8),
(555, '1.2', 40),
(663, '1.2', 88),
(664, '1.3', 88),
(3, '1.5', 2),
(122, '1.5', 9),
(598, '1.5', 11),
(253, '1.5', 32),
(522, '1.5', 55),
(619, '1.5', 73),
(123, '1.6', 9),
(599, '1.6', 11),
(721, '1.6', 94),
(392, '1.7', 45),
(192, '1.8', 26),
(191, '1.8', 27),
(720, '1.9', 50),
(749, '10', 3),
(496, '10', 17),
(182, '10', 20),
(652, '10', 22),
(481, '10', 24),
(562, '10', 33),
(535, '10', 48),
(417, '10.0', 1),
(13, '10.0', 2),
(34, '10.0', 3),
(65, '10.0', 4),
(411, '10.0', 24),
(312, '10.0', 36),
(451, '10.0', 47),
(733, '10.00', 6),
(732, '10.1', 6),
(734, '10.1', 17),
(563, '10.1', 33),
(712, '10.1', 36),
(536, '10.1', 48),
(713, '10.2', 36),
(141, '11', 17),
(144, '11', 18),
(686, '11', 24),
(564, '11', 33),
(418, '11.0', 1),
(14, '11.0', 2),
(35, '11.0', 3),
(66, '11.0', 4),
(719, '11.0', 24),
(452, '11.0', 47),
(565, '11.1', 33),
(143, '12', 17),
(146, '12', 18),
(566, '12', 33),
(570, '12', 62),
(419, '12.0', 1),
(36, '12.0', 3),
(67, '12.0', 4),
(453, '12.0', 47),
(420, '13.0', 1),
(37, '13.0', 3),
(68, '13.0', 4),
(454, '13.0', 47),
(700, '14', 1),
(421, '14.0', 1),
(38, '14.0', 3),
(69, '14.0', 4),
(455, '14.0', 47),
(422, '15.0', 1),
(39, '15.0', 3),
(70, '15.0', 4),
(456, '15.0', 47),
(423, '16.0', 1),
(40, '16.0', 3),
(71, '16.0', 4),
(457, '16.0', 47),
(718, '17', 1),
(424, '17.0', 1),
(41, '17.0', 3),
(72, '17.0', 4),
(458, '17.0', 47),
(133, '18', 9),
(116, '18', 10),
(425, '18.0', 1),
(42, '18.0', 3),
(73, '18.0', 4),
(134, '18.0', 10),
(459, '18.0', 47),
(506, '19', 10),
(426, '19.0', 1),
(43, '19.0', 3),
(74, '19.0', 4),
(460, '19.0', 47),
(275, '2', 8),
(408, '2', 19),
(313, '2', 36),
(500, '2', 51),
(595, '2', 68),
(658, '2', 87),
(746, '2', 96),
(129, '2', 97),
(427, '2.0', 1),
(4, '2.0', 2),
(22, '2.0', 3),
(163, '2.0', 5),
(203, '2.0', 6),
(236, '2.0', 8),
(600, '2.0', 11),
(530, '2.0', 16),
(188, '2.0', 26),
(113, '2.0', 32),
(279, '2.0', 34),
(340, '2.0', 35),
(289, '2.0', 36),
(556, '2.0', 40),
(231, '2.0', 44),
(461, '2.0', 47),
(511, '2.0', 53),
(573, '2.0', 63),
(588, '2.0', 66),
(614, '2.0', 70),
(617, '2.0', 71),
(620, '2.0', 73),
(621, '2.0', 74),
(637, '2.0', 80),
(640, '2.0', 83),
(690, '2.0', 87),
(665, '2.0', 88),
(715, '2.0', 90),
(745, '2.0', 96),
(165, '2.0', 97),
(164, '2.1', 5),
(396, '2.1', 8),
(126, '2.1', 9),
(601, '2.1', 11),
(341, '2.1', 35),
(393, '2.1', 45),
(615, '2.1', 70),
(386, '2.16', 8),
(158, '2.2', 5),
(602, '2.2', 11),
(261, '2.2', 16),
(189, '2.2', 26),
(245, '2.2', 32),
(334, '2.2', 35),
(666, '2.2', 88),
(335, '2.2.1', 35),
(603, '2.3', 11),
(190, '2.3', 26),
(225, '2.3', 30),
(667, '2.3', 88),
(604, '2.4', 11),
(277, '2.5', 1),
(278, '2.5', 34),
(180, '2.7', 23),
(428, '20.0', 1),
(44, '20.0', 3),
(75, '20.0', 4),
(462, '20.0', 47),
(429, '21.0', 1),
(45, '21.0', 3),
(76, '21.0', 4),
(463, '21.0', 47),
(430, '22.0', 1),
(46, '22.0', 3),
(77, '22.0', 4),
(464, '22.0', 47),
(431, '23.0', 1),
(47, '23.0', 3),
(78, '23.0', 4),
(465, '23.0', 47),
(432, '24.0', 1),
(48, '24.0', 3),
(79, '24.0', 4),
(466, '24.0', 47),
(433, '25.0', 1),
(49, '25.0', 3),
(80, '25.0', 4),
(467, '25.0', 47),
(434, '26.0', 1),
(50, '26.0', 3),
(81, '26.0', 4),
(468, '26.0', 47),
(435, '27.0', 1),
(51, '27.0', 3),
(82, '27.0', 4),
(469, '27.0', 47),
(135, '28', 10),
(436, '28.0', 1),
(52, '28.0', 3),
(83, '28.0', 4),
(470, '28.0', 47),
(437, '29.0', 1),
(84, '29.0', 4),
(471, '29.0', 47),
(751, '3', 3),
(364, '3', 8),
(409, '3', 19),
(243, '3', 32),
(501, '3', 51),
(659, '3', 87),
(233, '3', 97),
(365, '3 Q03', 8),
(438, '3.0', 1),
(5, '3.0', 2),
(23, '3.0', 3),
(159, '3.0', 5),
(264, '3.0', 7),
(363, '3.0', 8),
(605, '3.0', 11),
(533, '3.0', 28),
(244, '3.0', 32),
(281, '3.0', 35),
(557, '3.0', 40),
(276, '3.0', 44),
(472, '3.0', 47),
(512, '3.0', 53),
(574, '3.0', 63),
(577, '3.0', 64),
(589, '3.0', 66),
(622, '3.0', 74),
(668, '3.0', 88),
(235, '3.0.1', 44),
(24, '3.1', 3),
(160, '3.1', 5),
(247, '3.1', 7),
(606, '3.1', 11),
(402, '3.1', 19),
(534, '3.1', 28),
(669, '3.1', 88),
(124, '3.1.2', 9),
(380, '3.12', 8),
(150, '3.2', 5),
(267, '3.2', 7),
(607, '3.2', 11),
(228, '3.2', 31),
(290, '3.2', 36),
(670, '3.2', 88),
(680, '3.2', 97),
(291, '3.2.1', 36),
(111, '3.3', 7),
(271, '3.3', 31),
(314, '3.3', 36),
(578, '3.3', 64),
(110, '3.4', 7),
(280, '3.4', 31),
(25, '3.5', 3),
(246, '3.5', 7),
(378, '3.5', 8),
(315, '3.5', 36),
(473, '3.5', 47),
(26, '3.6', 3),
(377, '3.6', 8),
(292, '3.6', 36),
(287, '3.7', 36),
(296, '3.8', 36),
(137, '30', 10),
(439, '30.0', 1),
(85, '30.0', 4),
(440, '31.0', 1),
(86, '31.0', 4),
(441, '32.0', 1),
(87, '32.0', 4),
(442, '33.0', 1),
(329, '4', 8),
(257, '4', 19),
(744, '4', 28),
(316, '4', 36),
(502, '4', 51),
(660, '4', 87),
(443, '4.0', 1),
(6, '4.0', 2),
(27, '4.0', 3),
(161, '4.0', 5),
(706, '4.0', 6),
(531, '4.0', 7),
(101, '4.0', 8),
(127, '4.0', 9),
(608, '4.0', 11),
(140, '4.0', 16),
(675, '4.0', 19),
(269, '4.0', 21),
(482, '4.0', 24),
(223, '4.0', 28),
(294, '4.0', 36),
(327, '4.0', 38),
(558, '4.0', 40),
(216, '4.0', 44),
(474, '4.0', 47),
(513, '4.0', 53),
(575, '4.0', 63),
(579, '4.0', 64),
(623, '4.0', 74),
(691, '4.0', 87),
(671, '4.0', 88),
(580, '4.0.1', 64),
(581, '4.0.2', 64),
(582, '4.0.3', 64),
(397, '4.01', 8),
(367, '4.01', 21),
(332, '4.08', 1),
(162, '4.1', 5),
(254, '4.1', 7),
(609, '4.1', 11),
(226, '4.1', 28),
(297, '4.1', 36),
(333, '4.1', 38),
(229, '4.1', 44),
(583, '4.1', 64),
(672, '4.1', 88),
(298, '4.1.0', 36),
(295, '4.1.03', 36),
(214, '4.1.3', 5),
(213, '4.13', 5),
(28, '4.2', 3),
(156, '4.2', 5),
(109, '4.2', 7),
(610, '4.2', 11),
(263, '4.2', 19),
(300, '4.2', 36),
(328, '4.2', 38),
(400, '4.2', 40),
(584, '4.2', 64),
(673, '4.2', 88),
(681, '4.2', 97),
(301, '4.2.1', 36),
(288, '4.2.2', 36),
(157, '4.3', 5),
(611, '4.3', 11),
(302, '4.3', 36),
(748, '4.3', 49),
(612, '4.4', 11),
(304, '4.5', 36),
(702, '4.5', 93),
(305, '4.5.0', 36),
(308, '4.5.0.69', 36),
(303, '4.6', 36),
(306, '4.6.1', 36),
(311, '4.7', 36),
(503, '4_1', 51),
(504, '4_3', 51),
(505, '4_5', 51),
(356, '5', 8),
(250, '5', 19),
(317, '5', 36),
(352, '5', 41),
(444, '5.0', 1),
(7, '5.0', 2),
(29, '5.0', 3),
(151, '5.0', 5),
(283, '5.0', 8),
(613, '5.0', 11),
(147, '5.0', 19),
(483, '5.0', 24),
(265, '5.0', 28),
(307, '5.0', 36),
(299, '5.0', 37),
(559, '5.0', 40),
(383, '5.0', 43),
(475, '5.0', 47),
(514, '5.0', 53),
(624, '5.0', 74),
(693, '5.0', 91),
(682, '5.0', 97),
(285, '5.0', 98),
(701, '5.1', 1),
(152, '5.1', 5),
(410, '5.1', 19),
(590, '5.1', 97),
(175, '5.2', 20),
(705, '5.2', 21),
(412, '5.2', 37),
(737, '5.30', 43),
(8, '5.5', 2),
(366, '5.5', 21),
(484, '5.5', 24),
(491, '525', 1),
(211, '525', 5),
(492, '530', 1),
(676, '6', 19),
(240, '6', 20),
(168, '6', 21),
(318, '6', 36),
(497, '6', 50),
(525, '6', 58),
(653, '6', 86),
(591, '6', 97),
(384, '6', 98),
(445, '6.0', 1),
(9, '6.0', 2),
(30, '6.0', 3),
(61, '6.0', 4),
(153, '6.0', 5),
(342, '6.0', 6),
(148, '6.0', 19),
(169, '6.0', 20),
(183, '6.0', 21),
(485, '6.0', 24),
(258, '6.0', 28),
(310, '6.0', 36),
(560, '6.0', 40),
(476, '6.0', 47),
(537, '6.0', 48),
(515, '6.0', 53),
(625, '6.0', 74),
(106, '6.0', 97),
(108, '6.0', 98),
(154, '6.1', 5),
(717, '6.1', 19),
(251, '6.1', 28),
(538, '6.1', 48),
(238, '6.1', 98),
(711, '6.10', 6),
(174, '6.12', 21),
(369, '6.12', 35),
(739, '6.12', 88),
(274, '6.15', 98),
(202, '6.2', 6),
(385, '6.2', 8),
(194, '6.2', 28),
(372, '6.2', 37),
(539, '6.2', 48),
(242, '6.2', 98),
(343, '6.2.2.1', 28),
(494, '6.2.2.6', 28),
(252, '6.2.3', 28),
(387, '6.2.3.2', 28),
(266, '6.2.3.3', 28),
(346, '6.2.3.4', 28),
(381, '6.2.3.8', 28),
(388, '6.2.3.9', 28),
(201, '6.20', 6),
(222, '6.3', 28),
(540, '6.3', 48),
(351, '6.3.0.6', 28),
(322, '6.30', 6),
(323, '6.31', 6),
(708, '6.5', 6),
(139, '6.5', 19),
(239, '6.8', 21),
(368, '6.9', 21),
(324, '7', 8),
(677, '7', 19),
(177, '7', 20),
(178, '7', 22),
(735, '7', 24),
(221, '7', 28),
(319, '7', 36),
(632, '7', 78),
(638, '7', 81),
(654, '7', 86),
(592, '7', 97),
(446, '7.0', 1),
(10, '7.0', 2),
(31, '7.0', 3),
(62, '7.0', 4),
(155, '7.0', 5),
(710, '7.0', 6),
(374, '7.0', 8),
(149, '7.0', 19),
(166, '7.0', 20),
(486, '7.0', 24),
(337, '7.0', 28),
(309, '7.0', 36),
(561, '7.0', 40),
(477, '7.0', 47),
(541, '7.0', 48),
(516, '7.0', 53),
(626, '7.0', 74),
(683, '7.0', 97),
(688, '7.0', 98),
(405, '7.0.2.1', 1),
(321, '7.1', 5),
(375, '7.1', 8),
(336, '7.1', 28),
(215, '7.1', 29),
(320, '7.1', 36),
(218, '7.1', 44),
(401, '7.1.0', 28),
(704, '7.11', 6),
(731, '7.11', 19),
(398, '7.11', 20),
(171, '7.11', 21),
(738, '7.11', 35),
(716, '7.2', 5),
(488, '7.2', 6),
(282, '7.2', 28),
(208, '7.2', 29),
(217, '7.2', 44),
(542, '7.2', 48),
(635, '7.2', 78),
(227, '7.2', 97),
(373, '7.3', 8),
(209, '7.3', 29),
(633, '7.3', 78),
(636, '7.3', 79),
(210, '7.4', 29),
(212, '7.4', 30),
(358, '7.5', 6),
(179, '7.5', 20),
(543, '7.5', 48),
(204, '7.50', 6),
(399, '7.6', 20),
(268, '7.6', 21),
(544, '7.6', 48),
(205, '7.60', 6),
(359, '7.7', 20),
(272, '7.7', 21),
(703, '7.7', 88),
(736, '7.7', 97),
(136, '7.8', 97),
(138, '7.9', 97),
(338, '8', 6),
(353, '8', 19),
(655, '8', 22),
(414, '8', 37),
(125, '8', 97),
(447, '8.0', 1),
(11, '8.0', 2),
(32, '8.0', 3),
(63, '8.0', 4),
(347, '8.0', 6),
(487, '8.0', 24),
(413, '8.0', 37),
(478, '8.0', 47),
(545, '8.0', 48),
(517, '8.0', 53),
(105, '8.0', 97),
(199, '8.00', 6),
(198, '8.00', 44),
(725, '8.1', 37),
(170, '8.12', 20),
(241, '8.12', 21),
(206, '8.5', 1),
(750, '8.5', 3),
(331, '8.5', 6),
(546, '8.5', 48),
(630, '8.5', 77),
(103, '8.5', 97),
(348, '8.50', 6),
(197, '8.50', 44),
(349, '8.6', 6),
(547, '8.6', 48),
(128, '8.6', 97),
(195, '8.60', 6),
(114, '8.65', 6),
(200, '8.65', 19),
(707, '8.7', 6),
(548, '8.7', 48),
(207, '8.7', 97),
(234, '8.8', 97),
(176, '9', 20),
(656, '9', 22),
(549, '9', 48),
(112, '9', 97),
(448, '9.0', 1),
(12, '9.0', 2),
(33, '9.0', 3),
(64, '9.0', 4),
(370, '9.0', 6),
(167, '9.0', 20),
(181, '9.0', 24),
(479, '9.0', 47),
(518, '9.0', 53),
(394, '9.1', 6),
(395, '9.30', 6),
(220, '9.5', 6),
(262, '9.5', 17),
(248, '9.5', 33),
(550, '9.5', 48),
(172, '9.50', 6),
(339, '9.50', 17),
(371, '9.51', 17),
(403, '9.51 beta', 17),
(489, '9.6', 1),
(260, '9.6', 6),
(173, '9.7', 6),
(249, '9.7', 17),
(567, '9.7', 33),
(551, '9.7', 48),
(354, '9.8', 17),
(568, '9.8', 33),
(552, '9.8', 48),
(490, '9.80', 48),
(679, 'browser_root_ucweb', 97),
(692, 'PIE 1', 21),
(273, 'PIE 4', 21),
(743, 'PIE 4', 88),
(130, 'Q03', 8),
(740, 'Q03B1', 8),
(360, 'Q03C', 8),
(699, 'Q03c', 49),
(697, 'Q04', 8),
(357, 'Q04C1', 8),
(102, 'Q05', 8),
(361, 'Q05A', 8),
(325, 'Q07', 8),
(355, 'Q3', 8),
(362, 'q3c', 8),
(404, 'Q4', 8),
(284, 'q4c', 8),
(728, 'Q7.0-1.3', 8),
(389, 'Q7.0-1.6', 8),
(729, 'WebPro 3.5', 93);

-- --------------------------------------------------------

--
-- Table structure for table `smdatarate`
--

CREATE TABLE `smdatarate` (
  `DataRateID` tinyint(3) UNSIGNED NOT NULL,
  `DataRate` int(10) UNSIGNED DEFAULT NULL,
  `DataRateName` varchar(50) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `smdatarate`
--

INSERT INTO `smdatarate` (`DataRateID`, `DataRate`, `DataRateName`) VALUES
(1, 0, ''),
(2, 9, 'CSD'),
(3, 200, 'EGPRS/EDGE'),
(4, 3600, 'HSDPA'),
(5, 384, 'UMTS (3G)'),
(6, 3200, 'Other'),
(7, 7200, 'HSDPA'),
(8, 1800, 'HSDPA'),
(9, 300, 'EDGE'),
(10, 10200, 'HSDPA Release 5'),
(11, 2100, 'HSDPA'),
(12, 42000, 'HSPA+'),
(13, 14000, 'HSDPA Release 5'),
(14, 5760, 'HSDPA'),
(15, 1200, 'Evolved EDGE'),
(16, 29, 'HSCSD'),
(17, 2800, 'TD-SCDMA'),
(18, 21600, 'HSPA+'),
(19, 11264, 'HSDPA Release 5'),
(20, 236, 'EDGE'),
(21, 320, 'EDGE'),
(22, 100000, 'LTE'),
(23, 3100, 'CDMA'),
(24, 14400, 'HSUPA'),
(25, 21000, 'HSPA+'),
(26, 40, 'GPRS');

-- --------------------------------------------------------

--
-- Table structure for table `smdevicenamebrand`
--

CREATE TABLE `smdevicenamebrand` (
  `DeviceNameID` smallint(5) UNSIGNED NOT NULL DEFAULT 0,
  `BrandID` smallint(5) UNSIGNED NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `smdevicenamebrand`
--

INSERT INTO `smdevicenamebrand` (`DeviceNameID`, `BrandID`) VALUES
(1, 1),
(1, 2),
(1, 3),
(1, 4),
(1, 5),
(1, 7),
(1, 12),
(1, 15),
(1, 28),
(1, 52),
(1, 60),
(1, 70),
(1, 147),
(1, 159),
(1, 160),
(1, 164),
(1, 168),
(1, 252),
(1, 253),
(1, 255),
(1, 258),
(1, 265),
(1, 269),
(1, 279),
(1, 282),
(1, 324),
(1, 325),
(1, 327),
(1, 343),
(1, 401),
(1, 416),
(1, 426),
(2, 250),
(3, 2),
(4, 3),
(5, 3),
(6, 3),
(7, 4),
(8, 5),
(9, 5),
(10, 5),
(11, 5),
(12, 5),
(13, 6),
(14, 7),
(15, 8),
(16, 9),
(17, 6),
(18, 4),
(18, 6),
(19, 6),
(20, 4),
(21, 10),
(22, 7),
(23, 11),
(24, 12),
(25, 13),
(26, 14),
(27, 14),
(28, 14),
(29, 14),
(30, 14),
(31, 14),
(32, 14),
(33, 12),
(34, 250),
(35, 15),
(36, 15),
(37, 15),
(38, 15),
(39, 15),
(40, 15),
(41, 16),
(42, 17),
(43, 17),
(44, 17),
(45, 17),
(46, 17),
(47, 18),
(48, 19),
(49, 20),
(50, 21),
(51, 21),
(52, 21),
(53, 22),
(53, 25),
(53, 141),
(54, 17),
(55, 7),
(56, 23),
(57, 24),
(58, 22),
(58, 25),
(59, 21),
(60, 26),
(61, 7),
(62, 7),
(63, 27),
(64, 21),
(65, 21),
(66, 21),
(67, 21),
(68, 4),
(69, 4),
(70, 4),
(71, 28),
(72, 28),
(73, 28),
(74, 28),
(75, 28),
(76, 28),
(77, 28),
(78, 28),
(79, 29),
(80, 30),
(81, 22),
(82, 250),
(83, 7),
(84, 22),
(85, 22),
(86, 250),
(87, 250),
(88, 31),
(89, 32),
(90, 30),
(91, 30),
(92, 28),
(93, 28),
(94, 31),
(95, 31),
(96, 33),
(97, 34),
(98, 35),
(99, 28),
(100, 21),
(101, 5),
(102, 5),
(103, 24),
(104, 24),
(104, 141),
(105, 5),
(106, 5),
(107, 4),
(108, 36),
(108, 91),
(108, 126),
(108, 144),
(108, 154),
(109, 36),
(109, 252),
(110, 22),
(111, 21),
(112, 21),
(113, 9),
(114, 4),
(115, 4),
(116, 24),
(117, 37),
(118, 28),
(119, 38),
(120, 9),
(121, 5),
(122, 5),
(123, 5),
(124, 5),
(125, 5),
(126, 5),
(127, 5),
(128, 5),
(129, 5),
(130, 5),
(131, 39),
(132, 5),
(133, 40),
(134, 41),
(134, 52),
(135, 42),
(136, 30),
(136, 43),
(136, 52),
(136, 252),
(137, 28),
(138, 31),
(139, 44),
(140, 6),
(141, 6),
(142, 28),
(143, 45),
(144, 28),
(145, 28),
(146, 28),
(147, 28),
(148, 6),
(148, 69),
(149, 17),
(150, 17),
(151, 28),
(152, 21),
(153, 21),
(154, 21),
(155, 2),
(156, 2),
(157, 4),
(158, 2),
(159, 2),
(160, 2),
(161, 4),
(162, 42),
(163, 6),
(164, 42),
(165, 4),
(165, 250),
(166, 250),
(167, 250),
(167, 312),
(168, 28),
(169, 35),
(170, 21),
(171, 5),
(172, 24),
(173, 9),
(174, 9),
(175, 46),
(176, 47),
(177, 7),
(178, 7),
(179, 7),
(180, 7),
(181, 7),
(182, 7),
(183, 7),
(184, 7),
(185, 7),
(186, 7),
(187, 7),
(188, 7),
(189, 7),
(190, 7),
(191, 7),
(192, 7),
(193, 21),
(194, 21),
(195, 21),
(196, 21),
(197, 21),
(198, 21),
(199, 21),
(200, 21),
(201, 21),
(202, 21),
(203, 21),
(204, 21),
(205, 250),
(206, 4),
(206, 250),
(207, 9),
(208, 48),
(209, 250),
(210, 22),
(211, 4),
(212, 4),
(213, 4),
(214, 49),
(215, 28),
(216, 28),
(217, 28),
(218, 28),
(219, 28),
(220, 28),
(221, 28),
(222, 50),
(223, 42),
(224, 42),
(225, 51),
(226, 28),
(227, 28),
(228, 28),
(229, 42),
(230, 53),
(231, 54),
(232, 55),
(233, 29),
(234, 27),
(235, 56),
(236, 250),
(237, 46),
(238, 21),
(239, 21),
(240, 42),
(241, 42),
(242, 57),
(243, 58),
(244, 59),
(245, 42),
(246, 7),
(247, 7),
(248, 7),
(249, 7),
(250, 7),
(251, 7),
(252, 7),
(253, 7),
(254, 7),
(255, 9),
(256, 7),
(257, 7),
(258, 7),
(259, 16),
(260, 60),
(261, 60),
(262, 7),
(263, 7),
(264, 7),
(265, 7),
(266, 61),
(267, 5),
(268, 21),
(269, 24),
(270, 62),
(271, 22),
(272, 22),
(273, 42),
(274, 28),
(274, 63),
(275, 64),
(276, 4),
(276, 250),
(277, 28),
(278, 250),
(279, 65),
(280, 250),
(281, 250),
(282, 250),
(283, 4),
(284, 42),
(285, 42),
(286, 250),
(287, 28),
(288, 35),
(289, 42),
(290, 28),
(291, 28),
(292, 28),
(293, 28),
(294, 66),
(295, 7),
(296, 66),
(297, 42),
(298, 42),
(299, 67),
(300, 68),
(300, 91),
(300, 282),
(301, 70),
(302, 28),
(303, 28),
(304, 71),
(305, 72),
(306, 73),
(306, 92),
(306, 111),
(307, 74),
(308, 75),
(309, 76),
(310, 21),
(311, 76),
(312, 30),
(313, 30),
(314, 77),
(315, 78),
(316, 21),
(317, 21),
(318, 79),
(319, 47),
(320, 80),
(321, 81),
(321, 198),
(322, 28),
(323, 21),
(324, 21),
(325, 21),
(326, 2),
(326, 180),
(327, 2),
(328, 2),
(329, 2),
(330, 2),
(331, 2),
(332, 2),
(333, 2),
(334, 24),
(335, 42),
(336, 42),
(337, 82),
(338, 83),
(339, 84),
(340, 84),
(341, 250),
(342, 77),
(343, 77),
(344, 85),
(345, 9),
(346, 28),
(347, 28),
(348, 28),
(349, 28),
(350, 35),
(351, 35),
(352, 21),
(353, 21),
(354, 24),
(355, 24),
(356, 24),
(357, 86),
(358, 48),
(359, 87),
(360, 7),
(361, 7),
(362, 7),
(363, 7),
(364, 7),
(365, 7),
(366, 7),
(367, 7),
(368, 7),
(369, 7),
(370, 7),
(371, 7),
(372, 7),
(373, 7),
(374, 7),
(375, 7),
(376, 7),
(377, 7),
(378, 7),
(379, 7),
(380, 7),
(381, 7),
(382, 7),
(383, 7),
(384, 7),
(385, 21),
(386, 21),
(387, 21),
(388, 21),
(389, 21),
(390, 21),
(391, 21),
(392, 21),
(393, 21),
(394, 21),
(395, 21),
(396, 21),
(397, 21),
(398, 88),
(399, 250),
(400, 89),
(401, 250),
(402, 250),
(403, 250),
(404, 250),
(405, 250),
(406, 60),
(407, 60),
(408, 60),
(409, 60),
(410, 60),
(411, 60),
(412, 90),
(413, 9),
(414, 60),
(415, 21),
(416, 250),
(417, 250),
(418, 86),
(419, 91),
(419, 181),
(420, 4),
(421, 4),
(422, 4),
(423, 4),
(424, 4),
(425, 4),
(426, 4),
(427, 4),
(428, 4),
(429, 4),
(430, 4),
(431, 4),
(432, 4),
(433, 4),
(434, 4),
(435, 4),
(436, 4),
(437, 4),
(438, 4),
(439, 4),
(440, 4),
(441, 4),
(442, 6),
(443, 4),
(444, 4),
(445, 4),
(446, 4),
(447, 4),
(448, 4),
(449, 4),
(450, 4),
(451, 4),
(452, 4),
(453, 4),
(454, 4),
(455, 4),
(456, 4),
(457, 4),
(458, 4),
(459, 42),
(460, 42),
(461, 92),
(462, 37),
(463, 28),
(464, 28),
(465, 28),
(466, 28),
(467, 28),
(468, 28),
(469, 50),
(470, 93),
(471, 50),
(472, 3),
(472, 50),
(473, 50),
(474, 50),
(475, 94),
(476, 95),
(477, 28),
(478, 2),
(479, 96),
(480, 97),
(481, 91),
(481, 98),
(482, 52),
(482, 129),
(483, 28),
(484, 28),
(485, 99),
(486, 100),
(487, 101),
(488, 101),
(489, 21),
(490, 21),
(491, 60),
(492, 42),
(493, 250),
(494, 7),
(495, 7),
(496, 9),
(497, 9),
(498, 7),
(499, 7),
(500, 7),
(501, 7),
(502, 7),
(503, 7),
(504, 7),
(505, 7),
(506, 7),
(507, 7),
(508, 7),
(509, 7),
(510, 7),
(511, 7),
(512, 9),
(513, 7),
(514, 7),
(515, 7),
(516, 7),
(517, 7),
(518, 7),
(519, 7),
(520, 7),
(521, 7),
(522, 60),
(522, 102),
(522, 267),
(523, 103),
(524, 104),
(525, 104),
(526, 5),
(527, 105),
(528, 7),
(529, 7),
(530, 106),
(531, 21),
(532, 4),
(532, 250),
(533, 22),
(534, 107),
(534, 407),
(535, 108),
(536, 109),
(537, 7),
(537, 110),
(538, 111),
(539, 112),
(540, 111),
(541, 113),
(542, 250),
(543, 250),
(544, 250),
(545, 250),
(546, 4),
(547, 42),
(548, 114),
(549, 4),
(550, 4),
(551, 2),
(552, 114),
(553, 114),
(554, 114),
(555, 115),
(556, 4),
(557, 77),
(558, 5),
(559, 116),
(560, 42),
(561, 28),
(562, 28),
(563, 7),
(564, 7),
(565, 7),
(566, 7),
(567, 42),
(568, 21),
(568, 42),
(569, 42),
(570, 42),
(571, 42),
(572, 42),
(573, 67),
(574, 117),
(575, 118),
(576, 119),
(577, 70),
(578, 120),
(578, 233),
(578, 502),
(578, 557),
(579, 7),
(580, 121),
(581, 22),
(582, 88),
(583, 122),
(584, 13),
(585, 250),
(586, 42),
(587, 42),
(588, 76),
(589, 13),
(590, 77),
(591, 77),
(592, 77),
(593, 77),
(594, 77),
(595, 123),
(596, 77),
(596, 261),
(597, 124),
(598, 125),
(599, 77),
(600, 91),
(601, 30),
(602, 127),
(603, 52),
(604, 52),
(605, 52),
(606, 52),
(607, 52),
(608, 91),
(609, 91),
(609, 128),
(609, 165),
(610, 129),
(611, 130),
(612, 129),
(613, 131),
(614, 21),
(615, 21),
(616, 21),
(617, 60),
(618, 2),
(619, 2),
(620, 2),
(621, 2),
(622, 2),
(623, 2),
(624, 2),
(625, 2),
(626, 2),
(627, 2),
(628, 2),
(629, 2),
(630, 2),
(631, 2),
(632, 2),
(633, 2),
(634, 2),
(635, 18),
(636, 18),
(637, 18),
(638, 18),
(639, 132),
(640, 42),
(641, 6),
(642, 6),
(643, 7),
(643, 24),
(644, 133),
(645, 134),
(646, 135),
(647, 109),
(648, 136),
(649, 54),
(650, 37),
(651, 37),
(652, 250),
(653, 137),
(654, 138),
(655, 250),
(656, 139),
(657, 138),
(658, 3),
(658, 77),
(659, 77),
(660, 42),
(661, 29),
(662, 9),
(663, 28),
(664, 28),
(665, 28),
(666, 28),
(667, 140),
(668, 140),
(669, 140),
(670, 140),
(671, 140),
(672, 141),
(673, 142),
(674, 143),
(675, 141),
(676, 141),
(677, 141),
(678, 141),
(679, 144),
(680, 31),
(680, 145),
(680, 461),
(681, 7),
(682, 7),
(683, 7),
(684, 7),
(685, 7),
(686, 7),
(687, 7),
(688, 7),
(689, 7),
(690, 7),
(691, 7),
(692, 7),
(693, 7),
(694, 7),
(695, 7),
(696, 7),
(697, 7),
(698, 7),
(699, 7),
(700, 7),
(701, 7),
(702, 7),
(703, 7),
(704, 7),
(705, 7),
(706, 7),
(707, 7),
(708, 7),
(709, 7),
(710, 7),
(711, 7),
(712, 7),
(713, 7),
(714, 7),
(715, 7),
(716, 7),
(717, 7),
(718, 7),
(719, 7),
(720, 7),
(721, 7),
(722, 7),
(723, 7),
(724, 7),
(725, 7),
(726, 7),
(727, 7),
(728, 7),
(729, 7),
(730, 7),
(731, 7),
(732, 7),
(733, 146),
(734, 250),
(735, 109),
(736, 147),
(737, 21),
(738, 21),
(739, 21),
(740, 21),
(741, 21),
(742, 21),
(743, 21),
(744, 21),
(745, 21),
(746, 21),
(747, 21),
(748, 21),
(749, 21),
(750, 21),
(751, 21),
(752, 21),
(753, 21),
(754, 21),
(755, 21),
(756, 21),
(757, 21),
(758, 21),
(759, 21),
(760, 21),
(761, 21),
(762, 21),
(763, 21),
(764, 21),
(765, 21),
(766, 21),
(767, 21),
(768, 21),
(769, 21),
(770, 21),
(771, 21),
(772, 21),
(773, 21),
(774, 250),
(775, 250),
(776, 250),
(777, 250),
(778, 250),
(779, 250),
(780, 250),
(781, 250),
(782, 250),
(783, 148),
(784, 149),
(785, 149),
(786, 60),
(787, 60),
(788, 60),
(789, 149),
(790, 149),
(791, 149),
(792, 60),
(793, 60),
(794, 9),
(795, 103),
(796, 6),
(797, 141),
(798, 141),
(799, 82),
(800, 103),
(801, 103),
(802, 60),
(803, 5),
(804, 9),
(805, 62),
(806, 103),
(807, 9),
(808, 9),
(809, 103),
(810, 140),
(811, 37),
(812, 28),
(813, 103),
(814, 21),
(815, 150),
(816, 150),
(817, 151),
(818, 152),
(819, 86),
(820, 86),
(821, 86),
(822, 153),
(822, 154),
(823, 4),
(824, 4),
(825, 4),
(826, 154),
(827, 4),
(828, 4),
(829, 4),
(830, 4),
(831, 4),
(832, 4),
(832, 22),
(833, 4),
(834, 4),
(835, 4),
(836, 4),
(837, 4),
(838, 4),
(839, 4),
(840, 4),
(841, 4),
(842, 4),
(843, 4),
(844, 4),
(845, 4),
(846, 4),
(847, 4),
(848, 4),
(849, 4),
(850, 4),
(851, 4),
(852, 4),
(853, 4),
(854, 4),
(855, 4),
(856, 4),
(857, 4),
(858, 4),
(859, 4),
(860, 4),
(861, 4),
(862, 4),
(863, 4),
(864, 4),
(865, 4),
(866, 4),
(867, 4),
(868, 4),
(869, 4),
(870, 4),
(871, 4),
(872, 4),
(873, 4),
(874, 4),
(875, 4),
(876, 4),
(877, 4),
(878, 4),
(879, 4),
(880, 4),
(881, 4),
(882, 4),
(883, 30),
(884, 5),
(885, 5),
(886, 5),
(887, 5),
(888, 5),
(889, 5),
(890, 5),
(891, 30),
(892, 30),
(893, 30),
(894, 30),
(895, 30),
(896, 24),
(897, 155),
(898, 125),
(899, 250),
(900, 250),
(901, 250),
(902, 28),
(903, 28),
(904, 28),
(905, 28),
(906, 28),
(907, 121),
(908, 156),
(909, 156),
(910, 50),
(911, 50),
(912, 50),
(913, 50),
(914, 50),
(915, 50),
(916, 50),
(917, 50),
(918, 50),
(919, 50),
(920, 50),
(921, 50),
(922, 50),
(923, 28),
(924, 28),
(925, 28),
(926, 28),
(927, 28),
(928, 28),
(929, 157),
(930, 157),
(931, 5),
(932, 5),
(933, 5),
(934, 5),
(935, 158),
(936, 52),
(937, 52),
(937, 91),
(938, 52),
(939, 52),
(940, 30),
(940, 52),
(940, 252),
(941, 52),
(942, 52),
(943, 28),
(944, 28),
(945, 28),
(946, 99),
(947, 159),
(948, 99),
(949, 154),
(950, 154),
(951, 42),
(952, 42),
(953, 160),
(954, 160),
(955, 160),
(956, 160),
(957, 160),
(958, 160),
(959, 54),
(960, 54),
(961, 5),
(962, 29),
(963, 29),
(964, 29),
(965, 27),
(966, 27),
(967, 161),
(968, 100),
(969, 2),
(970, 2),
(971, 100),
(972, 42),
(973, 13),
(974, 13),
(975, 13),
(976, 162),
(977, 126),
(978, 21),
(979, 21),
(980, 21),
(981, 163),
(982, 57),
(983, 57),
(984, 108),
(985, 163),
(986, 13),
(987, 60),
(988, 60),
(989, 164),
(990, 22),
(991, 166),
(992, 5),
(993, 5),
(994, 5),
(995, 5),
(996, 167),
(997, 30),
(998, 24),
(999, 250),
(1000, 250),
(1001, 5),
(1002, 168),
(1003, 7),
(1004, 7),
(1005, 7),
(1006, 7),
(1007, 7),
(1008, 7),
(1009, 7),
(1010, 7),
(1011, 7),
(1012, 7),
(1013, 7),
(1014, 7),
(1015, 9),
(1016, 9),
(1017, 9),
(1018, 9),
(1019, 9),
(1020, 9),
(1021, 7),
(1022, 7),
(1023, 7),
(1024, 7),
(1025, 7),
(1026, 7),
(1027, 7),
(1028, 7),
(1029, 7),
(1030, 7),
(1031, 7),
(1032, 7),
(1033, 7),
(1034, 7),
(1035, 7),
(1036, 7),
(1037, 7),
(1038, 7),
(1039, 7),
(1040, 7),
(1041, 7),
(1042, 7),
(1043, 7),
(1044, 7),
(1045, 7),
(1046, 7),
(1047, 7),
(1048, 7),
(1049, 7),
(1050, 7),
(1051, 9),
(1052, 9),
(1053, 159),
(1054, 159),
(1055, 9),
(1056, 9),
(1057, 7),
(1058, 7),
(1059, 7),
(1060, 7),
(1061, 7),
(1062, 7),
(1063, 7),
(1064, 7),
(1065, 7),
(1066, 7),
(1067, 7),
(1068, 7),
(1069, 7),
(1070, 5),
(1071, 5),
(1072, 169),
(1073, 157),
(1074, 5),
(1075, 5),
(1076, 5),
(1076, 159),
(1077, 5),
(1078, 159),
(1079, 7),
(1080, 7),
(1081, 7),
(1082, 7),
(1083, 105),
(1084, 5),
(1085, 5),
(1086, 5),
(1087, 5),
(1088, 5),
(1089, 5),
(1090, 170),
(1091, 170),
(1092, 169),
(1093, 171),
(1094, 172),
(1095, 21),
(1096, 103),
(1097, 5),
(1098, 5),
(1099, 6),
(1100, 5),
(1101, 5),
(1102, 5),
(1103, 5),
(1104, 5),
(1105, 5),
(1106, 5),
(1107, 5),
(1108, 5),
(1109, 5),
(1110, 21),
(1111, 62),
(1112, 173),
(1113, 42),
(1114, 22),
(1115, 174),
(1116, 5),
(1116, 73),
(1116, 175),
(1117, 176),
(1118, 177),
(1119, 178),
(1120, 178),
(1121, 178),
(1122, 179),
(1123, 111),
(1124, 111),
(1125, 181),
(1126, 65),
(1127, 250),
(1128, 250),
(1129, 250),
(1130, 250),
(1131, 250),
(1132, 250),
(1133, 250),
(1134, 250),
(1135, 250),
(1136, 4),
(1137, 21),
(1138, 182),
(1139, 183),
(1140, 42),
(1141, 4),
(1142, 4),
(1143, 10),
(1144, 2),
(1145, 2),
(1146, 115),
(1147, 184),
(1148, 42),
(1149, 42),
(1150, 28),
(1151, 28),
(1152, 28),
(1153, 28),
(1154, 28),
(1155, 28),
(1156, 28),
(1157, 28),
(1158, 28),
(1159, 28),
(1160, 28),
(1161, 28),
(1162, 28),
(1163, 28),
(1164, 185),
(1165, 3),
(1165, 77),
(1166, 7),
(1167, 7),
(1168, 42),
(1169, 42),
(1170, 42),
(1171, 42),
(1172, 42),
(1173, 42),
(1173, 99),
(1174, 42),
(1175, 42),
(1176, 42),
(1177, 186),
(1178, 187),
(1179, 188),
(1180, 189),
(1181, 21),
(1182, 28),
(1182, 42),
(1183, 190),
(1184, 24),
(1185, 24),
(1186, 24),
(1187, 48),
(1188, 24),
(1189, 7),
(1190, 7),
(1191, 4),
(1191, 159),
(1192, 4),
(1193, 4),
(1194, 28),
(1195, 28),
(1196, 28),
(1197, 24),
(1198, 44),
(1199, 28),
(1200, 7),
(1201, 7),
(1202, 7),
(1203, 7),
(1204, 21),
(1205, 30),
(1206, 28),
(1206, 30),
(1207, 28),
(1208, 28),
(1209, 7),
(1210, 7),
(1211, 12),
(1212, 30),
(1213, 44),
(1214, 9),
(1215, 24),
(1216, 24),
(1217, 24),
(1218, 17),
(1219, 17),
(1220, 48),
(1221, 48),
(1222, 191),
(1223, 35),
(1224, 75),
(1225, 140),
(1226, 7),
(1227, 7),
(1228, 7),
(1229, 7),
(1230, 7),
(1231, 7),
(1232, 7),
(1233, 7),
(1234, 7),
(1235, 7),
(1236, 250),
(1237, 192),
(1238, 193),
(1239, 194),
(1240, 28),
(1241, 28),
(1242, 28),
(1243, 28),
(1244, 28),
(1245, 161),
(1246, 101),
(1247, 21),
(1248, 60),
(1249, 7),
(1250, 7),
(1251, 7),
(1252, 7),
(1253, 7),
(1254, 7),
(1255, 7),
(1256, 7),
(1257, 44),
(1258, 42),
(1258, 115),
(1259, 12),
(1260, 22),
(1261, 44),
(1262, 28),
(1263, 28),
(1264, 127),
(1265, 91),
(1266, 91),
(1266, 126),
(1266, 449),
(1267, 91),
(1268, 13),
(1268, 24),
(1269, 30),
(1270, 24),
(1271, 24),
(1272, 24),
(1273, 91),
(1273, 195),
(1274, 196),
(1275, 24),
(1275, 479),
(1276, 24),
(1277, 127),
(1278, 91),
(1278, 129),
(1279, 52),
(1280, 129),
(1281, 21),
(1282, 21),
(1283, 60),
(1284, 60),
(1285, 197),
(1286, 2),
(1287, 2),
(1288, 2),
(1289, 2),
(1290, 198),
(1291, 18),
(1292, 44),
(1293, 44),
(1294, 44),
(1295, 44),
(1296, 199),
(1297, 48),
(1298, 160),
(1299, 200),
(1300, 42),
(1301, 12),
(1302, 37),
(1303, 37),
(1304, 201),
(1305, 201),
(1306, 202),
(1307, 24),
(1308, 203),
(1309, 7),
(1310, 204),
(1311, 205),
(1312, 206),
(1313, 141),
(1314, 141),
(1315, 141),
(1316, 207),
(1317, 7),
(1318, 7),
(1319, 7),
(1320, 7),
(1321, 7),
(1322, 7),
(1323, 7),
(1324, 7),
(1325, 7),
(1326, 7),
(1327, 7),
(1328, 7),
(1329, 7),
(1330, 7),
(1331, 7),
(1332, 7),
(1333, 7),
(1334, 7),
(1335, 7),
(1336, 7),
(1337, 7),
(1338, 7),
(1339, 7),
(1340, 7),
(1341, 7),
(1342, 7),
(1343, 7),
(1344, 21),
(1345, 21),
(1346, 21),
(1347, 21),
(1348, 21),
(1349, 21),
(1350, 21),
(1351, 21),
(1352, 21),
(1353, 21),
(1354, 21),
(1355, 21),
(1356, 21),
(1357, 21),
(1358, 21),
(1359, 21),
(1360, 21),
(1361, 21),
(1362, 21),
(1363, 21),
(1364, 21),
(1365, 21),
(1366, 250),
(1367, 250),
(1368, 250),
(1369, 250),
(1370, 250),
(1371, 250),
(1372, 60),
(1373, 60),
(1374, 60),
(1375, 60),
(1376, 60),
(1377, 60),
(1378, 60),
(1379, 154),
(1380, 103),
(1381, 103),
(1382, 103),
(1383, 103),
(1384, 208),
(1385, 30),
(1386, 30),
(1387, 209),
(1388, 14),
(1389, 210),
(1390, 211),
(1390, 509),
(1390, 564),
(1391, 4),
(1392, 159),
(1393, 159),
(1394, 4),
(1395, 4),
(1396, 4),
(1397, 4),
(1398, 4),
(1399, 4),
(1400, 4),
(1401, 4),
(1402, 4),
(1403, 4),
(1404, 4),
(1405, 4),
(1406, 4),
(1407, 4),
(1408, 4),
(1409, 4),
(1410, 4),
(1411, 4),
(1412, 4),
(1413, 4),
(1414, 4),
(1415, 4),
(1416, 4),
(1417, 4),
(1418, 4),
(1419, 4),
(1420, 4),
(1421, 4),
(1422, 4),
(1423, 4),
(1424, 4),
(1425, 4),
(1426, 4),
(1427, 4),
(1428, 4),
(1429, 4),
(1430, 4),
(1431, 194),
(1432, 194),
(1433, 12),
(1434, 185),
(1435, 12),
(1436, 12),
(1437, 12),
(1438, 212),
(1439, 30),
(1440, 213),
(1440, 511),
(1440, 566),
(1441, 157),
(1442, 121),
(1443, 214),
(1444, 215),
(1445, 28),
(1446, 50),
(1447, 50),
(1448, 50),
(1449, 50),
(1450, 50),
(1451, 50),
(1452, 50),
(1453, 50),
(1454, 50),
(1455, 163),
(1456, 28),
(1457, 28),
(1458, 5),
(1459, 250),
(1460, 52),
(1461, 52),
(1462, 52),
(1463, 52),
(1464, 52),
(1465, 52),
(1466, 52),
(1467, 159),
(1468, 154),
(1469, 42),
(1470, 216),
(1471, 160),
(1472, 160),
(1473, 160),
(1474, 160),
(1475, 160),
(1476, 54),
(1477, 54),
(1478, 161),
(1479, 29),
(1480, 29),
(1481, 29),
(1482, 101),
(1483, 111),
(1484, 217),
(1485, 218),
(1486, 163),
(1487, 219),
(1488, 219),
(1489, 219),
(1490, 220),
(1491, 221),
(1492, 44),
(1493, 44),
(1494, 222),
(1495, 24),
(1495, 256),
(1496, 203),
(1497, 7),
(1498, 7),
(1499, 7),
(1500, 7),
(1501, 7),
(1502, 7),
(1503, 76),
(1504, 76),
(1505, 159),
(1506, 7),
(1507, 7),
(1508, 7),
(1509, 7),
(1510, 7),
(1511, 7),
(1512, 7),
(1513, 7),
(1514, 7),
(1515, 7),
(1516, 7),
(1517, 7),
(1518, 7),
(1519, 7),
(1520, 7),
(1521, 7),
(1522, 7),
(1523, 7),
(1524, 7),
(1525, 7),
(1526, 12),
(1527, 12),
(1528, 159),
(1529, 159),
(1530, 9),
(1531, 7),
(1532, 7),
(1533, 7),
(1534, 7),
(1535, 7),
(1536, 7),
(1537, 7),
(1538, 7),
(1539, 7),
(1540, 159),
(1541, 12),
(1541, 103),
(1542, 7),
(1543, 7),
(1544, 7),
(1545, 7),
(1546, 7),
(1547, 5),
(1547, 12),
(1548, 12),
(1549, 12),
(1549, 185),
(1550, 12),
(1551, 12),
(1551, 185),
(1552, 12),
(1553, 12),
(1554, 223),
(1555, 172),
(1556, 21),
(1557, 157),
(1558, 91),
(1558, 224),
(1559, 225),
(1560, 5),
(1561, 5),
(1562, 12),
(1563, 12),
(1564, 12),
(1565, 12),
(1566, 159),
(1567, 12),
(1568, 61),
(1568, 255),
(1569, 178),
(1570, 65),
(1571, 65),
(1572, 44),
(1573, 27),
(1574, 226),
(1575, 250),
(1576, 250),
(1577, 103),
(1578, 42),
(1579, 227),
(1580, 4),
(1581, 4),
(1582, 228),
(1583, 115),
(1584, 168),
(1585, 21),
(1586, 28),
(1587, 28),
(1588, 28),
(1589, 28),
(1590, 28),
(1591, 28),
(1592, 28),
(1593, 28),
(1594, 7),
(1595, 21),
(1596, 42),
(1597, 42),
(1598, 42),
(1599, 229),
(1600, 230),
(1601, 231),
(1602, 232),
(1603, 70),
(1604, 161),
(1605, 161),
(1606, 2),
(1607, 109),
(1608, 24),
(1609, 234),
(1610, 24),
(1611, 12),
(1612, 12),
(1613, 12),
(1614, 5),
(1615, 5),
(1615, 12),
(1616, 235),
(1617, 7),
(1618, 7),
(1619, 7),
(1620, 7),
(1621, 7),
(1622, 7),
(1623, 7),
(1624, 7),
(1625, 7),
(1626, 7),
(1627, 7),
(1628, 7),
(1629, 7),
(1630, 7),
(1631, 7),
(1632, 7),
(1633, 7),
(1634, 21),
(1635, 21),
(1636, 21),
(1637, 21),
(1638, 4),
(1639, 4),
(1640, 4),
(1641, 4),
(1642, 4),
(1643, 4),
(1644, 236),
(1644, 268),
(1645, 156),
(1646, 65),
(1647, 27),
(1648, 236),
(1649, 44),
(1650, 7),
(1651, 7),
(1652, 7),
(1653, 7),
(1654, 7),
(1655, 7),
(1656, 7),
(1657, 7),
(1658, 7),
(1659, 7),
(1660, 7),
(1661, 7),
(1662, 12),
(1663, 7),
(1664, 7),
(1665, 7),
(1666, 7),
(1667, 7),
(1668, 7),
(1669, 7),
(1670, 172),
(1671, 12),
(1672, 237),
(1673, 238),
(1674, 239),
(1675, 27),
(1676, 7),
(1677, 27),
(1678, 35),
(1679, 30),
(1680, 28),
(1681, 240),
(1682, 240),
(1683, 7),
(1684, 6),
(1685, 84),
(1686, 4),
(1687, 7),
(1688, 21),
(1689, 6),
(1690, 28),
(1691, 28),
(1692, 72),
(1693, 28),
(1694, 21),
(1695, 28),
(1696, 28),
(1697, 151),
(1698, 241),
(1699, 147),
(1700, 250),
(1701, 4),
(1702, 28),
(1703, 21),
(1704, 21),
(1705, 21),
(1706, 242),
(1707, 42),
(1708, 21),
(1709, 4),
(1710, 243),
(1711, 30),
(1712, 108),
(1713, 108),
(1714, 115),
(1715, 72),
(1716, 42),
(1717, 42),
(1718, 52),
(1719, 250),
(1720, 77),
(1721, 5),
(1721, 244),
(1722, 72),
(1723, 72),
(1724, 72),
(1725, 111),
(1726, 245),
(1727, 245),
(1728, 245),
(1729, 245),
(1730, 245),
(1731, 245),
(1732, 7),
(1733, 42),
(1734, 42),
(1735, 6),
(1736, 8),
(1737, 8),
(1738, 8),
(1739, 6),
(1740, 3),
(1740, 6),
(1741, 5),
(1742, 21),
(1743, 21),
(1744, 21),
(1745, 21),
(1746, 21),
(1747, 7),
(1748, 48),
(1749, 44),
(1750, 21),
(1751, 21),
(1752, 4),
(1753, 4),
(1754, 7),
(1755, 7),
(1756, 35),
(1757, 21),
(1758, 21),
(1759, 21),
(1760, 21),
(1761, 21),
(1762, 21),
(1763, 4),
(1764, 4),
(1765, 4),
(1766, 4),
(1767, 246),
(1768, 3),
(1769, 3),
(1770, 7),
(1771, 7),
(1772, 42),
(1773, 24),
(1774, 103),
(1775, 21),
(1776, 21),
(1777, 21),
(1778, 21),
(1779, 21),
(1780, 21),
(1781, 21),
(1782, 21),
(1783, 21),
(1784, 21),
(1785, 4),
(1786, 247),
(1787, 3),
(1788, 3),
(1789, 3),
(1790, 3),
(1791, 3),
(1792, 3),
(1793, 3),
(1794, 7),
(1795, 7),
(1796, 7),
(1797, 7),
(1798, 7),
(1799, 7),
(1800, 7),
(1801, 246),
(1802, 42),
(1803, 21),
(1804, 21),
(1805, 21),
(1806, 21),
(1807, 21),
(1808, 21),
(1809, 21),
(1810, 21),
(1811, 21),
(1812, 21),
(1813, 21),
(1814, 3),
(1815, 3),
(1816, 3),
(1817, 3),
(1818, 3),
(1819, 3),
(1820, 248),
(1821, 3),
(1822, 7),
(1823, 7),
(1824, 24),
(1825, 24),
(1826, 24),
(1827, 3),
(1828, 3),
(1829, 3),
(1830, 3),
(1831, 3),
(1832, 3),
(1833, 3),
(1834, 3),
(1835, 3),
(1836, 3),
(1837, 3),
(1838, 3),
(1838, 77),
(1839, 3),
(1840, 3),
(1841, 3),
(1842, 3),
(1843, 3),
(1844, 3),
(1845, 3),
(1846, 3),
(1847, 3),
(1848, 3),
(1849, 3),
(1850, 3),
(1851, 3),
(1852, 3),
(1853, 3),
(1854, 3),
(1855, 3),
(1856, 3),
(1857, 3),
(1858, 3),
(1859, 3),
(1860, 3),
(1861, 3),
(1862, 3),
(1863, 3),
(1864, 3),
(1865, 3),
(1866, 3),
(1867, 3),
(1868, 3),
(1869, 3),
(1870, 3),
(1871, 3),
(1872, 3),
(1873, 3),
(1874, 3),
(1875, 3),
(1876, 3),
(1877, 3),
(1878, 3),
(1879, 3),
(1880, 3),
(1881, 3),
(1882, 3),
(1883, 3),
(1884, 3),
(1885, 3),
(1886, 3),
(1887, 3),
(1888, 3),
(1889, 3),
(1890, 3),
(1891, 3),
(1892, 3),
(1893, 3),
(1894, 3),
(1895, 3),
(1896, 3),
(1897, 3),
(1898, 3),
(1899, 3),
(1900, 3),
(1901, 3),
(1902, 3),
(1903, 3),
(1904, 3),
(1905, 3),
(1906, 3),
(1907, 3),
(1908, 3),
(1909, 3),
(1910, 3),
(1911, 3),
(1912, 3),
(1913, 3),
(1914, 3),
(1915, 3),
(1916, 3),
(1917, 3),
(1918, 3),
(1919, 3),
(1920, 3),
(1921, 3),
(1922, 3),
(1923, 3),
(1924, 3),
(1924, 257),
(1925, 3),
(1926, 3),
(1927, 3),
(1928, 3),
(1929, 3),
(1930, 3),
(1931, 3),
(1932, 3),
(1933, 3),
(1934, 3),
(1935, 3),
(1936, 3),
(1937, 3),
(1938, 3),
(1939, 3),
(1940, 3),
(1941, 3),
(1942, 3),
(1943, 3),
(1944, 3),
(1945, 3),
(1946, 3),
(1947, 3),
(1948, 3),
(1949, 3),
(1950, 3),
(1951, 3),
(1952, 3),
(1953, 3),
(1954, 3),
(1955, 3),
(1956, 3),
(1957, 3),
(1958, 3),
(1959, 3),
(1960, 3),
(1961, 3),
(1962, 3),
(1963, 3),
(1964, 3),
(1965, 3),
(1966, 3),
(1967, 249),
(1968, 3),
(1968, 70),
(1969, 3),
(1969, 70),
(1970, 3),
(1971, 3),
(1972, 3),
(1973, 3),
(1973, 257),
(1974, 3),
(1975, 3),
(1976, 3),
(1977, 3),
(1978, 3),
(1979, 3),
(1980, 3),
(1981, 3),
(1982, 3),
(1983, 3),
(1984, 3),
(1985, 3),
(1986, 3),
(1987, 3),
(1988, 3),
(1989, 3),
(1990, 3),
(1991, 3),
(1992, 3),
(1993, 3),
(1994, 3),
(1995, 3),
(1996, 3),
(1997, 3),
(1998, 3),
(1999, 3),
(2000, 3),
(2001, 3),
(2002, 3),
(2003, 3),
(2004, 3),
(2004, 257),
(2005, 3),
(2006, 3),
(2006, 198),
(2006, 256),
(2007, 3),
(2008, 3),
(2009, 3),
(2010, 3),
(2011, 3),
(2012, 3),
(2013, 3),
(2014, 3),
(2015, 3),
(2016, 3),
(2017, 3),
(2018, 3),
(2019, 3),
(2020, 3),
(2021, 3),
(2022, 3),
(2022, 4),
(2023, 3),
(2024, 3),
(2025, 3),
(2026, 3),
(2027, 3),
(2028, 3),
(2029, 3),
(2030, 3),
(2031, 3),
(2032, 3),
(2033, 3),
(2034, 3),
(2035, 3),
(2036, 3),
(2037, 3),
(2038, 3),
(2039, 3),
(2040, 3),
(2041, 3),
(2042, 3),
(2043, 3),
(2044, 3),
(2045, 3),
(2046, 3),
(2047, 3),
(2048, 3),
(2049, 3),
(2050, 3),
(2051, 3),
(2052, 3),
(2053, 3),
(2054, 3),
(2055, 3),
(2056, 3),
(2057, 3),
(2058, 3),
(2059, 3),
(2060, 3),
(2061, 3),
(2062, 3),
(2063, 3),
(2064, 3),
(2065, 3),
(2066, 3),
(2067, 3),
(2068, 3),
(2069, 3),
(2070, 3),
(2071, 3),
(2072, 3),
(2073, 3),
(2074, 3),
(2075, 3),
(2076, 3),
(2077, 3),
(2078, 3),
(2079, 3),
(2080, 3),
(2081, 3),
(2082, 3),
(2083, 3),
(2084, 3),
(2085, 3),
(2086, 3),
(2087, 3),
(2088, 3),
(2089, 3),
(2090, 3),
(2091, 3),
(2092, 3),
(2093, 3),
(2094, 3),
(2095, 3),
(2096, 3),
(2097, 3),
(2098, 3),
(2099, 3),
(2100, 3),
(2101, 3),
(2102, 3),
(2103, 3),
(2104, 3),
(2105, 3),
(2106, 3),
(2107, 3),
(2108, 3),
(2109, 3),
(2109, 60),
(2109, 168),
(2109, 256),
(2109, 264),
(2109, 430),
(2110, 3),
(2111, 3),
(2112, 3),
(2113, 3),
(2114, 3),
(2114, 4),
(2115, 3),
(2116, 3),
(2117, 3),
(2118, 3),
(2119, 3),
(2120, 3),
(2121, 3),
(2122, 3),
(2123, 3),
(2124, 3),
(2125, 3),
(2126, 3),
(2127, 3),
(2128, 3),
(2129, 3),
(2130, 3),
(2131, 3),
(2132, 3),
(2133, 3),
(2134, 3),
(2135, 3),
(2136, 3),
(2137, 3),
(2138, 3),
(2139, 3),
(2140, 3),
(2141, 3),
(2142, 3),
(2143, 3),
(2144, 3),
(2145, 3),
(2146, 3),
(2147, 3),
(2148, 3),
(2149, 3),
(2150, 3),
(2151, 3),
(2152, 3),
(2153, 3),
(2154, 3),
(2155, 3),
(2156, 3),
(2157, 3),
(2158, 3),
(2159, 3),
(2160, 3),
(2161, 3),
(2162, 3),
(2163, 3),
(2164, 3),
(2165, 3),
(2166, 3),
(2167, 3),
(2168, 3),
(2169, 3),
(2170, 3),
(2171, 3),
(2172, 3),
(2173, 3),
(2174, 3),
(2175, 3),
(2176, 3),
(2177, 3),
(2178, 3),
(2179, 3),
(2179, 60),
(2180, 3),
(2181, 3),
(2182, 3),
(2183, 3),
(2184, 3),
(2185, 3),
(2186, 3),
(2187, 3),
(2188, 3),
(2189, 3),
(2190, 3),
(2191, 3),
(2192, 3),
(2193, 3),
(2194, 3),
(2195, 3),
(2196, 3),
(2197, 3),
(2198, 3),
(2199, 3),
(2200, 3),
(2201, 3),
(2202, 3),
(2203, 3),
(2204, 3),
(2205, 3),
(2206, 251),
(2206, 369),
(2206, 378),
(2206, 457),
(2207, 3),
(2208, 3),
(2209, 3),
(2210, 3),
(2211, 3),
(2212, 3),
(2213, 3),
(2214, 3),
(2215, 3),
(2216, 3),
(2217, 3),
(2218, 3),
(2219, 3),
(2220, 3),
(2221, 3),
(2222, 3),
(2223, 3),
(2224, 3),
(2225, 3),
(2226, 3),
(2227, 3),
(2228, 3),
(2229, 3),
(2230, 3),
(2231, 3),
(2232, 3),
(2233, 3),
(2234, 3),
(2235, 3),
(2236, 3),
(2237, 3),
(2238, 3),
(2239, 3),
(2240, 3),
(2241, 3),
(2242, 3),
(2243, 3),
(2244, 3),
(2245, 3),
(2246, 3),
(2247, 3),
(2248, 3),
(2249, 3),
(2250, 3),
(2251, 3),
(2252, 3),
(2253, 3),
(2254, 3),
(2255, 3),
(2256, 3),
(2257, 3),
(2258, 3),
(2259, 3),
(2260, 3),
(2261, 3),
(2262, 3),
(2263, 3),
(2264, 3),
(2265, 3),
(2266, 3),
(2267, 3),
(2268, 3),
(2269, 3),
(2270, 3),
(2271, 3),
(2272, 3),
(2273, 3),
(2274, 3),
(2275, 3),
(2276, 3),
(2277, 3),
(2278, 3),
(2279, 3),
(2280, 3),
(2281, 3),
(2282, 3),
(2283, 3),
(2284, 3),
(2285, 3),
(2286, 3),
(2287, 3),
(2288, 3),
(2289, 3),
(2290, 3),
(2291, 3),
(2292, 3),
(2293, 3),
(2294, 3),
(2295, 3),
(2296, 3),
(2297, 3),
(2298, 3),
(2299, 3),
(2300, 3),
(2301, 3),
(2302, 3),
(2303, 3),
(2304, 3),
(2305, 3),
(2306, 3),
(2307, 3),
(2308, 3),
(2309, 3),
(2310, 3),
(2311, 3),
(2312, 3),
(2313, 3),
(2314, 3),
(2315, 3),
(2316, 3),
(2316, 283),
(2317, 3),
(2318, 3),
(2319, 3),
(2320, 3),
(2321, 3),
(2322, 3),
(2323, 3),
(2324, 3),
(2325, 3),
(2326, 7),
(2327, 76),
(2328, 76),
(2329, 7),
(2330, 7),
(2331, 7),
(2332, 7),
(2333, 7),
(2334, 7),
(2335, 7),
(2336, 7),
(2337, 7),
(2338, 7),
(2339, 7),
(2340, 7),
(2341, 7),
(2342, 7),
(2343, 7),
(2344, 7),
(2345, 7),
(2346, 7),
(2347, 7),
(2348, 7),
(2349, 7),
(2350, 7),
(2351, 7),
(2352, 7),
(2353, 7),
(2354, 7),
(2355, 7),
(2356, 7),
(2357, 7),
(2358, 7),
(2359, 7),
(2360, 7),
(2361, 7),
(2362, 7),
(2363, 7),
(2364, 7),
(2365, 7),
(2366, 7),
(2367, 7),
(2368, 7),
(2369, 7),
(2370, 7),
(2371, 7),
(2372, 7),
(2373, 7),
(2374, 7),
(2375, 7),
(2376, 7),
(2377, 7),
(2378, 7),
(2379, 7),
(2380, 7),
(2381, 7),
(2382, 7),
(2383, 7),
(2384, 7),
(2385, 7),
(2386, 7),
(2387, 7),
(2388, 7),
(2389, 7),
(2390, 7),
(2391, 7),
(2392, 7),
(2393, 7),
(2394, 7),
(2395, 7),
(2396, 7),
(2397, 7),
(2398, 7),
(2399, 7),
(2400, 4),
(2400, 7),
(2401, 7),
(2402, 7),
(2403, 7),
(2404, 7),
(2405, 7),
(2406, 7),
(2406, 250),
(2407, 7),
(2408, 7),
(2409, 7),
(2410, 7),
(2411, 7),
(2412, 7),
(2413, 7),
(2414, 7),
(2415, 7),
(2416, 7),
(2417, 7),
(2418, 7),
(2419, 7),
(2420, 7),
(2421, 7),
(2422, 7),
(2423, 7),
(2424, 7),
(2425, 7),
(2426, 7),
(2427, 7),
(2428, 7),
(2429, 7),
(2430, 7),
(2431, 7),
(2432, 7),
(2433, 7),
(2434, 7),
(2435, 7),
(2436, 7),
(2437, 7),
(2438, 7),
(2439, 7),
(2440, 7),
(2441, 7),
(2442, 7),
(2443, 7),
(2444, 7),
(2445, 7),
(2446, 7),
(2447, 7),
(2448, 7),
(2449, 7),
(2450, 7),
(2451, 7),
(2452, 7),
(2453, 7),
(2454, 7),
(2455, 7),
(2456, 7),
(2457, 7),
(2458, 7),
(2459, 7),
(2460, 7),
(2461, 7),
(2462, 7),
(2463, 7),
(2464, 7),
(2465, 7),
(2466, 7),
(2467, 7),
(2468, 7),
(2469, 7),
(2470, 7),
(2471, 7),
(2472, 7),
(2473, 7),
(2474, 7),
(2475, 7),
(2476, 7),
(2477, 7),
(2478, 7),
(2479, 7),
(2480, 7),
(2481, 7),
(2482, 7),
(2483, 7),
(2484, 7),
(2485, 7),
(2486, 7),
(2487, 7),
(2488, 7),
(2489, 7),
(2490, 7),
(2491, 7),
(2492, 7),
(2493, 7),
(2494, 7),
(2495, 7),
(2496, 7),
(2497, 7),
(2498, 7),
(2499, 7),
(2500, 7),
(2501, 7),
(2502, 7),
(2503, 7),
(2504, 7),
(2505, 7),
(2506, 7),
(2507, 7),
(2508, 7),
(2509, 7),
(2510, 7),
(2511, 7),
(2512, 7),
(2513, 7),
(2514, 7),
(2515, 7),
(2516, 7),
(2517, 7),
(2518, 7),
(2519, 7),
(2520, 7),
(2521, 7),
(2522, 7),
(2523, 7),
(2524, 7),
(2525, 7),
(2526, 7),
(2527, 7),
(2528, 7),
(2529, 7),
(2530, 7),
(2531, 7),
(2532, 7),
(2533, 7),
(2534, 7),
(2535, 7),
(2536, 7),
(2537, 7),
(2538, 7),
(2539, 7),
(2540, 7),
(2541, 7),
(2542, 7),
(2543, 7),
(2544, 7),
(2545, 7),
(2546, 7),
(2547, 7),
(2548, 7),
(2549, 7),
(2550, 7),
(2551, 7),
(2552, 7),
(2553, 7),
(2554, 7),
(2555, 7),
(2556, 7),
(2557, 7),
(2558, 7),
(2559, 7),
(2560, 7),
(2561, 7),
(2562, 7),
(2563, 7),
(2564, 7),
(2565, 7),
(2566, 7),
(2567, 7),
(2568, 7),
(2569, 7),
(2570, 7),
(2571, 7),
(2572, 7),
(2573, 7),
(2574, 7),
(2575, 7),
(2576, 7),
(2577, 7),
(2578, 7),
(2579, 7),
(2580, 7),
(2581, 7),
(2582, 7),
(2583, 7),
(2584, 7),
(2585, 7),
(2586, 7),
(2587, 7),
(2588, 7),
(2589, 7),
(2590, 7),
(2591, 7),
(2592, 7),
(2593, 7),
(2594, 7),
(2595, 7),
(2596, 7),
(2597, 7),
(2598, 7),
(2599, 7),
(2600, 7),
(2601, 7),
(2602, 7),
(2603, 7),
(2604, 7),
(2605, 7),
(2606, 4),
(2606, 7),
(2607, 7),
(2608, 7),
(2609, 7),
(2610, 7),
(2611, 7),
(2612, 7),
(2613, 7),
(2614, 7),
(2615, 7),
(2616, 7),
(2617, 7),
(2618, 7),
(2619, 7),
(2620, 7),
(2621, 7),
(2622, 7),
(2623, 7),
(2624, 7),
(2625, 7),
(2626, 7),
(2627, 7),
(2628, 7),
(2629, 7),
(2630, 7),
(2631, 7),
(2632, 7),
(2633, 7),
(2634, 7),
(2635, 7),
(2636, 7),
(2637, 7),
(2638, 7),
(2639, 7),
(2640, 7),
(2641, 7),
(2642, 7),
(2643, 7),
(2644, 7),
(2645, 7),
(2646, 7),
(2647, 7),
(2648, 7),
(2649, 7),
(2650, 7),
(2651, 7),
(2652, 7),
(2653, 7),
(2654, 7),
(2655, 7),
(2656, 7),
(2657, 7),
(2658, 7),
(2659, 7),
(2660, 7),
(2661, 7),
(2662, 7),
(2663, 7),
(2664, 7),
(2665, 7),
(2666, 7),
(2667, 7),
(2668, 7),
(2669, 7),
(2670, 7),
(2671, 7),
(2672, 7),
(2673, 7),
(2674, 7),
(2675, 7),
(2676, 7),
(2677, 7),
(2678, 7),
(2679, 7),
(2680, 7),
(2681, 7),
(2682, 7),
(2683, 7),
(2684, 7),
(2685, 7),
(2686, 7),
(2687, 7),
(2688, 7),
(2689, 7),
(2690, 7),
(2691, 7),
(2692, 7),
(2693, 7),
(2694, 7),
(2695, 7),
(2696, 7),
(2697, 7),
(2698, 7),
(2699, 7),
(2700, 7),
(2701, 7),
(2702, 7),
(2703, 7),
(2704, 7),
(2705, 7),
(2706, 7),
(2707, 7),
(2708, 7),
(2709, 7),
(2710, 7),
(2711, 7),
(2712, 7),
(2713, 7),
(2714, 7),
(2715, 7),
(2716, 7),
(2717, 7),
(2718, 7),
(2719, 7),
(2720, 7),
(2721, 7),
(2722, 7),
(2723, 7),
(2724, 7),
(2725, 7),
(2726, 7),
(2727, 7),
(2728, 7),
(2729, 7),
(2730, 7),
(2731, 7),
(2732, 7),
(2733, 7),
(2734, 7),
(2735, 7),
(2736, 7),
(2737, 7),
(2738, 7),
(2739, 7),
(2740, 7),
(2741, 7),
(2742, 7),
(2743, 7),
(2744, 7),
(2745, 7),
(2746, 7),
(2747, 7),
(2748, 7),
(2749, 7),
(2750, 7),
(2751, 7),
(2752, 7),
(2753, 7),
(2754, 7),
(2755, 7),
(2756, 7),
(2757, 7),
(2758, 7),
(2759, 7),
(2760, 7),
(2761, 7),
(2762, 7),
(2763, 7),
(2764, 7),
(2765, 7),
(2766, 7),
(2767, 7),
(2768, 7),
(2769, 7),
(2770, 7),
(2771, 7),
(2772, 7),
(2773, 7),
(2774, 7),
(2775, 7),
(2776, 7),
(2777, 7),
(2778, 7),
(2779, 7),
(2780, 7),
(2781, 7),
(2782, 7),
(2783, 7),
(2784, 7),
(2785, 7),
(2786, 7),
(2787, 7),
(2788, 7),
(2789, 7),
(2790, 7),
(2791, 7),
(2792, 7),
(2793, 7),
(2794, 7),
(2795, 7),
(2796, 7),
(2797, 7),
(2798, 7),
(2799, 7),
(2800, 7),
(2801, 7),
(2802, 7),
(2803, 7),
(2804, 7),
(2805, 7),
(2806, 7),
(2807, 7),
(2808, 7),
(2809, 7),
(2810, 7),
(2811, 7),
(2812, 7),
(2813, 7),
(2814, 7),
(2815, 7),
(2816, 7),
(2817, 7),
(2818, 7),
(2819, 7),
(2820, 7),
(2821, 7),
(2822, 7),
(2823, 7),
(2824, 7),
(2825, 7),
(2826, 7),
(2827, 7),
(2828, 7),
(2829, 7),
(2830, 7),
(2831, 7),
(2832, 7),
(2833, 7),
(2834, 7),
(2835, 7),
(2836, 7),
(2837, 7),
(2838, 7),
(2839, 7),
(2840, 7),
(2841, 7),
(2842, 7),
(2843, 7),
(2844, 7),
(2845, 7),
(2846, 7),
(2847, 7),
(2848, 7),
(2849, 7),
(2850, 7),
(2851, 7),
(2852, 7),
(2853, 7),
(2854, 7),
(2855, 7),
(2856, 7),
(2857, 7),
(2858, 7),
(2859, 7),
(2860, 7),
(2861, 7),
(2862, 7),
(2863, 7),
(2864, 7),
(2865, 7),
(2866, 7),
(2867, 7),
(2868, 7),
(2869, 7),
(2870, 7),
(2871, 7),
(2872, 7),
(2873, 7),
(2874, 7),
(2875, 7),
(2876, 7),
(2877, 7),
(2878, 7),
(2879, 7),
(2880, 7),
(2881, 7),
(2882, 7),
(2883, 7),
(2884, 7),
(2885, 7),
(2886, 7),
(2887, 7),
(2888, 7),
(2889, 5),
(2889, 7),
(2890, 7),
(2891, 7),
(2892, 7),
(2893, 7),
(2894, 7),
(2895, 7),
(2896, 7),
(2897, 7),
(2898, 7),
(2899, 7),
(2900, 7),
(2901, 7),
(2902, 7),
(2903, 7),
(2904, 7),
(2905, 7),
(2906, 7),
(2907, 7),
(2908, 7),
(2909, 7),
(2910, 7),
(2911, 7),
(2912, 7),
(2913, 7),
(2914, 7),
(2915, 7),
(2916, 7),
(2917, 7),
(2918, 7),
(2919, 7),
(2920, 7),
(2921, 7),
(2922, 7),
(2923, 7),
(2924, 7),
(2925, 7),
(2926, 7),
(2927, 7),
(2928, 7),
(2929, 7),
(2930, 7),
(2931, 7),
(2932, 7),
(2933, 7),
(2934, 7),
(2935, 7),
(2936, 7),
(2937, 7),
(2938, 7),
(2939, 7),
(2940, 7),
(2941, 7),
(2942, 7),
(2943, 7),
(2944, 7),
(2945, 7),
(2946, 7),
(2947, 7),
(2948, 7),
(2949, 7),
(2950, 7),
(2951, 7),
(2952, 7),
(2953, 7),
(2954, 7),
(2955, 7),
(2956, 7),
(2957, 7),
(2958, 7),
(2959, 7),
(2960, 7),
(2961, 7),
(2962, 7),
(2963, 7),
(2964, 7),
(2965, 7),
(2966, 7),
(2967, 7),
(2968, 7),
(2969, 7),
(2970, 7),
(2971, 7),
(2972, 7),
(2973, 7),
(2974, 7),
(2975, 7),
(2976, 7),
(2977, 7),
(2978, 7),
(2979, 7),
(2980, 7),
(2981, 7),
(2982, 7),
(2983, 7),
(2984, 7),
(2985, 7),
(2986, 7),
(2987, 7),
(2988, 7),
(2989, 7),
(2990, 7),
(2991, 7),
(2992, 7),
(2993, 7),
(2994, 7),
(2995, 7),
(2996, 7),
(2997, 7),
(2998, 7),
(2999, 7),
(3000, 7),
(3001, 7),
(3002, 7),
(3003, 7),
(3004, 7),
(3005, 7),
(3006, 7),
(3007, 7),
(3008, 7),
(3009, 7),
(3010, 7),
(3011, 7),
(3012, 7),
(3013, 7),
(3014, 7),
(3015, 7),
(3016, 7),
(3017, 7),
(3018, 7),
(3019, 7),
(3020, 7),
(3021, 7),
(3022, 7),
(3023, 7),
(3024, 7),
(3025, 7),
(3026, 7),
(3027, 7),
(3028, 7),
(3029, 7),
(3030, 7),
(3031, 7),
(3032, 7),
(3033, 7),
(3034, 7),
(3035, 7),
(3036, 7),
(3037, 7),
(3038, 7),
(3039, 7),
(3040, 7),
(3041, 7),
(3042, 7),
(3043, 7),
(3044, 7),
(3045, 7),
(3046, 7),
(3047, 7),
(3048, 7),
(3049, 7),
(3050, 7),
(3051, 5),
(3051, 7),
(3052, 7),
(3053, 7),
(3054, 7),
(3055, 7),
(3056, 7),
(3057, 7),
(3058, 7),
(3059, 7),
(3060, 7),
(3061, 7),
(3062, 7),
(3063, 7),
(3064, 7),
(3065, 7),
(3066, 7),
(3067, 7),
(3068, 7),
(3069, 7),
(3070, 7),
(3071, 7),
(3072, 7),
(3073, 7),
(3074, 7),
(3075, 7),
(3076, 7),
(3077, 7),
(3078, 7),
(3079, 7),
(3080, 7),
(3081, 7),
(3082, 7),
(3083, 7),
(3084, 7),
(3085, 7),
(3086, 7),
(3087, 7),
(3088, 7),
(3089, 7),
(3090, 7),
(3091, 7),
(3092, 7),
(3093, 7),
(3094, 7),
(3095, 7),
(3096, 7),
(3097, 7),
(3098, 7),
(3099, 7),
(3100, 7),
(3101, 7),
(3102, 7),
(3103, 7),
(3104, 7),
(3105, 7),
(3106, 7),
(3107, 7),
(3108, 7),
(3109, 7),
(3110, 7),
(3111, 7),
(3112, 7),
(3113, 7),
(3114, 7),
(3115, 7),
(3116, 7),
(3117, 7),
(3118, 7),
(3119, 7),
(3120, 7),
(3121, 7),
(3122, 7),
(3123, 7),
(3124, 7),
(3125, 7),
(3126, 7),
(3127, 7),
(3128, 7),
(3129, 7),
(3130, 7),
(3131, 7),
(3132, 7),
(3133, 7),
(3134, 7),
(3135, 7),
(3136, 7),
(3137, 7),
(3138, 7),
(3139, 7),
(3140, 7),
(3141, 7),
(3142, 7),
(3143, 7),
(3144, 7),
(3145, 7),
(3146, 7),
(3147, 7),
(3148, 7),
(3149, 7),
(3150, 7),
(3151, 7),
(3152, 7),
(3153, 7),
(3154, 7),
(3155, 7),
(3156, 7),
(3157, 7),
(3158, 7),
(3159, 7),
(3160, 7),
(3161, 7),
(3162, 7),
(3163, 7),
(3164, 7),
(3165, 7),
(3166, 7),
(3167, 7),
(3168, 7),
(3169, 7),
(3170, 7),
(3171, 7),
(3172, 7),
(3173, 7),
(3174, 7),
(3175, 7),
(3176, 7),
(3177, 7),
(3178, 7),
(3179, 7),
(3180, 7),
(3181, 7),
(3182, 7),
(3183, 7),
(3184, 7),
(3185, 7),
(3186, 7),
(3187, 7),
(3188, 7),
(3189, 7),
(3190, 7),
(3191, 7),
(3192, 7),
(3193, 7),
(3194, 7),
(3195, 7),
(3196, 7),
(3197, 7),
(3198, 7),
(3199, 7),
(3200, 7),
(3201, 7),
(3202, 7),
(3203, 7),
(3204, 7),
(3205, 7),
(3206, 7),
(3207, 7),
(3208, 7),
(3209, 7),
(3210, 7),
(3211, 7),
(3212, 7),
(3213, 7),
(3214, 7),
(3215, 7),
(3216, 7),
(3217, 7),
(3218, 7),
(3219, 7),
(3220, 7),
(3221, 7),
(3222, 7),
(3223, 7),
(3224, 7),
(3225, 7),
(3226, 7),
(3227, 7),
(3228, 7),
(3229, 7),
(3230, 7),
(3231, 7),
(3232, 7),
(3233, 7),
(3234, 7),
(3235, 7),
(3236, 7),
(3237, 7),
(3238, 7),
(3239, 7),
(3240, 7),
(3241, 7),
(3242, 7),
(3243, 7),
(3244, 7),
(3245, 7),
(3246, 7),
(3247, 7),
(3248, 7),
(3249, 7),
(3250, 7),
(3251, 7),
(3252, 7),
(3253, 7),
(3254, 7),
(3255, 7),
(3256, 7),
(3257, 7),
(3258, 7),
(3259, 7),
(3260, 7),
(3261, 7),
(3262, 7),
(3263, 7),
(3264, 7),
(3265, 7),
(3266, 7),
(3267, 7),
(3268, 7),
(3269, 7),
(3270, 7),
(3271, 7),
(3272, 7),
(3273, 7),
(3274, 7),
(3275, 7),
(3276, 7),
(3277, 7),
(3278, 7),
(3279, 7),
(3280, 7),
(3281, 7),
(3282, 7),
(3283, 7),
(3284, 7),
(3285, 7),
(3286, 7),
(3287, 7),
(3288, 7),
(3289, 7),
(3290, 7),
(3291, 7),
(3292, 7),
(3293, 7),
(3294, 7),
(3295, 7),
(3296, 7),
(3297, 7),
(3298, 7),
(3299, 7),
(3300, 7),
(3301, 7),
(3302, 7),
(3303, 7),
(3304, 7),
(3305, 7),
(3306, 7),
(3307, 7),
(3308, 7),
(3309, 7),
(3310, 7),
(3311, 7),
(3312, 7),
(3313, 7),
(3314, 7),
(3315, 7),
(3316, 7),
(3317, 7),
(3318, 7),
(3319, 7),
(3320, 7),
(3321, 7),
(3322, 7),
(3323, 7),
(3324, 7),
(3325, 7),
(3326, 7),
(3327, 7),
(3328, 7),
(3329, 7),
(3330, 7),
(3331, 7),
(3332, 7),
(3333, 7),
(3334, 7),
(3335, 7),
(3336, 7),
(3337, 7),
(3338, 7),
(3339, 7),
(3340, 7),
(3341, 7),
(3342, 7),
(3343, 7),
(3344, 7),
(3345, 7),
(3346, 7),
(3347, 7),
(3348, 7),
(3349, 7),
(3350, 7),
(3351, 7),
(3352, 7),
(3353, 7),
(3354, 7),
(3355, 7),
(3356, 7),
(3357, 7),
(3358, 7),
(3359, 7),
(3360, 7),
(3361, 7),
(3362, 7),
(3363, 7),
(3364, 7),
(3365, 7),
(3366, 7),
(3367, 7),
(3368, 7),
(3369, 7),
(3370, 7),
(3371, 7),
(3372, 7),
(3373, 7),
(3374, 7),
(3375, 7),
(3376, 7),
(3377, 7),
(3378, 7),
(3379, 7),
(3380, 7),
(3381, 7),
(3382, 7),
(3383, 7),
(3384, 7),
(3385, 7),
(3386, 7),
(3387, 7),
(3388, 7),
(3389, 7),
(3390, 7),
(3391, 7),
(3392, 7),
(3393, 7),
(3394, 7),
(3395, 7),
(3396, 7),
(3397, 7),
(3398, 7),
(3399, 7),
(3400, 7),
(3401, 7),
(3402, 7),
(3403, 7),
(3404, 7),
(3405, 7),
(3406, 7),
(3407, 7),
(3408, 7),
(3409, 7),
(3410, 7),
(3411, 7),
(3412, 7),
(3413, 7),
(3414, 7),
(3415, 7),
(3416, 7),
(3417, 7),
(3418, 7),
(3419, 7),
(3420, 7),
(3421, 7),
(3422, 7),
(3423, 7),
(3424, 7),
(3425, 7),
(3426, 7),
(3427, 7),
(3428, 7),
(3429, 7),
(3430, 7),
(3431, 7),
(3432, 7),
(3433, 7),
(3434, 7),
(3435, 7),
(3436, 7),
(3437, 7),
(3438, 7),
(3439, 7),
(3439, 141),
(3440, 7),
(3441, 7),
(3442, 7),
(3443, 7),
(3444, 7),
(3445, 7),
(3446, 7),
(3447, 7),
(3448, 164),
(3449, 164),
(3450, 164),
(3451, 164),
(3452, 164),
(3453, 164),
(3454, 164),
(3455, 164),
(3456, 164),
(3457, 164),
(3458, 164),
(3459, 164),
(3460, 164),
(3461, 164),
(3462, 164),
(3463, 164),
(3464, 164),
(3465, 164),
(3466, 164),
(3467, 164),
(3468, 164),
(3469, 164),
(3470, 164),
(3471, 164),
(3472, 164),
(3473, 164),
(3474, 164),
(3475, 164),
(3476, 164),
(3477, 164),
(3478, 164),
(3479, 164),
(3480, 164),
(3481, 164),
(3482, 164),
(3483, 164),
(3484, 164),
(3485, 164),
(3486, 164),
(3487, 164),
(3488, 164),
(3489, 164),
(3490, 164),
(3491, 164),
(3492, 164),
(3493, 164),
(3494, 164),
(3495, 164),
(3496, 164),
(3497, 164),
(3498, 164),
(3499, 164),
(3500, 164),
(3501, 164),
(3502, 164),
(3503, 164),
(3504, 164),
(3505, 164),
(3506, 164),
(3507, 164),
(3508, 164),
(3509, 164),
(3510, 164),
(3511, 164),
(3512, 164),
(3513, 164),
(3514, 164),
(3515, 164),
(3516, 164),
(3517, 164),
(3518, 164),
(3519, 164),
(3520, 164),
(3521, 164),
(3522, 164),
(3523, 164),
(3524, 164),
(3525, 164),
(3526, 164),
(3527, 164),
(3528, 164),
(3529, 164),
(3530, 164),
(3531, 164),
(3532, 164),
(3533, 164),
(3534, 164),
(3535, 252),
(3536, 253),
(3537, 164),
(3538, 164),
(3539, 164),
(3540, 164),
(3541, 164),
(3542, 164),
(3543, 164),
(3544, 164),
(3545, 5),
(3546, 5),
(3547, 12),
(3548, 12),
(3549, 12),
(3550, 12),
(3551, 5),
(3552, 5),
(3553, 5),
(3554, 5),
(3555, 5),
(3556, 5),
(3557, 5),
(3558, 5),
(3559, 5),
(3560, 5),
(3560, 28),
(3560, 60),
(3561, 5),
(3562, 5),
(3563, 5),
(3564, 5),
(3565, 5),
(3566, 5),
(3567, 5),
(3568, 5),
(3569, 5),
(3570, 5),
(3571, 5),
(3572, 5),
(3573, 4),
(3574, 4),
(3575, 5),
(3576, 5),
(3576, 255),
(3577, 5),
(3578, 5),
(3579, 5),
(3580, 5),
(3581, 5),
(3582, 5),
(3583, 5),
(3584, 5),
(3584, 198),
(3585, 5),
(3586, 5),
(3587, 5),
(3588, 5),
(3589, 5),
(3590, 5),
(3591, 5),
(3592, 5),
(3593, 5),
(3594, 5),
(3595, 5),
(3596, 5),
(3597, 5),
(3598, 5),
(3599, 5),
(3600, 5),
(3601, 5),
(3602, 5),
(3603, 5),
(3604, 5),
(3605, 5),
(3606, 5),
(3607, 5),
(3607, 44),
(3608, 5),
(3609, 5),
(3610, 5),
(3611, 5),
(3612, 5),
(3613, 5),
(3614, 254),
(3615, 5),
(3616, 5),
(3617, 5),
(3618, 5),
(3619, 5),
(3620, 5),
(3621, 5),
(3622, 5),
(3623, 5),
(3624, 5),
(3625, 5),
(3626, 5),
(3627, 5),
(3628, 5),
(3629, 5),
(3630, 5),
(3631, 5),
(3632, 5),
(3633, 5),
(3634, 5),
(3635, 5),
(3636, 5),
(3637, 5),
(3638, 5),
(3639, 5),
(3640, 5),
(3641, 5),
(3642, 5),
(3643, 5),
(3644, 5),
(3645, 5),
(3646, 5),
(3647, 5),
(3648, 5),
(3649, 5),
(3650, 5),
(3651, 5),
(3652, 5),
(3653, 5),
(3654, 5),
(3655, 5),
(3656, 5),
(3657, 5),
(3658, 5),
(3659, 5),
(3660, 5),
(3661, 5),
(3662, 5),
(3663, 5),
(3664, 5),
(3665, 5),
(3666, 5),
(3667, 5),
(3668, 5),
(3669, 5),
(3670, 5),
(3671, 5),
(3672, 5),
(3673, 5),
(3674, 5),
(3675, 5),
(3675, 168),
(3676, 5),
(3677, 5),
(3678, 5),
(3679, 5),
(3680, 5),
(3681, 5),
(3682, 5),
(3683, 5),
(3684, 5),
(3685, 5),
(3686, 5),
(3687, 5),
(3688, 5),
(3689, 5),
(3690, 5),
(3691, 5),
(3692, 5),
(3693, 5),
(3694, 5),
(3695, 5),
(3696, 5),
(3697, 5),
(3698, 5),
(3699, 5),
(3699, 56),
(3700, 5),
(3701, 5),
(3702, 5),
(3703, 5),
(3704, 5),
(3705, 5),
(3705, 30),
(3705, 159),
(3706, 5),
(3707, 5),
(3707, 159),
(3708, 5),
(3709, 5),
(3710, 5),
(3711, 5),
(3712, 5),
(3713, 5),
(3714, 5),
(3715, 5),
(3716, 5),
(3717, 5),
(3718, 5),
(3718, 7),
(3719, 5),
(3719, 187),
(3719, 280),
(3720, 5),
(3721, 5),
(3721, 30),
(3721, 31),
(3721, 256),
(3722, 5),
(3723, 5),
(3724, 5),
(3724, 21),
(3724, 31),
(3724, 187),
(3724, 302),
(3725, 5),
(3725, 302),
(3726, 5),
(3726, 42),
(3726, 255),
(3727, 5),
(3728, 5),
(3729, 5),
(3729, 255),
(3730, 5),
(3731, 5),
(3732, 5),
(3733, 5),
(3734, 5),
(3735, 5),
(3736, 5),
(3737, 5),
(3738, 5),
(3738, 28),
(3739, 5),
(3740, 5),
(3741, 5),
(3742, 5),
(3742, 318),
(3743, 5),
(3744, 5),
(3745, 5),
(3746, 5),
(3747, 5),
(3748, 5),
(3749, 5),
(3749, 255),
(3750, 5),
(3750, 255),
(3751, 42),
(3751, 255),
(3752, 5),
(3752, 33),
(3752, 255),
(3753, 5),
(3754, 5),
(3755, 5),
(3756, 5),
(3757, 5),
(3758, 5),
(3759, 5),
(3760, 5),
(3761, 5),
(3762, 5),
(3763, 5),
(3764, 5),
(3765, 5),
(3766, 5),
(3767, 5),
(3768, 5),
(3769, 5),
(3770, 5),
(3771, 5),
(3772, 5),
(3773, 5),
(3774, 5),
(3775, 5),
(3776, 5),
(3777, 5),
(3778, 5),
(3779, 5),
(3780, 5),
(3781, 5),
(3782, 5),
(3783, 5),
(3784, 5),
(3785, 5),
(3785, 28),
(3785, 30),
(3786, 5),
(3787, 5),
(3788, 5),
(3789, 5),
(3790, 5),
(3791, 5),
(3792, 5),
(3793, 5),
(3794, 5),
(3795, 5),
(3796, 5),
(3797, 5),
(3798, 5),
(3799, 5),
(3800, 5),
(3801, 5),
(3802, 5),
(3803, 5),
(3804, 5),
(3805, 5),
(3806, 5),
(3807, 5),
(3808, 5),
(3809, 5),
(3810, 5),
(3811, 5),
(3812, 5),
(3813, 5),
(3814, 5),
(3815, 5),
(3816, 5),
(3817, 5),
(3818, 5),
(3819, 5),
(3820, 5),
(3821, 5),
(3822, 5),
(3823, 5),
(3824, 5),
(3825, 5),
(3826, 5),
(3827, 5),
(3828, 5),
(3829, 5),
(3830, 5),
(3831, 5),
(3832, 5),
(3833, 5),
(3834, 4),
(3834, 5),
(3834, 28),
(3835, 5),
(3836, 5),
(3837, 5),
(3838, 5),
(3839, 5),
(3840, 5),
(3841, 5),
(3842, 5),
(3843, 5),
(3844, 5),
(3845, 5),
(3846, 5),
(3847, 5),
(3848, 5),
(3849, 5),
(3850, 5),
(3851, 5),
(3852, 5),
(3853, 5),
(3854, 5),
(3855, 5),
(3856, 5),
(3857, 5),
(3858, 5),
(3859, 5),
(3860, 5),
(3861, 5),
(3862, 5),
(3863, 5),
(3864, 5),
(3865, 5),
(3866, 5),
(3867, 5),
(3868, 5),
(3869, 5),
(3869, 141),
(3870, 5),
(3871, 5),
(3872, 5),
(3872, 141),
(3873, 5),
(3874, 5),
(3875, 5),
(3876, 5),
(3877, 5),
(3878, 5),
(3879, 5),
(3879, 7),
(3880, 5),
(3880, 141),
(3881, 5),
(3882, 5),
(3883, 5),
(3884, 5),
(3885, 5),
(3886, 5),
(3887, 5),
(3888, 5),
(3889, 5),
(3890, 5),
(3891, 5),
(3892, 5),
(3893, 5),
(3894, 5),
(3895, 5),
(3896, 5),
(3897, 5),
(3898, 5),
(3899, 5),
(3900, 5),
(3901, 5),
(3902, 5),
(3903, 5),
(3904, 5),
(3905, 5),
(3906, 5),
(3907, 5),
(3908, 5),
(3909, 5),
(3910, 5),
(3911, 5),
(3912, 5),
(3912, 9),
(3913, 5),
(3914, 5),
(3915, 5),
(3916, 5),
(3917, 28),
(3918, 28),
(3919, 28),
(3920, 28),
(3921, 28),
(3922, 28),
(3923, 28),
(3924, 28),
(3925, 28),
(3926, 28),
(3927, 28),
(3927, 70),
(3928, 28),
(3929, 28),
(3930, 4),
(3930, 28),
(3931, 28),
(3932, 28),
(3933, 28),
(3934, 28),
(3935, 28),
(3936, 28),
(3937, 28),
(3938, 28),
(3939, 28),
(3940, 28),
(3941, 28),
(3942, 28),
(3943, 28),
(3944, 28),
(3945, 28),
(3946, 28),
(3947, 28),
(3948, 28),
(3949, 4),
(3949, 21),
(3949, 28),
(3950, 28),
(3951, 28),
(3952, 4),
(3952, 28),
(3953, 28),
(3954, 28),
(3955, 28),
(3956, 28),
(3957, 28),
(3958, 28),
(3959, 28),
(3960, 28),
(3961, 28),
(3962, 28),
(3963, 28),
(3964, 28),
(3965, 28),
(3966, 28),
(3967, 28),
(3968, 28),
(3969, 28),
(3970, 28),
(3971, 28),
(3972, 28),
(3973, 28),
(3974, 28),
(3975, 28),
(3976, 28),
(3977, 28),
(3978, 28),
(3979, 28),
(3980, 28),
(3981, 28),
(3982, 28),
(3983, 28),
(3984, 28),
(3985, 28),
(3986, 28),
(3987, 28),
(3988, 28),
(3989, 28),
(3990, 28),
(3991, 28),
(3992, 28),
(3993, 28),
(3994, 28),
(3995, 28),
(3996, 28),
(3997, 28),
(3998, 28),
(3999, 28),
(3999, 309),
(4000, 28),
(4001, 28),
(4002, 28),
(4003, 28),
(4004, 28),
(4005, 28),
(4006, 28),
(4007, 28),
(4008, 28),
(4009, 28),
(4010, 28),
(4010, 437),
(4011, 28),
(4011, 437),
(4012, 28),
(4013, 28),
(4014, 28),
(4015, 28),
(4016, 28),
(4017, 28),
(4018, 28),
(4019, 28),
(4020, 28),
(4021, 28),
(4022, 28),
(4023, 28),
(4024, 28),
(4025, 28),
(4026, 28),
(4027, 28),
(4028, 28),
(4029, 28),
(4030, 28),
(4031, 28),
(4032, 28),
(4033, 28),
(4034, 28),
(4035, 28),
(4036, 28),
(4037, 28),
(4038, 28),
(4039, 28),
(4040, 28),
(4040, 298),
(4040, 346),
(4041, 28),
(4042, 28),
(4043, 28),
(4044, 28),
(4045, 28),
(4046, 28),
(4047, 28),
(4048, 28),
(4049, 28),
(4050, 28),
(4051, 28),
(4052, 28),
(4053, 28),
(4054, 28),
(4055, 28),
(4056, 28),
(4057, 28),
(4058, 28),
(4059, 28),
(4060, 28),
(4061, 28),
(4062, 28),
(4063, 28),
(4063, 298),
(4064, 28),
(4065, 28),
(4066, 28),
(4067, 28),
(4068, 28),
(4069, 28),
(4069, 252),
(4070, 28),
(4071, 28),
(4072, 28),
(4073, 28),
(4074, 28),
(4075, 28),
(4076, 76),
(4077, 28),
(4078, 28),
(4079, 28),
(4079, 302),
(4080, 28),
(4081, 28),
(4082, 28),
(4083, 28),
(4084, 28),
(4085, 28),
(4086, 28),
(4087, 28),
(4088, 28),
(4089, 28),
(4090, 28),
(4090, 37),
(4091, 28),
(4092, 28),
(4093, 28),
(4094, 28),
(4095, 28),
(4096, 28),
(4097, 28),
(4098, 28),
(4099, 28),
(4100, 28),
(4101, 28),
(4102, 28),
(4103, 28),
(4104, 28),
(4105, 28),
(4106, 28),
(4107, 28),
(4108, 28),
(4109, 28),
(4110, 28),
(4111, 28),
(4112, 28),
(4113, 28),
(4114, 28),
(4115, 28),
(4116, 28),
(4117, 28),
(4118, 28),
(4119, 28),
(4120, 28),
(4121, 28),
(4122, 28),
(4123, 28),
(4124, 28),
(4125, 28),
(4126, 28),
(4127, 28),
(4128, 28),
(4129, 28),
(4130, 28),
(4131, 28),
(4132, 28),
(4133, 28),
(4134, 28),
(4135, 28),
(4136, 28),
(4137, 28),
(4138, 28),
(4139, 28),
(4140, 28),
(4141, 28),
(4142, 28),
(4143, 28),
(4144, 28),
(4145, 28),
(4146, 28),
(4147, 28),
(4148, 28),
(4149, 28),
(4150, 28),
(4151, 28),
(4152, 28),
(4153, 28),
(4154, 28),
(4155, 28),
(4156, 28),
(4157, 28),
(4158, 28),
(4159, 28),
(4160, 28),
(4161, 28),
(4162, 28),
(4163, 28),
(4164, 28),
(4165, 28),
(4166, 28),
(4167, 28),
(4168, 28),
(4169, 28),
(4170, 28),
(4171, 28),
(4172, 28),
(4173, 28),
(4174, 28),
(4175, 28),
(4176, 28),
(4177, 28),
(4178, 28),
(4179, 28),
(4180, 28),
(4181, 28),
(4182, 28),
(4183, 28),
(4184, 28),
(4185, 28),
(4186, 28),
(4187, 28),
(4187, 144),
(4188, 28),
(4188, 44),
(4189, 28),
(4190, 28),
(4191, 28),
(4192, 28),
(4193, 28),
(4194, 28),
(4195, 28),
(4196, 28),
(4197, 28),
(4198, 28),
(4199, 28),
(4200, 28),
(4201, 28),
(4202, 28),
(4203, 28),
(4204, 28),
(4205, 28),
(4206, 28),
(4207, 28),
(4208, 28),
(4209, 28),
(4210, 28),
(4211, 28),
(4212, 28),
(4213, 28),
(4214, 28),
(4215, 28),
(4216, 28),
(4217, 28),
(4218, 28),
(4218, 44),
(4219, 28),
(4220, 28),
(4221, 28),
(4222, 28),
(4223, 28),
(4224, 28),
(4225, 28),
(4226, 28),
(4227, 28),
(4228, 28),
(4229, 28),
(4230, 28),
(4231, 28),
(4232, 28),
(4233, 28),
(4234, 28),
(4235, 28),
(4236, 252),
(4237, 28),
(4237, 492),
(4238, 28),
(4239, 28),
(4240, 28),
(4241, 28),
(4242, 28),
(4243, 28),
(4243, 141),
(4244, 28),
(4245, 28),
(4246, 28),
(4247, 28),
(4248, 28),
(4249, 28),
(4250, 28),
(4251, 28),
(4252, 28),
(4253, 28),
(4254, 28),
(4255, 28),
(4256, 28),
(4257, 28),
(4258, 28),
(4259, 28),
(4260, 28),
(4261, 28),
(4262, 28),
(4263, 28),
(4264, 28),
(4265, 28),
(4266, 28),
(4267, 28),
(4268, 28),
(4269, 28),
(4270, 28),
(4271, 28),
(4272, 28),
(4273, 28),
(4274, 28),
(4275, 28),
(4276, 28),
(4276, 298),
(4277, 28),
(4278, 28),
(4279, 28),
(4280, 28),
(4281, 28),
(4282, 28),
(4283, 28),
(4284, 28),
(4285, 28),
(4286, 28),
(4287, 28),
(4288, 28),
(4289, 28),
(4290, 28),
(4291, 28),
(4292, 28),
(4293, 28),
(4294, 28),
(4295, 28),
(4296, 28),
(4297, 28),
(4298, 28),
(4299, 28),
(4300, 28),
(4301, 28),
(4302, 28),
(4303, 28),
(4304, 28),
(4305, 28),
(4306, 28),
(4307, 28),
(4308, 28),
(4309, 28),
(4310, 28),
(4311, 28),
(4312, 28),
(4313, 28),
(4314, 28),
(4314, 198),
(4315, 28),
(4316, 28),
(4317, 28),
(4318, 28),
(4319, 28),
(4320, 28),
(4321, 28),
(4322, 28),
(4323, 28),
(4324, 28),
(4325, 28),
(4326, 28),
(4327, 28),
(4328, 28),
(4329, 28),
(4329, 198),
(4329, 250),
(4330, 28),
(4331, 28),
(4332, 28),
(4333, 28),
(4334, 28),
(4335, 28),
(4336, 28),
(4337, 28),
(4338, 28),
(4339, 76),
(4340, 28),
(4341, 28),
(4342, 28),
(4343, 28),
(4344, 28),
(4345, 28),
(4346, 28),
(4347, 28),
(4348, 28),
(4349, 28),
(4350, 28),
(4351, 28),
(4352, 28),
(4353, 28),
(4354, 28),
(4355, 28),
(4356, 28),
(4357, 28),
(4358, 28),
(4359, 28),
(4360, 28),
(4361, 28),
(4362, 28),
(4363, 28),
(4364, 28),
(4365, 28),
(4366, 28),
(4367, 28),
(4368, 28),
(4369, 28),
(4370, 28),
(4371, 28),
(4372, 28),
(4373, 28),
(4374, 28),
(4375, 28),
(4376, 28),
(4377, 28),
(4378, 28),
(4379, 28),
(4380, 28),
(4381, 28),
(4382, 28),
(4383, 28),
(4384, 28),
(4385, 28),
(4386, 28),
(4387, 28),
(4388, 28),
(4389, 28),
(4390, 28),
(4391, 28),
(4392, 28),
(4393, 28),
(4394, 28),
(4395, 28),
(4396, 28),
(4397, 28),
(4398, 28),
(4399, 28),
(4400, 28),
(4401, 28),
(4402, 28),
(4403, 28),
(4404, 28),
(4405, 28),
(4406, 28),
(4407, 28),
(4408, 28),
(4409, 28),
(4410, 28),
(4411, 28),
(4412, 28),
(4413, 28),
(4414, 28),
(4415, 28),
(4416, 28),
(4417, 28),
(4418, 28),
(4419, 28),
(4420, 28),
(4421, 28),
(4422, 28),
(4423, 28),
(4424, 28),
(4425, 28),
(4426, 28),
(4427, 28),
(4428, 28),
(4429, 28),
(4430, 28),
(4431, 28),
(4432, 28),
(4433, 28),
(4434, 28),
(4435, 28),
(4436, 28),
(4437, 28),
(4438, 28),
(4439, 28),
(4440, 28),
(4441, 28),
(4442, 28),
(4443, 28),
(4444, 28),
(4445, 28),
(4446, 28),
(4447, 28),
(4448, 2),
(4448, 252),
(4449, 2),
(4450, 2),
(4451, 2),
(4452, 2),
(4453, 2),
(4454, 22),
(4455, 2),
(4456, 2),
(4457, 2),
(4458, 2),
(4459, 2),
(4460, 2),
(4461, 2),
(4462, 2),
(4463, 2),
(4464, 2),
(4465, 2),
(4466, 2),
(4467, 2),
(4468, 2),
(4469, 2),
(4470, 2),
(4471, 2),
(4472, 2),
(4473, 2),
(4474, 2),
(4475, 2),
(4476, 2),
(4477, 2),
(4478, 2),
(4479, 2),
(4480, 2),
(4481, 2),
(4482, 2),
(4483, 2),
(4484, 2),
(4485, 2),
(4486, 2),
(4487, 2),
(4488, 2),
(4489, 2),
(4490, 2),
(4491, 2),
(4492, 2),
(4493, 2),
(4494, 2),
(4495, 2),
(4496, 2),
(4497, 2),
(4498, 2),
(4499, 2),
(4500, 2),
(4501, 2),
(4502, 2),
(4503, 2),
(4504, 2),
(4505, 2),
(4506, 2),
(4507, 2),
(4508, 2),
(4509, 2),
(4510, 2),
(4511, 2),
(4512, 2),
(4512, 198),
(4513, 2),
(4514, 2),
(4515, 2),
(4516, 2),
(4517, 2),
(4518, 2),
(4519, 2),
(4520, 2),
(4521, 2),
(4522, 2),
(4523, 2),
(4524, 2),
(4525, 2),
(4526, 2),
(4527, 2),
(4528, 2),
(4529, 2),
(4530, 2),
(4531, 2),
(4532, 2),
(4533, 2),
(4534, 2),
(4535, 2),
(4536, 2),
(4537, 2),
(4538, 2),
(4539, 2),
(4540, 2),
(4541, 2),
(4542, 2),
(4543, 2),
(4544, 2),
(4545, 2),
(4546, 2),
(4547, 2),
(4548, 2),
(4549, 2),
(4550, 2),
(4551, 2),
(4552, 2),
(4553, 2),
(4554, 2),
(4555, 2),
(4556, 2),
(4557, 2),
(4558, 2),
(4559, 2),
(4560, 2),
(4561, 2),
(4562, 2),
(4563, 2),
(4564, 2),
(4565, 2),
(4566, 2),
(4567, 2),
(4568, 2),
(4569, 2),
(4570, 2),
(4571, 2),
(4572, 2),
(4573, 2),
(4574, 2),
(4575, 2),
(4576, 2),
(4577, 2),
(4578, 2),
(4579, 2),
(4580, 2),
(4581, 2),
(4582, 2),
(4583, 2),
(4584, 2),
(4585, 2),
(4586, 2),
(4587, 2),
(4588, 2),
(4589, 2),
(4590, 2),
(4591, 2),
(4592, 2),
(4593, 2),
(4594, 2),
(4595, 2),
(4596, 2),
(4597, 2),
(4598, 2),
(4599, 2),
(4600, 2),
(4601, 2),
(4602, 2),
(4603, 2),
(4604, 2),
(4605, 2),
(4606, 2),
(4607, 2),
(4608, 2),
(4609, 13),
(4609, 198),
(4609, 256),
(4610, 256),
(4611, 256),
(4612, 256),
(4613, 256),
(4614, 256),
(4615, 256),
(4616, 256),
(4617, 256),
(4618, 256),
(4619, 256),
(4620, 30),
(4620, 256),
(4621, 256),
(4621, 257),
(4622, 256),
(4623, 257),
(4624, 257),
(4625, 252),
(4626, 252),
(4626, 257),
(4627, 257),
(4628, 256),
(4629, 252),
(4629, 257),
(4630, 256),
(4631, 198),
(4631, 256),
(4632, 256),
(4633, 256),
(4634, 256),
(4634, 258),
(4635, 256),
(4635, 257),
(4636, 256),
(4637, 256),
(4638, 252),
(4638, 257),
(4639, 256),
(4640, 252),
(4640, 257),
(4641, 257),
(4642, 257),
(4643, 257),
(4644, 252),
(4645, 256),
(4646, 243),
(4646, 256),
(4647, 256),
(4648, 159),
(4649, 159),
(4650, 159),
(4651, 159),
(4652, 159),
(4653, 159),
(4654, 159),
(4655, 159),
(4656, 159),
(4657, 159),
(4658, 258),
(4659, 159),
(4660, 159),
(4661, 159),
(4662, 159),
(4663, 159),
(4664, 159),
(4665, 159),
(4666, 159),
(4667, 159),
(4668, 159),
(4669, 159),
(4670, 159),
(4671, 159),
(4672, 159),
(4673, 159),
(4674, 159),
(4675, 159),
(4676, 159),
(4677, 159),
(4678, 159),
(4679, 159),
(4680, 159),
(4681, 159),
(4682, 159),
(4683, 159),
(4684, 159),
(4685, 159),
(4686, 159),
(4687, 159),
(4688, 159),
(4689, 159),
(4690, 159),
(4691, 159),
(4692, 159),
(4693, 159),
(4694, 159),
(4695, 159),
(4696, 159),
(4697, 159),
(4698, 159),
(4699, 159),
(4700, 159),
(4701, 159),
(4702, 159),
(4703, 159),
(4704, 159),
(4705, 159),
(4706, 159),
(4707, 159),
(4708, 159),
(4709, 159),
(4710, 159),
(4711, 159),
(4712, 159),
(4713, 159),
(4714, 159),
(4715, 159),
(4716, 159),
(4717, 159),
(4718, 159),
(4719, 159),
(4720, 159),
(4721, 159),
(4722, 159),
(4723, 159),
(4724, 159),
(4725, 159),
(4726, 159),
(4727, 159),
(4728, 159),
(4729, 159),
(4730, 159),
(4731, 159),
(4732, 159),
(4733, 159),
(4734, 159),
(4735, 159),
(4736, 159),
(4737, 159),
(4738, 159),
(4739, 159),
(4740, 159),
(4741, 159),
(4742, 159),
(4743, 159),
(4744, 159),
(4745, 159),
(4746, 159),
(4747, 159),
(4748, 159),
(4749, 159),
(4750, 159),
(4751, 159),
(4752, 159),
(4753, 159),
(4754, 159),
(4755, 159),
(4756, 159),
(4757, 159),
(4758, 159),
(4759, 159),
(4760, 159),
(4761, 159),
(4762, 159),
(4763, 159),
(4764, 159),
(4765, 159),
(4766, 159),
(4767, 159),
(4768, 159),
(4769, 159),
(4770, 159),
(4771, 159),
(4772, 159),
(4773, 159),
(4774, 159),
(4775, 159),
(4776, 159),
(4777, 159),
(4778, 159),
(4779, 159),
(4780, 159),
(4781, 159),
(4782, 159),
(4783, 159),
(4784, 159),
(4785, 159),
(4786, 159),
(4787, 159),
(4788, 159),
(4789, 159),
(4790, 159),
(4791, 159),
(4792, 159),
(4793, 159),
(4794, 159),
(4795, 159),
(4796, 159),
(4797, 159),
(4798, 159),
(4799, 159),
(4800, 159),
(4801, 159),
(4802, 159),
(4803, 159),
(4804, 159),
(4805, 159),
(4806, 159),
(4807, 159),
(4808, 159),
(4809, 159),
(4810, 159),
(4811, 159),
(4812, 159),
(4813, 159),
(4814, 159),
(4815, 159),
(4816, 159),
(4817, 159),
(4818, 159),
(4819, 159),
(4820, 159),
(4821, 159),
(4822, 159),
(4823, 159),
(4824, 159),
(4825, 159),
(4826, 159),
(4827, 159),
(4828, 159),
(4829, 159),
(4830, 159),
(4831, 159),
(4832, 159),
(4833, 159),
(4834, 159),
(4835, 159),
(4836, 159),
(4837, 159),
(4838, 159),
(4839, 159),
(4840, 159),
(4841, 159),
(4842, 159),
(4843, 159),
(4844, 159),
(4845, 159),
(4846, 159),
(4847, 159),
(4848, 159),
(4849, 159),
(4850, 159),
(4851, 159),
(4852, 159),
(4853, 159),
(4854, 159),
(4855, 159),
(4856, 159),
(4857, 159),
(4858, 159),
(4859, 159),
(4860, 159),
(4861, 159),
(4862, 159),
(4863, 159),
(4864, 159),
(4865, 159),
(4866, 159),
(4867, 159),
(4868, 159),
(4869, 159),
(4870, 159),
(4871, 159),
(4872, 159),
(4873, 159),
(4874, 159),
(4875, 159),
(4876, 159),
(4877, 159),
(4878, 159),
(4879, 159),
(4880, 159),
(4881, 159),
(4882, 159),
(4883, 159),
(4884, 159),
(4885, 159),
(4886, 159),
(4887, 159),
(4888, 159),
(4889, 159),
(4890, 159),
(4891, 159),
(4892, 159),
(4893, 159),
(4894, 159),
(4895, 159),
(4896, 159),
(4897, 159),
(4898, 159),
(4899, 159),
(4900, 159),
(4901, 159),
(4902, 159),
(4903, 159),
(4904, 159),
(4905, 159),
(4906, 159),
(4907, 159),
(4908, 159),
(4909, 159),
(4910, 159),
(4911, 159),
(4912, 159),
(4913, 159),
(4914, 159),
(4915, 159),
(4916, 159),
(4917, 159),
(4918, 159),
(4919, 159),
(4920, 159),
(4921, 159),
(4922, 159),
(4923, 159),
(4924, 159),
(4925, 159),
(4926, 159),
(4927, 159),
(4928, 159),
(4929, 159),
(4930, 159),
(4931, 159),
(4932, 159),
(4933, 159),
(4934, 159),
(4935, 159),
(4936, 159),
(4937, 159),
(4938, 159),
(4939, 159),
(4940, 159),
(4941, 159),
(4942, 159),
(4943, 159),
(4944, 159),
(4945, 159),
(4946, 159),
(4947, 159),
(4948, 159),
(4949, 159),
(4950, 159),
(4951, 159),
(4952, 159),
(4953, 159),
(4954, 159),
(4955, 159),
(4956, 159),
(4957, 159),
(4958, 159),
(4959, 159),
(4960, 159),
(4961, 159),
(4962, 159),
(4963, 159),
(4964, 159),
(4965, 159),
(4966, 159),
(4967, 159),
(4968, 159),
(4969, 159),
(4970, 159),
(4971, 159),
(4972, 159),
(4973, 159),
(4974, 159),
(4975, 159),
(4976, 159),
(4977, 13),
(4977, 159),
(4978, 159),
(4979, 159),
(4980, 13),
(4980, 159),
(4981, 159),
(4982, 159),
(4983, 159),
(4984, 159),
(4985, 159),
(4986, 159),
(4987, 159),
(4988, 159),
(4989, 159),
(4990, 159),
(4991, 159),
(4992, 159),
(4993, 159),
(4994, 159),
(4995, 159),
(4996, 159),
(4997, 159),
(4998, 159),
(4999, 159),
(5000, 159),
(5001, 159),
(5002, 159),
(5003, 159),
(5004, 159),
(5005, 159),
(5006, 159),
(5007, 159),
(5008, 159),
(5009, 159),
(5010, 159),
(5011, 159),
(5012, 159),
(5013, 159),
(5014, 159),
(5015, 159),
(5016, 159),
(5017, 159),
(5018, 159),
(5019, 159),
(5020, 159),
(5021, 159),
(5022, 159),
(5023, 159),
(5024, 159),
(5025, 159),
(5026, 159),
(5027, 159),
(5028, 159),
(5029, 159),
(5030, 159),
(5031, 159),
(5032, 159),
(5033, 159),
(5034, 159),
(5035, 159),
(5036, 159),
(5037, 159),
(5038, 159),
(5039, 159),
(5040, 159),
(5041, 159),
(5042, 159),
(5043, 159),
(5044, 159),
(5045, 159),
(5046, 159),
(5047, 159),
(5048, 159),
(5049, 159),
(5050, 159),
(5051, 99),
(5052, 259),
(5053, 259),
(5054, 259),
(5055, 21),
(5056, 21),
(5057, 21),
(5058, 21),
(5059, 21),
(5060, 21),
(5061, 21),
(5062, 21),
(5063, 21),
(5064, 21),
(5065, 260),
(5065, 268),
(5066, 260),
(5067, 21),
(5068, 21),
(5069, 21),
(5070, 21),
(5071, 21),
(5072, 21),
(5073, 21),
(5074, 21),
(5075, 21),
(5076, 21),
(5077, 21),
(5078, 21),
(5079, 21),
(5080, 21),
(5081, 21),
(5081, 348),
(5082, 21),
(5083, 115),
(5084, 21),
(5085, 21),
(5086, 21),
(5087, 21);
INSERT INTO `smdevicenamebrand` (`DeviceNameID`, `BrandID`) VALUES
(5088, 21),
(5089, 21),
(5090, 21),
(5091, 56),
(5092, 21),
(5092, 267),
(5093, 21),
(5094, 21),
(5095, 21),
(5096, 21),
(5097, 21),
(5098, 21),
(5099, 21),
(5100, 21),
(5101, 21),
(5102, 21),
(5103, 21),
(5104, 21),
(5105, 21),
(5106, 21),
(5107, 21),
(5108, 21),
(5109, 21),
(5110, 21),
(5111, 21),
(5112, 21),
(5113, 21),
(5114, 21),
(5115, 21),
(5116, 21),
(5117, 21),
(5118, 21),
(5119, 21),
(5120, 21),
(5121, 21),
(5122, 21),
(5123, 21),
(5124, 21),
(5125, 21),
(5126, 21),
(5127, 21),
(5128, 21),
(5129, 261),
(5130, 21),
(5131, 21),
(5132, 45),
(5132, 305),
(5133, 21),
(5134, 21),
(5135, 21),
(5136, 21),
(5137, 115),
(5138, 21),
(5139, 21),
(5140, 21),
(5141, 115),
(5142, 115),
(5143, 21),
(5143, 205),
(5143, 305),
(5144, 21),
(5145, 21),
(5146, 21),
(5147, 21),
(5148, 21),
(5149, 115),
(5150, 21),
(5151, 21),
(5152, 21),
(5153, 21),
(5154, 21),
(5155, 21),
(5156, 21),
(5157, 21),
(5158, 21),
(5159, 21),
(5160, 21),
(5161, 21),
(5162, 21),
(5163, 21),
(5164, 21),
(5164, 22),
(5165, 21),
(5166, 21),
(5167, 21),
(5168, 21),
(5169, 21),
(5170, 21),
(5171, 21),
(5172, 21),
(5173, 21),
(5174, 21),
(5175, 21),
(5176, 21),
(5177, 21),
(5178, 21),
(5179, 21),
(5180, 21),
(5181, 21),
(5182, 21),
(5183, 21),
(5184, 21),
(5185, 21),
(5186, 115),
(5187, 115),
(5188, 45),
(5189, 103),
(5190, 103),
(5191, 103),
(5192, 103),
(5193, 103),
(5194, 103),
(5195, 103),
(5196, 103),
(5197, 103),
(5198, 103),
(5199, 103),
(5200, 103),
(5201, 103),
(5202, 103),
(5203, 103),
(5204, 103),
(5205, 103),
(5206, 103),
(5207, 103),
(5208, 103),
(5209, 103),
(5210, 103),
(5211, 103),
(5212, 103),
(5213, 103),
(5214, 103),
(5215, 103),
(5216, 103),
(5217, 103),
(5218, 103),
(5219, 103),
(5220, 103),
(5221, 103),
(5222, 103),
(5223, 103),
(5224, 103),
(5225, 103),
(5226, 103),
(5227, 103),
(5228, 103),
(5229, 103),
(5230, 103),
(5231, 103),
(5232, 103),
(5233, 103),
(5234, 103),
(5235, 103),
(5236, 103),
(5237, 103),
(5238, 103),
(5239, 103),
(5240, 103),
(5241, 103),
(5242, 103),
(5243, 103),
(5244, 103),
(5245, 103),
(5246, 37),
(5247, 103),
(5248, 103),
(5249, 103),
(5250, 103),
(5251, 103),
(5252, 103),
(5253, 103),
(5254, 103),
(5255, 103),
(5256, 103),
(5257, 103),
(5258, 103),
(5259, 103),
(5260, 103),
(5261, 103),
(5262, 103),
(5263, 103),
(5264, 103),
(5265, 103),
(5266, 103),
(5267, 103),
(5268, 103),
(5269, 103),
(5270, 103),
(5271, 103),
(5272, 103),
(5273, 103),
(5274, 103),
(5275, 103),
(5276, 103),
(5277, 103),
(5278, 103),
(5279, 103),
(5280, 103),
(5281, 103),
(5282, 103),
(5283, 103),
(5284, 103),
(5285, 103),
(5286, 103),
(5287, 103),
(5288, 103),
(5289, 103),
(5290, 103),
(5291, 103),
(5292, 103),
(5293, 103),
(5294, 103),
(5295, 103),
(5296, 103),
(5297, 103),
(5298, 103),
(5299, 103),
(5300, 103),
(5301, 103),
(5302, 103),
(5303, 103),
(5304, 103),
(5305, 103),
(5306, 103),
(5307, 103),
(5308, 103),
(5309, 103),
(5310, 103),
(5311, 103),
(5312, 103),
(5313, 103),
(5314, 103),
(5315, 103),
(5316, 103),
(5317, 103),
(5318, 103),
(5319, 103),
(5320, 103),
(5321, 103),
(5322, 27),
(5322, 272),
(5322, 274),
(5322, 469),
(5323, 103),
(5324, 103),
(5325, 103),
(5326, 103),
(5327, 103),
(5328, 103),
(5329, 103),
(5330, 103),
(5331, 103),
(5332, 103),
(5333, 103),
(5334, 103),
(5335, 103),
(5336, 103),
(5337, 103),
(5338, 103),
(5339, 103),
(5340, 103),
(5341, 103),
(5342, 103),
(5343, 103),
(5344, 103),
(5345, 103),
(5346, 103),
(5347, 103),
(5348, 103),
(5349, 103),
(5350, 103),
(5351, 103),
(5352, 103),
(5353, 103),
(5354, 103),
(5355, 103),
(5356, 103),
(5357, 103),
(5358, 103),
(5359, 103),
(5360, 103),
(5361, 103),
(5362, 103),
(5363, 103),
(5364, 103),
(5365, 103),
(5366, 103),
(5367, 103),
(5368, 103),
(5369, 103),
(5370, 103),
(5371, 103),
(5372, 103),
(5373, 103),
(5374, 103),
(5375, 103),
(5376, 103),
(5377, 103),
(5378, 103),
(5379, 103),
(5380, 103),
(5381, 103),
(5382, 103),
(5383, 103),
(5384, 103),
(5385, 103),
(5386, 103),
(5387, 103),
(5388, 103),
(5389, 103),
(5390, 103),
(5391, 103),
(5392, 103),
(5393, 103),
(5394, 103),
(5395, 103),
(5396, 103),
(5397, 103),
(5398, 103),
(5399, 103),
(5400, 103),
(5401, 103),
(5402, 103),
(5403, 103),
(5404, 103),
(5405, 103),
(5406, 103),
(5407, 103),
(5408, 103),
(5409, 103),
(5410, 103),
(5411, 103),
(5412, 103),
(5413, 103),
(5414, 103),
(5415, 103),
(5416, 103),
(5417, 103),
(5418, 103),
(5419, 103),
(5420, 103),
(5421, 103),
(5422, 103),
(5423, 103),
(5424, 103),
(5425, 48),
(5426, 103),
(5427, 103),
(5428, 103),
(5429, 103),
(5430, 103),
(5431, 103),
(5432, 103),
(5433, 103),
(5434, 103),
(5435, 103),
(5436, 103),
(5437, 103),
(5438, 37),
(5439, 37),
(5440, 37),
(5441, 37),
(5442, 37),
(5443, 37),
(5444, 37),
(5445, 37),
(5446, 37),
(5447, 37),
(5448, 37),
(5449, 37),
(5450, 37),
(5451, 37),
(5452, 37),
(5453, 37),
(5454, 37),
(5455, 37),
(5456, 37),
(5457, 37),
(5458, 37),
(5459, 37),
(5460, 37),
(5461, 37),
(5462, 37),
(5463, 37),
(5464, 37),
(5465, 37),
(5466, 37),
(5467, 37),
(5467, 346),
(5468, 37),
(5469, 37),
(5470, 37),
(5471, 37),
(5472, 37),
(5473, 37),
(5474, 37),
(5475, 37),
(5476, 37),
(5477, 37),
(5478, 37),
(5479, 37),
(5480, 37),
(5481, 37),
(5482, 37),
(5483, 37),
(5484, 37),
(5485, 37),
(5486, 4),
(5487, 4),
(5488, 4),
(5489, 4),
(5490, 4),
(5491, 4),
(5492, 4),
(5493, 4),
(5494, 4),
(5495, 4),
(5496, 4),
(5497, 4),
(5498, 4),
(5499, 4),
(5500, 4),
(5501, 4),
(5502, 4),
(5503, 4),
(5504, 4),
(5505, 4),
(5506, 4),
(5507, 4),
(5508, 4),
(5509, 4),
(5510, 4),
(5511, 4),
(5512, 4),
(5513, 4),
(5514, 4),
(5515, 4),
(5516, 4),
(5517, 4),
(5518, 4),
(5519, 4),
(5520, 4),
(5521, 4),
(5522, 4),
(5523, 4),
(5524, 4),
(5525, 4),
(5526, 4),
(5527, 4),
(5528, 4),
(5529, 4),
(5530, 4),
(5531, 4),
(5532, 4),
(5533, 4),
(5534, 4),
(5535, 4),
(5536, 4),
(5537, 4),
(5538, 4),
(5539, 4),
(5540, 4),
(5541, 4),
(5542, 4),
(5543, 4),
(5544, 4),
(5545, 4),
(5546, 4),
(5547, 4),
(5548, 4),
(5549, 4),
(5550, 4),
(5551, 4),
(5552, 4),
(5553, 4),
(5554, 4),
(5555, 4),
(5556, 4),
(5557, 4),
(5558, 4),
(5559, 4),
(5560, 4),
(5561, 4),
(5562, 4),
(5563, 4),
(5564, 4),
(5564, 283),
(5565, 4),
(5566, 4),
(5567, 4),
(5568, 4),
(5569, 4),
(5570, 4),
(5571, 4),
(5572, 4),
(5573, 4),
(5574, 4),
(5574, 528),
(5574, 583),
(5575, 4),
(5576, 4),
(5577, 4),
(5578, 4),
(5579, 4),
(5580, 4),
(5581, 4),
(5582, 4),
(5583, 4),
(5583, 411),
(5584, 4),
(5585, 4),
(5586, 4),
(5587, 4),
(5588, 4),
(5589, 4),
(5590, 4),
(5591, 4),
(5592, 4),
(5593, 4),
(5594, 4),
(5595, 4),
(5596, 4),
(5597, 4),
(5598, 4),
(5599, 4),
(5600, 4),
(5601, 4),
(5602, 4),
(5603, 4),
(5604, 4),
(5604, 60),
(5605, 4),
(5606, 4),
(5607, 4),
(5608, 4),
(5609, 4),
(5610, 4),
(5611, 4),
(5612, 4),
(5613, 4),
(5614, 4),
(5615, 4),
(5616, 4),
(5617, 4),
(5618, 4),
(5619, 4),
(5620, 4),
(5621, 4),
(5622, 4),
(5623, 4),
(5624, 4),
(5625, 4),
(5626, 4),
(5627, 4),
(5628, 4),
(5629, 4),
(5630, 4),
(5631, 4),
(5632, 4),
(5633, 4),
(5634, 4),
(5635, 4),
(5636, 4),
(5637, 4),
(5638, 4),
(5639, 4),
(5640, 4),
(5641, 4),
(5642, 4),
(5643, 4),
(5644, 4),
(5645, 4),
(5646, 4),
(5647, 4),
(5648, 4),
(5649, 4),
(5650, 4),
(5651, 4),
(5652, 4),
(5653, 4),
(5654, 4),
(5655, 4),
(5656, 4),
(5657, 4),
(5658, 4),
(5659, 4),
(5660, 4),
(5661, 4),
(5662, 4),
(5663, 4),
(5664, 4),
(5665, 4),
(5666, 4),
(5667, 4),
(5668, 4),
(5669, 4),
(5670, 4),
(5671, 4),
(5672, 4),
(5673, 4),
(5674, 4),
(5675, 4),
(5676, 4),
(5677, 4),
(5678, 4),
(5679, 4),
(5680, 4),
(5681, 4),
(5682, 4),
(5683, 4),
(5684, 4),
(5685, 4),
(5686, 4),
(5687, 4),
(5688, 4),
(5689, 4),
(5690, 4),
(5691, 4),
(5692, 4),
(5693, 4),
(5694, 4),
(5695, 4),
(5696, 4),
(5697, 4),
(5698, 4),
(5699, 4),
(5700, 4),
(5701, 4),
(5702, 4),
(5703, 4),
(5704, 4),
(5705, 4),
(5706, 4),
(5707, 4),
(5708, 4),
(5709, 4),
(5710, 4),
(5711, 4),
(5712, 4),
(5713, 4),
(5714, 4),
(5715, 4),
(5716, 4),
(5717, 4),
(5718, 4),
(5719, 4),
(5720, 4),
(5721, 4),
(5722, 4),
(5723, 4),
(5724, 4),
(5725, 4),
(5726, 4),
(5727, 4),
(5728, 4),
(5729, 4),
(5730, 4),
(5731, 4),
(5732, 4),
(5733, 4),
(5734, 4),
(5735, 4),
(5736, 4),
(5737, 4),
(5738, 4),
(5739, 4),
(5740, 4),
(5741, 4),
(5742, 4),
(5743, 4),
(5744, 4),
(5745, 4),
(5746, 4),
(5747, 4),
(5748, 4),
(5749, 4),
(5750, 4),
(5751, 4),
(5752, 4),
(5753, 4),
(5754, 4),
(5755, 4),
(5756, 4),
(5757, 4),
(5758, 4),
(5759, 4),
(5760, 4),
(5761, 4),
(5762, 4),
(5763, 4),
(5764, 4),
(5765, 4),
(5766, 4),
(5767, 4),
(5768, 4),
(5769, 4),
(5770, 4),
(5771, 4),
(5772, 4),
(5773, 4),
(5774, 4),
(5775, 4),
(5776, 4),
(5777, 4),
(5778, 4),
(5779, 4),
(5780, 4),
(5781, 4),
(5782, 4),
(5783, 4),
(5784, 4),
(5785, 4),
(5786, 4),
(5787, 4),
(5788, 4),
(5789, 4),
(5790, 4),
(5791, 4),
(5792, 4),
(5793, 4),
(5794, 4),
(5795, 4),
(5796, 4),
(5797, 4),
(5798, 4),
(5799, 4),
(5800, 4),
(5801, 4),
(5802, 4),
(5803, 4),
(5804, 4),
(5805, 4),
(5806, 4),
(5807, 4),
(5808, 4),
(5809, 4),
(5810, 4),
(5811, 4),
(5812, 4),
(5813, 4),
(5814, 4),
(5815, 4),
(5816, 4),
(5817, 4),
(5818, 4),
(5819, 4),
(5820, 4),
(5821, 4),
(5822, 4),
(5823, 4),
(5824, 4),
(5825, 4),
(5826, 4),
(5827, 4),
(5828, 4),
(5829, 4),
(5830, 4),
(5831, 4),
(5832, 4),
(5833, 4),
(5834, 4),
(5835, 4),
(5836, 4),
(5837, 4),
(5838, 4),
(5839, 4),
(5840, 4),
(5841, 4),
(5842, 4),
(5843, 4),
(5844, 4),
(5845, 4),
(5846, 4),
(5847, 4),
(5848, 4),
(5849, 4),
(5850, 4),
(5851, 4),
(5852, 4),
(5853, 4),
(5854, 4),
(5855, 4),
(5856, 4),
(5857, 4),
(5858, 4),
(5859, 4),
(5860, 4),
(5861, 4),
(5862, 4),
(5863, 4),
(5864, 4),
(5865, 4),
(5866, 4),
(5867, 4),
(5868, 4),
(5869, 4),
(5870, 4),
(5871, 4),
(5872, 4),
(5873, 4),
(5874, 4),
(5875, 4),
(5876, 4),
(5877, 4),
(5878, 4),
(5879, 4),
(5880, 4),
(5881, 4),
(5882, 4),
(5883, 4),
(5884, 4),
(5885, 4),
(5886, 4),
(5887, 4),
(5888, 4),
(5889, 4),
(5890, 4),
(5891, 4),
(5892, 4),
(5893, 4),
(5894, 4),
(5895, 4),
(5896, 4),
(5897, 4),
(5898, 4),
(5899, 4),
(5900, 4),
(5901, 4),
(5902, 4),
(5903, 4),
(5904, 4),
(5905, 4),
(5906, 4),
(5907, 4),
(5908, 4),
(5909, 4),
(5910, 4),
(5911, 4),
(5912, 4),
(5913, 4),
(5914, 4),
(5915, 4),
(5916, 4),
(5917, 4),
(5918, 4),
(5919, 4),
(5920, 4),
(5921, 4),
(5922, 4),
(5923, 4),
(5924, 4),
(5925, 4),
(5926, 4),
(5927, 4),
(5928, 4),
(5929, 4),
(5930, 4),
(5931, 4),
(5932, 4),
(5933, 4),
(5934, 4),
(5935, 4),
(5936, 4),
(5937, 4),
(5938, 4),
(5939, 4),
(5940, 4),
(5941, 4),
(5942, 4),
(5943, 4),
(5944, 4),
(5945, 4),
(5946, 4),
(5947, 4),
(5948, 4),
(5949, 4),
(5950, 4),
(5951, 4),
(5952, 4),
(5953, 4),
(5954, 4),
(5955, 4),
(5956, 4),
(5957, 4),
(5958, 4),
(5959, 4),
(5960, 4),
(5961, 4),
(5962, 4),
(5963, 4),
(5964, 4),
(5965, 4),
(5966, 4),
(5967, 4),
(5968, 4),
(5969, 4),
(5970, 4),
(5971, 4),
(5972, 4),
(5973, 4),
(5974, 4),
(5975, 4),
(5976, 4),
(5977, 4),
(5978, 4),
(5979, 4),
(5980, 4),
(5981, 4),
(5982, 4),
(5983, 4),
(5984, 4),
(5985, 4),
(5986, 4),
(5987, 4),
(5988, 4),
(5989, 4),
(5990, 4),
(5991, 4),
(5992, 4),
(5993, 4),
(5994, 4),
(5994, 168),
(5995, 4),
(5996, 4),
(5997, 4),
(5998, 4),
(5999, 4),
(6000, 4),
(6001, 4),
(6002, 4),
(6003, 4),
(6004, 4),
(6005, 4),
(6006, 4),
(6007, 4),
(6007, 267),
(6008, 4),
(6009, 4),
(6010, 4),
(6011, 4),
(6012, 4),
(6013, 4),
(6014, 4),
(6015, 4),
(6016, 4),
(6017, 4),
(6018, 4),
(6019, 4),
(6020, 4),
(6021, 4),
(6022, 4),
(6023, 4),
(6024, 4),
(6025, 4),
(6026, 4),
(6027, 4),
(6028, 4),
(6029, 4),
(6030, 4),
(6031, 4),
(6032, 4),
(6033, 4),
(6034, 4),
(6035, 4),
(6036, 4),
(6037, 4),
(6038, 4),
(6039, 4),
(6040, 4),
(6041, 4),
(6042, 4),
(6043, 4),
(6044, 4),
(6045, 4),
(6046, 4),
(6047, 4),
(6048, 4),
(6049, 4),
(6050, 4),
(6051, 4),
(6052, 4),
(6053, 4),
(6054, 4),
(6055, 4),
(6056, 4),
(6057, 4),
(6058, 4),
(6059, 4),
(6060, 4),
(6061, 4),
(6062, 4),
(6063, 4),
(6064, 4),
(6065, 4),
(6066, 4),
(6067, 4),
(6068, 4),
(6069, 4),
(6070, 4),
(6071, 4),
(6072, 4),
(6073, 4),
(6074, 4),
(6075, 4),
(6076, 4),
(6077, 4),
(6078, 4),
(6079, 4),
(6080, 4),
(6081, 4),
(6082, 4),
(6083, 4),
(6084, 4),
(6084, 141),
(6085, 4),
(6086, 4),
(6087, 4),
(6088, 4),
(6088, 141),
(6089, 4),
(6090, 4),
(6091, 4),
(6092, 4),
(6093, 4),
(6094, 4),
(6095, 4),
(6096, 4),
(6097, 4),
(6098, 4),
(6099, 4),
(6100, 4),
(6101, 4),
(6102, 4),
(6103, 4),
(6104, 4),
(6105, 4),
(6106, 4),
(6107, 4),
(6108, 4),
(6109, 4),
(6110, 4),
(6111, 4),
(6112, 4),
(6113, 4),
(6114, 4),
(6115, 4),
(6116, 4),
(6117, 4),
(6118, 4),
(6119, 4),
(6120, 4),
(6121, 4),
(6122, 4),
(6123, 4),
(6124, 4),
(6125, 4),
(6126, 4),
(6127, 4),
(6128, 4),
(6129, 4),
(6130, 4),
(6131, 4),
(6132, 4),
(6133, 4),
(6134, 4),
(6135, 4),
(6136, 4),
(6137, 4),
(6138, 4),
(6139, 4),
(6140, 4),
(6141, 4),
(6142, 4),
(6143, 4),
(6144, 4),
(6145, 4),
(6146, 4),
(6147, 4),
(6148, 4),
(6149, 4),
(6150, 4),
(6151, 4),
(6152, 3),
(6152, 99),
(6153, 3),
(6153, 99),
(6154, 258),
(6155, 258),
(6156, 258),
(6157, 258),
(6158, 258),
(6159, 258),
(6160, 258),
(6161, 258),
(6162, 2),
(6163, 258),
(6164, 258),
(6165, 250),
(6165, 258),
(6166, 258),
(6166, 333),
(6167, 159),
(6168, 159),
(6169, 159),
(6170, 99),
(6171, 262),
(6172, 99),
(6173, 159),
(6174, 99),
(6174, 350),
(6175, 99),
(6176, 99),
(6176, 168),
(6176, 376),
(6177, 99),
(6178, 99),
(6179, 99),
(6180, 99),
(6181, 99),
(6182, 99),
(6183, 99),
(6184, 99),
(6185, 99),
(6186, 99),
(6187, 99),
(6188, 99),
(6189, 99),
(6190, 99),
(6191, 99),
(6192, 3),
(6192, 99),
(6193, 99),
(6194, 99),
(6195, 99),
(6196, 99),
(6197, 99),
(6198, 99),
(6199, 99),
(6200, 99),
(6201, 99),
(6202, 99),
(6203, 99),
(6204, 99),
(6205, 99),
(6206, 99),
(6207, 99),
(6208, 99),
(6209, 99),
(6210, 263),
(6211, 263),
(6212, 263),
(6213, 263),
(6214, 263),
(6215, 13),
(6215, 259),
(6216, 13),
(6216, 314),
(6217, 13),
(6218, 13),
(6219, 13),
(6220, 13),
(6221, 13),
(6222, 13),
(6223, 13),
(6224, 13),
(6225, 13),
(6226, 13),
(6227, 13),
(6228, 13),
(6229, 13),
(6230, 13),
(6231, 13),
(6232, 13),
(6233, 13),
(6234, 13),
(6235, 13),
(6235, 265),
(6236, 13),
(6237, 13),
(6238, 13),
(6239, 13),
(6240, 13),
(6241, 13),
(6242, 13),
(6243, 13),
(6244, 13),
(6244, 168),
(6244, 394),
(6244, 479),
(6245, 13),
(6246, 13),
(6247, 13),
(6248, 13),
(6249, 13),
(6250, 13),
(6251, 13),
(6252, 13),
(6252, 168),
(6252, 394),
(6253, 13),
(6254, 13),
(6255, 60),
(6256, 60),
(6257, 48),
(6257, 60),
(6258, 60),
(6259, 60),
(6260, 4),
(6261, 60),
(6262, 60),
(6262, 407),
(6263, 60),
(6264, 60),
(6265, 60),
(6266, 60),
(6267, 60),
(6268, 60),
(6269, 60),
(6270, 60),
(6271, 60),
(6272, 60),
(6273, 60),
(6274, 44),
(6274, 60),
(6275, 60),
(6276, 60),
(6277, 60),
(6278, 60),
(6279, 60),
(6280, 60),
(6281, 60),
(6282, 60),
(6283, 60),
(6284, 60),
(6285, 60),
(6286, 60),
(6287, 60),
(6288, 60),
(6289, 60),
(6290, 60),
(6291, 60),
(6292, 60),
(6293, 60),
(6294, 60),
(6295, 60),
(6296, 60),
(6297, 60),
(6298, 60),
(6299, 60),
(6300, 60),
(6301, 60),
(6302, 60),
(6303, 60),
(6304, 60),
(6305, 60),
(6306, 60),
(6307, 60),
(6308, 60),
(6309, 60),
(6310, 60),
(6311, 60),
(6312, 60),
(6313, 60),
(6314, 60),
(6315, 60),
(6316, 60),
(6317, 60),
(6318, 60),
(6318, 343),
(6319, 60),
(6320, 60),
(6321, 60),
(6322, 60),
(6323, 60),
(6324, 60),
(6325, 60),
(6326, 60),
(6327, 60),
(6328, 168),
(6329, 168),
(6330, 168),
(6331, 168),
(6332, 168),
(6333, 168),
(6334, 168),
(6335, 168),
(6336, 168),
(6337, 168),
(6338, 168),
(6339, 168),
(6340, 168),
(6341, 168),
(6342, 168),
(6343, 168),
(6344, 168),
(6345, 168),
(6346, 168),
(6347, 168),
(6348, 168),
(6349, 168),
(6350, 168),
(6351, 168),
(6352, 168),
(6353, 168),
(6354, 168),
(6355, 168),
(6356, 168),
(6357, 168),
(6358, 168),
(6359, 168),
(6360, 168),
(6361, 168),
(6362, 168),
(6363, 168),
(6364, 168),
(6365, 168),
(6366, 168),
(6367, 168),
(6368, 168),
(6369, 168),
(6370, 168),
(6371, 168),
(6372, 168),
(6373, 30),
(6373, 168),
(6374, 264),
(6375, 264),
(6376, 168),
(6377, 168),
(6378, 168),
(6379, 168),
(6380, 168),
(6381, 168),
(6382, 168),
(6383, 168),
(6384, 168),
(6385, 168),
(6386, 168),
(6387, 168),
(6388, 168),
(6389, 168),
(6390, 168),
(6391, 168),
(6392, 52),
(6392, 168),
(6393, 168),
(6394, 258),
(6395, 48),
(6396, 48),
(6397, 48),
(6398, 258),
(6399, 99),
(6400, 99),
(6401, 99),
(6402, 28),
(6403, 259),
(6404, 259),
(6405, 259),
(6406, 259),
(6407, 259),
(6408, 4),
(6409, 4),
(6410, 4),
(6411, 4),
(6412, 4),
(6413, 28),
(6414, 28),
(6415, 258),
(6416, 258),
(6417, 258),
(6418, 258),
(6419, 99),
(6420, 99),
(6421, 99),
(6422, 99),
(6423, 99),
(6424, 99),
(6425, 99),
(6426, 99),
(6427, 99),
(6428, 99),
(6429, 99),
(6430, 99),
(6431, 99),
(6432, 3),
(6433, 3),
(6434, 3),
(6435, 13),
(6436, 13),
(6437, 7),
(6438, 7),
(6439, 7),
(6440, 7),
(6441, 7),
(6442, 7),
(6443, 7),
(6444, 7),
(6445, 265),
(6446, 265),
(6447, 265),
(6448, 265),
(6449, 265),
(6450, 265),
(6451, 265),
(6452, 265),
(6453, 252),
(6454, 252),
(6455, 252),
(6456, 48),
(6457, 266),
(6458, 266),
(6459, 266),
(6460, 5),
(6461, 7),
(6462, 265),
(6463, 159),
(6464, 265),
(6465, 265),
(6466, 265),
(6467, 265),
(6468, 265),
(6469, 159),
(6470, 99),
(6471, 28),
(6472, 7),
(6473, 267),
(6474, 77),
(6474, 267),
(6475, 77),
(6475, 267),
(6476, 267),
(6477, 21),
(6477, 267),
(6478, 267),
(6478, 270),
(6479, 265),
(6480, 265),
(6481, 265),
(6482, 265),
(6483, 265),
(6484, 265),
(6485, 265),
(6486, 265),
(6487, 265),
(6488, 265),
(6489, 265),
(6490, 265),
(6491, 265),
(6492, 265),
(6493, 265),
(6494, 265),
(6495, 265),
(6495, 347),
(6496, 265),
(6497, 265),
(6498, 265),
(6499, 265),
(6500, 265),
(6501, 265),
(6502, 265),
(6503, 265),
(6504, 265),
(6505, 265),
(6506, 265),
(6507, 265),
(6508, 265),
(6509, 265),
(6510, 265),
(6511, 265),
(6512, 265),
(6513, 265),
(6514, 265),
(6515, 265),
(6516, 265),
(6517, 265),
(6518, 265),
(6519, 265),
(6520, 265),
(6521, 265),
(6522, 265),
(6523, 265),
(6524, 265),
(6525, 265),
(6526, 265),
(6527, 265),
(6528, 265),
(6529, 265),
(6530, 265),
(6531, 265),
(6532, 265),
(6533, 265),
(6534, 265),
(6535, 265),
(6536, 265),
(6537, 265),
(6538, 265),
(6539, 265),
(6540, 265),
(6541, 265),
(6542, 265),
(6543, 265),
(6544, 265),
(6545, 265),
(6546, 265),
(6547, 265),
(6548, 265),
(6549, 265),
(6550, 265),
(6551, 265),
(6552, 265),
(6553, 265),
(6554, 265),
(6555, 265),
(6556, 265),
(6557, 265),
(6558, 265),
(6559, 265),
(6560, 265),
(6561, 265),
(6562, 265),
(6563, 265),
(6564, 265),
(6565, 265),
(6566, 265),
(6567, 265),
(6568, 265),
(6569, 265),
(6570, 265),
(6571, 265),
(6572, 265),
(6573, 265),
(6574, 265),
(6575, 265),
(6576, 265),
(6577, 265),
(6578, 265),
(6579, 265),
(6580, 265),
(6581, 265),
(6582, 265),
(6583, 265),
(6584, 265),
(6585, 265),
(6586, 265),
(6587, 265),
(6588, 265),
(6589, 265),
(6590, 265),
(6591, 265),
(6592, 265),
(6593, 265),
(6594, 265),
(6595, 265),
(6596, 265),
(6597, 265),
(6598, 265),
(6599, 265),
(6600, 265),
(6601, 265),
(6602, 265),
(6603, 265),
(6604, 265),
(6605, 265),
(6606, 265),
(6607, 265),
(6608, 265),
(6609, 265),
(6610, 265),
(6611, 265),
(6612, 265),
(6613, 265),
(6614, 265),
(6615, 265),
(6616, 265),
(6617, 265),
(6618, 265),
(6619, 268),
(6620, 268),
(6621, 268),
(6622, 268),
(6623, 268),
(6624, 268),
(6625, 268),
(6626, 268),
(6627, 268),
(6628, 268),
(6629, 268),
(6630, 268),
(6631, 268),
(6632, 268),
(6633, 268),
(6634, 268),
(6635, 268),
(6636, 268),
(6637, 268),
(6638, 268),
(6639, 268),
(6640, 268),
(6641, 268),
(6642, 268),
(6643, 268),
(6644, 268),
(6645, 268),
(6646, 268),
(6647, 268),
(6648, 268),
(6649, 268),
(6650, 268),
(6651, 268),
(6652, 268),
(6653, 268),
(6654, 268),
(6655, 268),
(6656, 268),
(6657, 268),
(6658, 268),
(6659, 268),
(6660, 5),
(6660, 254),
(6661, 268),
(6662, 268),
(6663, 268),
(6664, 268),
(6665, 268),
(6666, 268),
(6667, 268),
(6668, 268),
(6669, 268),
(6670, 268),
(6671, 268),
(6672, 268),
(6673, 268),
(6674, 268),
(6675, 268),
(6676, 268),
(6677, 268),
(6678, 268),
(6679, 268),
(6680, 9),
(6681, 9),
(6682, 9),
(6683, 9),
(6684, 9),
(6685, 9),
(6686, 9),
(6687, 9),
(6688, 9),
(6689, 9),
(6690, 9),
(6691, 9),
(6692, 9),
(6693, 9),
(6694, 9),
(6695, 9),
(6696, 9),
(6697, 9),
(6698, 9),
(6699, 9),
(6700, 9),
(6701, 9),
(6702, 9),
(6703, 9),
(6704, 9),
(6705, 9),
(6706, 9),
(6707, 9),
(6708, 9),
(6709, 9),
(6710, 9),
(6711, 9),
(6712, 9),
(6713, 9),
(6714, 9),
(6715, 9),
(6716, 9),
(6717, 9),
(6718, 9),
(6719, 9),
(6720, 9),
(6721, 9),
(6722, 9),
(6723, 9),
(6724, 9),
(6724, 76),
(6725, 76),
(6726, 76),
(6727, 252),
(6728, 252),
(6729, 252),
(6730, 252),
(6731, 252),
(6732, 252),
(6733, 252),
(6734, 252),
(6735, 252),
(6736, 252),
(6737, 252),
(6738, 252),
(6739, 252),
(6740, 252),
(6741, 252),
(6742, 252),
(6743, 252),
(6743, 346),
(6744, 252),
(6745, 252),
(6746, 252),
(6747, 252),
(6748, 252),
(6749, 252),
(6750, 252),
(6751, 252),
(6752, 252),
(6753, 252),
(6754, 252),
(6755, 252),
(6756, 252),
(6757, 252),
(6758, 252),
(6759, 252),
(6760, 252),
(6761, 252),
(6762, 252),
(6763, 252),
(6764, 252),
(6765, 252),
(6766, 252),
(6766, 257),
(6767, 252),
(6768, 252),
(6769, 252),
(6770, 252),
(6771, 252),
(6772, 252),
(6773, 252),
(6774, 252),
(6775, 252),
(6776, 252),
(6777, 252),
(6778, 252),
(6779, 252),
(6780, 252),
(6781, 252),
(6782, 252),
(6783, 252),
(6784, 252),
(6785, 252),
(6786, 257),
(6787, 257),
(6788, 252),
(6789, 252),
(6790, 252),
(6791, 252),
(6792, 252),
(6793, 252),
(6794, 252),
(6795, 252),
(6796, 252),
(6797, 252),
(6798, 252),
(6799, 252),
(6800, 252),
(6801, 252),
(6802, 252),
(6803, 252),
(6804, 252),
(6805, 252),
(6806, 252),
(6807, 252),
(6808, 252),
(6809, 252),
(6810, 252),
(6811, 252),
(6812, 252),
(6813, 252),
(6814, 252),
(6815, 252),
(6816, 252),
(6817, 252),
(6818, 252),
(6819, 252),
(6820, 252),
(6821, 252),
(6822, 257),
(6823, 252),
(6824, 252),
(6825, 252),
(6826, 252),
(6827, 252),
(6828, 252),
(6829, 252),
(6830, 252),
(6831, 252),
(6832, 252),
(6833, 252),
(6834, 252),
(6835, 252),
(6836, 252),
(6837, 252),
(6838, 252),
(6839, 252),
(6840, 252),
(6841, 252),
(6842, 252),
(6843, 252),
(6844, 252),
(6845, 252),
(6846, 252),
(6847, 252),
(6848, 252),
(6849, 252),
(6850, 252),
(6851, 252),
(6852, 252),
(6853, 252),
(6854, 252),
(6855, 252),
(6856, 252),
(6857, 56),
(6858, 56),
(6859, 56),
(6860, 56),
(6861, 56),
(6862, 56),
(6863, 56),
(6864, 56),
(6865, 56),
(6866, 21),
(6866, 56),
(6867, 56),
(6868, 56),
(6869, 56),
(6870, 56),
(6871, 56),
(6872, 56),
(6873, 56),
(6874, 56),
(6875, 269),
(6876, 56),
(6877, 56),
(6878, 270),
(6879, 270),
(6880, 48),
(6881, 48),
(6882, 48),
(6883, 48),
(6884, 115),
(6885, 250),
(6886, 2),
(6887, 115),
(6888, 42),
(6889, 115),
(6890, 2),
(6891, 115),
(6892, 115),
(6893, 250),
(6894, 250),
(6895, 250),
(6896, 250),
(6897, 250),
(6898, 115),
(6899, 37),
(6900, 115),
(6900, 250),
(6901, 250),
(6902, 250),
(6903, 250),
(6904, 250),
(6905, 250),
(6906, 9),
(6907, 9),
(6907, 76),
(6908, 9),
(6909, 9),
(6909, 76),
(6910, 9),
(6911, 76),
(6912, 147),
(6913, 4),
(6914, 76),
(6915, 76),
(6916, 76),
(6917, 76),
(6918, 76),
(6919, 76),
(6920, 76),
(6921, 76),
(6922, 76),
(6923, 76),
(6924, 76),
(6925, 76),
(6926, 76),
(6927, 48),
(6928, 76),
(6929, 76),
(6930, 76),
(6931, 76),
(6932, 2),
(6933, 2),
(6934, 115),
(6934, 250),
(6935, 115),
(6936, 9),
(6937, 48),
(6938, 48),
(6939, 48),
(6940, 48),
(6941, 269),
(6942, 147),
(6943, 269),
(6944, 147),
(6945, 269),
(6946, 269),
(6947, 269),
(6948, 147),
(6949, 2),
(6950, 115),
(6951, 245),
(6952, 245),
(6953, 245),
(6954, 245),
(6955, 4),
(6956, 4),
(6957, 245),
(6958, 42),
(6959, 246),
(6960, 6),
(6961, 271),
(6962, 6),
(6963, 27),
(6964, 27),
(6965, 27),
(6966, 273),
(6967, 273),
(6968, 275),
(6969, 27),
(6970, 276),
(6971, 246),
(6972, 250),
(6973, 37),
(6974, 37),
(6975, 277),
(6976, 278),
(6977, 187),
(6978, 187),
(6979, 21),
(6980, 21),
(6981, 270),
(6982, 270),
(6983, 44),
(6984, 270),
(6985, 270),
(6986, 8),
(6987, 279),
(6988, 280),
(6989, 281),
(6990, 282),
(6991, 21),
(6992, 21),
(6993, 283),
(6994, 284),
(6995, 24),
(6996, 99),
(6997, 99),
(6998, 99),
(6999, 30),
(6999, 99),
(7000, 99),
(7001, 99),
(7002, 285),
(7003, 285),
(7003, 421),
(7004, 285),
(7005, 285),
(7006, 285),
(7007, 285),
(7008, 42),
(7009, 286),
(7010, 42),
(7011, 154),
(7011, 198),
(7012, 7),
(7013, 287),
(7014, 250),
(7015, 44),
(7016, 44),
(7017, 44),
(7018, 44),
(7019, 44),
(7020, 44),
(7021, 44),
(7022, 44),
(7023, 44),
(7024, 44),
(7025, 44),
(7026, 99),
(7027, 7),
(7028, 7),
(7029, 288),
(7030, 288),
(7031, 288),
(7032, 288),
(7033, 288),
(7034, 288),
(7035, 288),
(7036, 288),
(7037, 288),
(7038, 288),
(7039, 288),
(7040, 288),
(7041, 288),
(7042, 288),
(7043, 288),
(7044, 288),
(7045, 288),
(7046, 288),
(7047, 288),
(7048, 289),
(7048, 390),
(7048, 405),
(7049, 290),
(7050, 291),
(7051, 292),
(7052, 2),
(7053, 9),
(7054, 198),
(7055, 198),
(7056, 198),
(7057, 198),
(7058, 198),
(7059, 198),
(7060, 198),
(7061, 198),
(7062, 198),
(7063, 198),
(7064, 198),
(7065, 198),
(7066, 198),
(7067, 198),
(7068, 198),
(7069, 198),
(7070, 198),
(7071, 198),
(7072, 198),
(7073, 198),
(7074, 198),
(7075, 293),
(7076, 8),
(7077, 294),
(7078, 295),
(7079, 296),
(7080, 141),
(7081, 297),
(7082, 298),
(7083, 299),
(7084, 300),
(7085, 301),
(7086, 265),
(7087, 302),
(7088, 302),
(7089, 302),
(7090, 302),
(7090, 340),
(7091, 280),
(7091, 302),
(7092, 302),
(7093, 302),
(7094, 302),
(7095, 302),
(7096, 302),
(7097, 302),
(7098, 302),
(7099, 302),
(7100, 302),
(7101, 302),
(7102, 302),
(7103, 187),
(7103, 302),
(7104, 302),
(7105, 302),
(7106, 302),
(7107, 302),
(7108, 302),
(7109, 302),
(7110, 302),
(7111, 302),
(7112, 302),
(7113, 303),
(7114, 296),
(7115, 301),
(7116, 301),
(7117, 304),
(7118, 298),
(7119, 305),
(7120, 301),
(7121, 299),
(7122, 299),
(7123, 299),
(7124, 299),
(7125, 300),
(7126, 300),
(7127, 300),
(7128, 198),
(7129, 187),
(7129, 302),
(7129, 435),
(7130, 302),
(7131, 302),
(7132, 302),
(7133, 302),
(7134, 302),
(7135, 302),
(7136, 302),
(7137, 302),
(7138, 303),
(7139, 265),
(7140, 303),
(7141, 303),
(7142, 303),
(7143, 303),
(7144, 306),
(7145, 250),
(7146, 250),
(7147, 250),
(7148, 250),
(7149, 250),
(7150, 250),
(7151, 250),
(7152, 250),
(7153, 307),
(7154, 250),
(7155, 250),
(7156, 287),
(7157, 308),
(7158, 305),
(7159, 288),
(7160, 288),
(7161, 288),
(7162, 288),
(7163, 288),
(7164, 288),
(7165, 288),
(7166, 288),
(7167, 288),
(7168, 60),
(7169, 305),
(7170, 60),
(7171, 305),
(7172, 288),
(7173, 308),
(7174, 305),
(7175, 305),
(7176, 309),
(7177, 131),
(7178, 310),
(7179, 131),
(7180, 131),
(7181, 270),
(7182, 42),
(7183, 83),
(7184, 168),
(7185, 311),
(7186, 42),
(7186, 311),
(7187, 312),
(7188, 312),
(7189, 312),
(7190, 312),
(7191, 312),
(7192, 312),
(7193, 312),
(7194, 312),
(7195, 312),
(7196, 312),
(7197, 312),
(7198, 312),
(7199, 312),
(7200, 312),
(7201, 312),
(7202, 312),
(7203, 312),
(7204, 312),
(7205, 77),
(7206, 313),
(7206, 404),
(7207, 314),
(7208, 314),
(7209, 28),
(7210, 314),
(7211, 314),
(7212, 42),
(7213, 315),
(7214, 316),
(7215, 317),
(7216, 318),
(7217, 318),
(7218, 318),
(7219, 318),
(7220, 318),
(7221, 318),
(7222, 318),
(7223, 318),
(7224, 318),
(7225, 318),
(7226, 319),
(7227, 320),
(7228, 31),
(7229, 6),
(7230, 6),
(7231, 6),
(7232, 6),
(7233, 6),
(7234, 6),
(7235, 6),
(7236, 6),
(7237, 6),
(7238, 6),
(7239, 6),
(7240, 6),
(7241, 27),
(7242, 1),
(7243, 321),
(7243, 328),
(7243, 375),
(7244, 322),
(7245, 159),
(7246, 159),
(7247, 159),
(7248, 159),
(7249, 6),
(7250, 6),
(7251, 6),
(7252, 6),
(7253, 6),
(7254, 6),
(7255, 6),
(7256, 6),
(7257, 6),
(7258, 6),
(7259, 6),
(7260, 6),
(7261, 6),
(7262, 323),
(7262, 402),
(7263, 6),
(7264, 6),
(7264, 270),
(7265, 6),
(7266, 3),
(7267, 245),
(7268, 326),
(7269, 249),
(7270, 3),
(7271, 8),
(7272, 8),
(7273, 8),
(7274, 8),
(7275, 8),
(7276, 8),
(7277, 8),
(7278, 8),
(7279, 8),
(7280, 8),
(7281, 8),
(7282, 8),
(7283, 8),
(7284, 8),
(7285, 8),
(7286, 8),
(7287, 276),
(7288, 246),
(7289, 254),
(7290, 254),
(7291, 5),
(7291, 254),
(7292, 5),
(7292, 254),
(7293, 254),
(7294, 254),
(7295, 3),
(7296, 245),
(7297, 246),
(7298, 329),
(7299, 330),
(7300, 6),
(7301, 6),
(7302, 6),
(7303, 6),
(7304, 6),
(7305, 6),
(7306, 6),
(7307, 6),
(7308, 6),
(7309, 6),
(7310, 6),
(7311, 331),
(7312, 331),
(7313, 332),
(7313, 347),
(7314, 31),
(7315, 31),
(7316, 31),
(7317, 31),
(7318, 31),
(7319, 31),
(7320, 31),
(7321, 31),
(7322, 31),
(7323, 31),
(7324, 31),
(7325, 31),
(7326, 31),
(7327, 31),
(7327, 280),
(7328, 334),
(7329, 250),
(7330, 335),
(7331, 37),
(7332, 110),
(7332, 141),
(7332, 282),
(7333, 336),
(7334, 202),
(7335, 202),
(7336, 337),
(7337, 202),
(7338, 337),
(7339, 337),
(7340, 337),
(7341, 202),
(7342, 337),
(7343, 338),
(7344, 338),
(7345, 338),
(7346, 338),
(7347, 255),
(7348, 202),
(7349, 202),
(7349, 339),
(7350, 340),
(7351, 282),
(7352, 339),
(7353, 282),
(7354, 282),
(7355, 339),
(7356, 141),
(7356, 339),
(7357, 339),
(7358, 341),
(7359, 282),
(7360, 282),
(7361, 282),
(7362, 342),
(7363, 342),
(7364, 282),
(7365, 255),
(7366, 255),
(7367, 255),
(7368, 255),
(7369, 255),
(7370, 255),
(7371, 255),
(7372, 255),
(7373, 255),
(7374, 243),
(7374, 255),
(7375, 255),
(7376, 255),
(7377, 22),
(7378, 255),
(7379, 42),
(7380, 42),
(7381, 22),
(7382, 343),
(7383, 343),
(7384, 288),
(7385, 268),
(7386, 268),
(7387, 268),
(7388, 48),
(7389, 42),
(7390, 270),
(7391, 141),
(7392, 141),
(7393, 141),
(7394, 141),
(7395, 141),
(7396, 141),
(7397, 141),
(7398, 141),
(7399, 141),
(7400, 141),
(7401, 141),
(7402, 141),
(7403, 141),
(7404, 141),
(7405, 141),
(7406, 141),
(7407, 141),
(7408, 141),
(7409, 141),
(7410, 141),
(7411, 141),
(7412, 141),
(7413, 141),
(7414, 141),
(7415, 141),
(7416, 344),
(7417, 141),
(7418, 141),
(7419, 141),
(7420, 141),
(7421, 141),
(7422, 141),
(7423, 141),
(7424, 141),
(7425, 141),
(7426, 141),
(7427, 141),
(7428, 141),
(7429, 141),
(7430, 141),
(7431, 141),
(7432, 141),
(7432, 339),
(7433, 141),
(7434, 141),
(7435, 141),
(7436, 141),
(7437, 141),
(7438, 141),
(7439, 141),
(7440, 141),
(7441, 141),
(7442, 141),
(7443, 141),
(7444, 141),
(7445, 141),
(7446, 141),
(7447, 141),
(7448, 141),
(7449, 141),
(7450, 141),
(7451, 141),
(7452, 141),
(7453, 141),
(7454, 141),
(7455, 141),
(7456, 141),
(7457, 141),
(7458, 141),
(7459, 141),
(7460, 141),
(7461, 141),
(7462, 141),
(7463, 141),
(7464, 141),
(7465, 141),
(7466, 141),
(7467, 141),
(7468, 141),
(7469, 141),
(7470, 141),
(7471, 141),
(7472, 141),
(7473, 141),
(7474, 141),
(7475, 345),
(7476, 346),
(7477, 48),
(7478, 343),
(7479, 343),
(7480, 348),
(7481, 33),
(7482, 144),
(7483, 144),
(7484, 144),
(7485, 144),
(7486, 144),
(7487, 144),
(7488, 144),
(7489, 144),
(7490, 144),
(7491, 144),
(7492, 250),
(7493, 305),
(7494, 131),
(7495, 343),
(7496, 343),
(7497, 305),
(7498, 347),
(7499, 159),
(7500, 252),
(7501, 343),
(7502, 343),
(7503, 343),
(7504, 343),
(7505, 343),
(7506, 343),
(7507, 343),
(7508, 343),
(7509, 343),
(7510, 349),
(7511, 351),
(7512, 283),
(7513, 283),
(7514, 288),
(7515, 352),
(7515, 354),
(7516, 352),
(7517, 352),
(7518, 352),
(7519, 353),
(7520, 353),
(7521, 353),
(7522, 354),
(7523, 282),
(7524, 147),
(7525, 147),
(7526, 147),
(7527, 147),
(7528, 147),
(7529, 147),
(7530, 147),
(7531, 147),
(7532, 147),
(7533, 147),
(7534, 147),
(7535, 240),
(7536, 240),
(7537, 355),
(7538, 356),
(7539, 346),
(7540, 346),
(7541, 346),
(7542, 250),
(7543, 250),
(7544, 250),
(7545, 250),
(7546, 250),
(7547, 250),
(7548, 250),
(7549, 250),
(7550, 250),
(7551, 250),
(7552, 250),
(7553, 250),
(7554, 346),
(7555, 346),
(7556, 346),
(7557, 346),
(7558, 346),
(7559, 346),
(7560, 346),
(7561, 346),
(7561, 545),
(7561, 600),
(7562, 346),
(7563, 346),
(7564, 346),
(7565, 24),
(7565, 357),
(7566, 250),
(7567, 250),
(7568, 250),
(7569, 250),
(7570, 250),
(7571, 250),
(7572, 250),
(7573, 250),
(7574, 250),
(7575, 250),
(7576, 250),
(7577, 250),
(7578, 250),
(7579, 250),
(7580, 250),
(7581, 250),
(7582, 250),
(7583, 250),
(7584, 250),
(7585, 250),
(7586, 250),
(7587, 250),
(7588, 250),
(7589, 250),
(7590, 250),
(7591, 250),
(7592, 250),
(7593, 250),
(7594, 250),
(7595, 250),
(7596, 250),
(7597, 250),
(7598, 250),
(7599, 250),
(7600, 250),
(7601, 250),
(7602, 250),
(7603, 250),
(7604, 250),
(7605, 250),
(7606, 250),
(7607, 250),
(7608, 250),
(7609, 250),
(7610, 250),
(7611, 250),
(7612, 250),
(7613, 250),
(7614, 250),
(7615, 250),
(7616, 250),
(7617, 250),
(7618, 250),
(7619, 250),
(7620, 99),
(7621, 358),
(7622, 358),
(7623, 261),
(7624, 359),
(7625, 360),
(7626, 360),
(7627, 361),
(7628, 150),
(7629, 359),
(7630, 359),
(7631, 359),
(7632, 359),
(7633, 359),
(7634, 359),
(7635, 359),
(7636, 359),
(7637, 359),
(7638, 359),
(7639, 359),
(7640, 90),
(7641, 90),
(7642, 90),
(7643, 90),
(7644, 90),
(7645, 150),
(7646, 362),
(7647, 363),
(7648, 363),
(7649, 60),
(7650, 115),
(7651, 364),
(7652, 76),
(7653, 76),
(7654, 76),
(7655, 76),
(7656, 76),
(7657, 76),
(7658, 76),
(7659, 76),
(7660, 76),
(7661, 76),
(7662, 76),
(7663, 76),
(7664, 76),
(7665, 76),
(7666, 76),
(7667, 76),
(7668, 76),
(7669, 76),
(7670, 76),
(7671, 76),
(7672, 76),
(7673, 76),
(7674, 76),
(7675, 76),
(7676, 76),
(7677, 76),
(7678, 76),
(7679, 76),
(7680, 76),
(7681, 76),
(7682, 76),
(7683, 76),
(7684, 76),
(7685, 76),
(7686, 76),
(7687, 76),
(7688, 76),
(7689, 76),
(7690, 76),
(7691, 76),
(7692, 76),
(7693, 76),
(7694, 76),
(7695, 76),
(7696, 76),
(7697, 76),
(7698, 76),
(7699, 76),
(7700, 76),
(7701, 76),
(7702, 76),
(7703, 76),
(7704, 76),
(7705, 76),
(7706, 76),
(7707, 76),
(7708, 76),
(7709, 76),
(7710, 76),
(7711, 76),
(7712, 76),
(7713, 76),
(7714, 76),
(7715, 76),
(7716, 76),
(7717, 76),
(7718, 76),
(7719, 76),
(7720, 76),
(7721, 76),
(7722, 76),
(7723, 76),
(7724, 76),
(7725, 76),
(7726, 76),
(7727, 76),
(7728, 76),
(7729, 76),
(7730, 250),
(7731, 365),
(7732, 22),
(7732, 28),
(7733, 366),
(7734, 367),
(7735, 37),
(7736, 91),
(7737, 91),
(7738, 302),
(7739, 37),
(7740, 37),
(7741, 103),
(7742, 315),
(7743, 315),
(7744, 315),
(7745, 315),
(7746, 315),
(7747, 368),
(7748, 153),
(7749, 282),
(7750, 37),
(7751, 37),
(7752, 91),
(7753, 91),
(7754, 91),
(7755, 287),
(7756, 37),
(7757, 42),
(7757, 315),
(7758, 243),
(7759, 243),
(7760, 243),
(7761, 243),
(7762, 243),
(7763, 243),
(7764, 243),
(7765, 243),
(7766, 154),
(7767, 306),
(7768, 306),
(7769, 306),
(7770, 306),
(7771, 306),
(7772, 306),
(7773, 306),
(7774, 306),
(7775, 370),
(7776, 30),
(7777, 30),
(7778, 30),
(7779, 30),
(7780, 30),
(7781, 30),
(7782, 30),
(7783, 30),
(7784, 30),
(7785, 30),
(7785, 427),
(7786, 30),
(7787, 30),
(7788, 30),
(7789, 30),
(7790, 30),
(7791, 30),
(7792, 5),
(7793, 371),
(7794, 372),
(7795, 372),
(7796, 187),
(7796, 373),
(7797, 243),
(7798, 370),
(7799, 370),
(7800, 30),
(7801, 30),
(7802, 30),
(7803, 30),
(7804, 30),
(7805, 30),
(7806, 30),
(7807, 30),
(7808, 30),
(7809, 30),
(7810, 30),
(7811, 374),
(7812, 198),
(7813, 376),
(7814, 377),
(7815, 379),
(7816, 282),
(7817, 377),
(7818, 380),
(7818, 464),
(7819, 381),
(7820, 382),
(7821, 28),
(7822, 255),
(7823, 28),
(7824, 250),
(7825, 42),
(7826, 383),
(7827, 42),
(7828, 42),
(7829, 42),
(7830, 282),
(7831, 282),
(7832, 194),
(7833, 141),
(7834, 52),
(7835, 384),
(7836, 384),
(7837, 286),
(7838, 374),
(7839, 28),
(7840, 385),
(7841, 28),
(7842, 269),
(7843, 386),
(7844, 386),
(7845, 250),
(7846, 250),
(7847, 250),
(7848, 42),
(7849, 250),
(7850, 374),
(7851, 42),
(7852, 250),
(7853, 387),
(7854, 388),
(7855, 389),
(7856, 52),
(7857, 52),
(7858, 52),
(7859, 52),
(7860, 52),
(7861, 52),
(7862, 52),
(7863, 52),
(7864, 52),
(7865, 52),
(7866, 52),
(7867, 52),
(7868, 52),
(7869, 52),
(7870, 52),
(7871, 52),
(7872, 52),
(7873, 52),
(7874, 52),
(7875, 52),
(7876, 52),
(7877, 52),
(7878, 52),
(7879, 52),
(7880, 246),
(7881, 384),
(7882, 246),
(7883, 391),
(7883, 406),
(7884, 305),
(7885, 269),
(7886, 392),
(7887, 37),
(7888, 37),
(7889, 37),
(7890, 393),
(7891, 268),
(7892, 268),
(7893, 205),
(7894, 268),
(7895, 268),
(7896, 205),
(7897, 205),
(7898, 268),
(7899, 44),
(7900, 12),
(7901, 12),
(7902, 12),
(7903, 4),
(7904, 363),
(7905, 270),
(7906, 21),
(7907, 21),
(7908, 270),
(7909, 270),
(7910, 270),
(7911, 270),
(7912, 261),
(7913, 261),
(7914, 261),
(7915, 261),
(7916, 147),
(7917, 395),
(7918, 147),
(7919, 147),
(7920, 267),
(7921, 205),
(7922, 21),
(7922, 22),
(7923, 22),
(7924, 22),
(7925, 22),
(7926, 21),
(7927, 22),
(7928, 270),
(7929, 21),
(7930, 28),
(7931, 205),
(7932, 205),
(7933, 270),
(7934, 270),
(7935, 270),
(7936, 261),
(7937, 261),
(7938, 261),
(7939, 270),
(7940, 9),
(7941, 28),
(7942, 269),
(7943, 269),
(7944, 269),
(7945, 269),
(7946, 269),
(7947, 269),
(7948, 269),
(7949, 269),
(7950, 269),
(7951, 44),
(7952, 44),
(7953, 44),
(7954, 44),
(7955, 31),
(7955, 437),
(7956, 31),
(7957, 270),
(7958, 31),
(7959, 22),
(7960, 21),
(7961, 21),
(7962, 9),
(7963, 22),
(7964, 21),
(7964, 22),
(7965, 48),
(7966, 9),
(7967, 270),
(7968, 246),
(7969, 246),
(7970, 246),
(7971, 31),
(7972, 270),
(7973, 21),
(7974, 21),
(7975, 270),
(7976, 270),
(7977, 7),
(7978, 48),
(7979, 305),
(7980, 45),
(7981, 44),
(7982, 44),
(7983, 44),
(7984, 44),
(7985, 44),
(7986, 44),
(7987, 147),
(7988, 21),
(7989, 42),
(7990, 396),
(7991, 22),
(7992, 21),
(7992, 22),
(7993, 22),
(7994, 22),
(7995, 397),
(7996, 305),
(7997, 21),
(7998, 205),
(7999, 22),
(8000, 22),
(8001, 398),
(8002, 7),
(8003, 4),
(8004, 42),
(8005, 9),
(8006, 261),
(8007, 37),
(8008, 4),
(8009, 4),
(8010, 33),
(8011, 22),
(8012, 22),
(8013, 7),
(8014, 269),
(8015, 115),
(8016, 115),
(8017, 21),
(8018, 261),
(8019, 45),
(8020, 44),
(8021, 21),
(8022, 33),
(8023, 397),
(8024, 397),
(8025, 48),
(8026, 44),
(8027, 305),
(8028, 24),
(8029, 269),
(8030, 4),
(8031, 21),
(8032, 21),
(8033, 7),
(8034, 21),
(8035, 21),
(8035, 22),
(8036, 24),
(8037, 24),
(8038, 24),
(8039, 44),
(8040, 4),
(8041, 6),
(8042, 399),
(8043, 3),
(8044, 4),
(8045, 28),
(8046, 115),
(8047, 115),
(8048, 4),
(8049, 76),
(8050, 76),
(8051, 76),
(8052, 76),
(8053, 76),
(8054, 76),
(8055, 76),
(8056, 76),
(8057, 76),
(8058, 76),
(8059, 76),
(8060, 76),
(8061, 159),
(8062, 159),
(8063, 12),
(8064, 12),
(8065, 245),
(8066, 3),
(8067, 4),
(8068, 4),
(8069, 4),
(8070, 4),
(8071, 4),
(8072, 269),
(8073, 269),
(8074, 76),
(8075, 76),
(8076, 76),
(8077, 76),
(8078, 76),
(8079, 76),
(8080, 76),
(8081, 76),
(8082, 76),
(8083, 76),
(8084, 76),
(8085, 76),
(8086, 76),
(8087, 76),
(8088, 76),
(8089, 76),
(8090, 253),
(8091, 253),
(8092, 253),
(8093, 22),
(8094, 400),
(8095, 400),
(8096, 12),
(8097, 250),
(8098, 250),
(8099, 250),
(8100, 4),
(8101, 4),
(8102, 4),
(8103, 4),
(8104, 4),
(8105, 4),
(8106, 4),
(8107, 4),
(8108, 4),
(8109, 4),
(8110, 4),
(8111, 4),
(8112, 4),
(8113, 36),
(8114, 12),
(8115, 52),
(8116, 159),
(8117, 265),
(8118, 4),
(8119, 4),
(8120, 249),
(8121, 4),
(8122, 4),
(8123, 4),
(8124, 6),
(8125, 6),
(8126, 27),
(8127, 4),
(8128, 60),
(8129, 400),
(8130, 4),
(8131, 28),
(8132, 28),
(8133, 4),
(8134, 4),
(8135, 4),
(8136, 4),
(8137, 4),
(8138, 4),
(8139, 4),
(8140, 4),
(8141, 7),
(8142, 7),
(8143, 7),
(8144, 4),
(8145, 269),
(8146, 131),
(8147, 203),
(8148, 403),
(8149, 403),
(8150, 403),
(8151, 403),
(8152, 403),
(8153, 403),
(8154, 403),
(8155, 403),
(8156, 403),
(8157, 403),
(8158, 403),
(8159, 111),
(8160, 111),
(8161, 111),
(8162, 111),
(8163, 111),
(8164, 111),
(8165, 111),
(8166, 111),
(8167, 111),
(8168, 111),
(8169, 111),
(8170, 111),
(8171, 111),
(8172, 111),
(8173, 111),
(8174, 111),
(8175, 111),
(8176, 111),
(8177, 111),
(8178, 111),
(8179, 407),
(8180, 407),
(8181, 407),
(8182, 339),
(8183, 408),
(8184, 409),
(8185, 160),
(8186, 160),
(8187, 160),
(8188, 160),
(8189, 160),
(8190, 160),
(8191, 160),
(8192, 160),
(8193, 141),
(8194, 160),
(8195, 160),
(8196, 160),
(8197, 160),
(8198, 160),
(8199, 160),
(8200, 160),
(8201, 160),
(8202, 160),
(8203, 160),
(8204, 160),
(8205, 160),
(8206, 160),
(8207, 160),
(8208, 160),
(8209, 405),
(8210, 3),
(8211, 3),
(8212, 3),
(8213, 3),
(8214, 3),
(8215, 3),
(8216, 3),
(8217, 3),
(8218, 399),
(8219, 205),
(8220, 205),
(8221, 4),
(8222, 4),
(8223, 198),
(8224, 407),
(8224, 544),
(8224, 599),
(8225, 408),
(8226, 408),
(8227, 408),
(8228, 408),
(8229, 408),
(8230, 408),
(8231, 408),
(8232, 408),
(8233, 408),
(8234, 408),
(8235, 408),
(8236, 408),
(8237, 408),
(8238, 408),
(8239, 408),
(8240, 408),
(8241, 408),
(8242, 408),
(8243, 408),
(8244, 408),
(8245, 408),
(8246, 408),
(8247, 408),
(8248, 408),
(8249, 408),
(8250, 408),
(8251, 408),
(8252, 408),
(8253, 408),
(8254, 408),
(8255, 408),
(8256, 408),
(8257, 408),
(8258, 408),
(8259, 408),
(8260, 408),
(8261, 282),
(8262, 111),
(8263, 270),
(8264, 389),
(8265, 270),
(8266, 270),
(8267, 270),
(8268, 410),
(8269, 410),
(8270, 111),
(8271, 116),
(8272, 116),
(8273, 116),
(8274, 116),
(8275, 116),
(8276, 116),
(8277, 277),
(8278, 277),
(8279, 277),
(8280, 277),
(8281, 277),
(8282, 2),
(8283, 2),
(8284, 2),
(8285, 164),
(8286, 56),
(8287, 265),
(8288, 245),
(8289, 412),
(8290, 413),
(8291, 131),
(8292, 60),
(8293, 60),
(8294, 4),
(8295, 4),
(8296, 265),
(8297, 265),
(8298, 381),
(8299, 24),
(8300, 60),
(8301, 60),
(8302, 358),
(8303, 269),
(8304, 269),
(8305, 269),
(8306, 269),
(8307, 269),
(8308, 250),
(8309, 381),
(8310, 414),
(8311, 415),
(8312, 417),
(8313, 418),
(8314, 127),
(8315, 127),
(8316, 127),
(8317, 52),
(8318, 419),
(8319, 419),
(8320, 419),
(8321, 350),
(8322, 42),
(8323, 42),
(8324, 42),
(8325, 42),
(8326, 255),
(8327, 42),
(8328, 420),
(8329, 422),
(8330, 423),
(8331, 298),
(8332, 424),
(8333, 425),
(8334, 7),
(8335, 7),
(8336, 7),
(8337, 7),
(8338, 7),
(8339, 9),
(8340, 7),
(8341, 5),
(8342, 250),
(8343, 42),
(8344, 42),
(8345, 9),
(8346, 252),
(8347, 428),
(8348, 73),
(8349, 202),
(8350, 286),
(8351, 141),
(8352, 264),
(8353, 429),
(8354, 381),
(8355, 187),
(8356, 187),
(8357, 187),
(8358, 187),
(8359, 187),
(8360, 187),
(8361, 187),
(8362, 187),
(8362, 448),
(8363, 187),
(8364, 31),
(8364, 187),
(8365, 429),
(8366, 7),
(8367, 280),
(8368, 280),
(8369, 280),
(8370, 280),
(8371, 280),
(8372, 280),
(8373, 280),
(8374, 280),
(8375, 280),
(8376, 280),
(8377, 431),
(8378, 9),
(8379, 432),
(8380, 76),
(8381, 76),
(8382, 76),
(8383, 76),
(8384, 76),
(8385, 76),
(8386, 76),
(8387, 76),
(8388, 76),
(8389, 76),
(8390, 76),
(8391, 76),
(8392, 76),
(8393, 76),
(8394, 76),
(8395, 76),
(8396, 76),
(8397, 76),
(8398, 76),
(8399, 76),
(8400, 76),
(8401, 76),
(8402, 76),
(8403, 76),
(8404, 76),
(8405, 76),
(8406, 76),
(8407, 76),
(8408, 76),
(8409, 76),
(8410, 76),
(8411, 76),
(8412, 76),
(8413, 76),
(8414, 76),
(8415, 76),
(8416, 76),
(8417, 76),
(8418, 76),
(8419, 76),
(8420, 76),
(8421, 76),
(8422, 76),
(8423, 76),
(8424, 76),
(8425, 76),
(8426, 76),
(8427, 76),
(8428, 76),
(8429, 76),
(8430, 76),
(8431, 76),
(8432, 76),
(8433, 76),
(8434, 76),
(8435, 76),
(8436, 76),
(8437, 76),
(8438, 76),
(8439, 76),
(8440, 76),
(8441, 76),
(8442, 76),
(8443, 76),
(8444, 76),
(8445, 76),
(8446, 76),
(8447, 76),
(8448, 76),
(8449, 76),
(8450, 76),
(8451, 76),
(8452, 76),
(8453, 76),
(8454, 76),
(8455, 76),
(8456, 76),
(8457, 76),
(8458, 76),
(8459, 76),
(8460, 76),
(8461, 76),
(8462, 76),
(8463, 76),
(8464, 76),
(8465, 76),
(8466, 76),
(8467, 76),
(8468, 76),
(8469, 76),
(8470, 76),
(8471, 76),
(8472, 76),
(8473, 76),
(8474, 76),
(8475, 76),
(8476, 76),
(8477, 76),
(8478, 76),
(8479, 76),
(8480, 76),
(8481, 76),
(8482, 76),
(8483, 76),
(8484, 76),
(8485, 76),
(8486, 76),
(8487, 9),
(8488, 76),
(8489, 9),
(8490, 76),
(8491, 9),
(8492, 264),
(8493, 187),
(8494, 42),
(8494, 187),
(8495, 187),
(8496, 187),
(8497, 187),
(8498, 187),
(8499, 187),
(8500, 187),
(8501, 187),
(8502, 187),
(8503, 187),
(8504, 187),
(8505, 187),
(8506, 187),
(8507, 187),
(8508, 187),
(8509, 187),
(8510, 187),
(8511, 187),
(8512, 187),
(8513, 187),
(8514, 187),
(8515, 433),
(8516, 42),
(8517, 5),
(8518, 258),
(8519, 48),
(8520, 110),
(8521, 110),
(8522, 110),
(8523, 110),
(8524, 110),
(8525, 110),
(8526, 110),
(8527, 434),
(8528, 347),
(8529, 436),
(8530, 436),
(8531, 437),
(8532, 437),
(8533, 437),
(8534, 437),
(8535, 437),
(8536, 437),
(8537, 437),
(8538, 437),
(8539, 437),
(8540, 437),
(8541, 437),
(8542, 437),
(8543, 437),
(8544, 437),
(8545, 437),
(8546, 437),
(8547, 437),
(8548, 437),
(8549, 437),
(8550, 437),
(8551, 437),
(8552, 437),
(8553, 437),
(8554, 437),
(8555, 437),
(8556, 437),
(8557, 437),
(8558, 358),
(8559, 48),
(8560, 56),
(8561, 266),
(8562, 266),
(8563, 266),
(8564, 266),
(8565, 266),
(8566, 266),
(8567, 266),
(8568, 266),
(8569, 266),
(8570, 266),
(8571, 266),
(8572, 266),
(8573, 266),
(8574, 266),
(8575, 266),
(8576, 351),
(8577, 438),
(8578, 60),
(8579, 305),
(8580, 131),
(8581, 60),
(8582, 60),
(8583, 131),
(8584, 28),
(8585, 439),
(8586, 347),
(8587, 347),
(8588, 347),
(8589, 347),
(8590, 347),
(8591, 347),
(8592, 347),
(8593, 347),
(8594, 347),
(8595, 440),
(8596, 441),
(8597, 440),
(8598, 440),
(8599, 440),
(8600, 56),
(8601, 442),
(8602, 442),
(8603, 443),
(8604, 21),
(8605, 269),
(8606, 42),
(8607, 444),
(8608, 445),
(8609, 446),
(8610, 446),
(8611, 7),
(8612, 3),
(8613, 37),
(8614, 7),
(8615, 7),
(8616, 268),
(8617, 269),
(8618, 281),
(8619, 281),
(8620, 305),
(8621, 305),
(8622, 305),
(8623, 305),
(8624, 305),
(8625, 305),
(8626, 305),
(8627, 305),
(8628, 305),
(8629, 447),
(8630, 447),
(8631, 388),
(8632, 448),
(8633, 448),
(8634, 305),
(8635, 305),
(8636, 449),
(8637, 449),
(8638, 250),
(8639, 450),
(8640, 376),
(8641, 376),
(8642, 376),
(8643, 376),
(8644, 376),
(8645, 376),
(8646, 376),
(8647, 376),
(8648, 376),
(8649, 376),
(8650, 376),
(8651, 376),
(8652, 376),
(8653, 48),
(8654, 21),
(8655, 298),
(8656, 298),
(8657, 287),
(8658, 4),
(8659, 4),
(8660, 4),
(8661, 4),
(8662, 4),
(8663, 42),
(8664, 451),
(8665, 249),
(8666, 249),
(8667, 249),
(8668, 249),
(8669, 452),
(8670, 453),
(8671, 40),
(8672, 449),
(8673, 449),
(8674, 449),
(8675, 449),
(8676, 449),
(8677, 449),
(8678, 449),
(8679, 449),
(8680, 374),
(8681, 298),
(8682, 256),
(8683, 168),
(8684, 41),
(8685, 41),
(8686, 454),
(8687, 41),
(8688, 455),
(8689, 41),
(8690, 41),
(8691, 41),
(8692, 41),
(8693, 456),
(8694, 255),
(8695, 255),
(8696, 41),
(8697, 41),
(8698, 41),
(8699, 458),
(8700, 458),
(8701, 459),
(8702, 460),
(8703, 459),
(8704, 459),
(8705, 459),
(8706, 461),
(8706, 497),
(8707, 52),
(8708, 462),
(8709, 270),
(8710, 270),
(8711, 270),
(8712, 270),
(8713, 270),
(8714, 270),
(8715, 463),
(8716, 42),
(8717, 42),
(8718, 77),
(8719, 464),
(8720, 465),
(8721, 465),
(8722, 465),
(8723, 465),
(8724, 465),
(8725, 465),
(8726, 465),
(8727, 465),
(8728, 465),
(8729, 465),
(8730, 465),
(8731, 465),
(8732, 465),
(8733, 466),
(8734, 42),
(8735, 42),
(8736, 42),
(8737, 42),
(8738, 42),
(8739, 42),
(8740, 42),
(8741, 254),
(8742, 42),
(8743, 42),
(8744, 42),
(8745, 42),
(8746, 42),
(8747, 42),
(8748, 42),
(8749, 42),
(8750, 42),
(8751, 42),
(8752, 42),
(8753, 42),
(8754, 42),
(8755, 42),
(8756, 42),
(8757, 42),
(8758, 42),
(8759, 42),
(8760, 42),
(8761, 42),
(8762, 42),
(8763, 42),
(8764, 42),
(8765, 42),
(8766, 42),
(8767, 42),
(8768, 42),
(8769, 42),
(8770, 42),
(8771, 42),
(8772, 42),
(8773, 42),
(8774, 42),
(8775, 42),
(8776, 42),
(8777, 42),
(8778, 42),
(8779, 42),
(8780, 42),
(8781, 42),
(8782, 42),
(8783, 42),
(8784, 42),
(8785, 42),
(8786, 42),
(8787, 42),
(8788, 42),
(8789, 42),
(8790, 42),
(8791, 42),
(8792, 42),
(8793, 42),
(8794, 42),
(8795, 42),
(8796, 42),
(8797, 56),
(8798, 74),
(8799, 42),
(8800, 42),
(8801, 42),
(8802, 42),
(8803, 42),
(8804, 42),
(8805, 42),
(8805, 310),
(8806, 42),
(8807, 42),
(8808, 42),
(8809, 42),
(8810, 42),
(8811, 42),
(8812, 42),
(8813, 42),
(8814, 42),
(8815, 42),
(8816, 42),
(8817, 42),
(8818, 42),
(8819, 42),
(8820, 42),
(8821, 42),
(8822, 42),
(8823, 42),
(8824, 42),
(8825, 42),
(8826, 42),
(8827, 42),
(8828, 42),
(8829, 2),
(8830, 300),
(8831, 60),
(8832, 31),
(8833, 31),
(8834, 31),
(8835, 21),
(8836, 31),
(8837, 261),
(8838, 467),
(8839, 468),
(8840, 468),
(8841, 468),
(8842, 468),
(8843, 468),
(8844, 141),
(8845, 21),
(8846, 298),
(8847, 298),
(8848, 298),
(8849, 298),
(8850, 470),
(8851, 70),
(8852, 70),
(8853, 70),
(8854, 70),
(8855, 70),
(8856, 70),
(8857, 70),
(8858, 70),
(8859, 70),
(8860, 70),
(8861, 70),
(8862, 70),
(8863, 70),
(8864, 70),
(8865, 70),
(8866, 70),
(8867, 70),
(8868, 70),
(8869, 70),
(8870, 70),
(8871, 70),
(8872, 70),
(8873, 70),
(8874, 70),
(8875, 70),
(8876, 70),
(8877, 70),
(8878, 70),
(8879, 70),
(8880, 70),
(8881, 70),
(8882, 70),
(8883, 70),
(8884, 70),
(8885, 70),
(8886, 70),
(8887, 70),
(8888, 70),
(8889, 470),
(8890, 471),
(8891, 471),
(8892, 8),
(8893, 472),
(8894, 473),
(8895, 37),
(8896, 186),
(8897, 391),
(8898, 474),
(8899, 374),
(8900, 374),
(8901, 54),
(8902, 305),
(8903, 381),
(8904, 381),
(8905, 381),
(8906, 381),
(8907, 381),
(8908, 381),
(8909, 381),
(8910, 7),
(8911, 7),
(8912, 164),
(8913, 7),
(8914, 7),
(8915, 7),
(8916, 7),
(8917, 7),
(8918, 7),
(8919, 7),
(8920, 7),
(8921, 7),
(8922, 7),
(8923, 7),
(8924, 7),
(8925, 7),
(8926, 7),
(8927, 7),
(8928, 7),
(8929, 7),
(8930, 7),
(8931, 440),
(8932, 305),
(8933, 305),
(8934, 305),
(8935, 305),
(8936, 4),
(8937, 4),
(8938, 4),
(8939, 7),
(8940, 7),
(8941, 52),
(8942, 150),
(8943, 475),
(8944, 141),
(8945, 7),
(8946, 250),
(8947, 154),
(8948, 4),
(8949, 4),
(8950, 250),
(8951, 144),
(8952, 7),
(8953, 7),
(8954, 423),
(8955, 476),
(8956, 250),
(8957, 173),
(8958, 477),
(8959, 28),
(8961, 173),
(8962, 173),
(8964, 42),
(8965, 91),
(8966, 203),
(8967, 2),
(8968, 18),
(8969, 18),
(8970, 18),
(8971, 24),
(8972, 7),
(8974, 37),
(8975, 4),
(8976, 30),
(8977, 478),
(8978, 37),
(8979, 7),
(8981, 7),
(8982, 7),
(8984, 7),
(8986, 7),
(8987, 7),
(8988, 7),
(8989, 7),
(8990, 7),
(8991, 7),
(8993, 7),
(8995, 7),
(8996, 7),
(8997, 7),
(8998, 7),
(8999, 7),
(9001, 187),
(9002, 21),
(9003, 221),
(9004, 28),
(9005, 480),
(9006, 44),
(9008, 7),
(9013, 7),
(9019, 7),
(9021, 2),
(9022, 276),
(9023, 276),
(9024, 14),
(9025, 14),
(9026, 17),
(9027, 17),
(9028, 17),
(9029, 481),
(9030, 7),
(9031, 7),
(9032, 7),
(9033, 7),
(9034, 7),
(9035, 4),
(9036, 50),
(9037, 60),
(9038, 7),
(9039, 250),
(9040, 42),
(9041, 2),
(9042, 2),
(9043, 4),
(9044, 101),
(9045, 7),
(9046, 108),
(9047, 2),
(9048, 30),
(9049, 170),
(9050, 482),
(9051, 77),
(9052, 91),
(9053, 52),
(9054, 91),
(9055, 2),
(9056, 133),
(9057, 150),
(9058, 483),
(9059, 77),
(9060, 77),
(9061, 77),
(9062, 77),
(9063, 77),
(9064, 77),
(9065, 240),
(9066, 7),
(9067, 7),
(9068, 7),
(9069, 7),
(9070, 484),
(9070, 34515),
(9070, 34517),
(9071, 240),
(9072, 250),
(9073, 250),
(9074, 250),
(9075, 250),
(9076, 60),
(9077, 103),
(9078, 485),
(9079, 243),
(9080, 154),
(9081, 154),
(9082, 283),
(9083, 486),
(9084, 91),
(9085, 4),
(9086, 4),
(9087, 4),
(9088, 4),
(9089, 30),
(9090, 30),
(9091, 30),
(9092, 30),
(9093, 30),
(9094, 30),
(9095, 487),
(9096, 194),
(9097, 5),
(9098, 488),
(9099, 28),
(9100, 52),
(9101, 52),
(9102, 52),
(9103, 52),
(9104, 52),
(9105, 52),
(9106, 42),
(9107, 159),
(9108, 2),
(9109, 116),
(9110, 116),
(9111, 116),
(9112, 116),
(9113, 116),
(9114, 489),
(9114, 34538),
(9115, 159),
(9116, 168),
(9117, 42),
(9118, 159),
(9119, 7),
(9120, 7),
(9121, 7),
(9122, 7),
(9123, 159),
(9124, 7),
(9125, 490),
(9126, 5),
(9127, 5),
(9128, 491),
(9129, 492),
(9130, 240),
(9131, 250),
(9132, 42),
(9133, 28),
(9134, 28),
(9135, 77),
(9136, 77),
(9137, 42),
(9138, 42),
(9139, 42),
(9140, 480),
(9141, 42),
(9142, 480),
(9143, 42),
(9144, 493),
(9145, 494),
(9146, 495),
(9147, 496),
(9148, 497),
(9149, 497),
(9149, 9149),
(9150, 250),
(9151, 101),
(9152, 77),
(9153, 498),
(9154, 77),
(9155, 499),
(9156, 21),
(9157, 91),
(9158, 500),
(9159, 17),
(9160, 17),
(9161, 12),
(9162, 82),
(9163, 84),
(9164, 29),
(9165, 501),
(9166, 37),
(9167, 503),
(9168, 9168),
(9169, 504),
(9170, 159),
(9171, 159),
(9172, 159),
(9173, 159),
(9174, 505),
(9174, 34612),
(9175, 144),
(9176, 7),
(9177, 7),
(9178, 7),
(9179, 7),
(9180, 7),
(9181, 7),
(9182, 7),
(9183, 7),
(9184, 7),
(9185, 27),
(9186, 109),
(9187, 240),
(9188, 21),
(9189, 21),
(9190, 21),
(9191, 21),
(9192, 21),
(9193, 250),
(9194, 250),
(9195, 250),
(9196, 250),
(9197, 250),
(9198, 250),
(9199, 250),
(9200, 250),
(9201, 250),
(9202, 250),
(9203, 506),
(9204, 103),
(9205, 30),
(9206, 507),
(9206, 34771),
(9206, 34950),
(9207, 86),
(9208, 508),
(9209, 103),
(9210, 91),
(9211, 159),
(9212, 159),
(9213, 4),
(9214, 5),
(9215, 510),
(9216, 30),
(9217, 30),
(9218, 30),
(9219, 30),
(9220, 30),
(9221, 30),
(9222, 157),
(9223, 157),
(9224, 157),
(9225, 157),
(9226, 157),
(9227, 156),
(9228, 156),
(9229, 50),
(9230, 163),
(9231, 163),
(9232, 28),
(9233, 250),
(9234, 52),
(9235, 52),
(9236, 403),
(9237, 159),
(9238, 159),
(9239, 159),
(9240, 42),
(9241, 160),
(9242, 29),
(9243, 161),
(9244, 116),
(9245, 116),
(9246, 116),
(9247, 159),
(9248, 159),
(9249, 142),
(9250, 236),
(9251, 60),
(9252, 512),
(9252, 34615),
(9253, 116),
(9254, 116),
(9255, 130),
(9256, 7),
(9257, 76),
(9258, 76),
(9259, 7),
(9260, 7),
(9261, 7),
(9262, 7),
(9263, 7),
(9264, 7),
(9265, 7),
(9266, 7),
(9267, 7),
(9268, 7),
(9269, 7),
(9270, 7),
(9271, 7),
(9272, 7),
(9273, 7),
(9274, 159),
(9275, 159),
(9276, 159),
(9277, 159),
(9278, 103),
(9279, 7),
(9280, 7),
(9281, 7),
(9282, 7),
(9283, 7),
(9284, 237),
(9285, 159),
(9286, 7),
(9287, 513),
(9288, 9288),
(9289, 514),
(9290, 187),
(9291, 231),
(9292, 159),
(9293, 21),
(9294, 515),
(9295, 516),
(9296, 517),
(9296, 34636),
(9297, 9297),
(9298, 9298),
(9299, 518),
(9300, 519),
(9301, 9301),
(9302, 116),
(9303, 250),
(9304, 250),
(9305, 4),
(9306, 520),
(9306, 34708),
(9307, 521),
(9308, 522),
(9309, 479),
(9310, 28),
(9311, 523),
(9312, 523),
(9312, 9312),
(9313, 42),
(9314, 42),
(9315, 42),
(9316, 42),
(9317, 42),
(9318, 42),
(9319, 42),
(9320, 496),
(9321, 497),
(9322, 497),
(9323, 497),
(9324, 497),
(9325, 190),
(9326, 497),
(9327, 190),
(9328, 190),
(9329, 524),
(9330, 52),
(9331, 525),
(9332, 526),
(9333, 2),
(9334, 2),
(9335, 2),
(9336, 2),
(9337, 2),
(9338, 2),
(9339, 2),
(9340, 2),
(9341, 2),
(9342, 2),
(9343, 2),
(9344, 2),
(9345, 2),
(9346, 44),
(9347, 44),
(9348, 17),
(9349, 12),
(9350, 12),
(9351, 12),
(9352, 12),
(9353, 12),
(9354, 12),
(9355, 12),
(9356, 12),
(9357, 12),
(9358, 5),
(9359, 5),
(9360, 527),
(9361, 77),
(9362, 77),
(9363, 77),
(9364, 9364),
(9365, 159),
(9366, 141),
(9367, 141),
(9368, 232),
(9369, 529),
(9370, 7),
(9371, 7),
(9372, 7),
(9373, 7),
(9374, 7),
(9375, 7),
(9376, 7),
(9377, 7),
(9378, 7),
(9379, 7),
(9380, 7),
(9381, 9381),
(9381, 34728),
(9382, 7),
(9383, 7),
(9384, 7),
(9385, 7),
(9386, 7),
(9387, 7),
(9388, 7),
(9389, 7),
(9390, 7),
(9391, 7),
(9392, 7),
(9393, 7),
(9394, 7),
(9395, 7),
(9396, 7),
(9397, 7),
(9398, 7),
(9399, 7),
(9400, 7),
(9401, 7),
(9402, 7),
(9403, 9403),
(9403, 35066),
(9404, 9404),
(9405, 9405),
(9405, 34942),
(9406, 147),
(9407, 21),
(9408, 21),
(9409, 21),
(9410, 250),
(9411, 250),
(9412, 250),
(9413, 250),
(9414, 250),
(9415, 250),
(9416, 250),
(9417, 250),
(9418, 250),
(9419, 250),
(9420, 250),
(9421, 159),
(9422, 530),
(9423, 239),
(9424, 531),
(9425, 60),
(9426, 60),
(9427, 60),
(9428, 60),
(9429, 60),
(9430, 60),
(9431, 60),
(9432, 60),
(9433, 210),
(9434, 210),
(9435, 159),
(9436, 4),
(9437, 4),
(9438, 4),
(9439, 4),
(9440, 4),
(9441, 4),
(9442, 4),
(9443, 4),
(9444, 4),
(9445, 4),
(9446, 4),
(9447, 4),
(9448, 4),
(9449, 4),
(9450, 4),
(9451, 4),
(9452, 4),
(9453, 4),
(9454, 4),
(9455, 4),
(9456, 4),
(9457, 4),
(9458, 4),
(9459, 4),
(9460, 4),
(9461, 4),
(9462, 4),
(9463, 4),
(9464, 4),
(9465, 30),
(9466, 157),
(9467, 157),
(9468, 157),
(9469, 157),
(9470, 157),
(9471, 121),
(9472, 44),
(9473, 44),
(9474, 156),
(9475, 156),
(9476, 156),
(9477, 156),
(9478, 163),
(9479, 532),
(9479, 34886),
(9480, 52),
(9481, 52),
(9482, 52),
(9483, 533),
(9484, 534),
(9485, 9485),
(9486, 160),
(9487, 56),
(9488, 159),
(9489, 219),
(9490, 535),
(9491, 7),
(9492, 7),
(9493, 536),
(9494, 7),
(9495, 7),
(9496, 7),
(9497, 7),
(9498, 7),
(9499, 7),
(9500, 7),
(9501, 7),
(9502, 7),
(9503, 7),
(9504, 12),
(9505, 159),
(9506, 7),
(9507, 7),
(9508, 7),
(9509, 7),
(9510, 7),
(9511, 7),
(9512, 7),
(9513, 7),
(9514, 7),
(9515, 7),
(9516, 159),
(9517, 159),
(9518, 7),
(9519, 7),
(9520, 7),
(9521, 157),
(9522, 12),
(9523, 5),
(9524, 12),
(9525, 159),
(9526, 103),
(9527, 537),
(9528, 65),
(9529, 181),
(9530, 91),
(9531, 538),
(9532, 24),
(9533, 111),
(9534, 4),
(9535, 115),
(9536, 115),
(9537, 115),
(9538, 116),
(9539, 28),
(9540, 28),
(9541, 28),
(9542, 28),
(9543, 42),
(9544, 42),
(9545, 42),
(9546, 42),
(9547, 130),
(9548, 133),
(9549, 248),
(9550, 71),
(9551, 71),
(9552, 492),
(9553, 190),
(9554, 497),
(9555, 24),
(9556, 24),
(9557, 24),
(9558, 2),
(9559, 2),
(9560, 2),
(9561, 44),
(9562, 48),
(9563, 9563),
(9564, 12),
(9565, 12),
(9566, 12),
(9567, 12),
(9568, 12),
(9569, 12),
(9570, 12),
(9571, 24),
(9572, 9572),
(9573, 159),
(9574, 160),
(9575, 7),
(9576, 9576),
(9577, 7),
(9578, 7),
(9579, 7),
(9580, 7),
(9581, 7),
(9582, 7),
(9583, 7),
(9584, 7),
(9585, 7),
(9586, 7),
(9587, 7),
(9588, 7),
(9589, 7),
(9590, 7),
(9591, 7),
(9592, 7),
(9593, 7),
(9594, 7),
(9595, 7),
(9596, 7),
(9597, 7),
(9598, 7),
(9599, 7),
(9600, 7),
(9601, 7),
(9602, 9602),
(9603, 21),
(9604, 21),
(9605, 21),
(9606, 21),
(9607, 21),
(9608, 21),
(9609, 250),
(9610, 239),
(9611, 60),
(9612, 154),
(9613, 30),
(9614, 4),
(9615, 14),
(9616, 159),
(9617, 159),
(9618, 4),
(9619, 4),
(9620, 4),
(9621, 4),
(9622, 4),
(9623, 4),
(9624, 4),
(9625, 4),
(9626, 4),
(9627, 4),
(9628, 4),
(9629, 4),
(9630, 157),
(9631, 539),
(9631, 34968),
(9632, 540),
(9633, 44),
(9634, 44),
(9635, 541),
(9636, 52),
(9637, 52),
(9638, 542),
(9638, 34979),
(9639, 78),
(9640, 159),
(9641, 219),
(9642, 116),
(9643, 24),
(9644, 24),
(9645, 7),
(9646, 7),
(9647, 7),
(9648, 7),
(9649, 7),
(9650, 7),
(9651, 7),
(9652, 7),
(9653, 7),
(9654, 7),
(9655, 7),
(9656, 7),
(9657, 159),
(9658, 7),
(9659, 7),
(9660, 7),
(9661, 7),
(9662, 7),
(9663, 159),
(9664, 543),
(9665, 7),
(9666, 7),
(9667, 7),
(9668, 7),
(9669, 7),
(9670, 7),
(9671, 7),
(9672, 7),
(9673, 7),
(9674, 7),
(9675, 7),
(9676, 7),
(9677, 7),
(9678, 9678),
(9679, 24),
(9680, 24),
(9681, 24),
(9682, 24),
(9683, 4),
(9684, 115),
(9685, 181),
(9686, 116),
(9687, 28),
(9688, 28),
(9689, 28),
(9690, 28),
(9691, 28),
(9692, 28),
(9693, 9693),
(9694, 9694),
(9695, 42),
(9696, 154),
(9697, 248),
(9698, 495),
(9699, 497),
(9700, 497),
(9701, 497),
(9702, 170),
(9703, 7),
(9704, 7),
(9705, 7),
(9706, 7),
(9707, 7),
(9708, 7),
(9709, 7),
(9710, 7),
(9711, 7),
(9712, 7),
(9713, 28),
(9714, 28),
(9715, 28),
(9716, 77),
(9717, 77),
(9718, 250),
(9719, 283),
(9720, 283),
(9721, 30),
(9722, 546),
(9723, 7),
(9724, 250),
(9725, 77),
(9726, 77),
(9727, 30),
(9728, 30),
(9729, 231),
(9730, 116),
(9731, 547),
(9732, 42),
(9733, 42),
(9734, 42),
(9735, 42),
(9736, 548),
(9737, 2),
(9738, 21),
(9739, 21),
(9740, 21),
(9741, 250),
(9742, 250),
(9743, 250),
(9744, 250),
(9745, 3),
(9746, 3),
(9747, 3),
(9748, 3),
(9749, 3),
(9750, 3),
(9751, 3),
(9752, 7),
(9753, 7),
(9754, 7),
(9755, 7),
(9756, 3),
(9757, 3),
(9758, 3),
(9759, 3),
(9760, 3),
(9761, 3),
(9762, 3),
(9763, 3),
(9764, 3),
(9765, 7),
(9766, 7),
(9767, 7),
(9768, 7),
(9769, 7),
(9770, 7),
(9771, 7),
(9772, 7),
(9773, 7),
(9774, 7),
(9775, 7),
(9776, 7),
(9777, 7),
(9778, 7),
(9779, 7),
(9780, 7),
(9781, 7),
(9782, 7),
(9783, 7),
(9784, 7),
(9785, 7),
(9786, 7),
(9787, 7),
(9788, 7),
(9789, 7),
(9790, 164),
(9791, 5),
(9792, 28),
(9793, 28),
(9794, 2),
(9795, 2),
(9796, 2),
(9797, 2),
(9798, 2),
(9799, 2),
(9800, 2),
(9801, 2),
(9802, 2),
(9803, 103),
(9804, 103),
(9805, 103),
(9806, 103),
(9807, 4),
(9808, 60),
(9809, 60),
(9810, 60),
(9811, 60),
(9812, 549),
(9813, 115),
(9814, 42),
(9815, 27),
(9816, 27),
(9817, 27),
(9818, 423),
(9819, 550),
(9820, 551),
(9821, 42),
(9822, 321),
(9823, 321),
(9824, 321),
(9825, 321),
(9826, 276),
(9827, 6),
(9828, 6),
(9829, 6),
(9830, 6),
(9831, 254),
(9832, 141),
(9833, 141),
(9834, 141),
(9835, 141),
(9836, 141),
(9837, 76),
(9838, 154),
(9839, 52),
(9840, 52),
(9841, 52),
(9842, 52),
(9843, 52),
(9844, 52),
(9845, 52),
(9846, 115),
(9847, 253),
(9848, 4),
(9849, 36),
(9850, 4),
(9851, 2),
(9852, 2),
(9853, 42),
(9854, 42),
(9855, 42),
(9856, 42),
(9857, 42),
(9858, 42),
(9859, 42),
(9860, 42),
(9861, 42),
(9862, 42),
(9863, 42),
(9864, 42),
(9865, 42),
(9866, 42),
(9867, 42),
(9868, 42),
(9869, 552),
(9870, 101),
(9871, 77),
(9872, 553),
(9873, 77);
INSERT INTO `smdevicenamebrand` (`DeviceNameID`, `BrandID`) VALUES
(9874, 554),
(9875, 21),
(9876, 91),
(9877, 555),
(9878, 17),
(9879, 17),
(9880, 12),
(9881, 82),
(9882, 84),
(9883, 29),
(9884, 556),
(9885, 37),
(9886, 558),
(9887, 558),
(9888, 559),
(9889, 159),
(9890, 159),
(9891, 159),
(9892, 159),
(9893, 560),
(9894, 144),
(9895, 7),
(9896, 7),
(9897, 7),
(9898, 7),
(9899, 7),
(9900, 7),
(9901, 7),
(9902, 7),
(9903, 7),
(9904, 27),
(9905, 109),
(9906, 240),
(9907, 21),
(9908, 21),
(9909, 21),
(9910, 21),
(9911, 21),
(9912, 250),
(9913, 250),
(9914, 250),
(9915, 250),
(9916, 250),
(9917, 250),
(9918, 250),
(9919, 250),
(9920, 250),
(9921, 250),
(9922, 561),
(9923, 103),
(9924, 30),
(9925, 562),
(9926, 86),
(9927, 563),
(9928, 103),
(9929, 91),
(9930, 159),
(9931, 159),
(9932, 4),
(9933, 5),
(9934, 565),
(9935, 30),
(9936, 30),
(9937, 30),
(9938, 30),
(9939, 30),
(9940, 30),
(9941, 157),
(9942, 157),
(9943, 157),
(9944, 157),
(9945, 157),
(9946, 156),
(9947, 156),
(9948, 50),
(9949, 163),
(9950, 163),
(9951, 28),
(9952, 250),
(9953, 52),
(9954, 52),
(9955, 403),
(9956, 159),
(9957, 159),
(9958, 159),
(9959, 42),
(9960, 160),
(9961, 29),
(9962, 161),
(9963, 116),
(9964, 116),
(9965, 116),
(9966, 159),
(9967, 159),
(9968, 142),
(9969, 236),
(9970, 60),
(9971, 567),
(9972, 116),
(9973, 116),
(9974, 130),
(9975, 7),
(9976, 76),
(9977, 76),
(9978, 7),
(9979, 7),
(9980, 7),
(9981, 7),
(9982, 7),
(9983, 7),
(9984, 7),
(9985, 7),
(9986, 7),
(9987, 7),
(9988, 7),
(9989, 7),
(9990, 7),
(9991, 7),
(9992, 7),
(9993, 159),
(9994, 159),
(9995, 159),
(9996, 159),
(9997, 103),
(9998, 7),
(9999, 7),
(10000, 7),
(10001, 7),
(10002, 7),
(10003, 237),
(10004, 159),
(10005, 7),
(10006, 568),
(10007, 568),
(10008, 569),
(10009, 187),
(10010, 231),
(10011, 159),
(10012, 21),
(10013, 570),
(10014, 571),
(10015, 572),
(10016, 572),
(10017, 572),
(10018, 573),
(10019, 574),
(10020, 570),
(10021, 116),
(10022, 250),
(10023, 250),
(10024, 4),
(10025, 575),
(10026, 576),
(10027, 577),
(10028, 479),
(10029, 28),
(10030, 578),
(10031, 578),
(10032, 42),
(10033, 42),
(10034, 42),
(10035, 42),
(10036, 42),
(10037, 42),
(10038, 42),
(10039, 496),
(10040, 497),
(10041, 497),
(10042, 497),
(10043, 497),
(10044, 190),
(10045, 497),
(10046, 190),
(10047, 190),
(10048, 579),
(10049, 52),
(10050, 580),
(10051, 581),
(10052, 2),
(10053, 2),
(10054, 2),
(10055, 2),
(10056, 2),
(10057, 2),
(10058, 2),
(10059, 2),
(10060, 2),
(10061, 2),
(10062, 2),
(10063, 2),
(10064, 2),
(10065, 44),
(10066, 44),
(10067, 17),
(10068, 12),
(10069, 12),
(10070, 12),
(10071, 12),
(10072, 12),
(10073, 12),
(10074, 12),
(10075, 12),
(10076, 12),
(10077, 5),
(10078, 5),
(10079, 582),
(10080, 77),
(10081, 77),
(10082, 77),
(10083, 558),
(10084, 159),
(10085, 141),
(10086, 141),
(10087, 232),
(10088, 584),
(10089, 7),
(10090, 7),
(10091, 7),
(10092, 7),
(10093, 7),
(10094, 7),
(10095, 7),
(10096, 7),
(10097, 7),
(10098, 7),
(10099, 7),
(10100, 579),
(10101, 7),
(10102, 7),
(10103, 7),
(10104, 7),
(10105, 7),
(10106, 7),
(10107, 7),
(10108, 7),
(10109, 7),
(10110, 7),
(10111, 7),
(10112, 7),
(10113, 7),
(10114, 7),
(10115, 7),
(10116, 7),
(10117, 7),
(10118, 7),
(10119, 7),
(10120, 7),
(10121, 7),
(10122, 579),
(10123, 579),
(10124, 579),
(10125, 147),
(10126, 21),
(10127, 21),
(10128, 21),
(10129, 250),
(10130, 250),
(10131, 250),
(10132, 250),
(10133, 250),
(10134, 250),
(10135, 250),
(10136, 250),
(10137, 250),
(10138, 250),
(10139, 250),
(10140, 159),
(10141, 585),
(10142, 239),
(10143, 586),
(10144, 60),
(10145, 60),
(10146, 60),
(10147, 60),
(10148, 60),
(10149, 60),
(10150, 60),
(10151, 60),
(10152, 210),
(10153, 210),
(10154, 159),
(10155, 4),
(10156, 4),
(10157, 4),
(10158, 4),
(10159, 4),
(10160, 4),
(10161, 4),
(10162, 4),
(10163, 4),
(10164, 4),
(10165, 4),
(10166, 4),
(10167, 4),
(10168, 4),
(10169, 4),
(10170, 4),
(10171, 4),
(10172, 4),
(10173, 4),
(10174, 4),
(10175, 4),
(10176, 2),
(10177, 2),
(10178, 2),
(10179, 2),
(10180, 2),
(10181, 2),
(10182, 2),
(10183, 2),
(10184, 2),
(10185, 2),
(10186, 485),
(10187, 4),
(10188, 4),
(10189, 4),
(10190, 4),
(10191, 4),
(10192, 4),
(10193, 4),
(10194, 4),
(10195, 30),
(10196, 157),
(10197, 157),
(10198, 157),
(10199, 157),
(10200, 157),
(10201, 121),
(10202, 44),
(10203, 44),
(10204, 156),
(10205, 156),
(10206, 156),
(10207, 156),
(10208, 163),
(10209, 587),
(10210, 52),
(10211, 52),
(10212, 52),
(10213, 588),
(10214, 589),
(10215, 555),
(10216, 160),
(10217, 56),
(10218, 159),
(10219, 219),
(10220, 590),
(10221, 7),
(10222, 7),
(10223, 591),
(10224, 7),
(10225, 7),
(10226, 7),
(10227, 7),
(10228, 7),
(10229, 7),
(10230, 7),
(10231, 7),
(10232, 7),
(10233, 7),
(10234, 12),
(10235, 159),
(10236, 7),
(10237, 7),
(10238, 7),
(10239, 7),
(10240, 7),
(10241, 7),
(10242, 7),
(10243, 7),
(10244, 7),
(10245, 7),
(10246, 159),
(10247, 159),
(10248, 7),
(10249, 7),
(10250, 7),
(10251, 157),
(10252, 12),
(10253, 5),
(10254, 12),
(10255, 159),
(10256, 103),
(10257, 592),
(10258, 65),
(10259, 181),
(10260, 91),
(10261, 593),
(10262, 24),
(10263, 111),
(10264, 4),
(10265, 115),
(10266, 115),
(10267, 115),
(10268, 116),
(10269, 28),
(10270, 28),
(10271, 28),
(10272, 28),
(10273, 42),
(10274, 42),
(10275, 42),
(10276, 42),
(10277, 130),
(10278, 133),
(10279, 248),
(10280, 71),
(10281, 71),
(10282, 492),
(10283, 190),
(10284, 497),
(10285, 24),
(10286, 24),
(10287, 24),
(10288, 2),
(10289, 2),
(10290, 2),
(10291, 44),
(10292, 48),
(10293, 578),
(10294, 12),
(10295, 12),
(10296, 12),
(10297, 12),
(10298, 12),
(10299, 12),
(10300, 12),
(10301, 24),
(10302, 558),
(10303, 159),
(10304, 160),
(10305, 7),
(10306, 579),
(10307, 7),
(10308, 7),
(10309, 7),
(10310, 7),
(10311, 7),
(10312, 7),
(10313, 7),
(10314, 7),
(10315, 7),
(10316, 7),
(10317, 7),
(10318, 7),
(10319, 7),
(10320, 7),
(10321, 7),
(10322, 7),
(10323, 7),
(10324, 7),
(10325, 7),
(10326, 7),
(10327, 7),
(10328, 7),
(10329, 7),
(10330, 7),
(10331, 7),
(10332, 579),
(10333, 21),
(10334, 21),
(10335, 21),
(10336, 21),
(10337, 21),
(10338, 21),
(10339, 250),
(10340, 239),
(10341, 60),
(10342, 154),
(10343, 30),
(10344, 4),
(10345, 14),
(10346, 159),
(10347, 159),
(10348, 4),
(10349, 4),
(10350, 4),
(10351, 4),
(10352, 4),
(10353, 4),
(10354, 4),
(10355, 4),
(10356, 4),
(10357, 4),
(10358, 4),
(10359, 4),
(10360, 157),
(10361, 594),
(10362, 595),
(10363, 44),
(10364, 44),
(10365, 596),
(10366, 52),
(10367, 52),
(10368, 597),
(10369, 78),
(10370, 159),
(10371, 219),
(10372, 116),
(10373, 24),
(10374, 24),
(10375, 7),
(10376, 7),
(10377, 7),
(10378, 7),
(10379, 7),
(10380, 7),
(10381, 7),
(10382, 7),
(10383, 7),
(10384, 7),
(10385, 7),
(10386, 7),
(10387, 159),
(10388, 7),
(10389, 7),
(10390, 7),
(10391, 7),
(10392, 7),
(10393, 159),
(10394, 598),
(10395, 7),
(10396, 7),
(10397, 7),
(10398, 7),
(10399, 7),
(10400, 7),
(10401, 7),
(10402, 7),
(10403, 7),
(10404, 7),
(10405, 7),
(10406, 7),
(10407, 7),
(10408, 569),
(10409, 24),
(10410, 24),
(10411, 24),
(10412, 24),
(10413, 4),
(10414, 115),
(10415, 181),
(10416, 116),
(10417, 28),
(10418, 28),
(10419, 28),
(10420, 28),
(10421, 28),
(10422, 28),
(10423, 578),
(10424, 578),
(10425, 42),
(10426, 154),
(10427, 248),
(10428, 495),
(10429, 497),
(10430, 497),
(10431, 497),
(10432, 170),
(10433, 7),
(10434, 7),
(10435, 7),
(10436, 7),
(10437, 7),
(10438, 7),
(10439, 7),
(10440, 7),
(10441, 7),
(10442, 7),
(10443, 28),
(10444, 28),
(10445, 28),
(10446, 77),
(10447, 77),
(10448, 250),
(10449, 283),
(10450, 283),
(10451, 30),
(10452, 601),
(10453, 7),
(10454, 250),
(10455, 77),
(10456, 77),
(10457, 30),
(10458, 30),
(10459, 231),
(10460, 116),
(10461, 602),
(10462, 42),
(10463, 42),
(10464, 42),
(10465, 42),
(10466, 603),
(10467, 2),
(10468, 21),
(10469, 21),
(10470, 21),
(10471, 250),
(10472, 250),
(10473, 250),
(10474, 250),
(10475, 3),
(10476, 3),
(10477, 3),
(10478, 3),
(10479, 3),
(10480, 3),
(10481, 3),
(10482, 7),
(10483, 7),
(10484, 7),
(10485, 7),
(10486, 3),
(10487, 3),
(10488, 3),
(10489, 3),
(10490, 3),
(10491, 3),
(10492, 3),
(10493, 3),
(10494, 3),
(10495, 7),
(10496, 7),
(10497, 7),
(10498, 7),
(10499, 7),
(10500, 7),
(10501, 7),
(10502, 7),
(10503, 7),
(10504, 7),
(10505, 7),
(10506, 7),
(10507, 7),
(10508, 7),
(10509, 7),
(10510, 7),
(10511, 7),
(10512, 7),
(10513, 7),
(10514, 7),
(10515, 7),
(10516, 7),
(10517, 7),
(10518, 7),
(10519, 7),
(10520, 164),
(10521, 5),
(10522, 28),
(10523, 28),
(10524, 2),
(10525, 2),
(10526, 2),
(10527, 2),
(10528, 2),
(10529, 2),
(10530, 2),
(10531, 2),
(10532, 2),
(10533, 103),
(10534, 103),
(10535, 103),
(10536, 103),
(10537, 4),
(10538, 60),
(10539, 60),
(10540, 60),
(10541, 60),
(10542, 604),
(10543, 115),
(10544, 42),
(10545, 27),
(10546, 27),
(10547, 27),
(10548, 423),
(10549, 605),
(10550, 606),
(10551, 42),
(10552, 321),
(10553, 321),
(10554, 321),
(10555, 321),
(10556, 276),
(10557, 6),
(10558, 6),
(10559, 6),
(10560, 6),
(10561, 254),
(10562, 141),
(10563, 141),
(10564, 141),
(10565, 141),
(10566, 141),
(10567, 76),
(10568, 154),
(10569, 52),
(10570, 52),
(10571, 52),
(10572, 52),
(10573, 52),
(10574, 52),
(10575, 52),
(10576, 115),
(10577, 253),
(10578, 4),
(10579, 36),
(10580, 4),
(10581, 2),
(10582, 2),
(10583, 42),
(10584, 42),
(10585, 42),
(10586, 42),
(10587, 42),
(10588, 42),
(10589, 42),
(10590, 42),
(10591, 42),
(10592, 42),
(10593, 42),
(10594, 42),
(10595, 42),
(10596, 42),
(10597, 42),
(10598, 42),
(10599, 607);

-- --------------------------------------------------------

--
-- Table structure for table `smdevicenames`
--

CREATE TABLE `smdevicenames` (
  `DeviceNameID` smallint(5) UNSIGNED NOT NULL,
  `DeviceName` varchar(191) DEFAULT NULL,
  `DeviceModel` varchar(191) DEFAULT NULL,
  `MarketingName` varchar(191) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `smdevicenames`
--

INSERT INTO `smdevicenames` (`DeviceNameID`, `DeviceName`, `DeviceModel`, `MarketingName`) VALUES
(1, '', '', ''),
(2, 'U3205', 'U3205', 'U3205'),
(3, 'OT-807A', 'OT-807A', 'OT-807A'),
(4, '6230', '6230', '6230'),
(5, 'E50', 'E50', 'E50'),
(6, 'N81', 'N81', 'N81'),
(7, 'LX290S', 'LX290S', 'LX290S'),
(8, 'K111i', 'K111i', 'K111i'),
(9, 'K310i', 'K310i', 'K310i'),
(10, 'W200i', 'W200i', 'W200i'),
(11, 'W595', 'W595', 'W595'),
(12, 'P1i', 'P1i', 'P1i'),
(13, 'J2ME Midlet', 'J2ME Midlet', 'J2ME Midlet'),
(14, 'SGH-i450', 'SGH-i450', 'SGH-i450'),
(15, 'TV', 'TV', 'TV'),
(16, 'Aquos Net Plus', 'Aquos Net Plus', 'Aquos Net Plus'),
(17, 'Boxee Box', 'Boxee Box', 'Boxee Box'),
(18, 'GoogleTV', 'GoogleTV', 'GoogleTV'),
(19, 'SmartTV', 'SmartTV', 'SmartTV'),
(20, 'NetCast', 'NetCast', 'NetCast'),
(21, 'Co-Star', 'Co-Star', 'Co-Star'),
(22, 'Smart TV', 'Smart TV', 'Smart TV'),
(23, 'Revue', 'Revue', 'Revue'),
(24, 'Internet TV', 'Internet TV', 'Internet TV'),
(25, 'Viera Cast', 'Viera Cast', 'Viera Cast'),
(26, 'Kindle Fire', 'D01400', 'Kindle Fire D01400'),
(27, 'Kindle Fire HD 8.9', 'KFJWI', 'Kindle Fire HD 8.9 KFJWI'),
(28, 'Kindle Fire 7', 'KFOT', 'Kindle Fire 7 KFOT'),
(29, 'Kindle Fire HD 7', 'KFTT', 'Kindle Fire HD 7 KFTT'),
(30, 'Kindle', 'Kindle', 'Kindle'),
(31, 'Kindle 2', 'Kindle 2', 'Kindle 2'),
(32, 'Kindle 3', 'Kindle 3', 'Kindle 3'),
(33, 'PlayStation Vita', 'PlayStation Vita', 'PlayStation Vita'),
(34, 'U120', 'U120', 'U120'),
(35, 'LGUPlus/Android/WebKit', 'LGUPlus/Android/WebKit', 'LGUPlus/Android/WebKit'),
(36, 'LGUPlus/Android/Webviewer', 'LGUPlus/Android/Webviewer', 'LGUPlus/Android/Webviewer'),
(37, 'LGUPlus/Rex/FaceBook', 'LGUPlus/Rex/FaceBook', 'LGUPlus/Rex/FaceBook'),
(38, 'LGUPlus/Rex/WebViewer', 'LGUPlus/Rex/WebViewer', 'LGUPlus/Rex/WebViewer'),
(39, 'LGUPlus/WindowsMobile/FaceBook', 'LGUPlus/WindowsMobile/FaceBook', 'LGUPlus/WindowsMobile/FaceBook'),
(40, 'LGUPlus/WindowsMobile/WebViewer', 'LGUPlus/WindowsMobile/WebViewer', 'LGUPlus/WindowsMobile/WebViewer'),
(41, '7CK100', '7CK100', '7CK100'),
(42, 'A70BHT', 'A70BHT', 'A70BHT'),
(43, '7c Home', 'A70CHT', '7c Home A70CHT'),
(44, 'A70HB', 'A70HB', 'A70HB'),
(45, '70c eReader', '70c', '70c eReader 70c'),
(46, 'Arnova', 'A80KSC', 'Arnova A80KSC'),
(47, 'ARCHM901', 'ARCHM901', 'ARCHM901'),
(48, 'Multipad M7', 'M7', 'Multipad M7 M7'),
(49, 'M7', 'M7', 'M7'),
(50, '6277', '6277', '6277'),
(51, 'Desire ADR6200', 'Desire ADR6200', 'Desire ADR6200'),
(52, 'Dream', 'Dream', 'Dream'),
(53, 'G1', 'G1', 'G1'),
(54, '5', '5', '5'),
(55, 'Behold 2', 'Behold 2', 'Behold 2'),
(56, 'CHT8000', 'CHT8000', 'CHT8000'),
(57, 'beTouch E110', 'E110', 'beTouch E110 E110'),
(58, 'G2 Touch', 'G2 Touch', 'G2 Touch'),
(59, 'Droid Eris', 'Droid Eris', 'Droid Eris'),
(60, 'DSTL1', 'DSTL1', 'DSTL1'),
(61, 'Galaxy Spica', 'GT i5700', 'Galaxy Spica GT i5700'),
(62, 'Galaxy', 'GT i7500', 'Galaxy GT i7500'),
(63, 'Ion', 'Ion', 'Ion'),
(64, 'Hero 200', 'Hero 200', 'Hero 200'),
(65, 'HT-03A', 'HT-03A', 'HT-03A'),
(66, 'Hero', 'Hero', 'Hero'),
(67, 'Magic', 'Magic', 'Magic'),
(68, 'GW620', 'GW620', 'GW620'),
(69, 'GW620F', 'GW620F', 'GW620F'),
(70, 'KH5200', 'KH5200', 'KH5200'),
(71, 'Cliq', 'MB200', 'Cliq MB200'),
(72, 'Backflip', 'Moto MB300', 'Backflip Moto MB300'),
(73, 'Backflip', 'MB300', 'Backflip MB300'),
(74, 'CLIQ XT', 'MB501', 'CLIQ XT MB501'),
(75, 'ME501', 'ME501', 'ME501'),
(76, 'ME600', 'ME600', 'ME600'),
(77, 'MT710', 'MT710', 'MT710'),
(78, 'Opus One', 'i1', 'Opus One i1'),
(79, 'Next2', 'Next2', 'Next2'),
(80, 'OMS Android', 'OMS Android', 'OMS Android'),
(81, 'Pulse', 'Pulse', 'Pulse'),
(82, 'RBM2', 'U8230', 'RBM2 U8230'),
(83, 'Moment', 'SPH-M900', 'Moment SPH-M900'),
(84, 'Opal', 'Opal', 'Opal'),
(85, 'myTouch 3G', 'myTouch 3G', 'myTouch 3G'),
(86, 'Pulse', 'U8220', 'Pulse U8220'),
(87, 'U8230', 'U8230', 'U8230'),
(88, 'A6288', 'A6288', 'A6288'),
(89, 'M7005', 'M7005', 'M7005'),
(90, 'LePhone DONUT', '3GC101', 'LePhone DONUT 3GC101'),
(91, 'LePhone', '3GW100', 'LePhone 3GW100'),
(92, 'A1260', 'A1260', 'A1260'),
(93, 'A1680', 'A1680', 'A1680'),
(94, 'A6388', 'A6388', 'A6388'),
(95, 'A8188', 'A8188', 'A8188'),
(96, 'Boston', 'GSMART 1305', 'Boston GSMART 1305'),
(97, 'Blaze', 'Blaze', 'Blaze'),
(98, 'Streak', 'Streak', 'Streak'),
(99, 'Devour', 'Calgary', 'Devour Calgary'),
(100, 'DoCoMo 03A', 'DoCoMo 03A', 'DoCoMo 03A'),
(101, 'X10 mini', 'E10a', 'X10 mini E10a'),
(102, 'Xperia X10 Mini', 'E10i', 'Xperia X10 Mini E10i'),
(103, 'E120', 'E120', 'E120'),
(104, 'E130', 'E130', 'E130'),
(105, 'Xperia X8', 'E15a', 'Xperia X8 E15a'),
(106, 'EXPERIA X8', 'E15i', 'EXPERIA X8 E15i'),
(107, 'GT540 Optimus', 'GT540', 'GT540 Optimus GT540'),
(108, 'A10', 'A10', 'A10'),
(109, 'A50', 'A50', 'A50'),
(110, 'Garminfone', 'Garminfone', 'Garminfone'),
(111, 'Fiesta', 'Fiesta', 'Fiesta'),
(112, 'Tattoo', 'Tattoo', 'Tattoo'),
(113, 'IS01', 'IS01', 'IS01'),
(114, 'GT540 Optimus', 'GT540F', 'GT540 Optimus GT540F'),
(115, 'LU2300', 'LU2300', 'LU2300'),
(116, 'Liquid', 'Acer S100', 'Liquid Acer S100'),
(117, 'Zio', 'M6000', 'Zio M6000'),
(118, 'Quench Greco', 'XT3 XT502', 'Quench Greco XT3 XT502'),
(119, 'I58', 'I58', 'I58'),
(120, 'Lynx', 'SH-10B', 'Lynx SH-10B'),
(121, 'Xperia SO-01B for DoCoMo', 'SO-01B', 'Xperia SO-01B for DoCoMo SO-01B'),
(122, 'Xperia X10 Mini', 'E10a', 'Xperia X10 Mini E10a'),
(123, 'Xperia X8', 'E15i', 'Xperia X8 E15i'),
(124, 'Xperia X8', 'E15iv', 'Xperia X8 E15iv'),
(125, 'Xperia X10 Mini pro', 'E10a', 'Xperia X10 Mini pro E10a'),
(126, 'Xperia X10 Mini pro', 'U20i', 'Xperia X10 Mini pro U20i'),
(127, 'U20i', 'U20i', 'U20i'),
(128, 'Xperia X10', 'X10a', 'Xperia X10 X10a'),
(129, 'Xperia X10', 'X10i', 'Xperia X10 X10i'),
(130, 'Xperia X10', 'X10iv', 'Xperia X10 X10iv'),
(131, 'T1', 'T1', 'T1'),
(132, 'X10 Mini Pro', 'U20a', 'X10 Mini Pro U20a'),
(133, 'A688', 'A688', 'A688'),
(134, 'A88', 'A88', 'A88'),
(135, 'Link', 'Link', 'Link'),
(136, 'A60', 'A60', 'A60'),
(137, 'Calgary', 'Calgary', 'Calgary'),
(138, 'A3288', 'A3288', 'A3288'),
(139, 'Android eeepc', 'Android eeepc', 'Android eeepc'),
(140, 'Android 1.6', 'Android 1.6', 'Android 1.6'),
(141, 'qsd8250_surf', 'qsd8250_surf', 'qsd8250_surf'),
(142, 'Milestone', 'A853', 'Milestone A853'),
(143, 'Droid', 'Droid', 'Droid'),
(144, 'Milestone', 'Milestone', 'Milestone'),
(145, 'Milestone', 'XT701', 'Milestone XT701'),
(146, 'MOTOROI', 'XT720', 'MOTOROI XT720'),
(147, 'Zhishang', 'XT800', 'Zhishang XT800'),
(148, 'SDK', 'SDK', 'SDK'),
(149, 'A101IT', 'A101IT', 'A101IT'),
(150, 'A70S', 'A70S', 'A70S'),
(151, 'A854', 'A854', 'A854'),
(152, 'Wildfire', 'Wildfire', 'Wildfire'),
(153, 'Incredible', 'ADR6300', 'Incredible ADR6300'),
(154, 'Incredible C', 'Incredible ADR6300', 'Incredible C Incredible ADR6300'),
(155, 'one touch 890', 'one touch 890', 'one touch 890'),
(156, 'one touch 890D', 'one touch 890D', 'one touch 890D one touch 890D'),
(157, 'Axis', 'AS 740', 'Axis AS 740'),
(158, 'OT-980', 'OT-980', 'OT-980'),
(159, 'OT-980A', 'OT-980A', 'OT-980A'),
(160, 'OT-981A', 'OT-981A', 'OT-981A'),
(161, 'Ally', 'Ally', 'Ally'),
(162, 'Blade', 'Blade', 'Blade'),
(163, 'Android 2.1', 'Android 2.1', 'Android 2.1'),
(164, 'Beeline M2', 'Beeline M2', 'Beeline M2'),
(165, 'U8500', 'U8500', 'U8500'),
(166, 'C8500', 'C8500', 'C8500'),
(167, 'C8600', 'C8600', 'C8600'),
(168, 'DroidX', 'DroidX', 'DroidX'),
(169, 'Aero', 'Aero', 'Aero'),
(170, 'Desire', 'Desire', 'Desire Desire'),
(171, 'Walkman 8', 'E16i', 'Walkman 8 E16i'),
(172, 'beTouch E400', 'E400', 'beTouch E400 E400'),
(173, 'GALAPAGOS', 'EB-W51GJ', 'GALAPAGOS EB-W51GJ'),
(174, 'GALAPAGOS', 'EB-WX1GJ', 'GALAPAGOS EB-WX1GJ'),
(175, '8000', 'EMR1882TG', '8000 EMR1882TG'),
(176, 'F9191', 'F9191', 'F9191'),
(177, 'Galaxy 5', 'GT-i5500', 'Galaxy 5 GT-i5500'),
(178, 'Galaxy 5', 'GT-I5500B', 'Galaxy 5 GT-I5500B'),
(179, 'Galaxy 5', 'GT-I5500L', 'Galaxy 5 GT-I5500L'),
(180, 'Galaxy 5', 'GT-I5503', 'Galaxy 5 GT-I5503'),
(181, 'Galaxy 5', 'GT-i5503T', 'Galaxy 5 GT-i5503T'),
(182, 'Galaxy 5', 'GT-I5508', 'Galaxy 5 GT-I5508'),
(183, 'GT-I5510', 'GT-I5510', 'GT-I5510'),
(184, 'Galaxy 3 Apollo', 'GT-I5800', 'Galaxy 3 Apollo GT-I5800'),
(185, 'Apollo', 'GT-I5800L', 'Apollo GT-I5800L'),
(186, 'GT-I5801', 'GT-I5801', 'GT-I5801'),
(187, 'Saturn', 'GT i6500u', 'Saturn GT i6500u'),
(188, 'Galaxy S', 'GT-I9000', 'Galaxy S GT-I9000'),
(189, 'Galaxy S Vibrant', 'GT-I9000B', 'Galaxy S Vibrant GT-I9000B'),
(190, 'Galaxy S/Vibrant', 'GT-I9000', 'Galaxy S/Vibrant GT-I9000'),
(191, 'Galaxy S', 'GT I9000T', 'Galaxy S GT I9000T'),
(192, 'Galaxy S CU ECLAIR', 'GT-I9088', 'Galaxy S CU ECLAIR GT-I9088'),
(193, 'HTC Desire X06HT for SoftBank', 'X06HT', 'HTC Desire X06HT for SoftBank X06HT'),
(194, 'Wildfire', 'Buzz', 'Wildfire Buzz'),
(195, 'Aria', 'A6366', 'Aria A6366'),
(196, 'Aria', 'A6380', 'Aria A6380'),
(197, 'Bee', 'Bee', 'Bee'),
(198, 'Bravo', 'Bravo', 'Bravo'),
(199, 'Buzz', 'Buzz', 'Buzz'),
(200, 'Desire', 'A8183', 'Desire A8183'),
(201, 'Espresso', 'Espresso', 'Espresso'),
(202, 'HD2', 'HD2', 'HD2'),
(203, 'Legend', 'Legend', 'Legend'),
(204, 'Liberty', 'Liberty', 'Liberty'),
(205, 'Ascend', 'M860', 'Ascend M860'),
(206, 'U8100', 'U8100', 'U8100'),
(207, 'IS03 for KDDI', 'IS03', 'IS03 for KDDI IS03'),
(208, 'Regza Phone IS04 for KDDI', 'IS04', 'Regza Phone IS04 for KDDI IS04'),
(209, 'IDEOS S7', 'IDEOS S7', 'IDEOS S7'),
(210, 'Pulse Mini', 'Pulse Mini', 'Pulse Mini'),
(211, 'KU9500', 'KU9500', 'KU9500'),
(212, 'Aloha', 'C710', 'Aloha C710'),
(213, 'Aloha', 'C710h', 'Aloha C710h'),
(214, 'Barnes & Noble Nook Color', 'Zoom2', 'Barnes & Noble Nook Color Zoom2'),
(215, 'CLIQ DEXT', 'MB220', 'CLIQ DEXT MB220'),
(216, 'MB502', 'MB502', 'MB502'),
(217, 'Sage', 'MB508', 'Sage MB508'),
(218, 'Ruth', 'MB511', 'Ruth MB511'),
(219, 'Kobe', 'MB520', 'Kobe MB520'),
(220, 'DEFY', 'MB525', 'DEFY MB525'),
(221, 'FLIPOUT', 'ME511', 'FLIPOUT ME511'),
(222, 'Kyros MID7015', 'MID7015', 'Kyros MID7015 MID7015'),
(223, 'ZTE Joe', 'MTC 916', 'ZTE Joe MTC 916'),
(224, 'ZTE Racer', 'MTC 918', 'ZTE Racer MTC 918'),
(225, 'Breeze', 'MW0811', 'Breeze MW0811'),
(226, 'Milestone XT720', 'Milestone XT720', 'Milestone XT720'),
(227, 'XT500', 'XT500', 'XT500'),
(228, 'Quench XT5', 'XT5 XT502', 'Quench XT5 XT5 XT502'),
(229, 'Movistar Link', 'Movistar Link', 'Movistar Link'),
(230, 'N5 Pro 2', 'N5 Pro 2', 'N5 Pro 2'),
(231, 'Nook Simple Touch', 'Nook BNRV300', 'Nook Simple Touch Nook BNRV300'),
(232, 'Hikari i-Frame 2', 'Hikari i-Frame 2', 'Hikari i-Frame 2'),
(233, 'Next3', 'NXM901', 'Next3 NXM901'),
(234, 'HTC Nexus One', 'Nexus One', 'HTC Nexus One Nexus One'),
(235, 'San Francisco', 'San Francisco', 'San Francisco'),
(236, 'Tactile Internet', 'U8100', 'Tactile Internet U8100'),
(237, 'Microbee Origin 7100', '7100', 'Microbee Origin 7100 7100'),
(238, 'Incredible', 'PB99400', 'Incredible PB99400'),
(239, 'EVO 4G', 'PC36100', 'EVO 4G PC36100'),
(240, 'PosteMobile PM1107 Smart', 'PM1107 Smart', 'PosteMobile PM1107 Smart PM1107 Smart'),
(241, 'PosteMobile PM1152 Tabula', 'PM1152 Tabula', 'PosteMobile PM1152 Tabula PM1152 Tabula'),
(242, 'PMP3084B', 'PMP3084B', 'PMP3084B'),
(243, 'RBK-490', 'RBK-490', 'RBK-490'),
(244, 'RBM C', 'C', 'RBM C C'),
(245, 'Racer', 'X850', 'Racer X850'),
(246, 'Galaxy S Captivate', 'SGH-I896', 'Galaxy S Captivate SGH-I896'),
(247, 'Galaxy S Captivate', 'SGH-I897', 'Galaxy S Captivate SGH-I897'),
(248, 'Gem', 'SCH-I100', 'Gem SCH-I100'),
(249, 'Continuum', 'SCH-I400', 'Continuum SCH-I400'),
(250, 'Fascinate', 'SCH-I500', 'Fascinate SCH-I500'),
(251, 'Acclaim', 'SCH-R880', 'Acclaim SCH-R880'),
(252, 'Galaxy S', 'SCH-i909', 'Galaxy S SCH-i909'),
(253, 'Vibrant', 'SGH-T959', 'Vibrant SGH-T959'),
(254, 'Galaxy S Facinate', 'SGH-T959D', 'Galaxy S Facinate SGH-T959D'),
(255, 'LYNX 3D SH-03C for DoCoMo', 'SH-03C', 'LYNX 3D SH-03C for DoCoMo SH-03C'),
(256, 'Galaxy A', 'SHW-M100S', 'Galaxy A SHW-M100S'),
(257, 'Galaxy S', 'SHW-M110S', 'Galaxy S SHW-M110S'),
(258, 'Galaxy U', 'SHW-M130L', 'Galaxy U SHW-M130L'),
(259, 'SIM710', 'SIM710', 'SIM710'),
(260, 'Sirius', 'SKY IM A600S', 'Sirius SKY IM A600S'),
(261, 'SKY IM-A630K Izar', 'SKY IM-A630K Izar', 'SKY IM-A630K Izar'),
(262, 'SKY Vega', 'SKY IM-A650S', 'SKY Vega SKY IM-A650S'),
(263, 'Epic 4G', 'SPH-D700', 'Epic 4G SPH-D700'),
(264, 'Intercept', 'SPH-M910', 'Intercept SPH-M910'),
(265, 'SPH-M920', 'SPH-M920', 'SPH-M920'),
(266, 'V5', 'V5', 'V5'),
(267, 'Xperia X10', 'X10', 'Xperia X10 X10'),
(268, 'EVO 4G', '9292', 'EVO 4G 9292'),
(269, 'Stream', 'S110', 'Stream S110'),
(270, 'Regza T-01C for DoCoMo', 'T-01C', 'Regza T-01C for DoCoMo T-01C'),
(271, 'myTouch 3G Slide', 'myTouch 3G Slide', 'myTouch 3G Slide'),
(272, 'HTC Sappire', 'G2 Touch', 'HTC Sappire G2 Touch'),
(273, 'Telstra Smart-Touch', 'T3020', 'Telstra Smart-Touch T3020'),
(274, 'T720', 'T720', 'T720'),
(275, 'TF-R702', 'TF-R702', 'TF-R702'),
(276, 'U8110', 'U8110', 'U8110'),
(277, 'Titanium', 'Titanium', 'Titanium'),
(278, 'Turkcell T10', 'U8110', 'Turkcell T10 U8110'),
(279, 'Sonic', 'T20', 'Sonic T20'),
(280, 'Vodafone 845', '8120', 'Vodafone 845 8120'),
(281, 'T-Mobile Pulse', 'U8230', 'T-Mobile Pulse U8230'),
(282, 'Evolution', 'UM840', 'Evolution UM840'),
(283, 'Apex', 'US740', 'Apex US740'),
(284, 'V9', 'V9', 'V9'),
(285, 'Vodafone 945', 'VF945', 'Vodafone 945 VF945'),
(286, 'Vodafone 845', 'Vodafone 845', 'Vodafone 845'),
(287, 'Ciena', 'WX445', 'Ciena WX445'),
(288, 'Racer', 'XCD28', 'Racer XCD28'),
(289, 'Dell XCD35', 'Blade', 'Dell XCD35 Blade'),
(290, 'Spice', 'XT300', 'Spice XT300'),
(291, 'Milestone', 'XT702', 'Milestone XT702'),
(292, 'MOTOROI', 'XT711', 'MOTOROI XT711'),
(293, 'Glam', 'XT800W', 'Glam XT800W'),
(294, '7001', '7001', '7001'),
(295, 'Galaxy Player G50', 'Galaxy Player G50', 'Galaxy Player G50'),
(296, '5002', '5002', '5002'),
(297, 'N600', 'N600', 'N600 N600'),
(298, 'C R750', 'C R750', 'C R750'),
(299, 'ZiiO7', 'ZiiO7', 'ZiiO7'),
(300, 'A5', 'A5', 'A5'),
(301, 'i858', 'i858', 'i858'),
(302, 'i867', 'i867', 'i867'),
(303, 'i940', 'i940', 'i940'),
(304, 'RK2818 SDK', 'RK2818', 'RK2818 SDK RK2818'),
(305, 'Novel', 'Novel', 'Novel'),
(306, 'MID', 'MID', 'MID'),
(307, 'Softstone', 'Softstone', 'Softstone'),
(308, 'ZT180', 'ZT180', 'ZT180'),
(309, 'Dell Streak 5', '001DL', 'Dell Streak 5 001DL'),
(310, 'Desire HD SoftBank', '001HT', 'Desire HD SoftBank 001HT'),
(311, 'Desire', '003Z', 'Desire 003Z'),
(312, 'LePhone FROYO', '3GC101', 'LePhone FROYO 3GC101'),
(313, 'LePhone FROYO', 'W101', 'LePhone FROYO W101'),
(314, '9930', '9930', '9930'),
(315, 'A2000', 'A2000', 'A2000'),
(316, 'WildFire TD Mini', 'A3360', 'WildFire TD Mini A3360'),
(317, 'WildFire TD', 'A3380', 'WildFire TD A3380'),
(318, 'A502', 'A502', 'A502'),
(319, 'FG8', 'A601', 'FG8 A601'),
(320, 'Flying A602', 'A602', 'Flying A602 A602'),
(321, 'A90', 'A90', 'A90'),
(322, 'MILESTONE 2', 'A953', 'MILESTONE 2 A953'),
(323, 'Merge', 'ADR6325', 'Merge ADR6325'),
(324, 'Droid Incredible 2', 'ADR6350', 'Droid Incredible 2 ADR6350'),
(325, 'Thunderbolt', 'ADR6400L', 'Thunderbolt ADR6400L'),
(326, 'One Touch 990', 'OT-990', 'One Touch 990 OT-990'),
(327, 'one touch 906', 'one touch 906', 'one touch 906 one touch 906'),
(328, 'one touch 906Y', 'one touch 906Y', 'one touch 906Y one touch 906Y'),
(329, 'one touch 908', 'one touch 908', 'one touch 908'),
(330, 'OneTouch908F', 'OneTouch908F', 'OneTouch908F'),
(331, 'One Touch 990', 'one touch 990A', 'One Touch 990 one touch 990A'),
(332, 'One Touch 990', 'one touch 990M', 'One Touch 990 one touch 990M'),
(333, 'One Touch 990', 'one touch 990S', 'One Touch 990 one touch 990S'),
(334, 'Liquid Metal', 'S120', 'Liquid Metal S120'),
(335, 'Tuires', 'Tuires', 'Tuires'),
(336, 'Amigo', 'Amigo', 'Amigo'),
(337, 'G\'zOne', 'C771', 'G\'zOne C771'),
(338, 'Spice MI410', 'MI410', 'Spice MI410 MI410'),
(339, 'Touch Tablet', 'CT1000', 'Touch Tablet CT1000'),
(340, 'CT704', 'CT704', 'CT704'),
(341, 'T-Mobile Comet', 'Comet', 'T-Mobile Comet Comet'),
(342, '8809', '8809', '8809'),
(343, 'W706', 'W706', 'W706'),
(344, 'Flytouch 3 Disco 10', 'F10B', 'Flytouch 3 Disco 10 F10B'),
(345, 'DM009SH for Disney Mobile - SoftBank', 'DM009SH', 'DM009SH for Disney Mobile - SoftBank DM009SH'),
(346, 'DROID PRO', 'DROID PRO', 'DROID PRO'),
(347, 'Droid X2', 'Droid X2', 'Droid X2'),
(348, 'Droid 2 Global', 'Droid 2 Global', 'Droid 2 Global'),
(349, 'Droid 2', 'Droid 2', 'Droid 2'),
(350, 'Streak 7', 'Streak 7', 'Streak 7'),
(351, 'Venue', 'Venue', 'Venue'),
(352, 'Desire HD', 'Desire HD', 'Desire HD'),
(353, 'Desire', 'A8181', 'Desire A8181'),
(354, 'beTouch E140', 'Acer E140', 'beTouch E140 Acer E140'),
(355, 'beTouch E210', 'Acer E210', 'beTouch E210 Acer E210'),
(356, 'Liquid Mini', 'Acer E310', 'Liquid Mini Acer E310'),
(357, 'TAKE', 'EV-S100', 'TAKE EV-S100'),
(358, 'Folio 100', 'Folio 100', 'Folio 100'),
(359, 'Fox', 'Fox', 'Fox'),
(360, 'GT-B7510', 'GT-B7510', 'GT-B7510'),
(361, 'Galaxy Pro', 'GT-B7510L', 'Galaxy Pro GT-B7510L'),
(362, 'GT-I5510M', 'GT-I5510M', 'GT-I5510M'),
(363, 'GT-I5510T', 'GT-I5510T', 'GT-I5510T'),
(364, 'Galaxy 3 Apollo', 'GT-I5800D', 'Galaxy 3 Apollo GT-I5800D'),
(365, 'Galaxy SL', 'GT-I9003', 'Galaxy SL GT-I9003'),
(366, 'Galaxy S', 'GT-I9008L', 'Galaxy S GT-I9008L'),
(367, 'Galaxy S Armani', 'GT-I9010', 'Galaxy S Armani GT-I9010'),
(368, 'Galaxy S', 'GT-I9018', 'Galaxy S GT-I9018'),
(369, 'Galaxy S CU FROYO', 'GT-I9088', 'Galaxy S CU FROYO GT-I9088'),
(370, 'Galaxy Tab', 'GT-P1000', 'Galaxy Tab GT-P1000'),
(371, 'Galaxy Tab', 'GT-P1000R', 'Galaxy Tab GT-P1000R'),
(372, 'Galaxy Tab', 'GT-P1000T', 'Galaxy Tab GT-P1000T'),
(373, 'Galaxy Tab', 'GT-P1010', 'Galaxy Tab GT-P1010'),
(374, 'Galaxy Mini', 'GT-S5570', 'Galaxy Mini GT-S5570'),
(375, 'GT-S5570B', 'GT-S5570B', 'GT-S5570B'),
(376, 'GT-S5570L', 'GT-S5570L', 'GT-S5570L'),
(377, 'Galaxy Gio', 'GT-S5660', 'Galaxy Gio GT-S5660'),
(378, 'Galaxy Gio', 'GT-S5660L', 'Galaxy Gio GT-S5660L'),
(379, 'Galaxy Fit', 'GT-S5670', 'Galaxy Fit GT-S5670'),
(380, 'Galaxy Fit', 'GT-S5670B', 'Galaxy Fit GT-S5670B'),
(381, 'Galaxy Ace', 'GT-S5830', 'Galaxy Ace GT-S5830'),
(382, 'Galaxy Ace', 'GT-S5830B', 'Galaxy Ace GT-S5830B'),
(383, 'Galaxy Ace', 'GT-S5830L', 'Galaxy Ace GT-S5830L'),
(384, 'Galaxy Ace', 'GT-S5830T', 'Galaxy Ace GT-S5830T'),
(385, 'WildFire WCDMA', 'A3366', 'WildFire WCDMA A3366'),
(386, 'Desire FROYO', 'A8180', 'Desire FROYO A8180'),
(387, 'Vision', 'A7275', 'Vision A7275'),
(388, 'Inspire 4G', 'Inspire 4G', 'Inspire 4G'),
(389, 'Desire', 'Desire Z', 'Desire Desire Z'),
(390, 'Glacier', 'Glacier', 'Glacier'),
(391, 'Gratia', 'A6380', 'Gratia A6380'),
(392, 'Incredible S', 'S710E', 'Incredible S S710E'),
(393, 'Verizon Droid Incredible', 'Incredible C', 'Verizon Droid Incredible Incredible C'),
(394, 'Aria S31HT for E-Mobile', 'Liberty', 'Aria S31HT for E-Mobile Liberty'),
(395, 'Detail', 'PLS7373ADR', 'Detail PLS7373ADR'),
(396, 'Vision', 'Vision', 'Vision'),
(397, 'Wildfire', 'A3333', 'Wildfire A3333'),
(398, '105', 'HT_PAD1051', '105 HT_PAD1051'),
(399, 'T8300', 'T8300', 'T8300'),
(400, 'M835', 'M835', 'M835'),
(401, 'Ideos X6', 'U9000', 'Ideos X6 U9000'),
(402, 'Vodafone 858', 'Vodafone 858', 'Vodafone 858'),
(403, 'Impulse 4G for AT&T', 'U8800-51', 'Impulse 4G for AT&T U8800-51'),
(404, 'S7_Slim', 'S7_Slim', 'S7_Slim'),
(405, 'Ideos X5', 'u8800', 'Ideos X5 u8800'),
(406, 'Mirach', 'IM-A690L', 'Mirach IM-A690L'),
(407, 'IM-A690S', 'IM-A690S', 'IM-A690S'),
(408, 'Sky Vega Xpress', 'IM-A710K', 'Sky Vega Xpress IM-A710K'),
(409, 'Sky Vega XPress', 'IM-A720L', 'Sky Vega XPress IM-A720L'),
(410, 'SKY Vega X+', 'IM-A725L', 'SKY Vega X+ IM-A725L'),
(411, 'AKY IM-A730S', 'AKY IM-A730S', 'AKY IM-A730S'),
(412, 'Cloud Touch', 'Cloud Touch', 'Cloud Touch'),
(413, 'IS05 for KDDI', 'IS05', 'IS05 for KDDI IS05'),
(414, 'Pantech Sirius alpha IS06 for KDDI', 'IS06', 'Pantech Sirius alpha IS06 for KDDI IS06'),
(415, 'EVO WiMAX ISW11HT for KDDI', 'ISW11HT', 'EVO WiMAX ISW11HT for KDDI ISW11HT'),
(416, 'IDEOS', 'BM-SWU300', 'IDEOS BM-SWU300'),
(417, 'Ideos', 'U8150', 'Ideos U8150'),
(418, 'TAKE 2', 'KM-S120', 'TAKE 2 KM-S120'),
(419, 'A1', 'A1', 'A1'),
(420, 'Optimus chat L-04C for DoCoMo', 'L-04C', 'Optimus chat L-04C for DoCoMo L-04C'),
(421, 'LG Optimus Chat', 'LG/C550/V1.0', 'LG Optimus Chat LG/C550/V1.0'),
(422, 'C555', 'C555', 'C555'),
(423, 'Optimus Chic', 'E720', 'Optimus Chic E720'),
(424, 'Optimus Quantum Chic', 'E720b', 'Optimus Quantum Chic E720b'),
(425, 'KU3700', 'KU3700', 'KU3700'),
(426, 'Optimus Black', 'KU5900', 'Optimus Black KU5900'),
(427, 'Optimus Mach', 'LU3000', 'Optimus Mach LU3000'),
(428, 'Optimus Chic', 'LU3100', 'Optimus Chic LU3100'),
(429, 'Optimus One', 'LU3700', 'Optimus One LU3700'),
(430, 'Optimus Big', 'LU6800', 'Optimus Big LU6800'),
(431, 'Optimus C', 'LW690', 'Optimus C LW690'),
(432, 'Optimus M', 'MS690', 'Optimus M MS690'),
(433, 'Optimus Me', 'P350G', 'Optimus Me P350G'),
(434, 'Optimus Me', 'P350', 'Optimus Me P350'),
(435, 'Optimus Me', 'P350F', 'Optimus Me P350F'),
(436, 'P500', 'P500', 'P500'),
(437, 'Optimus One', 'P500h', 'Optimus One P500h'),
(438, 'LG/P503/V1.0', 'LG/P503/V1.0', 'LG/P503/V1.0'),
(439, 'Optimus One', 'P504', 'Optimus One P504'),
(440, 'Phoenix', 'P505', 'Phoenix P505'),
(441, 'Phoenix', 'P505R', 'Phoenix P505R'),
(442, 'Android 2.2', 'Android 2.2', 'Android 2.2'),
(443, 'Optimus T', 'P509', 'Optimus T P509'),
(444, 'Optimus 3D', 'P920', 'Optimus 3D P920'),
(445, 'Optimus 3D', 'P920h', 'Optimus 3D P920h'),
(446, 'Thrill', 'P925', 'Thrill P925'),
(447, 'Optimus 3D', 'P925g', 'Optimus 3D P925g'),
(448, 'Optimus Black', 'P970', 'Optimus Black P970'),
(449, 'Optimus Black', 'P970h', 'Optimus Black P970h'),
(450, 'Optimus 2X', 'P990', 'Optimus 2X P990'),
(451, 'Optimus 2X', 'P990h', 'Optimus 2X P990h'),
(452, 'Optimus 2X', 'P990hN', 'Optimus 2X P990hN'),
(453, 'T-Mobile G2x', 'P999', 'T-Mobile G2x P999'),
(454, 'Optimus One', 'SU370', 'Optimus One SU370'),
(455, 'Optimux 2X', 'SU660', 'Optimux 2X SU660'),
(456, 'Optimus 3D', 'SU760', 'Optimus 3D SU760'),
(457, 'Optimus U', 'US670', 'Optimus U US670'),
(458, 'Optimus S', 'LS670', 'Optimus S LS670'),
(459, 'Light Pro', 'Light Pro', 'Light Pro'),
(460, 'Light Tab', 'BM-LTBU300', 'Light Tab BM-LTBU300'),
(461, 'M721 MID Tablet', 'M721', 'M721 MID Tablet M721'),
(462, 'Echo', 'M9300', 'Echo M9300'),
(463, 'MB611', 'MB611', 'MB611'),
(464, 'XPRT', 'MB612', 'XPRT MB612'),
(465, 'Atrix', 'MB860', 'Atrix MB860'),
(466, 'Defy', 'ME525', 'Defy ME525'),
(467, 'MILESTONE 2', 'ME722', 'MILESTONE 2 ME722'),
(468, 'Droid X', 'MB810', 'Droid X MB810'),
(469, 'Kyros MID1024', 'MID1024', 'Kyros MID1024 MID1024'),
(470, 'MID7008', 'MID7008', 'MID7008'),
(471, 'Kyros MID7010', 'MID7010', 'Kyros MID7010 MID7010'),
(472, '7020', '7020', '7020'),
(473, 'Kyros MID7024', 'MID7024', 'Kyros MID7024 MID7024'),
(474, 'Kyros MID8024', 'MID8024', 'Kyros MID8024 MID8024'),
(475, 'MID C070A', 'MID C070A', 'MID C070A'),
(476, 'A8T', 'A8T', 'A8T'),
(477, 'Triumph', 'MOTWX435KT', 'Triumph MOTWX435KT'),
(478, 'MOVE', 'MOVE', 'MOVE MOVE'),
(479, 'MP434', 'MP434', 'MP434'),
(480, 'Mtag 3.1', 'SP101', 'Mtag 3.1 SP101'),
(481, 'A2', 'A2', 'A2'),
(482, 'A85', 'A85', 'A85'),
(483, 'Milestone Plus', 'A957', 'Milestone Plus A957'),
(484, 'MotoroiX', 'MotoroiX', 'MotoroiX'),
(485, 'Medias N-04C for DoCoMo', 'N-04C', 'Medias N-04C for DoCoMo N-04C'),
(486, 'Space', 'Space', 'Space'),
(487, 'Olipad 70', 'Olipad 70', 'Olipad 70'),
(488, 'OliPad 100', 'OliPad 100', 'OliPad 100'),
(489, 'HTC EVO WiMAX', 'ISW11HT', 'HTC EVO WiMAX ISW11HT'),
(490, 'Knight', 'PG06100', 'Knight PG06100'),
(491, 'P8000', 'P8000', 'P8000'),
(492, 'Racer II', 'Racer II', 'Racer II'),
(493, 'Pocket WiFi S for emobile', 'S31HW', 'Pocket WiFi S for emobile S31HW'),
(494, 'DoubleTime', 'SGH-I857', 'DoubleTime SGH-I857'),
(495, 'Infuse', 'SGH-I997', 'Infuse SGH-I997'),
(496, 'Galapagos 003SH for SoftBank', '003SH', 'Galapagos 003SH for SoftBank 003SH'),
(497, 'Sharp Galapagos 005SH for SoftBank', '005SH', 'Sharp Galapagos 005SH for SoftBank 005SH'),
(498, 'Galaxy Tab SC-01C for DoCoMo', 'SC-01C', 'Galaxy Tab SC-01C for DoCoMo SC-01C'),
(499, 'Galaxy S SC-02B for DoCoMo', 'SC-02B', 'Galaxy S SC-02B for DoCoMo SC-02B'),
(500, 'Droid Charge', 'SCH-I510', 'Droid Charge SCH-I510'),
(501, 'Precedent', 'SCH-M828C', 'Precedent SCH-M828C'),
(502, 'Galaxy Indulge', 'SCH-R910', 'Galaxy Indulge SCH-R910'),
(503, 'Galaxy Pop', 'SCH-i559', 'Galaxy Pop SCH-i559'),
(504, 'SCH-i569', 'SCH-i569', 'SCH-i569'),
(505, 'Galaxy Ace Duos', 'SCH-i579', 'Galaxy Ace Duos SCH-i579'),
(506, 'SCH-i809', 'SCH-i809', 'SCH-i809'),
(507, 'Dart', 'SGH-T499', 'Dart SGH-T499'),
(508, 'Dart', 'SGH-T499V', 'Dart SGH-T499V'),
(509, 'Galaxy Mini', 'SGH-T499', 'Galaxy Mini SGH-T499'),
(510, 'Gravity Smart', 'SGH-T589', 'Gravity Smart SGH-T589'),
(511, 'T-Mobile Sidekick 4G', 'SGH-T839', 'T-Mobile Sidekick 4G SGH-T839'),
(512, 'FX Plus', 'ADS1', 'FX Plus ADS1'),
(513, 'Galaxy K', 'SHW-M130K', 'Galaxy K SHW-M130K'),
(514, 'Galaxy Tab (KT)', 'SHW-M180K', 'Galaxy Tab (KT) SHW-M180K'),
(515, 'GALAXY Tab (LG U+)', 'SHW-M180L', 'GALAXY Tab (LG U+) SHW-M180L'),
(516, 'GALAXY Tab (SKT)', 'SHW-M180S', 'GALAXY Tab (SKT) SHW-M180S'),
(517, 'GALAXY Tab (LG U+)', 'SHW-M180W', 'GALAXY Tab (LG U+) SHW-M180W'),
(518, 'Galaxy S Hoppin', 'SHW-M190S', 'Galaxy S Hoppin SHW-M190S'),
(519, 'Galaxy Neo', 'GT-I9000', 'Galaxy Neo GT-I9000'),
(520, 'Galaxy Ace', 'SHW-M240S', 'Galaxy Ace SHW-M240S'),
(521, 'Galaxy Gio', 'SHW-M290K', 'Galaxy Gio SHW-M290K'),
(522, 'S100', 'S100', 'S100'),
(523, 'SMT-i9100', 'SMT-i9100', 'SMT-i9100'),
(524, 'SN10T1', 'SN10T1', 'SN10T1'),
(525, 'HANNS pad', 'SN10T2', 'HANNS pad SN10T2'),
(526, 'Xperia arc SO-01C for DoCoMo', 'SO-01C', 'Xperia arc SO-01C for DoCoMo SO-01C'),
(527, 'SP-60', 'SP-60', 'SP-60'),
(528, 'Replenish', 'SPH-M580', 'Replenish SPH-M580'),
(529, 'Galaxy Prevail', 'SPH-M820-BST', 'Galaxy Prevail SPH-M820-BST'),
(530, 'Express Plus', 'SYTABEX7-2', 'Express Plus SYTABEX7-2'),
(531, 'EVO Shift 4G', 'APA7373KT', 'EVO Shift 4G APA7373KT'),
(532, 'U8180', 'U8180', 'U8180'),
(533, 'HTC Sapphire', 'G2 Touch', 'HTC Sapphire G2 Touch'),
(534, 'T3', 'T3', 'T3'),
(535, 'Cruz T301', 'Cruz T301', 'Cruz T301'),
(536, 'T9189', 'T9189', 'T9189'),
(537, 'A990', 'A990', 'A990'),
(538, 'Andy Tab', 'TO101', 'Andy Tab TO101'),
(539, 'TPC800W', 'TPC800W', 'TPC800W'),
(540, 'Onda MyTab', 'TT101', 'Onda MyTab TT101'),
(541, 'U2', 'U2', 'U2'),
(542, 'Pulse FROYO', 'U8220', 'Pulse FROYO U8220'),
(543, 'Boulder', 'U8350', 'Boulder U8350'),
(544, 'U8800 Pro', 'U8800 Pro', 'U8800 Pro'),
(545, 'Titan', 'U8820', 'Titan U8820'),
(546, 'Genesis', 'US760', 'Genesis US760'),
(547, 'Light Tab V9C', 'V9c', 'Light Tab V9C V9c'),
(548, 'gTablet', 'gTablet', 'gTablet'),
(549, 'Optimus V', 'VM670', 'Optimus V VM670'),
(550, 'Revolution', 'VS910 4G', 'Revolution VS910 4G'),
(551, 'vancouver', 'vancouver', 'vancouver vancouver'),
(552, 'ViewPad 10s', 'ViewPad 10s', 'ViewPad 10s'),
(553, 'ViewPad7', 'ViewPad7', 'ViewPad7'),
(554, 'V350', 'V350', 'V350'),
(555, '958', '958', '958'),
(556, 'Vortex', 'VS660', 'Vortex VS660'),
(557, 'W770', 'W770', 'W770'),
(558, 'X10 Mini', 'X10 Mini', 'X10 Mini'),
(559, 'Find', 'X903', 'Find X903'),
(560, 'XCD35', 'Blade', 'XCD35 Blade'),
(561, 'Dominoq', 'XT316', 'Dominoq XT316'),
(562, 'MotoXT610', 'MotoXT610', 'MotoXT610'),
(563, 'Galaxy Player 4.0', 'YP-G1', 'Galaxy Player 4.0 YP-G1'),
(564, 'Galaxy Player 5', 'YP-G70', 'Galaxy Player 5 YP-G70'),
(565, 'Player 4', 'YP-GB1', 'Player 4 YP-GB1'),
(566, 'WiFi 5.0', 'YP-GB70', 'WiFi 5.0 YP-GB70'),
(567, 'Jewe', 'Jewe', 'Jewe'),
(568, 'Libra', 'Libra', 'Libra'),
(569, 'Blade', 'U880', 'Blade U880'),
(570, 'Personal Touch', 'N721', 'Personal Touch N721'),
(571, 'Blade', 'V880', 'Blade V880'),
(572, 'U N720', 'U N720', 'U N720'),
(573, 'ZiiO 10', 'ZiiO 10', 'ZiiO 10'),
(574, 'eGlide', 'eGlide', 'eGlide'),
(575, 'Pocket Edge', 'Pocket Edge', 'Pocket Edge'),
(576, 'Identity Tab', 'E201', 'Identity Tab E201'),
(577, 'i810', 'i810', 'i810'),
(578, 'i7', 'i7', 'i7'),
(579, 'GALAXY S', 'SC-02B', 'GALAXY S SC-02B'),
(580, 'M9', 'M9', 'M9'),
(581, 'myTouch4G', 'myTouch4G', 'myTouch4G'),
(582, 'P7901A', 'P7901A', 'P7901A'),
(583, 'xPad-70', 'xPad-70', 'xPad-70'),
(584, 'Sweety 003P for Softbank', '003P', 'Sweety 003P for Softbank 003P'),
(585, 'Vision 007HW for Softbank', '007HW', 'Vision 007HW for Softbank 007HW'),
(586, 'Simple Smartphone 008Z for Softbank', '008Z', 'Simple Smartphone 008Z for Softbank 008Z'),
(587, 'STAR7 009Z for Softbank', '009Z', 'STAR7 009Z for Softbank 009Z'),
(588, 'Honey Bee', '101K', 'Honey Bee 101K'),
(589, 'LUMIX Phone 101P for Softbank', '101P', 'LUMIX Phone 101P for Softbank 101P'),
(590, '5832', '5832', '5832'),
(591, 'Lightning', '5860', 'Lightning 5860'),
(592, 'Lightning', '5860A', 'Lightning 5860A'),
(593, 'Quattro 4G', '5860E', 'Quattro 4G 5860E'),
(594, 'Quattro 5860e 4G', '5860e', 'Quattro 5860e 4G 5860e'),
(595, '710', '710', '710'),
(596, '8150', '8150', '8150'),
(597, '97FC', '97FC', '97FC'),
(598, 'MB702', '97FR', 'MB702 97FR'),
(599, '9900', '9900', '9900'),
(600, 'A1+', 'A1+', 'A1+'),
(601, 'IdeaPad A1 Tablet', 'IdeaPad A1', 'IdeaPad A1 Tablet IdeaPad A1'),
(602, 'Noir', 'A2', 'Noir A2'),
(603, 'A25 Smarty', 'A25', 'A25 Smarty A25'),
(604, 'Superfone Punk', 'A44', 'Superfone Punk A44'),
(605, 'Superfone Punk', 'A45', 'Superfone Punk A45'),
(606, 'Aisha', 'A52', 'Aisha A52'),
(607, 'A54 Smarty 3.5', 'A54', 'A54 Smarty 3.5 A54'),
(608, 'A7+', 'A7+', 'A7+'),
(609, 'A7', 'A7', 'A7'),
(610, 'A89', 'A89', 'A89'),
(611, 'A9100 S2', 'A9100', 'A9100 S2 A9100'),
(612, 'A95', 'A95', 'A95'),
(613, 'ADR21', 'ADR21', 'ADR21'),
(614, 'Rhyme', 'ADR6330', 'Rhyme ADR6330'),
(615, 'Thunderbolt 4G', 'ADR6400L', 'Thunderbolt 4G ADR6400L'),
(616, 'Rezound', 'ADR6425LVW', 'Rezound ADR6425LVW'),
(617, 'Breakout', 'ADR8995 4G', 'Breakout ADR8995 4G'),
(618, 'One Touch 903', 'OT-903', 'One Touch 903 OT-903'),
(619, 'One Touch 903A', 'OT-903A', 'One Touch 903A OT-903A'),
(620, 'One Touch 903D', 'OT-903D', 'One Touch 903D OT-903D'),
(621, 'One Touch 918', 'OT-918', 'One Touch 918 OT-918'),
(622, 'One Touch 918A', 'OT-918A', 'One Touch 918A OT-918A'),
(623, 'One Touch 918D', 'OT-918D', 'One Touch 918D OT-918D'),
(624, 'One Touch 918N', 'OT-918N', 'One Touch 918N OT-918N'),
(625, 'One Touch 918S', 'OT-918S', 'One Touch 918S OT-918S'),
(626, 'One Touch 985', 'OT-985', 'One Touch 985 OT-985'),
(627, 'One Touch 985N', 'OT-985N', 'One Touch 985N OT-985N'),
(628, 'One Touch 991 Play', 'OT-991', 'One Touch 991 Play OT-991'),
(629, 'One Touch 991T Play', 'OT-991T', 'One Touch 991T Play OT-991T'),
(630, 'One Touch 909A', 'One Touch 909A', 'One Touch 909A'),
(631, 'One Touch 909B', 'One Touch 909B', 'One Touch 909B'),
(632, 'One Touch 909S', 'One Touch 909S', 'One Touch 909S'),
(633, 'OneTouch910', 'OneTouch910', 'OneTouch910'),
(634, 'One Touch 995', 'OT-995', 'One Touch 995 OT-995'),
(635, '10 G2', '10 G2', '10 G2'),
(636, '7C G2', '7C G2', '7C G2'),
(637, '7 G2', 'AN7G2', '7 G2 AN7G2'),
(638, '9 G2', '9 G2', '9 G2'),
(639, '627', '627', '627'),
(640, 'Atlas W', 'Atlas W', 'Atlas W'),
(641, 'Acer Liquid Express', 'Acer E320', 'Acer Liquid Express Acer E320'),
(642, 'Acer Liquid Express', 'Acer E320-orange', 'Acer Liquid Express Acer E320-orange'),
(643, 'Z110', 'Z110', 'Z110'),
(644, 'Andi 107', 'Andi 107', 'Andi 107'),
(645, 'StarAddict', 'StarAddict', 'StarAddict'),
(646, 'YG A700', 'YG A700', 'YG A700'),
(647, 'B63M', 'B63M', 'B63M'),
(648, 'Lutea 2', 'Lutea 2', 'Lutea 2'),
(649, 'NOOK Tablet', 'NOOK Tablet', 'NOOK Tablet'),
(650, 'Milano', 'C5120', 'Milano C5120'),
(651, 'Milano', 'C5121', 'Milano C5121'),
(652, 'C8650', 'C8650', 'C8650'),
(653, 'Smart Touch', 'C8660', 'Smart Touch C8660'),
(654, 'Cat Nova', 'Cat Nova', 'Cat Nova'),
(655, 'Evolution II', 'C8651', 'Evolution II C8651'),
(656, 'Plenue', 'D3', 'Plenue D3'),
(657, 'Tablet PC', 'Cat Nova 8', 'Tablet PC Cat Nova 8'),
(658, '5210', '5210', '5210'),
(659, '7019', '7019', '7019'),
(660, 'Chorus', 'D930', 'Chorus D930'),
(661, 'Premium8', 'M803HC', 'Premium8 M803HC'),
(662, 'DM010SH for Disney Mobile - SoftBank', 'DM010SH', 'DM010SH for Disney Mobile - SoftBank DM010SH'),
(663, 'Droid Bionic 4G', 'xt875', 'Droid Bionic 4G xt875'),
(664, 'Droid Razr 4G', 'MOTXT912B', 'Droid Razr 4G MOTXT912B'),
(665, 'Droid 3', 'XT862', 'Droid 3 XT862'),
(666, 'Droid 4', 'XT894', 'Droid 4 XT894'),
(667, 'ARROWS Kiss F-03D for DoCoMo', 'F-03D', 'ARROWS Kiss F-03D for DoCoMo F-03D'),
(668, 'ARROWS X LTE F-05D', 'F-05D', 'ARROWS X LTE F-05D F-05D'),
(669, 'ARROWS u F-07D', 'F-07D', 'ARROWS u F-07D F-07D'),
(670, 'Disney Mobile F-08D', 'F-08D', 'Disney Mobile F-08D F-08D'),
(671, 'F-12C for DoCoMo', 'F-12C', 'F-12C for DoCoMo F-12C'),
(672, 'IQ256', 'IQ256', 'IQ256'),
(673, 'FWS610', 'FWS610', 'FWS610'),
(674, 'FX2 PAD10', '812223', 'FX2 PAD10 812223'),
(675, 'IQ245', 'IQ245', 'IQ245'),
(676, 'IQ235', 'IQ235', 'IQ235'),
(677, 'IQ270', 'IQ270', 'IQ270'),
(678, 'IQ275', 'IQ275', 'IQ275'),
(679, 'GN105', 'GN105', 'GN105'),
(680, 'S1', 'S1', 'S1'),
(681, 'Galaxy Y', 'GT-B5510', 'Galaxy Y GT-B5510'),
(682, 'Galaxy Y Pro', 'GT-B5510L', 'Galaxy Y Pro GT-B5510L'),
(683, 'GT-B5512', 'GT-B5512', 'GT-B5512'),
(684, 'GT-B9120', 'GT-B9120', 'GT-B9120'),
(685, 'Galaxy W', 'GT-I8150', 'Galaxy W GT-I8150'),
(686, 'Galaxy Ace 2', 'GT-I8160', 'Galaxy Ace 2 GT-I8160'),
(687, 'Galaxy Ace 2', 'GT-I8160L', 'Galaxy Ace 2 GT-I8160L'),
(688, 'Galaxy Ace 2 NFC', 'GT-I8160P', 'Galaxy Ace 2 NFC GT-I8160P'),
(689, 'GT-I8250', 'GT-I8250', 'GT-I8250'),
(690, 'GT-I8530', 'GT-I8530', 'GT-I8530'),
(691, 'GT-I9001', 'GT-I9001', 'GT-I9001'),
(692, 'Galaxy S Advance', 'GT-I9070', 'Galaxy S Advance GT-I9070'),
(693, 'Galaxy S II', 'GT-I9100', 'Galaxy S II GT-I9100'),
(694, 'Galaxy S II', 'GT-I9100G', 'Galaxy S II GT-I9100G'),
(695, 'Galaxy S II NFC', 'GT-I9100P', 'Galaxy S II NFC GT-I9100P'),
(696, 'Galaxy SII', 'GT-I9103', 'Galaxy SII GT-I9103'),
(697, 'Galaxy S II', 'GT-I9108', 'Galaxy S II GT-I9108'),
(698, 'Galaxy SII 4G', 'GT-I9210T', 'Galaxy SII 4G GT-I9210T'),
(699, 'Galaxy Note', 'GT-I9220', 'Galaxy Note GT-I9220'),
(700, 'Galaxy Note', 'GT-I9228', 'Galaxy Note GT-I9228'),
(701, 'Galaxy Note', 'GT-N7000', 'Galaxy Note GT-N7000'),
(702, 'Galaxy Pocket', 'GT-S5300', 'Galaxy Pocket GT-S5300'),
(703, 'Galaxy Pocket', 'GT-S5300B', 'Galaxy Pocket GT-S5300B'),
(704, 'GT-S5302', 'GT-S5302', 'GT-S5302'),
(705, 'Galaxy Y', 'GT-S5360', 'Galaxy Y GT-S5360'),
(706, 'Galaxy Y', 'GT-S5360B', 'Galaxy Y GT-S5360B'),
(707, 'Galaxy Y', 'GT-S5360L', 'Galaxy Y GT-S5360L'),
(708, 'GT-S5363', 'GT-S5363', 'GT-S5363'),
(709, 'Samsung Galaxy Y TV', 'GT-S5367', 'Samsung Galaxy Y TV GT-S5367'),
(710, 'Galaxy Y', 'GT-S5369', 'Galaxy Y GT-S5369'),
(711, 'Galaxy Pop Plus', 'GT-S5570I', 'Galaxy Pop Plus GT-S5570I'),
(712, 'Galaxy Gio', 'GT-S5660V', 'Galaxy Gio GT-S5660V'),
(713, 'Xcover', 'GT-S5690', 'Xcover GT-S5690'),
(714, 'Xcover', 'GT-S5690L', 'Xcover GT-S5690L'),
(715, 'Galaxy Ace S5820', 'GT-S5820', 'Galaxy Ace S5820 GT-S5820'),
(716, 'Galaxy Ace', 'GT-S5830D', 'Galaxy Ace GT-S5830D'),
(717, 'Galaxy Ace', 'GT-S5830M', 'Galaxy Ace GT-S5830M'),
(718, 'Galaxy Ace', 'GT-S5830i', 'Galaxy Ace GT-S5830i'),
(719, 'GT-S5838', 'GT-S5838', 'GT-S5838'),
(720, 'Galaxy Ace', 'GT-S5839i', 'Galaxy Ace GT-S5839i'),
(721, 'Galaxy Y Duos', 'GT-S6102', 'Galaxy Y Duos GT-S6102'),
(722, 'Galaxy Y Duos', 'GT-S6102B', 'Galaxy Y Duos GT-S6102B'),
(723, 'Galaxy Y Duos', 'GT-S6102E', 'Galaxy Y Duos GT-S6102E'),
(724, 'Galaxy Y Pop', 'GT-S6108', 'Galaxy Y Pop GT-S6108'),
(725, 'Galaxy Ace', 'GT-S6358', 'Galaxy Ace GT-S6358'),
(726, 'Galaxy Mini 2', 'GT-S6500', 'Galaxy Mini 2 GT-S6500'),
(727, 'Galaxy Mini 2', 'GT-S6500D', 'Galaxy Mini 2 GT-S6500D'),
(728, 'Galaxy Mini 2', 'GT-S6500L', 'Galaxy Mini 2 GT-S6500L'),
(729, 'Galaxy Ace Duos', 'GT-S6802', 'Galaxy Ace Duos GT-S6802'),
(730, 'Galaxy Ace Duos', 'GT-S6802B', 'Galaxy Ace Duos GT-S6802B'),
(731, 'Galaxy Ace Plus', 'GT-S7500', 'Galaxy Ace Plus GT-S7500'),
(732, 'Galaxy Ace Plus', 'GT-S7500L', 'Galaxy Ace Plus GT-S7500L'),
(733, 'Zero', 'Zero', 'Zero'),
(734, 'Ascend Y H866C', 'H866C', 'Ascend Y H866C H866C'),
(735, 'HD7 Pro', 'HD7 Pro', 'HD7 Pro'),
(736, 'Touchpad', 'Touchpad', 'Touchpad'),
(737, 'Wildfire S', 'A510', 'Wildfire S A510'),
(738, 'Wildfire S', 'A510c', 'Wildfire S A510c'),
(739, 'Wildfire S', 'A510e', 'Wildfire S A510e'),
(740, 'Amaze 4G', 'Amaze 4G', 'Amaze 4G'),
(741, 'ChaChaCha', 'A810e', 'ChaChaCha A810e'),
(742, 'ChaCha', 'A810e', 'ChaCha A810e'),
(743, 'Desire HD', 'A9191', 'Desire HD A9191'),
(744, 'Desire S', 'Desire S', 'Desire S'),
(745, 'X0H6T', 'Desire', 'X0H6T Desire'),
(746, 'Desire GINGERBREAD', 'A8180', 'Desire GINGERBREAD A8180'),
(747, 'HTC Desire HD', 'HTC Desire HD', 'HTC Desire HD'),
(748, 'Desire S', 'S510e', 'Desire S S510e'),
(749, 'EVO 3D', 'X515a', 'EVO 3D X515a'),
(750, 'EVO 3D', 'X515m', 'EVO 3D X515m'),
(751, 'EVO 3D', 'X515', 'EVO 3D X515'),
(752, 'Explorer', 'A310e', 'Explorer A310e'),
(753, 'Flyer', 'Flyer', 'Flyer'),
(754, 'Hero S', 'Hero S', 'Hero S'),
(755, 'Raider 4G', 'X710a', 'Raider 4G X710a'),
(756, 'Inspire 3D', 'X515', 'Inspire 3D X515'),
(757, 'Status', 'PH06130', 'Status PH06130'),
(758, 'Vivid 4G', 'PH39100', 'Vivid 4G PH39100'),
(759, 'Panache 4G', 'Panache 4G', 'Panache 4G'),
(760, 'Sensation', 'Pyramid', 'Sensation Pyramid'),
(761, 'Raider 4G', 'X710e', 'Raider 4G X710e'),
(762, 'Rhyme', 'S510b', 'Rhyme S510b'),
(763, 'Salsa', 'Salsa', 'Salsa'),
(764, 'Sensation', 'SensationXE Beats Z715e', 'Sensation SensationXE Beats Z715e'),
(765, 'Sensation XL with Beats Audio', 'X315b', 'Sensation XL with Beats Audio X315b'),
(766, 'Sensation XL with Beats Audio', 'X315e', 'Sensation XL with Beats Audio X315e'),
(767, 'Sensation', 'Z710a', 'Sensation Z710a'),
(768, 'Sensation', 'Z710', 'Sensation Z710'),
(769, 'Velocity 4G', 'Velocity 4G', 'Velocity 4G'),
(770, 'Wildfire S', 'A510b', 'Wildfire S A510b'),
(771, 'EVO 4G+', 'Rider', 'EVO 4G+ Rider'),
(772, 'Sensation', 'Sensation Z710a', 'Sensation Sensation Z710a'),
(773, 'Sensation', 'Z710t', 'Sensation Z710t'),
(774, 'C8650 Plus', 'C8650 Plus', 'C8650 Plus'),
(775, 'Sonic', 'U8650', 'Sonic U8650'),
(776, 'U8661', 'U8661', 'U8661'),
(777, 'Ascend Y210', 'Y210-0151', 'Ascend Y210 Y210-0151'),
(778, 'Activa 4G', 'M920', 'Activa 4G M920'),
(779, 'Vision', 'U8850', 'Vision U8850'),
(780, 'Ascend G300C', 'C8810', 'Ascend G300C C8810'),
(781, 'Fusion for AT&T', 'U8652', 'Fusion for AT&T U8652'),
(782, 'Fusion 2', 'U8665', 'Fusion 2 U8665'),
(783, 'Impression 10', 'i10', 'Impression 10 i10'),
(784, 'Mirach A', 'IM-A740S', 'Mirach A IM-A740S'),
(785, 'Mirach A', 'IM-A750K', 'Mirach A IM-A750K'),
(786, 'SKY Vega Racer (SKT)', 'IM-A760S', 'SKY Vega Racer (SKT) IM-A760S'),
(787, 'SKY Vega Racer (KT)', 'IM-A770K', 'SKY Vega Racer (KT) IM-A770K'),
(788, 'SKY Vega Racer (LG U+)', 'IM-A780L', 'SKY Vega Racer (LG U+) IM-A780L'),
(789, 'Vega LTE', 'IM-A800S', 'Vega LTE IM-A800S'),
(790, 'Vega LTE M', 'IM-A810K', 'Vega LTE M IM-A810K'),
(791, 'Vega LTE M', 'IM-A810S', 'Vega LTE M IM-A810S'),
(792, 'Vega LTE EX', 'IM-A820L', 'Vega LTE EX IM-A820L'),
(793, 'Vega No 5', 'IM-T100K', 'Vega No 5 IM-T100K'),
(794, 'INFOBAR A01 for KDDI au iida', 'A01', 'INFOBAR A01 for KDDI au iida A01'),
(795, 'Infobar C01', 'Infobar C01', 'Infobar C01'),
(796, 'Android 2.3', 'Android 2.3', 'Android 2.3'),
(797, 'IQ240', 'IQ240', 'IQ240'),
(798, 'IQ255', 'IQ255', 'IQ255'),
(799, 'G\'z One IS11CA for KDDI au', 'IS11CA', 'G\'z One IS11CA for KDDI au IS11CA'),
(800, 'Optimus X', 'IS11LG', 'Optimus X IS11LG'),
(801, 'IS11N', 'IS11N', 'IS11N'),
(802, 'MIRACH IS11PT for KDDI', 'IS11PT', 'MIRACH IS11PT for KDDI IS11PT'),
(803, 'Xperia acro', 'IS11S', 'Xperia acro IS11S'),
(804, 'AQUOS PHONE IS11SH for KDDI au', 'IS11SH', 'AQUOS PHONE IS11SH for KDDI au IS11SH'),
(805, 'REGZA Phone IS11T for KDDI', 'IS11T', 'REGZA Phone IS11T for KDDI IS11T'),
(806, 'Arrows ES IS12F', 'IS12F', 'Arrows ES IS12F IS12F'),
(807, '3D AQUOS PHONE IS12SH for KDDI au', 'IS12SH', '3D AQUOS PHONE IS12SH for KDDI au IS12SH'),
(808, 'AQUOS Phone IS13SH for KDDI', 'IS13SH', 'AQUOS Phone IS13SH for KDDI IS13SH'),
(809, 'Aquos Phone IS14SH', 'IS14SH', 'Aquos Phone IS14SH IS14SH'),
(810, 'ARROWS Z ISW11F for KDDI', 'ISW11F', 'ARROWS Z ISW11F for KDDI ISW11F'),
(811, 'Digno ISW11K', 'ISW11K', 'Digno ISW11K ISW11K'),
(812, 'PHOTON ISW11M for KDDI', 'ISW11M', 'PHOTON ISW11M for KDDI ISW11M'),
(813, 'Galaxy SII WiMAX', 'ISW11SC', 'Galaxy SII WiMAX ISW11SC'),
(814, 'EVO 3D ISW12HT for KDDI', 'ISW12HT', 'EVO 3D ISW12HT for KDDI ISW12HT'),
(815, 'Aqua 3.2', 'Aqua 3.2', 'Aqua 3.2'),
(816, 'Aqua Marvel', 'G32', 'Aqua Marvel G32'),
(817, 'Vox eReader', 'K080', 'Vox eReader K080'),
(818, 'Agora 10', 'Agora 10', 'Agora 10'),
(819, 'TAKE Janus', 'KM-S200', 'TAKE Janus KM-S200'),
(820, 'TAKE Tachy', 'KM-S220', 'TAKE Tachy KM-S220'),
(821, 'TAKE HD', 'KM-S300', 'TAKE HD KM-S300'),
(822, 'A9', 'A9', 'A9'),
(823, 'Optimus LTE', 'L-01D', 'Optimus LTE L-01D'),
(824, 'Optimus Bright', 'L-02D', 'Optimus Bright L-02D'),
(825, 'Optimus bright L-07C for DoCoMo', 'L-07C', 'Optimus bright L-07C for DoCoMo L-07C'),
(826, 'Iris 351', '351', 'Iris 351 351'),
(827, 'Optimus 2', 'AS680', 'Optimus 2 AS680'),
(828, 'Optimus Plus', 'AS695', 'Optimus Plus AS695'),
(829, 'Ignite', 'AS855', 'Ignite AS855'),
(830, 'Optimus Pro', 'C660h', 'Optimus Pro C660h'),
(831, 'DoublePlay', 'C729', 'DoublePlay C729'),
(832, 'myTouch Q', 'C800', 'myTouch Q C800'),
(833, 'Optimus L3', 'E400', 'Optimus L3 E400'),
(834, 'Optimus L3', 'E400f', 'Optimus L3 E400f'),
(835, 'Optimus L3', 'E400g', 'Optimus L3 E400g'),
(836, 'Optimus L3', 'E405', 'Optimus L3 E405'),
(837, 'Optimus L3', 'E405F', 'Optimus L3 E405F'),
(838, 'Optimus Hub', 'E510', 'Optimus Hub E510'),
(839, 'Optimus Hub', 'E510g', 'Optimus Hub E510g'),
(840, 'E730', 'E730', 'E730'),
(841, 'E730f', 'E730f', 'E730f'),
(842, 'myTouch E739BK', 'E739BK', 'myTouch E739BK E739BK'),
(843, 'Optimus Vu', 'F100L', 'Optimus Vu F100L'),
(844, 'Optimus Vu', 'F100S', 'Optimus Vu F100S'),
(845, 'Optimus LTE TAG', 'F120K', 'Optimus LTE TAG F120K'),
(846, 'Optimus LTE TAG', 'F120L', 'Optimus LTE TAG F120L'),
(847, 'Optimus LTE TAG', 'F120S', 'Optimus LTE TAG F120S'),
(848, 'Optimus LTE2', 'F160K', 'Optimus LTE2 F160K'),
(849, 'Prada 3.0', 'KU5400', 'Prada 3.0 KU5400'),
(850, 'Marquee', 'LG855', 'Marquee LG855'),
(851, 'Gelato', 'LS685', 'Gelato LS685'),
(852, 'Optimus Elite', 'LS696', 'Optimus Elite LS696'),
(853, 'Gelato Q', 'LS700', 'Gelato Q LS700'),
(854, 'Viper 4G LTE', 'LS840', 'Viper 4G LTE LS840'),
(855, 'Marquee', 'LS855', 'Marquee LS855'),
(856, 'Optimus LTE', 'LU6200', 'Optimus LTE LU6200'),
(857, 'Optimus Q2', 'LU6500', 'Optimus Q2 LU6500'),
(858, 'Optimus M+', 'MS695', 'Optimus M+ MS695'),
(859, 'Connect 4G', 'MS840', 'Connect 4G MS840'),
(860, 'Bryce', 'MS910', 'Bryce MS910'),
(861, 'Optimus Spirit', 'P690f', 'Optimus Spirit P690f'),
(862, 'LG/P692/V1.0', 'LG/P692/V1.0', 'LG/P692/V1.0'),
(863, 'Optimus Dual Sim', 'P698F', 'Optimus Dual Sim P698F'),
(864, 'Optimus 3D Max', 'P720', 'Optimus 3D Max P720'),
(865, 'Optimus 3D Max', 'P725', 'Optimus 3D Max P725'),
(866, 'Thrill', 'P925g', 'Thrill P925g'),
(867, 'Optimus LTE', 'P930', 'Optimus LTE P930'),
(868, 'Optimus 4G LTE', 'P935', 'Optimus 4G LTE P935'),
(869, 'Optimus LTE', 'P936', 'Optimus LTE P936'),
(870, 'Prada 3.0', 'P940', 'Prada 3.0 P940'),
(871, 'Optimus Black', 'P970g', 'Optimus Black P970g'),
(872, 'Prada 3.0', 'SU540', 'Prada 3.0 SU540'),
(873, 'Optimus LTE', 'SU640', 'Optimus LTE SU640'),
(874, 'Optimus 3D Cube', 'SU870', 'Optimus 3D Cube SU870'),
(875, 'Optimus EX', 'Su880', 'Optimus EX Su880'),
(876, 'Optimus Elite', 'VM696', 'Optimus Elite VM696'),
(877, 'Optimus Slider', 'VM701', 'Optimus Slider VM701'),
(878, 'Enlighten', 'VS700', 'Enlighten VS700'),
(879, 'Optimus Pro', 'C660', 'Optimus Pro C660'),
(880, 'Optimus Net', 'L45C', 'Optimus Net L45C'),
(881, 'Optimus Q', 'L55c', 'Optimus Q L55c'),
(882, 'Optimus Zip', 'L75C', 'Optimus Zip L75C'),
(883, 'A790e', 'A790e', 'A790e'),
(884, 'Xperia Arc', 'LT15a', 'Xperia Arc LT15a'),
(885, 'Xperia Arc', 'LT15i', 'Xperia Arc LT15i'),
(886, 'Xperia Arc', 'LT18a', 'Xperia Arc LT18a'),
(887, 'Xperia Arc', 'LT18i', 'Xperia Arc LT18i'),
(888, 'Xperia P LT22i', 'LT22i', 'Xperia P LT22i LT22i'),
(889, 'Xperia Arc HD', 'LT26i', 'Xperia Arc HD LT26i'),
(890, 'Xperia Ion', 'LT28i', 'Xperia Ion LT28i'),
(891, 'A366t', 'A366t', 'A366t'),
(892, 'Lady', 'A520', 'Lady A520'),
(893, 'Lephone A60', 'A60', 'Lephone A60 A60'),
(894, 'A750', 'A750', 'A750'),
(895, 'LePhone S2-38AH0', 'LePhone S2-38AH0', 'LePhone S2-38AH0'),
(896, 'Liquid MT', 'S120', 'Liquid MT S120'),
(897, 'M-Pad NP720', 'M-Pad NP720', 'M-Pad NP720'),
(898, 'M009F', 'M009F', 'M009F'),
(899, 'Sprint Express', 'M650', 'Sprint Express M650'),
(900, 'Ascend II', 'M865', 'Ascend II M865'),
(901, 'Glory', 'M886', 'Glory M886'),
(902, 'MB526', 'MB526', 'MB526'),
(903, 'Pro+', 'MB632', 'Pro+ MB632'),
(904, 'Photon', 'MB855', 'Photon MB855'),
(905, 'Atrix 2', 'MB865', 'Atrix 2 MB865'),
(906, 'Droid X2', 'MB870', 'Droid X2 MB870'),
(907, 'MX', 'MX', 'MX'),
(908, 'MI-ONE C1', 'MI-ONE C1', 'MI-ONE C1'),
(909, 'M1 Plus', 'MI-ONE Plus', 'M1 Plus MI-ONE Plus'),
(910, 'Kyros MID1125', 'MID1125', 'Kyros MID1125 MID1125'),
(911, 'Kyros MID1126', 'MID1126', 'Kyros MID1126 MID1126'),
(912, 'Kyros MID7012', 'MID7012', 'Kyros MID7012 MID7012'),
(913, 'MID7014', 'MID7014', 'MID7014'),
(914, 'Kyros MID7016', 'MID7016', 'Kyros MID7016 MID7016'),
(915, 'Kyros MID7022', 'MID7022', 'Kyros MID7022 MID7022'),
(916, 'Kyros MID7026', 'MID7026', 'Kyros MID7026 MID7026'),
(917, 'Kyros MID7120', 'MID7120', 'Kyros MID7120 MID7120'),
(918, 'Kyros MID7125', 'MID7125', 'Kyros MID7125 MID7125'),
(919, 'Kyros MID7127', 'MID7127', 'Kyros MID7127 MID7127'),
(920, 'Kyros MID8120', 'MID8120', 'Kyros MID8120 MID8120'),
(921, 'Kyros MID8125', 'MID8125', 'Kyros MID8125 MID8125'),
(922, 'Kyros MID8127', 'MID8127', 'Kyros MID8127 MID8127'),
(923, 'MOT-XT303', 'MOT-XT303', 'MOT-XT303'),
(924, 'Motoluxe XT389', 'XT389', 'Motoluxe XT389 XT389'),
(925, 'XT390', 'XT390', 'XT390'),
(926, 'Defy XT', 'XT535', 'Defy XT XT535'),
(927, 'XT615', 'XT615', 'XT615'),
(928, 'RAZR XT910 Spider', 'XT910', 'RAZR XT910 Spider XT910'),
(929, 'Smart Pad 700 3G', 'MP700', 'Smart Pad 700 3G MP700'),
(930, 'Smart Pad MP907C', 'MP907C', 'Smart Pad MP907C MP907C'),
(931, 'Xperia Neo V', 'MT11a', 'Xperia Neo V MT11a'),
(932, 'Xperia Neo V', 'MT11i', 'Xperia Neo V MT11i'),
(933, 'Xperia Neo', 'MT15i', 'Xperia Neo MT15i'),
(934, 'Xperia Sola', 'MT27i', 'Xperia Sola MT27i'),
(935, 'MT791', 'MT791', 'MT791'),
(936, 'A27', 'A27', 'A27'),
(937, 'A30', 'A30', 'A30'),
(938, 'Ninja', 'A50', 'Ninja A50'),
(939, 'Ninja 3', 'A57', 'Ninja 3 A57'),
(940, 'A65', 'A65', 'A65'),
(941, 'Superfone Lite', 'A75', 'Superfone Lite A75'),
(942, 'Ninja 4', 'A87', 'Ninja 4 A87'),
(943, 'Milestone X2', 'MB867', 'Milestone X2 MB867'),
(944, 'Electrify', 'Electrify', 'Electrify'),
(945, 'XT681', 'XT681', 'XT681'),
(946, 'MEDIAS PP N-01D for DoCoMo', 'N-01D', 'MEDIAS PP N-01D for DoCoMo N-01D'),
(947, 'NEXT series MEDIAS LTE N-04D', 'N-04D', 'NEXT series MEDIAS LTE N-04D N-04D'),
(948, 'Medias WP N-06C for DoCoMo', 'N-06C', 'Medias WP N-06C for DoCoMo N-06C'),
(949, 'N320', 'N320', 'N320'),
(950, 'Iris N350', 'N350', 'Iris N350 N350'),
(951, 'N762', 'N762', 'N762'),
(952, 'N860', 'N860', 'N860'),
(953, 'Action', 'eagle75', 'Action eagle75'),
(954, 'Wemove Explorer', 'Wemove Explorer', 'Wemove Explorer'),
(955, 'Orion', 'Orion', 'Orion'),
(956, 'quasar', 'ztemt73', 'quasar ztemt73'),
(957, 'VanitySmart', 'VanitySmart', 'VanitySmart VanitySmart'),
(958, 'Winn', 'Winn', 'Winn'),
(959, 'NOOK Tablet', 'BNTV250', 'NOOK Tablet BNTV250'),
(960, 'NOOK Tablet', 'BNTV250A', 'NOOK Tablet BNTV250A'),
(961, 'NW-Z1000', 'NW-Z1000', 'NW-Z1000'),
(962, 'Premium 7', 'NXM726HN', 'Premium 7 NXM726HN'),
(963, 'Premium8', 'NXM803HC', 'Premium8 NXM803HC'),
(964, 'Premium9', 'NXM908HC', 'Premium9 NXM908HC'),
(965, 'Nexus S 4G', 'Nexus S 4G', 'Nexus S 4G'),
(966, 'Nexus S', 'Nexus S', 'Nexus S'),
(967, 'Novo7 Advanced', 'Novo7 Advanced', 'Novo7 Advanced'),
(968, 'Xpress', 'Xpress', 'Xpress'),
(969, 'One Touch 983', 'OT-983', 'One Touch 983 OT-983'),
(970, 'One Touch 960C', 'OT-960C', 'One Touch 960C OT-960C'),
(971, 'Loox', 'Loox', 'Loox'),
(972, 'Monte Carlo', 'Skate', 'Monte Carlo Skate'),
(973, 'P-01D for DoCoMo', 'P-01D', 'P-01D for DoCoMo P-01D'),
(974, 'LUMIX Phone P-02D for DoCoMo', 'P-02D', 'LUMIX Phone P-02D for DoCoMo P-02D'),
(975, 'P-07C for DoCoMo', 'P-07C', 'P-07C for DoCoMo P-07C'),
(976, 'Orion', 'P4D Orion', 'Orion P4D Orion'),
(977, 'P76TI', 'P76TI', 'P76TI'),
(978, 'Evo View 4G Tablet', 'ATP515CKIT', 'Evo View 4G Tablet ATP515CKIT'),
(979, 'EVO 3D', 'PG86100', 'EVO 3D PG86100'),
(980, 'EVO Design 4G', 'PH44100', 'EVO Design 4G PH44100'),
(981, '7inch Internet Tablet', 'PMID700', '7inch Internet Tablet PMID700'),
(982, 'PMP3384B', 'PMP3384B', 'PMP3384B'),
(983, 'PMP5080B', 'PMP5080B', 'PMP5080B'),
(984, 'Cruz PS47', 'PS47', 'Cruz PS47 PS47'),
(985, 'PTAB7200', 'PTAB7200', 'PTAB7200'),
(986, 'Eluga', 'dL1', 'Eluga dL1'),
(987, 'Pocket', 'P9060', 'Pocket P9060'),
(988, 'Burst', 'P9070', 'Burst P9070'),
(989, 'PlayBook', 'PlayBook', 'PlayBook'),
(990, 'Prism', 'U8651T', 'Prism U8651T'),
(991, 'Q4350', 'Q4350', 'Q4350'),
(992, 'Xperia PLAY', 'R800a', 'Xperia PLAY R800a'),
(993, 'Xperia PLAY', 'R800at', 'Xperia PLAY R800at'),
(994, 'Xperia PLAY', 'R800i', 'Xperia PLAY R800i'),
(995, 'Xperia PLAY', 'R800x', 'Xperia PLAY R800x'),
(996, 'W6HD', 'W6HD', 'W6HD'),
(997, 'LePad S2005A-H', 'S2005A-H', 'LePad S2005A-H S2005A-H'),
(998, 'Acer S300', 'Acer S300', 'Acer S300'),
(999, 'Pocket WiFi S II for emobile', 'S41HW', 'Pocket WiFi S II for emobile S41HW'),
(1000, 'smart bar S42HW for emobile', 'S42HW', 'smart bar S42HW for emobile S42HW'),
(1001, 'Sony Ericsson mini for emobile', 'S51SE', 'Sony Ericsson mini for emobile S51SE'),
(1002, 'GoGear SA3CNT', 'GoGear SA3CNT', 'GoGear SA3CNT'),
(1003, 'Galaxy SII LTE', 'GT-I9210', 'Galaxy SII LTE GT-I9210'),
(1004, 'Galaxy Y', 'GT-S5360T', 'Galaxy Y GT-S5360T'),
(1005, 'Exhilarate', 'SGH-I577', 'Exhilarate SGH-I577'),
(1006, 'Galaxy Note', 'SGH-i717', 'Galaxy Note SGH-i717'),
(1007, 'Galaxy S II Skyrocket', 'SGH-I727', 'Galaxy S II Skyrocket SGH-I727'),
(1008, 'Galaxy S II', 'SGH-I777', 'Galaxy S II SGH-I777'),
(1009, 'SGH-I807D', 'SGH-I807D', 'SGH-I807D'),
(1010, 'Galaxy Appeal', 'SGH-I827', 'Galaxy Appeal SGH-I827'),
(1011, 'Rugby Smart', 'SGH-I847', 'Rugby Smart SGH-I847'),
(1012, 'Captivate Glide', 'SGH-i927', 'Captivate Glide SGH-i927'),
(1013, 'Captivate Glide', 'SGH-i927R', 'Captivate Glide SGH-i927R'),
(1014, 'Infuse', 'SGH-I997R', 'Infuse SGH-I997R'),
(1015, 'AQUOS PHONE SoftBank 006SH', '006SH', 'AQUOS PHONE SoftBank 006SH 006SH'),
(1016, 'AQUOS Phone', '007SH', 'AQUOS Phone 007SH'),
(1017, 'AQUOS PHONE THE PREMIUM 009SH for Softbank', '009SH', 'AQUOS PHONE THE PREMIUM 009SH for Softbank 009SH'),
(1018, 'AQUOS PHONE THE HYBRID 101SH for Softbank', '101SH', 'AQUOS PHONE THE HYBRID 101SH for Softbank 101SH'),
(1019, 'SBM102SH', 'SBM102SH', 'SBM102SH'),
(1020, 'Aquos Phone 103SH', 'SBM103SH', 'Aquos Phone 103SH SBM103SH'),
(1021, 'Galaxy S II SC-02C for DoCoMo', 'SC-02C', 'Galaxy S II SC-02C for DoCoMo SC-02C'),
(1022, 'GALAXY S II LTE SC-03D for DoCoMo', 'SC-03D', 'GALAXY S II LTE SC-03D for DoCoMo SC-03D'),
(1023, 'Illusion', 'SCH-i110', 'Illusion SCH-i110'),
(1024, 'Stratosphere', 'SCH-i405', 'Stratosphere SCH-i405'),
(1025, 'Galaxy Ace Duos', 'SCH-i589', 'Galaxy Ace Duos SCH-i589'),
(1026, 'Galaxy Ace Plus', 'SCH-I659', 'Galaxy Ace Plus SCH-I659'),
(1027, 'Galaxy Tab 7', 'SCH-I800', 'Galaxy Tab 7 SCH-I800'),
(1028, 'Repp', 'SCH-R680', 'Repp SCH-R680'),
(1029, 'Admire', 'SCH-R720', 'Admire SCH-R720'),
(1030, 'Transfix', 'SCH-R730', 'Transfix SCH-R730'),
(1031, 'Galaxy S II', 'SCH-R760', 'Galaxy S II SCH-R760'),
(1032, 'Galaxy Attain 4G', 'SCH-R920', 'Galaxy Attain 4G SCH-R920'),
(1033, 'Galaxy S Aviator', 'SCH-R930', 'Galaxy S Aviator SCH-R930'),
(1034, 'Galaxy Proclaim', 'SCH-S720C', 'Galaxy Proclaim SCH-S720C');
INSERT INTO `smdevicenames` (`DeviceNameID`, `DeviceName`, `DeviceModel`, `MarketingName`) VALUES
(1035, 'SCH-W999', 'SCH-W999', 'SCH-W999'),
(1036, 'Galaxy Young CDMA', 'SCH-i509', 'Galaxy Young CDMA SCH-i509'),
(1037, 'Galaxy Note', 'SCH-i889', 'Galaxy Note SCH-i889'),
(1038, 'Galaxy S Duos', 'SCH-i919', 'Galaxy S Duos SCH-i919'),
(1039, 'SCH-i929', 'SCH-i929', 'SCH-i929'),
(1040, 'Galaxy Note LTE', 'SGH-i717', 'Galaxy Note LTE SGH-i717'),
(1041, 'Galaxy Note LTE', 'SGH-i717M', 'Galaxy Note LTE SGH-i717M'),
(1042, 'Galaxy Note LTE', 'SGH-i717R', 'Galaxy Note LTE SGH-i717R'),
(1043, 'Exhibit II 4G', 'SGH-T679', 'Exhibit II 4G SGH-T679'),
(1044, 'Exhibit II 4G', 'SGH-T679M', 'Exhibit II 4G SGH-T679M'),
(1045, 'Exhibit 4G', 'SGH-T759', 'Exhibit 4G SGH-T759'),
(1046, 'Galaxy S Blaze 4G', 'SGH-T769', 'Galaxy S Blaze 4G SGH-T769'),
(1047, 'Galaxy Note', 'SGH-T879', 'Galaxy Note SGH-T879'),
(1048, 'Vibrant', 'SGH-T959P', 'Vibrant SGH-T959P'),
(1049, 'Galaxy SII', 'SGH-T989', 'Galaxy SII SGH-T989'),
(1050, 'Galaxy S II X', 'SGH-T989D', 'Galaxy S II X SGH-T989D'),
(1051, 'AQUOS PHONE SH-01D for DoCoMo', 'SH-01D', 'AQUOS PHONE SH-01D for DoCoMo SH-01D'),
(1052, 'AQUOS PHONE slider SH-02D', 'SH-02D', 'AQUOS PHONE slider SH-02D SH-02D'),
(1053, 'Q-pot.Phone SH-04D', 'SH-04D', 'Q-pot.Phone SH-04D SH-04D'),
(1054, 'NERV', 'SH-06D', 'NERV SH-06D'),
(1055, 'AQUOS PHONE SH-12C for DoCoMo', 'SH-12C', 'AQUOS PHONE SH-12C for DoCoMo SH-12C'),
(1056, 'AQUOS PHONE f SH-13C for DoCoMo', 'SH-13C', 'AQUOS PHONE f SH-13C for DoCoMo SH-13C'),
(1057, 'Galaxy S II LTE', 'SHV-E110S', 'Galaxy S II LTE SHV-E110S'),
(1058, 'Galaxy SII HD', 'SHV-E120K', 'Galaxy SII HD SHV-E120K'),
(1059, 'Galaxy S II HD', 'SHV-E120L', 'Galaxy S II HD SHV-E120L'),
(1060, 'Galaxy S II HD', 'SHV-E120S', 'Galaxy S II HD SHV-E120S'),
(1061, 'Galaxy Note', 'SHV-E160K', 'Galaxy Note SHV-E160K'),
(1062, 'Galaxy Note', 'SHV-E160L', 'Galaxy Note SHV-E160L'),
(1063, 'Galaxy Note', 'SHV-E160S', 'Galaxy Note SHV-E160S'),
(1064, 'GALAXY S II (KT)', 'SHW-M250K', 'GALAXY S II (KT) SHW-M250K'),
(1065, 'GALAXY S II (LG U+)', 'SHW-M250L', 'GALAXY S II (LG U+) SHW-M250L'),
(1066, 'GALAXY S II (SKT)', 'SHW-M250S', 'GALAXY S II (SKT) SHW-M250S'),
(1067, 'Galaxy M Style', 'SHW-M340K', 'Galaxy M Style SHW-M340K'),
(1068, 'Galaxy M Style', 'SHW-M340L', 'Galaxy M Style SHW-M340L'),
(1069, 'Galaxy M Style', 'SHW-M340S', 'Galaxy M Style SHW-M340S'),
(1070, 'Xperia Mini Pro', 'SK17a', 'Xperia Mini Pro SK17a'),
(1071, 'Xperia Mini Pro', 'SK17i', 'Xperia Mini Pro SK17i'),
(1072, 'Alpha 2', 'Alpha 2', 'Alpha 2'),
(1073, 'Smart Pad 810c', 'Smart Pad 810c', 'Smart Pad 810c'),
(1074, 'Xperia PLAY SO-01D for DoCoMo', 'SO-01D', 'Xperia PLAY SO-01D for DoCoMo SO-01D'),
(1075, 'Xperia acro', 'SO-02C', 'Xperia acro SO-02C'),
(1076, 'Xperia TM NX SO-02D', 'SO-02D', 'Xperia TM NX SO-02D SO-02D'),
(1077, 'Xperia ray SO-03C for DoCoMo', 'SO-03C', 'Xperia ray SO-03C for DoCoMo SO-03C'),
(1078, 'Xperia acro HD', 'SO-03D', 'Xperia acro HD SO-03D'),
(1079, 'Conquer', 'SPH-D600', 'Conquer SPH-D600'),
(1080, 'Galaxy SII Epic 4G Touch', 'SPH-D710', 'Galaxy SII Epic 4G Touch SPH-D710'),
(1081, 'Galaxy Prevail', 'SPH-M820', 'Galaxy Prevail SPH-M820'),
(1082, 'Transform Ultra', 'SPH-930', 'Transform Ultra SPH-930'),
(1083, 'SPX-5 3G', 'SPX-5 3G', 'SPX-5 3G'),
(1084, 'ST15i', 'ST15i', 'ST15i'),
(1085, 'Urushi', 'ST18a', 'Urushi ST18a'),
(1086, 'Urushi', 'ST18i', 'Urushi ST18i'),
(1087, 'Xperia U', 'ST25a', 'Xperia U ST25a'),
(1088, 'Xperia U', 'ST25i', 'Xperia U ST25i'),
(1089, 'ST27i', 'ST27i', 'ST27i'),
(1090, 'Pascal', 'STM722HCZ', 'Pascal STM722HCZ'),
(1091, 'Kepler', 'M803', 'Kepler M803'),
(1092, 'Alpha', 'Alpha', 'Alpha'),
(1093, 'Skypad Alpha2', 'SX-SP715A', 'Skypad Alpha2 SX-SP715A'),
(1094, 'Scroll Excel', 'Scroll Excel', 'Scroll Excel'),
(1095, 'Sensation', 'Sensation 4G', 'Sensation Sensation 4G'),
(1096, 'acro HD IS12S', 'IS12S', 'acro HD IS12S IS12S'),
(1097, 'Xperia arc SO-01C for DoCoMo', 'LT15i', 'Xperia arc SO-01C for DoCoMo LT15i'),
(1098, 'Xperia Ion LTE', 'LT28at', 'Xperia Ion LTE LT28at'),
(1099, 'Xperia Pro', 'Android 2.3', 'Xperia Pro Android 2.3'),
(1100, 'Xperia Neo', 'MT15a', 'Xperia Neo MT15a'),
(1101, 'Xperia Mini Pro', 'SK17i-o', 'Xperia Mini Pro SK17i-o'),
(1102, 'Xperia Play SO-01D', 'SO-01D', 'Xperia Play SO-01D SO-01D'),
(1103, 'ST15a', 'ST15a', 'ST15a'),
(1104, 'Xperia Active', 'ST17a', 'Xperia Active ST17a'),
(1105, 'Xperia Active', 'ST17i', 'Xperia Active ST17i'),
(1106, 'Xperia Go', 'ST27a', 'Xperia Go ST27a'),
(1107, 'Live', 'WT19a', 'Live WT19a'),
(1108, 'Live', 'WT19i', 'Live WT19i'),
(1109, 'Live', 'WT19iv', 'Live WT19iv'),
(1110, 'EVO Design 4G', 'APC715CKT', 'EVO Design 4G APC715CKT'),
(1111, 'REGZA Phone T-01D for DoCoMo', 'T-01D', 'REGZA Phone T-01D for DoCoMo T-01D'),
(1112, 'T-Hub2', 'T-Hub2', 'T-Hub2'),
(1113, 'T-Mobile Vivacity', 'Vivacity', 'T-Mobile Vivacity Vivacity'),
(1114, 'myTouch', 'U8680', 'myTouch U8680'),
(1115, 'Fantastic T3', 'Fantastic T3', 'Fantastic T3'),
(1116, 'T700', 'T700', 'T700'),
(1117, 'T9199+', 'T9199+', 'T9199+'),
(1118, 'T9599', 'T9599', 'T9599'),
(1119, 'Protab 2', 'TAB-7-4GW-4', 'Protab 2 TAB-7-4GW-4'),
(1120, 'PLAYTABPRO', 'PLAYTABPRO', 'PLAYTABPRO'),
(1121, 'Protab 2 XL', 'Protab 2 XL', 'Protab 2 XL'),
(1122, 'Tab 720', 'Tab 720', 'Tab 720'),
(1123, 'TQ150', 'TQ150', 'TQ150'),
(1124, 'My Tab+', 'TT102', 'My Tab+ TT102'),
(1125, 'W3', 'W3', 'W3'),
(1126, 'Campaign', 'T11', 'Campaign T11'),
(1127, 'Ascend Y100', 'U8185', 'Ascend Y100 U8185'),
(1128, 'Ascend Y100', 'U8186', 'Ascend Y100 U8186'),
(1129, 'T Mobile Move Balance', 'U8600', 'T Mobile Move Balance U8600'),
(1130, 'Ascend Y200', 'U8655', 'Ascend Y200 U8655'),
(1131, 'U8667', 'U8667', 'U8667'),
(1132, 'Ascent G 300', 'U8815', 'Ascent G 300 U8815'),
(1133, 'Ascent G 300', 'U8815N', 'Ascent G 300 U8815N'),
(1134, 'Ascend G300', 'U8818', 'Ascend G300 U8818'),
(1135, 'Honor', 'U8860', 'Honor U8860'),
(1136, 'Optimus Black', 'US855', 'Optimus Black US855'),
(1137, 'Hero S', 'ADR6285', 'Hero S ADR6285'),
(1138, 'UTV210', 'UTV210', 'UTV210'),
(1139, 'V8403', 'V8403', 'V8403'),
(1140, 'V9c', 'V9c', 'V9c'),
(1141, 'Lucid', 'VS840 4G', 'Lucid VS840 4G'),
(1142, 'Revolution 2', 'VS920 4G', 'Revolution 2 VS920 4G'),
(1143, 'VTAB1008', 'VTAB1008', 'VTAB1008'),
(1144, 'Venture', 'ADR2045', 'Venture ADR2045'),
(1145, 'Smart II 3G', 'v860', 'Smart II 3G v860'),
(1146, 'Smart Q', 'Smart Q', 'Smart Q'),
(1147, 'W801', 'W801', 'W801'),
(1148, 'Score', 'X500', 'Score X500'),
(1149, 'X501 Groove', 'X501 Groove', 'X501 Groove'),
(1150, 'XT311', 'XT311', 'XT311'),
(1151, 'XT317', 'XT317', 'XT317'),
(1152, 'Defy Mini', 'XT320', 'Defy Mini XT320'),
(1153, 'XT530', 'XT530', 'XT530'),
(1154, 'Fire XT', 'XT531', 'Fire XT XT531'),
(1155, 'XT532', 'XT532', 'XT532'),
(1156, 'Defy XT', 'XT556', 'Defy XT XT556'),
(1157, 'Defy Pro', 'XT560', 'Defy Pro XT560'),
(1158, 'Admiral', 'XT603', 'Admiral XT603'),
(1159, 'Jorian', 'XT605', 'Jorian XT605'),
(1160, 'Motosmart Flip', 'XT611', 'Motosmart Flip XT611'),
(1161, 'Atrix TV', 'XT682', 'Atrix TV XT682'),
(1162, 'MotoXT860', 'MotoXT860', 'MotoXT860'),
(1163, 'MOTO XT882', 'XT882', 'MOTO XT882 XT882'),
(1164, 'Xperia X8', 'X8', 'Xperia X8 X8'),
(1165, '7260', '7260', '7260'),
(1166, 'Galaxy Player 4.2', 'YP-GI1', 'Galaxy Player 4.2 YP-GI1'),
(1167, 'Galaxy Player 3.6', 'YP-GS1', 'Galaxy Player 3.6 YP-GS1'),
(1168, 'N880E', 'N880E', 'N880E'),
(1169, 'Skate', 'Skate', 'Skate'),
(1170, 'V791', 'V791', 'V791'),
(1171, 'V889D', 'V889D', 'V889D'),
(1172, 'N760', 'N760', 'N760'),
(1173, 'N910', 'N910', 'N910'),
(1174, 'Blade', 'Blade', 'Blade Blade'),
(1175, 'Avail', 'Z990', 'Avail Z990'),
(1176, 'Merit', 'Z990g', 'Merit Z990g'),
(1177, 'Zpad', 'Zpad', 'Zpad'),
(1178, 'Mi-350n', 'Mi-350n', 'Mi-350n'),
(1179, 'AM801', 'AM801', 'AM801'),
(1180, 'P2', 'P2', 'P2'),
(1181, 'myTouch 4G Slide', 'myTouch 4G Slide', 'myTouch 4G Slide'),
(1182, 'V875', 'V875', 'V875'),
(1183, 'Vivo V1', 'Vivo V1', 'Vivo V1'),
(1184, 'Vangogh', 'Iconia Tab A100', 'Vangogh Iconia Tab A100'),
(1185, 'Picasso', 'A500', 'Picasso A500'),
(1186, 'Picasso', 'A501', 'Picasso A501'),
(1187, 'AT100', 'AT100', 'AT100'),
(1188, 'G100W', 'G100W', 'G100W G100W'),
(1189, 'Galaxy Tab 10.1V', 'GT-P7100', 'Galaxy Tab 10.1V GT-P7100'),
(1190, 'Galaxy Tab 10.1', 'GT-P7500', 'Galaxy Tab 10.1 GT-P7500'),
(1191, 'Optimus Pad', 'L-06C', 'Optimus Pad L-06C'),
(1192, 'Optimus Pad', 'V900', 'Optimus Pad V900'),
(1193, 'G Slate', 'V909', 'G Slate V909'),
(1194, 'Xoom', 'MZ601', 'Xoom MZ601'),
(1195, 'Xoom', 'MZ604', 'Xoom MZ604'),
(1196, 'Xoom', 'MZ605', 'Xoom MZ605'),
(1197, 'TPA60W', 'TPA60W', 'TPA60W TPA60W'),
(1198, 'Eee Pad Transformer TF101', 'TF101', 'Eee Pad Transformer TF101 TF101'),
(1199, 'Xoom', 'Xoom', 'Xoom'),
(1200, 'Galaxy Tab 8.9', 'GT-P7300', 'Galaxy Tab 8.9 GT-P7300'),
(1201, 'Galaxy Tab 8.9', 'GT-P7310', 'Galaxy Tab 8.9 GT-P7310'),
(1202, 'Galaxy Tab 10.1', 'GT-P7500R', 'Galaxy Tab 10.1 GT-P7500R'),
(1203, 'Galaxy Tab 10.1', 'GT-P7510', 'Galaxy Tab 10.1 GT-P7510'),
(1204, 'JetStream', 'PG09410', 'JetStream PG09410'),
(1205, 'IdeaTab A1107', 'A1107', 'IdeaTab A1107 A1107'),
(1206, 'K1', 'K1', 'K1'),
(1207, 'Xoom', 'MZ505', 'Xoom MZ505'),
(1208, 'Xoom', 'MZ606', 'Xoom MZ606'),
(1209, 'Galaxy Tab 10.1', 'SHW-M380S', 'Galaxy Tab 10.1 SHW-M380S'),
(1210, 'Galaxy Tab 10.1', 'SHW-M380W', 'Galaxy Tab 10.1 SHW-M380W'),
(1211, 'Tablet S', 'Tablet S', 'Tablet S'),
(1212, 'ThinkPad Tablet', '1838', 'ThinkPad Tablet 1838'),
(1213, 'Eee Pad Transformer TF101', 'TF101G', 'Eee Pad Transformer TF101 TF101G'),
(1214, 'Galapagos', 'A01SH', 'Galapagos A01SH'),
(1215, 'Vangogh', 'A100', 'Vangogh A100'),
(1216, 'Vangogh', 'A101', 'Vangogh A101'),
(1217, 'Picasso_E', 'A200', 'Picasso_E A200'),
(1218, '101 G9', '101 G9', '101 G9'),
(1219, '80 G9', '80 G9', '80 G9'),
(1220, 'Regza AT1S0', 'AT1S0', 'Regza AT1S0 AT1S0'),
(1221, 'Excite AT200', 'AT200', 'Excite AT200 AT200'),
(1222, 'Mangrove 7', 'Mangrove 7', 'Mangrove 7'),
(1223, 'Streak 10 Pro', 'Streak 10 Pro', 'Streak 10 Pro'),
(1224, 'EPad', 'EPad', 'EPad'),
(1225, 'ARROWS Tab LTE F-01D', 'F-01D', 'ARROWS Tab LTE F-01D F-01D'),
(1226, 'GALAXY Tab 7.0 Plus', 'GT-P6200', 'GALAXY Tab 7.0 Plus GT-P6200'),
(1227, 'GALAXY Tab 7.0 Plus', 'GT-P6200L', 'GALAXY Tab 7.0 Plus GT-P6200L'),
(1228, 'GALAXY Tab 7.0 Plus', 'GT-P6201', 'GALAXY Tab 7.0 Plus GT-P6201'),
(1229, 'Samsung Galaxy Tab 7.0 Plus', 'GT-P6210', 'Samsung Galaxy Tab 7.0 Plus GT-P6210'),
(1230, 'Samsung Galaxy Tab 7.0 Plus', 'GT-P6211', 'Samsung Galaxy Tab 7.0 Plus GT-P6211'),
(1231, 'Galaxy Tab 7.7', 'GT-P6800', 'Galaxy Tab 7.7 GT-P6800'),
(1232, 'Galaxy Tab 7.7', 'GP-P6810', 'Galaxy Tab 7.7 GP-P6810'),
(1233, 'Galaxy Tab 8.9 LTE', 'GT-P7320', 'Galaxy Tab 8.9 LTE GT-P7320'),
(1234, 'Galaxy Tab 10.1N', 'GT-P7501', 'Galaxy Tab 10.1N GT-P7501'),
(1235, 'Galaxy Tab 10.1', 'GT-P7511', 'Galaxy Tab 10.1 GT-P7511'),
(1236, 'Mediapad', 'S7-301w', 'Mediapad S7-301w'),
(1237, 'P9514', 'P9514', 'P9514'),
(1238, 'II', 'II', 'II'),
(1239, 'LifeTab P9516', 'LifeTab P9516', 'LifeTab P9516'),
(1240, 'XOOM 2 ME 3G', 'MZ608', 'XOOM 2 ME 3G MZ608'),
(1241, 'Droid XYBoard 8.2 4G', 'MZ609 4G', 'Droid XYBoard 8.2 4G MZ609 4G'),
(1242, 'Droid XYBoard 8.2', 'MZ609', 'Droid XYBoard 8.2 MZ609'),
(1243, 'Droid XYBoard 10.1', 'MZ617 4G', 'Droid XYBoard 10.1 MZ617 4G'),
(1244, 'Droid XYBoard 10.1', 'MZ617', 'Droid XYBoard 10.1 MZ617'),
(1245, 'Novo7 Basic', 'Novo7 Basic', 'Novo7 Basic'),
(1246, 'OliPad 110', 'OliPad 110', 'OliPad 110 OliPad 110'),
(1247, 'Evo View 4G Tablet', 'PG41200', 'Evo View 4G Tablet PG41200'),
(1248, 'Element', 'P4100', 'Element P4100'),
(1249, 'Galaxy Tab 8.9 LTE', 'SGH-I957', 'Galaxy Tab 8.9 LTE SGH-I957'),
(1250, 'Galaxy Tab 7.7 LTE', 'SCH-I815', 'Galaxy Tab 7.7 LTE SCH-I815'),
(1251, 'Galaxy Tab 10.1 4G', 'SCH-i905', 'Galaxy Tab 10.1 4G SCH-i905'),
(1252, 'Galaxy Tab 8.9 LTE', 'SGH-I957M', 'Galaxy Tab 8.9 LTE SGH-I957M'),
(1253, 'Galaxy Tab 8.9 LTE', 'SGH-I957R', 'Galaxy Tab 8.9 LTE SGH-I957R'),
(1254, 'Galaxy Tab 10.1 4G', 'SGH-T859', 'Galaxy Tab 10.1 4G SGH-T859'),
(1255, 'GALAXY Tab 7.0 Plus 4G', 'SGH-T869', 'GALAXY Tab 7.0 Plus 4G SGH-T869'),
(1256, 'Galaxy Tab 7.7', 'SHV-E150S', 'Galaxy Tab 7.7 SHV-E150S'),
(1257, 'Eee Pad SL101 Slider', 'SL101', 'Eee Pad SL101 Slider SL101'),
(1258, 'Smart Tab 10', 'Smart Tab 10', 'Smart Tab 10'),
(1259, 'Tablet P', 'SGPT211', 'Tablet P SGPT211'),
(1260, 'Springboard', 'Springboard', 'Springboard'),
(1261, 'Transformer Prime', 'Eee Pad TF201', 'Transformer Prime Eee Pad TF201'),
(1262, 'XOOM 2 ME', 'MZ609', 'XOOM 2 ME MZ609'),
(1263, 'Xoom 2', 'MotoMZ616', 'Xoom 2 MotoMZ616'),
(1264, 'Noir A10', 'A10', 'Noir A10 A10'),
(1265, 'A11', 'A11', 'A11'),
(1266, 'A15', 'A15', 'A15'),
(1267, 'A21', 'A21', 'A21'),
(1268, 'A210', 'A210', 'A210'),
(1269, 'IdeaTab A2107A-H', 'A2107A-H', 'IdeaTab A2107A-H A2107A-H'),
(1270, 'A211', 'A211', 'A211'),
(1271, 'A510', 'A510', 'A510'),
(1272, 'A511', 'A511', 'A511'),
(1273, 'A6', 'A6', 'A6'),
(1274, 'Art', 'A7', 'Art A7'),
(1275, 'A700', 'A700', 'A700'),
(1276, 'A701', 'A701', 'A701'),
(1277, 'Noir A8', 'A8', 'Noir A8 A8'),
(1278, 'A9+', 'A9+', 'A9+'),
(1279, 'Superfone Pixel', 'A90s', 'Superfone Pixel A90s'),
(1280, 'A97i', 'A97i', 'A97i'),
(1281, 'Droid Incredible 4G LTE', 'ADR6410LVW 4G', 'Droid Incredible 4G LTE ADR6410LVW 4G'),
(1282, 'Droid Incredible 4G LTE', 'ADR6410LVW', 'Droid Incredible 4G LTE ADR6410LVW'),
(1283, 'Marauder', 'ADR910L 4G', 'Marauder ADR910L 4G'),
(1284, 'Marauder', 'ADR910L', 'Marauder ADR910L'),
(1285, 'AirPad', 'AirPad', 'AirPad'),
(1286, 'One Touch 992D', 'OT-992D', 'One Touch 992D OT-992D'),
(1287, 'ONE TOUCH 993', 'ONE TOUCH 993', 'ONE TOUCH 993'),
(1288, 'One Touch 997', 'OT-997', 'One Touch 997 OT-997'),
(1289, 'One Touch 997D', 'OT-997D', 'One Touch 997D OT-997D'),
(1290, 'N821', 'N821', 'N821'),
(1291, '9 G2I', '9 G2I', '9 G2I'),
(1292, 'Transformer Pad TF300T', 'TF300T', 'Transformer Pad TF300T TF300T'),
(1293, 'Transformer Pad TF300T', 'TF300TG', 'Transformer Pad TF300T TF300TG'),
(1294, 'Transformer Pad TF700 LTE', 'TF700KL', 'Transformer Pad TF700 LTE TF700KL'),
(1295, 'Transformer Pad TF700T', 'TF700T', 'Transformer Pad TF700T TF700T'),
(1296, 'AT-AS43D2', 'AT-AS43D2', 'AT-AS43D2'),
(1297, 'Regza AT300', 'AT300', 'Regza AT300 AT300'),
(1298, 'Wemove Atlantis', 'U8812D', 'Wemove Atlantis U8812D'),
(1299, 'Easy Home Tablet 7 LE', 'EH7LE', 'Easy Home Tablet 7 LE EH7LE'),
(1300, 'Beeline E600', 'Beeline E600', 'Beeline E600'),
(1301, 'Xperia E Dual', 'C1605', 'Xperia E Dual C1605'),
(1302, 'Rise C5155', 'C5155', 'Rise C5155 C5155'),
(1303, 'Hydro C5170', 'C5170', 'Hydro C5170 C5170'),
(1304, 'CMP741E', 'CMP741E', 'CMP741E'),
(1305, 'CMP741D', 'CMP741D', 'CMP741D'),
(1306, 'Cynus T2', 'Cynus T2', 'Cynus T2'),
(1307, 'Liquid Gallant E350', 'E350', 'Liquid Gallant E350 E350'),
(1308, 'Hisense E860', 'E860', 'Hisense E860 E860'),
(1309, 'Galaxy Camera', 'EK-GC100', 'Galaxy Camera EK-GC100'),
(1310, 'EM543', 'EM543', 'EM543'),
(1311, 'EVO 4G LTE', 'X325c/APX325CKT', 'EVO 4G LTE X325c/APX325CKT'),
(1312, 'EasyPad 970 Satellite', 'EasyPad 970', 'EasyPad 970 Satellite EasyPad 970'),
(1313, 'IQ440', 'IQ440', 'IQ440'),
(1314, 'IQ441', 'IQ441', 'IQ441'),
(1315, 'IQ442', 'IQ442', 'IQ442'),
(1316, 'GT-1220', 'GT-1220', 'GT-1220'),
(1317, 'Galaxy Chat', 'GT-B5330', 'Galaxy Chat GT-B5330'),
(1318, 'Galaxy S III Mini', 'GT-I8190', 'Galaxy S III Mini GT-I8190'),
(1319, 'Galaxy S II', 'GT-I9100M', 'Galaxy S II GT-I9100M'),
(1320, 'Galaxy SII Plus', 'GT-I9105', 'Galaxy SII Plus GT-I9105'),
(1321, 'Galaxy Premier', 'GT-I9260', 'Galaxy Premier GT-I9260'),
(1322, 'Galaxy S3', 'GT-I9300', 'Galaxy S3 GT-I9300'),
(1323, 'Galaxy S3 LTE International', 'GT-I9305', 'Galaxy S3 LTE International GT-I9305'),
(1324, 'Galaxy S3', 'GT-I9308', 'Galaxy S3 GT-I9308'),
(1325, 'Galaxy Note 10.1', 'GT-N8000', 'Galaxy Note 10.1 GT-N8000'),
(1326, 'Galaxy Note 10.1', 'GT-N8010', 'Galaxy Note 10.1 GT-N8010'),
(1327, 'Galaxy Note 10.1 WiFi', 'GT-N8013', 'Galaxy Note 10.1 WiFi GT-N8013'),
(1328, 'Galaxy Tab 2 7.0', 'GT-P3100', 'Galaxy Tab 2 7.0 GT-P3100'),
(1329, 'Galaxy Tab 2 7.0', 'GT-P3100B', 'Galaxy Tab 2 7.0 GT-P3100B'),
(1330, 'Galaxy Tab 2 7.0', 'GT-P3105', 'Galaxy Tab 2 7.0 GT-P3105'),
(1331, 'Galaxy Tab 2 7.0', 'GT-P3110', 'Galaxy Tab 2 7.0 GT-P3110'),
(1332, 'Galaxy Tab 2 7.0', 'GT-P3113', 'Galaxy Tab 2 7.0 GT-P3113'),
(1333, 'Galaxy Tab 2 10.1', 'GT-P5100', 'Galaxy Tab 2 10.1 GT-P5100'),
(1334, 'Galaxy Tab 2 10.1', 'GT-P5110', 'Galaxy Tab 2 10.1 GT-P5110'),
(1335, 'Galaxy Tab 2 10.1 WiFi', 'GT-P5113', 'Galaxy Tab 2 10.1 WiFi GT-P5113'),
(1336, 'Galaxy Pocket Plus', 'GT-S5301', 'Galaxy Pocket Plus GT-S5301'),
(1337, 'Galaxy Ace', 'GT-S5830C', 'Galaxy Ace GT-S5830C'),
(1338, 'Galaxy Music', 'GT-S6010', 'Galaxy Music GT-S6010'),
(1339, 'Galaxy Music Duos', 'GT-S6012', 'Galaxy Music Duos GT-S6012'),
(1340, 'Galaxy Ace II x', 'GT-S7560M', 'Galaxy Ace II x GT-S7560M'),
(1341, 'Galaxy S Duos', 'GT-S7562', 'Galaxy S Duos GT-S7562'),
(1342, 'Galaxy S Duos', 'GT-S7562L', 'Galaxy S Duos GT-S7562L'),
(1343, 'Galaxy Nexus', 'Galaxy Nexus', 'Galaxy Nexus'),
(1344, 'Droid DNA', 'HTC6435LVW 4G', 'Droid DNA HTC6435LVW 4G'),
(1345, 'Droid DNA', 'HTC6435LVW', 'Droid DNA HTC6435LVW'),
(1346, 'EVO V 4G', 'EVO V 4G', 'EVO V 4G'),
(1347, 'Desire C', '1000C', 'Desire C 1000C'),
(1348, 'Desire V', 'T328w', 'Desire V T328w'),
(1349, 'Desire VC', 'T328d', 'Desire VC T328d'),
(1350, 'Desire X', 'T328E', 'Desire X T328E'),
(1351, 'One X', 'PJ83100', 'One X PJ83100'),
(1352, 'One V', 'One V', 'One V'),
(1353, 'J', '321e', 'J 321e'),
(1354, 'One S', 'PJ401', 'One S PJ401'),
(1355, 'One SV', 'One SV', 'One SV'),
(1356, 'One XL', 'PJ83100', 'One XL PJ83100'),
(1357, 'One X+', 'PM63100', 'One X+ PM63100'),
(1358, 'One X', 'S720e', 'One X S720e'),
(1359, 'One XT', 'S720t', 'One XT S720t'),
(1360, 'One V', 'T120C', 'One V T120C'),
(1361, 'Desire VT', 'T328t', 'Desire VT T328t'),
(1362, 'One S', 'Ville', 'One S Ville'),
(1363, 'EVO 3D', 'X515C', 'EVO 3D X515C'),
(1364, 'One S', 'Z560e', 'One S Z560e'),
(1365, 'J Butterfly', 'HL21', 'J Butterfly HL21'),
(1366, 'Honor', 'C8860E', 'Honor C8860E'),
(1367, 'Honor +', 'C8950D', 'Honor + C8950D'),
(1368, 'Ascend Y201 Pro', 'U8666E-51', 'Ascend Y201 Pro U8666E-51'),
(1369, 'Honor +', 'U8950D', 'Honor + U8950D'),
(1370, 'Honor 2', 'U9510E', 'Honor 2 U9510E'),
(1371, 'Ascend D Quad', 'U9510', 'Ascend D Quad U9510'),
(1372, 'Vega Racer 2', 'IM-A830K', 'Vega Racer 2 IM-A830K'),
(1373, 'Vega Racer 2', 'IM-A830L', 'Vega Racer 2 IM-A830L'),
(1374, 'Vega Racer 2', 'IM-A830S', 'Vega Racer 2 IM-A830S'),
(1375, 'Vega S5', 'IM-A840S', 'Vega S5 IM-A840S'),
(1376, 'Vega R3', 'IM-A850K', 'Vega R3 IM-A850K'),
(1377, 'Vega R3', 'IM-A850L', 'Vega R3 IM-A850L'),
(1378, 'Vega R3', 'IM-A850S', 'Vega R3 IM-A850S'),
(1379, 'Iris 501', '501', 'Iris 501 501'),
(1380, 'Aquos Phone SL', 'IS15SH', 'Aquos Phone SL IS15SH'),
(1381, 'Aquos Phone CL', 'IS17SH', 'Aquos Phone CL IS17SH'),
(1382, 'J', 'ISW13HT', 'J ISW13HT'),
(1383, 'Aquos Phone Serie', 'ISW16SH', 'Aquos Phone Serie ISW16SH'),
(1384, 'Stealth i7520', 'i7520', 'Stealth i7520 i7520'),
(1385, 'IdeaTab A2107A-F', 'A2107A-F', 'IdeaTab A2107A-F A2107A-F'),
(1386, 'IdeaTab A2109A', 'A2109A', 'IdeaTab A2109A A2109A'),
(1387, 'K-Book', 'K-Book', 'K-Book'),
(1388, 'Kindle Fire HD 8.9 4G', 'KFJWA', 'Kindle Fire HD 8.9 4G KFJWA'),
(1389, 'A06', 'QT-A06', 'A06 QT-A06'),
(1390, 'Kurio 7', 'Kurio 7', 'Kurio 7'),
(1391, 'Optimus G', 'L-01E', 'Optimus G L-01E'),
(1392, 'L-02E', 'L-02E', 'L-02E'),
(1393, 'Optimus it', 'L-05D', 'Optimus it L-05D'),
(1394, 'Optimus L5', 'E610', 'Optimus L5 E610'),
(1395, 'Optimus L5', 'E610v', 'Optimus L5 E610v'),
(1396, 'Optimus L5', 'E612', 'Optimus L5 E612'),
(1397, 'Optimus L5', 'E612f', 'Optimus L5 E612f'),
(1398, 'Optimus L5', 'E612g', 'Optimus L5 E612g'),
(1399, 'Optimus L5 Dual', 'E615', 'Optimus L5 Dual E615'),
(1400, 'Optimus L5 Dual', 'E615f', 'Optimus L5 Dual E615f'),
(1401, 'Optimus G', 'E970', 'Optimus G E970'),
(1402, 'Optimus G', 'E971', 'Optimus G E971'),
(1403, 'Optimus G', 'E973', 'Optimus G E973'),
(1404, 'Optimus G', 'E975', 'Optimus G E975'),
(1405, 'Optimus LTE2', 'F160L', 'Optimus LTE2 F160L'),
(1406, 'Optimus LTE2', 'F160LV', 'Optimus LTE2 F160LV'),
(1407, 'Optimus LTE2', 'F160S', 'Optimus LTE2 F160S'),
(1408, 'for KT', 'F180K', 'for KT F180K'),
(1409, 'Optimus G', 'F180L', 'Optimus G F180L'),
(1410, 'Optimus G', 'F180S', 'Optimus G F180S'),
(1411, 'Optimus Vu II', 'F200K', 'Optimus Vu II F200K'),
(1412, 'Optimus Vu II', 'F200L', 'Optimus Vu II F200L'),
(1413, 'Optimus Vu II', 'F200S', 'Optimus Vu II F200S'),
(1414, 'Venice', 'LG730', 'Venice LG730'),
(1415, 'Mach LS860', 'LS860', 'Mach LS860 LS860'),
(1416, 'Optimus G', 'LS970', 'Optimus G LS970'),
(1417, 'Optimus Regard', 'LW770', 'Optimus Regard LW770'),
(1418, 'Motion 4G', 'MS770', 'Motion 4G MS770'),
(1419, 'Spirit 4G', 'MS870', 'Spirit 4G MS870'),
(1420, 'Optimus L7', 'P700', 'Optimus L7 P700'),
(1421, 'Optimus L7', 'P705', 'Optimus L7 P705'),
(1422, 'Optimus L7', 'P705g', 'Optimus L7 P705g'),
(1423, 'Optimus L7', 'P708G', 'Optimus L7 P708G'),
(1424, 'Optimus L9', 'P760', 'Optimus L9 P760'),
(1425, 'Optimus L9', 'P768', 'Optimus L9 P768'),
(1426, 'Optimus L9', 'P769', 'Optimus L9 P769'),
(1427, 'Escape', 'P870', 'Escape P870'),
(1428, 'Optimus 4X HD', 'P880', 'Optimus 4X HD P880'),
(1429, 'Optimus Vu', 'P895', 'Optimus Vu P895'),
(1430, 'Splendor', 'US730', 'Splendor US730'),
(1431, 'LIFETAB S9512', 'LIFETAB S9512', 'LIFETAB S9512'),
(1432, 'LIFETAB S9714', 'LIFETAB S9714', 'LIFETAB S9714'),
(1433, 'Xperia V', 'LT25i', 'Xperia V LT25i'),
(1434, 'Xperia SL', 'LT26ii', 'Xperia SL LT26ii'),
(1435, 'Xperia T', 'LT30a', 'Xperia T LT30a'),
(1436, 'Xperia TL', 'LT30a', 'Xperia TL LT30a'),
(1437, 'Xperia T', 'LT30p', 'Xperia T LT30p'),
(1438, 'Klu', 'LT7033', 'Klu LT7033'),
(1439, 'A789', 'A789', 'A789'),
(1440, 'M-270', 'M-270', 'M-270'),
(1441, 'Smartpad 711i', 'MP711i', 'Smartpad 711i MP711i'),
(1442, 'MX', 'M032', 'MX M032'),
(1443, 'M1001', 'M1001', 'M1001'),
(1444, 'M971B', 'M971B', 'M971B'),
(1445, 'Atrix HD', 'MB886', 'Atrix HD MB886'),
(1446, 'Kyros MID1042', 'MID1042', 'Kyros MID1042 MID1042'),
(1447, 'Kyros 7033', 'MID7033', 'Kyros 7033 MID7033'),
(1448, 'Kyros MID7034', 'MID7034', 'Kyros MID7034 MID7034'),
(1449, 'Kyros MID7036', 'MID7036', 'Kyros MID7036 MID7036'),
(1450, 'Kyros MID7042', 'MID7042', 'Kyros MID7042 MID7042'),
(1451, 'Kyros MID7048', 'MID7048', 'Kyros MID7048 MID7048'),
(1452, 'Kyros MID8042', 'MID8042', 'Kyros MID8042 MID8042'),
(1453, 'Kyros MID8048', 'MID8048', 'Kyros MID8048 MID8048'),
(1454, 'Kyros MID9742', 'MID9742', 'Kyros MID9742 MID9742'),
(1455, 'MIDC800PR001', 'MIDC800PR001', 'MIDC800PR001'),
(1456, 'Droid Razr HD', 'XT923', 'Droid Razr HD XT923'),
(1457, 'Droid Razr HD', 'XT295', 'Droid Razr HD XT295'),
(1458, 'Xperia neo L', 'MT25i', 'Xperia neo L MT25i'),
(1459, 'MediaPad 7 Lite', 'MediaPad 7 Lite', 'MediaPad 7 Lite'),
(1460, 'Superfone Canvas 2', 'A110', 'Superfone Canvas 2 A110'),
(1461, 'A68 Smarty', 'A68', 'A68 Smarty A68'),
(1462, 'A89 Ninja', 'A89', 'A89 Ninja A89'),
(1463, 'Funbook Alpha', 'P250', 'Funbook Alpha P250'),
(1464, 'Funbook Infinity P275', 'P275', 'Funbook Infinity P275 P275'),
(1465, 'Funbook Talk', 'P350', 'Funbook Talk P350'),
(1466, 'A101', 'A101', 'A101'),
(1467, 'N-07D', 'N-07D', 'N-07D'),
(1468, 'Iris N400', 'N400', 'Iris N400 N400'),
(1469, 'Warp', 'N861', 'Warp N861'),
(1470, 'Nabi 2', 'NABI2-NV7A', 'Nabi 2 NABI2-NV7A'),
(1471, 'legend', 'eagle75', 'legend eagle75'),
(1472, 'Wemove Legend 2', 'Wemove Legend 2', 'Wemove Legend 2'),
(1473, 'Wemove Legend XL', 'Wemove Legend XL', 'Wemove Legend XL'),
(1474, 'Wemove Polaris', 'Wemove Polaris', 'Wemove Polaris'),
(1475, 'wilco', 'eagle75', 'wilco eagle75'),
(1476, 'Nook HD Tablet', 'BNTV400', 'Nook HD Tablet BNTV400'),
(1477, 'Nook HD+ Tablet', 'BNTV600', 'Nook HD+ Tablet BNTV600'),
(1478, 'Novo 7 Paladin', 'Novo 7 Paladin', 'Novo 7 Paladin'),
(1479, 'Next7P12', 'Next7P12', 'Next7P12'),
(1480, 'Next7S', 'Next7S', 'Next7S'),
(1481, 'Next8P12', '8P12', 'Next8P12 8P12'),
(1482, 'Olipad 3', 'OP111', 'Olipad 3 OP111'),
(1483, 'Vi40 Elite', 'Vi40', 'Vi40 Elite Vi40'),
(1484, 'P771A', 'P771A', 'P771A'),
(1485, 'PAD-703', 'PAD-703', 'PAD-703'),
(1486, 'PMID4311', 'PMID4311', 'PMID4311'),
(1487, 'MultiPad PMP3770B', 'PMP3770B', 'MultiPad PMP3770B PMP3770B'),
(1488, 'MultiPad 5080 Pro', 'PMP5080CPRO', 'MultiPad 5080 Pro PMP5080CPRO'),
(1489, 'MultiPad 5197D ULTRA', 'PMP5197DULTRA', 'MultiPad 5197D ULTRA PMP5197DULTRA'),
(1490, '4.0 Multi-Touch 9.7', 'PNDPP4MT9G2', '4.0 Multi-Touch 9.7 PNDPP4MT9G2'),
(1491, 'Vandroid T2CI', 'T2CI', 'Vandroid T2CI T2CI'),
(1492, 'PadFone 2', 'A68', 'PadFone 2 A68'),
(1493, 'ASUS-PadFone', 'ASUS-PadFone', 'ASUS-PadFone'),
(1494, 'Q7033', 'Q7033', 'Q7033'),
(1495, 'S500', 'S500', 'S500'),
(1496, 'AndroTab S7', 'S7', 'AndroTab S7 S7'),
(1497, 'GT-B7810', 'GT-B7810', 'GT-B7810'),
(1498, 'Galaxy Express', 'SGH-I437', 'Galaxy Express SGH-I437'),
(1499, 'Galaxy Tab 2 10.1', 'SGH-I497', 'Galaxy Tab 2 10.1 SGH-I497'),
(1500, 'Galaxy Rugby Pro', 'SGH-I547', 'Galaxy Rugby Pro SGH-I547'),
(1501, 'Galaxy S3', 'SGH-I747', 'Galaxy S3 SGH-I747'),
(1502, 'Galaxy Tab 2 10.1', 'SGH-T779', 'Galaxy Tab 2 10.1 SGH-T779'),
(1503, 'Aquos 104SH', '104SH', 'Aquos 104SH 104SH'),
(1504, 'Pantone 5 107SH', 'SBM107SH', 'Pantone 5 107SH SBM107SH'),
(1505, 'Galaxy SIII LTE', 'SC-06D', 'Galaxy SIII LTE SC-06D'),
(1506, 'Galaxy Stellar 4G', 'SCH-I200', 'Galaxy Stellar 4G SCH-I200'),
(1507, 'Galaxy Stratosphere II', 'SCH-I415 4G', 'Galaxy Stratosphere II SCH-I415 4G'),
(1508, 'Galaxy Stratosphere II', 'SCH-I415', 'Galaxy Stratosphere II SCH-I415'),
(1509, 'Galaxy S3', 'SCH-I535 4G', 'Galaxy S3 SCH-I535 4G'),
(1510, 'Galaxy S3', 'SCH-I535', 'Galaxy S3 SCH-I535'),
(1511, 'Galaxy Tab 2 10.1', 'SCH-I915 4G', 'Galaxy Tab 2 10.1 SCH-I915 4G'),
(1512, 'Galaxy Tab 2 10.1', 'SCH-I915', 'Galaxy Tab 2 10.1 SCH-I915'),
(1513, 'Galaxy S3', 'SCH-I939', 'Galaxy S3 SCH-I939'),
(1514, 'Galaxy S3', 'SCH-L710 4G', 'Galaxy S3 SCH-L710 4G'),
(1515, 'Galaxy S3', 'SCH-L710', 'Galaxy S3 SCH-L710'),
(1516, 'Galaxy S3', 'SCH-R530M', 'Galaxy S3 SCH-R530M'),
(1517, 'Galaxy S3', 'SGH-I535', 'Galaxy S3 SGH-I535'),
(1518, 'Galaxy Rugby Pro', 'SGH-I547C', 'Galaxy Rugby Pro SGH-I547C'),
(1519, 'Galaxy Note', 'SGH-i717D', 'Galaxy Note SGH-i717D'),
(1520, 'Galaxy Note', 'SGH-i717R', 'Galaxy Note SGH-i717R'),
(1521, 'Galaxy S3', 'SGH-I747M', 'Galaxy S3 SGH-I747M'),
(1522, 'Galaxy SII HD LTE', 'SGH-I757M', 'Galaxy SII HD LTE SGH-I757M'),
(1523, 'Galaxy S Relay 4G', 'SGH-T699', 'Galaxy S Relay 4G SGH-T699'),
(1524, 'Galaxy Tab 10.1', 'SGH-T859', 'Galaxy Tab 10.1 SGH-T859'),
(1525, 'Galaxy S3', 'SGH-T999', 'Galaxy S3 SGH-T999'),
(1526, 'Xperia Tablet S', 'SGPT12', 'Xperia Tablet S SGPT12'),
(1527, 'Xperia Tablet S', 'SGPT13', 'Xperia Tablet S SGPT13'),
(1528, 'Aquos Phone ST', 'SH-07D', 'Aquos Phone ST SH-07D'),
(1529, 'Aquos Phone Zeta', 'SH-09D', 'Aquos Phone Zeta SH-09D'),
(1530, 'SH530U', 'SH530U', 'SH530U'),
(1531, 'Galaxy R', 'SHV-E170K', 'Galaxy R SHV-E170K'),
(1532, 'Galaxy R', 'SHV-E170S', 'Galaxy R SHV-E170S'),
(1533, 'Galaxy S3', 'SHV-E210K', 'Galaxy S3 SHV-E210K'),
(1534, 'Galaxy S3', 'SHV-E210L', 'Galaxy S3 SHV-E210L'),
(1535, 'Galaxy S3', 'SHV-E210S', 'Galaxy S3 SHV-E210S'),
(1536, 'Galaxy S3', 'SHW-M440S', 'Galaxy S3 SHW-M440S'),
(1537, 'Galaxy Note 10.1', 'SHW-M480K', 'Galaxy Note 10.1 SHW-M480K'),
(1538, 'Galaxy Note 10.1', 'SHW-M480S', 'Galaxy Note 10.1 SHW-M480S'),
(1539, 'Galaxy Note 10.1', 'SHW-M480W', 'Galaxy Note 10.1 SHW-M480W'),
(1540, 'Xperia GX', 'SO-04D', 'Xperia GX SO-04D'),
(1541, 'Xperia VL', 'SOL21', 'Xperia VL SOL21'),
(1542, 'Galaxy SII Epic 4G Touch', 'SPH-D710BST', 'Galaxy SII Epic 4G Touch SPH-D710BST'),
(1543, 'Gogh', 'SPH-L300', 'Gogh SPH-L300'),
(1544, 'Galaxy S3', 'SPH-L710', 'Galaxy S3 SPH-L710'),
(1545, 'Galaxy Rush', 'SPH-M830', 'Galaxy Rush SPH-M830'),
(1546, 'Galaxy Tab 2 10.1', 'SPH-P500', 'Galaxy Tab 2 10.1 SPH-P500'),
(1547, 'Xperia Tipo', 'ST21a', 'Xperia Tipo ST21a'),
(1548, 'Xperia Tipo', 'ST21i', 'Xperia Tipo ST21i'),
(1549, 'Xperia Tipo Dual', 'ST21i2', 'Xperia Tipo Dual ST21i2'),
(1550, 'Xperia miro', 'ST23a', 'Xperia miro ST23a'),
(1551, 'Xperia miro', 'ST23i', 'Xperia miro ST23i'),
(1552, 'Xperia J', 'ST26a', 'Xperia J ST26a'),
(1553, 'Xperia J', 'ST26i', 'Xperia J ST26i'),
(1554, 'PD10', 'PD10', 'PD10'),
(1555, 'Scroll Extreme', 'Scroll Extreme', 'Scroll Extreme'),
(1556, 'Sensation 4G', 'Z710', 'Sensation 4G Z710'),
(1557, 'Smart Pad 750 3G', 'Smart Pad 750 3G', 'Smart Pad 750 3G'),
(1558, 'SmartTab II 7', 'SmartTab II 7', 'SmartTab II 7'),
(1559, 'Tab', 'Tab', 'Tab'),
(1560, 'Xperia Acro S', 'LT26w', 'Xperia Acro S LT26w'),
(1561, 'Xperia Ion', 'LT28h', 'Xperia Ion LT28h'),
(1562, 'Xperia GX', 'LT29i', 'Xperia GX LT29i'),
(1563, 'Xperia Tipo', 'ST21iv', 'Xperia Tipo ST21iv'),
(1564, 'Xperia V', 'LT25c', 'Xperia V LT25c'),
(1565, 'Xperia V', 'LT25h', 'Xperia V LT25h'),
(1566, 'Xperia SX', 'SO-05D', 'Xperia SX SO-05D'),
(1567, 'Xperia Tipo Dual', 'ST21a2', 'Xperia Tipo Dual ST21a2'),
(1568, 'T20', 'T20', 'T20'),
(1569, 'PLAYTABPRO 4R', 'PLAYTABPRO 4R', 'PLAYTABPRO 4R'),
(1570, 'MaxiPRO5', 'MaxiPRO5', 'MaxiPRO5'),
(1571, 'Maxi Plus 5', 'T21', 'Maxi Plus 5 T21'),
(1572, 'Eee Pad Transformer TF101', 'Eee Pad Transformer TF101G', 'Eee Pad Transformer TF101 Eee Pad Transformer TF101G'),
(1573, 'Ice Cream Sandwich', 'Ice Cream Sandwich', 'Ice Cream Sandwich'),
(1574, 'ME U1', 'U1', 'ME U1 U1'),
(1575, 'Shine', 'U8836D', 'Shine U8836D'),
(1576, 'Ascend P1', 'U9200', 'Ascend P1 U9200'),
(1577, 'Urbano Progresso', 'ISW12K', 'Urbano Progresso ISW12K'),
(1578, 'Nova 4.0', 'V8000', 'Nova 4.0 V8000'),
(1579, '7 inch Tablet', '7 inch Tablet', '7 inch Tablet'),
(1580, 'Spectrum 2', 'VS930', 'Spectrum 2 VS930'),
(1581, 'Intuition', 'VS950 4G', 'Intuition VS950 4G'),
(1582, 'TouchPad 7', 'TouchPad 7', 'TouchPad 7'),
(1583, 'SmartTab II 10', 'SmartTab II 10', 'SmartTab II 10'),
(1584, 'W732', 'W732', 'W732'),
(1585, 'One X', 'X325a', 'One X X325a'),
(1586, 'Motoluxe XT685', 'XT685', 'Motoluxe XT685 XT685'),
(1587, 'Electrify 2', 'XT881', 'Electrify 2 XT881'),
(1588, 'RAZR V XT885', 'XT885', 'RAZR V XT885 XT885'),
(1589, 'XT890', 'XT890', 'XT890'),
(1590, 'Photon Q 4G LTE', 'XT897', 'Photon Q 4G LTE XT897'),
(1591, 'RAZR M 4G LTE', 'XT905', 'RAZR M 4G LTE XT905'),
(1592, 'DROID RAZR M 4G LTE', 'XT907', 'DROID RAZR M 4G LTE XT907'),
(1593, 'Droid Razr', 'XT928', 'Droid Razr XT928'),
(1594, 'Galaxy Player 5.8', 'YP-GP1', 'Galaxy Player 5.8 YP-GP1'),
(1595, 'One S', 'Z520m', 'One S Z520m'),
(1596, 'Blade III', 'Blade III', 'Blade III'),
(1597, 'Avid 4G', 'N9120', 'Avid 4G N9120'),
(1598, 'T81', 'T81', 'T81'),
(1599, 'Chagall', 'Chagall', 'Chagall'),
(1600, 'A9660 Mini', 'S50', 'A9660 Mini S50'),
(1601, 'SurfTab Breeze 7.0', 'ST701041', 'SurfTab Breeze 7.0 ST701041'),
(1602, 'FJ Vortex', 'VC882', 'FJ Vortex VC882'),
(1603, 'IQ 5', 'IQ 5', 'IQ 5'),
(1604, 'Novo7 Legend', 'Novo7 Legend', 'Novo7 Legend'),
(1605, 'Novo7 Aurora', 'Novo7 Aurora', 'Novo7 Aurora'),
(1606, 'One Touch T10', 'OT-T10', 'One Touch T10 OT-T10'),
(1607, '9300+', '9300+', '9300+'),
(1608, 'Iconia Tab A110', 'A110', 'Iconia Tab A110 A110'),
(1609, 'Excellent 7-II', 'ATP7717', 'Excellent 7-II ATP7717'),
(1610, 'Iconia B1-A71', 'B1-A71', 'Iconia B1-A71 B1-A71'),
(1611, 'Xperia ZL', 'C6502', 'Xperia ZL C6502'),
(1612, 'Xperia ZL', 'C6503', 'Xperia ZL C6503'),
(1613, 'Xperia ZL', 'C6506', 'Xperia ZL C6506'),
(1614, 'Xperia Z', 'C6602', 'Xperia Z C6602'),
(1615, 'Xperia Z', 'C6603', 'Xperia Z C6603'),
(1616, 'DIT9720', 'DIT9720', 'DIT9720'),
(1617, 'Galaxy S III Mini', 'GT-I8190L', 'Galaxy S III Mini GT-I8190L'),
(1618, 'Galaxy S III Mini', 'GT-I8190N', 'Galaxy S III Mini GT-I8190N'),
(1619, 'Galaxy Express', 'GT-I8730', 'Galaxy Express GT-I8730'),
(1620, 'Galaxy S Advance', 'GT-I9070P', 'Galaxy S Advance GT-I9070P'),
(1621, 'Galaxy Grand Duos', 'GT-I9082', 'Galaxy Grand Duos GT-I9082'),
(1622, 'Galaxy Grand Duos', 'GT-I9082L', 'Galaxy Grand Duos GT-I9082L'),
(1623, 'Galaxy SII Plus', 'GT-I9105P', 'Galaxy SII Plus GT-I9105P'),
(1624, 'Galaxy S3 LTE International', 'GT-I9305N', 'Galaxy S3 LTE International GT-I9305N'),
(1625, 'Galaxy S3 LTE', 'GT-I9305T', 'Galaxy S3 LTE GT-I9305T'),
(1626, 'Galaxy Note 8.0', 'GT-N5100', 'Galaxy Note 8.0 GT-N5100'),
(1627, 'Galaxy Note 8.0 WiFi', 'GT-N5110', 'Galaxy Note 8.0 WiFi GT-N5110'),
(1628, 'Galaxy Note II', 'GT-N7100', 'Galaxy Note II GT-N7100'),
(1629, 'Galaxy Note II', 'GT-N7102', 'Galaxy Note II GT-N7102'),
(1630, 'Galaxy Note II', 'GT-N7105', 'Galaxy Note II GT-N7105'),
(1631, 'Galaxy Note 10.1', 'GT-N8013', 'Galaxy Note 10.1 GT-N8013'),
(1632, 'Galaxy Note 10.1 LTE', 'GT-N8020', 'Galaxy Note 10.1 LTE GT-N8020'),
(1633, 'Galaxy Tab 2 10.1', 'GT-P5113', 'Galaxy Tab 2 10.1 GT-P5113'),
(1634, 'Deluxe', 'DLX', 'Deluxe DLX'),
(1635, 'One', 'M7', 'One M7'),
(1636, 'One', 'PN07120', 'One PN07120'),
(1637, 'J Butterfly', 'HTL21', 'J Butterfly HTL21'),
(1638, 'Optimus G', 'E975K', 'Optimus G E975K'),
(1639, 'E980', 'E980', 'E980'),
(1640, 'Optimus G', 'F180K', 'Optimus G F180K'),
(1641, 'Optimus G Pro', 'F240K', 'Optimus G Pro F240K'),
(1642, 'Optimus G Pro', 'F240L', 'Optimus G Pro F240L'),
(1643, 'Optimus G Pro', 'F240S', 'Optimus G Pro F240S'),
(1644, 'M1', 'M1', 'M1'),
(1645, 'MI-2', 'MI-2', 'MI-2'),
(1646, 'MaxiIQ', 'MaxiIQ', 'MaxiIQ'),
(1647, 'Nexus 7', 'Nexus 7', 'Nexus 7'),
(1648, 'M3 3G', 'M3 3G', 'M3 3G'),
(1649, 'Padfone Infinity', 'Padfone Infinity', 'Padfone Infinity'),
(1650, 'Galaxy Note II', 'SGH-I317', 'Galaxy Note II SGH-I317'),
(1651, 'Galaxy Note II', 'SC-02E', 'Galaxy Note II SC-02E'),
(1652, 'for Verizon', 'SCH-I605 4G', 'for Verizon SCH-I605 4G'),
(1653, 'Galaxy Note II', 'SCH-I605', 'Galaxy Note II SCH-I605'),
(1654, 'Galaxy Note 10.1 LTE', 'SCH-I925', 'Galaxy Note 10.1 LTE SCH-I925'),
(1655, 'Galaxy Note II', 'SCH-N719', 'Galaxy Note II SCH-N719'),
(1656, 'Galaxy Note II', 'SCH-R950', 'Galaxy Note II SCH-R950'),
(1657, 'Galaxy Note II 4G LTE', 'SGH-I317', 'Galaxy Note II 4G LTE SGH-I317'),
(1658, 'Galaxy Note II', 'SGH-I317M', 'Galaxy Note II SGH-I317M'),
(1659, 'Galaxy S3', 'SGH-I535 4G', 'Galaxy S3 SGH-I535 4G'),
(1660, 'Galaxy Note II', 'SGH-T889', 'Galaxy Note II SGH-T889'),
(1661, 'Galaxy S3', 'SGH-T999V', 'Galaxy S3 SGH-T999V'),
(1662, 'Xperia Tablet Z LTE', 'SGP321', 'Xperia Tablet Z LTE SGP321'),
(1663, 'Galaxy Note 10.1', 'SHV-E230K', 'Galaxy Note 10.1 SHV-E230K'),
(1664, 'Galaxy Note 10.1', 'SHV-E230L', 'Galaxy Note 10.1 SHV-E230L'),
(1665, 'Galaxy Note 10.1', 'SHV-E230S', 'Galaxy Note 10.1 SHV-E230S'),
(1666, 'Galaxy Note II', 'SHV-E250K', 'Galaxy Note II SHV-E250K'),
(1667, 'Galaxy Note II LTE', 'SHV-E250L', 'Galaxy Note II LTE SHV-E250L'),
(1668, 'Galaxy Note II', 'SHV-E250S', 'Galaxy Note II SHV-E250S'),
(1669, 'Galaxy Note II', 'SPH-L900', 'Galaxy Note II SPH-L900'),
(1670, 'Scroll Plus', 'Scroll Plus', 'Scroll Plus'),
(1671, 'Xperia E', 'C1505', 'Xperia E C1505'),
(1672, 'Xenta TAB10-201', 'Xenta TAB10-201', 'Xenta TAB10-201'),
(1673, 'X10', 'X10', 'X10'),
(1674, 'X720D', 'X720D', 'X720D'),
(1675, 'Nexus 10', 'Nexus 10', 'Nexus 10'),
(1676, 'Galaxy S IV', 'GT-I9500', 'Galaxy S IV GT-I9500'),
(1677, 'Nexus 4', 'Nexus 4', 'Nexus 4'),
(1678, 'Mini 3iX', '3iX', 'Mini 3iX 3iX'),
(1679, 'A288t', 'A288t', 'A288t'),
(1680, 'RAZR i', 'MT788', 'RAZR i MT788'),
(1681, 'HS-E90', 'HS-E90', 'HS-E90'),
(1682, 'HS-EG968', 'HS-EG968', 'HS-EG968'),
(1683, 'GT-i5800L', 'GT-i5800L', 'GT-i5800L'),
(1684, 'Android', 'Android', 'Android'),
(1685, 'CT 1001', 'CT 1001', 'CT 1001'),
(1686, 'Eve', 'GW620', 'Eve GW620'),
(1687, 'Behold2', 'SGH T939', 'Behold2 SGH T939'),
(1688, 'Desire', 'Desire', 'Desire'),
(1689, 'Android 1.5', 'Android 1.5', 'Android 1.5'),
(1690, 'Morrison', 'Morrison', 'Morrison'),
(1691, 'Motus', 'Motus', 'Motus'),
(1692, 'P1HR', 'P1HR', 'P1HR'),
(1693, 'Zeppelin', 'Zeppelin', 'Zeppelin'),
(1694, 'Bahamas', 'Bahamas', 'Bahamas'),
(1695, 'Sholes', 'Sholes', 'Sholes'),
(1696, 'Sholes Tablet', 'Sholes Tablet', 'Sholes Tablet'),
(1697, 'Touch eReader', 'Touch', 'Touch eReader Touch'),
(1698, 'DCT E366', 'DCT E366', 'DCT E366'),
(1699, 'Photosmart eStation', 'Photosmart eStation', 'Photosmart eStation'),
(1700, 'S7-103', 'S7-103', 'S7-103'),
(1701, 'Aloha', 'Aloha', 'Aloha'),
(1702, 'cdma_shadow', 'cdma_shadow', 'cdma_shadow'),
(1703, 'Verizon Droid Incredible', 'Incredible', 'Verizon Droid Incredible Incredible'),
(1704, 'Passion', 'Passion', 'Passion'),
(1705, 'Supersonic', 'Supersonic', 'Supersonic'),
(1706, 'A7 Internet Tablet', 'A7', 'A7 Internet Tablet A7'),
(1707, 'N880S', 'N880S', 'N880S'),
(1708, 'EVO 3D', 'X515d', 'EVO 3D X515d'),
(1709, 'Optimus Logic', 'L35G', 'Optimus Logic L35G'),
(1710, 'Ilium S50', 'S50', 'Ilium S50 S50'),
(1711, 'Music Phone P70', 'P70', 'Music Phone P70 P70'),
(1712, 'Cruz T408', 'Cruz T408', 'Cruz T408'),
(1713, 'Cruz T410', 'Cruz T410', 'Cruz T410'),
(1714, 'Smart Chat', 'P752D', 'Smart Chat P752D'),
(1715, 'SuperNova', 'SuperNova', 'SuperNova'),
(1716, 'Movistar One', 'U V856', 'Movistar One U V856'),
(1717, 'Smart Tab 7', 'V71A', 'Smart Tab 7 V71A'),
(1718, 'Superfone Canvas', 'A100', 'Superfone Canvas A100'),
(1719, 'Ascend C8812', 'C8812', 'Ascend C8812 C8812'),
(1720, '5910', '5910', '5910'),
(1721, 'T300', 'T300', 'T300'),
(1722, 'Planet', 'Planet', 'Planet'),
(1723, 'Star', 'Star', 'Star'),
(1724, 'Nova', 'Nova', 'Nova'),
(1725, 'TB600KT', 'TB600KT', 'TB600KT'),
(1726, 'Mobi for Android', 'Mobi for Android', 'Mobi for Android'),
(1727, 'Tablet on Android', 'Tablet on Android', 'Tablet on Android'),
(1728, 'Mini 5', 'Mini 5', 'Mini 5'),
(1729, 'Mini 5.1', 'Mini 5.1', 'Mini 5.1'),
(1730, 'Mini 6', 'Mini 6', 'Mini 6'),
(1731, 'Mini 7', 'Mini 7', 'Mini 7'),
(1732, 'GT-S5368', 'GT-S5368', 'GT-S5368'),
(1733, 'TU812', 'TU812', 'TU812'),
(1734, 'TU880', 'TU880', 'TU880'),
(1735, 'Iris Browser', 'Iris Browser', 'Iris Browser'),
(1736, 'iPad', 'iPad', 'iPad'),
(1737, 'iPhone', 'iPhone', 'iPhone'),
(1738, 'iPod Touch', 'iPod Touch', 'iPod Touch'),
(1739, 'Windows Phone 7', 'Windows Phone 7', 'Windows Phone 7'),
(1740, 'Windows Phone 7.5', 'Windows Phone 7.5', 'Windows Phone 7.5'),
(1741, 'Sony Ericsson Aspen', 'M1i', 'Sony Ericsson Aspen M1i'),
(1742, 'HD Mini', 'HD Mini', 'HD Mini'),
(1743, 'Touch Diamond 2', 'Touch Diamond 2', 'Touch Diamond 2'),
(1744, 'T3320', 'Touch2', 'T3320 Touch2'),
(1745, 'Touch2', 'Touch2', 'Touch2'),
(1746, 'Touch Diamond 2', 'T5360', 'Touch Diamond 2 T5360'),
(1747, 'Louvre', 'GT-B7610', 'Louvre GT-B7610'),
(1748, 'TG01', 'TG01', 'TG01'),
(1749, 'Galaxy6', 'Galaxy6', 'Galaxy6'),
(1750, 'HD7', 'T9292', 'HD7 T9292'),
(1751, '7 Trophy', 'Spark', '7 Trophy Spark'),
(1752, 'Optimus 7', 'E900', 'Optimus 7 E900'),
(1753, 'GW910', 'GW910', 'GW910'),
(1754, 'Samsung Taylor', 'SGH-i707', 'Samsung Taylor SGH-i707'),
(1755, 'Omnia 7', 'SGH-i917', 'Omnia 7 SGH-i917'),
(1756, 'Venue Pro', 'Venue Pro', 'Venue Pro'),
(1757, '7 Mozart', 'T8698', '7 Mozart T8698'),
(1758, '7 pro', 'T7576', '7 pro T7576'),
(1759, 'Arrive', 'T7575', 'Arrive T7575'),
(1760, 'Surround', 'T8788', 'Surround T8788'),
(1761, 'HD7', 'T9295', 'HD7 T9295'),
(1762, 'HD7', 'T9296', 'HD7 T9296'),
(1763, 'Quantum', 'C900', 'Quantum C900'),
(1764, 'Quantum', 'C900B', 'Quantum C900B'),
(1765, 'Quantum', 'C900k', 'Quantum C900k'),
(1766, 'Optimus 7', 'E900h', 'Optimus 7 E900h'),
(1767, 'XDeviceEmulator', 'XDeviceEmulator', 'XDeviceEmulator'),
(1768, 'Lumia 610', 'Lumia 610', 'Lumia 610'),
(1769, 'Lumia 800', 'Lumia 800', 'Lumia 800'),
(1770, 'Omnia 7', 'GT-i8700', 'Omnia 7 GT-i8700'),
(1771, 'Focus', 'SGH-i917', 'Focus SGH-i917'),
(1772, 'Tania', 'V965W', 'Tania V965W'),
(1773, 'Allegro', 'Acer M310', 'Allegro Acer M310'),
(1774, 'IS12T', 'IS12T', 'IS12T'),
(1775, '7 pro', 'MWP6885', '7 pro MWP6885'),
(1776, '7 Trophy', 'Mazaa', '7 Trophy Mazaa'),
(1777, 'Titan', 'PI39100', 'Titan PI39100'),
(1778, 'Titan II', 'PI86100', 'Titan II PI86100'),
(1779, 'Radar 4G', 'Radar 4G', 'Radar 4G'),
(1780, 'Radar', 'Radar', 'Radar'),
(1781, 'Schubert', 'Schubert', 'Schubert'),
(1782, 'Titan', 'X310e', 'Titan X310e'),
(1783, 'Arrive', 'PC93100', 'Arrive PC93100'),
(1784, 'Ultimate', 'Ultimate', 'Ultimate'),
(1785, 'LG-E906 Jill Sander', 'E906', 'LG-E906 Jill Sander E906'),
(1786, 'Emulator WP OS 7.5', 'Emulator WP OS 7.5', 'Emulator WP OS 7.5'),
(1787, 'Lumia 505', 'Lumia 505', 'Lumia 505'),
(1788, 'Lumia 510', 'Lumia 510', 'Lumia 510'),
(1789, 'Lumia 710', 'Lumia 710', 'Lumia 710'),
(1790, 'for Vodafone', 'Lumia 800', 'for Vodafone Lumia 800'),
(1791, 'Lumia 900', 'Lumia 900', 'Lumia 900'),
(1792, 'Nokia 800', '800', 'Nokia 800 800'),
(1793, 'Nokia 800c', '800c', 'Nokia 800c 800c'),
(1794, 'Omnia W', 'GT-i8350', 'Omnia W GT-i8350'),
(1795, 'Omnia M', 'GT-S7530', 'Omnia M GT-S7530'),
(1796, 'Omnia M', 'GT-S7530E', 'Omnia M GT-S7530E'),
(1797, 'Focus S', 'SGH-i937', 'Focus S SGH-i937'),
(1798, 'Focus 2', 'SGH-i667', 'Focus 2 SGH-i667'),
(1799, 'Focus Flash', 'SGH-i677', 'Focus Flash SGH-i677'),
(1800, 'Focus', 'SGH-i917R', 'Focus SGH-i917R'),
(1801, 'Xbox 360', 'Xbox 360', 'Xbox 360'),
(1802, 'Internet 7', 'V965W', 'Internet 7 V965W'),
(1803, '8S', 'A620b', '8S A620b'),
(1804, 'Windows Phone 8X', 'Windows Phone 8X', 'Windows Phone 8X'),
(1805, 'Windows Phone 8X', 'C620d', 'Windows Phone 8X C620d'),
(1806, 'Windows Phone 8X', 'Windows Phone 8X', 'Windows Phone 8X Windows Phone 8X'),
(1807, 'Windows Phone 8X', 'C625a', 'Windows Phone 8X C625a'),
(1808, 'C625b', 'C625b', 'C625b'),
(1809, 'Windows Phone 8X', 'HTC6990LVW 4G', 'Windows Phone 8X HTC6990LVW 4G'),
(1810, 'Windows Phone 8X', 'HTC6990LVW', 'Windows Phone 8X HTC6990LVW'),
(1811, 'Windows Phone 8X', 'PM23300', 'Windows Phone 8X PM23300'),
(1812, '8S', '8S', '8S'),
(1813, 'for Orange', 'Windows Phone 8X', 'for Orange Windows Phone 8X'),
(1814, 'Lumia 620', 'Lumia 620', 'Lumia 620'),
(1815, 'Lumia 810', 'Lumia 810', 'Lumia 810'),
(1816, 'Lumia 820', 'Lumia 820', 'Lumia 820'),
(1817, 'Lumia 822', 'Lumia 822', 'Lumia 822'),
(1818, 'Lumia 920', 'Lumia 920', 'Lumia 920'),
(1819, 'Lumia 920T', 'Lumia 920T', 'Lumia 920T'),
(1820, 'Fluid', 'Fluid', 'Fluid'),
(1821, 'Lumia 920', 'RM-820', 'Lumia 920 RM-820'),
(1822, 'ATIV S', 'GT-I8750', 'ATIV S GT-I8750'),
(1823, 'ATIV S', 'SCH-I930', 'ATIV S SCH-I930'),
(1824, 'Acer E100', 'Acer E100', 'Acer E100'),
(1825, 'beTouch E101', 'Acer E101', 'beTouch E101 Acer E101'),
(1826, 'newTouch S200', 'Acer S200', 'newTouch S200 Acer S200'),
(1827, 'Asha 303', 'Asha 303', 'Asha 303 Asha 303'),
(1828, '2700 classic', '2700 classic', '2700 classic'),
(1829, '2730 classic', '2730 classic', '2730 classic'),
(1830, 'XpressMusic', '5130', 'XpressMusic 5130'),
(1831, 'XpressMusic', '5220', 'XpressMusic 5220'),
(1832, 'XpressMusic', '5310 XpressMusic', 'XpressMusic 5310 XpressMusic'),
(1833, '5330 Mobile TV Edition', '5330 Mobile TV Edition', '5330 Mobile TV Edition'),
(1834, '6300', '6300', '6300'),
(1835, 'Classic', '6303', 'Classic 6303'),
(1836, 'Slide', '6500s', 'Slide 6500s'),
(1837, '6700 classic', '6700 classic', '6700 classic'),
(1838, '7230', '7230', '7230'),
(1839, 'C2-00', 'C2-00', 'C2-00'),
(1840, 'X2-00', 'X2-00', 'X2-00'),
(1841, 'X3-00', 'X3-00', 'X3-00'),
(1842, '110', '110', '110'),
(1843, '111', '111', '111'),
(1844, '112', '112', '112'),
(1845, '114', '114', '114'),
(1846, 'Nokia Asha 200', 'Nokia Asha 200', 'Nokia Asha 200 Nokia Asha 200'),
(1847, 'Nokia Asha 200', 'Asha 2000', 'Nokia Asha 200 Asha 2000'),
(1848, 'Asha 201', 'Nokia Asha 201', 'Asha 201 Nokia Asha 201'),
(1849, 'Asha 201', '2010', 'Asha 201 2010'),
(1850, 'Asha 202', 'Asha 202', 'Asha 202 Asha 202'),
(1851, 'Asha 202', '2020', 'Asha 202 2020'),
(1852, 'Asha 203', 'Asha 203', 'Asha 203 Asha 203'),
(1853, 'Asha 203', '2030', 'Asha 203 2030'),
(1854, 'Asha 205', '205', 'Asha 205 205'),
(1855, '206', '206', '206'),
(1856, '2220 slide', '2220 slide', '2220 slide'),
(1857, '2330 classic', '2330 classic', '2330 classic'),
(1858, '2690', '2690', '2690'),
(1859, 'Navigation Edition', '2710', 'Navigation Edition 2710'),
(1860, 'Nokia Asha 300', 'Asha 300', 'Nokia Asha 300 Asha 300'),
(1861, 'Nokia Asha 300', '3000', 'Nokia Asha 300 3000'),
(1862, 'Asha 301', '301.1', 'Asha 301 301.1'),
(1863, 'Asha 301', '301', 'Asha 301 301'),
(1864, 'Asha 302', 'Asha 302', 'Asha 302 Asha 302'),
(1865, 'Asha 303', '3030', 'Asha 303 3030'),
(1866, '305', '305', '305'),
(1867, 'Asha 3050', '3050', 'Asha 3050 3050'),
(1868, '306', '306', '306'),
(1869, 'Asha 308', '308', 'Asha 308 308'),
(1870, 'Asha 309', '309', 'Asha 309 309'),
(1871, 'Asha 311', '311', 'Asha 311 311'),
(1872, 'classic', '3110 classic', 'classic 3110 classic'),
(1873, 'Classic', '3120 classic', 'Classic 3120 classic'),
(1874, '3208 classic', '3208 classic', '3208 classic'),
(1875, 'Classic', '3500 classic', 'Classic 3500 classic'),
(1876, '3600', '3600', '3600'),
(1877, 'Slide', '3600 slide', 'Slide 3600 slide'),
(1878, 'Fold', '3710', 'Fold 3710'),
(1879, 'Fold', '3711', 'Fold 3711'),
(1880, '3720 classic', '3720 classic', '3720 classic'),
(1881, '5000', '5000', '5000'),
(1882, '5132 XpressMusic', 'N5132', '5132 XpressMusic N5132'),
(1883, '5200', '5200', '5200'),
(1884, '5300', '5300', '5300'),
(1885, 'XpressMusic', '5610', 'XpressMusic 5610'),
(1886, '6208 classic', '6208 classic', '6208 classic'),
(1887, '6280', '6280', '6280'),
(1888, '6300i', '6300i', '6300i'),
(1889, 'Classic', '6303i classic', 'Classic 6303i classic'),
(1890, '6350', '6350', '6350'),
(1891, '6500 classic', '6500 classic', '6500 classic'),
(1892, 'Fold', '6600 fold', 'Fold 6600 fold'),
(1893, '6600i slide', '6600i slide', '6600i slide'),
(1894, 'Slide', '6600 slide', 'Slide 6600 slide'),
(1895, 'Supernova', '7100 Supernova', 'Supernova 7100 Supernova'),
(1896, 'Supernova', '7210', 'Supernova 7210'),
(1897, 'Supernova', '7310', 'Supernova 7310'),
(1898, 'Supernova', '7510', 'Supernova 7510'),
(1899, 'Supernova', '7610 Supernova', 'Supernova 7610 Supernova'),
(1900, 'Supernova', '7610s', 'Supernova 7610s'),
(1901, 'C1-01', 'C1-01', 'C1-01'),
(1902, 'C1-02', 'C1-02', 'C1-02'),
(1903, 'C2-01', 'C2-01', 'C2-01'),
(1904, 'C2-02', 'C2-02', 'C2-02'),
(1905, 'C2-03', 'C2-03', 'C2-03'),
(1906, 'C2-05', 'C2-05', 'C2-05'),
(1907, 'C2-06', 'C2-06', 'C2-06'),
(1908, 'C2-07', 'C2-07', 'C2-07'),
(1909, 'C2-08', 'C2-08', 'C2-08'),
(1910, 'C3-00', 'C3-00', 'C3-00'),
(1911, 'C3-01 Gold Edition', 'C3-01', 'C3-01 Gold Edition C3-01'),
(1912, 'C3-01', 'C3-01', 'C3-01'),
(1913, 'C3-03', 'C3-03', 'C3-03'),
(1914, 'X2-01', 'X2-01', 'X2-01'),
(1915, 'X2-02', 'X2-02', 'X2-02'),
(1916, 'Nokia X2-03', 'Nokia X2-03', 'Nokia X2-03'),
(1917, 'X2-05', 'X2-05', 'X2-05'),
(1918, 'X3-02', 'X3-02', 'X3-02'),
(1919, '5233', '5233', '5233'),
(1920, '8310', '8310', '8310'),
(1921, '6600', '6600', '6600'),
(1922, '6630', '6630', '6630'),
(1923, '6638', '6638', '6638'),
(1924, 'E61', 'E61', 'E61'),
(1925, '9300', '9300', '9300'),
(1926, '9300i', '9300i', '9300i'),
(1927, '9500', '9500', '9500'),
(1928, '7700', '7700', '7700'),
(1929, '7710', '7710', '7710'),
(1930, '3230', '3230', '3230'),
(1931, '3250', '3250', '3250'),
(1932, '3310i', '3310i', '3310i'),
(1933, '6260', '6260', '6260'),
(1934, '6670', '6670', '6670'),
(1935, '6680', '6680', '6680'),
(1936, '6681', '6681', '6681'),
(1937, '6682', '6682', '6682'),
(1938, 'E60', 'E60', 'E60'),
(1939, 'N70', 'N70', 'N70'),
(1940, 'N80', 'N80', 'N80'),
(1941, 'N90', 'N90', 'N90'),
(1942, 'N91', 'N91', 'N91'),
(1943, 'N93', 'N93', 'N93'),
(1944, '6020i', '6020i', '6020i'),
(1945, '3650', '3650', '3650'),
(1946, '7610', '7610', '7610'),
(1947, '7650', '7650', '7650'),
(1948, 'N95 8GB', 'N95 8GB', 'N95 8GB'),
(1949, 'Slide', '6260 slide', 'Slide 6260 slide'),
(1950, 'Supernova', '7510a-b', 'Supernova 7510a-b'),
(1951, 'N9', 'N9', 'N9'),
(1952, 'N950', 'N950', 'N950'),
(1953, 'N73', 'N73', 'N73'),
(1954, 'Nuron', '5230', 'Nuron 5230'),
(1955, 'XpressMusic', '5800i', 'XpressMusic 5800i'),
(1956, 'C5', 'C5-03', 'C5 C5-03'),
(1957, 'C5-05', 'C5-05', 'C5-05'),
(1958, 'N8', 'N8-00', 'N8 N8-00'),
(1959, '500', '500', '500'),
(1960, '700', '700', '700'),
(1961, 'C6-01', 'C6-01', 'C6-01'),
(1962, 'Astound', 'C7-00', 'Astound C7-00'),
(1963, 'Oro', 'C7-00s', 'Oro C7-00s'),
(1964, 'E6', 'E6-00', 'E6 E6-00'),
(1965, 'E7-00', 'E7-00', 'E7-00'),
(1966, 'X7', 'X7-00', 'X7 X7-00'),
(1967, 'Constellation T', 'Constellation T', 'Constellation T'),
(1968, '600', '600', '600'),
(1969, '603', '603', '603'),
(1970, '701', '701', '701'),
(1971, '808 PureView', '808 PureView', '808 PureView'),
(1972, 'E65', 'E65', 'E65'),
(1973, 'E71', 'E71', 'E71'),
(1974, 'N95', 'N95', 'N95'),
(1975, 'XpressMusic', '5700', 'XpressMusic 5700'),
(1976, 'Navigator', '6110', 'Navigator 6110'),
(1977, '6120 classic', '6120 classic', '6120 classic'),
(1978, 'Classic', '6120ci', 'Classic 6120ci'),
(1979, '6121 classic', '6121 classic', '6121 classic'),
(1980, '6122c', '6122c', '6122c'),
(1981, '6124 classic', '6124 classic', '6124 classic'),
(1982, '6290', '6290', '6290'),
(1983, 'Communicator', 'E90 Communicator', 'Communicator E90 Communicator'),
(1984, 'E51', 'E51', 'E51'),
(1985, 'E63', 'E63', 'E63'),
(1986, 'E63-3', 'E63-3', 'E63-3'),
(1987, 'E66', 'E66', 'E66'),
(1988, 'E71-2', 'E71-2', 'E71-2'),
(1989, 'E71-3', 'E71-3', 'E71-3'),
(1990, 'N76', 'N76', 'N76'),
(1991, 'N82', 'N82', 'N82'),
(1992, 'N95-3 NAM', 'N95-3 NAM', 'N95-3 NAM'),
(1993, 'Classic', '6220 classic', 'Classic 6220 classic'),
(1994, 'XpressMusic', '5320 XpressMusic', 'XpressMusic 5320 XpressMusic'),
(1995, 'Navigator', '6210', 'Navigator 6210'),
(1996, 'Fold', '6650 fold', 'Fold 6650 fold'),
(1997, 'E71x', 'E71x', 'E71x'),
(1998, 'XpressMusic', '5730', 'XpressMusic 5730'),
(1999, '6700 slide', '6700 slide', '6700 slide'),
(2000, 'Navigator', '6710', 'Navigator 6710'),
(2001, '6730 classic', '6730 classic', '6730 classic'),
(2002, 'C5', 'C5-00', 'C5 C5-00'),
(2003, 'Mystic', 'E5-00', 'Mystic E5-00'),
(2004, 'E52', 'E52', 'E52'),
(2005, 'E55', 'E55', 'E55'),
(2006, 'E72', 'E72', 'E72'),
(2007, 'Mode', 'E73 Mode', 'Mode E73 Mode'),
(2008, 'E75', 'E75', 'E75 E75'),
(2009, 'N86 8MP', 'N86 8MP', 'N86 8MP'),
(2010, 'N96', 'N96', 'N96'),
(2011, 'X5-01', 'X5-01', 'X5-01'),
(2012, 'XpressMusic', '5630', 'XpressMusic 5630'),
(2013, '6720', '6720', '6720'),
(2014, '6760 slide', '6760 slide', '6760 slide'),
(2015, 'Slide', '6790', 'Slide 6790'),
(2016, 'N78', 'N78', 'N78'),
(2017, 'N79', 'N79', 'N79'),
(2018, 'N85', 'N85', 'N85'),
(2019, 'N96-3', 'N96-3', 'N96-3'),
(2020, '5228', '5228', '5228'),
(2021, 'Nuron', '5230 Nuron', 'Nuron 5230 Nuron'),
(2022, '5235', '5235', '5235'),
(2023, 'XpressMusic', '5530', 'XpressMusic 5530'),
(2024, 'XpressMusic', '5800 XpressMusic', 'XpressMusic 5800 XpressMusic'),
(2025, '5800w XpressMusic', '5800w', '5800w XpressMusic 5800w'),
(2026, 'C5-06', 'C5-06', 'C5-06'),
(2027, 'C6-00', 'C6-00', 'C6-00'),
(2028, 'N97', 'N97', 'N97'),
(2029, 'N97 mini', 'N97 mini', 'N97 mini N97 mini'),
(2030, 'N97 mini', 'N97 mini', 'N97 mini'),
(2031, 'Nokia X6-00.1', 'Nokia X6-00.1', 'Nokia X6-00.1'),
(2032, 'X6-00', 'X6-00', 'X6-00'),
(2033, '5232', '5232', '5232'),
(2034, '5250', '5250', '5250'),
(2035, 'C5-04', 'C5-04', 'C5-04'),
(2036, '5510', '5510', '5510'),
(2037, '2605', '2605', '2605'),
(2038, 'Verizon', '6205', 'Verizon 6205'),
(2039, '6270', '6270', '6270'),
(2040, '7110', '7110', '7110'),
(2041, 'Intrigue', '7205', 'Intrigue 7205'),
(2042, '9210', '9210', '9210'),
(2043, '9210i', '9210i', '9210i'),
(2044, '1006', '1006', '1006'),
(2045, '1606', '1606', '1606'),
(2046, '2228', '2228', '2228'),
(2047, '2626', '2626', '2626'),
(2048, '2705', '2705', '2705'),
(2049, '3606', '3606', '3606'),
(2050, '3587', '3587', '3587'),
(2051, '100', '100', '100'),
(2052, '1100', '1100', '1100'),
(2053, '1100b', '1100b', '1100b'),
(2054, '1101', '1101', '1101'),
(2055, '1108', '1108', '1108'),
(2056, '1110', '1110', '1110'),
(2057, '1110i', '1110i', '1110i'),
(2058, '1112', '1112', '1112'),
(2059, '113', '113', '113');
INSERT INTO `smdevicenames` (`DeviceNameID`, `DeviceName`, `DeviceModel`, `MarketingName`) VALUES
(2060, '1220', '1220', '1220'),
(2061, '1600', '1600', '1600'),
(2062, '1680 classic', '1680 classic', '1680 classic'),
(2063, '1681c', '1681c', '1681c'),
(2064, '1682c', '1682c', '1682c'),
(2065, '2100', '2100', '2100'),
(2066, '2112', '2112', '2112'),
(2067, '2115i', '2115i', '2115i'),
(2068, '2125', '2125', '2125'),
(2069, '2220', '2220', '2220'),
(2070, '2260', '2260', '2260'),
(2071, '2300', '2300', '2300'),
(2072, '2310', '2310', '2310'),
(2073, '2320 classic', '2320 classic', '2320 classic'),
(2074, '2322 Classic', '2322 Classic', '2322 Classic'),
(2075, '2323c-2', '2323c-2', '2323c-2'),
(2076, '2330 Classic 2B', '2330 Classic 2B', '2330 Classic 2B'),
(2077, '2355', '2355', '2355'),
(2078, '2600', '2600', '2600'),
(2079, '2600 classic', '2600 classic', '2600 classic'),
(2080, '2600c-2b', '2600c-2b', '2600c-2b'),
(2081, '2610', '2610', '2610'),
(2082, '2630', '2630', '2630'),
(2083, '2650', '2650', '2650'),
(2084, '2651', '2651', '2651'),
(2085, '2652', '2652', '2652'),
(2086, '2660', '2660', '2660'),
(2087, 'Slide', '2680', 'Slide 2680'),
(2088, '2720 fold', '2720 fold', '2720 fold'),
(2089, 'N2730c', 'N2730c', 'N2730c'),
(2090, '2760', '2760', '2760'),
(2091, '2855', '2855', '2855'),
(2092, '2855i', '2855i', '2855i'),
(2093, '2865', '2865', '2865'),
(2094, '2865i', '2865i', '2865i'),
(2095, '2875', '2875', '2875'),
(2096, '2875i', '2875i', '2875i'),
(2097, '3100', '3100', '3100'),
(2098, '3100b', '3100b', '3100b'),
(2099, '3108', '3108', '3108'),
(2100, 'classic', '3109 classic', 'classic 3109 classic'),
(2101, '3110', '3110', '3110'),
(2102, '3120', '3120', '3120'),
(2103, '3120b', '3120b', '3120b'),
(2104, '3125', '3125', '3125'),
(2105, '3128', '3128', '3128'),
(2106, '3152', '3152', '3152'),
(2107, '3155', '3155', '3155'),
(2108, '3155i', '3155i', '3155i'),
(2109, '3200', '3200', '3200'),
(2110, '3205', '3205', '3205'),
(2111, '3205i', '3205i', '3205i'),
(2112, '3210', '3210', '3210'),
(2113, '3220', '3220', '3220'),
(2114, '3300', '3300', '3300'),
(2115, '3310', '3310', '3310'),
(2116, '3320', '3320', '3320'),
(2117, '3330', '3330', '3330'),
(2118, '3330e', '3330e', '3330e'),
(2119, '3350', '3350', '3350'),
(2120, '3360', '3360', '3360'),
(2121, '3395', '3395', '3395'),
(2122, '3410', '3410', '3410'),
(2123, '3500c', '3500c', '3500c'),
(2124, '3510', '3510', '3510'),
(2125, '3510i', '3510i', '3510i'),
(2126, '3520', '3520', '3520'),
(2127, '3530', '3530', '3530'),
(2128, '3555', '3555', '3555'),
(2129, '3555b', '3555b', '3555b'),
(2130, '3555c', '3555c', '3555c'),
(2131, '3560', '3560', '3560'),
(2132, '3585', '3585', '3585'),
(2133, '3585i', '3585i', '3585i'),
(2134, '3586', '3586', '3586'),
(2135, '3587i', '3587i', '3587i'),
(2136, '3588i', '3588i', '3588i'),
(2137, '3590', '3590', '3590'),
(2138, '3595', '3595', '3595'),
(2139, '3595i', '3595i', '3595i'),
(2140, '3610', '3610', '3610'),
(2141, '3610a', '3610a', '3610a'),
(2142, '3620', '3620', '3620'),
(2143, '3630', '3630', '3630'),
(2144, '3660', '3660', '3660'),
(2145, '402', '402', '402'),
(2146, '5000d', '5000d', '5000d'),
(2147, '5070', '5070', '5070'),
(2148, '5070b', '5070b', '5070b'),
(2149, '5100', '5100', '5100'),
(2150, '5125', '5125', '5125'),
(2151, '5140', '5140', '5140'),
(2152, '5140i', '5140i', '5140i'),
(2153, '5146', '5146', '5146'),
(2154, '5210e', '5210e', '5210e'),
(2155, '5236', '5236', '5236'),
(2156, '5238', '5238', '5238'),
(2157, '5500', '5500', '5500'),
(2158, '5555', '5555', '5555'),
(2159, 'XpressMusic', '5611', 'XpressMusic 5611'),
(2160, 'XpressMusic', '5802', 'XpressMusic 5802'),
(2161, '6010', '6010', '6010'),
(2162, '6012', '6012', '6012'),
(2163, '6015', '6015', '6015'),
(2164, '6015i', '6015i', '6015i'),
(2165, '6016', '6016', '6016'),
(2166, '6016i', '6016i', '6016i'),
(2167, '6020', '6020', '6020'),
(2168, '6021', '6021', '6021'),
(2169, '6030', '6030', '6030'),
(2170, '6030b', '6030b', '6030b'),
(2171, '6060', '6060', '6060'),
(2172, '6061', '6061', '6061'),
(2173, '6070', '6070', '6070'),
(2174, '6080', '6080', '6080'),
(2175, '6080b', '6080b', '6080b'),
(2176, '6085', '6085', '6085'),
(2177, '6086', '6086', '6086'),
(2178, '6088', '6088', '6088'),
(2179, '6100', '6100', '6100'),
(2180, '6100A', '6100A', '6100A'),
(2181, '6101', '6101', '6101'),
(2182, '6102', '6102', '6102'),
(2183, '6102i', '6102i', '6102i'),
(2184, '6103', '6103', '6103'),
(2185, '6108', '6108', '6108'),
(2186, '6111', '6111', '6111'),
(2187, '6120', '6120', '6120'),
(2188, '6125', '6125', '6125'),
(2189, '6126', '6126', '6126'),
(2190, '6130', '6130', '6130'),
(2191, '6131', '6131', '6131'),
(2192, '6131 NFC', '6131 NFC', '6131 NFC'),
(2193, '6133', '6133', '6133'),
(2194, '6135', '6135', '6135'),
(2195, '6136', '6136', '6136'),
(2196, '6150', '6150', '6150'),
(2197, '6151', '6151', '6151'),
(2198, '6152', '6152', '6152'),
(2199, '6155', '6155', '6155'),
(2200, '6155i', '6155i', '6155i'),
(2201, '6163', '6163', '6163'),
(2202, '6165', '6165', '6165'),
(2203, '6165i', '6165i', '6165i'),
(2204, '6170', '6170', '6170'),
(2205, '6200', '6200', '6200'),
(2206, 'WAP Browser', 'WAP Browser', 'WAP Browser'),
(2207, 'Navigator', '6210e', 'Navigator 6210e'),
(2208, 'Classic', '6212', 'Classic 6212'),
(2209, '6215i', '6215i', '6215i'),
(2210, '6220', '6220', '6220'),
(2211, '6225', '6225', '6225'),
(2212, '6225i', '6225i', '6225i'),
(2213, '6230i', '6230i', '6230i'),
(2214, '6233', '6233', '6233'),
(2215, '6234', '6234', '6234'),
(2216, '6235', '6235', '6235'),
(2217, '6235i', '6235i', '6235i'),
(2218, '6236i', '6236i', '6236i'),
(2219, '6250', '6250', '6250'),
(2220, '6255', '6255', '6255'),
(2221, '6255i', '6255i', '6255i'),
(2222, '6263', '6263', '6263'),
(2223, '6265', '6265', '6265'),
(2224, '6265i', '6265i', '6265i'),
(2225, '6267', '6267', '6267'),
(2226, '6275', '6275', '6275'),
(2227, '6275i', '6275i', '6275i'),
(2228, '6276', '6276', '6276'),
(2229, '6282', '6282', '6282'),
(2230, '6288', '6288', '6288'),
(2231, '6301', '6301', '6301'),
(2232, '6305i', '6305i', '6305i'),
(2233, '6310', '6310', '6310'),
(2234, '6310i', '6310i', '6310i'),
(2235, '6315i', '6315i', '6315i'),
(2236, '6320i', '6320i', '6320i'),
(2237, '6340', '6340', '6340'),
(2238, '6340i', '6340i', '6340i'),
(2239, '6500', '6500', '6500'),
(2240, '6500c', '6500c', '6500c'),
(2241, '6510', '6510', '6510'),
(2242, '6555', '6555', '6555'),
(2243, '6555b', '6555b', '6555b'),
(2244, '6555c', '6555c', '6555c'),
(2245, '6560', '6560', '6560'),
(2246, '6585', '6585', '6585'),
(2247, '6590', '6590', '6590'),
(2248, '660', '660', '660'),
(2249, '6610', '6610', '6610'),
(2250, '6610i', '6610i', '6610i'),
(2251, '6620', '6620', '6620'),
(2252, '6650', '6650', '6650'),
(2253, '6650x', '6650x', '6650x'),
(2254, '6651', '6651', '6651'),
(2255, '6680i', '6680i', '6680i'),
(2256, '6708', '6708', '6708'),
(2257, 'Mural', '6750 Mural', 'Mural 6750 Mural'),
(2258, '6788', '6788', '6788'),
(2259, '6788i', '6788i', '6788i'),
(2260, 'Surge', '6790', 'Surge 6790'),
(2261, '6800', '6800', '6800'),
(2262, '6810', '6810', '6810'),
(2263, '6820', '6820', '6820'),
(2264, '6820b', '6820b', '6820b'),
(2265, '6822', '6822', '6822'),
(2266, 'E6', '702T', 'E6 702T'),
(2267, 'Prism', '7070', 'Prism 7070'),
(2268, '7160', '7160', '7160'),
(2269, '7190', '7190', '7190'),
(2270, '7200', '7200', '7200'),
(2271, '7250', '7250', '7250'),
(2272, '7250i', '7250i', '7250i'),
(2273, '7270', '7270', '7270'),
(2274, '7280', '7280', '7280'),
(2275, '7360', '7360', '7360'),
(2276, '7370', '7370', '7370'),
(2277, '7373', '7373', '7373'),
(2278, '7380', '7380', '7380'),
(2279, '7390', '7390', '7390'),
(2280, 'Prism', '7500', 'Prism 7500'),
(2281, '7600', '7600', '7600'),
(2282, 'N7612s', 'N7612s', 'N7612s'),
(2283, 'Prism', '7900', 'Prism 7900'),
(2284, '801T', '801T', '801T'),
(2285, '8210', '8210', '8210'),
(2286, '8260', '8260', '8260'),
(2287, '8265', '8265', '8265'),
(2288, '8280', '8280', '8280'),
(2289, '8290', '8290', '8290'),
(2290, '8310e', '8310e', '8310e'),
(2291, '8390', '8390', '8390'),
(2292, 'Luna', '8600', 'Luna 8600'),
(2293, 'Sirocco Edition', '8800', 'Sirocco Edition 8800'),
(2294, 'Arte', '8800 Arte', 'Arte 8800 Arte'),
(2295, '8801', '8801', '8801'),
(2296, '8810', '8810', '8810'),
(2297, '8850', '8850', '8850'),
(2298, '8855', '8855', '8855'),
(2299, '8860', '8860', '8860'),
(2300, '8890', '8890', '8890'),
(2301, '8910', '8910', '8910'),
(2302, '8910i', '8910i', '8910i'),
(2303, '9110', '9110', '9110'),
(2304, '9210c', '9210c', '9210c'),
(2305, '9290', '9290', '9290'),
(2306, 'C5-01', 'C5-01', 'C5-01'),
(2307, 'E61i', 'E61i', 'E61i'),
(2308, 'E62', 'E62', 'E62'),
(2309, 'E70', 'E70', 'E70'),
(2310, 'N-Gage', 'N-Gage', 'N-Gage'),
(2311, 'N-Gage QD', 'N-Gage QD', 'N-Gage QD'),
(2312, 'N71', 'N71', 'N71'),
(2313, 'N72', 'N72', 'N72'),
(2314, 'N73-2', 'N73-2', 'N73-2'),
(2315, 'N75', 'N75', 'N75'),
(2316, 'N77', 'N77', 'N77'),
(2317, 'N78-2', 'N78-2', 'N78-2'),
(2318, 'N92', 'N92', 'N92'),
(2319, 'N93i', 'N93i', 'N93i'),
(2320, 'N97i', 'N97i', 'N97i'),
(2321, 'T7', 'T7-00', 'T7 T7-00'),
(2322, 'THR880i', 'THR880i', 'THR880i'),
(2323, 'X5-00', 'X5-00', 'X5-00'),
(2324, 'Softbank 705NK', 'Softbank 705NK', 'Softbank 705NK'),
(2325, 'SoftBank X02NK', 'SoftBank X02NK', 'SoftBank X02NK'),
(2326, 'SGH-X520X', 'SGH-X520X', 'SGH-X520X'),
(2327, '702NK(NOKIA 6630)', '702NK(NOKIA 6630)', '702NK(NOKIA 6630)'),
(2328, '702NKII(NOKIA 6680)', '702NKII(NOKIA 6680)', '702NKII(NOKIA 6680)'),
(2329, 'VGA1000', 'SPH-A620', 'VGA1000 SPH-A620'),
(2330, 'IP-A790', 'IP-A790', 'IP-A790'),
(2331, 'PM-A740', 'PM-A740', 'PM-A740'),
(2332, 'PM-A840', 'PM-A840', 'PM-A840'),
(2333, 'RL-A760', 'RL-A760', 'RL-A760'),
(2334, 'VI660', 'VI660', 'VI660'),
(2335, 'MM-A900', 'MM-A900', 'MM-A900'),
(2336, 'MM-A920', 'MM-A920', 'MM-A920'),
(2337, 'm240', 'PLS-M240', 'm240 PLS-M240'),
(2338, 'PLS-M330', 'PLS-M330', 'PLS-M330'),
(2339, 'SPH-M240', 'SPH-M240', 'SPH-M240'),
(2340, 'SPH M330', 'SPH M330', 'SPH M330'),
(2341, 'Rogue', 'SCH U960', 'Rogue SCH U960'),
(2342, 'SGH-i600', 'SGH-i600', 'SGH-i600'),
(2343, 'Blackjack Telstra', 'SGH-i601', 'Blackjack Telstra SGH-i601'),
(2344, 'SGH-i640V', 'SGH-i640V', 'SGH-i640V'),
(2345, 'SGH-I620', 'SGH-I620', 'SGH-I620'),
(2346, 'OMNIA', 'SGH i900', 'OMNIA SGH i900'),
(2347, 'Omnia', 'SCH-I910', 'Omnia SCH-I910'),
(2348, 'Omnia II', 'GT-i8000', 'Omnia II GT-i8000'),
(2349, 'Code', 'SCH i220', 'Code SCH i220'),
(2350, 'R631', 'R631', 'R631'),
(2351, 'Reality', 'SCH U820', 'Reality SCH U820'),
(2352, 'Wave', 'GT S8500', 'Wave GT S8500'),
(2353, 'Wave 2', 'GT-S5250', 'Wave 2 GT-S5250'),
(2354, 'GT-S5253', 'GT-S5253', 'GT-S5253'),
(2355, 'GT-S5330', 'GT-S5330', 'GT-S5330'),
(2356, 'Samsung Wave 533', 'GT-S5333', 'Samsung Wave 533 GT-S5333'),
(2357, 'GT-S5380B', 'GT-S5380B', 'GT-S5380B'),
(2358, 'GT-S5380', 'GT-S5380', 'GT-S5380'),
(2359, 'Wave Y', 'GT-S5380K', 'Wave Y GT-S5380K'),
(2360, 'GT-S5750E', 'GT-S5750E', 'GT-S5750E'),
(2361, 'S5753E', 'S5753E', 'S5753E'),
(2362, 'GT-S5780', 'GT-S5780', 'GT-S5780'),
(2363, 'GT-S7230', 'GT-S7230', 'GT-S7230'),
(2364, 'Wave 723', 'GT-S7230E', 'Wave 723 GT-S7230E'),
(2365, 'GT-S7233E', 'GT-S7233E', 'GT-S7233E'),
(2366, 'Wave M', 'GT-S7250', 'Wave M GT-S7250'),
(2367, 'GT-S8500L Wave', 'GT-S8500L', 'GT-S8500L Wave GT-S8500L'),
(2368, 'Wave 2', 'GT-S8530', 'Wave 2 GT-S8530'),
(2369, 'Wave 3', 'GT-S8600', 'Wave 3 GT-S8600'),
(2370, 'SGH G810', 'SGH G810', 'SGH G810'),
(2371, 'SGH i560', 'SGH i560', 'SGH i560'),
(2372, 'SGH-i550', 'SGH-i550', 'SGH-i550'),
(2373, 'SGH-i450V', 'SGH-i450V', 'SGH-i450V'),
(2374, 'SGH-i455', 'SGH-i455', 'SGH-i455'),
(2375, 'SGH-i520', 'SGH-i520', 'SGH-i520'),
(2376, 'SGH-i520V', 'SGH-i520V', 'SGH-i520V'),
(2377, 'SGH i550V', 'SGH i550V', 'SGH i550V'),
(2378, 'I7110', 'I7110', 'I7110'),
(2379, 'INNOV8', 'GT-I8510', 'INNOV8 GT-I8510'),
(2380, 'SGH-L870', 'SGH-L870', 'SGH-L870'),
(2381, 'Omnia HD', 'GT-I8910', 'Omnia HD GT-I8910'),
(2382, 'SCH-R900', 'SCH-R900', 'SCH-R900'),
(2383, 'SCH-U940', 'SCH-U940', 'SCH-U940'),
(2384, 'SGH-Z105', 'SGH-Z105', 'SGH-Z105'),
(2385, 'Z100', 'Z100', 'Z100'),
(2386, 'Z105U', 'Z105U', 'Z105U'),
(2387, 'Restore', 'SPH-M570', 'Restore SPH-M570'),
(2388, 'SPH-M360', 'SPH-M360', 'SPH-M360'),
(2389, 'Eclaim', 'SPH M550', 'Eclaim SPH M550'),
(2390, 'SPH M560', 'SPH M560', 'SPH M560'),
(2391, 'Seek', 'PLS-M350', 'Seek PLS-M350'),
(2392, 'Trender', 'SPH-M380', 'Trender SPH-M380'),
(2393, 'SPH-M370', 'SPH-M370', 'SPH-M370'),
(2394, 'Omnia II', 'SCH-i920', 'Omnia II SCH-i920'),
(2395, 'Omnia ii', 'GT i8000', 'Omnia ii GT i8000'),
(2396, 'Instinct HD', 'M850', 'Instinct HD M850'),
(2397, 'Convoy 2', 'SCH-U660', 'Convoy 2 SCH-U660'),
(2398, 'SGH-X100', 'SGH-X100', 'SGH-X100'),
(2399, 'Explorer', 'B2100', 'Explorer B2100'),
(2400, 'B2100', 'B2100', 'B2100'),
(2401, 'GT-B2700', 'GT-B2700', 'GT-B2700'),
(2402, 'B5702C', 'B5702C', 'B5702C'),
(2403, 'C3050', 'C3050', 'C3050'),
(2404, 'C3053', 'C3053', 'C3053'),
(2405, 'GT-C3110', 'GT-C3110', 'GT-C3110'),
(2406, 'C5110', 'C5110', 'C5110'),
(2407, 'C5212', 'C5212', 'C5212'),
(2408, 'GT-C5220', 'GT-C5220', 'GT-C5220'),
(2409, 'C6625', 'C6625', 'C6625'),
(2410, 'D900', 'D900', 'D900'),
(2411, 'E1310C', 'E1310C', 'E1310C'),
(2412, 'E1360B', 'E1360B', 'E1360B'),
(2413, 'E1410', 'E1410', 'E1410'),
(2414, 'E2100', 'E2100', 'E2100'),
(2415, 'E2100L', 'E2100L', 'E2100L'),
(2416, 'E2210', 'E2210', 'E2210'),
(2417, 'E2210B', 'E2210B', 'E2210B'),
(2418, 'E2510', 'E2510', 'E2510'),
(2419, 'Xcover 271', 'GT-B2710', 'Xcover 271 GT-B2710'),
(2420, 'CorbyTXT', 'GT B3210', 'CorbyTXT GT B3210'),
(2421, 'GT B3310', 'GT B3310', 'GT B3310'),
(2422, 'GT B3313', 'GT B3313', 'GT B3313'),
(2423, 'Corby text', 'GT B3410', 'Corby text GT B3410'),
(2424, 'Corby Plus', 'GT-B3410R', 'Corby Plus GT-B3410R'),
(2425, 'Chat', 'GT-B3410W', 'Chat GT-B3410W'),
(2426, 'GT B5310', 'GT B5310', 'GT B5310'),
(2427, 'GT-B5310L', 'GT-B5310L', 'GT-B5310L'),
(2428, 'GT-B5310R', 'GT-B5310R', 'GT-B5310R'),
(2429, 'GT-B5310U', 'GT-B5310U', 'GT-B5310U'),
(2430, 'GT B5722', 'GT B5722', 'GT B5722'),
(2431, 'GT-B5722C', 'GT-B5722C', 'GT-B5722C'),
(2432, 'Omnia Pro 5', 'GT-B6520', 'Omnia Pro 5 GT-B6520'),
(2433, 'Lite', 'GT B7300', 'Lite GT B7300'),
(2434, 'OmniaPRO', 'GT B7320', 'OmniaPRO GT B7320'),
(2435, 'GT-B7330', 'GT-B7330', 'GT-B7330'),
(2436, 'Omnia PRO', 'GT B7330', 'Omnia PRO GT B7330'),
(2437, 'GT-B7620', 'GT-B7620', 'GT-B7620'),
(2438, 'GT-B7722', 'GT-B7722', 'GT-B7722'),
(2439, 'C3010', 'C3010', 'C3010'),
(2440, 'GT-C3011', 'GT-C3011', 'GT-C3011'),
(2441, 'GT-S3060', 'GT-S3060', 'GT-S3060'),
(2442, 'GT-C3110C', 'GT-C3110C', 'GT-C3110C'),
(2443, 'GT-C3200', 'GT-C3200', 'GT-C3200'),
(2444, 'DuoS', 'GT C3212', 'DuoS GT C3212'),
(2445, 'GT-C3222', 'GT-C3222', 'GT-C3222'),
(2446, 'GT-C3300K', 'GT-C3300K', 'GT-C3300K'),
(2447, 'GT C3300K', 'GT C3300K', 'GT C3300K'),
(2448, 'Champ', 'GT-C3300i', 'Champ GT-C3300i'),
(2449, 'GT-C3303', 'GT-C3303', 'GT-C3303'),
(2450, 'GT-C3303K', 'GT-C3303K', 'GT-C3303K'),
(2451, 'GT-C3310', 'GT-C3310', 'GT-C3310'),
(2452, 'GT-C3312', 'GT-C3312', 'GT-C3312'),
(2453, 'Metro Duos', 'GT-C3322', 'Metro Duos GT-C3322'),
(2454, 'GT-C3330', 'GT-C3330', 'GT-C3330'),
(2455, 'GT-C3332', 'GT-C3332', 'GT-C3332'),
(2456, 'GT-C3350', 'GT-C3350', 'GT-C3350'),
(2457, 'Xcover 2', 'GT-C3350', 'Xcover 2 GT-C3350'),
(2458, 'GT-C3500', 'GT-C3500', 'GT-C3500'),
(2459, 'CorbyPOP', 'GT C3510', 'CorbyPOP GT C3510'),
(2460, 'GT-C3510T', 'GT-C3510T', 'GT-C3510T'),
(2461, 'GT-C3518', 'GT-C3518', 'GT-C3518'),
(2462, 'GT-C3520', 'GT-C3520', 'GT-C3520'),
(2463, 'GT-C3530', 'GT-C3530', 'GT-C3530'),
(2464, 'Metallic Gray', 'GT-C3560', 'Metallic Gray GT-C3560'),
(2465, 'GT-C3630', 'GT-C3630', 'GT-C3630'),
(2466, 'Metallic Gray', 'GT-C3750', 'Metallic Gray GT-C3750'),
(2467, 'GT-C3752', 'GT-C3752', 'GT-C3752'),
(2468, 'GT-C3782', 'GT-C3782', 'GT-C3782'),
(2469, 'GT-C5010', 'GT-C5010', 'GT-C5010'),
(2470, 'GT-C5010E', 'GT-C5010E', 'GT-C5010E'),
(2471, 'GT-C5130', 'GT-C5130', 'GT-C5130'),
(2472, 'GT-C5130S', 'GT-C5130S', 'GT-C5130S'),
(2473, 'GT-C5510', 'GT-C5510', 'GT-C5510'),
(2474, 'GT C6112', 'GT C6112', 'GT C6112'),
(2475, 'Valencia', 'C6620', 'Valencia C6620'),
(2476, 'Star II Duos', 'GT-C6712', 'Star II Duos GT-C6712'),
(2477, 'GT-E1390', 'GT-E1390', 'GT-E1390'),
(2478, 'GT E2120', 'GT E2120', 'GT E2120'),
(2479, 'GT-E2120C', 'GT-E2120C', 'GT-E2120C'),
(2480, 'GT-E2120L', 'GT-E2120L', 'GT-E2120L'),
(2481, 'GT E2120i', 'GT E2120i', 'GT E2120i'),
(2482, 'GT E2121', 'GT E2121', 'GT E2121'),
(2483, 'GT-E2121L', 'GT-E2121L', 'GT-E2121L'),
(2484, 'GT E2130', 'GT E2130', 'GT E2130'),
(2485, 'GT-E2152', 'GT-E2152', 'GT-E2152'),
(2486, 'GT-E2152i', 'GT-E2152i', 'GT-E2152i'),
(2487, 'GT-E2200', 'GT-E2200', 'GT-E2200'),
(2488, 'Chat 222', 'GT-E2220', 'Chat 222 GT-E2220'),
(2489, 'GT-E2222', 'GT-E2222', 'GT-E2222'),
(2490, 'GT-E2230', 'GT-E2230', 'GT-E2230'),
(2491, 'GT-E2232', 'GT-E2232', 'GT-E2232'),
(2492, 'Utica', 'GT-E2250', 'Utica GT-E2250'),
(2493, 'GT-E2330B', 'GT-E2330B', 'GT-E2330B'),
(2494, 'Xcover', 'GT-E2370', 'Xcover GT-E2370'),
(2495, 'GT-E2530', 'GT-E2530', 'GT-E2530'),
(2496, 'GT-E2550', 'GT-E2550', 'GT-E2550'),
(2497, 'GT-E2550L', 'GT-E2550L', 'GT-E2550L'),
(2498, 'GT-E2600', 'GT-E2600', 'GT-E2600'),
(2499, 'GT-E2652W', 'GT-E2652W', 'GT-E2652W'),
(2500, 'GT-E3210', 'GT-E3210', 'GT-E3210'),
(2501, 'GT-E3210L', 'GT-E3210L', 'GT-E3210L'),
(2502, 'GT I6220', 'GT I6220', 'GT I6220'),
(2503, 'Lite Star TV', 'GT-I6230', 'Lite Star TV GT-I6230'),
(2504, 'GT-I6330C', 'GT-I6330C', 'GT-I6330C'),
(2505, 'GT-I6410', 'GT-I6410', 'GT-I6410'),
(2506, 'Duos TV', 'GT-I6712', 'Duos TV GT-I6712'),
(2507, 'GT-I7410', 'GT-I7410', 'GT-I7410'),
(2508, 'GT-I8320', 'GT-I8320', 'GT-I8320'),
(2509, 'Vodafone 360 H1', 'SGH I8320', 'Vodafone 360 H1 SGH I8320'),
(2510, 'BeatDJ', 'GT M2310', 'BeatDJ GT M2310'),
(2511, 'GT M2510', 'GT M2510', 'GT M2510'),
(2512, 'GT M2513', 'GT M2513', 'GT M2513'),
(2513, 'Beat', 'GT M2520', 'Beat GT M2520'),
(2514, 'Beat Twist', 'M2710', 'Beat Twist M2710'),
(2515, 'GT-M3310', 'GT-M3310', 'GT-M3310'),
(2516, 'GT-M3318C', 'GT-M3318C', 'GT-M3318C'),
(2517, 'GT-M3710', 'GT-M3710', 'GT-M3710'),
(2518, 'Corby Lindy', 'GT M5650', 'Corby Lindy GT M5650'),
(2519, 'GT-M5650U', 'GT-M5650U', 'GT-M5650U'),
(2520, 'Beat DJ', 'GT-M7600', 'Beat DJ GT-M7600'),
(2521, 'Pixon', 'M8800', 'Pixon M8800'),
(2522, 'Pixon', 'GT M8800', 'Pixon GT M8800'),
(2523, 'Pixon12', 'GT M8910', 'Pixon12 GT M8910'),
(2524, 'Pixon 12', 'GT-M8920', 'Pixon 12 GT-M8920'),
(2525, 'GT S3100', 'GT S3100', 'GT S3100'),
(2526, 'GT-S3310', 'GT-S3310', 'GT-S3310'),
(2527, 'GT-S3350', 'GT-S3350', 'GT-S3350'),
(2528, 'GT-S3353', 'GT-S3353', 'GT-S3353'),
(2529, 'Corby', 'GT S3370', 'Corby GT S3370'),
(2530, 'GT-S3370L', 'GT-S3370L', 'GT-S3370L'),
(2531, 'S3500C', 'S3500C', 'S3500C'),
(2532, 'GT-S3501C', 'GT-S3501C', 'GT-S3501C'),
(2533, 'Shark 3', 'GT-S3550', 'Shark 3 GT-S3550'),
(2534, 'Ch@t', 'GT-S3570', 'Ch@t GT-S3570'),
(2535, 'GT S3600C', 'GT S3600C', 'GT S3600C'),
(2536, 'GT-S3601C', 'GT-S3601C', 'GT-S3601C'),
(2537, 'Corby', 'GT-S3650', 'Corby GT-S3650'),
(2538, 'GT-S3650C', 'GT-S3650C', 'GT-S3650C'),
(2539, 'GT-S3650H', 'GT-S3650H', 'GT-S3650H'),
(2540, 'GT-S3650W', 'GT-S3650W', 'GT-S3650W'),
(2541, 'GT S3653', 'GT S3653', 'GT S3653'),
(2542, 'Genio', 'GT-S3653W', 'Genio GT-S3653W'),
(2543, 'S3710', 'S3710', 'S3710'),
(2544, 'Champ 3.5G', 'GT-3770', 'Champ 3.5G GT-3770'),
(2545, 'Champ 3.5G', 'GT-S3770L', 'Champ 3.5G GT-S3770L'),
(2546, 'GT-S3850', 'GT-S3850', 'GT-S3850'),
(2547, 'S3930C', 'S3930C', 'S3930C'),
(2548, 'Diva folder', 'GT-S5150', 'Diva folder GT-S5150'),
(2549, 'GT-S5200C', 'GT-S5200C', 'GT-S5200C'),
(2550, 'GT-S5210', 'GT-S5210', 'GT-S5210'),
(2551, 'Star III Duos', 'GT-S5222', 'Star III Duos GT-S5222'),
(2552, 'Galaxy Pop', 'GT-S5229', 'Galaxy Pop GT-S5229'),
(2553, 'Star', 'GT-S5230', 'Star GT-S5230'),
(2554, 'Star', 'GT-S5230G', 'Star GT-S5230G'),
(2555, 'GT-S5230N', 'GT-S5230N', 'GT-S5230N'),
(2556, 'Star', 'GT S5230W', 'Star GT S5230W'),
(2557, 'Star', 'GT S5233A', 'Star GT S5233A'),
(2558, 'GT S5233S', 'GT S5233S', 'GT S5233S'),
(2559, 'GT-S5233T', 'GT-S5233T', 'GT-S5233T'),
(2560, 'GT S5233W', 'GT S5233W', 'GT S5233W'),
(2561, 'Star II', 'GT-S5260', 'Star II GT-S5260'),
(2562, 'Star II', 'GT-S5263', 'Star II GT-S5263'),
(2563, 'Chat', 'GT-S5270K', 'Chat GT-S5270K'),
(2564, 'Ch@t 527', 'GT-S5270L', 'Ch@t 527 GT-S5270L'),
(2565, 'Shark', 'GT S5350', 'Shark GT S5350'),
(2566, 'GT S5503', 'GT S5503', 'GT S5503'),
(2567, 'GT S5510', 'GT S5510', 'GT S5510'),
(2568, 'GT-S5511T', 'GT-S5511T', 'GT-S5511T'),
(2569, 'GT-S5530', 'GT-S5530', 'GT-S5530'),
(2570, 'Shark 2', 'GT-S5550', 'Shark 2 GT-S5550'),
(2571, 'GT S5560', 'GT S5560', 'GT S5560'),
(2572, 'GT-S5560i', 'GT-S5560i', 'GT-S5560i'),
(2573, 'GT-S5600', 'GT-S5600', 'GT-S5600'),
(2574, 'GT S5600', 'GT S5600', 'GT S5600'),
(2575, 'GT S5603', 'GT S5603', 'GT S5603'),
(2576, 'GT S5603T', 'GT S5603T', 'GT S5603T'),
(2577, 'Primo', 'GT-S5610', 'Primo GT-S5610'),
(2578, 'Primo', 'GT-S5610K', 'Primo GT-S5610K'),
(2579, 'GT S5620', 'GT S5620', 'GT S5620'),
(2580, 'GT-S5620B', 'GT-S5620B', 'GT-S5620B'),
(2581, 'GT-S5620L', 'GT-S5620L', 'GT-S5620L'),
(2582, 'GT-S5628', 'GT-S5628', 'GT-S5628'),
(2583, 'GT-S5630C', 'GT-S5630C', 'GT-S5630C'),
(2584, 'GT-S6700C', 'GT-S6700C', 'GT-S6700C'),
(2585, 'GT-S6700', 'GT-S6700', 'GT-S6700'),
(2586, 'Diva', 'GT-S7070', 'Diva GT-S7070'),
(2587, 'GT-S7070C', 'GT-S7070C', 'GT-S7070C'),
(2588, 'SGH S7330', 'SGH S7330', 'SGH S7330'),
(2589, 'GT-S7330', 'GT-S7330', 'GT-S7330'),
(2590, 'Blue Earth', 'GT S7550', 'Blue Earth GT S7550'),
(2591, 'Jet', 'GT-S8000', 'Jet GT-S8000'),
(2592, 'Jet', 'GT-S8000C', 'Jet GT-S8000C'),
(2593, 'Jet', 'GT S8000L', 'Jet GT S8000L'),
(2594, 'Jet', 'S8003', 'Jet S8003'),
(2595, 'M3200', 'M3200', 'M3200'),
(2596, 'Beat', 'M3510', 'Beat M3510'),
(2597, 'GT-M7500', 'GT-M7500', 'GT-M7500'),
(2598, 'M7603', 'M7603', 'M7603'),
(2599, 'Pixon', 'M8800L', 'Pixon M8800L'),
(2600, 'Tobi', 'GT S3030', 'Tobi GT S3030'),
(2601, 'S3110', 'S3110', 'S3110'),
(2602, 'S3110C', 'S3110C', 'S3110C'),
(2603, 'S3500', 'S3500', 'S3500'),
(2604, 'S3600', 'S3600', 'S3600'),
(2605, 'GT-S5050', 'GT-S5050', 'GT-S5050'),
(2606, 'S5200', 'S5200', 'S5200'),
(2607, 'S5320', 'S5320', 'S5320'),
(2608, 'GT-S7220', 'GT-S7220', 'GT-S7220'),
(2609, 'GT-S7350', 'GT-S7350', 'GT-S7350'),
(2610, 'GT-S8300', 'GT-S8300', 'GT-S8300'),
(2611, 'S8300T', 'S8300T', 'S8300T'),
(2612, 'S9402', 'S9402', 'S9402'),
(2613, 'X620', 'X620', 'X620'),
(2614, 'D600E', 'D600E', 'D600E'),
(2615, 'SCH-W169', 'SCH-W169', 'SCH-W169'),
(2616, 'SCH W259', 'SCH W259', 'SCH W259'),
(2617, 'SGH-A107', 'SGH-A107', 'SGH-A107'),
(2618, 'SGH-A110', 'SGH-A110', 'SGH-A110'),
(2619, 'SGH-A117', 'SGH-A117', 'SGH-A117'),
(2620, 'SGH-A137', 'SGH-A137', 'SGH-A137'),
(2621, 'GoPhone', 'SGH A167', 'GoPhone SGH A167'),
(2622, 'SGH-A177', 'SGH-A177', 'SGH-A177'),
(2623, 'SGH-A200', 'SGH-A200', 'SGH-A200'),
(2624, 'SGH-A227', 'SGH-A227', 'SGH-A227'),
(2625, 'SGH-A237', 'SGH-A237', 'SGH-A237'),
(2626, 'Hype', 'SGH-A256', 'Hype SGH-A256'),
(2627, 'Magnet', 'SGH-A257', 'Magnet SGH-A257'),
(2628, 'SGH-A300', 'SGH-A300', 'SGH-A300'),
(2629, 'SGH-A301', 'SGH-A301', 'SGH-A301'),
(2630, 'SGH-A400', 'SGH-A400', 'SGH-A400'),
(2631, 'SGH-A411', 'SGH-A411', 'SGH-A411'),
(2632, 'SGH-A412', 'SGH-A412', 'SGH-A412'),
(2633, 'SGH-A436', 'SGH-A436', 'SGH-A436'),
(2634, 'SGH-A437', 'SGH-A437', 'SGH-A437'),
(2635, 'SGH-A516', 'SGH-A516', 'SGH-A516'),
(2636, 'SGH-A517', 'SGH-A517', 'SGH-A517'),
(2637, 'SGH-A551', 'SGH-A551', 'SGH-A551'),
(2638, 'SGH-A561', 'SGH-A561', 'SGH-A561'),
(2639, 'Eternity II', 'SGH-A597', 'Eternity II SGH-A597'),
(2640, 'SGH A637', 'SGH A637', 'SGH A637'),
(2641, 'SGH-A657', 'SGH-A657', 'SGH-A657'),
(2642, 'SGH A687', 'SGH A687', 'SGH A687'),
(2643, 'Sunburst', 'SGH A697', 'Sunburst SGH A697'),
(2644, 'SGH-A701', 'SGH-A701', 'SGH-A701'),
(2645, 'SGH-A706', 'SGH-A706', 'SGH-A706'),
(2646, 'SYNC', 'SGH-A707', 'SYNC SGH-A707'),
(2647, 'SGH-A711', 'SGH-A711', 'SGH-A711'),
(2648, 'SGH-A717', 'SGH-A717', 'SGH-A717'),
(2649, 'SGH-A727', 'SGH-A727', 'SGH-A727'),
(2650, 'SGH-A736', 'SGH-A736', 'SGH-A736'),
(2651, 'SGH-A737', 'SGH-A737', 'SGH-A737'),
(2652, 'SGH-A746', 'SGH-A746', 'SGH-A746'),
(2653, 'SGH-A747', 'SGH-A747', 'SGH-A747'),
(2654, 'Propel', 'SGH A766', 'Propel SGH A766'),
(2655, 'Propel', 'SGH A767', 'Propel SGH A767'),
(2656, 'SGH-A777', 'SGH-A777', 'SGH-A777'),
(2657, 'Mariner', 'SGH-A797', 'Mariner SGH-A797'),
(2658, 'SGH-A800', 'SGH-A800', 'SGH-A800'),
(2659, 'SGH-A801', 'SGH-A801', 'SGH-A801'),
(2660, 'SGH-A811', 'SGH-A811', 'SGH-A811'),
(2661, 'Solstice II', 'SGH-A817', 'Solstice II SGH-A817'),
(2662, 'SGH-A821', 'SGH-A821', 'SGH-A821'),
(2663, 'Access', 'SGH-A827', 'Access SGH-A827'),
(2664, 'Rugby', 'SGH A837', 'Rugby SGH A837'),
(2665, 'Rugby II', 'SGH-A847', 'Rugby II SGH-A847'),
(2666, 'Eternity', 'SGH A867', 'Eternity SGH A867'),
(2667, 'Impression', 'SGH-A877', 'Impression SGH-A877'),
(2668, 'Advance', 'SGH A885', 'Advance SGH A885'),
(2669, 'Forever', 'SGH A886', 'Forever SGH A886'),
(2670, 'Solstice', 'SGH A887', 'Solstice SGH A887'),
(2671, 'Angel', 'SGH-A897', 'Angel SGH-A897'),
(2672, 'Flight II', 'SGH-A927', 'Flight II SGH-A927'),
(2673, 'SGH B110', 'SGH B110', 'SGH B110'),
(2674, 'SGH-B130', 'SGH-B130', 'SGH-B130'),
(2675, 'SGH B130L', 'SGH B130L', 'SGH B130L'),
(2676, 'SGH-B270i', 'SGH-B270i', 'SGH-B270i'),
(2677, 'SGH-B460', 'SGH-B460', 'SGH-B460'),
(2678, 'SGH-C160', 'SGH-C160', 'SGH-C160'),
(2679, 'C160L', 'C160L', 'C160L'),
(2680, 'C161', 'C161', 'C161'),
(2681, 'SGH-C165', 'SGH-C165', 'SGH-C165'),
(2682, 'SGH-C166', 'SGH-C166', 'SGH-C166'),
(2683, 'SGH-C180', 'SGH-C180', 'SGH-C180'),
(2684, 'SGH-C238', 'SGH-C238', 'SGH-C238'),
(2685, 'SGH-C240', 'SGH-C240', 'SGH-C240'),
(2686, 'SGH C270', 'SGH C270', 'SGH C270'),
(2687, 'SGH C276', 'SGH C276', 'SGH C276'),
(2688, 'SGH C280', 'SGH C280', 'SGH C280'),
(2689, 'SGH-C400', 'SGH-C400', 'SGH-C400'),
(2690, 'SGH-C406', 'SGH-C406', 'SGH-C406'),
(2691, 'SGH-C414', 'SGH-C414', 'SGH-C414'),
(2692, 'SGH-C416', 'SGH-C416', 'SGH-C416'),
(2693, 'SGH C417', 'SGH C417', 'SGH C417'),
(2694, 'SGH-C420L', 'SGH-C420L', 'SGH-C420L'),
(2695, 'SGH-C421', 'SGH-C421', 'SGH-C421'),
(2696, 'SGH-C425', 'SGH-C425', 'SGH-C425'),
(2697, 'SGH-C426', 'SGH-C426', 'SGH-C426'),
(2698, 'SGH-C450', 'SGH-C450', 'SGH-C450'),
(2699, 'SGH-C510L', 'SGH-C510L', 'SGH-C510L'),
(2700, 'SGH-CC03', 'SGH-CC03', 'SGH-CC03'),
(2701, 'SGH-D500', 'SGH-D500', 'SGH-D500'),
(2702, 'SGH-D500C', 'SGH-D500C', 'SGH-D500C'),
(2703, 'SGH-D500E', 'SGH-D500E', 'SGH-D500E'),
(2704, 'SGH-D508', 'SGH-D508', 'SGH-D508'),
(2705, 'SGH-D510', 'SGH-D510', 'SGH-D510'),
(2706, 'SGH-D520', 'SGH-D520', 'SGH-D520'),
(2707, 'SGH-D528', 'SGH-D528', 'SGH-D528'),
(2708, 'SGH-D600E', 'SGH-D600E', 'SGH-D600E'),
(2709, 'SGH-D608', 'SGH-D608', 'SGH-D608'),
(2710, 'SGH-D728', 'SGH-D728', 'SGH-D728'),
(2711, 'SGH D730', 'SGH D730', 'SGH D730'),
(2712, 'SGH-D780', 'SGH-D780', 'SGH-D780'),
(2713, 'SGH-D788', 'SGH-D788', 'SGH-D788'),
(2714, 'SGH-D808', 'SGH-D808', 'SGH-D808'),
(2715, 'SGH-D820', 'SGH-D820', 'SGH-D820'),
(2716, 'SGH-D830', 'SGH-D830', 'SGH-D830'),
(2717, 'SGH-D840', 'SGH-D840', 'SGH-D840'),
(2718, 'DuoS', 'SGH-D880', 'DuoS SGH-D880'),
(2719, 'SGH-D900', 'SGH-D900', 'SGH-D900'),
(2720, 'SGH-D900i', 'SGH-D900i', 'SGH-D900i'),
(2721, 'SGH-D908', 'SGH-D908', 'SGH-D908'),
(2722, 'SGH-D908i', 'SGH-D908i', 'SGH-D908i'),
(2723, 'SGH-D980', 'SGH-D980', 'SGH-D980'),
(2724, 'SGH D988', 'SGH D988', 'SGH D988'),
(2725, 'SGH-E100', 'SGH-E100', 'SGH-E100'),
(2726, 'SGH-E100A', 'SGH-E100A', 'SGH-E100A'),
(2727, 'SGH-E108', 'SGH-E108', 'SGH-E108'),
(2728, 'SGH-E200', 'SGH-E200', 'SGH-E200'),
(2729, 'SGH-E208', 'SGH-E208', 'SGH-E208'),
(2730, 'SGH-E230L', 'SGH-E230L', 'SGH-E230L'),
(2731, 'SGH-E236', 'SGH-E236', 'SGH-E236'),
(2732, 'SGH-E250', 'SGH-E250', 'SGH-E250'),
(2733, 'SGH E250i', 'SGH E250i', 'SGH E250i'),
(2734, 'SGH-E251L', 'SGH-E251L', 'SGH-E251L'),
(2735, 'SGH-E256', 'SGH-E256', 'SGH-E256'),
(2736, 'SGH-E258', 'SGH-E258', 'SGH-E258'),
(2737, 'SGH-E320', 'SGH-E320', 'SGH-E320'),
(2738, 'SGH-E330', 'SGH-E330', 'SGH-E330'),
(2739, 'SGH-E330C', 'SGH-E330C', 'SGH-E330C'),
(2740, 'SGH-E330N', 'SGH-E330N', 'SGH-E330N'),
(2741, 'SGH-E335', 'SGH-E335', 'SGH-E335'),
(2742, 'SGH-E338', 'SGH-E338', 'SGH-E338'),
(2743, 'SGH-E340', 'SGH-E340', 'SGH-E340'),
(2744, 'SGH-E350', 'SGH-E350', 'SGH-E350'),
(2745, 'SGH-E350E', 'SGH-E350E', 'SGH-E350E'),
(2746, 'SGH-E350V', 'SGH-E350V', 'SGH-E350V'),
(2747, 'SGH-E351', 'SGH-E351', 'SGH-E351'),
(2748, 'SGH-E351L', 'SGH-E351L', 'SGH-E351L'),
(2749, 'SGH-E356', 'SGH-E356', 'SGH-E356'),
(2750, 'SGH-E358', 'SGH-E358', 'SGH-E358'),
(2751, 'SGH-E360', 'SGH-E360', 'SGH-E360'),
(2752, 'SGH-E370', 'SGH-E370', 'SGH-E370'),
(2753, 'SGH-E376', 'SGH-E376', 'SGH-E376'),
(2754, 'SGH E378', 'SGH E378', 'SGH E378'),
(2755, 'SGH E380', 'SGH E380', 'SGH E380'),
(2756, 'SGH-E390', 'SGH-E390', 'SGH-E390'),
(2757, 'SGH-E398', 'SGH-E398', 'SGH-E398'),
(2758, 'SGH-E420', 'SGH-E420', 'SGH-E420'),
(2759, 'SGH-E428', 'SGH-E428', 'SGH-E428'),
(2760, 'SGH-E480', 'SGH-E480', 'SGH-E480'),
(2761, 'SGH-E500', 'SGH-E500', 'SGH-E500'),
(2762, 'SGH-E590', 'SGH-E590', 'SGH-E590'),
(2763, 'SGH-E620', 'SGH-E620', 'SGH-E620'),
(2764, 'SGH-E630', 'SGH-E630', 'SGH-E630'),
(2765, 'SGH-E630C', 'SGH-E630C', 'SGH-E630C'),
(2766, 'SGH-E635', 'SGH-E635', 'SGH-E635'),
(2767, 'SGH-E638', 'SGH-E638', 'SGH-E638'),
(2768, 'SGH-E640', 'SGH-E640', 'SGH-E640'),
(2769, 'SGH-E690', 'SGH-E690', 'SGH-E690'),
(2770, 'SGH-E700', 'SGH-E700', 'SGH-E700'),
(2771, 'SGH-E700A', 'SGH-E700A', 'SGH-E700A'),
(2772, 'SGH-E708', 'SGH-E708', 'SGH-E708'),
(2773, 'SGH-E730', 'SGH-E730', 'SGH-E730'),
(2774, 'SGH-E736', 'SGH-E736', 'SGH-E736'),
(2775, 'SGH-E738', 'SGH-E738', 'SGH-E738'),
(2776, 'SGH-E740', 'SGH-E740', 'SGH-E740'),
(2777, 'SGH-E746', 'SGH-E746', 'SGH-E746'),
(2778, 'SGH-E747', 'SGH-E747', 'SGH-E747'),
(2779, 'SGH E750', 'SGH E750', 'SGH E750'),
(2780, 'SGH-E758', 'SGH-E758', 'SGH-E758'),
(2781, 'SGH E760', 'SGH E760', 'SGH E760'),
(2782, 'SGH-E768', 'SGH-E768', 'SGH-E768'),
(2783, 'SGH-E770', 'SGH-E770', 'SGH-E770'),
(2784, 'SGH-E780', 'SGH-E780', 'SGH-E780'),
(2785, 'SGH-E800', 'SGH-E800', 'SGH-E800'),
(2786, 'SGH-E800C', 'SGH-E800C', 'SGH-E800C'),
(2787, 'SGH-E800N', 'SGH-E800N', 'SGH-E800N'),
(2788, 'SGH-E808', 'SGH-E808', 'SGH-E808'),
(2789, 'SGH-E820', 'SGH-E820', 'SGH-E820'),
(2790, 'SGH-E820N', 'SGH-E820N', 'SGH-E820N'),
(2791, 'SGH-E830', 'SGH-E830', 'SGH-E830'),
(2792, 'SGH-E838', 'SGH-E838', 'SGH-E838'),
(2793, 'SGH-E840', 'SGH-E840', 'SGH-E840'),
(2794, 'SGH-E848', 'SGH-E848', 'SGH-E848'),
(2795, 'SGH-E890', 'SGH-E890', 'SGH-E890'),
(2796, 'SGH-E908', 'SGH-E908', 'SGH-E908'),
(2797, 'SGH-E958', 'SGH-E958', 'SGH-E958'),
(2798, 'SGH-F110', 'SGH-F110', 'SGH-F110'),
(2799, 'SGH-F218', 'SGH-F218', 'SGH-F218'),
(2800, 'SGH-F250', 'SGH-F250', 'SGH-F250'),
(2801, 'SGH-F250L', 'SGH-F250L', 'SGH-F250L'),
(2802, 'SGH-F258', 'SGH-F258', 'SGH-F258'),
(2803, 'SGH-F265L', 'SGH-F265L', 'SGH-F265L'),
(2804, 'SGH-F266', 'SGH-F266', 'SGH-F266'),
(2805, 'SGH F268', 'SGH F268', 'SGH F268'),
(2806, 'Beat', 'SGH-F270', 'Beat SGH-F270'),
(2807, 'SGH-F300', 'SGH-F300', 'SGH-F300'),
(2808, 'SGH-F308', 'SGH-F308', 'SGH-F308'),
(2809, 'SGH-F330', 'SGH-F330', 'SGH-F330'),
(2810, 'SGH-F338', 'SGH-F338', 'SGH-F338'),
(2811, 'SGH-F400', 'SGH-F400', 'SGH-F400'),
(2812, 'SGH-F480', 'SGH-F480', 'SGH-F480'),
(2813, 'SGH-F480V', 'SGH-F480V', 'SGH-F480V'),
(2814, 'SGH F480i', 'SGH F480i', 'SGH F480i'),
(2815, 'SGH F480L', 'SGH F480L', 'SGH F480L'),
(2816, 'SGH-F480T', 'SGH-F480T', 'SGH-F480T'),
(2817, 'TOUCHWiZ', 'SGH-F488', 'TOUCHWiZ SGH-F488'),
(2818, 'SGH-F488I', 'SGH-F488I', 'SGH-F488I'),
(2819, 'SGH-F490', 'SGH-F490', 'SGH-F490'),
(2820, 'SGH-F700', 'SGH-F700', 'SGH-F700'),
(2821, 'Soul', 'SGH G400', 'Soul SGH G400'),
(2822, 'SGH-G600', 'SGH-G600', 'SGH-G600'),
(2823, 'SGH-G608', 'SGH-G608', 'SGH-G608'),
(2824, 'SGH-G800', 'SGH-G800', 'SGH-G800'),
(2825, 'SGH-I320N', 'SGH-I320N', 'SGH-I320N'),
(2826, 'BlackJack', 'SGH-i607', 'BlackJack SGH-i607'),
(2827, 'Jack', 'SGH-i616', 'Jack SGH-i616'),
(2828, 'BlackJack II', 'SGH I617', 'BlackJack II SGH I617'),
(2829, 'Propel Pro/Jack Frost', 'SGH I627', 'Propel Pro/Jack Frost SGH I627'),
(2830, 'SGH I627', 'SGH I627', 'SGH I627'),
(2831, 'BlackJack', 'SGH-i637', 'BlackJack SGH-i637'),
(2832, 'SGH-i710', 'SGH-i710', 'SGH-i710'),
(2833, 'SGH-i750', 'SGH-i750', 'SGH-i750'),
(2834, 'SGH-I8315', 'SGH-I8315', 'SGH-I8315'),
(2835, 'Epix', 'SGH-I907', 'Epix SGH-I907'),
(2836, 'SGH-J150', 'SGH-J150', 'SGH-J150'),
(2837, 'SGH-J160', 'SGH-J160', 'SGH-J160'),
(2838, 'SGH-J200', 'SGH-J200', 'SGH-J200'),
(2839, 'SGH-J208', 'SGH-J208', 'SGH-J208'),
(2840, 'SGH-J210', 'SGH-J210', 'SGH-J210'),
(2841, 'SGH-J400', 'SGH-J400', 'SGH-J400'),
(2842, 'SGH-J618', 'SGH-J618', 'SGH-J618'),
(2843, 'SGH-J630', 'SGH-J630', 'SGH-J630'),
(2844, 'SGH-J700L', 'SGH-J700L', 'SGH-J700L'),
(2845, 'SGH-J700', 'SGH-J700', 'SGH-J700'),
(2846, 'SGH J700i', 'SGH J700i', 'SGH J700i'),
(2847, 'SGH-J706', 'SGH-J706', 'SGH-J706'),
(2848, 'SGH J708i', 'SGH J708i', 'SGH J708i'),
(2849, 'SGH-J750', 'SGH-J750', 'SGH-J750'),
(2850, 'SGH-J770', 'SGH-J770', 'SGH-J770'),
(2851, 'Luxe', 'SGH-J800', 'Luxe SGH-J800'),
(2852, 'Luxe', 'SGH-J808', 'Luxe SGH-J808'),
(2853, 'SGH-L170', 'SGH-L170', 'SGH-L170'),
(2854, 'SGH-L310', 'SGH-L310', 'SGH-L310'),
(2855, 'SGH-L600', 'SGH-L600', 'SGH-L600'),
(2856, 'SGH-L700', 'SGH-L700', 'SGH-L700'),
(2857, 'SGH L700', 'SGH L700', 'SGH L700'),
(2858, 'SGH L708', 'SGH L708', 'SGH L708'),
(2859, 'SGH-L708E', 'SGH-L708E', 'SGH-L708E'),
(2860, 'SGH-L750', 'SGH-L750', 'SGH-L750'),
(2861, 'SGH-L760', 'SGH-L760', 'SGH-L760'),
(2862, 'SGH L768', 'SGH L768', 'SGH L768'),
(2863, 'SGH L770', 'SGH L770', 'SGH L770'),
(2864, 'SGH-L770V', 'SGH-L770V', 'SGH-L770V'),
(2865, 'SGH L810V', 'SGH L810V', 'SGH L810V'),
(2866, 'SGH L811', 'SGH L811', 'SGH L811'),
(2867, 'SGH-L878', 'SGH-L878', 'SGH-L878'),
(2868, 'Solid', 'SGH-M110', 'Solid SGH-M110'),
(2869, 'SGH-M130L', 'SGH-M130L', 'SGH-M130L'),
(2870, 'SGH-M140L', 'SGH-M140L', 'SGH-M140L'),
(2871, 'SGH M150', 'SGH M150', 'SGH M150'),
(2872, 'SGH M200', 'SGH M200', 'SGH M200'),
(2873, 'SGH-M610', 'SGH-M610', 'SGH-M610'),
(2874, 'SGH M628', 'SGH M628', 'SGH M628'),
(2875, 'PIXON', 'SGH-M8800', 'PIXON SGH-M8800'),
(2876, 'SGH-N100', 'SGH-N100', 'SGH-N100'),
(2877, 'SGH-N105', 'SGH-N105', 'SGH-N105'),
(2878, 'SGH-N188', 'SGH-N188', 'SGH-N188'),
(2879, 'SGH N200', 'SGH N200', 'SGH N200'),
(2880, 'SGH-N288', 'SGH-N288', 'SGH-N288'),
(2881, 'SGH-N300', 'SGH-N300', 'SGH-N300'),
(2882, 'SGH-N400', 'SGH-N400', 'SGH-N400'),
(2883, 'SGH-N500', 'SGH-N500', 'SGH-N500'),
(2884, 'SGH-N600', 'SGH-N600', 'SGH-N600'),
(2885, 'SGH-N620', 'SGH-N620', 'SGH-N620'),
(2886, 'SGH-N620E', 'SGH-N620E', 'SGH-N620E'),
(2887, 'SGH-N628', 'SGH-N628', 'SGH-N628'),
(2888, 'SGH-P180', 'SGH-P180', 'SGH-P180'),
(2889, 'P200', 'P200', 'P200'),
(2890, 'SGH-P220', 'SGH-P220', 'SGH-P220'),
(2891, 'SGH P250', 'SGH P250', 'SGH P250'),
(2892, 'SGH-P260', 'SGH-P260', 'SGH-P260'),
(2893, 'SGH-P308', 'SGH-P308', 'SGH-P308'),
(2894, 'SGH-P400', 'SGH-P400', 'SGH-P400'),
(2895, 'SGH-P500', 'SGH-P500', 'SGH-P500'),
(2896, 'SGH-P850', 'SGH-P850', 'SGH-P850'),
(2897, 'SGH-P906', 'SGH-P906', 'SGH-P906'),
(2898, 'SGH-P910', 'SGH-P910', 'SGH-P910'),
(2899, 'SGH-P920', 'SGH-P920', 'SGH-P920'),
(2900, 'SGH-P930', 'SGH-P930', 'SGH-P930'),
(2901, 'SGH-P940', 'SGH-P940', 'SGH-P940'),
(2902, 'SGH P960', 'SGH P960', 'SGH P960'),
(2903, 'SGH-Q100', 'SGH-Q100', 'SGH-Q100'),
(2904, 'SGH-R200', 'SGH-R200', 'SGH-R200'),
(2905, 'SGH-R200S', 'SGH-R200S', 'SGH-R200S'),
(2906, 'SGH-R210', 'SGH-R210', 'SGH-R210'),
(2907, 'SGH-R210S', 'SGH-R210S', 'SGH-R210S'),
(2908, 'SGH-R220', 'SGH-R220', 'SGH-R220'),
(2909, 'SGH-R225m', 'SGH-R225m', 'SGH-R225m'),
(2910, 'SGH S366', 'SGH S366', 'SGH S366'),
(2911, 'SGH-S500', 'SGH-S500', 'SGH-S500'),
(2912, 'SGH-S508', 'SGH-S508', 'SGH-S508'),
(2913, 'SGH-T100', 'SGH-T100', 'SGH-T100'),
(2914, 'SGH-T101G', 'SGH-T101G', 'SGH-T101G'),
(2915, 'SGH-T108', 'SGH-T108', 'SGH-T108'),
(2916, 'SGH-T109', 'SGH-T109', 'SGH-T109'),
(2917, 'SGH T119', 'SGH T119', 'SGH T119'),
(2918, 'SGH T139', 'SGH T139', 'SGH T139'),
(2919, 'SGH-T155G', 'SGH-T155G', 'SGH-T155G'),
(2920, 'SGH-T200', 'SGH-T200', 'SGH-T200'),
(2921, 'SGH-T201G', 'SGH-T201G', 'SGH-T201G'),
(2922, 'SGH-T209', 'SGH-T209', 'SGH-T209'),
(2923, 'SGH-T209R', 'SGH-T209R', 'SGH-T209R'),
(2924, 'SGH-T219', 'SGH-T219', 'SGH-T219'),
(2925, 'SGH-T219S', 'SGH-T219S', 'SGH-T219S'),
(2926, 'SGH-T229', 'SGH-T229', 'SGH-T229'),
(2927, 'SGH-T239', 'SGH-T239', 'SGH-T239'),
(2928, 'SGH-T245G', 'SGH-T245G', 'SGH-T245G'),
(2929, 'SGH-T249', 'SGH-T249', 'SGH-T249'),
(2930, 'SGH-T255G', 'SGH-T255G', 'SGH-T255G'),
(2931, 'SGH-T301G', 'SGH-T301G', 'SGH-T301G'),
(2932, 'SGH-T309', 'SGH-T309', 'SGH-T309'),
(2933, 'SGH-T319', 'SGH-T319', 'SGH-T319'),
(2934, 'SGH-T319R', 'SGH-T319R', 'SGH-T319R'),
(2935, 'Stripe', 'SGH-T329', 'Stripe SGH-T329'),
(2936, 'SGH-T336', 'SGH-T336', 'SGH-T336'),
(2937, 'SGH-T339', 'SGH-T339', 'SGH-T339'),
(2938, 'SGH-T340G', 'SGH-T340G', 'SGH-T340G'),
(2939, 'SGH-T349', 'SGH-T349', 'SGH-T349'),
(2940, 'SGH T356', 'SGH T356', 'SGH T356'),
(2941, 'Smiley', 'SGH T359', 'Smiley SGH T359'),
(2942, 'SGH-T369', 'SGH-T369', 'SGH-T369'),
(2943, 'SGH-T369R', 'SGH-T369R', 'SGH-T369R'),
(2944, 'SGH-T400', 'SGH-T400', 'SGH-T400'),
(2945, 'SGH-T401G', 'SGH-T401G', 'SGH-T401G'),
(2946, 'SGH-T404G', 'SGH-T404G', 'SGH-T404G'),
(2947, 'SGH T406', 'SGH T406', 'SGH T406'),
(2948, 'SGH-T408', 'SGH-T408', 'SGH-T408'),
(2949, 'SGH-T409', 'SGH-T409', 'SGH-T409'),
(2950, 'SGH-T410', 'SGH-T410', 'SGH-T410'),
(2951, 'SGH-T419', 'SGH-T419', 'SGH-T419'),
(2952, 'SGH-T429', 'SGH-T429', 'SGH-T429'),
(2953, 'SGH-T439', 'SGH-T439', 'SGH-T439'),
(2954, 'SGH-T456', 'SGH-T456', 'SGH-T456'),
(2955, 'Gravity', 'SGH T459', 'Gravity SGH T459'),
(2956, 'Gravity2', 'SGH T469', 'Gravity2 SGH T469'),
(2957, 'Gravity 3', 'SGH-T479', 'Gravity 3 SGH-T479'),
(2958, 'SGH-T500', 'SGH-T500', 'SGH-T500'),
(2959, 'SGH-T509', 'SGH-T509', 'SGH-T509'),
(2960, 'SGH T509S', 'SGH T509S', 'SGH T509S'),
(2961, 'SGH-T519', 'SGH-T519', 'SGH-T519'),
(2962, 'SGH-T528G', 'SGH-T528G', 'SGH-T528G'),
(2963, 'SGH-T539', 'SGH-T539', 'SGH-T539'),
(2964, 'SGH-T559', 'SGH-T559', 'SGH-T559'),
(2965, 'SGH-T609', 'SGH-T609', 'SGH-T609'),
(2966, 'SGH-T619', 'SGH-T619', 'SGH-T619'),
(2967, 'SGH T629', 'SGH T629', 'SGH T629'),
(2968, 'SGH-T636', 'SGH-T636', 'SGH-T636'),
(2969, 'SGH-T639', 'SGH-T639', 'SGH-T639'),
(2970, 'SGH-T659', 'SGH-T659', 'SGH-T659'),
(2971, 'Gravity T', 'SGH T669', 'Gravity T SGH T669'),
(2972, 'Gravity T', 'SGH-T669B', 'Gravity T SGH-T669B'),
(2973, 'SGH-T709', 'SGH-T709', 'SGH-T709'),
(2974, 'SGH-T719', 'SGH-T719', 'SGH-T719'),
(2975, 'SGH-T729', 'SGH-T729', 'SGH-T729'),
(2976, 'Katalyst', 'SGH-T739', 'Katalyst SGH-T739'),
(2977, 'Impact', 'SGH T746', 'Impact SGH T746'),
(2978, 'Highlight', 'SGH-T749', 'Highlight SGH-T749'),
(2979, 'SGH-T809', 'SGH-T809', 'SGH-T809'),
(2980, 'SGH-T819', 'SGH-T819', 'SGH-T819'),
(2981, 'SGH-T919', 'SGH-T919', 'SGH-T919'),
(2982, 'Samsung T919 Behold', 'SGH-T919', 'Samsung T919 Behold SGH-T919'),
(2983, 'Memoir', 'SGH-T929', 'Memoir SGH-T929'),
(2984, 'SGH-U608', 'SGH-U608', 'SGH-U608'),
(2985, 'SGH U700', 'SGH U700', 'SGH U700'),
(2986, 'SGH-U700V', 'SGH-U700V', 'SGH-U700V'),
(2987, 'SGH-U708', 'SGH-U708', 'SGH-U708'),
(2988, 'SGH-U800', 'SGH-U800', 'SGH-U800'),
(2989, 'SGH U800E', 'SGH U800E', 'SGH U800E'),
(2990, 'SGH-U808E', 'SGH-U808E', 'SGH-U808E'),
(2991, 'SGH U900', 'SGH U900', 'SGH U900'),
(2992, 'SGH-U900V', 'SGH-U900V', 'SGH-U900V'),
(2993, 'SGH-U900', 'SGH-U900', 'SGH-U900'),
(2994, 'SGH-U900L', 'SGH-U900L', 'SGH-U900L'),
(2995, 'SGH-X108', 'SGH-X108', 'SGH-X108'),
(2996, 'SGH-X166', 'SGH-X166', 'SGH-X166'),
(2997, 'SGH-X200', 'SGH-X200', 'SGH-X200'),
(2998, 'SGH-X300', 'SGH-X300', 'SGH-X300'),
(2999, 'SGH-X400', 'SGH-X400', 'SGH-X400'),
(3000, 'SGH-X460', 'SGH-X460', 'SGH-X460'),
(3001, 'SGH-X460C', 'SGH-X460C', 'SGH-X460C'),
(3002, 'SGH-X461', 'SGH-X461', 'SGH-X461'),
(3003, 'SGH-X467', 'SGH-X467', 'SGH-X467'),
(3004, 'SGH-X468', 'SGH-X468', 'SGH-X468'),
(3005, 'SGH X480', 'SGH X480', 'SGH X480'),
(3006, 'SGH-X480C', 'SGH-X480C', 'SGH-X480C'),
(3007, 'SGH-X481', 'SGH-X481', 'SGH-X481'),
(3008, 'SGH-X486', 'SGH-X486', 'SGH-X486'),
(3009, 'SGH-X488', 'SGH-X488', 'SGH-X488'),
(3010, 'SGH-X490', 'SGH-X490', 'SGH-X490'),
(3011, 'SGH-X495', 'SGH-X495', 'SGH-X495'),
(3012, 'SGH-X496', 'SGH-X496', 'SGH-X496'),
(3013, 'SGH-X497', 'SGH-X497', 'SGH-X497'),
(3014, 'SGH X500', 'SGH X500', 'SGH X500'),
(3015, 'SGH-X526', 'SGH-X526', 'SGH-X526'),
(3016, 'SGH-X540', 'SGH-X540', 'SGH-X540'),
(3017, 'SGH-X550', 'SGH-X550', 'SGH-X550'),
(3018, 'SGH-X560L', 'SGH-X560L', 'SGH-X560L'),
(3019, 'SGH-X566', 'SGH-X566', 'SGH-X566'),
(3020, 'SGH-X576', 'SGH-X576', 'SGH-X576'),
(3021, 'SGH-X600', 'SGH-X600', 'SGH-X600'),
(3022, 'SGH-X600A', 'SGH-X600A', 'SGH-X600A'),
(3023, 'SGH-X608', 'SGH-X608', 'SGH-X608'),
(3024, 'SGH-X619', 'SGH-X619', 'SGH-X619'),
(3025, 'SGH-X630', 'SGH-X630', 'SGH-X630'),
(3026, 'SGH-X636', 'SGH-X636', 'SGH-X636'),
(3027, 'SGH X640', 'SGH X640', 'SGH X640'),
(3028, 'SGH X650', 'SGH X650', 'SGH X650'),
(3029, 'SGH-X656', 'SGH-X656', 'SGH-X656'),
(3030, 'SGH-X660', 'SGH-X660', 'SGH-X660'),
(3031, 'SGH X660', 'SGH X660', 'SGH X660'),
(3032, 'SGH-X670', 'SGH-X670', 'SGH-X670'),
(3033, 'SGH X680', 'SGH X680', 'SGH X680'),
(3034, 'SGH-X700', 'SGH-X700', 'SGH-X700'),
(3035, 'SGH-X708', 'SGH-X708', 'SGH-X708'),
(3036, 'SGH-X820', 'SGH-X820', 'SGH-X820'),
(3037, 'SGH-X830', 'SGH-X830', 'SGH-X830'),
(3038, 'SGH-Z140', 'SGH-Z140', 'SGH-Z140'),
(3039, 'SGH-Z150', 'SGH-Z150', 'SGH-Z150'),
(3040, 'SGH-Z170', 'SGH-Z170', 'SGH-Z170'),
(3041, 'SGH Z230', 'SGH Z230', 'SGH Z230'),
(3042, 'SGH-Z240', 'SGH-Z240', 'SGH-Z240'),
(3043, 'SGH-Z240E', 'SGH-Z240E', 'SGH-Z240E'),
(3044, 'Z310', 'Z310', 'Z310'),
(3045, 'SGH-Z360', 'SGH-Z360', 'SGH-Z360'),
(3046, 'SGH-Z370', 'SGH-Z370', 'SGH-Z370'),
(3047, 'SGH-Z400', 'SGH-Z400', 'SGH-Z400'),
(3048, 'SGH-Z400V', 'SGH-Z400V', 'SGH-Z400V'),
(3049, 'SGH-Z500', 'SGH-Z500', 'SGH-Z500'),
(3050, 'Z510', 'Z510', 'Z510'),
(3051, 'Z520', 'Z520', 'Z520'),
(3052, 'Z540', 'Z540', 'Z540'),
(3053, 'SGH-Z548', 'SGH-Z548', 'SGH-Z548'),
(3054, 'Z560', 'Z560', 'Z560'),
(3055, 'SGH Z560', 'SGH Z560', 'SGH Z560'),
(3056, 'SGH-Z620', 'SGH-Z620', 'SGH-Z620'),
(3057, 'SGH-Z630', 'SGH-Z630', 'SGH-Z630'),
(3058, 'SGH-Z720', 'SGH-Z720', 'SGH-Z720'),
(3059, 'Joy McLaren Vodafone', 'SGH-Z720M', 'Joy McLaren Vodafone SGH-Z720M'),
(3060, 'SGH-ZV10', 'SGH-ZV10', 'SGH-ZV10'),
(3061, 'ZV30', 'ZV30', 'ZV30'),
(3062, 'ZV40', 'ZV40', 'ZV40'),
(3063, 'ZV50', 'ZV50', 'ZV50'),
(3064, 'SGH-ZV60', 'SGH-ZV60', 'SGH-ZV60'),
(3065, 'SGH i200', 'SGH i200', 'SGH i200'),
(3066, 'SGH-i608', 'SGH-i608', 'SGH-i608'),
(3067, 'SGH-i688', 'SGH-i688', 'SGH-i688'),
(3068, 'SGH-I718', 'SGH-I718', 'SGH-I718'),
(3069, 'SGH-I718 Plus', 'SGH-I718 Plus', 'SGH-I718 Plus'),
(3070, 'SGH i728', 'SGH i728', 'SGH i728'),
(3071, 'SGH i740', 'SGH i740', 'SGH i740'),
(3072, 'SGH i780', 'SGH i780', 'SGH i780'),
(3073, 'SGH i780V', 'SGH i780V', 'SGH i780V'),
(3074, 'OMNIA', 'SGH i900v', 'OMNIA SGH i900v'),
(3075, 'Omnia', 'SGH-i908', 'Omnia SGH-i908'),
(3076, 'SGH-C260', 'SGH-C260', 'SGH-C260'),
(3077, 'SGH-P520', 'SGH-P520', 'SGH-P520'),
(3078, 'STH A255', 'STH A255', 'STH A255'),
(3079, 'E860V', 'E860V', 'E860V'),
(3080, 'SCH-A570', 'SCH-A570', 'SCH-A570'),
(3081, 'SCH-A600', 'SCH-A600', 'SCH-A600'),
(3082, 'SCH-A630', 'SCH-A630', 'SCH-A630'),
(3083, 'SCH-A645', 'SCH-A645', 'SCH-A645'),
(3084, 'SCH-A650', 'SCH-A650', 'SCH-A650'),
(3085, 'SCH A670', 'SCH A670', 'SCH A670'),
(3086, 'SCH-A750', 'SCH-A750', 'SCH-A750'),
(3087, 'SCH-A790', 'SCH-A790', 'SCH-A790'),
(3088, 'SCH A815', 'SCH A815', 'SCH A815'),
(3089, 'A850', 'A850', 'A850'),
(3090, 'A870', 'A870', 'A870'),
(3091, 'SCH-A890', 'SCH-A890', 'SCH-A890'),
(3092, 'SCH A915', 'SCH A915', 'SCH A915'),
(3093, 'SCH-A930', 'SCH-A930', 'SCH-A930'),
(3094, 'SCH-A950', 'SCH-A950', 'SCH-A950'),
(3095, 'SCH-A970', 'SCH-A970', 'SCH-A970'),
(3096, 'SCH-E159', 'SCH-E159', 'SCH-E159'),
(3097, 'SCH F309', 'SCH F309', 'SCH F309'),
(3098, 'SCH F339', 'SCH F339', 'SCH F339'),
(3099, 'SCH-F519', 'SCH-F519', 'SCH-F519'),
(3100, 'SGH F679', 'SGH F679', 'SGH F679'),
(3101, 'SCH-F679', 'SCH-F679', 'SCH-F679'),
(3102, 'SCH-N330', 'SCH-N330', 'SCH-N330'),
(3103, 'N415', 'N415', 'N415'),
(3104, 'SCH-N485', 'SCH-N485', 'SCH-N485'),
(3105, 'SCH-R210', 'SCH-R210', 'SCH-R210'),
(3106, 'SCH R211', 'SCH R211', 'SCH R211'),
(3107, 'SCH R300', 'SCH R300', 'SCH R300'),
(3108, 'SCH-R400', 'SCH-R400', 'SCH-R400'),
(3109, 'SCH-R410', 'SCH-R410', 'SCH-R410'),
(3110, 'SCH-R430', 'SCH-R430', 'SCH-R430'),
(3111, 'SCH-R500', 'SCH-R500', 'SCH-R500'),
(3112, 'SCH-R510', 'SCH-R510', 'SCH-R510'),
(3113, 'SCH R600', 'SCH R600', 'SCH R600'),
(3114, 'R610', 'R610', 'R610'),
(3115, 'SCH-S169', 'SCH-S169', 'SCH-S169'),
(3116, 'S179', 'S179', 'S179'),
(3117, 'SCH-S259', 'SCH-S259', 'SCH-S259'),
(3118, 'SCH S319', 'SCH S319', 'SCH S319'),
(3119, 'SCH-U340', 'SCH-U340', 'SCH-U340'),
(3120, 'Smooth', 'SCH U350', 'Smooth SCH U350'),
(3121, 'SCH-U360', 'SCH-U360', 'SCH-U360'),
(3122, 'Gusto 2', 'SCH-U365', 'Gusto 2 SCH-U365'),
(3123, 'SCH-U410', 'SCH-U410', 'SCH-U410'),
(3124, 'SCH-U410T', 'SCH-U410T', 'SCH-U410T'),
(3125, 'SCH-U420', 'SCH-U420', 'SCH-U420'),
(3126, 'SCH-U430', 'SCH-U430', 'SCH-U430'),
(3127, 'Intensity', 'SCH U450', 'Intensity SCH U450'),
(3128, 'SCH U490', 'SCH U490', 'SCH U490'),
(3129, 'SCH-U510', 'SCH-U510', 'SCH-U510'),
(3130, 'SCH-U520', 'SCH-U520', 'SCH-U520'),
(3131, 'SCH-U540', 'SCH-U540', 'SCH-U540'),
(3132, 'SCH-U550', 'SCH-U550', 'SCH-U550'),
(3133, 'SCH-U620', 'SCH-U620', 'SCH-U620'),
(3134, 'Convoy', 'SCH U640', 'Convoy SCH U640'),
(3135, 'SCH U650', 'SCH U650', 'SCH U650'),
(3136, 'SCH U700', 'SCH U700', 'SCH U700'),
(3137, 'Muse', 'SCH-U706', 'Muse SCH-U706'),
(3138, 'Alias', 'SCH U740', 'Alias SCH U740'),
(3139, 'Alias 2', 'SCH U750', 'Alias 2 SCH U750'),
(3140, 'Renown', 'SCH U810', 'Renown SCH U810'),
(3141, 'SCH U900', 'SCH U900', 'SCH U900'),
(3142, 'SCH-W109', 'SCH-W109', 'SCH-W109'),
(3143, 'SCH W399', 'SCH W399', 'SCH W399'),
(3144, 'SCH-W569', 'SCH-W569', 'SCH-W569'),
(3145, 'SCH-W579', 'SCH-W579', 'SCH-W579'),
(3146, 'SCH-W619', 'SCH-W619', 'SCH-W619'),
(3147, 'SCH-X839', 'SCH-X839', 'SCH-X839'),
(3148, 'SCH-X859', 'SCH-X859', 'SCH-X859'),
(3149, 'SCH N181', 'SCH N181', 'SCH N181'),
(3150, 'SCH N362', 'SCH N362', 'SCH N362'),
(3151, 'SCH N392', 'SCH N392', 'SCH N392'),
(3152, 'SCH-A220', 'SCH-A220', 'SCH-A220'),
(3153, 'SGH-A127', 'SGH-A127', 'SGH-A127'),
(3154, 'SGH-A501', 'SGH-A501', 'SGH-A501'),
(3155, 'SGH-B100', 'SGH-B100', 'SGH-B100'),
(3156, 'SGH B120', 'SGH B120', 'SGH B120'),
(3157, 'SGH-B200', 'SGH-B200', 'SGH-B200'),
(3158, 'SGH B220', 'SGH B220', 'SGH B220'),
(3159, 'SGH-B270', 'SGH-B270', 'SGH-B270'),
(3160, 'SGH B300', 'SGH B300', 'SGH B300'),
(3161, 'SGH B310', 'SGH B310', 'SGH B310'),
(3162, 'SGH-B320', 'SGH-B320', 'SGH-B320'),
(3163, 'SGH-B500', 'SGH-B500', 'SGH-B500'),
(3164, 'SGH-B510', 'SGH-B510', 'SGH-B510'),
(3165, 'SGH-B520', 'SGH-B520', 'SGH-B520'),
(3166, 'SGH-C100', 'SGH-C100', 'SGH-C100'),
(3167, 'SGH-C100G', 'SGH-C100G', 'SGH-C100G'),
(3168, 'SGH-C108', 'SGH-C108', 'SGH-C108'),
(3169, 'SGH-C108t', 'SGH-C108t', 'SGH-C108t'),
(3170, 'SGH-C110', 'SGH-C110', 'SGH-C110'),
(3171, 'SGH-C120', 'SGH-C120', 'SGH-C120'),
(3172, 'SGH-C130', 'SGH-C130', 'SGH-C130'),
(3173, 'SGH-C140', 'SGH-C140', 'SGH-C140'),
(3174, 'SGH-C160L', 'SGH-C160L', 'SGH-C160L'),
(3175, 'SGH-C170', 'SGH-C170', 'SGH-C170'),
(3176, 'SGH C200', 'SGH C200', 'SGH C200'),
(3177, 'SGH-C207', 'SGH-C207', 'SGH-C207'),
(3178, 'SGH-C207L', 'SGH-C207L', 'SGH-C207L'),
(3179, 'SGH-C210', 'SGH-C210', 'SGH-C210'),
(3180, 'SGH-C216', 'SGH-C216', 'SGH-C216'),
(3181, 'SGH-C225', 'SGH-C225', 'SGH-C225'),
(3182, 'SGH-C230', 'SGH-C230', 'SGH-C230'),
(3183, 'C250', 'C250', 'C250'),
(3184, 'SGH-C260L', 'SGH-C260L', 'SGH-C260L'),
(3185, 'SGH-C260M', 'SGH-C260M', 'SGH-C260M'),
(3186, 'SGH-C266', 'SGH-C266', 'SGH-C266'),
(3187, 'SGH-C275L', 'SGH-C275L', 'SGH-C275L'),
(3188, 'SGH-C300', 'SGH-C300', 'SGH-C300'),
(3189, 'SGH C320', 'SGH C320', 'SGH C320'),
(3190, 'SGH-C500', 'SGH-C500', 'SGH-C500'),
(3191, 'SGH-C506', 'SGH-C506', 'SGH-C506'),
(3192, 'SGH-C510', 'SGH-C510', 'SGH-C510'),
(3193, 'SGH-C516', 'SGH-C516', 'SGH-C516'),
(3194, 'SGH-C520', 'SGH-C520', 'SGH-C520'),
(3195, 'SGH-D100', 'SGH-D100', 'SGH-D100'),
(3196, 'SGH-D307', 'SGH-D307', 'SGH-D307'),
(3197, 'SGH-D347', 'SGH-D347', 'SGH-D347'),
(3198, 'SGH-D357', 'SGH-D357', 'SGH-D357'),
(3199, 'SGH-D406', 'SGH-D406', 'SGH-D406'),
(3200, 'SGH-D407', 'SGH-D407', 'SGH-D407'),
(3201, 'SGH-D410', 'SGH-D410', 'SGH-D410'),
(3202, 'SGH-D410C', 'SGH-D410C', 'SGH-D410C'),
(3203, 'SGH-D415', 'SGH-D415', 'SGH-D415'),
(3204, 'SGH-D418', 'SGH-D418', 'SGH-D418'),
(3205, 'SGH-D428', 'SGH-D428', 'SGH-D428'),
(3206, 'SGH-D710', 'SGH-D710', 'SGH-D710'),
(3207, 'SGH-D720', 'SGH-D720', 'SGH-D720'),
(3208, 'SGH-D800', 'SGH-D800', 'SGH-D800'),
(3209, 'SGH-D807', 'SGH-D807', 'SGH-D807'),
(3210, 'SGH-D836', 'SGH-D836', 'SGH-D836'),
(3211, 'SGH-E105', 'SGH-E105', 'SGH-E105'),
(3212, 'SGH-E116', 'SGH-E116', 'SGH-E116'),
(3213, 'SGH-E210', 'SGH-E210', 'SGH-E210'),
(3214, 'SGH-E215L', 'SGH-E215L', 'SGH-E215L'),
(3215, 'SGH-E217', 'SGH-E217', 'SGH-E217'),
(3216, 'SGH-E300', 'SGH-E300', 'SGH-E300'),
(3217, 'SGH-E310', 'SGH-E310', 'SGH-E310'),
(3218, 'SGH-E315', 'SGH-E315', 'SGH-E315'),
(3219, 'SGH-E316', 'SGH-E316', 'SGH-E316'),
(3220, 'SGH-E317', 'SGH-E317', 'SGH-E317'),
(3221, 'SGH-E318', 'SGH-E318', 'SGH-E318'),
(3222, 'SGH-E400', 'SGH-E400', 'SGH-E400'),
(3223, 'SGH E420', 'SGH E420', 'SGH E420'),
(3224, 'SGH-E490', 'SGH-E490', 'SGH-E490'),
(3225, 'SGH-E496', 'SGH-E496', 'SGH-E496'),
(3226, 'SGH-E530', 'SGH-E530', 'SGH-E530'),
(3227, 'SGH-E530C', 'SGH-E530C', 'SGH-E530C'),
(3228, 'SGH-E570', 'SGH-E570', 'SGH-E570'),
(3229, 'SGH-E570L', 'SGH-E570L', 'SGH-E570L'),
(3230, 'SGH-E576', 'SGH-E576', 'SGH-E576'),
(3231, 'SGH-E600', 'SGH-E600', 'SGH-E600'),
(3232, 'SGH-E600C', 'SGH-E600C', 'SGH-E600C'),
(3233, 'SGH-E608', 'SGH-E608', 'SGH-E608'),
(3234, 'SGH-E610', 'SGH-E610', 'SGH-E610'),
(3235, 'SGH-E618', 'SGH-E618', 'SGH-E618'),
(3236, 'SGH-E710', 'SGH-E710', 'SGH-E710'),
(3237, 'SGH-E710i', 'SGH-E710i', 'SGH-E710i'),
(3238, 'SGH-E715', 'SGH-E715', 'SGH-E715'),
(3239, 'SGH-E720', 'SGH-E720', 'SGH-E720'),
(3240, 'SGH-E720C', 'SGH-E720C', 'SGH-E720C'),
(3241, 'SGH-E790', 'SGH-E790', 'SGH-E790'),
(3242, 'SGH-E810', 'SGH-E810', 'SGH-E810'),
(3243, 'SGH-E810C', 'SGH-E810C', 'SGH-E810C'),
(3244, 'SGH-E818', 'SGH-E818', 'SGH-E818'),
(3245, 'SGH-E850', 'SGH-E850', 'SGH-E850'),
(3246, 'SGH-E870', 'SGH-E870', 'SGH-E870'),
(3247, 'SGH-E880', 'SGH-E880', 'SGH-E880'),
(3248, 'SGH-E900', 'SGH-E900', 'SGH-E900'),
(3249, 'SGH-E906', 'SGH-E906', 'SGH-E906'),
(3250, 'SGH-E910', 'SGH-E910', 'SGH-E910'),
(3251, 'SGH-E950', 'SGH-E950', 'SGH-E950'),
(3252, 'SGH-F200', 'SGH-F200', 'SGH-F200'),
(3253, 'SGH F210', 'SGH F210', 'SGH F210'),
(3254, 'SGH-F210', 'SGH-F210', 'SGH-F210'),
(3255, 'SGH-F900', 'SGH-F900', 'SGH-F900'),
(3256, 'SGH-i300', 'SGH-i300', 'SGH-i300'),
(3257, 'SGH-I310', 'SGH-I310', 'SGH-I310'),
(3258, 'SGH-I320', 'SGH-I320', 'SGH-I320'),
(3259, 'SGH-I400', 'SGH-I400', 'SGH-I400'),
(3260, 'SGH-I700', 'SGH-I700', 'SGH-I700'),
(3261, 'SGH-J600', 'SGH-J600', 'SGH-J600'),
(3262, 'SGH-J600E', 'SGH-J600E', 'SGH-J600E'),
(3263, 'SGH-J610', 'SGH-J610', 'SGH-J610'),
(3264, 'SGH-L320', 'SGH-L320', 'SGH-L320'),
(3265, 'SGH M120', 'SGH M120', 'SGH M120'),
(3266, 'SGH-M300', 'SGH-M300', 'SGH-M300'),
(3267, 'SGH M310', 'SGH M310', 'SGH M310'),
(3268, 'SGH-M600', 'SGH-M600', 'SGH-M600'),
(3269, 'SGH-M620', 'SGH-M620', 'SGH-M620'),
(3270, 'SGH-N350', 'SGH-N350', 'SGH-N350'),
(3271, 'SGH-N625', 'SGH-N625', 'SGH-N625'),
(3272, 'SGH-N700', 'SGH-N700', 'SGH-N700'),
(3273, 'SGH-P100', 'SGH-P100', 'SGH-P100'),
(3274, 'SGH-P107', 'SGH-P107', 'SGH-P107'),
(3275, 'SGH-P108', 'SGH-P108', 'SGH-P108'),
(3276, 'SGH-P207', 'SGH-P207', 'SGH-P207'),
(3277, 'SGH-P300', 'SGH-P300', 'SGH-P300'),
(3278, 'SGH-P310', 'SGH-P310', 'SGH-P310'),
(3279, 'SGH-P408', 'SGH-P408', 'SGH-P408'),
(3280, 'SGH-P510', 'SGH-P510', 'SGH-P510'),
(3281, 'SGH-P518', 'SGH-P518', 'SGH-P518'),
(3282, 'SGH-P700', 'SGH-P700', 'SGH-P700');
INSERT INTO `smdevicenames` (`DeviceNameID`, `DeviceName`, `DeviceModel`, `MarketingName`) VALUES
(3283, 'SGH P705', 'SGH P705', 'SGH P705'),
(3284, 'SGH-P710', 'SGH-P710', 'SGH-P710'),
(3285, 'SGH-P716', 'SGH-P716', 'SGH-P716'),
(3286, 'SGH-P730', 'SGH-P730', 'SGH-P730'),
(3287, 'SGH-P730C', 'SGH-P730C', 'SGH-P730C'),
(3288, 'SGH-P735', 'SGH-P735', 'SGH-P735'),
(3289, 'SGH-P738', 'SGH-P738', 'SGH-P738'),
(3290, 'SGH-P777', 'SGH-P777', 'SGH-P777'),
(3291, 'SGH-P900', 'SGH-P900', 'SGH-P900'),
(3292, 'SGH Q100', 'SGH Q100', 'SGH Q100'),
(3293, 'SGH-Q105', 'SGH-Q105', 'SGH-Q105'),
(3294, 'SGH-Q200', 'SGH-Q200', 'SGH-Q200'),
(3295, 'SGH-S100', 'SGH-S100', 'SGH-S100'),
(3296, 'SGH-S105', 'SGH-S105', 'SGH-S105'),
(3297, 'SGH-S108', 'SGH-S108', 'SGH-S108'),
(3298, 'SGH-S200', 'SGH-S200', 'SGH-S200'),
(3299, 'SGH-S205', 'SGH-S205', 'SGH-S205'),
(3300, 'SGH-S208', 'SGH-S208', 'SGH-S208'),
(3301, 'SGH-S300', 'SGH-S300', 'SGH-S300'),
(3302, 'S300M', 'S300M', 'S300M'),
(3303, 'SGH-S307', 'SGH-S307', 'SGH-S307'),
(3304, 'SGH-S308', 'SGH-S308', 'SGH-S308'),
(3305, 'SGH-U100', 'SGH-U100', 'SGH-U100'),
(3306, 'SGH-U300', 'SGH-U300', 'SGH-U300'),
(3307, 'SGH-U600', 'SGH-U600', 'SGH-U600'),
(3308, 'Ultra Edition 10.9', 'SGH-U600', 'Ultra Edition 10.9 SGH-U600'),
(3309, 'SGH-V100', 'SGH-V100', 'SGH-V100'),
(3310, 'SGH-V200', 'SGH-V200', 'SGH-V200'),
(3311, 'SGH-V205', 'SGH-V205', 'SGH-V205'),
(3312, 'SGH-V206', 'SGH-V206', 'SGH-V206'),
(3313, 'SGH-V208', 'SGH-V208', 'SGH-V208'),
(3314, 'SGH-X105', 'SGH-X105', 'SGH-X105'),
(3315, 'SGH-X120', 'SGH-X120', 'SGH-X120'),
(3316, 'SGH-X140', 'SGH-X140', 'SGH-X140'),
(3317, 'SGH-X150L', 'SGH-X150L', 'SGH-X150L'),
(3318, 'SGH-X160', 'SGH-X160', 'SGH-X160'),
(3319, 'SGH-X210', 'SGH-X210', 'SGH-X210'),
(3320, 'SGH-X426', 'SGH-X426', 'SGH-X426'),
(3321, 'SGH-X427', 'SGH-X427', 'SGH-X427'),
(3322, 'SGH-X427m', 'SGH-X427m', 'SGH-X427m'),
(3323, 'SGH-X430', 'SGH-X430', 'SGH-X430'),
(3324, 'SGH X450', 'SGH X450', 'SGH X450'),
(3325, 'SGH-X458', 'SGH-X458', 'SGH-X458'),
(3326, 'SGH-X466', 'SGH-X466', 'SGH-X466'),
(3327, 'SGH-X475', 'SGH-X475', 'SGH-X475'),
(3328, 'SGH-X506', 'SGH-X506', 'SGH-X506'),
(3329, 'SGH-X507', 'SGH-X507', 'SGH-X507'),
(3330, 'SGH-X510', 'SGH-X510', 'SGH-X510'),
(3331, 'X530', 'X530', 'X530'),
(3332, 'SGH-X610', 'SGH-X610', 'SGH-X610'),
(3333, 'SGH-X680', 'SGH-X680', 'SGH-X680'),
(3334, 'SGH-X686', 'SGH-X686', 'SGH-X686'),
(3335, 'SGH-X800', 'SGH-X800', 'SGH-X800'),
(3336, 'SGH-X810', 'SGH-X810', 'SGH-X810'),
(3337, 'SGh-X836', 'SGh-X836', 'SGh-X836'),
(3338, 'X910', 'X910', 'X910'),
(3339, 'SGH-ZX10', 'SGH-ZX10', 'SGH-ZX10'),
(3340, 'SGH-ZX20', 'SGH-ZX20', 'SGH-ZX20'),
(3341, 'SGH i505', 'SGH i505', 'SGH i505'),
(3342, 'SPH A520', 'SPH A520', 'SPH A520'),
(3343, 'SPH A540', 'SPH A540', 'SPH A540'),
(3344, 'SPH-N300', 'SPH-N300', 'SPH-N300'),
(3345, 'SCH-A310', 'SCH-A310', 'SCH-A310'),
(3346, 'SCH A530', 'SCH A530', 'SCH A530'),
(3347, 'SCH A561', 'SCH A561', 'SCH A561'),
(3348, 'SCH A605', 'SCH A605', 'SCH A605'),
(3349, 'SCH A610', 'SCH A610', 'SCH A610'),
(3350, 'SCH-A655', 'SCH-A655', 'SCH-A655'),
(3351, 'SCH-A670', 'SCH-A670', 'SCH-A670'),
(3352, 'SCH i519', 'SCH i519', 'SCH i519'),
(3353, 'SCH-N170', 'SCH-N170', 'SCH-N170'),
(3354, 'SCH N171', 'SCH N171', 'SCH N171'),
(3355, 'SCH N255', 'SCH N255', 'SCH N255'),
(3356, 'SCH-N370', 'SCH-N370', 'SCH-N370'),
(3357, 'SCH-X199', 'SCH-X199', 'SCH-X199'),
(3358, 'SGH-X339', 'SGH-X339', 'SGH-X339'),
(3359, 'SGH-X359', 'SGH-X359', 'SGH-X359'),
(3360, 'SGH-X369', 'SGH-X369', 'SGH-X369'),
(3361, 'X609', 'X609', 'X609'),
(3362, 'SCH-X659', 'SCH-X659', 'SCH-X659'),
(3363, 'SPH A400', 'SPH A400', 'SPH A400'),
(3364, 'SPH-A460', 'SPH-A460', 'SPH-A460'),
(3365, 'SPH-A500', 'SPH-A500', 'SPH-A500'),
(3366, 'SPH A505', 'SPH A505', 'SPH A505'),
(3367, 'SGH-A401', 'SGH-A401', 'SGH-A401'),
(3368, 'SGH-F310', 'SGH-F310', 'SGH-F310'),
(3369, 'SGH-F500', 'SGH-F500', 'SGH-F500'),
(3370, 'F510', 'F510', 'F510'),
(3371, 'SGH-Z107', 'SGH-Z107', 'SGH-Z107'),
(3372, 'Z130', 'Z130', 'Z130'),
(3373, 'SGH-Z220', 'SGH-Z220', 'SGH-Z220'),
(3374, 'SGH-Z300', 'SGH-Z300', 'SGH-Z300'),
(3375, 'SGH-Z308', 'SGH-Z308', 'SGH-Z308'),
(3376, 'SGH-Z500V', 'SGH-Z500V', 'SGH-Z500V'),
(3377, 'SGH-Z550', 'SGH-Z550', 'SGH-Z550'),
(3378, 'SGH-Z600', 'SGH-Z600', 'SGH-Z600'),
(3379, 'SGH-Z630B', 'SGH-Z630B', 'SGH-Z630B'),
(3380, 'SGH-Z710', 'SGH-Z710', 'SGH-Z710'),
(3381, 'SGH-Z800', 'SGH-Z800', 'SGH-Z800'),
(3382, 'SGH-ZM60', 'SGH-ZM60', 'SGH-ZM60'),
(3383, 'SPH-A523', 'SPH-A523', 'SPH-A523'),
(3384, 'SPH-A720', 'SPH-A720', 'SPH-A720'),
(3385, 'SPH-A820', 'SPH-A820', 'SPH-A820'),
(3386, 'SPH-A880', 'SPH-A880', 'SPH-A880'),
(3387, 'SPH E119', 'SPH E119', 'SPH E119'),
(3388, 'SPH-M210', 'SPH-M210', 'SPH-M210'),
(3389, 'SPH-M310', 'SPH-M310', 'SPH-M310'),
(3390, 'Mantra', 'SPH M340', 'Mantra SPH M340'),
(3391, 'SPH-M540', 'SPH-M540', 'SPH-M540'),
(3392, 'Restore', 'SPH-M575', 'Restore SPH-M575'),
(3393, 'SPH-M620', 'SPH-M620', 'SPH-M620'),
(3394, 'Instinct', 'SPH-M800', 'Instinct SPH-M800'),
(3395, 'SGH BC01', 'SGH BC01', 'SGH BC01'),
(3396, 'MM-A900 (SPH-A900)', 'MM-A900 (SPH-A900)', 'MM-A900 (SPH-A900)'),
(3397, 'PLS-M520', 'PLS-M520', 'PLS-M520'),
(3398, 'SCH-A900', 'SCH-A900', 'SCH-A900'),
(3399, 'SCH R100', 'SCH R100', 'SCH R100'),
(3400, 'SCH R351', 'SCH R351', 'SCH R351'),
(3401, 'SCH R561', 'SCH R561', 'SCH R561'),
(3402, 'SCH-R610', 'SCH-R610', 'SCH-R610'),
(3403, 'Gloss', 'SCH U440', 'Gloss SCH U440'),
(3404, 'SCH-W531', 'SCH-W531', 'SCH-W531'),
(3405, 'SGH-i458', 'SGH-i458', 'SGH-i458'),
(3406, 'SPH-A560', 'SPH-A560', 'SPH-A560'),
(3407, 'SPH-A580', 'SPH-A580', 'SPH-A580'),
(3408, 'SPH-A860', 'SPH-A860', 'SPH-A860'),
(3409, 'SPH-A620', 'SPH-A620', 'SPH-A620'),
(3410, 'SPH-A640', 'SPH-A640', 'SPH-A640'),
(3411, 'SPH-A660', 'SPH-A660', 'SPH-A660'),
(3412, 'VM-A680 (SPH-A680)', 'VM-A680 (SPH-A680)', 'VM-A680 (SPH-A680)'),
(3413, 'MM-A700', 'MM-A700', 'MM-A700'),
(3414, 'SPH-A740', 'SPH-A740', 'SPH-A740'),
(3415, 'SPH-A760', 'SPH-A760', 'SPH-A760'),
(3416, 'SPH-A790', 'SPH-A790', 'SPH-A790'),
(3417, 'SPH-A795', 'SPH-A795', 'SPH-A795'),
(3418, 'SPH-A800', 'SPH-A800', 'SPH-A800'),
(3419, 'SPH-A840', 'SPH-A840', 'SPH-A840'),
(3420, 'SPH-A850', 'SPH-A850', 'SPH-A850'),
(3421, 'SPH-A900P', 'SPH-A900P', 'SPH-A900P'),
(3422, 'SPH-A920', 'SPH-A920', 'SPH-A920'),
(3423, 'A940', 'A940', 'A940'),
(3424, 'SPH-A960', 'SPH-A960', 'SPH-A960'),
(3425, 'SPH M220', 'SPH M220', 'SPH M220'),
(3426, 'SPH M230', 'SPH M230', 'SPH M230'),
(3427, 'SPH-M250', 'SPH-M250', 'SPH-M250'),
(3428, 'SPH-M300', 'SPH-M300', 'SPH-M300'),
(3429, 'SPH-M320', 'SPH-M320', 'SPH-M320'),
(3430, 'Seek', 'SPH-M350', 'Seek SPH-M350'),
(3431, 'SPH-M500', 'SPH-M500', 'SPH-M500'),
(3432, 'SPH M510', 'SPH M510', 'SPH M510'),
(3433, 'SPH-M510', 'SPH-M510', 'SPH-M510'),
(3434, 'SPH-M520', 'SPH-M520', 'SPH-M520'),
(3435, 'SPH-M530', 'SPH-M530', 'SPH-M530'),
(3436, 'SPH-M610', 'SPH-M610', 'SPH-M610'),
(3437, 'SPH-M630', 'SPH-M630', 'SPH-M630'),
(3438, 'Instinct', 'SPH M810', 'Instinct SPH M810'),
(3439, 'Z400', 'Z400', 'Z400'),
(3440, 'SPH Z400', 'SPH Z400', 'SPH Z400'),
(3441, 'SGH-C510V', 'SGH-C510V', 'SGH-C510V'),
(3442, 'SCH-V940', 'SCH-V940', 'SCH-V940'),
(3443, 'OmniaPRO4', 'GT B7350', 'OmniaPRO4 GT B7350'),
(3444, 'SGH-J700V', 'SGH-J700V', 'SGH-J700V'),
(3445, 'SGH-M300V', 'SGH-M300V', 'SGH-M300V'),
(3446, 'SGH M310V', 'SGH M310V', 'SGH M310V'),
(3447, 'SGH-E860V', 'SGH-E860V', 'SGH-E860V'),
(3448, 'BlackBerry 7230', 'BlackBerry 7230', 'BlackBerry 7230'),
(3449, 'Curve', 'BlackBerry 8310', 'Curve BlackBerry 8310'),
(3450, 'BlackBerry 857', 'BlackBerry 857', 'BlackBerry 857'),
(3451, 'BlackBerry 950', 'BlackBerry 950', 'BlackBerry 950'),
(3452, 'BlackBerry 957', 'BlackBerry 957', 'BlackBerry 957'),
(3453, 'BlackBerry 5810', 'BlackBerry 5810', 'BlackBerry 5810'),
(3454, 'BlackBerry 5820', 'BlackBerry 5820', 'BlackBerry 5820'),
(3455, 'BlackBerry 6210', 'BlackBerry 6210', 'BlackBerry 6210'),
(3456, 'BlackBerry 6220', 'BlackBerry 6220', 'BlackBerry 6220'),
(3457, 'BlackBerry 6230', 'BlackBerry 6230', 'BlackBerry 6230'),
(3458, 'BlackBerry 6280', 'BlackBerry 6280', 'BlackBerry 6280'),
(3459, 'BlackBerry 6510', 'BlackBerry 6510', 'BlackBerry 6510'),
(3460, 'BlackBerry 6700', 'BlackBerry 6700', 'BlackBerry 6700'),
(3461, 'BlackBerry 6710', 'BlackBerry 6710', 'BlackBerry 6710'),
(3462, 'BlackBerry 6720', 'BlackBerry 6720', 'BlackBerry 6720'),
(3463, 'BlackBerry 6750', 'BlackBerry 6750', 'BlackBerry 6750'),
(3464, 'BlackBerry 7100', 'BlackBerry 7100', 'BlackBerry 7100'),
(3465, 'BlackBerry 7100g', 'BlackBerry 7100g', 'BlackBerry 7100g'),
(3466, 'BlackBerry 7100i', 'BlackBerry 7100i', 'BlackBerry 7100i'),
(3467, 'BlackBerry 7130', 'BlackBerry 7130', 'BlackBerry 7130'),
(3468, 'BlackBerry 7130c', 'BlackBerry 7130c', 'BlackBerry 7130c'),
(3469, 'BlackBerry 7130e', 'BlackBerry 7130e', 'BlackBerry 7130e'),
(3470, 'BlackBerry 7130g', 'BlackBerry 7130g', 'BlackBerry 7130g'),
(3471, 'BlackBerry 7210', 'BlackBerry 7210', 'BlackBerry 7210'),
(3472, 'BlackBerry 7220', 'BlackBerry 7220', 'BlackBerry 7220'),
(3473, 'BlackBerry 7250', 'BlackBerry 7250', 'BlackBerry 7250'),
(3474, 'BlackBerry 7280', 'BlackBerry 7280', 'BlackBerry 7280'),
(3475, 'BlackBerry 7290', 'BlackBerry 7290', 'BlackBerry 7290'),
(3476, 'BlackBerry 7510', 'BlackBerry 7510', 'BlackBerry 7510'),
(3477, 'BlackBerry 7520', 'BlackBerry 7520', 'BlackBerry 7520'),
(3478, 'BlackBerry 7730', 'BlackBerry 7730', 'BlackBerry 7730'),
(3479, 'BlackBerry 7750', 'BlackBerry 7750', 'BlackBerry 7750'),
(3480, 'BlackBerry 7780', 'BlackBerry 7780', 'BlackBerry 7780'),
(3481, 'Pearl', 'BlackBerry 8100', 'Pearl BlackBerry 8100'),
(3482, 'Pearl', 'BlackBerry 8110', 'Pearl BlackBerry 8110'),
(3483, 'BlackBerry 8120', 'BlackBerry 8120', 'BlackBerry 8120'),
(3484, 'Pearl', 'BlackBerry 8130', 'Pearl BlackBerry 8130'),
(3485, 'Pearl Flip', 'BlackBerry 8220', 'Pearl Flip BlackBerry 8220'),
(3486, 'BlackBerry 8230', 'BlackBerry 8230', 'BlackBerry 8230'),
(3487, 'Curve', 'BlackBerry 8300', 'Curve BlackBerry 8300'),
(3488, 'Curve', 'BlackBerry 8320', 'Curve BlackBerry 8320'),
(3489, 'Curve', 'BlackBerry 8330', 'Curve BlackBerry 8330'),
(3490, 'Curve', 'BlackBerry 8330m', 'Curve BlackBerry 8330m'),
(3491, 'Curve', 'BlackBerry 8350i', 'Curve BlackBerry 8350i'),
(3492, 'Curve', 'BlackBerry 8520', 'Curve BlackBerry 8520'),
(3493, 'Curve', 'BlackBerry 8530', 'Curve BlackBerry 8530'),
(3494, 'BlackBerry 8700', 'BlackBerry 8700', 'BlackBerry 8700'),
(3495, 'BlackBerry 8700c', 'BlackBerry 8700c', 'BlackBerry 8700c'),
(3496, 'BlackBerry 8700f', 'BlackBerry 8700f', 'BlackBerry 8700f'),
(3497, 'BlackBerry 8700g', 'BlackBerry 8700g', 'BlackBerry 8700g'),
(3498, 'BlackBerry 8700r', 'BlackBerry 8700r', 'BlackBerry 8700r'),
(3499, 'BlackBerry 8700v', 'BlackBerry 8700v', 'BlackBerry 8700v'),
(3500, 'BlackBerry 8703', 'BlackBerry 8703', 'BlackBerry 8703'),
(3501, 'BlackBerry 8703e', 'BlackBerry 8703e', 'BlackBerry 8703e'),
(3502, 'BlackBerry 8705g', 'BlackBerry 8705g', 'BlackBerry 8705g'),
(3503, 'BlackBerry 8707', 'BlackBerry 8707', 'BlackBerry 8707'),
(3504, 'BlackBerry 8707v', 'BlackBerry 8707v', 'BlackBerry 8707v'),
(3505, 'BlackBerry 8800', 'BlackBerry 8800', 'BlackBerry 8800'),
(3506, 'BlackBerry 8820', 'BlackBerry 8820', 'BlackBerry 8820'),
(3507, 'World Edition', 'BlackBerry 8830', 'World Edition BlackBerry 8830'),
(3508, 'Curve', 'BlackBerry 8900', 'Curve BlackBerry 8900'),
(3509, 'BlackBerry 8910', 'BlackBerry 8910', 'BlackBerry 8910'),
(3510, 'Bold', 'BlackBerry 9000', 'Bold BlackBerry 9000'),
(3511, 'Pearl 3G', 'BlackBerry 9100', 'Pearl 3G BlackBerry 9100'),
(3512, 'Pearl 3G', 'BlackBerry 9105', 'Pearl 3G BlackBerry 9105'),
(3513, 'BlackBerry 9150', 'BlackBerry 9150', 'BlackBerry 9150'),
(3514, 'BlackBerry 9220', 'BlackBerry 9220', 'BlackBerry 9220'),
(3515, 'Curve 3G', 'BlackBerry 9300', 'Curve 3G BlackBerry 9300'),
(3516, 'Curve', 'BlackBerry 9330', 'Curve BlackBerry 9330'),
(3517, 'Curve', 'BlackBerry 9360', 'Curve BlackBerry 9360'),
(3518, 'Blackberry 9380 Curve', 'BlackBerry 9380', 'Blackberry 9380 Curve BlackBerry 9380'),
(3519, 'Storm', 'BlackBerry 9500', 'Storm BlackBerry 9500'),
(3520, 'Storm II', 'BlackBerry 9520', 'Storm II BlackBerry 9520'),
(3521, 'Storm', 'BlackBerry 9530', 'Storm BlackBerry 9530'),
(3522, 'Storm2', 'BlackBerry 9550', 'Storm2 BlackBerry 9550'),
(3523, 'Tour', 'BlackBerry 9630', 'Tour BlackBerry 9630'),
(3524, 'Bold', 'BlackBerry 9650', 'Bold BlackBerry 9650'),
(3525, 'BlackBerry 9670', 'BlackBerry 9670', 'BlackBerry 9670'),
(3526, 'Bold', 'BlackBerry 9700', 'Bold BlackBerry 9700'),
(3527, 'Bold', 'BlackBerry 9700a', 'Bold BlackBerry 9700a'),
(3528, 'BlackBerry 9780', 'BlackBerry 9780', 'BlackBerry 9780'),
(3529, 'BlackBerry Bold 9790', 'BlackBerry 9790', 'BlackBerry Bold 9790 BlackBerry 9790'),
(3530, 'Torch', 'BlackBerry 9800', 'Torch BlackBerry 9800'),
(3531, 'Torch 4G', 'BlackBerry 9810', 'Torch 4G BlackBerry 9810'),
(3532, 'Monza', 'BlackBerry Torch 9860', 'Monza BlackBerry Torch 9860'),
(3533, 'Dakota', 'BlackBerry Bold Touch 9900', 'Dakota BlackBerry Bold Touch 9900'),
(3534, 'Charm', 'BlackBerry 7100t', 'Charm BlackBerry 7100t'),
(3535, 'SK65', 'SK65', 'SK65'),
(3536, 'BB 10 Tablet', 'BB 10 Tablet', 'BB 10 Tablet'),
(3537, 'Curve 9310', 'BlackBerry 9310', 'Curve 9310 BlackBerry 9310'),
(3538, 'BlackBerry Curve 9320', 'BlackBerry 9320', 'BlackBerry Curve 9320 BlackBerry 9320'),
(3539, 'Curve 9350', 'BlackBerry 9350', 'Curve 9350 BlackBerry 9350'),
(3540, 'BlackBerry Curve 9370', 'BlackBerry 9370', 'BlackBerry Curve 9370 BlackBerry 9370'),
(3541, 'Patagonia 9620', 'BlackBerry 9620', 'Patagonia 9620 BlackBerry 9620'),
(3542, 'Volt', 'BlackBerry Torch 9850', 'Volt BlackBerry Torch 9850'),
(3543, 'Blackberry Bold Touch 9930', 'Blackberry Bold Touch 9930', 'Blackberry Bold Touch 9930'),
(3544, 'Porsche Design P\'9981', 'BlackBerry 9981', 'Porsche Design P\'9981-BlackBerry 9981'),
(3545, 'Z1010', 'Z1010', 'Z1010'),
(3546, 'T608', 'T608', 'T608'),
(3547, 'CMD-J5', 'CMD-J5', 'CMD-J5'),
(3548, 'CMD-J7/J70', 'CMD-J7/J70', 'CMD-J7/J70'),
(3549, 'CMD-Z5', 'CMD-Z5', 'CMD-Z5'),
(3550, 'CMD-Z7', 'CMD-Z7', 'CMD-Z7'),
(3551, 'P800', 'P800', 'P800'),
(3552, 'P900', 'P900', 'P900'),
(3553, 'P910i', 'P910i', 'P910i'),
(3554, 'M600i', 'M600i', 'M600i'),
(3555, 'P990', 'P990', 'P990'),
(3556, 'Xperia', 'X1i', 'Xperia X1i'),
(3557, 'K610i', 'K610i', 'K610i'),
(3558, 'Hazel', 'J20', 'Hazel J20'),
(3559, 'C123', 'C123', 'C123'),
(3560, 'C510', 'C510', 'C510'),
(3561, 'C902', 'C902', 'C902'),
(3562, 'C905', 'C905', 'C905'),
(3563, 'K850i', 'K850i', 'K850i'),
(3564, 'V640iv', 'V640iv', 'V640iv'),
(3565, 'W715', 'W715', 'W715'),
(3566, 'W890i', 'W890i', 'W890i'),
(3567, 'W890iv', 'W890iv', 'W890iv'),
(3568, 'W910i', 'W910i', 'W910i'),
(3569, 'W980v', 'W980v', 'W980v'),
(3570, 'Satio', 'P100', 'Satio P100'),
(3571, 'P990i', 'P990i', 'P990i'),
(3572, 'K700i', 'K700i', 'K700i'),
(3573, 'enV Touch', 'VX 11000', 'enV Touch VX 11000'),
(3574, 'VX5500', 'VX5500', 'VX5500'),
(3575, 'P900R101', 'P900R101', 'P900R101'),
(3576, 'T610', 'T610', 'T610'),
(3577, 'T290i', 'T290i', 'T290i'),
(3578, 'A100i', 'A100i', 'A100i'),
(3579, 'A130i', 'A130i', 'A130i'),
(3580, 'A195i', 'A195i', 'A195i'),
(3581, 'A260', 'A260', 'A260'),
(3582, 'A270', 'A270', 'A270'),
(3583, 'A290i', 'A290i', 'A290i'),
(3584, 'A320', 'A320', 'A320'),
(3585, 'B10', 'B10', 'B10'),
(3586, 'C123 A', 'C123 A', 'C123 A'),
(3587, 'C510a', 'C510a', 'C510a'),
(3588, 'C702', 'C702', 'C702'),
(3589, 'C901', 'C901', 'C901'),
(3590, 'C903', 'C903', 'C903'),
(3591, 'SonyEricsson TXT', 'CK13i', 'SonyEricsson TXT CK13i'),
(3592, 'CK15i', 'CK15i', 'CK15i'),
(3593, 'CS8', 'CS8', 'CS8'),
(3594, 'D750i', 'D750i', 'D750i'),
(3595, 'F100i', 'F100i', 'F100i'),
(3596, 'F305', 'F305', 'F305'),
(3597, 'F500i', 'F500i', 'F500i'),
(3598, 'F508i', 'F508i', 'F508i'),
(3599, 'G502', 'G502', 'G502'),
(3600, 'G700', 'G700', 'G700'),
(3601, 'G700c', 'G700c', 'G700c'),
(3602, 'G705', 'G705', 'G705'),
(3603, 'G705u', 'G705u', 'G705u'),
(3604, 'G900', 'G900', 'G900'),
(3605, 'Generic A1', 'Generic A1', 'Generic A1'),
(3606, 'Elm', 'J10', 'Elm J10'),
(3607, 'J100', 'J100', 'J100'),
(3608, 'J100a', 'J100a', 'J100a'),
(3609, 'J100c', 'J100c', 'J100c'),
(3610, 'J100i', 'J100i', 'J100i'),
(3611, 'Naite', 'J105', 'Naite J105'),
(3612, 'J105i', 'J105i', 'J105i'),
(3613, 'Cedar', 'J108a', 'Cedar J108a'),
(3614, 'NetFront Ver. 3.5', 'NetFront Ver. 3.5', 'NetFront Ver. 3.5'),
(3615, 'Elm', 'J10i2', 'Elm J10i2'),
(3616, 'J200', 'J200', 'J200'),
(3617, 'J200c', 'J200c', 'J200c'),
(3618, 'J200i', 'J200i', 'J200i'),
(3619, 'J20i', 'J20i', 'J20i'),
(3620, 'J210', 'J210', 'J210'),
(3621, 'J210c', 'J210c', 'J210c'),
(3622, 'J210i', 'J210i', 'J210i'),
(3623, 'J220', 'J220', 'J220'),
(3624, 'J220a', 'J220a', 'J220a'),
(3625, 'J220c', 'J220c', 'J220c'),
(3626, 'J220i', 'J220i', 'J220i'),
(3627, 'J230', 'J230', 'J230'),
(3628, 'J230a', 'J230a', 'J230a'),
(3629, 'J230c', 'J230c', 'J230c'),
(3630, 'J230i', 'J230i', 'J230i'),
(3631, 'J300', 'J300', 'J300'),
(3632, 'J300a', 'J300a', 'J300a'),
(3633, 'J300c', 'J300c', 'J300c'),
(3634, 'J300i', 'J300i', 'J300i'),
(3635, 'K200i', 'K200i', 'K200i'),
(3636, 'K205i', 'K205i', 'K205i'),
(3637, 'K220i', 'K220i', 'K220i'),
(3638, 'K300', 'K300', 'K300'),
(3639, 'K300a', 'K300a', 'K300a'),
(3640, 'K300c', 'K300c', 'K300c'),
(3641, 'K300i', 'K300i', 'K300i'),
(3642, 'K310', 'K310', 'K310'),
(3643, 'K310a', 'K310a', 'K310a'),
(3644, 'K310c', 'K310c', 'K310c'),
(3645, 'K310iv', 'K310iv', 'K310iv'),
(3646, 'K320i', 'K320i', 'K320i'),
(3647, 'K330', 'K330', 'K330'),
(3648, 'K500c', 'K500c', 'K500c'),
(3649, 'K500i', 'K500i', 'K500i'),
(3650, 'K506c', 'K506c', 'K506c'),
(3651, 'K508', 'K508', 'K508'),
(3652, 'K508c', 'K508c', 'K508c'),
(3653, 'K508i', 'K508i', 'K508i'),
(3654, 'K510', 'K510', 'K510'),
(3655, 'K510a', 'K510a', 'K510a'),
(3656, 'K510c', 'K510c', 'K510c'),
(3657, 'K510i', 'K510i', 'K510i'),
(3658, 'K530c', 'K530c', 'K530c'),
(3659, 'K530i', 'K530i', 'K530i'),
(3660, 'K550c', 'K550c', 'K550c'),
(3661, 'K550i', 'K550i', 'K550i'),
(3662, 'K600', 'K600', 'K600'),
(3663, 'K600c', 'K600c', 'K600c'),
(3664, 'K600i', 'K600i', 'K600i'),
(3665, 'K608', 'K608', 'K608'),
(3666, 'K608i', 'K608i', 'K608i'),
(3667, 'K610', 'K610', 'K610'),
(3668, 'K610c', 'K610c', 'K610c'),
(3669, 'K610im', 'K610im', 'K610im'),
(3670, 'K610iv', 'K610iv', 'K610iv'),
(3671, 'K618', 'K618', 'K618'),
(3672, 'K618i', 'K618i', 'K618i'),
(3673, 'K630i', 'K630i', 'K630i'),
(3674, 'K660i', 'K660i', 'K660i'),
(3675, 'K700', 'K700', 'K700'),
(3676, 'K700c', 'K700c', 'K700c'),
(3677, 'K750', 'K750', 'K750'),
(3678, 'K750c', 'K750c', 'K750c'),
(3679, 'K750i', 'K750i', 'K750i'),
(3680, 'K758c', 'K758c', 'K758c'),
(3681, 'K770i', 'K770i', 'K770i'),
(3682, 'K770iv', 'K770iv', 'K770iv'),
(3683, 'K790', 'K790', 'K790'),
(3684, 'K790a', 'K790a', 'K790a'),
(3685, 'K790c', 'K790c', 'K790c'),
(3686, 'K790i', 'K790i', 'K790i'),
(3687, 'K800', 'K800', 'K800'),
(3688, 'K800a', 'K800a', 'K800a'),
(3689, 'K800c', 'K800c', 'K800c'),
(3690, 'K800i', 'K800i', 'K800i'),
(3691, 'K800iv', 'K800iv', 'K800iv'),
(3692, 'K810', 'K810', 'K810'),
(3693, 'K810a', 'K810a', 'K810a'),
(3694, 'K810c', 'K810c', 'K810c'),
(3695, 'K810i', 'K810i', 'K810i'),
(3696, 'K818c', 'K818c', 'K818c'),
(3697, 'K858c', 'K858c', 'K858c'),
(3698, 'Sony Ericsson Aspen', 'M1a', 'Sony Ericsson Aspen M1a'),
(3699, 'M600', 'M600', 'M600'),
(3700, 'M600c', 'M600c', 'M600c'),
(3701, 'M608', 'M608', 'M608'),
(3702, 'M608c', 'M608c', 'M608c'),
(3703, 'M610i', 'M610i', 'M610i'),
(3704, 'P1c', 'P1c', 'P1c'),
(3705, 'P700i', 'P700i', 'P700i'),
(3706, 'P802', 'P802', 'P802'),
(3707, 'P900i', 'P900i', 'P900i'),
(3708, 'P908', 'P908', 'P908'),
(3709, 'P910', 'P910', 'P910'),
(3710, 'P910a', 'P910a', 'P910a'),
(3711, 'P910c', 'P910c', 'P910c'),
(3712, 'P990c', 'P990c', 'P990c'),
(3713, 'R300', 'R300', 'R300'),
(3714, 'R306', 'R306', 'R306'),
(3715, 'S302', 'S302', 'S302'),
(3716, 'S312', 'S312', 'S312'),
(3717, 'S500c', 'S500c', 'S500c'),
(3718, 'S500i', 'S500i', 'S500i'),
(3719, 'S600', 'S600', 'S600'),
(3720, 'S600i', 'S600i', 'S600i'),
(3721, 'S700', 'S700', 'S700'),
(3722, 'S700c', 'S700c', 'S700c'),
(3723, 'S700i', 'S700i', 'S700i'),
(3724, 'S710', 'S710', 'S710'),
(3725, 'S710a', 'S710a', 'S710a'),
(3726, 'T100', 'T100', 'T100'),
(3727, 'T105', 'T105', 'T105'),
(3728, 'T123i', 'T123i', 'T123i'),
(3729, 'T200', 'T200', 'T200'),
(3730, 'T226', 'T226', 'T226'),
(3731, 'T230', 'T230', 'T230'),
(3732, 'T237', 'T237', 'T237'),
(3733, 'T238', 'T238', 'T238'),
(3734, 'T250a', 'T250a', 'T250a'),
(3735, 'T250i', 'T250i', 'T250i'),
(3736, 'T270i', 'T270i', 'T270i'),
(3737, 'T280a', 'T280a', 'T280a'),
(3738, 'T280i', 'T280i', 'T280i'),
(3739, 'T290', 'T290', 'T290'),
(3740, 'T290a', 'T290a', 'T290a'),
(3741, 'T290c', 'T290c', 'T290c'),
(3742, 'T302', 'T302', 'T302'),
(3743, 'T303', 'T303', 'T303'),
(3744, 'T306', 'T306', 'T306'),
(3745, 'T310', 'T310', 'T310'),
(3746, 'T312', 'T312', 'T312'),
(3747, 'T316', 'T316', 'T316'),
(3748, 'T360', 'T360', 'T360'),
(3749, 'T39m R2', 'T39m R2', 'T39m R2'),
(3750, 'T39M', 'T39M', 'T39M'),
(3751, 'T6', 'T6', 'T6'),
(3752, 'T600', 'T600', 'T600'),
(3753, 'T61', 'T61', 'T61'),
(3754, 'T612', 'T612', 'T612'),
(3755, 'T616', 'T616', 'T616'),
(3756, 'T618', 'T618', 'T618'),
(3757, 'T62', 'T62', 'T62'),
(3758, 'T620', 'T620', 'T620'),
(3759, 'T628', 'T628', 'T628'),
(3760, 'T630', 'T630', 'T630'),
(3761, 'T637', 'T637', 'T637'),
(3762, 'T650i', 'T650i', 'T650i'),
(3763, 'T658c', 'T658c', 'T658c'),
(3764, 'T68i', 'T68i', 'T68i'),
(3765, 'T687i', 'T687i', 'T687i'),
(3766, 'T707', 'T707', 'T707'),
(3767, 'T707a', 'T707a', 'T707a'),
(3768, 'T715', 'T715', 'T715'),
(3769, 'T715a', 'T715a', 'T715a'),
(3770, 'TM506', 'TM506', 'TM506'),
(3771, 'TM717', 'TM717', 'TM717'),
(3772, 'U100i', 'U100i', 'U100i'),
(3773, 'Aino', 'U10i', 'Aino U10i'),
(3774, 'Satio', 'U1i', 'Satio U1i'),
(3775, 'Satio', 'U1iv', 'Satio U1iv'),
(3776, 'Vivaz', 'U5a', 'Vivaz U5a'),
(3777, 'Vivaz', 'U5i', 'Vivaz U5i'),
(3778, 'Vivaz', 'U5iv', 'Vivaz U5iv'),
(3779, 'kanna', 'U8i', 'kanna U8i'),
(3780, 'U1', 'U1', 'U1'),
(3781, 'V600i', 'V600i', 'V600i'),
(3782, 'V630', 'V630', 'V630'),
(3783, 'V630i', 'V630i', 'V630i'),
(3784, 'V640i', 'V640i', 'V640i'),
(3785, 'V800', 'V800', 'V800'),
(3786, 'V802', 'V802', 'V802'),
(3787, 'Spiro Stealth Black', 'W100a', 'Spiro Stealth Black W100a'),
(3788, 'Spiro', 'W100', 'Spiro W100'),
(3789, 'W150', 'W150', 'W150'),
(3790, 'Yendo', 'W150a', 'Yendo W150a'),
(3791, 'TeaCake', 'W150i', 'TeaCake W150i'),
(3792, 'Zylo', 'W20', 'Zylo W20'),
(3793, 'W200a', 'W200a', 'W200a'),
(3794, 'W200c', 'W200c', 'W200c'),
(3795, 'W200iv', 'W200iv', 'W200iv'),
(3796, 'W205', 'W205', 'W205'),
(3797, 'W205a', 'W205a', 'W205a'),
(3798, 'Tao', 'W20i', 'Tao W20i'),
(3799, 'W300', 'W300', 'W300'),
(3800, 'W300c', 'W300c', 'W300c'),
(3801, 'W300i', 'W300i', 'W300i'),
(3802, 'W302', 'W302', 'W302'),
(3803, 'W350a', 'W350a', 'W350a'),
(3804, 'W350i', 'W350i', 'W350i'),
(3805, 'W380a', 'W380a', 'W380a'),
(3806, 'W380c', 'W380c', 'W380c'),
(3807, 'W380i', 'W380i', 'W380i'),
(3808, 'W395', 'W395', 'W395'),
(3809, 'W508', 'W508', 'W508'),
(3810, 'W508a', 'W508a', 'W508a'),
(3811, 'W518a', 'W518a', 'W518a'),
(3812, 'W550c', 'W550c', 'W550c'),
(3813, 'W550i', 'W550i', 'W550i'),
(3814, 'W580', 'W580', 'W580'),
(3815, 'W580c', 'W580c', 'W580c'),
(3816, 'W580i', 'W580i', 'W580i'),
(3817, 'W595s', 'W595s', 'W595s'),
(3818, 'W600c', 'W600c', 'W600c'),
(3819, 'W610', 'W610', 'W610'),
(3820, 'W610i', 'W610i', 'W610i'),
(3821, 'W660i', 'W660i', 'W660i'),
(3822, 'W660iv', 'W660iv', 'W660iv'),
(3823, 'W700', 'W700', 'W700'),
(3824, 'W700c', 'W700c', 'W700c'),
(3825, 'W700i', 'W700i', 'W700i'),
(3826, 'W705', 'W705', 'W705'),
(3827, 'W705a', 'W705a', 'W705a'),
(3828, 'W705u', 'W705u', 'W705u'),
(3829, 'W710c', 'W710c', 'W710c'),
(3830, 'W710i', 'W710i', 'W710i'),
(3831, 'W750i', 'W750i', 'W750i'),
(3832, 'W760a', 'W760a', 'W760a'),
(3833, 'W760i', 'W760i', 'W760i'),
(3834, 'W800', 'W800', 'W800'),
(3835, 'W800c', 'W800c', 'W800c'),
(3836, 'W800i', 'W800i', 'W800i'),
(3837, 'W810', 'W810', 'W810'),
(3838, 'W810a', 'W810a', 'W810a'),
(3839, 'W810c', 'W810c', 'W810c'),
(3840, 'W810i', 'W810i', 'W810i'),
(3841, 'W830c', 'W830c', 'W830c'),
(3842, 'W830i', 'W830i', 'W830i'),
(3843, 'W850', 'W850', 'W850'),
(3844, 'W850i', 'W850i', 'W850i'),
(3845, 'W850iv', 'W850iv', 'W850iv'),
(3846, 'W880', 'W880', 'W880'),
(3847, 'W880c', 'W880c', 'W880c'),
(3848, 'W880i', 'W880i', 'W880i'),
(3849, 'W880iv', 'W880iv', 'W880iv'),
(3850, 'W888', 'W888', 'W888'),
(3851, 'W888c', 'W888c', 'W888c'),
(3852, 'W890', 'W890', 'W890'),
(3853, 'W900i', 'W900i', 'W900i'),
(3854, 'W902', 'W902', 'W902'),
(3855, 'W902plus', 'W902plus', 'W902plus'),
(3856, 'W908c', 'W908c', 'W908c'),
(3857, 'W950', 'W950', 'W950'),
(3858, 'W950c', 'W950c', 'W950c'),
(3859, 'W950i', 'W950i', 'W950i'),
(3860, 'W958c', 'W958c', 'W958c'),
(3861, 'W960i', 'W960i', 'W960i'),
(3862, 'W980', 'W980', 'W980'),
(3863, 'W980i', 'W980i', 'W980i'),
(3864, 'W995', 'W995', 'W995'),
(3865, 'WT13i', 'WT13i', 'WT13i'),
(3866, 'Xperia', 'X1a', 'Xperia X1a'),
(3867, 'X2', 'X2', 'X2'),
(3868, 'X5', 'X5', 'X5'),
(3869, 'Z200', 'Z200', 'Z200'),
(3870, 'Z208', 'Z208', 'Z208'),
(3871, 'Z250i', 'Z250i', 'Z250i'),
(3872, 'Z300', 'Z300', 'Z300'),
(3873, 'Z300a', 'Z300a', 'Z300a'),
(3874, 'Z300i', 'Z300i', 'Z300i'),
(3875, 'Z310a', 'Z310a', 'Z310a'),
(3876, 'Z310i', 'Z310i', 'Z310i'),
(3877, 'Z310iv', 'Z310iv', 'Z310iv'),
(3878, 'Z320a', 'Z320a', 'Z320a'),
(3879, 'Z320i', 'Z320i', 'Z320i'),
(3880, 'Z500', 'Z500', 'Z500'),
(3881, 'Z500a', 'Z500a', 'Z500a'),
(3882, 'Z500i', 'Z500i', 'Z500i'),
(3883, 'Z520a', 'Z520a', 'Z520a'),
(3884, 'Z520c', 'Z520c', 'Z520c'),
(3885, 'Z520i', 'Z520i', 'Z520i'),
(3886, 'Z525', 'Z525', 'Z525'),
(3887, 'Z525a', 'Z525a', 'Z525a'),
(3888, 'Z525c', 'Z525c', 'Z525c'),
(3889, 'Z525i', 'Z525i', 'Z525i'),
(3890, 'Z530', 'Z530', 'Z530'),
(3891, 'Z530c', 'Z530c', 'Z530c'),
(3892, 'Z530i', 'Z530i', 'Z530i'),
(3893, 'Z550', 'Z550', 'Z550'),
(3894, 'Z550a', 'Z550a', 'Z550a'),
(3895, 'Z550c', 'Z550c', 'Z550c'),
(3896, 'Z550i', 'Z550i', 'Z550i'),
(3897, 'Z555a', 'Z555a', 'Z555a'),
(3898, 'Z555i', 'Z555i', 'Z555i'),
(3899, 'Z558c', 'Z558c', 'Z558c'),
(3900, 'Z558i', 'Z558i', 'Z558i'),
(3901, 'Z600', 'Z600', 'Z600'),
(3902, 'Z608', 'Z608', 'Z608'),
(3903, 'Z610i', 'Z610i', 'Z610i'),
(3904, 'Z700', 'Z700', 'Z700'),
(3905, 'Z710', 'Z710', 'Z710'),
(3906, 'Z710c', 'Z710c', 'Z710c'),
(3907, 'Z710i', 'Z710i', 'Z710i'),
(3908, 'Z750a', 'Z750a', 'Z750a'),
(3909, 'Z750i', 'Z750i', 'Z750i'),
(3910, 'Z770i', 'Z770i', 'Z770i'),
(3911, 'Z780i', 'Z780i', 'Z780i'),
(3912, 'Z800', 'Z800', 'Z800'),
(3913, 'Z800c', 'Z800c', 'Z800c'),
(3914, 'Z800i', 'Z800i', 'Z800i'),
(3915, '750i', '750i', '750i'),
(3916, 'K550im', 'K550im', 'K550im'),
(3917, 'C650', 'C650', 'C650'),
(3918, '0102', '0102', '0102'),
(3919, '120E', '120E', '120E'),
(3920, '201', '201', '201'),
(3921, '222', '222', '222'),
(3922, 'Vegas', 'VE', 'Vegas VE'),
(3923, '2000', '2000', '2000'),
(3924, '2001', '2001', '2001'),
(3925, '60c', '60c', '60c'),
(3926, '270c', '270c', '270c'),
(3927, '2200', '2200', '2200'),
(3928, 'KRZR K1c', 'KRZR K1c', 'KRZR K1c'),
(3929, 'i700+/i1000+', 'i700+/i1000+', 'i700+/i1000+'),
(3930, '280', '280', '280'),
(3931, '30', '30', '30'),
(3932, '300', '300', '300'),
(3933, 'i85s/i50sx/i55sr', 'i85s/i50sx/i55sr', 'i85s/i50sx/i55sr'),
(3934, '36567', '36567', '36567'),
(3935, '385', '385', '385'),
(3936, '40', '40', '40'),
(3937, '43', '43', '43'),
(3938, '47', '47', '47'),
(3939, '562', '562', '562'),
(3940, 'i500+/i550+', 'i500+/i550+', 'i500+/i550+'),
(3941, '62', '62', '62'),
(3942, '6330', '6330', '6330'),
(3943, '70', '70', '70'),
(3944, 'i80s', 'i80s', 'i80s'),
(3945, '74', '74', '74'),
(3946, 'i90c', 'i90c', 'i90c'),
(3947, '8300', '8300', '8300'),
(3948, 'i95cl', 'i95cl', 'i95cl'),
(3949, '8500', '8500', '8500'),
(3950, '8600', '8600', '8600'),
(3951, 'i30sx', 'i30sx', 'i30sx'),
(3952, '8700', '8700', '8700'),
(3953, '8720', '8720', '8720'),
(3954, '8800', '8800', '8800'),
(3955, 'ROKR E1', 'E1', 'ROKR E1 E1'),
(3956, 'i730', 'i730', 'i730'),
(3957, 'i530', 'i530', 'i530'),
(3958, 'i325', 'i325', 'i325'),
(3959, 'i315', 'i315', 'i315'),
(3960, 'i860', 'i860', 'i860'),
(3961, 'i305', 'i305', 'i305'),
(3962, 'i830', 'i830', 'i830'),
(3963, 'i285', 'i285', 'i285'),
(3964, 'i740', 'i740', 'i740'),
(3965, 'i605', 'i605', 'i605'),
(3966, 'i265', 'i265', 'i265'),
(3967, 'i850', 'i850', 'i850'),
(3968, 'i760', 'i760', 'i760'),
(3969, 'i355', 'i355', 'i355'),
(3970, 'i560', 'i560', 'i560'),
(3971, 'i870', 'i870', 'i870'),
(3972, 'i580', 'i580', 'i580'),
(3973, 'i880', 'i880', 'i880'),
(3974, 'i670', 'i670', 'i670'),
(3975, 'i615', 'i615', 'i615'),
(3976, 'i290', 'i290', 'i290'),
(3977, 'i205', 'i205', 'i205'),
(3978, 'i88s', 'i88s', 'i88s'),
(3979, 'i570', 'i570', 'i570'),
(3980, 'i425', 'i425', 'i425'),
(3981, 'iDEN i365/i365is', 'i365/i365is', 'iDEN i365/i365is i365/i365is'),
(3982, 'unknown iDen', 'unknown iDen', 'unknown iDen'),
(3983, 'i576', 'i576', 'i576'),
(3984, 'A9D', 'A9D', 'A9D'),
(3985, 'Clutch', 'i465', 'Clutch i465'),
(3986, 'Debut i856', 'Debut i856', 'Debut i856'),
(3987, 'iDEN i890/i897', 'i890/i897', 'iDEN i890/i897 i890/i897'),
(3988, 'iDEN i410', 'i410', 'iDEN i410 i410'),
(3989, 'Brute', 'i680/i686', 'Brute i680/i686'),
(3990, 'i876', 'i876', 'i876'),
(3991, 'i877', 'i877', 'i877'),
(3992, 'Stature', 'i9', 'Stature i9'),
(3993, 'Moka', 'i786/i786w', 'Moka i786/i786w'),
(3994, 'Gallo', 'i294/i296', 'Gallo i294/i296'),
(3995, 'i706/i776', 'i706/i776', 'i706/i776'),
(3996, 'Clutch', 'i475', 'Clutch i475'),
(3997, 'i420/i440', 'i420/i440', 'i420/i440'),
(3998, 'Accompli', 'A008 GPRS', 'Accompli A008 GPRS'),
(3999, 'A1000', 'A1000', 'A1000'),
(4000, 'MING', 'A1200', 'MING A1200'),
(4001, 'MING', 'A1200e', 'MING A1200e'),
(4002, 'MING', 'A1200eam', 'MING A1200eam'),
(4003, 'MING', 'A1200i', 'MING A1200i'),
(4004, 'MING', 'A1200W', 'MING A1200W'),
(4005, 'Ming', 'A1600', 'Ming A1600'),
(4006, 'A3100', 'A3100', 'A3100'),
(4007, 'Accompli', 'A388', 'Accompli A388'),
(4008, 'MOTOCUBE', 'MOTOA45ECO', 'MOTOCUBE MOTOA45ECO'),
(4009, 'Rival', 'A455', 'Rival A455'),
(4010, 'A630', 'A630', 'A630'),
(4011, 'A660', 'A660', 'A660'),
(4012, 'A668', 'A668', 'A668'),
(4013, 'A728', 'A728', 'A728'),
(4014, 'A732', 'A732', 'A732'),
(4015, 'A760', 'A760', 'A760'),
(4016, 'A768', 'A768', 'A768'),
(4017, 'A768i', 'A768i', 'A768i'),
(4018, 'A780', 'A780', 'A780'),
(4019, 'A810', 'A810', 'A810'),
(4020, 'A820', 'A820', 'A820'),
(4021, 'A830', 'A830', 'A830'),
(4022, 'A835', 'A835', 'A835'),
(4023, 'A840', 'A840', 'A840'),
(4024, 'A845', 'A845', 'A845'),
(4025, 'A860', 'A860', 'A860'),
(4026, 'A890', 'A890', 'A890'),
(4027, 'A910', 'A910', 'A910'),
(4028, 'A920', 'A920', 'A920'),
(4029, 'Ti260', 'Ti260', 'Ti260'),
(4030, 'Artem', 'Artem', 'Artem'),
(4031, 'BlackMonster', 'Black Monster', 'BlackMonster Black Monster'),
(4032, 'C115', 'C115', 'C115'),
(4033, 'C116', 'C116', 'C116'),
(4034, 'C118', 'C118', 'C118'),
(4035, 'C139', 'C139', 'C139'),
(4036, 'C140', 'C140', 'C140'),
(4037, 'C155', 'C155', 'C155'),
(4038, 'C168', 'C168', 'C168'),
(4039, 'C168i', 'C168i', 'C168i'),
(4040, 'V100', 'V100', 'V100'),
(4041, 'C200', 'C200', 'C200'),
(4042, 'C201', 'C201', 'C201'),
(4043, 'C202', 'C202', 'C202'),
(4044, 'C212', 'C212', 'C212'),
(4045, 'C257', 'C257', 'C257'),
(4046, 'C261', 'C261', 'C261'),
(4047, 'C290', 'C290', 'C290'),
(4048, 'C331', 'C331', 'C331'),
(4049, 'C332', 'C332', 'C332'),
(4050, 'C353', 'C353', 'C353'),
(4051, 'C357', 'C357', 'C357'),
(4052, 'C370', 'C370', 'C370'),
(4053, 'C375', 'C375', 'C375'),
(4054, 'C380', 'C380', 'C380'),
(4055, 'C380M', 'C380M', 'C380M'),
(4056, 'C380P', 'C380P', 'C380P'),
(4057, 'C380i', 'C380i', 'C380i'),
(4058, 'C381', 'C381', 'C381'),
(4059, 'C381P', 'C381P', 'C381P'),
(4060, 'C384', 'C384', 'C384'),
(4061, 'C385', 'C385', 'C385'),
(4062, 'C390', 'C390', 'C390'),
(4063, 'V50', 'V50', 'V50'),
(4064, 'C400', 'C400', 'C400'),
(4065, 'C450', 'C450', 'C450'),
(4066, 'C480', 'C480', 'C480'),
(4067, 'C550', 'C550', 'C550'),
(4068, 'C600', 'C600', 'C600'),
(4069, 'C65', 'C65', 'C65'),
(4070, 'C650g', 'C650g', 'C650g'),
(4071, 'C650i', 'C650i', 'C650i'),
(4072, 'C651', 'C651', 'C651'),
(4073, 'C698p', 'C698p', 'C698p'),
(4074, 'Tyax', 'C975', 'Tyax C975'),
(4075, 'C980', 'C980', 'C980'),
(4076, '702sMO', '702sMO', '702sMO'),
(4077, 'C980M', 'C980M', 'C980M'),
(4078, 'CF', 'CF', 'CF'),
(4079, 'V750', 'V750', 'V750'),
(4080, 'CN620', 'CN620', 'CN620'),
(4081, 'W755', 'W755', 'W755'),
(4082, 'Canary', 'Canary', 'Canary'),
(4083, 'D3', 'D3', 'D3'),
(4084, 'T191', 'T191', 'T191'),
(4085, 'D8', 'D8', 'D8'),
(4086, 'VE 240', 'VE 240', 'VE 240'),
(4087, 'E398', 'E398', 'E398'),
(4088, 'E398I', 'E398I', 'E398I'),
(4089, 'RokR', 'E1', 'RokR E1'),
(4090, 'E1000', 'E1000', 'E1000'),
(4091, 'E100M', 'E100M', 'E100M'),
(4092, 'E1060', 'E1060', 'E1060'),
(4093, 'E1070', 'E1070', 'E1070'),
(4094, 'E1120', 'E1120', 'E1120'),
(4095, 'ROKR E2', 'ROKR E2', 'ROKR E2'),
(4096, 'E375', 'E375', 'E375'),
(4097, 'E380', 'E380', 'E380'),
(4098, 'E390', 'E390', 'E390'),
(4099, 'E398B', 'E398B', 'E398B'),
(4100, 'E398E', 'E398E', 'E398E'),
(4101, 'E398U', 'E398U', 'E398U'),
(4102, 'E550', 'E550', 'E550'),
(4103, 'E610', 'E610', 'E610'),
(4104, 'E615', 'E615', 'E615'),
(4105, 'E680', 'E680', 'E680'),
(4106, 'E680i', 'E680i', 'E680i'),
(4107, 'E685', 'E685', 'E685'),
(4108, 'E770', 'E770', 'E770'),
(4109, 'E770v', 'E770v', 'E770v'),
(4110, 'E790', 'E790', 'E790'),
(4111, 'E798', 'E798', 'E798'),
(4112, 'E798R', 'E798R', 'E798R'),
(4113, 'T192m', 'T192m', 'T192m'),
(4114, 'MOTOROKR', 'MOTOROKR E8', 'MOTOROKR MOTOROKR E8'),
(4115, 'E825', 'E825', 'E825'),
(4116, 'E895', 'E895', 'E895'),
(4117, 'ED', 'ED', 'ED'),
(4118, '388C', '388C', '388C'),
(4119, 'EM25', 'EM25', 'EM25'),
(4120, 'Motorokr', 'EM28', 'Motorokr EM28'),
(4121, 'MOTOROCKR', 'EM30', 'MOTOROCKR EM30'),
(4122, 'EM325', 'EM325', 'EM325'),
(4123, 'EM326g', 'EM326g', 'EM326g'),
(4124, 'EM330', 'EM330', 'EM330'),
(4125, 'Motorokr', 'EM35', 'Motorokr EM35'),
(4126, 'MOTOKEY Mini', 'EX108', 'MOTOKEY Mini EX108'),
(4127, 'MOTOKEY Mini', 'EX109', 'MOTOKEY Mini EX109'),
(4128, 'MOT-EX112', 'MOT-EX112', 'MOT-EX112'),
(4129, 'MOT-EX115', 'MOT-EX115', 'MOT-EX115'),
(4130, 'Motokey WiFi', 'EX116', 'Motokey WiFi EX116'),
(4131, 'MOTOKEY XT', 'EX118', 'MOTOKEY XT EX118'),
(4132, 'EX119', 'EX119', 'EX119'),
(4133, 'MOT-EX122', 'MOT-EX122', 'MOT-EX122'),
(4134, 'EX124G', 'EX124G', 'EX124G'),
(4135, 'MOT-EX128', 'MOT-EX128', 'MOT-EX128'),
(4136, 'EX130', 'EX130', 'EX130'),
(4137, 'MOTOTV 2', 'EX139', 'MOTOTV 2 EX139'),
(4138, 'MOT-EX225', 'MOT-EX225', 'MOT-EX225'),
(4139, 'MOT-EX245', 'MOT-EX245', 'MOT-EX245'),
(4140, 'F0', 'F0', 'F0'),
(4141, 'F3', 'F3', 'F3'),
(4142, 'F4', 'F4', 'F4'),
(4143, 'T193', 'T193', 'T193'),
(4144, 'Accompli', 'A008/A388', 'Accompli A008/A388'),
(4145, 'a388', 'a388', 'a388'),
(4146, 'RAZR', 'RAZR V3m', 'RAZR RAZR V3m'),
(4147, 'i398', 'i398', 'i398'),
(4148, 'i85', 'i85', 'i85'),
(4149, 'Irka', 'Irka', 'Irka'),
(4150, 'MOTOROKR', 'MOTOROKR Z6C', 'MOTOROKR MOTOROKR Z6C'),
(4151, 'W385', 'W385', 'W385'),
(4152, 'Parrot', 'K1m', 'Parrot K1m'),
(4153, 'K1m', 'K1m', 'K1m'),
(4154, 'K1v', 'K1v', 'K1v'),
(4155, 'KRZR K1v', 'KRZR K1v', 'KRZR K1v'),
(4156, 'K3', 'K3', 'K3'),
(4157, 'KLGO', 'KLGO', 'KLGO'),
(4158, 'L2', 'L2', 'L2'),
(4159, 'RAZR L6', 'RAZR L6', 'RAZR L6'),
(4160, 'L6i', 'L6i', 'L6i'),
(4161, 'SLVR', 'L7', 'SLVR L7'),
(4162, 'L71', 'L71', 'L71'),
(4163, 'SLVR', 'L72', 'SLVR L72'),
(4164, 'SLVR', 'L7e', 'SLVR L7e'),
(4165, 'SLVR', 'L7I', 'SLVR L7I'),
(4166, 'SLVR', 'SLVR L7', 'SLVR SLVR L7'),
(4167, 'SLVR', 'L9', 'SLVR L9'),
(4168, 'Smart Rider', 'M990', 'Smart Rider M990'),
(4169, 'MCC7', 'MCC7', 'MCC7'),
(4170, 'MCC8', 'MCC8', 'MCC8'),
(4171, 'P8767', 'P8767', 'P8767'),
(4172, 'V2267', 'V2267', 'V2267'),
(4173, 'Milla', 'Milla', 'Milla'),
(4174, 'V325', 'V325', 'V325'),
(4175, 'Karma', 'QA1', 'Karma QA1'),
(4176, 'MOTORAZR', 'V8', 'MOTORAZR V8'),
(4177, 'MOTORAZR 2', 'V9', 'MOTORAZR 2 V9'),
(4178, 'MOTORAZR 2', 'V9x', 'MOTORAZR 2 V9x'),
(4179, 'MOTORAZR 2', 'MOTORAZR V9x', 'MOTORAZR 2 MOTORAZR V9x'),
(4180, 'RAZR2', 'RAZR V8', 'RAZR2 RAZR V8'),
(4181, 'MOTOROKR', 'MOTOROKR E6', 'MOTOROKR MOTOROKR E6'),
(4182, 'MOTOROKR', 'MOTOROKR E6e', 'MOTOROKR MOTOROKR E6e'),
(4183, 'RAZR', 'Z9', 'RAZR Z9'),
(4184, 'MPx200', 'MPx200', 'MPx200'),
(4185, 'MPX100', 'MPX100', 'MPX100'),
(4186, 'MPx220', 'MPx220', 'MPx220'),
(4187, 'V500', 'V500', 'V500'),
(4188, 'V80', 'V80', 'V80'),
(4189, 'RAZR', 'V3c', 'RAZR V3c'),
(4190, 'C353t', 'C353t', 'C353t'),
(4191, 'T280', 'T280', 'T280'),
(4192, 'MOTORAZR 2', 'RAZR V9m', 'MOTORAZR 2 RAZR V9m'),
(4193, 'V265', 'V265', 'V265'),
(4194, 'PEBL U6', 'PEBL U6', 'PEBL U6'),
(4195, 'PEBL V6', 'PEBL V6', 'PEBL V6'),
(4196, 'V60', 'V60', 'V60'),
(4197, 'PHX8A', 'PHX8A', 'PHX8A'),
(4198, 'PEBL U3', 'PEBL U3', 'PEBL U3'),
(4199, 'Q11', 'Q11', 'Q11'),
(4200, 'Q8', 'Q8', 'Q8'),
(4201, 'MOT-Q9H', 'MOT-Q9H', 'MOT-Q9H'),
(4202, 'Q9H', 'Q9H', 'Q9H'),
(4203, 'Q-UMTS', 'Q-UMTS', 'Q-UMTS'),
(4204, 'Raspberry', 'QA30', 'Raspberry QA30'),
(4205, 'R38', 'R38', 'R38'),
(4206, 'Vegas', 'VE20', 'Vegas VE20'),
(4207, 'R9', 'R9', 'R9'),
(4208, 'V323i', 'V323i', 'V323i'),
(4209, 'V398', 'V398', 'V398'),
(4210, 'RAZR', 'RAZR V3xxR', 'RAZR RAZR V3xxR'),
(4211, 'RAZR', 'RAZR V3x', 'RAZR RAZR V3x'),
(4212, 'RAZR', 'RAZR V3xM', 'RAZR RAZR V3xM'),
(4213, 'RAZR', 'V3XX', 'RAZR V3XX'),
(4214, 'RAZR', 'RAZR V3xx', 'RAZR RAZR V3xx'),
(4215, 'RAZR', 'RAZR V3xxv', 'RAZR RAZR V3xxv'),
(4216, 'RAZR V6', 'RAZR V6', 'RAZR V6'),
(4217, 'RAZR V6vb', 'RAZR V6vb', 'RAZR V6vb'),
(4218, 'V66', 'V66', 'V66'),
(4219, 'Spark', 'Spark', 'Spark'),
(4220, 'V620', 'V620', 'V620'),
(4221, 'T190', 'T190', 'T190'),
(4222, 'T720g', 'T720g', 'T720g'),
(4223, 'T720M', 'T720M', 'T720M'),
(4224, 'T720i', 'T720i', 'T720i'),
(4225, 'T721', 'T721', 'T721'),
(4226, 'T722', 'T722', 'T722'),
(4227, 'T722i', 'T722i', 'T722i'),
(4228, 'T725', 'T725', 'T725'),
(4229, 'T725E', 'T725E', 'T725E'),
(4230, 'T730', 'T730', 'T730'),
(4231, 'T732', 'T732', 'T732'),
(4232, 'C330/C333/C336', 'C330/C333/C336', 'C330/C333/C336'),
(4233, 'Timeport 250', 'Timeport 250', 'Timeport 250'),
(4234, 'Timeport 260', 'Timeport 260', 'Timeport 260'),
(4235, 'Timeport 260 gprs', 'Timeport 260 gprs', 'Timeport 260 gprs'),
(4236, 'U15', 'U15', 'U15'),
(4237, 'U9', 'U9', 'U9'),
(4238, 'V1000', 'V1000', 'V1000'),
(4239, 'V101', 'V101', 'V101'),
(4240, 'V1050', 'V1050', 'V1050'),
(4241, 'V1075', 'V1075', 'V1075'),
(4242, 'V1100', 'V1100', 'V1100'),
(4243, 'V120', 'V120', 'V120'),
(4244, 'V120X', 'V120X', 'V120X'),
(4245, 'V170', 'V170', 'V170'),
(4246, 'V171', 'V171', 'V171'),
(4247, 'V172', 'V172', 'V172'),
(4248, 'V173', 'V173', 'V173'),
(4249, 'V175', 'V175', 'V175'),
(4250, 'V177', 'V177', 'V177'),
(4251, 'v180', 'v180', 'v180'),
(4252, 'V185', 'V185', 'V185'),
(4253, 'V186', 'V186', 'V186'),
(4254, 'V188', 'V188', 'V188'),
(4255, 'V190', 'V190', 'V190'),
(4256, 'V191', 'V191', 'V191'),
(4257, 'V195', 'V195', 'V195'),
(4258, 'V197', 'V197', 'V197'),
(4259, 'V220', 'V220', 'V220'),
(4260, 'V220i', 'V220i', 'V220i'),
(4261, 'V226', 'V226', 'V226'),
(4262, 'V235', 'V235', 'V235'),
(4263, 'V237', 'V237', 'V237'),
(4264, 'V260', 'V260', 'V260'),
(4265, 'V262', 'V262', 'V262'),
(4266, 'V266', 'V266', 'V266'),
(4267, 'V270', 'V270', 'V270'),
(4268, 'V276', 'V276', 'V276'),
(4269, 'V280', 'V280', 'V280'),
(4270, 'V290', 'V290', 'V290'),
(4271, 'V291', 'V291', 'V291'),
(4272, 'V295', 'V295', 'V295'),
(4273, 'D&G', 'RAZR V3', 'D&G RAZR V3'),
(4274, 'RAZR', 'RAZR V3', 'RAZR RAZR V3'),
(4275, 'RAZR', 'V3', 'RAZR V3'),
(4276, 'V300', 'V300', 'V300'),
(4277, 'V303', 'V303', 'V303'),
(4278, 'V330', 'V330', 'V330'),
(4279, 'V333', 'V333', 'V333'),
(4280, 'V360', 'V360', 'V360'),
(4281, 'V360i', 'V360i', 'V360i'),
(4282, 'V361', 'V361', 'V361'),
(4283, 'V365', 'V365', 'V365'),
(4284, 'V380', 'V380', 'V380'),
(4285, 'RAZR', 'RAZR V3AM', 'RAZR RAZR V3AM'),
(4286, 'RAZR', 'RAZR V3S', 'RAZR RAZR V3S'),
(4287, 'RAZR', 'RAZR V3 BLK', 'RAZR RAZR V3 BLK'),
(4288, 'RAZR', 'RAZR V3c', 'RAZR RAZR V3c'),
(4289, 'RAZR', 'V3E', 'RAZR V3E'),
(4290, 'RAZR', 'RAZR V3i', 'RAZR RAZR V3i'),
(4291, 'RAZR', 'V3i', 'RAZR V3i'),
(4292, 'RAZR', 'V3ie', 'RAZR V3ie'),
(4293, 'RAZR', 'RAZR V3iv', 'RAZR RAZR V3iv'),
(4294, 'RAZR', 'RAZR V3r', 'RAZR RAZR V3r'),
(4295, 'RAZR', 'V3r', 'RAZR V3r'),
(4296, 'RAZR', 'V3re', 'RAZR V3re'),
(4297, 'RAZR', 'V3T', 'RAZR V3T'),
(4298, 'V400', 'V400', 'V400'),
(4299, 'V501', 'V501', 'V501'),
(4300, 'V505', 'V505', 'V505'),
(4301, 'V51', 'V51', 'V51'),
(4302, 'V525', 'V525', 'V525'),
(4303, 'V525M', 'V525M', 'V525M'),
(4304, 'V535', 'V535', 'V535'),
(4305, 'V536', 'V536', 'V536'),
(4306, 'V540', 'V540', 'V540'),
(4307, 'V545', 'V545', 'V545'),
(4308, 'V547', 'V547', 'V547'),
(4309, 'V550', 'V550', 'V550'),
(4310, 'V551', 'V551', 'V551'),
(4311, 'V555', 'V555', 'V555'),
(4312, 'V557', 'V557', 'V557'),
(4313, 'V560', 'V560', 'V560'),
(4314, 'V600', 'V600', 'V600'),
(4315, 'V60i', 'V60i', 'V60i'),
(4316, 'V628', 'V628', 'V628'),
(4317, 'V635', 'V635', 'V635'),
(4318, 'V660', 'V660', 'V660'),
(4319, 'V66M', 'V66M', 'V66M'),
(4320, 'V66i', 'V66i', 'V66i'),
(4321, 'V688', 'V688', 'V688'),
(4322, 'V690', 'V690', 'V690'),
(4323, 'V70', 'V70', 'V70'),
(4324, 'V710', 'V710', 'V710'),
(4325, 'V730', 'V730', 'V730'),
(4326, 'Adventure', 'V750', 'Adventure V750'),
(4327, 'RAZR2', 'V8', 'RAZR2 V8'),
(4328, 'V8088', 'V8088', 'V8088'),
(4329, 'V810', 'V810', 'V810'),
(4330, 'V820', 'V820', 'V820'),
(4331, 'V860', 'V860', 'V860'),
(4332, 'V868', 'V868', 'V868'),
(4333, 'V870', 'V870', 'V870'),
(4334, 'V872', 'V872', 'V872'),
(4335, 'V878', 'V878', 'V878'),
(4336, 'V880', 'V880', 'V880'),
(4337, 'Tyax', 'V975', 'Tyax V975'),
(4338, 'V980', 'V980', 'V980'),
(4339, '702MO', '702MO', '702MO'),
(4340, 'MOTORAZR 2', 'MOTORAZR V9M', 'MOTORAZR 2 MOTORAZR V9M'),
(4341, 'VA76r', 'VA76r', 'VA76r'),
(4342, 'VE 440', 'VE 440', 'VE 440'),
(4343, 'VE 465', 'VE 465', 'VE 465'),
(4344, 'VE538', 'VE538', 'VE538'),
(4345, 'VE66', 'VE66', 'VE66'),
(4346, 'VU204', 'VU204', 'VU204'),
(4347, 'VU30', 'VU30', 'VU30'),
(4348, 'W200', 'W200', 'W200'),
(4349, 'W213', 'W213', 'W213'),
(4350, 'W220', 'W220', 'W220'),
(4351, 'W230', 'W230', 'W230'),
(4352, 'W231', 'W231', 'W231'),
(4353, 'W233', 'W233', 'W233'),
(4354, 'W270', 'W270', 'W270'),
(4355, 'W315', 'W315', 'W315'),
(4356, 'W360', 'W360', 'W360'),
(4357, 'W370', 'W370', 'W370'),
(4358, 'W375', 'W375', 'W375'),
(4359, 'MOT-W376g', 'MOT-W376g', 'MOT-W376g'),
(4360, 'W377', 'W377', 'W377'),
(4361, 'MOT-W377', 'MOT-W377', 'MOT-W377'),
(4362, 'MOT-W377g', 'MOT-W377g', 'MOT-W377g'),
(4363, 'W385m', 'W385m', 'W385m'),
(4364, 'W388', 'W388', 'W388'),
(4365, 'W396', 'W396', 'W396'),
(4366, 'W397', 'W397', 'W397'),
(4367, 'W408g', 'W408g', 'W408g'),
(4368, 'W409G', 'W409G', 'W409G'),
(4369, 'W418G', 'W418G', 'W418G'),
(4370, 'W450', 'W450', 'W450'),
(4371, 'W490', 'W490', 'W490'),
(4372, 'W5', 'W5', 'W5'),
(4373, 'W510', 'W510', 'W510'),
(4374, 'W6', 'W6', 'W6'),
(4375, 'MOTO Active Edition', 'W7', 'MOTO Active Edition W7'),
(4376, 'Entice', 'W766', 'Entice W766'),
(4377, 'Quantico', 'W840', 'Quantico W840'),
(4378, 'W845', 'W845', 'W845'),
(4379, 'WX346', 'WX346', 'WX346'),
(4380, 'Rambler', 'WX400', 'Rambler WX400'),
(4381, 'WX404', 'WX404', 'WX404'),
(4382, 'Bali', 'WX415', 'Bali WX415'),
(4383, 'Theory', 'WX430', 'Theory WX430'),
(4384, 'MOTORIZR', 'Z3', 'MOTORIZR Z3'),
(4385, 'MOTOROKR', 'MOTOROKR Z6M', 'MOTOROKR MOTOROKR Z6M'),
(4386, 'MOTOROKR', 'Z6W', 'MOTOROKR Z6W'),
(4387, 'ZN200', 'ZN200', 'ZN200'),
(4388, 'ZN300', 'ZN300', 'ZN300'),
(4389, 'Krave', 'ZN4', 'Krave ZN4'),
(4390, 'ZN5', 'ZN5', 'ZN5'),
(4391, 'C350', 'C350', 'C350'),
(4392, 'C350M', 'C350M', 'C350M'),
(4393, 'C350i', 'C350i', 'C350i'),
(4394, 'i215', 'i215', 'i215'),
(4395, 'i415', 'i415', 'i415'),
(4396, 'i450', 'i450', 'i450'),
(4397, 'i455', 'i455', 'i455'),
(4398, 'i833', 'i833', 'i833'),
(4399, 'i835', 'i835', 'i835'),
(4400, 'i836', 'i836', 'i836'),
(4401, 'i855', 'i855', 'i855'),
(4402, 'i885', 'i885', 'i885'),
(4403, 'V3r', 'V3r', 'V3r'),
(4404, 'V150', 'V150', 'V150'),
(4405, 'V200', 'V200', 'V200'),
(4406, 'Hurricane', 'W760r', 'Hurricane W760r'),
(4407, 'RAZR', 'Z10', 'RAZR Z10'),
(4408, 'MAXX V6', 'RAZRV6', 'MAXX V6 RAZRV6'),
(4409, 'MOTORIZR', 'Z8', 'MOTORIZR Z8'),
(4410, 'MOTORIZR V8', 'RIZR V8', 'MOTORIZR V8 RIZR V8'),
(4411, 'MOTOROKR', 'MOTOROKR Z6', 'MOTOROKR MOTOROKR Z6'),
(4412, 'EX211', 'EX211', 'EX211'),
(4413, 'Gleam', 'EX212', 'Gleam EX212'),
(4414, 'EX300', 'EX300', 'EX300'),
(4415, 'WX260', 'WX260', 'WX260'),
(4416, 'WX265', 'WX265', 'WX265'),
(4417, 'WX280', 'WX280', 'WX280'),
(4418, 'WX288', 'WX288', 'WX288'),
(4419, 'WX290', 'WX290', 'WX290'),
(4420, 'WX292', 'WX292', 'WX292'),
(4421, 'WX294', 'WX294', 'WX294'),
(4422, 'WX295', 'WX295', 'WX295'),
(4423, 'WX306', 'WX306', 'WX306'),
(4424, 'Gleam+/WX308', 'MotoWX308-Profile', 'Gleam+/WX308 MotoWX308-Profile'),
(4425, 'WX390', 'WX390', 'WX390'),
(4426, 'WX395', 'WX395', 'WX395'),
(4427, 'C290-boost', 'C290-boost', 'C290-boost'),
(4428, 'E365', 'E365', 'E365'),
(4429, 'SLVR L7c', 'SLVR L7c', 'SLVR L7c'),
(4430, 'T33', 'T33', 'T33'),
(4431, 'RAZR', 'V3m-Red', 'RAZR V3m-Red'),
(4432, 'V950', 'V950', 'V950'),
(4433, 'MOTORAZR 2', 'V9m', 'MOTORAZR 2 V9m'),
(4434, 'VE20', 'VE20', 'VE20'),
(4435, 'ic402', 'ic402', 'ic402'),
(4436, 'ic502', 'ic502', 'ic502'),
(4437, 'ic602', 'ic602', 'ic602'),
(4438, 'ic902', 'ic902', 'ic902'),
(4439, 'Q', 'Q', 'Q'),
(4440, 'A4500', 'A4500', 'A4500'),
(4441, 'Q9c', 'Q9c', 'Q9c'),
(4442, 'Q9m', 'Q9m', 'Q9m'),
(4443, 'Evoke', 'Evoke', 'Evoke Evoke'),
(4444, 'E815', 'E815', 'E815'),
(4445, 'L7c', 'L7c', 'L7c'),
(4446, 'Q9', 'Q9', 'Q9'),
(4447, 'W750', 'W750', 'W750'),
(4448, 'C60', 'C60', 'C60'),
(4449, 'One Touch 156', 'One Touch 156', 'One Touch 156'),
(4450, 'One Touch 319', 'OT-319', 'One Touch 319 OT-319'),
(4451, 'One Touch 358 Tribe', 'OT-358', 'One Touch 358 Tribe OT-358'),
(4452, 'One Touch 595D Tribe', 'OT-595D', 'One Touch 595D Tribe OT-595D'),
(4453, 'One Touch 639G', 'OT-639G', 'One Touch 639G OT-639G'),
(4454, 'One Touch 768 3G', 'OT-768T', 'One Touch 768 3G OT-768T'),
(4455, 'One Touch Tribe 838', 'OT-838', 'One Touch Tribe 838 OT-838'),
(4456, 'One Touch 902', 'OT-902', 'One Touch 902 OT-902'),
(4457, 'One Touch 902A', 'OT-902A', 'One Touch 902A OT-902A'),
(4458, 'OT-306X', 'OT-306X', 'OT-306X'),
(4459, 'One Touch 308', 'OT-308', 'One Touch 308 OT-308'),
(4460, 'One Touch 308A', 'OT-308A', 'One Touch 308A OT-308A'),
(4461, 'One Touch 310A', 'OT-310A', 'One Touch 310A OT-310A'),
(4462, 'one_touch_318D', 'one_touch_318D', 'one_touch_318D'),
(4463, 'OT-361X', 'OT-361X', 'OT-361X'),
(4464, 'one_touch_385D', 'one_touch_385D', 'one_touch_385D'),
(4465, 'OT-385J', 'OT-385J', 'OT-385J'),
(4466, 'OT-385JA', 'OT-385JA', 'OT-385JA'),
(4467, 'One Touch 506', 'OT-506', 'One Touch 506 OT-506'),
(4468, 'One Touch 506A', 'OT-506A', 'One Touch 506A OT-506A'),
(4469, 'One Touch 506D', 'OT-506D', 'One Touch 506D OT-506D'),
(4470, 'One Touch 585', 'One Touch 585', 'One Touch 585'),
(4471, 'One Touch 585A', 'OT-585A', 'One Touch 585A OT-585A'),
(4472, 'One Touch 585D', 'OT-585D', 'One Touch 585D OT-585D'),
(4473, 'One Touch 585DF', 'OT-585DF', 'One Touch 585DF OT-585DF'),
(4474, 'One Touch 602', 'OT-602', 'One Touch 602 OT-602'),
(4475, 'One Touch 602a', 'One Touch 602a', 'One Touch 602a'),
(4476, 'One Touch 602D', 'OT-602D', 'One Touch 602D OT-602D'),
(4477, 'one touch 665', 'one touch 665', 'one touch 665'),
(4478, 'One Touch 720D', 'OT-720D', 'One Touch 720D OT-720D'),
(4479, 'OT-803', 'OT-803', 'OT-803'),
(4480, 'OT-803A', 'OT-803A', 'OT-803A'),
(4481, 'One Touch 810D', 'OT-810D', 'One Touch 810D OT-810D'),
(4482, 'OT-813A', 'OT-813A', 'OT-813A'),
(4483, 'OT-813D', 'OT-813D', 'OT-813D'),
(4484, 'OT-813F', 'OT-813F', 'OT-813F'),
(4485, 'One Touch 818', 'OT-818', 'One Touch 818 OT-818'),
(4486, 'OT-818A', 'OT-818A', 'OT-818A'),
(4487, 'One Touch 819', 'One Touch 819', 'One Touch 819'),
(4488, 'One Touch 819A', 'One Touch 819A', 'One Touch 819A'),
(4489, 'One Touch 870', 'OT-870', 'One Touch 870 OT-870'),
(4490, 'One Touch 870A', 'OT-870A', 'One Touch 870A OT-870A'),
(4491, 'One Touch 870X', 'OT-870X', 'One Touch 870X OT-870X'),
(4492, 'One Touch 888A', 'One Touch 888A', 'One Touch 888A'),
(4493, 'One Touch 900', 'OT-900', 'One Touch 900 OT-900'),
(4494, 'One Touch 900A', 'OT-900A', 'One Touch 900A OT-900A'),
(4495, 'One Touch 900M', 'OT-900M', 'One Touch 900M OT-900M'),
(4496, 'one_touch_901A', 'one_touch_901A', 'one_touch_901A'),
(4497, 'One Touch 905', 'OT-905', 'One Touch 905 OT-905'),
(4498, 'One Touch 905A', 'OT-905A', 'One Touch 905A OT-905A'),
(4499, 'one_touch_907D', 'one_touch_907D', 'one_touch_907D'),
(4500, 'One Touch DB@', 'One Touch DB@', 'One Touch DB@'),
(4501, 'One Touch 301', 'One Touch 301', 'One Touch 301'),
(4502, 'One Touch 501/701', 'One Touch 501/701', 'One Touch 501/701'),
(4503, 'One Touch 311', 'One Touch 311', 'One Touch 311'),
(4504, 'One Touch 511', 'One Touch 511', 'One Touch 511'),
(4505, 'One Touch 512', 'One Touch 512', 'One Touch 512'),
(4506, 'One Touch 715', 'One Touch 715', 'One Touch 715'),
(4507, 'One Touch 331/525/526/531', 'One Touch 331/525/526/531', 'One Touch 331/525/526/531'),
(4508, 'One Touch 332', 'One Touch 332', 'One Touch 332'),
(4509, 'One Touch 535', 'One Touch 535', 'One Touch 535'),
(4510, 'One Touch 735i', 'One Touch 735i', 'One Touch 735i'),
(4511, 'One Touch C651', 'One Touch C651', 'One Touch C651'),
(4512, 'E5', 'E5', 'E5'),
(4513, 'GlamPhone/ELLE-N1', 'GlamPhone/ELLE-N1', 'GlamPhone/ELLE-N1'),
(4514, 'ELLE-N3', 'ELLE-N3', 'ELLE-N3'),
(4515, 'GLAMPHONE ELLE', 'GLAMPHONE ELLE', 'GLAMPHONE ELLE'),
(4516, 'One Touch S853', 'One Touch S853', 'One Touch S853'),
(4517, 'Miss Sixty', 'Miss Sixty', 'Miss Sixty'),
(4518, 'Mandarina Duck', 'Mandarina Duck', 'Mandarina Duck'),
(4519, 'OH1C', 'OH1C', 'OH1C'),
(4520, 'One Touch 355', 'One Touch 355', 'One Touch 355'),
(4521, 'One Touch 835', 'One Touch 835', 'One Touch 835'),
(4522, 'OT-216', 'OT-216', 'OT-216'),
(4523, 'OT-255', 'OT-255', 'OT-255'),
(4524, 'OT-255A', 'OT-255A', 'OT-255A'),
(4525, 'OT-255D', 'OT-255D', 'OT-255D'),
(4526, 'ALCATEL-OT-280', 'ALCATEL-OT-280', 'ALCATEL-OT-280'),
(4527, 'OT-300', 'OT-300', 'OT-300'),
(4528, 'OT 303A', 'OT 303A', 'OT 303A'),
(4529, 'OT 305', 'OT 305', 'OT 305'),
(4530, 'OT-315M', 'OT-315M', 'OT-315M'),
(4531, 'OT-355', 'OT-355', 'OT-355'),
(4532, 'OT-355A', 'OT-355A', 'OT-355A'),
(4533, 'OT-355D', 'OT-355D', 'OT-355D'),
(4534, 'OT-360', 'OT-360', 'OT-360'),
(4535, 'OT 363', 'OT 363', 'OT 363'),
(4536, 'OT-380', 'OT-380', 'OT-380'),
(4537, 'OT 383', 'OT 383', 'OT 383'),
(4538, 'OT-383A', 'OT-383A', 'OT-383A'),
(4539, 'OT-505', 'OT-505', 'OT-505'),
(4540, 'OT-508A', 'OT-508A', 'OT-508A'),
(4541, 'OT-600', 'OT-600', 'OT-600'),
(4542, 'OT-600A', 'OT-600A', 'OT-600A'),
(4543, 'Chat', 'OT-606', 'Chat OT-606'),
(4544, 'Chat', 'OT-606A', 'Chat OT-606A'),
(4545, 'OT 660', 'OT 660', 'OT 660'),
(4546, 'OT-706', 'OT-706', 'OT-706'),
(4547, 'OT-706A', 'OT-706A', 'OT-706A'),
(4548, 'Vodafone Alcatel 541', 'OT 708', 'Vodafone Alcatel 541 OT 708'),
(4549, 'Vodafone Alcatel 541', 'OT-708A', 'Vodafone Alcatel 541 OT-708A'),
(4550, 'OT-710', 'OT-710', 'OT-710'),
(4551, 'One Touch 710A', 'OT-710A', 'One Touch 710A OT-710A'),
(4552, 'OT-710D', 'OT-710D', 'OT-710D'),
(4553, 'OT-799', 'OT-799', 'OT-799'),
(4554, 'OT-799A', 'OT-799A', 'OT-799A'),
(4555, 'Alcatel one touch Phone', 'Alcatel one touch Phone', 'Alcatel one touch Phone'),
(4556, 'Wave', 'OT-802', 'Wave OT-802'),
(4557, 'Wave', 'OT-802A', 'Wave OT-802A'),
(4558, 'Wave', 'OT-802Y', 'Wave OT-802Y'),
(4559, 'OT-806', 'OT-806', 'OT-806'),
(4560, 'OT-806D', 'OT-806D', 'OT-806D'),
(4561, 'OT-807D', 'OT-807D', 'OT-807D'),
(4562, 'OT 808', 'OT 808', 'OT 808'),
(4563, 'OT 808A', 'OT 808A', 'OT 808A'),
(4564, 'One Touch Xtra', 'OT-880', 'One Touch Xtra OT-880'),
(4565, 'One Touch Xtra', 'OT-880A', 'One Touch Xtra OT-880A'),
(4566, 'OT-C550', 'OT-C550', 'OT-C550'),
(4567, 'One Touch C551', 'One Touch C551', 'One Touch C551'),
(4568, 'OT-C552', 'OT-C552', 'OT-C552'),
(4569, 'One Touch C552a', 'One Touch C552a', 'One Touch C552a'),
(4570, 'One Touch', 'One Touch C630', 'One Touch One Touch C630'),
(4571, 'OT-C652', 'OT-C652', 'OT-C652'),
(4572, 'OT-C652a', 'OT-C652a', 'OT-C652a'),
(4573, 'OT-C700', 'OT-C700', 'OT-C700'),
(4574, 'OT-C700A', 'OT-C700A', 'OT-C700A');
INSERT INTO `smdevicenames` (`DeviceNameID`, `DeviceName`, `DeviceModel`, `MarketingName`) VALUES
(4575, 'One Touch', 'OT-C701', 'One Touch OT-C701'),
(4576, 'OT-C707', 'OT-C707', 'OT-C707'),
(4577, 'OT-C717', 'OT-C717', 'OT-C717'),
(4578, 'OT-C717A', 'OT-C717A', 'OT-C717A'),
(4579, 'One Touch C750', 'One Touch C750', 'One Touch C750'),
(4580, 'OT-C820', 'OT-C820', 'OT-C820'),
(4581, 'One Touch', 'OT-C825', 'One Touch OT-C825'),
(4582, 'One Touch S218', 'One Touch S218', 'One Touch S218'),
(4583, 'OT-S319A', 'OT-S319A', 'OT-S319A'),
(4584, 'OT S320', 'OT S320', 'OT S320'),
(4585, 'OT-S320A', 'OT-S320A', 'OT-S320A'),
(4586, 'OT S321A', 'OT S321A', 'OT S321A'),
(4587, 'OT-S520', 'OT-S520', 'OT-S520'),
(4588, 'OT-S520A', 'OT-S520A', 'OT-S520A'),
(4589, 'OT S621', 'OT S621', 'OT S621'),
(4590, 'OT-S621A', 'OT-S621A', 'OT-S621A'),
(4591, 'OT S626A', 'OT S626A', 'OT S626A'),
(4592, 'OT S920', 'OT S920', 'OT S920'),
(4593, 'OneTouch Sport', 'OneTouch Sport', 'OneTouch Sport'),
(4594, 'OT V570', 'OT V570', 'OT V570'),
(4595, 'OT V670', 'OT V670', 'OT V670'),
(4596, 'OT V670A', 'OT V670A', 'OT V670A'),
(4597, 'OT v770', 'OT v770', 'OT v770'),
(4598, 'One Touch', 'OT 153', 'One Touch OT 153'),
(4599, 'One Touch 257', 'One Touch 257', 'One Touch 257'),
(4600, 'One Touch 711', 'One Touch 711', 'One Touch 711'),
(4601, 'One Touch 556/557/565', 'One Touch 556/557/565', 'One Touch 556/557/565'),
(4602, 'One Touch 756/757', 'One Touch 756/757', 'One Touch 756/757'),
(4603, 'TH4', 'TH4', 'TH4'),
(4604, 'one touch 214', 'one touch 214', 'one touch 214'),
(4605, 'OT-306A', 'OT-306A', 'OT-306A'),
(4606, 'One Touch 361A', 'OT-361A', 'One Touch 361A OT-361A'),
(4607, 'One Touch 665', 'OT-665', 'One Touch 665 OT-665'),
(4608, 'One Touch 665A', 'OT-665A', 'One Touch 665A OT-665A'),
(4609, 'A500', 'A500', 'A500'),
(4610, 'A5001', 'A5001', 'A5001'),
(4611, 'Athena S830C', 'Athena S830C', 'Athena S830C'),
(4612, 'Morpheus', 'Morpheus', 'Morpheus'),
(4613, 'Nike1 S660C', 'Nike1 S660C', 'Nike1 S660C'),
(4614, 'S668C', 'S668C', 'S668C'),
(4615, 'S670C', 'S670C', 'S670C'),
(4616, 'S680C', 'S680C', 'S680C'),
(4617, 'S7001', 'S7001', 'S7001'),
(4618, 'S660C', 'S660C', 'S660C'),
(4619, 'P30', 'P30', 'P30'),
(4620, 'P50', 'P50', 'P50'),
(4621, 'P51', 'P51', 'P51'),
(4622, 'C36', 'C36', 'C36'),
(4623, 'CF61', 'CF61', 'CF61'),
(4624, 'CL71', 'CL71', 'CL71'),
(4625, 'E81', 'E81', 'E81'),
(4626, 'EF51', 'EF51', 'EF51'),
(4627, 'EF61', 'EF61', 'EF61'),
(4628, 'EF71', 'EF71', 'EF71'),
(4629, 'EF91', 'EF91', 'EF91'),
(4630, 'M220', 'M220', 'M220'),
(4631, 'M300', 'M300', 'M300'),
(4632, 'M305', 'M305', 'M305'),
(4633, 'M315', 'M315', 'M315'),
(4634, 'M350', 'M350', 'M350'),
(4635, 'M580', 'M580', 'M580'),
(4636, 'MD 300H', 'MD 300H', 'MD 300H'),
(4637, 'S80', 'S80', 'S80'),
(4638, 'S81', 'S81', 'S81'),
(4639, 'S82', 'S82', 'S82'),
(4640, 'S88', 'S88', 'S88'),
(4641, 'SF71', 'SF71', 'SF71'),
(4642, 'C31', 'C31', 'C31'),
(4643, 'SL80', 'SL80', 'SL80'),
(4644, 'SL91', 'SL91', 'SL91'),
(4645, 'BenQ-T51HK/1.00/WAP2.0/MIDP2.0/CLDC1.1', 'BenQ-T51HK/1.00/WAP2.0/MIDP2.0/CLDC1.1', 'BenQ-T51HK/1.00/WAP2.0/MIDP2.0/CLDC1.1'),
(4646, 'T60', 'T60', 'T60'),
(4647, 'Z2', 'Z2', 'Z2'),
(4648, 'D209i', 'D209i', 'D209i'),
(4649, 'D210i', 'D210i', 'D210i'),
(4650, 'D211i', 'D211i', 'D211i'),
(4651, 'D251i', 'D251i', 'D251i'),
(4652, 'D251iS', 'D251iS', 'D251iS'),
(4653, 'D252i', 'D252i', 'D252i'),
(4654, 'D253i', 'D253i', 'D253i'),
(4655, 'D253iWM', 'D253iWM', 'D253iWM'),
(4656, 'D501i', 'D501i', 'D501i'),
(4657, 'D502i', 'D502i', 'D502i'),
(4658, 'DoCoMo D502i', 'DoCoMo D502i', 'DoCoMo D502i'),
(4659, 'D503i', 'D503i', 'D503i'),
(4660, 'D503iS', 'D503iS', 'D503iS'),
(4661, 'D504i', 'D504i', 'D504i'),
(4662, 'D505i', 'D505i', 'D505i'),
(4663, 'D505iS', 'D505iS', 'D505iS'),
(4664, 'D506i', 'D506i', 'D506i'),
(4665, 'ER209i', 'ER209i', 'ER209i'),
(4666, 'F209i', 'F209i', 'F209i'),
(4667, 'F210i', 'F210i', 'F210i'),
(4668, 'F211i', 'F211i', 'F211i'),
(4669, 'F212i', 'F212i', 'F212i'),
(4670, 'F251i', 'F251i', 'F251i'),
(4671, 'F501i', 'F501i', 'F501i'),
(4672, 'F502i', 'F502i', 'F502i'),
(4673, 'F502it', 'F502it', 'F502it'),
(4674, 'F503i', 'F503i', 'F503i'),
(4675, 'F503iS', 'F503iS', 'F503iS'),
(4676, 'F504i', 'F504i', 'F504i'),
(4677, 'F504iS', 'F504iS', 'F504iS'),
(4678, 'F505i', 'F505i', 'F505i'),
(4679, 'F505iGPS', 'F505iGPS', 'F505iGPS'),
(4680, 'F506i', 'F506i', 'F506i'),
(4681, 'F661i', 'F661i', 'F661i'),
(4682, 'F671i', 'F671i', 'F671i'),
(4683, 'F671iS', 'F671iS', 'F671iS'),
(4684, 'F672i', 'F672i', 'F672i'),
(4685, 'KO209i', 'KO209i', 'KO209i'),
(4686, 'KO210i', 'KO210i', 'KO210i'),
(4687, 'N209i', 'N209i', 'N209i'),
(4688, 'N210i', 'N210i', 'N210i'),
(4689, 'N211i', 'N211i', 'N211i'),
(4690, 'N211iS', 'N211iS', 'N211iS'),
(4691, 'N251i', 'N251i', 'N251i'),
(4692, 'N251iS', 'N251iS', 'N251iS'),
(4693, 'N252i', 'N252i', 'N252i'),
(4694, 'N253i', 'N253i', 'N253i'),
(4695, 'N501i', 'N501i', 'N501i'),
(4696, 'N502i', 'N502i', 'N502i'),
(4697, 'N502it', 'N502it', 'N502it'),
(4698, 'N503i', 'N503i', 'N503i'),
(4699, 'N503iS', 'N503iS', 'N503iS'),
(4700, 'N504i', 'N504i', 'N504i'),
(4701, 'N504iS', 'N504iS', 'N504iS'),
(4702, '504iS', '504iS', '504iS'),
(4703, 'N505i', 'N505i', 'N505i'),
(4704, 'N505iS', 'N505iS', 'N505iS'),
(4705, 'N506i', 'N506i', 'N506i'),
(4706, 'SO506i', 'SO506i', 'SO506i'),
(4707, 'N506iS', 'N506iS', 'N506iS'),
(4708, 'N506iSII', 'N506iSII', 'N506iSII'),
(4709, 'N821i', 'N821i', 'N821i'),
(4710, 'NM502i', 'NM502i', 'NM502i'),
(4711, 'P209i', 'P209i', 'P209i'),
(4712, 'P209iS', 'P209iS', 'P209iS'),
(4713, 'P210i', 'P210i', 'P210i'),
(4714, 'P211i', 'P211i', 'P211i'),
(4715, 'P211iS', 'P211iS', 'P211iS'),
(4716, 'P213i', 'P213i', 'P213i'),
(4717, 'P251iS', 'P251iS', 'P251iS'),
(4718, 'P252i', 'P252i', 'P252i'),
(4719, 'P252iS', 'P252iS', 'P252iS'),
(4720, 'P253i', 'P253i', 'P253i'),
(4721, 'P253iS', 'P253iS', 'P253iS'),
(4722, 'P501i', 'P501i', 'P501i'),
(4723, 'P502i', 'P502i', 'P502i'),
(4724, 'P503i', 'P503i', 'P503i'),
(4725, 'P503iS', 'P503iS', 'P503iS'),
(4726, 'P504i', 'P504i', 'P504i'),
(4727, 'P504iS', 'P504iS', 'P504iS'),
(4728, 'P505i', 'P505i', 'P505i'),
(4729, 'P505iS', 'P505iS', 'P505iS'),
(4730, 'P506iCII', 'P506iCII', 'P506iCII'),
(4731, 'P651ps', 'P651ps', 'P651ps'),
(4732, 'P821i', 'P821i', 'P821i'),
(4733, 'R209i', 'R209i', 'R209i'),
(4734, 'R211i', 'R211i', 'R211i'),
(4735, 'R691i', 'R691i', 'R691i'),
(4736, 'R692i', 'R692i', 'R692i'),
(4737, 'SH251i', 'SH251i', 'SH251i'),
(4738, 'SH251iS', 'SH251iS', 'SH251iS'),
(4739, 'SH252i', 'SH252i', 'SH252i'),
(4740, 'SH505i', 'SH505i', 'SH505i'),
(4741, 'DoCoMo SH505i2', 'DoCoMo SH505i2', 'DoCoMo SH505i2'),
(4742, 'SH505iS', 'SH505iS', 'SH505iS'),
(4743, 'SH506iC', 'SH506iC', 'SH506iC'),
(4744, 'SH821i', 'SH821i', 'SH821i'),
(4745, 'SO210i', 'SO210i', 'SO210i'),
(4746, 'SO211i', 'SO211i', 'SO211i'),
(4747, 'SO212i', 'SO212i', 'SO212i'),
(4748, 'SO213i', 'SO213i', 'SO213i'),
(4749, 'SO213iS', 'SO213iS', 'SO213iS'),
(4750, 'SO213iWR', 'SO213iWR', 'SO213iWR'),
(4751, 'SO502i', 'SO502i', 'SO502i'),
(4752, 'SO502iWM', 'SO502iWM', 'SO502iWM'),
(4753, 'SO503i', 'SO503i', 'SO503i'),
(4754, 'SO503iS', 'SO503iS', 'SO503iS'),
(4755, 'SO504i', 'SO504i', 'SO504i'),
(4756, 'SO505i', 'SO505i', 'SO505i'),
(4757, 'SO505iS', 'SO505iS', 'SO505iS'),
(4758, 'SO506iC', 'SO506iC', 'SO506iC'),
(4759, 'SO506iS', 'SO506iS', 'SO506iS'),
(4760, 'PRIME series CA-01C', 'CA-01C', 'PRIME series CA-01C CA-01C'),
(4761, 'D2101V', 'D2101V', 'D2101V'),
(4762, 'D701i', 'D701i', 'D701i'),
(4763, 'D701iWM', 'D701iWM', 'D701iWM'),
(4764, 'D702i', 'D702i', 'D702i'),
(4765, 'D702iBCL', 'D702iBCL', 'D702iBCL'),
(4766, 'D702iF', 'D702iF', 'D702iF'),
(4767, 'D703i', 'D703i', 'D703i'),
(4768, 'D704i', 'D704i', 'D704i'),
(4769, 'D705i', 'D705i', 'D705i'),
(4770, 'D800iDS', 'D800iDS', 'D800iDS'),
(4771, 'D851iWM', 'D851iWM', 'D851iWM'),
(4772, 'D900i', 'D900i', 'D900i'),
(4773, 'D901i', 'D901i', 'D901i'),
(4774, 'D901iS', 'D901iS', 'D901iS'),
(4775, 'D902i', 'D902i', 'D902i'),
(4776, 'D902iS', 'D902iS', 'D902iS'),
(4777, 'D903i', 'D903i', 'D903i'),
(4778, 'D903iTV', 'D903iTV', 'D903iTV'),
(4779, 'D904i', 'D904i', 'D904i'),
(4780, 'D905i', 'D905i', 'D905i'),
(4781, 'F-01A', 'F-01A', 'F-01A'),
(4782, 'F-01B', 'F-01B', 'F-01B'),
(4783, 'F-01C', 'F-01C', 'F-01C'),
(4784, 'F-02A', 'F-02A', 'F-02A'),
(4785, 'F-02B', 'F-02B', 'F-02B'),
(4786, 'F-02C', 'F-02C', 'F-02C'),
(4787, 'STYLE series F-02D', 'F-02D', 'STYLE series F-02D F-02D'),
(4788, 'F-03A', 'F-03A', 'F-03A'),
(4789, 'F-03B', 'F-03B', 'F-03B'),
(4790, 'F-03C', 'F-03C', 'F-03C'),
(4791, 'F-04A', 'F-04A', 'F-04A'),
(4792, 'F-04B', 'F-04B', 'F-04B'),
(4793, 'F-04C', 'F-04C', 'F-04C'),
(4794, 'Style Series F-04D', 'F-04D', 'Style Series F-04D F-04D'),
(4795, 'F-05A', 'F-05A', 'F-05A'),
(4796, 'F-05C', 'F-05C', 'F-05C'),
(4797, 'F-06A', 'F-06A', 'F-06A'),
(4798, 'F-06B', 'F-06B', 'F-06B'),
(4799, 'Girls', 'F-06D', 'Girls F-06D'),
(4800, 'F-07A', 'F-07A', 'F-07A'),
(4801, 'F-07B', 'F-07B', 'F-07B'),
(4802, 'F-08A', 'F-08A', 'F-08A'),
(4803, 'F-08B', 'F-08B', 'F-08B'),
(4804, 'F-08C', 'F-08C', 'F-08C'),
(4805, 'F-09A', 'F-09A', 'F-09A'),
(4806, 'F-09B', 'F-09B', 'F-09B'),
(4807, 'PRIME series F-09C', 'F-09C', 'PRIME series F-09C F-09C'),
(4808, 'F-10A', 'F-10A', 'F-10A'),
(4809, 'F-10B', 'F-10B', 'F-10B'),
(4810, 'STYLE series F-10C', 'F10C', 'STYLE series F-10C F10C'),
(4811, 'SMART series F-11C', 'F-11C', 'SMART series F-11C F-11C'),
(4812, 'F2051', 'F2051', 'F2051'),
(4813, 'F2102V', 'F2102V', 'F2102V'),
(4814, 'F700i', 'F700i', 'F700i'),
(4815, 'F700iS', 'F700iS', 'F700iS'),
(4816, 'F702iD', 'F702iD', 'F702iD'),
(4817, 'F703i', 'F703i', 'F703i'),
(4818, 'F704i', 'F704i', 'F704i'),
(4819, 'F705i', 'F705i', 'F705i'),
(4820, 'F706i', 'F706i', 'F706i'),
(4821, 'F801i', 'F801i', 'F801i'),
(4822, 'F880iES', 'F880iES', 'F880iES'),
(4823, 'F881iES', 'F881iES', 'F881iES'),
(4824, 'F882iES', 'F882iES', 'F882iES'),
(4825, 'F883i', 'F883i', 'F883i'),
(4826, 'F883iES', 'F883iES', 'F883iES'),
(4827, 'F883iESS', 'F883iESS', 'F883iESS'),
(4828, 'F883iS', 'F883iS', 'F883iS'),
(4829, 'F884i', 'F884i', 'F884i'),
(4830, 'F884iES', 'F884iES', 'F884iES'),
(4831, 'F900i', 'F900i', 'F900i'),
(4832, 'F900iC', 'F900iC', 'F900iC'),
(4833, 'F900iT', 'F900iT', 'F900iT'),
(4834, 'F901iC', 'F901iC', 'F901iC'),
(4835, 'F901iS', 'F901iS', 'F901iS'),
(4836, 'F902i', 'F902i', 'F902i'),
(4837, 'F902iS', 'F902iS', 'F902iS'),
(4838, 'F903i', 'F903i', 'F903i'),
(4839, 'F903iBSC', 'F903iBSC', 'F903iBSC'),
(4840, 'F903iX', 'F903iX', 'F903iX'),
(4841, 'F904i', 'F904i', 'F904i'),
(4842, 'F905i', 'F905i', 'F905i'),
(4843, 'F905iBiz', 'F905iBiz', 'F905iBiz'),
(4844, 'F906i', 'F906i', 'F906i'),
(4845, 'Simulator II', 'Simulator II', 'Simulator II'),
(4846, 'L-01A', 'L-01A', 'L-01A'),
(4847, 'L-01B', 'L-01B', 'L-01B'),
(4848, 'L-01C', 'L-01C', 'L-01C'),
(4849, 'L-02B', 'L-02B', 'L-02B'),
(4850, 'L-03A', 'L-03A', 'L-03A'),
(4851, 'L-03B', 'L-03B', 'L-03B'),
(4852, 'L-03C', 'L-03C', 'L-03C'),
(4853, 'L-04A', 'L-04A', 'L-04A'),
(4854, 'L-04B', 'L-04B', 'L-04B'),
(4855, 'L-06A', 'L-06A', 'L-06A'),
(4856, 'L10c', 'L10c', 'L10c'),
(4857, 'L600i', 'L600i', 'L600i'),
(4858, 'L601i', 'L601i', 'L601i'),
(4859, 'L602i', 'L602i', 'L602i'),
(4860, 'L704i', 'L704i', 'L704i'),
(4861, 'L705i', 'L705i', 'L705i'),
(4862, 'L705iX', 'L705iX', 'L705iX'),
(4863, 'L706ie', 'L706ie', 'L706ie'),
(4864, 'Prada', 'L852i', 'Prada L852i'),
(4865, 'M702iG', 'M702iG', 'M702iG'),
(4866, 'M702iS', 'M702iS', 'M702iS'),
(4867, 'SH2101V', 'SH2101V', 'SH2101V'),
(4868, 'N-01A', 'N-01A', 'N-01A'),
(4869, 'N-01B', 'N-01B', 'N-01B'),
(4870, 'N-01C', 'N-01C', 'N-01C'),
(4871, 'N-02A', 'N-02A', 'N-02A'),
(4872, 'N-02B', 'N-02B', 'N-02B'),
(4873, 'N-02C', 'N-02C', 'N-02C'),
(4874, 'STYLE series N-02D', 'N-02D', 'STYLE series N-02D N-02D'),
(4875, 'N-03A', 'N-03A', 'N-03A'),
(4876, 'N-03B', 'N-03B', 'N-03B'),
(4877, 'N-03C', 'N-03C', 'N-03C'),
(4878, 'STYLE series N-03D', 'N-03D', 'STYLE series N-03D N-03D'),
(4879, 'N-04A', 'N-04A', 'N-04A'),
(4880, 'N-04B', 'N-04B', 'N-04B'),
(4881, 'N-05A', 'N-05A', 'N-05A'),
(4882, 'N-05B', 'N-05B', 'N-05B'),
(4883, 'SMART series N-05C', 'N-05C', 'SMART series N-05C N-05C'),
(4884, 'N-06A', 'N-06A', 'N-06A'),
(4885, 'N-06B', 'N-06B', 'N-06B'),
(4886, 'N-07A', 'N-07A', 'N-07A'),
(4887, 'N-07B', 'N-07B', 'N-07B'),
(4888, 'N-08A', 'N-08A', 'N-08A'),
(4889, 'N-08B', 'N-08B', 'N-08B'),
(4890, 'N-09A', 'N-09A', 'N-09A'),
(4891, 'N2001', 'N2001', 'N2001'),
(4892, 'N2002', 'N2002', 'N2002'),
(4893, 'N2051', 'N2051', 'N2051'),
(4894, 'N2102V', 'N2102V', 'N2102V'),
(4895, 'N2701', 'N2701', 'N2701'),
(4896, 'N600i', 'N600i', 'N600i'),
(4897, 'N601i', 'N601i', 'N601i'),
(4898, 'N700i', 'N700i', 'N700i'),
(4899, 'N701i', 'N701i', 'N701i'),
(4900, 'N701iECO', 'N701iECO', 'N701iECO'),
(4901, 'N702iD', 'N702iD', 'N702iD'),
(4902, 'N702iS', 'N702iS', 'N702iS'),
(4903, 'N703iD', 'N703iD', 'N703iD'),
(4904, 'N703i', 'N703i', 'N703i'),
(4905, 'N704i', 'N704i', 'N704i'),
(4906, 'N705i', 'N705i', 'N705i'),
(4907, 'N706i', 'N706i', 'N706i'),
(4908, 'N706iII', 'N706iII', 'N706iII'),
(4909, 'N706ie', 'N706ie', 'N706ie'),
(4910, 'N900i', 'N900i', 'N900i'),
(4911, 'N900iG', 'N900iG', 'N900iG'),
(4912, 'N900iL', 'N900iL', 'N900iL'),
(4913, 'N900iS', 'N900iS', 'N900iS'),
(4914, 'N901iC', 'N901iC', 'N901iC'),
(4915, 'N901iS', 'N901iS', 'N901iS'),
(4916, 'N902i', 'N902i', 'N902i'),
(4917, 'N902iL', 'N902iL', 'N902iL'),
(4918, 'N902iS', 'N902iS', 'N902iS'),
(4919, 'N902iX', 'N902iX', 'N902iX'),
(4920, 'N903i', 'N903i', 'N903i'),
(4921, 'N904i', 'N904i', 'N904i'),
(4922, 'N905i', 'N905i', 'N905i'),
(4923, 'Google Bot', 'N905i', 'Google Bot N905i'),
(4924, 'N905iBiz', 'N905iBiz', 'N905iBiz'),
(4925, 'N906i', 'N906i', 'N906i'),
(4926, 'N906iL', 'N906iL', 'N906iL'),
(4927, 'NM705i', 'NM705i', 'NM705i'),
(4928, 'NM706i', 'NM706i', 'NM706i'),
(4929, 'NM850iG', 'NM850iG', 'NM850iG'),
(4930, 'P-01A', 'P-01A', 'P-01A'),
(4931, 'P-01B', 'P-01B', 'P-01B'),
(4932, 'P-01C', 'P-01C', 'P-01C'),
(4933, 'P-02A', 'P-02A', 'P-02A'),
(4934, 'P-02B', 'P-02B', 'P-02B'),
(4935, 'P-02C', 'P-02C', 'P-02C'),
(4936, 'P-03A', 'P-03A', 'P-03A'),
(4937, 'P-03B', 'P-03B', 'P-03B'),
(4938, 'P-03C', 'P-03C', 'P-03C'),
(4939, 'STYLE series P-03D', 'P-03D', 'STYLE series P-03D P-03D'),
(4940, 'P-04A', 'P-04A', 'P-04A'),
(4941, 'P-04B', 'P-04B', 'P-04B'),
(4942, 'STYLE series P-04C', 'P-04C', 'STYLE series P-04C P-04C'),
(4943, 'P-05A', 'P-05A', 'P-05A'),
(4944, 'P-05B', 'P-05B', 'P-05B'),
(4945, 'PRIME series P-05C', 'P-05C', 'PRIME series P-05C P-05C'),
(4946, 'P-06A', 'P-06A', 'P-06A'),
(4947, 'P-06B', 'P-06B', 'P-06B'),
(4948, 'P06c', 'P06c', 'P06c'),
(4949, 'P-07A', 'P-07A', 'P-07A'),
(4950, 'P-07B', 'P-07B', 'P-07B'),
(4951, 'P-08A', 'P-08A', 'P-08A'),
(4952, 'P-09A', 'P-09A', 'P-09A'),
(4953, 'P-10A', 'P-10A', 'P-10A'),
(4954, 'P2002', 'P2002', 'P2002'),
(4955, 'P2101V', 'P2101V', 'P2101V'),
(4956, 'P2102V', 'P2102V', 'P2102V'),
(4957, 'P701iD', 'P701iD', 'P701iD'),
(4958, 'P702i', 'P702i', 'P702i'),
(4959, 'P702iD', 'P702iD', 'P702iD'),
(4960, 'P703i', 'P703i', 'P703i'),
(4961, 'P703i mju', 'P703i mju', 'P703i mju'),
(4962, 'P704i', 'P704i', 'P704i'),
(4963, 'P705iCL', 'P705iCL', 'P705iCL'),
(4964, 'P705i', 'P705i', 'P705i'),
(4965, 'P706ie', 'P706ie', 'P706ie'),
(4966, 'P706i', 'P706i', 'P706i'),
(4967, 'P851i', 'P851i', 'P851i'),
(4968, 'P900iV', 'P900iV', 'P900iV'),
(4969, 'P901i', 'P901i', 'P901i'),
(4970, 'P901iS', 'P901iS', 'P901iS'),
(4971, 'P901iTV', 'P901iTV', 'P901iTV'),
(4972, 'P902i', 'P902i', 'P902i'),
(4973, 'P902iS', 'P902iS', 'P902iS'),
(4974, 'P903i', 'P903i', 'P903i'),
(4975, 'P903iTV', 'P903iTV', 'P903iTV'),
(4976, 'P903iX', 'P903iX', 'P903iX'),
(4977, 'P904i', 'P904i', 'P904i'),
(4978, 'P905i', 'P905i', 'P905i'),
(4979, 'P905iTV', 'P905iTV', 'P905iTV'),
(4980, 'P906i', 'P906i', 'P906i'),
(4981, 'SA700iS', 'SA700iS', 'SA700iS'),
(4982, 'SA702i', 'SA702i', 'SA702i'),
(4983, 'SA800i', 'SA800i', 'SA800i'),
(4984, 'SH-01A', 'SH-01A', 'SH-01A'),
(4985, 'SH-01B', 'SH-01B', 'SH-01B'),
(4986, 'SH-01C', 'SH-01C', 'SH-01C'),
(4987, 'SH-02A', 'SH-02A', 'SH-02A'),
(4988, 'SH-02B', 'SH-02B', 'SH-02B'),
(4989, 'SH-02C', 'SH-02C', 'SH-02C'),
(4990, 'SH-03A', 'SH-03A', 'SH-03A'),
(4991, 'SH-03B', 'SH-03B', 'SH-03B'),
(4992, 'STYLE series SH-03D', 'SH-03D', 'STYLE series SH-03D SH-03D'),
(4993, 'SH-04A', 'SH-04A', 'SH-04A'),
(4994, 'SH-04B', 'SH-04B', 'SH-04B'),
(4995, 'SH-04C', 'SH-04C', 'SH-04C'),
(4996, 'SH-05A', 'SH-05A', 'SH-05A'),
(4997, 'Sh-05B', 'Sh-05B', 'Sh-05B'),
(4998, 'SH-05C', 'SH-05C', 'SH-05C'),
(4999, 'STYLE series SH05D', 'SH05D', 'STYLE series SH05D SH05D'),
(5000, 'SH-06A', 'SH-06A', 'SH-06A'),
(5001, 'SH-06B', 'SH-06B', 'SH-06B'),
(5002, 'SH-06C', 'SH-06C', 'SH-06C'),
(5003, 'SH-07A', 'SH-07A', 'SH-07A'),
(5004, 'SH-07B', 'SH-07B', 'SH-07B'),
(5005, 'SH-08A', 'SH-08A', 'SH-08A'),
(5006, 'SH-08B', 'SH-08B', 'SH-08B'),
(5007, 'SH-08C', 'SH-08C', 'SH-08C'),
(5008, 'SH-09B', 'SH-09B', 'SH-09B'),
(5009, 'SH-09C', 'SH-09C', 'SH-09C'),
(5010, 'PRIME series SH-10C', 'SH-10C', 'PRIME series SH-10C SH-10C'),
(5011, 'STYLE series SH-11C', 'SH-11C', 'STYLE series SH-11C SH-11C'),
(5012, 'SH700i', 'SH700i', 'SH700i'),
(5013, 'SH700iS', 'SH700iS', 'SH700iS'),
(5014, 'SH702iD', 'SH702iD', 'SH702iD'),
(5015, 'SH702iS', 'SH702iS', 'SH702iS'),
(5016, 'SH703i', 'SH703i', 'SH703i'),
(5017, 'SH704i', 'SH704i', 'SH704i'),
(5018, 'SH705i', 'SH705i', 'SH705i'),
(5019, 'SH705iII', 'SH705iII', 'SH705iII'),
(5020, 'SH706i', 'SH706i', 'SH706i'),
(5021, 'SH706ie', 'SH706ie', 'SH706ie'),
(5022, 'SH706iw', 'SH706iw', 'SH706iw'),
(5023, 'SH851i', 'SH851i', 'SH851i'),
(5024, 'SH900i', 'SH900i', 'SH900i'),
(5025, 'SH901iC', 'SH901iC', 'SH901iC'),
(5026, 'SH901iS', 'SH901iS', 'SH901iS'),
(5027, 'SH902i', 'SH902i', 'SH902i'),
(5028, 'SH902iS', 'SH902iS', 'SH902iS'),
(5029, 'SH902iSL', 'SH902iSL', 'SH902iSL'),
(5030, 'SH903i', 'SH903i', 'SH903i'),
(5031, 'SH903iTV', 'SH903iTV', 'SH903iTV'),
(5032, 'SH904i', 'SH904i', 'SH904i'),
(5033, 'SH905i', 'SH905i', 'SH905i'),
(5034, 'SH905iTV', 'SH905iTV', 'SH905iTV'),
(5035, 'SH906i', 'SH906i', 'SH906i'),
(5036, 'SH906iTV', 'SH906iTV', 'SH906iTV'),
(5037, 'SO702i', 'SO702i', 'SO702i'),
(5038, 'SO703i', 'SO703i', 'SO703i'),
(5039, 'SO704i', 'SO704i', 'SO704i'),
(5040, 'SO705i', 'SO705i', 'SO705i'),
(5041, 'SO706i', 'SO706i', 'SO706i'),
(5042, 'SO902i', 'SO902i', 'SO902i'),
(5043, 'SO902iWP', 'SO902iWP', 'SO902iWP'),
(5044, 'SO902iWP+', 'SO902iWP+', 'SO902iWP+'),
(5045, 'SO903i', 'SO903i', 'SO903i'),
(5046, 'SO903iTV', 'SO903iTV', 'SO903iTV'),
(5047, 'SO905i', 'SO905i', 'SO905i'),
(5048, 'SO905iCS', 'SO905iCS', 'SO905iCS'),
(5049, 'SO906i', 'SO906i', 'SO906i'),
(5050, 'T2101V', 'T2101V', 'T2101V'),
(5051, 'DoCoMo N2701', 'DoCoMo N2701', 'DoCoMo N2701'),
(5052, 'GR660', 'GR660', 'GR660'),
(5053, 'GR980', 'GR980', 'GR980'),
(5054, 'M131', 'M131', 'M131'),
(5055, 'Touch/Elf', 'P3450', 'Touch/Elf P3450'),
(5056, 'Artemis', 'P3300', 'Artemis P3300'),
(5057, 'Disguised as Macintosh', 'Disguised as Macintosh', 'Disguised as Macintosh'),
(5058, 'Max 4G', 'Max 4G', 'Max 4G'),
(5059, 'HTC Touch P3450 (HTC Elf 100)', 'Elf', 'HTC Touch P3450 (HTC Elf 100) Elf'),
(5060, 'P3600', 'P3600', 'P3600'),
(5061, 'Touch Dual/P5500', 'Touch Dual/P5500', 'Touch Dual/P5500'),
(5062, 'Touch Diamond', 'Touch Diamond', 'Touch Diamond'),
(5063, 'Faraday', '2125', 'Faraday 2125'),
(5064, 'Star Trek', '3100', 'Star Trek 3100'),
(5065, '8100', '8100', '8100'),
(5066, '8125', '8125', '8125'),
(5067, 'Pilgrim/Tilt', 'TyTN II', 'Pilgrim/Tilt TyTN II'),
(5068, 'Excalibur', 'Excalibur', 'Excalibur'),
(5069, 'Freestyle', 'F5151', 'Freestyle F5151'),
(5070, 'Pharos', 'P3470', 'Pharos P3470'),
(5071, 'Touch Cruise/P3650', 'Touch Cruise/P3650', 'Touch Cruise/P3650'),
(5072, 'P3700', 'P3700', 'P3700'),
(5073, 'P4550', 'P4550', 'P4550'),
(5074, 'P4600', 'P4600', 'P4600'),
(5075, 'P6500', 'P6500', 'P6500'),
(5076, 'S411', 'S411', 'S411'),
(5077, 'Excalibur', 'S621', 'Excalibur S621'),
(5078, 'Pure', 'S6356', 'Pure S6356'),
(5079, 'Tilt 2', 'ST7377', 'Tilt 2 ST7377'),
(5080, 'Nike', 'TouchDual', 'Nike TouchDual'),
(5081, 'Touch', 'Touch', 'Touch'),
(5082, 'Advantage', 'X7510', 'Advantage X7510'),
(5083, 'Herald/Wing/Atlas', 'VPA Compact IV', 'Herald/Wing/Atlas VPA Compact IV'),
(5084, 'Gemini', 'Gemini', 'Gemini'),
(5085, 'Trinity', 'P3600', 'Trinity P3600'),
(5086, 'Herald/Wing/Atlas', 'P4350', 'Herald/Wing/Atlas P4350'),
(5087, 'S410', 'S410', 'S410'),
(5088, 'Excalibur', 'S620', 'Excalibur S620'),
(5089, 'P4500/TyTN/Hermes', 'P4500/TyTN/Hermes', 'P4500/TyTN/Hermes'),
(5090, 'T8585', 'T8585', 'T8585'),
(5091, 'SPV M3100', 'SPV M3100', 'SPV M3100'),
(5092, '9000', '9000', '9000'),
(5093, 'Mega', 'Mega', 'Mega'),
(5094, 'Artemis', 'P3300/Artemis/Cruiser', 'Artemis P3300/Artemis/Cruiser'),
(5095, 'Artemis', 'P3301', 'Artemis P3301'),
(5096, 'P3350', 'P3350', 'P3350'),
(5097, 'P3400', 'P3400', 'P3400'),
(5098, 'P3400i (Gene)', 'P3400i (Gene)', 'P3400i (Gene)'),
(5099, 'P3490', 'P3490', 'P3490'),
(5100, 'P3651', 'P3651', 'P3651'),
(5101, 'P3701', 'P3701', 'P3701'),
(5102, 'Touch Diamond/Victor', 'P3702', 'Touch Diamond/Victor P3702'),
(5103, 'Touch Dual/P5520', 'Touch Dual/P5520', 'Touch Dual/P5520'),
(5104, 'P5530 (Neon)', 'P5530 (Neon)', 'P5530 (Neon)'),
(5105, 'Sedna/P6500', 'Sedna/P6500', 'Sedna/P6500'),
(5106, 'Polaris', 'Polaris', 'Polaris'),
(5107, 'S310', 'S310', 'S310'),
(5108, 'S730', 'S730', 'S730'),
(5109, 'S740', 'S740', 'S740'),
(5110, 'Smart F3188', 'Smart F3188', 'Smart F3188'),
(5111, 'Snap', 'S521', 'Snap S521'),
(5112, 'Snap S523', 'Snap S523', 'Snap S523'),
(5113, 'T8290', 'T8290', 'T8290'),
(5114, 'Quartz', 'Quartz', 'Quartz'),
(5115, 'Touch 3G T3232', 'Touch 3G T3232', 'Touch 3G T3232'),
(5116, 'Touch Cruise', 'Touch Cruise', 'Touch Cruise'),
(5117, 'Touch Diamond2', 'T5353', 'Touch Diamond2 T5353'),
(5118, 'BlackStone', 'Touch HD T8282', 'BlackStone Touch HD T8282'),
(5119, 'Touch HD T8282', '8282', 'Touch HD T8282 8282'),
(5120, 'Rhodium 100', 'Touch Pro2 T7373', 'Rhodium 100 Touch Pro2 T7373'),
(5121, 'Raphael 100', 'Touch Pro', 'Raphael 100 Touch Pro'),
(5122, 'HTC Touch Viva T2223', 'HTC Touch Viva T2223', 'HTC Touch Viva T2223'),
(5123, 'Trinity', 'Trinity', 'Trinity'),
(5124, 'TyTN', 'Hermes/TyTN', 'TyTN Hermes/TyTN'),
(5125, 'Hermes', 'Hermes', 'Hermes'),
(5126, 'TyTN II', 'TyTN II', 'TyTN II'),
(5127, 'Advantage', 'Athena', 'Advantage Athena'),
(5128, 'X7500', 'X7500', 'X7500'),
(5129, 'K-JAM', 'K-JAM', 'K-JAM'),
(5130, 'X01HT', 'X01HT', 'X01HT'),
(5131, 'P5310BM', 'P5310BM', 'P5310BM'),
(5132, 'SMT 5800', 'SMT 5800', 'SMT 5800'),
(5133, 'X02HT', 'X02HT', 'X02HT'),
(5134, 'Athena/Advantage', 'Athena/Advantage', 'Athena/Advantage'),
(5135, 'Cavalier', 'S630', 'Cavalier S630'),
(5136, 'Vodafone s710', 'V7505', 'Vodafone s710 V7505'),
(5137, 'v1415', 'v1415', 'v1415'),
(5138, 'Artemis', 'Artemis', 'Artemis Artemis'),
(5139, 'Panda', 'P6300', 'Panda P6300'),
(5140, 'Breeze/MTeoR', 'Breeze/MTeoR', 'Breeze/MTeoR'),
(5141, 'v1605', 'v1605', 'v1605'),
(5142, 'v1510', 'v1510', 'v1510'),
(5143, 'Mogul', 'PPC6800', 'Mogul PPC6800'),
(5144, '6900/Touch', '6900/Touch', '6900/Touch'),
(5145, 'PPC6850BM', 'PPC6850BM', 'PPC6850BM'),
(5146, 'BlackStone', 'Blackstone', 'BlackStone Blackstone'),
(5147, '6850', '6850', '6850'),
(5148, 'Jade', 'Jade', 'Jade'),
(5149, 'SFR v1615', 'SFR v1615', 'SFR v1615'),
(5150, 'Touch/6900', 'Touch/6900', 'Touch/6900'),
(5151, 'Kaiser', 'Kaiser', 'Kaiser'),
(5152, 'Softbank X03HT', 'Volans', 'Softbank X03HT Volans'),
(5153, 'Artemis/Cruiser', 'Artemis/Cruiser', 'Artemis/Cruiser'),
(5154, '6175', '6175', '6175'),
(5155, 'Apache', 'Apache', 'Apache'),
(5156, 'Blackstone', 'Blackstone', 'Blackstone'),
(5157, 'Blue Angel', 'Blue Angel', 'Blue Angel'),
(5158, 'Cavalier', 'Cavalier', 'Cavalier'),
(5159, 'Charmer', 'Charmer', 'Charmer'),
(5160, 'Elf/Touch/Vogue/P3050/P3450', 'Elf/Touch/Vogue/P3050/P3450', 'Elf/Touch/Vogue/P3050/P3450'),
(5161, 'Herald/Wing/Atlas', 'Herald', 'Herald/Wing/Atlas Herald'),
(5162, 'Himalaya', 'Himalaya', 'Himalaya'),
(5163, 'ST21', 'ST21', 'ST21'),
(5164, 'Juno', 'Juno', 'Juno'),
(5165, 'Love', 'Love', 'Love'),
(5166, 'Magician', 'Magician', 'Magician'),
(5167, 'Nike', 'Nike', 'Nike'),
(5168, 'HTC Opal 100', 'HTC Opal 100', 'HTC Opal 100'),
(5169, 'Oxygen', 'Oxygen', 'Oxygen'),
(5170, 'Pharos', 'Pharos', 'Pharos'),
(5171, 'Raphael', 'Raphael', 'Raphael'),
(5172, 'Rose', 'Rose', 'Rose'),
(5173, 'StarTrek', 'StarTrek', 'StarTrek'),
(5174, 'Tornado', 'Tornado', 'Tornado'),
(5175, 'Typhoon/Feeler/Sonata/Amadeus', 'Typhoon/Feeler/Sonata/Amadeus', 'Typhoon/Feeler/Sonata/Amadeus'),
(5176, 'Universal', 'Universal', 'Universal'),
(5177, 'Vox', 'Vox', 'Vox'),
(5178, 'Voyager', 'Voyager', 'Voyager'),
(5179, 'Wallaby', 'Wallaby', 'Wallaby'),
(5180, 'Wave', 'Wave', 'Wave'),
(5181, 'Volans', 'Volans', 'Volans'),
(5182, 'Touch/Elf', 'P3451', 'Touch/Elf P3451'),
(5183, 'Herald/Wing/Atlas', 'P4351', 'Herald/Wing/Atlas P4351'),
(5184, 'Wizard/Prodigy', 'Wizard/Prodigy', 'Wizard/Prodigy'),
(5185, 'HD Mini T5555', 'HD Mini T5555', 'HD Mini T5555'),
(5186, 'Compact S', 'Compact S', 'Compact S'),
(5187, 'VPA Compact ii', 'VPA Compact ii', 'VPA Compact ii'),
(5188, 'Touch Pro2 XV6875', 'Touch Pro2 XV6875', 'Touch Pro2 XV6875'),
(5189, 'A3012CA', 'A3012CA', 'A3012CA'),
(5190, 'A5302CA', 'A5302CA', 'A5302CA'),
(5191, 'A5401CA II', 'A5401CA II', 'A5401CA II'),
(5192, 'A5403CA', 'A5403CA', 'A5403CA'),
(5193, 'A5406CA', 'A5406CA', 'A5406CA'),
(5194, 'A5407CA', 'A5407CA', 'A5407CA'),
(5195, 'A5512CA', 'A5512CA', 'A5512CA'),
(5196, 'G\'zOne TYPE-R', 'G\'zOne TYPE-R', 'G\'zOne TYPE-R'),
(5197, 'W21CA/CA II', 'W21CA/CA II', 'W21CA/CA II'),
(5198, 'W31CA', 'W31CA', 'W31CA'),
(5199, 'W41CA', 'W41CA', 'W41CA'),
(5200, 'W42CA', 'W42CA', 'W42CA'),
(5201, 'W43CA', 'W43CA', 'W43CA'),
(5202, 'E03CA', 'E03CA', 'E03CA'),
(5203, 'W51CA', 'W51CA', 'W51CA'),
(5204, 'W52CA', 'W52CA', 'W52CA'),
(5205, 'W53CA', 'W53CA', 'W53CA'),
(5206, 'CA3A', 'CA3A', 'CA3A'),
(5207, 'W62CA', 'W62CA', 'W62CA'),
(5208, 'W63CA', 'W63CA', 'W63CA'),
(5209, 'CA001', 'CA001', 'CA001'),
(5210, 'CA002', 'CA002', 'CA002'),
(5211, 'CA003', 'CA003', 'CA003'),
(5212, 'CA004', 'CA004', 'CA004'),
(5213, 'CA005', 'CA005', 'CA005'),
(5214, 'G\'zOne TYPE-X', 'G\'zOne TYPE-X', 'G\'zOne TYPE-X'),
(5215, 'CA006', 'CA006', 'CA006'),
(5216, 'CA007', 'CA007', 'CA007'),
(5217, 'F001', 'F001', 'F001'),
(5218, 'C3001H', 'C3001H', 'C3001H'),
(5219, 'A5303H', 'A5303H', 'A5303H'),
(5220, 'A5303H II', 'A5303H II', 'A5303H II'),
(5221, 'W11H', 'W11H', 'W11H'),
(5222, 'W21H', 'W21H', 'W21H'),
(5223, 'W22H', 'W22H', 'W22H'),
(5224, 'PENCK', 'PENCK', 'PENCK'),
(5225, 'W32H', 'W32H', 'W32H'),
(5226, 'W41H', 'W41H', 'W41H'),
(5227, 'W42H', 'W42H', 'W42H'),
(5228, 'W43H/H II', 'W43H/H II', 'W43H/H II'),
(5229, 'W51H', 'W51H', 'W51H'),
(5230, 'W52H', 'W52H', 'W52H'),
(5231, 'W53H', 'W53H', 'W53H'),
(5232, 'W61H', 'W61H', 'W61H'),
(5233, 'W62H', 'W62H', 'W62H'),
(5234, 'W63H', 'W63H', 'W63H'),
(5235, 'H001', 'H001', 'H001'),
(5236, 'Mobile Hi-Vision CAM Wooo', 'Mobile Hi-Vision CAM Wooo', 'Mobile Hi-Vision CAM Wooo'),
(5237, 'beskey', 'beskey', 'beskey'),
(5238, 'C3002K', 'C3002K', 'C3002K'),
(5239, 'A5305K', 'A5305K', 'A5305K'),
(5240, 'A1401K', 'A1401K', 'A1401K'),
(5241, 'A5502K', 'A5502K', 'A5502K'),
(5242, 'A1403K', 'A1403K', 'A1403K'),
(5243, 'A5515K', 'A5515K', 'A5515K'),
(5244, 'A5521K', 'A5521K', 'A5521K'),
(5245, 'A5526K', 'A5526K', 'A5526K'),
(5246, 'A5528K', 'A5528K', 'A5528K'),
(5247, 'W11K', 'W11K', 'W11K'),
(5248, 'W21K', 'W21K', 'W21K'),
(5249, 'W31K/K II', 'W31K/K II', 'W31K/K II'),
(5250, 'W32K', 'W32K', 'W32K'),
(5251, 'W41K', 'W41K', 'W41K'),
(5252, 'W42K', 'W42K', 'W42K'),
(5253, 'W43K', 'W43K', 'W43K'),
(5254, 'W44K/K II', 'W44K/K II', 'W44K/K II'),
(5255, 'W51K', 'W51K', 'W51K'),
(5256, 'MEDIA SKIN', 'MEDIA SKIN', 'MEDIA SKIN'),
(5257, 'W53K/W64K', 'W53K/W64K', 'W53K/W64K'),
(5258, 'W61K', 'W61K', 'W61K'),
(5259, 'W62K', 'W62K', 'W62K'),
(5260, 'W63K', 'W63K', 'W63K'),
(5261, 'W65K', 'W65K', 'W65K'),
(5262, 'K001', 'K001', 'K001'),
(5263, 'NS01', 'NS01', 'NS01'),
(5264, 'K002', 'K002', 'K002'),
(5265, 'K003', 'K003', 'K003'),
(5266, 'misora[iida]', 'misora[iida]', 'misora[iida]'),
(5267, 'SA001', 'SA001', 'SA001'),
(5268, 'PRISMOID[iida]', 'PRISMOID[iida]', 'PRISMOID[iida]'),
(5269, 'E07K', 'E07K', 'E07K'),
(5270, 'K004', 'K004', 'K004'),
(5271, 'lotta', 'lotta', 'lotta'),
(5272, 'SA002', 'SA002', 'SA002'),
(5273, 'K005', 'K005', 'K005'),
(5274, 'K006', 'K006', 'K006'),
(5275, 'K007', 'K007', 'K007'),
(5276, 'K008', 'K008', 'K008'),
(5277, 'K009', 'K009', 'K009'),
(5278, 'C3003P', 'C3003P', 'C3003P'),
(5279, 'W51P', 'W51P', 'W51P'),
(5280, 'W52P', 'W52P', 'W52P'),
(5281, 'MA33', 'MA33', 'MA33'),
(5282, 'W62P', 'W62P', 'W62P'),
(5283, 'P001', 'P001', 'P001'),
(5284, 'A1405PT', 'A1405PT', 'A1405PT'),
(5285, 'A1406PT', 'A1406PT', 'A1406PT'),
(5286, 'A1407PT', 'A1407PT', 'A1407PT'),
(5287, 'W61PT', 'W61PT', 'W61PT'),
(5288, 'W62PT', 'W62PT', 'W62PT'),
(5289, 'NS02', 'NS02', 'NS02'),
(5290, 'PT002', 'PT002', 'PT002'),
(5291, 'A3011SA', 'A3011SA', 'A3011SA'),
(5292, 'A3015SA', 'A3015SA', 'A3015SA'),
(5293, 'A1302SA', 'A1302SA', 'A1302SA'),
(5294, 'A1303SA', 'A1303SA', 'A1303SA'),
(5295, 'A5503SA', 'A5503SA', 'A5503SA'),
(5296, 'A5505SA', 'A5505SA', 'A5505SA'),
(5297, 'A1305SA', 'A1305SA', 'A1305SA'),
(5298, 'A5522SA', 'A5522SA', 'A5522SA'),
(5299, 'A5527SA', 'A5527SA', 'A5527SA'),
(5300, 'W21SA', 'W21SA', 'W21SA'),
(5301, 'W22SA', 'W22SA', 'W22SA'),
(5302, 'W31SA/SA II', 'W31SA/SA II', 'W31SA/SA II'),
(5303, 'W32SA', 'W32SA', 'W32SA'),
(5304, 'W33SA/SA II', 'W33SA/SA II', 'W33SA/SA II'),
(5305, 'W41SA', 'W41SA', 'W41SA'),
(5306, 'E02SA', 'E02SA', 'E02SA'),
(5307, 'W43SA', 'W43SA', 'W43SA'),
(5308, 'W51SA', 'W51SA', 'W51SA'),
(5309, 'W52SA', 'W52SA', 'W52SA'),
(5310, 'W54SA', 'W54SA', 'W54SA'),
(5311, 'W61SA', 'W61SA', 'W61SA'),
(5312, 'W63SA', 'W63SA', 'W63SA'),
(5313, 'W64SA', 'W64SA', 'W64SA'),
(5314, 'W41SH', 'W41SH', 'W41SH'),
(5315, 'W51SH', 'W51SH', 'W51SH'),
(5316, 'W52SH', 'W52SH', 'W52SH'),
(5317, 'SH34', 'SH34', 'SH34'),
(5318, 'W62SH', 'W62SH', 'W62SH'),
(5319, 'URBANO', 'URBANO', 'URBANO'),
(5320, 'W64SH', 'W64SH', 'W64SH'),
(5321, 'SH001', 'SH001', 'SH001'),
(5322, 'Bot', 'Bot', 'Bot'),
(5323, 'E05SH', 'E05SH', 'E05SH'),
(5324, 'E06SH', 'E06SH', 'E06SH'),
(5325, 'SH002', 'SH002', 'SH002'),
(5326, 'Sportio water beat', 'Sportio water beat', 'Sportio water beat'),
(5327, 'SH003', 'SH003', 'SH003'),
(5328, 'SH004', 'SH004', 'SH004'),
(5329, 'SH005', 'SH005', 'SH005'),
(5330, 'SH006', 'SH006', 'SH006'),
(5331, 'SH007', 'SH007', 'SH007'),
(5332, 'SH008', 'SH008', 'SH008'),
(5333, 'SH009', 'SH009', 'SH009'),
(5334, 'SH010', 'SH010', 'SH010'),
(5335, 'SH011', 'SH011', 'SH011'),
(5336, 'A3014S', 'A3014S', 'A3014S'),
(5337, 'A1101S', 'A1101S', 'A1101S'),
(5338, 'A1301S', 'A1301S', 'A1301S'),
(5339, 'A5402S', 'A5402S', 'A5402S'),
(5340, 'A5404S', 'A5404S', 'A5404S'),
(5341, 'A1402S', 'A1402S', 'A1402S'),
(5342, 'A1402S II', 'A1402S II', 'A1402S II'),
(5343, 'A1404S/S II', 'A1404S/S II', 'A1404S/S II'),
(5344, 'W21S', 'W21S', 'W21S'),
(5345, 'W31S', 'W31S', 'W31S'),
(5346, 'W32S', 'W32S', 'W32S'),
(5347, 'W41S', 'W41S', 'W41S'),
(5348, 'W42S', 'W42S', 'W42S'),
(5349, 'W43S', 'W43S', 'W43S'),
(5350, 'W44S', 'W44S', 'W44S'),
(5351, 'W51S', 'W51S', 'W51S'),
(5352, 'W52S', 'W52S', 'W52S'),
(5353, 'W53S', 'W53S', 'W53S'),
(5354, 'W54S', 'W54S', 'W54S'),
(5355, 'W61S', 'W61S', 'W61S'),
(5356, 'W62S', 'W62S', 'W62S'),
(5357, 're', 're', 're'),
(5358, 'W64S', 'W64S', 'W64S'),
(5359, 'Xmini', 'Xmini', 'Xmini'),
(5360, 'Premier3', 'Premier3', 'Premier3'),
(5361, 'S001', 'S001', 'S001'),
(5362, 'G9[iida]', 'G9[iida]', 'G9[iida]'),
(5363, 'BRAVIA Phone U1', 'BRAVIA Phone U1', 'BRAVIA Phone U1'),
(5364, 'S002', 'S002', 'S002'),
(5365, 'URBANO BARONE', 'URBANO BARONE', 'URBANO BARONE'),
(5366, 'S003', 'S003', 'S003'),
(5367, 'S004', 'S004', 'S004'),
(5368, 'S005', 'S005', 'S005'),
(5369, 'URBANO MOND', 'URBANO MOND', 'URBANO MOND'),
(5370, 'S006', 'S006', 'S006'),
(5371, 'G11', 'G11', 'G11'),
(5372, 'S007', 'S007', 'S007'),
(5373, 'Urbano Affare', 'Urbano Affare', 'Urbano Affare'),
(5374, 'A5306ST', 'A5306ST', 'A5306ST'),
(5375, 'INFOBAR', 'INFOBAR', 'INFOBAR'),
(5376, 'A5405SA', 'A5405SA', 'A5405SA'),
(5377, 'A5507SA', 'A5507SA', 'A5507SA'),
(5378, 'talby', 'talby', 'talby'),
(5379, 'Sweets', 'Sweets', 'Sweets'),
(5380, 'A5514SA', 'A5514SA', 'A5514SA'),
(5381, 'A5518SA', 'A5518SA', 'A5518SA'),
(5382, 'Sweets pure', 'Sweets pure', 'Sweets pure'),
(5383, 'A5520SA/SA II', 'A5520SA/SA II', 'A5520SA/SA II'),
(5384, 'A5516T', 'A5516T', 'A5516T'),
(5385, 'Sweets cute', 'Sweets cute', 'Sweets cute'),
(5386, 'A5525SA', 'A5525SA', 'A5525SA'),
(5387, 'W42SA', 'W42SA', 'W42SA'),
(5388, 'W53SA', 'W53SA', 'W53SA'),
(5389, 'INFOBAR 2', 'INFOBAR 2', 'INFOBAR 2'),
(5390, 'W62SA', 'W62SA', 'W62SA'),
(5391, 'C5001T', 'C5001T', 'C5001T'),
(5392, 'A3013T', 'A3013T', 'A3013T'),
(5393, 'A5301T', 'A5301T', 'A5301T'),
(5394, 'A5304T', 'A5304T', 'A5304T'),
(5395, 'A1304T II', 'A1304T II', 'A1304T II'),
(5396, 'A5501T', 'A5501T', 'A5501T'),
(5397, 'A5504T', 'A5504T', 'A5504T'),
(5398, 'A5506T', 'A5506T', 'A5506T'),
(5399, 'TS29', 'TS29', 'TS29'),
(5400, 'A5511T', 'A5511T', 'A5511T'),
(5401, 'A5517T', 'A5517T', 'A5517T'),
(5402, 'A5523T', 'A5523T', 'A5523T'),
(5403, 'A5529T', 'A5529T', 'A5529T'),
(5404, 'W55T', 'W55T', 'W55T'),
(5405, 'W21T', 'W21T', 'W21T'),
(5406, 'W31T', 'W31T', 'W31T'),
(5407, 'W32T', 'W32T', 'W32T'),
(5408, 'W41T', 'W41T', 'W41T'),
(5409, 'neon', 'neon', 'neon'),
(5410, 'W43T', 'W43T', 'W43T'),
(5411, 'W44T/T II/T III', 'W44T/T II/T III', 'W44T/T II/T III'),
(5412, 'W45T', 'W45T', 'W45T'),
(5413, 'DRAPE', 'DRAPE', 'DRAPE'),
(5414, 'W47T', 'W47T', 'W47T'),
(5415, 'W51T', 'W51T', 'W51T'),
(5416, 'W52T', 'W52T', 'W52T'),
(5417, 'W53T', 'W53T', 'W53T'),
(5418, 'W54T', 'W54T', 'W54T'),
(5419, 'W56T', 'W56T', 'W56T'),
(5420, 'W61T', 'W61T', 'W61T'),
(5421, 'W62T', 'W62T', 'W62T'),
(5422, 'Sportio', 'Sportio', 'Sportio'),
(5423, 'W64T', 'W64T', 'W64T'),
(5424, 'W65T', 'W65T', 'W65T'),
(5425, 'T001', 'T001', 'T001'),
(5426, 'TS3O', 'TS3O', 'TS3O'),
(5427, 'TS3P', 'TS3P', 'TS3P'),
(5428, 'PLY[iida]', 'PLY[iida]', 'PLY[iida]'),
(5429, 'T003', 'T003', 'T003'),
(5430, 'T004', 'T004', 'T004'),
(5431, 'E08T', 'E08T', 'E08T'),
(5432, 'LIGHT POOL', 'LIGHT POOL', 'LIGHT POOL'),
(5433, 'T005', 'T005', 'T005'),
(5434, 'X-RAY', 'X-RAY', 'X-RAY'),
(5435, 'T006', 'T006', 'T006'),
(5436, 'T008', 'T008', 'T008'),
(5437, 'T007', 'T007', 'T007'),
(5438, 'Buckle', 'Buckle', 'Buckle'),
(5439, 'KX13', 'Dorado', 'KX13 Dorado'),
(5440, 'E2000', 'E2000', 'E2000'),
(5441, 'Garnetto', 'Garnetto', 'Garnetto'),
(5442, 'KWC-Glide', 'KWC-Glide', 'KWC-Glide'),
(5443, 'Marbl', 'K127 (Marbl)', 'Marbl K127 (Marbl)'),
(5444, 'K132', 'K132', 'K132'),
(5445, 'K24', 'K24', 'K24'),
(5446, 'K312', 'K312', 'K312'),
(5447, 'KWC-K323', 'KWC-K323', 'KWC-K323'),
(5448, 'K325 (Cyclops)', 'K325 (Cyclops)', 'K325 (Cyclops)'),
(5449, 'K483JLC', 'K483JLC', 'K483JLC'),
(5450, 'K4 XXL', 'K4 XXL', 'K4 XXL'),
(5451, 'KWC-K4xxLC', 'KWC-K4xxLC', 'KWC-K4xxLC'),
(5452, 'K4XXN', 'K4XXN', 'K4XXN'),
(5453, 'Strobe', 'K612', 'Strobe K612'),
(5454, 'Strobe', 'K612B', 'Strobe K612B'),
(5455, 'KE414', 'KE414', 'KE414'),
(5456, 'KE424c', 'KE424c', 'KE424c'),
(5457, 'KX1', 'KX1', 'KX1'),
(5458, 'KX16', 'KX16', 'KX16'),
(5459, 'KX18 Jet', 'KX18 Jet', 'KX18 Jet'),
(5460, 'Koi', 'KX2', 'Koi KX2'),
(5461, 'Phantom (KX414)', 'Phantom (KX414)', 'Phantom (KX414)'),
(5462, 'KX444c', 'KX444c', 'KX444c'),
(5463, 'KX5', 'KX5', 'KX5'),
(5464, 'KX5B', 'KX5B', 'KX5B'),
(5465, 'KX9', 'KX9', 'KX9'),
(5466, 'Neo', 'E1100', 'Neo E1100'),
(5467, 'M1000', 'M1000', 'M1000'),
(5468, 'Laylo', 'M1400', 'Laylo M1400'),
(5469, 'X-TC', 'M2000/AAN0314', 'X-TC M2000/AAN0314'),
(5470, 'G2GO', 'M2000', 'G2GO M2000'),
(5471, 'Rio', 'KWC-Rio', 'Rio KWC-Rio'),
(5472, 'Melo', 'S1300', 'Melo S1300'),
(5473, 'Jax', 'S1300/0320', 'Jax S1300/0320'),
(5474, 'Domino', 'S1310-A', 'Domino S1310-A'),
(5475, 'Domino', 'S1310-V', 'Domino S1310-V'),
(5476, 'Torino', 'S2300', 'Torino S2300'),
(5477, 'S2410', 'S2410', 'S2410'),
(5478, 'Mako S4000', 'Mako S4000', 'Mako S4000'),
(5479, 'SE44', 'SE44', 'SE44'),
(5480, 'SE47', 'SE47', 'SE47'),
(5481, '3245', '3245', '3245'),
(5482, 'QCP-5135', 'QCP-5135', 'QCP-5135'),
(5483, '7135', '7135', '7135'),
(5484, '820', '820', '820'),
(5485, 'KZ 830', 'KZ 830', 'KZ 830'),
(5486, 'G8000', 'G8000', 'G8000'),
(5487, 'G8000i', 'G8000i', 'G8000i'),
(5488, 'VX5200', 'VX5200', 'VX5200'),
(5489, 'A130', 'A130', 'A130'),
(5490, 'Black', 'A133', 'Black A133'),
(5491, 'A155', 'A155', 'A155'),
(5492, 'A160', 'A160', 'A160'),
(5493, 'A165', 'A165', 'A165'),
(5494, 'LG-A200', 'LG-A200', 'LG-A200'),
(5495, 'LG-A225', 'LG-A225', 'LG-A225'),
(5496, 'A230', 'A230', 'A230'),
(5497, 'LG-A235', 'LG-A235', 'LG-A235'),
(5498, 'LG-A250', 'LG-A250', 'LG-A250'),
(5499, 'A255', 'A255', 'A255'),
(5500, 'A258', 'A258', 'A258'),
(5501, 'LG-A290', 'LG-A290', 'LG-A290'),
(5502, 'A7110', 'A7110', 'A7110'),
(5503, 'A7150', 'A7150', 'A7150'),
(5504, 'Wine 2', 'AN430', 'Wine 2 AN430'),
(5505, 'B1300', 'B1300', 'B1300'),
(5506, 'B2000', 'B2000', 'B2000'),
(5507, 'B2050', 'B2050', 'B2050'),
(5508, 'B2060', 'B2060', 'B2060'),
(5509, 'B2070', 'B2070', 'B2070'),
(5510, 'LG-B2100', 'LG-B2100', 'LG-B2100'),
(5511, 'B2150', 'B2150', 'B2150'),
(5512, 'B2250', 'B2250', 'B2250'),
(5513, 'New Chocolate', 'BL20', 'New Chocolate BL20'),
(5514, 'Black Label', 'BL40', 'Black Label BL40'),
(5515, 'New Chocolate', 'BL42K', 'New Chocolate BL42K'),
(5516, 'LG-C100', 'LG-C100', 'LG-C100'),
(5517, 'LG-C105', 'LG-C105', 'LG-C105'),
(5518, 'C1100', 'C1100', 'C1100'),
(5519, 'C1150', 'C1150', 'C1150'),
(5520, 'C1200', 'C1200', 'C1200'),
(5521, 'C130', 'C130', 'C130'),
(5522, 'C1300', 'C1300', 'C1300'),
(5523, 'C1300i', 'C1300i', 'C1300i'),
(5524, 'C1400', 'C1400', 'C1400'),
(5525, 'C1500', 'C1500', 'C1500'),
(5526, 'C2000', 'C2000', 'C2000'),
(5527, 'C2100', 'C2100', 'C2100'),
(5528, 'C2200', 'C2200', 'C2200'),
(5529, 'C2500', 'C2500', 'C2500'),
(5530, 'C2600', 'C2600', 'C2600'),
(5531, 'Town', 'C300', 'Town C300'),
(5532, 'LG-C305', 'LG-C305', 'LG-C305'),
(5533, 'C3100', 'C3100', 'C3100'),
(5534, 'LG/C320/v1.0', 'LG/C320/v1.0', 'LG/C320/v1.0'),
(5535, 'C3300', 'C3300', 'C3300'),
(5536, 'C3310', 'C3310', 'C3310'),
(5537, 'C3320', 'C3320', 'C3320'),
(5538, 'C3380', 'C3380', 'C3380'),
(5539, 'C3400', 'C3400', 'C3400'),
(5540, 'C3600', 'C3600', 'C3600'),
(5541, 'Xpression', 'C395', 'Xpression C395'),
(5542, 'C686', 'C686', 'C686'),
(5543, 'Invision', 'CB630', 'Invision CB630'),
(5544, 'CE110', 'CE110', 'CE110'),
(5545, 'CE500', 'CE500', 'CE500'),
(5546, 'CF360', 'CF360', 'CF360'),
(5547, 'CG180', 'CG180', 'CG180'),
(5548, 'CG225', 'CG225', 'CG225'),
(5549, 'CG300', 'CG300', 'CG300'),
(5550, 'Incite', 'CT810', 'Incite CT810'),
(5551, 'CU320', 'CU320', 'CU320'),
(5552, 'CU400', 'CU400', 'CU400'),
(5553, 'CU405', 'CU405', 'CU405'),
(5554, 'CU500', 'CU500', 'CU500'),
(5555, 'CU515', 'CU515', 'CU515'),
(5556, 'CU575', 'CU575', 'CU575'),
(5557, 'CU6060', 'CU6060', 'CU6060'),
(5558, 'CU6160', 'CU6160', 'CU6160'),
(5559, 'CU720', 'CU720', 'CU720'),
(5560, 'CU8280', 'CU8280', 'CU8280'),
(5561, 'Vu', 'CU915', 'Vu CU915'),
(5562, 'Vu', 'CU920', 'Vu CU920'),
(5563, 'DG200', 'DG200', 'DG200'),
(5564, 'E500', 'E500', 'E500'),
(5565, 'F1200', 'F1200', 'F1200'),
(5566, 'F2100', 'F2100', 'F2100'),
(5567, 'F2200', 'F2200', 'F2200'),
(5568, 'F2250', 'F2250', 'F2250'),
(5569, 'F2300', 'F2300', 'F2300'),
(5570, 'F2400', 'F2400', 'F2400'),
(5571, 'F2410', 'F2410', 'F2410'),
(5572, 'F2500', 'F2500', 'F2500'),
(5573, 'F3000', 'F3000', 'F3000'),
(5574, 'F7100', 'F7100', 'F7100'),
(5575, 'F7200', 'F7200', 'F7200'),
(5576, 'F7250', 'F7250', 'F7250'),
(5577, 'F9100', 'F9100', 'F9100'),
(5578, '9200', '9200', '9200'),
(5579, 'G1100', 'G1100', 'G1100'),
(5580, 'G1500', 'G1500', 'G1500'),
(5581, 'G1600', 'G1600', 'G1600'),
(5582, 'G1610', 'G1610', 'G1610'),
(5583, 'G8100', 'G8100', 'G8100'),
(5584, 'G210', 'G210', 'G210'),
(5585, 'G262', 'G262', 'G262'),
(5586, 'G282', 'G282', 'G282'),
(5587, 'G3000', 'G3000', 'G3000'),
(5588, 'G3100', 'G3100', 'G3100'),
(5589, '4010', '4010', '4010'),
(5590, 'G4011', 'G4011', 'G4011'),
(5591, 'G4015', 'G4015', 'G4015'),
(5592, 'G4020', 'G4020', 'G4020'),
(5593, 'G4050', 'G4050', 'G4050'),
(5594, 'G510', 'G510', 'G510'),
(5595, 'G5200', 'G5200', 'G5200'),
(5596, 'G5220C', 'G5220C', 'G5220C'),
(5597, 'G5300', 'G5300', 'G5300'),
(5598, 'G5300i', 'G5300i', 'G5300i'),
(5599, 'G5310', 'G5310', 'G5310'),
(5600, 'G5400', 'G5400', 'G5400'),
(5601, 'G5410', 'G5410', 'G5410'),
(5602, 'G5500', 'G5500', 'G5500'),
(5603, 'G5600', 'G5600', 'G5600'),
(5604, 'G650', 'G650', 'G650'),
(5605, 'G7000', 'G7000', 'G7000'),
(5606, 'G7020', 'G7020', 'G7020'),
(5607, 'G7030', 'G7030', 'G7030'),
(5608, 'G7050', 'G7050', 'G7050'),
(5609, 'G7070', 'G7070', 'G7070'),
(5610, 'G7100', 'G7100', 'G7100'),
(5611, 'G7110', 'G7110', 'G7110'),
(5612, 'G7120', 'G7120', 'G7120'),
(5613, 'G7200', 'G7200', 'G7200'),
(5614, 'G828', 'G828', 'G828'),
(5615, 'G912', 'G912', 'G912'),
(5616, 'LG-GB160', 'LG-GB160', 'LG-GB160'),
(5617, 'GB170', 'GB170', 'GB170'),
(5618, 'GB175', 'GB175', 'GB175'),
(5619, 'GB190', 'GB190', 'GB190'),
(5620, 'GB210', 'GB210', 'GB210'),
(5621, 'GB220', 'GB220', 'GB220'),
(5622, 'GB230', 'GB230', 'GB230'),
(5623, 'GB250', 'GB250', 'GB250'),
(5624, 'GB255', 'GB255', 'GB255'),
(5625, 'GB270', 'GB270', 'GB270'),
(5626, 'LG-GB280', 'LG-GB280', 'LG-GB280'),
(5627, 'Viewty', 'GC-900', 'Viewty GC-900'),
(5628, 'Smart Viewty', 'GC900', 'Smart Viewty GC900'),
(5629, 'GD330', 'GD330', 'GD330'),
(5630, 'LG-GD350', 'LG-GD350', 'LG-GD350'),
(5631, 'Pop', 'GD510', 'Pop GD510'),
(5632, 'LG-GD550', 'LG-GD550', 'LG-GD550'),
(5633, 'dLite', 'GD570', 'dLite GD570'),
(5634, 'GD580', 'GD580', 'GD580'),
(5635, 'Expo', 'GD710', 'Expo GD710'),
(5636, 'Crystal', 'GD900', 'Crystal GD900'),
(5637, 'GM200', 'GM200', 'GM200'),
(5638, 'GM205', 'GM205', 'GM205'),
(5639, 'GM210', 'GM210', 'GM210'),
(5640, 'GM310', 'GM310', 'GM310'),
(5641, 'GM360', 'GM360', 'GM360'),
(5642, 'Scarlet II', 'GM600', 'Scarlet II GM600'),
(5643, 'GM730', 'GM730', 'GM730'),
(5644, 'Eigen', 'GM370', 'Eigen GM370'),
(5645, 'Xenon', 'GR500', 'Xenon GR500'),
(5646, 'Xenon', 'GR500R', 'Xenon GR500R'),
(5647, 'Xenon', 'GR501', 'Xenon GR501'),
(5648, 'Vu Plus', 'GR700', 'Vu Plus GR700'),
(5649, 'GS170', 'GS170', 'GS170'),
(5650, 'LG-GS205', 'LG-GS205', 'LG-GS205'),
(5651, 'Cookie Fresh', 'GS290', 'Cookie Fresh GS290'),
(5652, 'Prime', 'GS390', 'Prime GS390'),
(5653, 'Cookie Plus', 'GS500', 'Cookie Plus GS500'),
(5654, 'Sentio', 'GS505', 'Sentio GS505'),
(5655, 'Town/Etna Plus', 'GT350', 'Town/Etna Plus GT350'),
(5656, 'Town/Etna Plus', 'LG-GT350', 'Town/Etna Plus LG-GT350'),
(5657, 'GT360', 'GT360', 'GT360'),
(5658, 'Neon', 'LG-GT365', 'Neon LG-GT365'),
(5659, 'GT370', 'GT370', 'GT370'),
(5660, 'Viewty Smile', 'GT400', 'Viewty Smile GT400'),
(5661, 'Viewty GT', 'GT405', 'Viewty GT GT405'),
(5662, 'Puccini', 'GT500', 'Puccini GT500'),
(5663, 'GT505', 'GT505', 'GT505'),
(5664, 'Encore', 'LG-GT550', 'Encore LG-GT550'),
(5665, 'GT810H', 'GT810H', 'GT810H'),
(5666, 'Met', 'GT950', 'Met GT950'),
(5667, 'GU220', 'GU220', 'GU220'),
(5668, 'GU230', 'GU230', 'GU230'),
(5669, 'Popcorn', 'GU280', 'Popcorn GU280'),
(5670, 'Popcorn', 'GU282', 'Popcorn GU282'),
(5671, 'GU285', 'GU285', 'GU285'),
(5672, 'GU295', 'GU295', 'GU295'),
(5673, 'Smart', 'GW300', 'Smart GW300'),
(5674, 'LG-GW300FD', 'LG-GW300FD', 'LG-GW300FD'),
(5675, 'LG-GW305', 'LG-GW305', 'LG-GW305'),
(5676, 'Neon 2', 'GW370', 'Neon 2 GW370'),
(5677, 'GW382f', 'GW382f', 'GW382f'),
(5678, 'Calisto', 'GW520', 'Calisto GW520'),
(5679, 'Calisto', 'GW525', 'Calisto GW525'),
(5680, 'Tiger', 'GW820', 'Tiger GW820'),
(5681, 'GW825', 'GW825', 'GW825'),
(5682, 'GX200', 'GX200', 'GX200'),
(5683, 'LG-GX300', 'LG-GX300', 'LG-GX300'),
(5684, 'LG-GX500', 'LG-GX500', 'LG-GX500'),
(5685, 'HB620T', 'HB620T', 'HB620T'),
(5686, 'Scarlet Phone', 'KB775F', 'Scarlet Phone KB775F'),
(5687, 'KC550', 'KC550', 'KC550'),
(5688, 'KC560', 'KC560', 'KC560'),
(5689, 'KC780', 'KC780', 'KC780'),
(5690, 'Renoir', 'KC910', 'Renoir KC910'),
(5691, 'KD876', 'KD876', 'KD876'),
(5692, 'KE260', 'KE260', 'KE260'),
(5693, 'KE500', 'KE500', 'KE500'),
(5694, 'KE520', 'KE520', 'KE520'),
(5695, 'KE590i', 'KE590i', 'KE590i'),
(5696, 'KE600', 'KE600', 'KE600'),
(5697, 'KE600E', 'KE600E', 'KE600E'),
(5698, 'KE770', 'KE770', 'KE770'),
(5699, 'KE800', 'KE800', 'KE800'),
(5700, 'KE820', 'KE820', 'KE820'),
(5701, 'Prada', 'KE850', 'Prada KE850'),
(5702, 'KE970', 'KE970', 'KE970'),
(5703, 'Viewty', 'KE990', 'Viewty KE990'),
(5704, 'Viewty', 'KE998', 'Viewty KE998'),
(5705, 'KF240', 'KF240', 'KF240'),
(5706, 'KF245', 'KF245', 'KF245'),
(5707, 'KF300', 'KF300', 'KF300'),
(5708, 'LGE/KF305', 'LGE/KF305', 'LGE/KF305'),
(5709, 'KF310', 'KF310', 'KF310'),
(5710, 'KF311', 'KF311', 'KF311'),
(5711, 'KF350', 'KF350', 'KF350'),
(5712, 'KF390', 'KF390', 'KF390'),
(5713, 'KF510', 'KF510', 'KF510'),
(5714, 'KF600', 'KF600', 'KF600'),
(5715, 'LG-KF600d', 'LG-KF600d', 'LG-KF600d'),
(5716, 'KF700', 'KF700', 'KF700'),
(5717, 'KF700C', 'KF700C', 'KF700C'),
(5718, 'LG-KF700Q', 'LG-KF700Q', 'LG-KF700Q'),
(5719, 'Secret', 'KF750', 'Secret KF750'),
(5720, 'Secret', 'LG/KF750/v1.0', 'Secret LG/KF750/v1.0'),
(5721, 'Secret', 'KF757', 'Secret KF757'),
(5722, 'Prada', 'KF900', 'Prada KF900'),
(5723, 'KG110', 'KG110', 'KG110'),
(5724, 'KG120', 'KG120', 'KG120'),
(5725, 'KG130', 'KG130', 'KG130'),
(5726, 'KG190', 'KG190', 'KG190'),
(5727, 'KG195', 'KG195', 'KG195'),
(5728, 'KG200', 'KG200', 'KG200'),
(5729, 'KG200j', 'KG200j', 'KG200j'),
(5730, 'KX208', 'KX208', 'KX208'),
(5731, 'KG220', 'KG220', 'KG220'),
(5732, 'KG225', 'KG225', 'KG225'),
(5733, 'KG240', 'KG240', 'KG240'),
(5734, 'KG245', 'KG245', 'KG245'),
(5735, 'KG280', 'KG280', 'KG280'),
(5736, 'KG290', 'KG290', 'KG290'),
(5737, 'KG290UAE', 'KG290UAE', 'KG290UAE'),
(5738, 'KG296', 'KG296', 'KG296'),
(5739, 'KG300', 'KG300', 'KG300'),
(5740, 'KG300j', 'KG300j', 'KG300j'),
(5741, 'KG320', 'KG320', 'KG320'),
(5742, 'AEGIS', 'AEGIS', 'AEGIS'),
(5743, 'KG70', 'KG70', 'KG70'),
(5744, 'KG77', 'KG77', 'KG77'),
(5745, 'Chocolate', 'KG800', 'Chocolate KG800'),
(5746, 'KG810', 'KG810', 'KG810'),
(5747, 'KG90', 'KG90', 'KG90'),
(5748, 'KG920', 'KG920', 'KG920'),
(5749, 'KG98', 'KG98', 'KG98'),
(5750, 'KM330', 'KM330', 'KM330'),
(5751, 'KM335', 'KM335', 'KM335'),
(5752, 'KM380', 'KM380', 'KM380'),
(5753, 'LG-KM385', 'LG-KM385', 'LG-KM385'),
(5754, 'LG-KM386', 'LG-KM386', 'LG-KM386'),
(5755, 'KM500', 'KM500', 'KM500'),
(5756, 'LGE/KM501', 'LGE/KM501', 'LGE/KM501'),
(5757, 'KM555', 'KM555', 'KM555'),
(5758, 'Cookie Music', 'KM570', 'Cookie Music KM570'),
(5759, 'KM710', 'KM710', 'KM710'),
(5760, 'KM900', 'KM900', 'KM900'),
(5761, 'LG-KM900', 'LG-KM900', 'LG-KM900'),
(5762, 'KP110', 'KP110', 'KP110'),
(5763, 'LGE/KP115', 'LGE/KP115', 'LGE/KP115'),
(5764, 'KP130', 'KP130', 'KP130'),
(5765, 'LGE/KP135', 'LGE/KP135', 'LGE/KP135'),
(5766, 'KP15xQ', 'KP15xQ', 'KP15xQ'),
(5767, 'KP170', 'KP170', 'KP170'),
(5768, 'KP175', 'KP175', 'KP175'),
(5769, 'LG KP199', 'LG KP199', 'LG KP199'),
(5770, 'KP200', 'KP200', 'KP200'),
(5771, 'KP202', 'KP202', 'KP202'),
(5772, 'LGE/KP202', 'LGE/KP202', 'LGE/KP202'),
(5773, 'KP210', 'KP210', 'KP210'),
(5774, 'KP215', 'KP215', 'KP215'),
(5775, 'KP220', 'KP220', 'KP220'),
(5776, 'LGE/KP230', 'LGE/KP230', 'LGE/KP230'),
(5777, 'KP233', 'KP233', 'KP233'),
(5778, 'KP235', 'KP235', 'KP235'),
(5779, 'KP260', 'KP260', 'KP260'),
(5780, 'LG-KP265', 'LG-KP265', 'LG-KP265'),
(5781, 'KP270', 'KP270', 'KP270'),
(5782, 'LG-KP275', 'LG-KP275', 'LG-KP275'),
(5783, 'KP320', 'KP320', 'KP320'),
(5784, 'KP500', 'KP500', 'KP500'),
(5785, 'Cookie', 'KP501', 'Cookie KP501'),
(5786, 'Cookie', 'KP502', 'Cookie KP502'),
(5787, 'KP505', 'KP505', 'KP505'),
(5788, 'KP550', 'KP550', 'KP550'),
(5789, 'LG-KP570', 'LG-KP570', 'LG-KP570'),
(5790, 'JOY', 'KS10', 'JOY KS10'),
(5791, 'Tribe', 'KS360', 'Tribe KS360'),
(5792, 'LG-KS365', 'LG-KS365', 'LG-KS365'),
(5793, 'KS660', 'KS660', 'KS660'),
(5794, 'KT520', 'KT520', 'KT520'),
(5795, 'KU250', 'KU250', 'KU250'),
(5796, 'KU311', 'KU311', 'KU311'),
(5797, 'KU380', 'KU380', 'KU380'),
(5798, 'KU580', 'KU580', 'KU580'),
(5799, 'KU730', 'KU730', 'KU730'),
(5800, 'KU800', 'KU800', 'KU800'),
(5801, 'KU970', 'KU970', 'KU970'),
(5802, 'Viewty', 'KU990', 'Viewty KU990'),
(5803, 'L1100', 'L1100', 'L1100'),
(5804, 'L1150', 'L1150', 'L1150'),
(5805, 'L1200', 'L1200', 'L1200'),
(5806, 'L1400', 'L1400', 'L1400'),
(5807, 'L1400i', 'L1400i', 'L1400i'),
(5808, 'L3100', 'L3100', 'L3100'),
(5809, 'L5100', 'L5100', 'L5100'),
(5810, 'LG100', 'LG100', 'LG100'),
(5811, 'LG100C', 'LG100C', 'LG100C'),
(5812, '145PRE', '145PRE', '145PRE'),
(5813, 'LG-LG1500', 'LG-LG1500', 'LG-LG1500'),
(5814, 'LG220C', 'LG220C', 'LG220C'),
(5815, '225', '225', '225'),
(5816, 'Nite', 'LG230', 'Nite LG230'),
(5817, 'Nite', 'LG231C', 'Nite LG231C'),
(5818, 'LG260', 'LG260', 'LG260'),
(5819, 'LG-LG410G', 'LG-LG410G', 'LG-LG410G'),
(5820, 'LG-LG420G', 'LG-LG420G', 'LG-LG420G'),
(5821, 'LG500', 'LG500', 'LG500'),
(5822, 'LG501C', 'LG501C', 'LG501C'),
(5823, '511C', '511C', '511C'),
(5824, 'LG-LG620G', 'LG-LG620G', 'LG-LG620G'),
(5825, '800G', '800G', '800G'),
(5826, 'LG900G', 'LG900G', 'LG900G'),
(5827, 'Rumor', 'LN510', 'Rumor LN510'),
(5828, 'LP1000', 'LP1000', 'LP1000'),
(5829, 'LX140', 'LX140', 'LX140'),
(5830, 'LX150', 'LX150', 'LX150'),
(5831, 'LX160', 'LX160', 'LX160'),
(5832, 'LG-LX165', 'LG-LX165', 'LG-LX165'),
(5833, 'LX260', 'LX260', 'LX260'),
(5834, 'LX350', 'LX350', 'LX350'),
(5835, 'LX400', 'LX400', 'LX400'),
(5836, 'LX550', 'LX550', 'LX550'),
(5837, 'LX570', 'LX570', 'LX570'),
(5838, 'LX600', 'LX600', 'LX600'),
(5839, 'M4300', 'M4300', 'M4300'),
(5840, 'M4410', 'M4410', 'M4410'),
(5841, 'M6100', 'M6100', 'M6100'),
(5842, 'ME240', 'ME240', 'ME240'),
(5843, 'ME500', 'ME500', 'ME500'),
(5844, 'ME500c', 'ME500c', 'ME500c'),
(5845, 'ME540c', 'ME540c', 'ME540c'),
(5846, 'ME550', 'ME550', 'ME550'),
(5847, 'ME550c', 'ME550c', 'ME550c'),
(5848, 'ME591', 'ME591', 'ME591'),
(5849, 'ME591D', 'ME591D', 'ME591D'),
(5850, 'Shine', 'ME770', 'Shine ME770'),
(5851, 'ME770c', 'ME770c', 'ME770c'),
(5852, 'ME770d', 'ME770d', 'ME770d'),
(5853, 'ME830', 'ME830', 'ME830'),
(5854, 'PRADA', 'ME850c', 'PRADA ME850c'),
(5855, 'ME850d', 'ME850d', 'ME850d'),
(5856, 'ME970', 'ME970', 'ME970'),
(5857, 'ME970c', 'ME970c', 'ME970c'),
(5858, 'ME970d', 'ME970d', 'ME970d'),
(5859, 'MG100', 'MG100', 'MG100'),
(5860, 'MG100a', 'MG100a', 'MG100a'),
(5861, 'MG100c', 'MG100c', 'MG100c'),
(5862, 'MG101', 'MG101', 'MG101'),
(5863, 'MG105', 'MG105', 'MG105'),
(5864, 'MG110', 'MG110', 'MG110'),
(5865, 'LGE/MG110', 'LGE/MG110', 'LGE/MG110'),
(5866, 'MG112', 'MG112', 'MG112'),
(5867, 'MG120', 'MG120', 'MG120'),
(5868, 'MG125', 'MG125', 'MG125'),
(5869, 'MG130', 'MG130', 'MG130'),
(5870, 'MG150', 'MG150', 'MG150'),
(5871, 'MG155', 'MG155', 'MG155'),
(5872, 'MG155c', 'MG155c', 'MG155c'),
(5873, 'MG160', 'MG160', 'MG160'),
(5874, 'MG170', 'MG170', 'MG170'),
(5875, 'MG180c', 'MG180c', 'MG180c'),
(5876, 'MG185', 'MG185', 'MG185'),
(5877, 'MG191', 'MG191', 'MG191'),
(5878, 'MG191b', 'MG191b', 'MG191b'),
(5879, 'MG200', 'MG200', 'MG200'),
(5880, 'MG200c', 'MG200c', 'MG200c'),
(5881, 'MG200d', 'MG200d', 'MG200d'),
(5882, 'MG201d', 'MG201d', 'MG201d'),
(5883, 'MG210', 'MG210', 'MG210'),
(5884, 'LG-MG210', 'LG-MG210', 'LG-MG210'),
(5885, 'MG220', 'MG220', 'MG220'),
(5886, 'MG225d', 'MG225d', 'MG225d'),
(5887, 'LGE/MG225d', 'LGE/MG225d', 'LGE/MG225d'),
(5888, 'MG230', 'MG230', 'MG230'),
(5889, 'MG230d', 'MG230d', 'MG230d'),
(5890, 'MG235', 'MG235', 'MG235'),
(5891, 'MG280', 'MG280', 'MG280'),
(5892, 'MG280c', 'MG280c', 'MG280c'),
(5893, 'MG280d', 'MG280d', 'MG280d'),
(5894, 'MG295', 'MG295', 'MG295'),
(5895, 'MG296', 'MG296', 'MG296'),
(5896, 'MG300D', 'MG300D', 'MG300D'),
(5897, 'MG320', 'MG320', 'MG320'),
(5898, 'MG320c', 'MG320c', 'MG320c'),
(5899, 'MG320d', 'MG320d', 'MG320d'),
(5900, 'MG530', 'MG530', 'MG530'),
(5901, 'MG610c', 'MG610c', 'MG610c'),
(5902, 'MG800', 'MG800', 'MG800'),
(5903, 'Chocolate', 'MG800c', 'Chocolate MG800c'),
(5904, 'MG810', 'MG810', 'MG810'),
(5905, 'MG810C', 'MG810C', 'MG810C'),
(5906, 'MG-810d', 'MG-810d', 'MG-810d'),
(5907, 'MU500', 'MU500', 'MU500'),
(5908, 'MU515', 'MU515', 'MU515'),
(5909, 'MU550', 'MU550', 'MU550'),
(5910, 'MU575', 'MU575', 'MU575'),
(5911, 'NX550', 'NX550', 'NX550'),
(5912, 'OG200', 'OG200', 'OG200'),
(5913, 'LG-P520', 'LG-P520', 'LG-P520'),
(5914, 'LG-P525', 'LG-P525', 'LG-P525'),
(5915, 'P7200', 'P7200', 'P7200');
INSERT INTO `smdevicenames` (`DeviceNameID`, `DeviceName`, `DeviceModel`, `MarketingName`) VALUES
(5916, 'PLS350', 'PLS350', 'PLS350'),
(5917, 'LG-S310', 'LG-S310', 'LG-S310'),
(5918, 'S365', 'S365', 'S365'),
(5919, 'LG-S367', 'LG-S367', 'LG-S367'),
(5920, 'S5000', 'S5000', 'S5000'),
(5921, 'S5100 MIC', 'S5100 MIC', 'S5100 MIC'),
(5922, 'S5300', 'S5300', 'S5300'),
(5923, 'Cookie Lite', 'T300', 'Cookie Lite T300'),
(5924, 'Cookie Style', 'T310', 'Cookie Style T310'),
(5925, 'LG-T310i', 'LG-T310i', 'LG-T310i'),
(5926, 'LG-T315i', 'LG-T315i', 'LG-T315i'),
(5927, 'LG-T320', 'LG-T320', 'LG-T320'),
(5928, 'T320g', 'T320g', 'T320g'),
(5929, 'LG-T325', 'LG-T325', 'LG-T325'),
(5930, 'T5100', 'T5100', 'T5100'),
(5931, 'TD7130', 'TD7130', 'TD7130'),
(5932, 'Neon', 'TE365', 'Neon TE365'),
(5933, 'Chocolate', 'TG800', 'Chocolate TG800'),
(5934, 'TU500', 'TU500', 'TU500'),
(5935, 'TU515', 'TU515', 'TU515'),
(5936, 'TU550', 'TU550', 'TU550'),
(5937, 'TU575', 'TU575', 'TU575'),
(5938, 'Shine', 'TU720', 'Shine TU720'),
(5939, 'TU750', 'TU750', 'TU750'),
(5940, 'VU', 'LGE/TU915', 'VU LGE/TU915'),
(5941, 'U300', 'U300', 'U300'),
(5942, 'U310', 'U310', 'U310'),
(5943, 'U8138', 'U8138', 'U8138'),
(5944, 'U8200', 'U8200', 'U8200'),
(5945, 'U8210', 'U8210', 'U8210'),
(5946, 'U8290', 'U8290', 'U8290'),
(5947, 'U8360', 'U8360', 'U8360'),
(5948, 'U8550', 'U8550', 'U8550'),
(5949, 'U880', 'U880', 'U880'),
(5950, 'U890', 'U890', 'U890'),
(5951, 'U900', 'U900', 'U900'),
(5952, 'U990', 'U990', 'U990'),
(5953, 'W3000', 'W3000', 'W3000'),
(5954, 'W5200', 'W5200', 'W5200'),
(5955, 'X330T', 'X330T', 'X330T'),
(5956, 'X335', 'X335', 'X335'),
(5957, 'LG/HB620/v1.0', 'LG/HB620/v1.0', 'LG/HB620/v1.0'),
(5958, 'KB620', 'KB620', 'KB620'),
(5959, 'KB770', 'KB770', 'KB770'),
(5960, 'Renoir', 'KC910i', 'Renoir KC910i'),
(5961, 'Viewty', 'KE990c', 'Viewty KE990c'),
(5962, 'KF690', 'KF690', 'KF690'),
(5963, 'Secret', 'KF755', 'Secret KF755'),
(5964, 'KP330', 'KP330', 'KP330'),
(5965, 'KS500Q', 'KS500Q', 'KS500Q'),
(5966, 'KU385', 'KU385', 'KU385'),
(5967, 'KU450', 'KU450', 'KU450'),
(5968, 'KU950', 'KU950', 'KU950'),
(5969, 'LG/KU950/v1.0', 'LG/KU950/v1.0', 'LG/KU950/v1.0'),
(5970, 'Viewty', 'KU990i', 'Viewty KU990i'),
(5971, 'L600v', 'L600v', 'L600v'),
(5972, 'U250', 'U250', 'U250'),
(5973, 'U370', 'U370', 'U370'),
(5974, 'U400', 'U400', 'U400'),
(5975, 'U450', 'U450', 'U450'),
(5976, 'U8120', 'U8120', 'U8120'),
(5977, 'U8130', 'U8130', 'U8130'),
(5978, 'U8180F', 'U8180F', 'U8180F'),
(5979, 'U830', 'U830', 'U830'),
(5980, 'U8330', 'U8330', 'U8330'),
(5981, 'U8380', 'U8380', 'U8380'),
(5982, 'U960', 'U960', 'U960'),
(5983, 'Shine', 'U970', 'Shine U970'),
(5984, '10000', '10000', '10000'),
(5985, 'LG210', 'LG210', 'LG210'),
(5986, 'LG245', 'LG245', 'LG245'),
(5987, 'Parrot', '265', 'Parrot 265'),
(5988, 'Script', '265', 'Script 265'),
(5989, '285', '285', '285'),
(5990, 'LG370', 'LG370', 'LG370'),
(5991, '380', '380', '380'),
(5992, 'LG4750', 'LG4750', 'LG4750'),
(5993, 'LG490', 'LG490', 'LG490'),
(5994, '535', '535', '535'),
(5995, 'LG 5500', 'LG 5500', 'LG 5500'),
(5996, 'LGE/LG600G', 'LGE/LG600G', 'LGE/LG600G'),
(5997, 'Bliss - Volt', 'LG700', 'Bliss - Volt LG700'),
(5998, '7100', '7100', '7100'),
(5999, 'LG8100', 'LG8100', 'LG8100'),
(6000, 'Spider 2', 'LG840', 'Spider 2 LG840'),
(6001, 'Chocolate Spin', 'LG8550', 'Chocolate Spin LG8550'),
(6002, 'ChocolateFlip', '8600', 'ChocolateFlip 8600'),
(6003, 'LG8700-parrot', 'LG8700-parrot', 'LG8700-parrot'),
(6004, 'Shine', 'LG8700', 'Shine LG8700'),
(6005, 'Venus', '8800', 'Venus 8800'),
(6006, 'Parrot', '9100', 'Parrot 9100'),
(6007, '9100', '9100', '9100'),
(6008, '9250', '9250', '9250'),
(6009, 'LG9600', 'LG9600', 'LG9600'),
(6010, 'LG9700', 'LG9700', 'LG9700'),
(6011, 'AD 5235', 'AD 5235', 'AD 5235'),
(6012, 'AD6335', 'AD6335', 'AD6335'),
(6013, 'Saber', 'AN200', 'Saber AN200'),
(6014, 'AX245', 'AX245', 'AX245'),
(6015, 'AX260', 'AX260', 'AX260'),
(6016, 'AX 265', 'AX 265', 'AX 265'),
(6017, 'AX275', 'AX275', 'AX275'),
(6018, 'AX300', 'AX300', 'AX300'),
(6019, 'Helix', 'AX310', 'Helix AX310'),
(6020, 'AX3200', 'AX3200', 'AX3200'),
(6021, 'AX355', 'AX355', 'AX355'),
(6022, 'AX380', 'AX380', 'AX380'),
(6023, 'AX390', 'AX390', 'AX390'),
(6024, 'AX4270', 'AX4270', 'AX4270'),
(6025, 'AX4750', 'AX4750', 'AX4750'),
(6026, 'AX490', 'AX490', 'AX490'),
(6027, 'AX5000', 'AX5000', 'AX5000'),
(6028, 'AX5450', 'AX5450', 'AX5450'),
(6029, 'AX565', 'AX565', 'AX565'),
(6030, 'Rhythm', 'AX585', 'Rhythm AX585'),
(6031, 'AX830', 'AX830', 'AX830'),
(6032, 'AX8600', 'AX8600', 'AX8600'),
(6033, 'BD2030', 'BD2030', 'BD2030'),
(6034, 'BP4270', 'BP4270', 'BP4270'),
(6035, 'BP5000', 'BP5000', 'BP5000'),
(6036, 'BX4170', 'BX4170', 'BX4170'),
(6037, 'Easy Shot BX5450', 'Easy Shot BX5450', 'Easy Shot BX5450'),
(6038, 'CU6260', 'CU6260', 'CU6260'),
(6039, 'CU8080', 'CU8080', 'CU8080'),
(6040, 'CU8180', 'CU8180', 'CU8180'),
(6041, 'CU8188', 'CU8188', 'CU8188'),
(6042, 'CU8380', 'CU8380', 'CU8380'),
(6043, 'CX5450', 'CX5450', 'CX5450'),
(6044, 'DB230', 'DB230', 'DB230'),
(6045, 'DB520', 'DB520', 'DB520'),
(6046, 'DB525', 'DB525', 'DB525'),
(6047, 'DM120', 'DM120', 'DM120'),
(6048, 'DM510', 'DM510', 'DM510'),
(6049, 'DM515H', 'DM515H', 'DM515H'),
(6050, 'Rumor Plus', 'GW370B', 'Rumor Plus GW370B'),
(6051, 'LG125', 'LG125', 'LG125'),
(6052, 'LG150', 'LG150', 'LG150'),
(6053, 'LG160P', 'LG160P', 'LG160P'),
(6054, 'LG160V', 'LG160V', 'LG160V'),
(6055, 'LGE-LG200/1.0', 'LGE-LG200/1.0', 'LGE-LG200/1.0'),
(6056, '245', '245', '245'),
(6057, '290C', '290C', '290C'),
(6058, 'LG300', 'LG300', 'LG300'),
(6059, 'LG3200', 'LG3200', 'LG3200'),
(6060, 'LG380', 'LG380', 'LG380'),
(6061, 'LG385', 'LG385', 'LG385'),
(6062, 'LG4600', 'LG4600', 'LG4600'),
(6063, 'LG5400', 'LG5400', 'LG5400'),
(6064, '550', '550', '550'),
(6065, 'LG570', 'LG570', 'LG570'),
(6066, 'LG570V', 'LG570V', 'LG570V'),
(6067, 'LG600', 'LG600', 'LG600'),
(6068, 'G6070', 'G6070', 'G6070'),
(6069, 'LG6190', 'LG6190', 'LG6190'),
(6070, 'LGE-LG6200', 'LGE-LG6200', 'LGE-LG6200'),
(6071, 'LG800', 'LG800', 'LG800'),
(6072, 'LG830', 'LG830', 'LG830'),
(6073, 'LG8380', 'LG8380', 'LG8380'),
(6074, 'Helix', 'LW310', 'Helix LW310'),
(6075, 'LX125', 'LX125', 'LX125'),
(6076, 'LX535', 'LX535', 'LX535'),
(6077, 'LX5350', 'LX5350', 'LX5350'),
(6078, 'MM535', 'MM535', 'MM535'),
(6079, 'MN180', 'MN180', 'MN180'),
(6080, 'Imprint', 'MN240', 'Imprint MN240'),
(6081, 'Beacon', 'MN270', 'Beacon MN270'),
(6082, 'Helix', 'MT310', 'Helix MT310'),
(6083, 'Lyrics', 'MT375', 'Lyrics MT375'),
(6084, 'MX200', 'MX200', 'MX200'),
(6085, 'MX210', 'MX210', 'MX210'),
(6086, 'MX240', 'MX240', 'MX240'),
(6087, 'MX275', 'MX275', 'MX275'),
(6088, 'MX300', 'MX300', 'MX300'),
(6089, 'MX380', 'MX380', 'MX380'),
(6090, 'MX500', 'MX500', 'MX500'),
(6091, 'MX505', 'MX505', 'MX505'),
(6092, 'MX510', 'MX510', 'MX510'),
(6093, 'MX535', 'MX535', 'MX535'),
(6094, 'MX7000', 'MX7000', 'MX7000'),
(6095, 'Chocolate', 'MX800', 'Chocolate MX800'),
(6096, 'MX830', 'MX830', 'MX830'),
(6097, 'MX8500', 'MX8500', 'MX8500'),
(6098, 'MX8550', 'MX8550', 'MX8550'),
(6099, 'MX8700', 'MX8700', 'MX8700'),
(6100, 'MX9700', 'MX9700', 'MX9700'),
(6101, 'PLS225', 'PLS225', 'PLS225'),
(6102, 'PLS535', 'PLS535', 'PLS535'),
(6103, 'PM225', 'PM225', 'PM225'),
(6104, 'PM325', 'PM325', 'PM325'),
(6105, 'TD6000', 'TD6000', 'TD6000'),
(6106, 'TM240', 'TM240', 'TM240'),
(6107, 'TM250', 'TM250', 'TM250'),
(6108, 'TM510', 'TM510', 'TM510'),
(6109, 'TM520', 'TM520', 'TM520'),
(6110, 'TM540C', 'TM540C', 'TM540C'),
(6111, 'TM910', 'TM910', 'TM910'),
(6112, 'U8150', 'U8150', 'U8150'),
(6113, 'Envoy', 'UN150', 'Envoy UN150'),
(6114, 'Saber UN200', 'UN200', 'Saber UN200 UN200'),
(6115, 'VI-125', 'VI-125', 'VI-125'),
(6116, 'vi5225', 'vi5225', 'vi5225'),
(6117, 'VM101', 'VM101', 'VM101'),
(6118, 'VM265', 'VM265', 'VM265'),
(6119, 'Rumor Touch', 'VM510', 'Rumor Touch VM510'),
(6120, 'Revere', 'VN150', 'Revere VN150'),
(6121, 'Cosmos', 'VN-250', 'Cosmos VN-250'),
(6122, 'VX3100', 'VX3100', 'VX3100'),
(6123, 'VX3200', 'VX3200', 'VX3200'),
(6124, 'VX3300', 'VX3300', 'VX3300'),
(6125, 'VX4500', 'VX4500', 'VX4500'),
(6126, 'VX4600', 'VX4600', 'VX4600'),
(6127, 'VX4650', 'VX4650', 'VX4650'),
(6128, 'VX4700', 'VX4700', 'VX4700'),
(6129, 'VX5300', 'VX5300', 'VX5300'),
(6130, 'VX-5400', 'VX-5400', 'VX-5400'),
(6131, 'VX5600', 'VX5600', 'VX5600'),
(6132, 'VX6000', 'VX6000', 'VX6000'),
(6133, 'VX6100', 'VX6100', 'VX6100'),
(6134, 'VX7000', 'VX7000', 'VX7000'),
(6135, 'Glance', 'VX 7100', 'Glance VX 7100'),
(6136, 'VX8000', 'VX8000', 'VX8000'),
(6137, 'VX8100', 'VX8100', 'VX8100'),
(6138, 'VX8300', 'VX8300', 'VX8300'),
(6139, 'VX8350', 'VX8350', 'VX8350'),
(6140, 'VX 8360', 'VX 8360', 'VX 8360'),
(6141, 'VX8500', 'VX8500', 'VX8500'),
(6142, 'VX8550', 'VX8550', 'VX8550'),
(6143, 'VX-8560', 'VX-8560', 'VX-8560'),
(6144, 'VX8600', 'VX8600', 'VX8600'),
(6145, 'VX-8610', 'VX-8610', 'VX-8610'),
(6146, 'VX8700', 'VX8700', 'VX8700'),
(6147, 'VX8800', 'VX8800', 'VX8800'),
(6148, 'VX9100', 'VX9100', 'VX9100'),
(6149, 'VX9400', 'VX9400', 'VX9400'),
(6150, 'VX9800', 'VX9800', 'VX9800'),
(6151, 'VX9900', 'VX9900', 'VX9900'),
(6152, 'N800', 'N800', 'N800'),
(6153, 'N900', 'N900', 'N900'),
(6154, 'Trium Odissey M6b', 'Trium Odissey M6b', 'Trium Odissey M6b'),
(6155, 'Trium 110', 'Trium 110', 'Trium 110'),
(6156, 'M120770', 'M120770', 'M120770'),
(6157, 'M520', 'M520', 'M520'),
(6158, 'M800', 'M800', 'M800'),
(6159, 'Mondo', 'Mondo', 'Mondo'),
(6160, 'Trium Eclipse', 'Trium Eclipse', 'Trium Eclipse'),
(6161, 'MT560', 'MT560', 'MT560'),
(6162, 'One Touch 531', 'One Touch 531', 'One Touch 531'),
(6163, 'M330', 'M330', 'M330'),
(6164, 'M172', 'M172', 'M172'),
(6165, 'M750', 'M750', 'M750'),
(6166, 'M900', 'M900', 'M900'),
(6167, 'N530i', 'N530i', 'N530i'),
(6168, 'N550i', 'N550i', 'N550i'),
(6169, 'T535i', 'T535i', 'T535i'),
(6170, 'N400i', 'N400i', 'N400i'),
(6171, 'N590i', 'N590i', 'N590i'),
(6172, 'N630i', 'N630i', 'N630i'),
(6173, 'Generic iMode', 'Generic iMode', 'Generic iMode'),
(6174, 'N110', 'N110', 'N110'),
(6175, '525', '525', '525'),
(6176, '530', '530', '530'),
(6177, 'e606', 'e606', 'e606'),
(6178, 'E616', 'E616', 'E616'),
(6179, 'a232', 'a232', 'a232'),
(6180, 'DB7000', 'DB7000', 'DB7000'),
(6181, 'E122', 'E122', 'E122'),
(6182, 'e232', 'e232', 'e232'),
(6183, 'N200', 'N200', 'N200'),
(6184, 'N500', 'N500', 'N500'),
(6185, 'N535', 'N535', 'N535'),
(6186, 'N600', 'N600', 'N600'),
(6187, 'N6206', 'N6206', 'N6206'),
(6188, 'N700', 'N700', 'N700'),
(6189, 'N710', 'N710', 'N710'),
(6190, 'N8', 'N8', 'N8'),
(6191, 'N8000', 'N8000', 'N8000'),
(6192, 'N810', 'N810', 'N810'),
(6193, 'N820', 'N820', 'N820'),
(6194, 'N830', 'N830', 'N830'),
(6195, 'N840', 'N840', 'N840'),
(6196, 'N850', 'N850', 'N850'),
(6197, 'N908', 'N908', 'N908'),
(6198, 'N917', 'N917', 'N917'),
(6199, 'N923', 'N923', 'N923'),
(6200, 'E101', 'E101', 'E101'),
(6201, 'E1101', 'E1101', 'E1101'),
(6202, 'e121', 'e121', 'e121'),
(6203, 'E235', 'E235', 'E235'),
(6204, 'e238', 'e238', 'e238'),
(6205, 'e242', 'e242', 'e242'),
(6206, 'e353', 'e353', 'e353'),
(6207, 'E373', 'E373', 'E373'),
(6208, 'e540', 'e540', 'e540'),
(6209, 'e949', 'e949', 'e949'),
(6210, 'DS', 'DS', 'DS'),
(6211, '3DS', '3DS', '3DS'),
(6212, 'Wii U', 'Wii U', 'Wii U'),
(6213, 'Wii', 'Wii', 'Wii'),
(6214, 'DSi', 'DSi', 'DSi'),
(6215, 'G600i', 'G600i', 'G600i'),
(6216, 'A100', 'A100', 'A100'),
(6217, 'A200', 'A200', 'A200'),
(6218, 'G50', 'G50', 'G50'),
(6219, 'G60', 'G60', 'G60'),
(6220, 'G70', 'G70', 'G70'),
(6221, 'GD35', 'GD35', 'GD35'),
(6222, 'GD55', 'GD55', 'GD55'),
(6223, 'GD67', 'GD67', 'GD67'),
(6224, 'GD75', 'GD75', 'GD75'),
(6225, 'GD76', 'GD76', 'GD76'),
(6226, 'GD87', 'GD87', 'GD87'),
(6227, 'GD95', 'GD95', 'GD95'),
(6228, 'GD96', 'GD96', 'GD96'),
(6229, 'MX6', 'MX6', 'MX6'),
(6230, 'MX7', 'MX7', 'MX7'),
(6231, 'SA6', 'SA6', 'SA6'),
(6232, 'SA7', 'SA7', 'SA7'),
(6233, 'SC3', 'SC3', 'SC3'),
(6234, 'VS2', 'VS2', 'VS2'),
(6235, 'VS3', 'VS3', 'VS3'),
(6236, 'VS6', 'VS6', 'VS6'),
(6237, 'VS7', 'VS7', 'VS7'),
(6238, 'X100', 'X100', 'X100'),
(6239, 'X200', 'X200', 'X200'),
(6240, 'X200P', 'X200P', 'X200P'),
(6241, 'X300', 'X300', 'X300'),
(6242, 'X400', 'X400', 'X400'),
(6243, 'X400P', 'X400P', 'X400P'),
(6244, 'X500', 'X500', 'X500'),
(6245, 'X60', 'X60', 'X60'),
(6246, 'X66', 'X66', 'X66'),
(6247, 'x68', 'x68', 'x68'),
(6248, 'X70', 'X70', 'X70'),
(6249, 'X700', 'X700', 'X700'),
(6250, 'X701', 'X701', 'X701'),
(6251, 'X77', 'X77', 'X77'),
(6252, 'X800', 'X800', 'X800'),
(6253, 'G51E', 'G51E', 'G51E'),
(6254, 'G51M', 'G51M', 'G51M'),
(6255, 'G200', 'G200', 'G200'),
(6256, 'G300', 'G300', 'G300'),
(6257, 'G500', 'G500', 'G500'),
(6258, 'C180', 'C180', 'C180'),
(6259, 'C520', 'C520', 'C520'),
(6260, 'C530', 'C530', 'C530'),
(6261, 'C570', 'C570', 'C570'),
(6262, 'C610', 'C610', 'C610'),
(6263, 'C630', 'C630', 'C630'),
(6264, 'C740', 'C740', 'C740'),
(6265, 'Aladdin', 'C790', 'Aladdin C790'),
(6266, 'Duo', 'C810', 'Duo C810'),
(6267, 'Matrix Pro', 'C820', 'Matrix Pro C820'),
(6268, 'EUROPA U4000', 'EUROPA U4000', 'EUROPA U4000'),
(6269, 'P4000', 'P4000', 'P4000'),
(6270, 'P7000', 'P7000', 'P7000'),
(6271, 'PN-3200', 'PN-3200', 'PN-3200'),
(6272, 'PG-1000S', 'PG-1000S', 'PG-1000S'),
(6273, '1200', '1200', '1200'),
(6274, '1210', '1210', '1210'),
(6275, 'PG-1300', 'PG-1300', 'PG-1300'),
(6276, '1310V', '1310V', '1310V'),
(6277, '1400', '1400', '1400'),
(6278, 'PG-1405', 'PG-1405', 'PG-1405'),
(6279, 'PG-1410', 'PG-1410', 'PG-1410'),
(6280, 'PG-1500J', 'PG-1500J', 'PG-1500J'),
(6281, 'PG-1600', 'PG-1600', 'PG-1600'),
(6282, '1610', '1610', '1610'),
(6283, '1810', '1810', '1810'),
(6284, 'PG-1900', 'PG-1900', 'PG-1900'),
(6285, 'PG-2800', 'PG-2800', 'PG-2800'),
(6286, 'PG-3000', 'PG-3000', 'PG-3000'),
(6287, 'PG 3210', 'PG 3210', 'PG 3210'),
(6288, 'PG-3300', 'PG-3300', 'PG-3300'),
(6289, 'PG 331', 'PG 331', 'PG 331'),
(6290, 'PG-3500', 'PG-3500', 'PG-3500'),
(6291, 'PG-3600J', 'PG-3600J', 'PG-3600J'),
(6292, '3700', '3700', '3700'),
(6293, 'PG-3810', 'PG-3810', 'PG-3810'),
(6294, 'PG-3900', 'PG-3900', 'PG-3900'),
(6295, 'PG-6200', 'PG-6200', 'PG-6200'),
(6296, 'PG-8000', 'PG-8000', 'PG-8000'),
(6297, 'PG-C120', 'PG-C120', 'PG-C120'),
(6298, 'PG-C150', 'PG-C150', 'PG-C150'),
(6299, 'PG-C300', 'PG-C300', 'PG-C300'),
(6300, 'PG-C510', 'PG-C510', 'PG-C510'),
(6301, 'PT-G310', 'PT-G310', 'PT-G310'),
(6302, 'PT-G310c', 'PT-G310c', 'PT-G310c'),
(6303, 'PT-G510', 'PT-G510', 'PT-G510'),
(6304, 'PT-G600', 'PT-G600', 'PT-G600'),
(6305, 'PG-G670', 'PG-G670', 'PG-G670'),
(6306, 'PT-G700', 'PT-G700', 'PT-G700'),
(6307, 'PT-G800', 'PT-G800', 'PT-G800'),
(6308, 'PT-G900', 'PT-G900', 'PT-G900'),
(6309, 'PT-GB100', 'PT-GB100', 'PT-GB100'),
(6310, 'PT-GB200', 'PT-GB200', 'PT-GB200'),
(6311, 'PT-BG210', 'PT-BG210', 'PT-BG210'),
(6312, 'PT GB300', 'PT GB300', 'PT GB300'),
(6313, 'GB310', 'GB310', 'GB310'),
(6314, 'PG-GF100', 'PG-GF100', 'PG-GF100'),
(6315, 'PT-GF200', 'PT-GF200', 'PT-GF200'),
(6316, 'PT-GF200J', 'PT-GF200J', 'PT-GF200J'),
(6317, 'PT-GF260', 'PT-GF260', 'PT-GF260'),
(6318, 'GF500', 'GF500', 'GF500'),
(6319, 'PT-GF500', 'PT-GF500', 'PT-GF500'),
(6320, 'PT-GI100J', 'PT-GI100J', 'PT-GI100J'),
(6321, 'C8816', 'C8816', 'C8816'),
(6322, 'Ease', 'P2020', 'Ease P2020'),
(6323, 'Link II', 'P5000', 'Link II P5000'),
(6324, 'Pursuit II', 'P6010', 'Pursuit II P6010'),
(6325, 'Link', 'P7040', 'Link P7040'),
(6326, 'P9020', 'P9020', 'P9020'),
(6327, 'Laser', 'P9050', 'Laser P9050'),
(6328, '162', '162', '162'),
(6329, '163', '163', '163'),
(6330, '330', '330', '330'),
(6331, '350', '350', '350'),
(6332, '355', '355', '355'),
(6333, 'Fisio 630', 'Fisio 630', 'Fisio 630'),
(6334, 'Fisio 636', 'Fisio 636', 'Fisio 636'),
(6335, 'Fisio 639', 'Fisio 639', 'Fisio 639'),
(6336, '768', '768', '768'),
(6337, '855', '855', '855'),
(6338, '960', '960', '960'),
(6339, 'Azalis', 'Azalis', 'Azalis'),
(6340, 'Fisio 330', 'Fisio 330', 'Fisio 330'),
(6341, 'Fisio 620', 'Fisio 620', 'Fisio 620'),
(6342, 'Fisio 625', 'Fisio 625', 'Fisio 625'),
(6343, 'Fisio 820', 'Fisio 820', 'Fisio 820'),
(6344, 'Fisio 822', 'Fisio 822', 'Fisio 822'),
(6345, 'Fisio 825', 'Fisio 825', 'Fisio 825'),
(6346, '826', '826', '826'),
(6347, 'Fisio 311', 'Fisio 311', 'Fisio 311'),
(6348, 'Fisio 121', 'Fisio 121', 'Fisio 121'),
(6349, 'Ozeo', 'Ozeo', 'Ozeo'),
(6350, 'V21', 'V21', 'V21'),
(6351, 'VThin', 'VThin', 'VThin'),
(6352, 'Xenium 9@9', 'Xenium 9@9', 'Xenium 9@9'),
(6353, '289', '289', '289'),
(6354, '362-1', '362-1', '362-1'),
(6355, '362-2', '362-2', '362-2'),
(6356, '568', '568', '568'),
(6357, '650', '650', '650'),
(6358, '655', '655', '655'),
(6359, 'S660', 'S660', 'S660'),
(6360, '661', '661', '661'),
(6361, '755', '755', '755'),
(6362, '760', '760', '760'),
(6363, '766', '766', '766'),
(6364, '859', '859', '859'),
(6365, '9@9H', '9@9H', '9@9H'),
(6366, '598', '598', '598'),
(6367, '9A9W', '9A9W', '9A9W'),
(6368, 'Philips-198', 'Philips-198', 'Philips-198'),
(6369, '199', '199', '199'),
(6370, 'E100', 'E100', 'E100'),
(6371, 'E210', 'E210', 'E210'),
(6372, 'PHILIPS-P390', 'PHILIPS-P390', 'PHILIPS-P390'),
(6373, 'S890', 'S890', 'S890'),
(6374, 'PhilipsX116', 'PhilipsX116', 'PhilipsX116'),
(6375, 'PhilipsX128', 'PhilipsX128', 'PhilipsX128'),
(6376, 'PhilipsX130', 'PhilipsX130', 'PhilipsX130'),
(6377, 'X710', 'X710', 'X710'),
(6378, '292', '292', '292'),
(6379, '588', '588', '588'),
(6380, '9@9k', '9@9k', '9@9k'),
(6381, '9@9Q', '9@9Q', '9@9Q'),
(6382, 'Xenium', 'E102', 'Xenium E102'),
(6383, 'F511', 'F511', 'F511'),
(6384, 'PhilipsX100', 'PhilipsX100', 'PhilipsX100'),
(6385, 'PhilipsX216', 'PhilipsX216', 'PhilipsX216'),
(6386, 'X312', 'X312', 'X312'),
(6387, 'X703', 'X703', 'X703'),
(6388, 'x331', 'x331', 'x331'),
(6389, 'X501', 'X501', 'X501'),
(6390, 'X503', 'X503', 'X503'),
(6391, 'Xenium', 'X520', 'Xenium X520'),
(6392, 'X600', 'X600', 'X600'),
(6393, 'X830', 'X830', 'X830'),
(6394, 'M222i', 'M222i', 'M222i'),
(6395, 'TS21i', 'TS21i', 'TS21i'),
(6396, 'TS21iC', 'TS21iC', 'TS21iC'),
(6397, 'TS2li', 'TS2li', 'TS2li'),
(6398, 'M21i', 'M21i', 'M21i'),
(6399, 'n21i', 'n21i', 'n21i'),
(6400, '223i', '223i', '223i'),
(6401, 'n22i', 'n22i', 'n22i'),
(6402, 'E378i', 'E378i', 'E378i'),
(6403, 'G402i', 'G402i', 'G402i'),
(6404, 'G410i', 'G410i', 'G410i'),
(6405, 'G411i', 'G411i', 'G411i'),
(6406, 'DreamPhone G500i', 'G500i', 'DreamPhone G500i G500i'),
(6407, 'G550i', 'G550i', 'G550i'),
(6408, 'KG291i', 'KG291i', 'KG291i'),
(6409, 'KP202i', 'KP202i', 'KP202i'),
(6410, 'L341i', 'L341i', 'L341i'),
(6411, 'L342i', 'L342i', 'L342i'),
(6412, 'L343i', 'L343i', 'L343i'),
(6413, 'L6imode', 'L6imode', 'L6imode'),
(6414, 'L7imode', 'L7imode', 'L7imode'),
(6415, 'M341i', 'M341i', 'M341i'),
(6416, 'M342i', 'M342i', 'M342i'),
(6417, 'M420i', 'M420i', 'M420i'),
(6418, 'M430i', 'M430i', 'M430i'),
(6419, '341i', '341i', '341i'),
(6420, '331i', '331i', '331i'),
(6421, '333i', '333i', '333i'),
(6422, 'n342i', 'n342i', 'n342i'),
(6423, 'n343i', 'n343i', 'n343i'),
(6424, 'N344i', 'N344i', 'N344i'),
(6425, 'N401i', 'N401i', 'N401i'),
(6426, 'N410i', 'N410i', 'N410i'),
(6427, 'N411i', 'N411i', 'N411i'),
(6428, 'N412i', 'N412i', 'N412i'),
(6429, 'N500i', 'N500i', 'N500i'),
(6430, 'N500iS', 'N500iS', 'N500iS'),
(6431, '600i', '600i', '600i'),
(6432, 'NK600i', 'NK600i', 'NK600i'),
(6433, 'NK601i', 'NK601i', 'NK601i'),
(6434, 'N70i', 'N70i', 'N70i'),
(6435, 'p341i', 'p341i', 'p341i'),
(6436, 'p342i', 'p342i', 'p342i'),
(6437, 'S341i', 'S341i', 'S341i'),
(6438, 'S342i', 'S342i', 'S342i'),
(6439, 'S400i', 'S400i', 'S400i'),
(6440, 'S401i', 'S401i', 'S401i'),
(6441, 'S410i', 'S410i', 'S410i'),
(6442, 'S501i', 'S501i', 'S501i'),
(6443, 'SGH-S720i', 'SGH-S720i', 'SGH-S720i'),
(6444, 'S730i', 'S730i', 'S730i'),
(6445, 'SG321i', 'SG321i', 'SG321i'),
(6446, 'SG322i', 'SG322i', 'SG322i'),
(6447, 'SG341i', 'SG341i', 'SG341i'),
(6448, 'SG342i', 'SG342i', 'SG342i'),
(6449, 'SG343i', 'SG343i', 'SG343i'),
(6450, 'SG344i', 'SG344i', 'SG344i'),
(6451, 'SG345i', 'SG345i', 'SG345i'),
(6452, 'SG346i', 'SG346i', 'SG346i'),
(6453, 'Si331i/CXi70', 'Si331i/CXi70', 'Si331i/CXi70'),
(6454, 'Si341i', 'Si341i', 'Si341i'),
(6455, 'SI400i', 'SI400i', 'SI400i'),
(6456, 'TS222i', 'TS222i', 'TS222i'),
(6457, '30i', '30i', '30i'),
(6458, 'TSM-7', 'TSM-7', 'TSM-7'),
(6459, 'TSM-7i', 'TSM-7i', 'TSM-7i'),
(6460, 'W580im', 'W580im', 'W580im'),
(6461, 'Z650i', 'Z650i', 'Z650i'),
(6462, 'my401Ci', 'my401Ci', 'my401Ci'),
(6463, 'my411Ci', 'my411Ci', 'my411Ci'),
(6464, 'my411Xi', 'my411Xi', 'my411Xi'),
(6465, 'Sagem MY501C', 'Sagem MY501C', 'Sagem MY501C'),
(6466, 'my511Xi', 'my511Xi', 'my511Xi'),
(6467, 'my700Xi', 'my700Xi', 'my700Xi'),
(6468, 'my700X imode', 'my700X imode', 'my700X imode'),
(6469, 'myC5-3i', 'myC5-3i', 'myC5-3i'),
(6470, 'n31i', 'n31i', 'n31i'),
(6471, 'RAZR V3xxi iZar', 'RAZR V3xxi iZar', 'RAZR V3xxi iZar'),
(6472, 'SGH-S710i', 'SGH-S710i', 'SGH-S710i'),
(6473, 'S200', 'S200', 'S200'),
(6474, '8010', '8010', '8010'),
(6475, '8020', '8020', '8020'),
(6476, '8080', '8080', '8080'),
(6477, '9090', '9090', '9090'),
(6478, 'Xda II', 'Xda II', 'Xda II'),
(6479, '3000', '3000', '3000'),
(6480, '3016', '3016', '3016'),
(6481, '3XXX', '3XXX', '3XXX'),
(6482, 'my3062', 'my3062', 'my3062'),
(6483, '910', '910', '910'),
(6484, '912', '912', '912'),
(6485, '916', '916', '916'),
(6486, '919', '919', '919'),
(6487, '920', '920', '920'),
(6488, '922', '922', '922'),
(6489, '926', '926', '926'),
(6490, '929', '929', '929'),
(6491, '930', '930', '930'),
(6492, '932', '932', '932'),
(6493, '936', '936', '936'),
(6494, '939', '939', '939'),
(6495, '940', '940', '940'),
(6496, '942', '942', '942'),
(6497, '946', '946', '946'),
(6498, '949', '949', '949'),
(6499, '950', '950', '950'),
(6500, '952', '952', '952'),
(6501, '956', '956', '956'),
(6502, '959', '959', '959'),
(6503, '9XX', '9XX', '9XX'),
(6504, 'CO210', 'CO210', 'CO210'),
(6505, 'MC2007', 'MC2007', 'MC2007'),
(6506, 'myMobileTV', 'myMobileTV', 'myMobileTV'),
(6507, 'VF526', 'VF526', 'VF526'),
(6508, 'Vodafone 527', 'Vodafone 527', 'Vodafone 527'),
(6509, 'VF533', 'VF533', 'VF533'),
(6510, 'VF540', 'VF540', 'VF540'),
(6511, 'mw 3020', 'mw 3020', 'mw 3020'),
(6512, 'mw 3022', 'mw 3022', 'mw 3022'),
(6513, 'mw 3026', 'mw 3026', 'mw 3026'),
(6514, 'mw 3040', 'mw 3040', 'mw 3040'),
(6515, 'mw 3042', 'mw 3042', 'mw 3042'),
(6516, 'mw 3046', 'mw 3046', 'mw 3046'),
(6517, 'my100x', 'my100x', 'my100x'),
(6518, 'my200x', 'my200x', 'my200x'),
(6519, 'my201x', 'my201x', 'my201x'),
(6520, 'My X2', 'My X2', 'My X2'),
(6521, 'MY202C', 'MY202C', 'MY202C'),
(6522, 'my202x', 'my202x', 'my202x'),
(6523, 'my213x', 'my213x', 'my213x'),
(6524, 'MY214X', 'MY214X', 'MY214X'),
(6525, 'my300X', 'my300X', 'my300X'),
(6526, 'my301X', 'my301X', 'my301X'),
(6527, 'my 3020', 'my 3020', 'my 3020'),
(6528, 'my 3022', 'my 3022', 'my 3022'),
(6529, 'my 3026', 'my 3026', 'my 3026'),
(6530, 'my302X', 'my302X', 'my302X'),
(6531, 'my 3030', 'my 3030', 'my 3030'),
(6532, 'my 3032', 'my 3032', 'my 3032'),
(6533, 'my3036', 'my3036', 'my3036'),
(6534, 'my 3040', 'my 3040', 'my 3040'),
(6535, 'my 3042', 'my 3042', 'my 3042'),
(6536, 'my 3046', 'my 3046', 'my 3046'),
(6537, 'my 3052', 'my 3052', 'my 3052'),
(6538, 'my312X', 'my312X', 'my312X'),
(6539, 'MY400V', 'MY400V', 'MY400V'),
(6540, 'my400X', 'my400X', 'my400X'),
(6541, 'MY401C', 'MY401C', 'MY401C'),
(6542, 'my401X', 'my401X', 'my401X'),
(6543, 'MY401Z', 'MY401Z', 'MY401Z'),
(6544, 'MY405X', 'MY405X', 'MY405X'),
(6545, 'my411C', 'my411C', 'my411C'),
(6546, 'MY411Cv', 'MY411Cv', 'MY411Cv'),
(6547, 'MY411V', 'MY411V', 'MY411V'),
(6548, 'MY411X', 'MY411X', 'MY411X'),
(6549, 'MY419X', 'MY419X', 'MY419X'),
(6550, 'MY 421Z', 'MY 421Z', 'MY 421Z'),
(6551, 'my500X', 'my500X', 'my500X'),
(6552, 'my501C', 'my501C', 'my501C'),
(6553, 'MY501X', 'MY501X', 'MY501X'),
(6554, 'my511X', 'my511X', 'my511X'),
(6555, 'my519x', 'my519x', 'my519x'),
(6556, 'MY600V', 'MY600V', 'MY600V'),
(6557, 'My600x', 'My600x', 'My600x'),
(6558, 'my700X', 'my700X', 'my700X'),
(6559, 'my721X', 'my721X', 'my721X'),
(6560, 'my730C', 'my730C', 'my730C'),
(6561, 'my750C', 'my750C', 'my750C'),
(6562, 'my750X', 'my750X', 'my750X'),
(6563, 'MY800V', 'MY800V', 'MY800V'),
(6564, 'MY800X', 'MY800X', 'MY800X'),
(6565, 'my810X', 'my810X', 'my810X'),
(6566, 'my850C', 'my850C', 'my850C'),
(6567, 'MY850V', 'MY850V', 'MY850V'),
(6568, 'MY901C', 'MY901C', 'MY901C'),
(6569, 'myC-2', 'myC-2', 'myC-2'),
(6570, 'myC-3', 'myC-3', 'myC-3'),
(6571, 'myC-3b', 'myC-3b', 'myC-3b'),
(6572, 'myC-4', 'myC-4', 'myC-4'),
(6573, 'myC2-2', 'myC2-2', 'myC2-2'),
(6574, 'myC2-3', 'myC2-3', 'myC2-3'),
(6575, 'myC-3m', 'myC-3m', 'myC-3m'),
(6576, 'myC3-2', 'myC3-2', 'myC3-2'),
(6577, 'myC4-2', 'myC4-2', 'myC4-2'),
(6578, 'myC5-2', 'myC5-2', 'myC5-2'),
(6579, 'myC5-2T', 'myC5-2T', 'myC5-2T'),
(6580, 'myC5-3', 'myC5-3', 'myC5-3'),
(6581, 'myG-5', 'myG-5', 'myG-5'),
(6582, 'myS-7', 'myS-7', 'myS-7'),
(6583, 'myT-22', 'myT-22', 'myT-22'),
(6584, 'myV-55', 'myV-55', 'myV-55'),
(6585, 'myV-56', 'myV-56', 'myV-56'),
(6586, 'MyV-65', 'MyV-65', 'MyV-65'),
(6587, 'MYV-66', 'MYV-66', 'MYV-66'),
(6588, 'MyV-75', 'MyV-75', 'MyV-75'),
(6589, 'DoCoMo myV-75', 'DoCoMo myV-75', 'DoCoMo myV-75'),
(6590, 'myV-76', 'myV-76', 'myV-76'),
(6591, 'MYV-85', 'MYV-85', 'MYV-85'),
(6592, 'myW-7', 'myW-7', 'myW-7'),
(6593, 'myX-1', 'myX-1', 'myX-1'),
(6594, 'myX-2', 'myX-2', 'myX-2'),
(6595, 'myX-2G', 'myX-2G', 'myX-2G'),
(6596, 'myX-3', 'myX-3', 'myX-3'),
(6597, 'myX-4', 'myX-4', 'myX-4'),
(6598, 'myX-4T', 'myX-4T', 'myX-4T'),
(6599, 'myX-5', 'myX-5', 'myX-5'),
(6600, 'myX-5-2T', 'myX-5-2T', 'myX-5-2T'),
(6601, 'myX-5d', 'myX-5d', 'myX-5d'),
(6602, 'myX-5e', 'myX-5e', 'myX-5e'),
(6603, 'myX-5m', 'myX-5m', 'myX-5m'),
(6604, 'MyX-6', 'MyX-6', 'MyX-6'),
(6605, 'myX-7', 'myX-7', 'myX-7'),
(6606, 'MyX8', 'MyX8', 'MyX8'),
(6607, 'myX2-2', 'myX2-2', 'myX2-2'),
(6608, 'myX3-2', 'myX3-2', 'myX3-2'),
(6609, 'MyX5-2', 'MyX5-2', 'MyX5-2'),
(6610, 'myX5-2m', 'myX5-2m', 'myX5-2m'),
(6611, 'myX5-2v', 'myX5-2v', 'myX5-2v'),
(6612, 'MY X55', 'MY X55', 'MY X55'),
(6613, 'myX6-2', 'myX6-2', 'myX6-2'),
(6614, 'MYZ-5', 'MYZ-5', 'MYZ-5'),
(6615, 'myZ-55', 'myZ-55', 'myZ-55'),
(6616, 'MY212X', 'MY212X', 'MY212X'),
(6617, 'MY300C', 'MY300C', 'MY300C'),
(6618, 'MY 521X', 'MY 521X', 'MY 521X'),
(6619, 'SCP-3200', 'SCP-3200', 'SCP-3200'),
(6620, 'MM5600', 'MM5600', 'MM5600'),
(6621, 'MM7400', 'MM7400', 'MM7400'),
(6622, 'MM7500', 'MM7500', 'MM7500'),
(6623, 'MM-8300', 'MM-8300', 'MM-8300'),
(6624, 'SCP-9000', 'SCP-9000', 'SCP-9000'),
(6625, 'MM-9000', 'MM-9000', 'MM-9000'),
(6626, 'PL6650', 'PL6650', 'PL6650'),
(6627, 'PLS3200', 'PLS3200', 'PLS3200'),
(6628, 'PLS4920', 'PLS4920', 'PLS4920'),
(6629, 'PLS6600', 'PLS6600', 'PLS6600'),
(6630, 'SCP6650', 'SCP6650', 'SCP6650'),
(6631, 'PLS7400', 'PLS7400', 'PLS7400'),
(6632, 'PLS8200', 'PLS8200', 'PLS8200'),
(6633, 'PM-8200', 'PM-8200', 'PM-8200'),
(6634, 'RL-4920', 'RL-4920', 'RL-4920'),
(6635, 'RL-4930', 'RL-4930', 'RL-4930'),
(6636, 'SCP-200', 'SCP-200', 'SCP-200'),
(6637, 'VI-2300 (SCP-2300)', 'VI-2300 (SCP-2300)', 'VI-2300 (SCP-2300)'),
(6638, 'SCP-2400', 'SCP-2400', 'SCP-2400'),
(6639, 'SCP2500', 'SCP2500', 'SCP2500'),
(6640, 'SCP-3100', 'SCP-3100', 'SCP-3100'),
(6641, 'Katana LX', 'SCP3800', 'Katana LX SCP3800'),
(6642, 'SCP-4900', 'SCP-4900', 'SCP-4900'),
(6643, 'SCP-5300', 'SCP-5300', 'SCP-5300'),
(6644, 'SCP-5400', 'SCP-5400', 'SCP-5400'),
(6645, 'SCP-5500', 'SCP-5500', 'SCP-5500'),
(6646, 'SCP-6400', 'SCP-6400', 'SCP-6400'),
(6647, 'Katana', 'SCP-6600', 'Katana SCP-6600'),
(6648, 'Katana II', 'SCP-6650', 'Katana II SCP-6650'),
(6649, 'SCP-6750', 'SCP-6750', 'SCP-6750'),
(6650, 'SCP-7000', 'SCP-7000', 'SCP-7000'),
(6651, 'SCP7050', 'SCP7050', 'SCP7050'),
(6652, 'SCP-7200', 'SCP-7200', 'SCP-7200'),
(6653, 'SCP-7300', 'SCP-7300', 'SCP-7300'),
(6654, 'SCP-8100', 'SCP-8100', 'SCP-8100'),
(6655, 'SCP-8200', 'SCP-8200', 'SCP-8200'),
(6656, '8400', '8400', '8400'),
(6657, 'SCP-8500', 'SCP-8500', 'SCP-8500'),
(6658, 'SCP PRO200', 'SCP PRO200', 'SCP PRO200'),
(6659, 'SCP-PRO700', 'SCP-PRO700', 'SCP-PRO700'),
(6660, 'NetFront Ver. 3.0', 'NetFront Ver. 3.0', 'NetFront Ver. 3.0'),
(6661, 'S103', 'S103', 'S103'),
(6662, 'S750', 'S750', 'S750'),
(6663, 'C304 SA', 'C304 SA', 'C304 SA'),
(6664, 'C401 HK', 'C401 HK', 'C401 HK'),
(6665, 'SCP4700', 'SCP4700', 'SCP4700'),
(6666, 'SCP 5000', 'SCP 5000', 'SCP 5000'),
(6667, 'SCP 510CN', 'SCP 510CN', 'SCP 510CN'),
(6668, 'SCP5150', 'SCP5150', 'SCP5150'),
(6669, 'SCP 550 CN', 'SCP 550 CN', 'SCP 550 CN'),
(6670, 'SCP580 CN', 'SCP580 CN', 'SCP580 CN'),
(6671, 'SCP580', 'SCP580', 'SCP580'),
(6672, 'SCP6000', 'SCP6000', 'SCP6000'),
(6673, 'SCP 6200', 'SCP 6200', 'SCP 6200'),
(6674, 'Katana', 'SCP6600CA', 'Katana SCP6600CA'),
(6675, 'SCP7000CA', 'SCP7000CA', 'SCP7000CA'),
(6676, 'SCP-2500CA', 'SCP-2500CA', 'SCP-2500CA'),
(6677, 'SCP3800CA', 'SCP3800CA', 'SCP3800CA'),
(6678, 'SCP-7050', 'SCP-7050', 'SCP-7050 SCP-7050'),
(6679, 'SCP-PRO700CA', 'SCP-PRO700CA', 'SCP-PRO700CA'),
(6680, 'Blink/Tango', 'SH6017D', 'Blink/Tango SH6017D'),
(6681, 'WX-T71', 'WX-T71', 'WX-T71'),
(6682, 'FX', 'STX2', 'FX STX2'),
(6683, 'TM100', 'TM100', 'TM100'),
(6684, 'TM-150', 'TM-150', 'TM-150'),
(6685, 'TM200', 'TM200', 'TM200'),
(6686, 'TQ-GX21', 'TQ-GX21', 'TQ-GX21'),
(6687, 'TQ-GX31', 'TQ-GX31', 'TQ-GX31'),
(6688, 'TQ-GX31i', 'TQ-GX31i', 'TQ-GX31i'),
(6689, 'GX-A15', 'GX-A15', 'GX-A15'),
(6690, 'TQ-GX-E30', 'TQ-GX-E30', 'TQ-GX-E30'),
(6691, 'TQ GX F200', 'TQ GX F200', 'TQ GX F200'),
(6692, 'TQ GX15', 'TQ GX15', 'TQ GX15'),
(6693, 'TQ-GX-i98', 'TQ-GX-i98', 'TQ-GX-i98'),
(6694, 'TQ-GX1', 'TQ-GX1', 'TQ-GX1'),
(6695, 'GX10', 'GX10', 'GX10'),
(6696, 'TQ-GX10N', 'TQ-GX10N', 'TQ-GX10N'),
(6697, 'GX10i', 'GX10i', 'GX10i'),
(6698, 'TQ-GX10m', 'TQ-GX10m', 'TQ-GX10m'),
(6699, 'TQ-GX12', 'TQ-GX12', 'TQ-GX12'),
(6700, 'TQ-GX13', 'TQ-GX13', 'TQ-GX13'),
(6701, 'TQ-GX17', 'TQ-GX17', 'TQ-GX17'),
(6702, 'TQ GX20', 'TQ GX20', 'TQ GX20'),
(6703, 'TQ-GX20N', 'TQ-GX20N', 'TQ-GX20N'),
(6704, 'TQ-GX20i', 'TQ-GX20i', 'TQ-GX20i'),
(6705, 'TQ-GX22', 'TQ-GX22', 'TQ-GX22'),
(6706, 'TQ-GX22S', 'TQ-GX22S', 'TQ-GX22S'),
(6707, 'TQ-GX23', 'TQ-GX23', 'TQ-GX23'),
(6708, 'TQ GX25', 'TQ GX25', 'TQ GX25'),
(6709, 'TQ-GX27', 'TQ-GX27', 'TQ-GX27'),
(6710, 'GX29', 'GX29', 'GX29'),
(6711, 'GX30', 'GX30', 'GX30'),
(6712, 'GX30i', 'GX30i', 'GX30i'),
(6713, 'TQ GX32', 'TQ GX32', 'TQ GX32'),
(6714, 'TQ-GX32i', 'TQ-GX32i', 'TQ-GX32i'),
(6715, 'TQ-GX33', 'TQ-GX33', 'TQ-GX33'),
(6716, 'TQ GZ1', 'TQ GZ1', 'TQ GZ1'),
(6717, 'TQ-GZ100', 'TQ-GZ100', 'TQ-GZ100'),
(6718, 'TQ-GZ100S', 'TQ-GZ100S', 'TQ-GZ100S'),
(6719, 'TQ-GZ100T', 'TQ-GZ100T', 'TQ-GZ100T'),
(6720, 'TQ-GZ200', 'TQ-GZ200', 'TQ-GZ200'),
(6721, 'TQ-GZ200S', 'TQ-GZ200S', 'TQ-GZ200S'),
(6722, 'TQ-V750', 'TQ-V750', 'TQ-V750'),
(6723, 'V802SH', 'V802SH', 'V802SH'),
(6724, '902SH', '902SH', '902SH'),
(6725, 'SX833', 'SX833', 'SX833'),
(6726, 'WX-T91', 'WX-T91', 'WX-T91'),
(6727, '2128', '2128', '2128'),
(6728, '3118', '3118', '3118'),
(6729, '3618', '3618', '3618'),
(6730, '6618', '6618', '6618'),
(6731, '6688', '6688', '6688'),
(6732, 'AL21a', 'AL21a', 'AL21a'),
(6733, 'A31', 'A31', 'A31'),
(6734, 'A31C', 'A31C', 'A31C'),
(6735, 'A31a', 'A31a', 'A31a'),
(6736, 'A40', 'A40', 'A40'),
(6737, 'A52', 'A52', 'A52'),
(6738, 'A55', 'A55', 'A55'),
(6739, 'A55A', 'A55A', 'A55A'),
(6740, 'A56', 'A56', 'A56'),
(6741, 'A56i', 'A56i', 'A56i'),
(6742, 'A57', 'A57', 'A57'),
(6743, 'A62', 'A62', 'A62'),
(6744, 'A70', 'A70', 'A70'),
(6745, 'A71', 'A71', 'A71'),
(6746, 'A75', 'A75', 'A75'),
(6747, 'A76', 'A76', 'A76'),
(6748, 'AF51', 'AF51', 'AF51'),
(6749, 'AL21', 'AL21', 'AL21'),
(6750, 'Butterfly / Hello Kitty', 'AL26', 'Butterfly / Hello Kitty AL26'),
(6751, 'AP75', 'AP75', 'AP75'),
(6752, 'AX72', 'AX72', 'AX72'),
(6753, 'AX75', 'AX75', 'AX75'),
(6754, 'CF110', 'CF110', 'CF110'),
(6755, 'C35', 'C35', 'C35'),
(6756, 'C45', 'C45', 'C45'),
(6757, 'C55', 'C55', 'C55'),
(6758, 'C56', 'C56', 'C56'),
(6759, 'C61', 'C61', 'C61'),
(6760, 'C62', 'C62', 'C62'),
(6761, 'C66', 'C66', 'C66'),
(6762, 'C65-China', 'C65-China', 'C65-China'),
(6763, 'C70', 'C70', 'C70'),
(6764, 'C72', 'C72', 'C72'),
(6765, 'C75', 'C75', 'C75'),
(6766, 'C81', 'C81', 'C81'),
(6767, 'CF62', 'CF62', 'CF62'),
(6768, 'CF62T', 'CF62T', 'CF62T'),
(6769, 'CF6C', 'CF6C', 'CF6C'),
(6770, 'CF75', 'CF75', 'CF75'),
(6771, 'CF76', 'CF76', 'CF76'),
(6772, 'CFX65', 'CFX65', 'CFX65'),
(6773, 'CL50', 'CL50', 'CL50'),
(6774, 'CL75', 'CL75', 'CL75'),
(6775, 'CL91', 'CL91', 'CL91'),
(6776, 'CT65', 'CT65', 'CT65'),
(6777, 'CT66', 'CT66', 'CT66'),
(6778, 'CV65', 'CV65', 'CV65'),
(6779, 'CV66', 'CV66', 'CV66'),
(6780, 'CX65', 'CX65', 'CX65'),
(6781, 'CX65 China', 'CX65 China', 'CX65 China'),
(6782, 'CX70', 'CX70', 'CX70'),
(6783, 'CX75', 'CX75', 'CX75'),
(6784, 'CXT65', 'CXT65', 'CXT65'),
(6785, 'CXT70', 'CXT70', 'CXT70'),
(6786, 'EF81', 'EF81', 'EF81'),
(6787, 'EL71', 'EL71', 'EL71'),
(6788, 'ELC1', 'ELC1', 'ELC1'),
(6789, 'IC35', 'IC35', 'IC35'),
(6790, 'M46', 'M46', 'M46'),
(6791, 'M50', 'M50', 'M50'),
(6792, 'M50I', 'M50I', 'M50I'),
(6793, 'M55', 'M55', 'M55'),
(6794, 'M55C', 'M55C', 'M55C'),
(6795, 'M56', 'M56', 'M56'),
(6796, 'M65', 'M65', 'M65'),
(6797, 'M65i', 'M65i', 'M65i'),
(6798, 'M65C', 'M65C', 'M65C'),
(6799, 'M75', 'M75', 'M75'),
(6800, 'M81', 'M81', 'M81'),
(6801, 'MC35', 'MC35', 'MC35'),
(6802, 'MC60', 'MC60', 'MC60'),
(6803, 'MC6C', 'MC6C', 'MC6C'),
(6804, 'ME45', 'ME45', 'ME45'),
(6805, 'ME45i', 'ME45i', 'ME45i'),
(6806, 'ME75', 'ME75', 'ME75'),
(6807, 'MT50', 'MT50', 'MT50'),
(6808, 'MT65', 'MT65', 'MT65'),
(6809, 'OP600', 'OP600', 'OP600'),
(6810, 'P35', 'P35', 'P35'),
(6811, 'S35', 'S35', 'S35'),
(6812, 'S40', 'S40', 'S40'),
(6813, 'S45', 'S45', 'S45'),
(6814, 'S45i', 'S45i', 'S45i'),
(6815, 'S46', 'S46', 'S46'),
(6816, 'S55', 'S55', 'S55'),
(6817, 'S55i', 'S55i', 'S55i'),
(6818, 'S56', 'S56', 'S56'),
(6819, 'S57', 'S57', 'S57'),
(6820, 'S65', 'S65', 'S65'),
(6821, 'S66', 'S66', 'S66'),
(6822, 'S68', 'S68', 'S68'),
(6823, 'S6C', 'S6C', 'S6C'),
(6824, 'S75', 'S75', 'S75'),
(6825, 'SF65', 'SF65', 'SF65'),
(6826, 'SF65v2', 'SF65v2', 'SF65v2'),
(6827, 'SG75', 'SG75', 'SG75'),
(6828, 'SK6R', 'SK6R', 'SK6R'),
(6829, 'SL42i', 'SL42i', 'SL42i'),
(6830, 'SL45', 'SL45', 'SL45'),
(6831, 'SL50', 'SL50', 'SL50'),
(6832, 'SL55', 'SL55', 'SL55'),
(6833, 'SL56', 'SL56', 'SL56'),
(6834, 'SL5C', 'SL5C', 'SL5C'),
(6835, 'SL5E', 'SL5E', 'SL5E'),
(6836, 'SL65', 'SL65', 'SL65'),
(6837, 'SL65-China', 'SL65-China', 'SL65-China'),
(6838, 'SL75', 'SL75', 'SL75'),
(6839, 'SL7F', 'SL7F', 'SL7F'),
(6840, 'SL45i', 'SL45i', 'SL45i'),
(6841, 'SLIN', 'SLIN', 'SLIN'),
(6842, 'SP65', 'SP65', 'SP65'),
(6843, 'ST55', 'ST55', 'ST55'),
(6844, 'ST60', 'ST60', 'ST60'),
(6845, 'SX1', 'SX1', 'SX1'),
(6846, 'SX56', 'SX56', 'SX56'),
(6847, 'SX65', 'SX65', 'SX65'),
(6848, 'SX66', 'SX66', 'SX66'),
(6849, 'SXG75', 'SXG75', 'SXG75'),
(6850, 'U35', 'U35', 'U35'),
(6851, 'X55i', 'X55i', 'X55i'),
(6852, 'Xelibri 1', 'Xelibri 1', 'Xelibri 1'),
(6853, 'Xelibri 2', 'Xelibri 2', 'Xelibri 2'),
(6854, 'Xelibri 3', 'Xelibri 3', 'Xelibri 3'),
(6855, 'Xelibri 4', 'Xelibri 4', 'Xelibri 4'),
(6856, 'Z60', 'Z60', 'Z60'),
(6857, 'SPV M650', 'SPV M650', 'SPV M650'),
(6858, 'Typhoon', 'SPV C500', 'Typhoon SPV C500'),
(6859, 'SPV C600', 'SPV C600', 'SPV C600'),
(6860, 'SPV M1000', 'SPV M1000', 'SPV M1000'),
(6861, 'SPV M1500', 'SPV M1500', 'SPV M1500'),
(6862, 'SPV M2000', 'SPV M2000', 'SPV M2000'),
(6863, 'SPV M3000', 'SPV M3000', 'SPV M3000'),
(6864, 'SPV M5000', 'SPV M5000', 'SPV M5000'),
(6865, 'HTC Charmer', 'SPV M500', 'HTC Charmer SPV M500'),
(6866, 'SPV M600', 'SPV M600', 'SPV M600'),
(6867, 'SPV M700', 'SPV M700', 'SPV M700'),
(6868, 'SPV C100', 'SPV C100', 'SPV C100'),
(6869, 'SPV C550', 'SPV C550', 'SPV C550'),
(6870, 'SPV C700', 'SPV C700', 'SPV C700'),
(6871, 'SPV E600', 'SPV E600', 'SPV E600'),
(6872, 'SPV E650', 'SPV E650', 'SPV E650'),
(6873, 'SPV C200', 'SPV C200', 'SPV C200'),
(6874, 'SPV E610', 'SPV E610', 'SPV E610'),
(6875, '750', '750', '750'),
(6876, 'SPV E100', 'SPV E100', 'SPV E100'),
(6877, 'SPV E200', 'SPV E200', 'SPV E200'),
(6878, 'Xda Orbit', 'Xda Orbit', 'Xda Orbit'),
(6879, 'Xda Orbit II', 'Xda Orbit II', 'Xda Orbit II'),
(6880, 'TS608_TS30', 'TS608_TS30', 'TS608_TS30'),
(6881, 'TS 608', 'TS 608', 'TS 608'),
(6882, 'TS10', 'TS10', 'TS10'),
(6883, 'TS 605', 'TS 605', 'TS 605'),
(6884, '553', '553', '553'),
(6885, 'V720', 'V720', 'V720'),
(6886, 'MTC540', 'MTC540', 'MTC540'),
(6887, '332', '332', '332'),
(6888, 'Vodafone351', 'Vodafone351', 'Vodafone351'),
(6889, '353', '353', '353'),
(6890, 'Miss Sixty', 'Vodafone-543', 'Miss Sixty Vodafone-543'),
(6891, '555 Blue', '555 Blue', '555 Blue'),
(6892, 'Chat 655', '655', 'Chat 655 655'),
(6893, 'Vodafone 710', 'Vodafone 710', 'Vodafone 710'),
(6894, 'Vodafone 715', 'Vodafone 715', 'Vodafone 715'),
(6895, 'Vodafone 716', 'Vodafone 716', 'Vodafone 716'),
(6896, 'Vodafone 720', 'Vodafone 720', 'Vodafone 720'),
(6897, 'Vodafone 725', 'Vodafone 725', 'Vodafone 725'),
(6898, '735', '735', '735'),
(6899, 'Vodafone 736', 'Vodafone 736', 'Vodafone 736'),
(6900, 'Vodafone 810', 'Vodafone 810', 'Vodafone 810'),
(6901, 'Vodafone 830', 'Vodafone 830', 'Vodafone 830'),
(6902, 'VODAFONE 830i', 'VODAFONE 830i', 'VODAFONE 830i'),
(6903, 'VODAFONE 840', 'VODAFONE 840', 'VODAFONE 840'),
(6904, 'V715', 'V715', 'V715'),
(6905, 'v716', 'v716', 'v716'),
(6906, '550SH', '550SH', '550SH'),
(6907, '703SH', '703SH', '703SH'),
(6908, '770SH', '770SH', '770SH'),
(6909, '802SH', '802SH', '802SH'),
(6910, '880SH', '880SH', '880SH'),
(6911, '903SH', '903SH', '903SH'),
(6912, 'iPAQ Voice Messenger', 'iPAQ Voice Messenger', 'iPAQ Voice Messenger'),
(6913, 'Viewty', 'LG/KU990/v1.0', 'Viewty LG/KU990/v1.0'),
(6914, '703N', '703N', '703N'),
(6915, '703SHf', '703SHf', '703SHf'),
(6916, 'V703SHf', 'V703SHf', 'V703SHf'),
(6917, '705SH', '705SH', '705SH'),
(6918, '705T', '705T', '705T'),
(6919, '802N', '802N', '802N'),
(6920, '802SE', '802SE', '802SE'),
(6921, '803T', '803T', '803T'),
(6922, '804N', '804N', '804N'),
(6923, '804NK', '804NK', '804NK'),
(6924, '804SH', '804SH', '804SH'),
(6925, '804SS', '804SS', '804SS'),
(6926, '902T', '902T', '902T'),
(6927, 'vodafone 902T', 'vodafone 902T', 'vodafone 902T'),
(6928, '903T', '903T', '903T'),
(6929, '904SH', '904SH', '904SH'),
(6930, '904T', '904T', '904T'),
(6931, '905SH', '905SH', '905SH'),
(6932, 'Vodafone-330-FM', 'Vodafone-330-FM', 'Vodafone-330-FM'),
(6933, 'Vodafone331', 'Vodafone331', 'Vodafone331'),
(6934, 'v1240', 'v1240', 'v1240'),
(6935, 'v1640', 'v1640', 'v1640'),
(6936, 'TQ GX18', 'TQ GX18', 'TQ GX18'),
(6937, '803', '803', '803'),
(6938, '808', '808', '808'),
(6939, 'TS 921', 'TS 921', 'TS 921'),
(6940, 'V902T', 'V902T', 'V902T'),
(6941, 'Pre', 'Pre', 'Pre'),
(6942, 'TouchPad', 'TouchPad', 'TouchPad TouchPad'),
(6943, 'Pre Plus', 'Pre Plus', 'Pre Plus'),
(6944, 'Veer', 'P160U', 'Veer P160U'),
(6945, 'Pixi', 'Pixi', 'Pixi'),
(6946, 'Pixi Plus', 'Pixi Plus', 'Pixi Plus'),
(6947, 'Pre2', 'Pre2', 'Pre2'),
(6948, 'Pre3', 'Pre3', 'Pre3'),
(6949, 'VF455', 'VF455', 'VF455'),
(6950, 'Chat 655W', '655W', 'Chat 655W 655W'),
(6951, 'Mini 1', 'Mini 1', 'Mini 1'),
(6952, 'Mini 2', 'Mini 2', 'Mini 2'),
(6953, 'Mini 3', 'Mini 3', 'Mini 3'),
(6954, 'Mini 4', 'Mini 4', 'Mini 4'),
(6955, 'Cosmos Touch', 'VN270', 'Cosmos Touch VN270'),
(6956, 'Extravert', 'VN271', 'Extravert VN271'),
(6957, 'Opera Mini for S60', 'Opera Mini for S60', 'Opera Mini for S60'),
(6958, 'Z331', 'Z331', 'Z331'),
(6959, 'Windows RT Tablet', 'Windows RT Tablet', 'Windows RT Tablet'),
(6960, 'Windows Phone 8', 'Windows Phone 8', 'Windows Phone 8'),
(6961, 'Bot or Crawler', 'Bot or Crawler', 'Bot or Crawler'),
(6962, 'Transcoder', 'Transcoder', 'Transcoder'),
(6963, 'Feed Fetcher', 'Feed Fetcher', 'Feed Fetcher'),
(6964, 'AdSense Bot', 'AdSense Bot', 'AdSense Bot'),
(6965, 'Wireless Transcoder', 'Wireless Transcoder', 'Wireless Transcoder'),
(6966, 'CTS reformatting proxy', 'CTS reformatting proxy', 'CTS reformatting proxy'),
(6967, 'nWeb Browser', 'nWeb Browser', 'nWeb Browser'),
(6968, 'Rogerbot', 'Rogerbot', 'Rogerbot'),
(6969, 'Chrome', 'Chrome', 'Chrome'),
(6970, 'Firefox', 'Firefox', 'Firefox'),
(6971, 'Internet Explorer', 'Internet Explorer', 'Internet Explorer'),
(6972, 'M735', 'M735', 'M735'),
(6973, 'WX330K', 'WX330K', 'WX330K'),
(6974, 'Honey Bee Box', 'WX334K', 'Honey Bee Box WX334K'),
(6975, 'reformatting proxy', 'reformatting proxy', 'reformatting proxy'),
(6976, 'Opera', 'Opera', 'Opera'),
(6977, 'Flo', 'M6800', 'Flo M6800'),
(6978, 'Spice', 'M6900', 'Spice M6900'),
(6979, 'Imagio', 'XV6975', 'Imagio XV6975'),
(6980, 'Xda_Diamond_2', 'Xda_Diamond_2', 'Xda_Diamond_2'),
(6981, 'XDA Ignito', 'XDA Ignito', 'XDA Ignito'),
(6982, 'XDA Serra', 'XDA Serra', 'XDA Serra'),
(6983, 'O2 Xda Zest', 'O2 Xda Zest', 'O2 Xda Zest'),
(6984, 'XDA Diamond', 'XDA Diamond', 'XDA Diamond'),
(6985, 'XDA Diamond Pro', 'XDA Diamond Pro', 'XDA Diamond Pro'),
(6986, 'Safari', 'Safari', 'Safari'),
(6987, '4', '4', '4'),
(6988, 'W622', 'W622', 'W622'),
(6989, '828B', '828B', '828B'),
(6990, '8352RC', '8352RC', '8352RC'),
(6991, 'Pilgrim/Tilt', '8900A', 'Pilgrim/Tilt 8900A'),
(6992, 'Pilgrim/Tilt', '8900B', 'Pilgrim/Tilt 8900B'),
(6993, 'A7722', 'A7722', 'A7722'),
(6994, 'AC831', 'AC831', 'AC831'),
(6995, 'Pro80', 'Pro80', 'Pro80'),
(6996, 'c313', 'c313', 'c313'),
(6997, 'c338', 'c338', 'c338'),
(6998, 'c616', 'c616', 'c616'),
(6999, 'e228', 'e228', 'e228'),
(7000, 'e313', 'e313', 'e313'),
(7001, 'e338', 'e338', 'e338'),
(7002, 'D08', 'D08', 'D08'),
(7003, 'D09', 'D09', 'D09'),
(7004, 'D13', 'D13', 'D13'),
(7005, 'D15', 'D15', 'D15'),
(7006, 'D17', 'D17', 'D17'),
(7007, 'D23', 'D23', 'D23'),
(7008, '70W', '70W', '70W'),
(7009, 'Air99', 'Air99', 'Air99'),
(7010, 'AMC F188', 'AMC F188', 'AMC F188'),
(7011, 'M30', 'M30', 'M30'),
(7012, 'GT-S3370B', 'GT-S3370B', 'GT-S3370B'),
(7013, 'Pav', 'Pav', 'Pav'),
(7014, 'G7210', 'G7210', 'G7210'),
(7015, 'GalaxyII', 'GalaxyII', 'GalaxyII'),
(7016, 'J101', 'J101', 'J101'),
(7017, 'J102', 'J102', 'J102'),
(7018, 'J206', 'J206', 'J206'),
(7019, 'J501', 'J501', 'J501'),
(7020, 'M303', 'M303', 'M303'),
(7021, 'P320', 'P320', 'P320'),
(7022, 'P505', 'P505', 'P505'),
(7023, 'V75', 'V75', 'V75'),
(7024, 'WP70', 'WP70', 'WP70'),
(7025, 'Z801', 'Z801', 'Z801'),
(7026, 'N525i', 'N525i', 'N525i'),
(7027, 'SPH-N400', 'SPH-N400', 'SPH-N400'),
(7028, 'A500/A620', 'A500/A620', 'A500/A620'),
(7029, 'CDM-9155-GPX', 'CDM-9155-GPX', 'CDM-9155-GPX'),
(7030, 'CDM-8910', 'CDM-8910', 'CDM-8910'),
(7031, 'Snapper', 'CDM-8915', 'Snapper CDM-8915'),
(7032, 'CDM-8930', 'CDM-8930', 'CDM-8930'),
(7033, 'CDM-120', 'CDM-120', 'CDM-120'),
(7034, 'CDM-180', 'CDM-180', 'CDM-180'),
(7035, 'CDM-8450', 'CDM-8450', 'CDM-8450'),
(7036, 'CDM-8450SP', 'CDM-8450SP', 'CDM-8450SP'),
(7037, 'CDM8615', 'CDM8615', 'CDM8615'),
(7038, 'CDM-8912', 'CDM-8912', 'CDM-8912'),
(7039, 'CDM-8940', 'CDM-8940', 'CDM-8940'),
(7040, 'CDM-8945', 'CDM-8945', 'CDM-8945'),
(7041, 'CDM-9100', 'CDM-9100', 'CDM-9100'),
(7042, 'CDM 9155SP', 'CDM 9155SP', 'CDM 9155SP'),
(7043, 'CDM-9200', 'CDM-9200', 'CDM-9200'),
(7044, 'CDM-9500', 'CDM-9500', 'CDM-9500'),
(7045, 'PM-8912', 'PM-8912', 'PM-8912'),
(7046, 'PM-8920', 'PM-8920', 'PM-8920'),
(7047, 'SMT 5600', 'SMT 5600', 'SMT 5600'),
(7048, 'Anti Virus Updater', 'Anti Virus Updater', 'Anti Virus Updater'),
(7049, 'S1160', 'S1160', 'S1160'),
(7050, 'T480', 'T480', 'T480 T480'),
(7051, 'Aladino MMS', 'Aladino MMS', 'Aladino MMS'),
(7052, 'One Touch 500', 'One Touch 500', 'One Touch 500'),
(7053, 'Alex-uo', 'Alex-uo', 'Alex-uo'),
(7054, '3 Skypephone', '8505', '3 Skypephone 8505'),
(7055, '3 Skypephone', '8512', '3 Skypephone 8512'),
(7056, '8709', '8709', '8709'),
(7057, '8710', '8710', '8710'),
(7058, '9109', '9109', '9109'),
(7059, 'A310', 'A310', 'A310'),
(7060, 'A9B', 'A9B', 'A9B'),
(7061, 'CA6', 'CA6', 'CA6'),
(7062, 'CS6', 'CS6', 'CS6'),
(7063, 'D85', 'D85', 'D85'),
(7064, 'D89', 'D89', 'D89'),
(7065, 'DA8', 'DA8', 'DA8'),
(7066, 'DF9', 'DF9', 'DF9'),
(7067, 'F90', 'F90', 'F90'),
(7068, 'M515', 'M515', 'M515'),
(7069, 'M630', 'M630', 'M630'),
(7070, 'M636', 'M636', 'M636'),
(7071, 'F8', 'F8', 'F8'),
(7072, '9201', '9201', '9201'),
(7073, 'F9', 'F9', 'F9'),
(7074, 'F99', 'F99', 'F99'),
(7075, 'SP230', 'SP230', 'SP230'),
(7076, 'QuickTime Agent', 'QuickTime Agent', 'QuickTime Agent'),
(7077, 'Tzuki', 'Tzuki', 'Tzuki'),
(7078, 'Avvio 1550', 'Avvio 1550', 'Avvio 1550'),
(7079, 'T519', 'T519', 'T519'),
(7080, 'B600', 'B600', 'B600'),
(7081, 'BC831', 'BC831', 'BC831'),
(7082, 'BD60', 'BD60', 'BD60'),
(7083, 'Op', 'Op', 'Op'),
(7084, 'GD410', 'GD410', 'GD410'),
(7085, 'Neo200', 'Neo200', 'Neo200'),
(7086, 'Bird D600', 'myX6-2', 'Bird D600 myX6-2'),
(7087, 'D718', 'D718', 'D718'),
(7088, 'E818', 'E818', 'E818'),
(7089, 'F518', 'F518', 'F518'),
(7090, 'K298', 'K298', 'K298'),
(7091, 'S230', 'S230', 'S230'),
(7092, 'S305', 'S305', 'S305'),
(7093, 'S701', 'S701', 'S701'),
(7094, 'S918', 'S918', 'S918'),
(7095, 'V780', 'V780', 'V780'),
(7096, 'V788', 'V788', 'V788'),
(7097, 'V007', 'V007', 'V007'),
(7098, 'A120', 'A120', 'A120'),
(7099, 'A150', 'A150', 'A150'),
(7100, 'D700', 'D700', 'D700'),
(7101, 'F501', 'F501', 'F501'),
(7102, 'G118', 'G118', 'G118'),
(7103, 'S580', 'S580', 'S580'),
(7104, 'SC14', 'SC14', 'SC14'),
(7105, 'SC24', 'SC24', 'SC24'),
(7106, 'V59', 'V59', 'V59'),
(7107, 'D611', 'D611', 'D611'),
(7108, 'D615', 'D615', 'D615'),
(7109, 'D660', 'D660', 'D660'),
(7110, 'D720', 'D720', 'D720'),
(7111, 'D730', 'D730', 'D730'),
(7112, 'D736', 'D736', 'D736'),
(7113, '651Z', '651Z', '651Z'),
(7114, '209', '209', '209'),
(7115, 'Anasta', 'Anasta', 'Anasta'),
(7116, 'Fino30', 'Fino30', 'Fino30'),
(7117, '485', '485', '485'),
(7118, 'UP200', 'UP200', 'UP200'),
(7119, 'GPRS778', 'GPRS778', 'GPRS778'),
(7120, 'UP560', 'UP560', 'UP560'),
(7121, 'DCW2111H', 'DCW2111H', 'DCW2111H'),
(7122, 'Dcw2112h', 'Dcw2112h', 'Dcw2112h'),
(7123, 'Dcw2113h', 'Dcw2113h', 'Dcw2113h'),
(7124, 'Dcw2402h', 'Dcw2402h', 'Dcw2402h'),
(7125, 'GD412', 'GD412', 'GD412'),
(7126, 'GD555', 'GD555', 'GD555'),
(7127, 'TD590', 'TD590', 'TD590'),
(7128, 'Berlin', 'Berlin', 'Berlin'),
(7129, 'S570', 'S570', 'S570'),
(7130, 'D610', 'D610', 'D610'),
(7131, 'Bird M19', 'M19', 'Bird M19 M19'),
(7132, 'S689', 'S689', 'S689'),
(7133, 'S789', 'S789', 'S789'),
(7134, 'Bird S889', 'S889', 'Bird S889 S889'),
(7135, 'SC17c', 'SC17c', 'SC17c'),
(7136, 'SM10', 'SM10', 'SM10'),
(7137, 'V89', 'V89', 'V89'),
(7138, '355X', '355X', '355X'),
(7139, 'Bleu 453x', 'Bleu 453x', 'Bleu 453x'),
(7140, '458x', '458x', '458x'),
(7141, '471x', '471x', '471x'),
(7142, '454x', '454x', '454x'),
(7143, '555X', '555X', '555X'),
(7144, 'W660', 'W660', 'W660'),
(7145, 'C5005', 'C5005', 'C5005'),
(7146, 'C5100', 'C5100', 'C5100'),
(7147, 'C5320', 'C5320', 'C5320'),
(7148, 'C5330', 'C5330', 'C5330'),
(7149, 'C5588', 'C5588', 'C5588'),
(7150, 'C5589', 'C5589', 'C5589'),
(7151, 'C5600', 'C5600', 'C5600'),
(7152, 'C6100', 'C6100', 'C6100'),
(7153, 'C691', 'C691', 'C691'),
(7154, 'C7100', 'C7100', 'C7100'),
(7155, 'C7500', 'C7500', 'C7500'),
(7156, 'Castor', 'Castor', 'Castor'),
(7157, '230', '230', '230'),
(7158, 'CDM-8074VM', 'CDM-8074VM', 'CDM-8074VM'),
(7159, 'CDM 8150', 'CDM 8150', 'CDM 8150'),
(7160, 'CDM-8300', 'CDM-8300', 'CDM-8300'),
(7161, 'CDM-8400', 'CDM-8400', 'CDM-8400'),
(7162, 'CDM-8460T', 'CDM-8460T', 'CDM-8460T'),
(7163, 'CDM-8500', 'CDM-8500', 'CDM-8500'),
(7164, 'CDM-8600', 'CDM-8600', 'CDM-8600'),
(7165, 'CDM 8610VM', 'CDM 8610VM', 'CDM 8610VM'),
(7166, 'CDM-8900', 'CDM-8900', 'CDM-8900'),
(7167, 'CDM-8920', 'CDM-8920', 'CDM-8920'),
(7168, 'PN-320/CDM-8932', 'PN-320/CDM-8932', 'PN-320/CDM-8932'),
(7169, 'CDM-8955', 'CDM-8955', 'CDM-8955'),
(7170, 'CDM 8960', 'CDM 8960', 'CDM 8960'),
(7171, 'CDM 8964', 'CDM 8964', 'CDM 8964'),
(7172, 'CDM-9900', 'CDM-9900', 'CDM-9900'),
(7173, '8935', '8935', '8935'),
(7174, 'CDM 8950', 'CDM 8950', 'CDM 8950'),
(7175, 'CDM8975', 'CDM8975', 'CDM8975'),
(7176, 'U600', 'U600', 'U600'),
(7177, '1261', '1261', '1261'),
(7178, 'CL129', 'CL129', 'CL129'),
(7179, 'CL252', 'CL252', 'CL252'),
(7180, 'GPT380', 'GPT380', 'GPT380'),
(7181, 'COCOON', 'COCOON', 'COCOON'),
(7182, 'CORAL400', 'CORAL400', 'CORAL400'),
(7183, 'BlueBerry Princess', '9200', 'BlueBerry Princess 9200'),
(7184, 'CT9A9G', 'CT9A9G', 'CT9A9G'),
(7185, 'C8188', 'C8188', 'C8188'),
(7186, 'F600', 'F600', 'F600'),
(7187, 'A618', 'A618', 'A618'),
(7188, 'Chase 898', 'Chase 898', 'Chase 898'),
(7189, 'D77', 'D77', 'D77'),
(7190, 'HZ8', 'HZ8', 'HZ8'),
(7191, 'S7100', 'S7100', 'S7100'),
(7192, 'S7110', 'S7110', 'S7110'),
(7193, 'TG762', 'TG762', 'TG762'),
(7194, 'TG762D', 'TG762D', 'TG762D'),
(7195, 'U80', 'U80', 'U80'),
(7196, 'U8600', 'U8600', 'U8600'),
(7197, 'U8800', 'U8800', 'U8800'),
(7198, 'V800C', 'V800C', 'V800C'),
(7199, 'XG2', 'XG2', 'XG2'),
(7200, 'XG3', 'XG3', 'XG3'),
(7201, 'XG3C', 'XG3C', 'XG3C'),
(7202, 'XG5', 'XG5', 'XG5'),
(7203, 'XG655', 'XG655', 'XG655'),
(7204, 'XG799', 'XG799', 'XG799'),
(7205, 'W702', 'W702', 'W702'),
(7206, 'Proxy', 'Proxy', 'Proxy'),
(7207, 'CAPTR A200', 'CAPTR A200', 'CAPTR A200'),
(7208, 'CAPTR II', 'A210', 'CAPTR II A210'),
(7209, 'A300', 'A300', 'A300'),
(7210, 'MSGM8 II', 'A310', 'MSGM8 II A310'),
(7211, 'TXTM8', 'A410', 'TXTM8 A410'),
(7212, 'Memo', 'A415', 'Memo A415'),
(7213, 'D176', 'D176', 'D176'),
(7214, 'D758', 'D758', 'D758'),
(7215, 'DP900', 'DP900', 'DP900'),
(7216, '6668', '6668', '6668'),
(7217, '8038', '8038', '8038'),
(7218, '2039', '2039', '2039'),
(7219, '6228', '6228', '6228'),
(7220, '6568', '6568', '6568'),
(7221, '6588C', '6588C', '6588C'),
(7222, '6669', '6669', '6669'),
(7223, '8036', '8036', '8036'),
(7224, 'D5', 'D5', 'D5'),
(7225, 'J6', 'J6', 'J6'),
(7226, 'S40p', 'S40p', 'S40p'),
(7227, 'T905', 'T905', 'T905'),
(7228, 'HTC Vogue 200', 'S500', 'HTC Vogue 200 S500'),
(7229, 'Android 1.5 Tablet', 'Android 1.5 Tablet', 'Android 1.5 Tablet'),
(7230, 'Fennec', 'Fennec', 'Fennec'),
(7231, 'Fennec Desktop', 'Fennec Desktop', 'Fennec Desktop'),
(7232, 'Fennec Tablet', 'Fennec Tablet', 'Fennec Tablet'),
(7233, 'Android 2.0', 'Android 2.0', 'Android 2.0'),
(7234, 'Android 2.2 Tablet', 'Android 2.2 Tablet', 'Android 2.2 Tablet'),
(7235, 'Android 2.3 Tablet', 'Android 2.3 Tablet', 'Android 2.3 Tablet'),
(7236, 'Android 2.4', 'Android 2.4', 'Android 2.4'),
(7237, 'Android 3.0', 'Android 3.0', 'Android 3.0'),
(7238, 'Android 3.1', 'Android 3.1', 'Android 3.1'),
(7239, 'Android 3.2', 'Android 3.2', 'Android 3.2'),
(7240, 'Android 3.3', 'Android 3.3', 'Android 3.3'),
(7241, 'Chrome Mobile', 'Chrome Mobile', 'Chrome Mobile'),
(7242, 'QQ Browser', 'QQ Browser', 'QQ Browser'),
(7243, 'Browser', 'Browser', 'Browser'),
(7244, 'NX', 'NX', 'NX'),
(7245, '505i Series', '505i Series', '505i Series'),
(7246, '700i Series', '700i Series', '700i Series'),
(7247, '900i Series', '900i Series', '900i Series'),
(7248, '901i Series', '901i Series', '901i Series'),
(7249, 'Android 1.6 Tablet', 'Android 1.6 Tablet', 'Android 1.6 Tablet'),
(7250, 'Android 2.0 Tablet', 'Android 2.0 Tablet', 'Android 2.0 Tablet'),
(7251, 'Android 2.1 Tablet', 'Android 2.1 Tablet', 'Android 2.1 Tablet'),
(7252, 'Android 4.0', 'Android 4.0', 'Android 4.0'),
(7253, 'Android 4 Tablet', 'Android 4 Tablet', 'Android 4 Tablet'),
(7254, 'Android 4.1', 'Android 4.1', 'Android 4.1'),
(7255, 'Android 4.1 Tablet', 'Android 4.1 Tablet', 'Android 4.1 Tablet'),
(7256, 'Android 4.2', 'Android 4.2', 'Android 4.2'),
(7257, 'Android 4.2 Tablet', 'Android 4.2 Tablet', 'Android 4.2 Tablet'),
(7258, 'Android 4.3', 'Android 4.3', 'Android 4.3'),
(7259, 'Android 4.3 Tablet', 'Android 4.3 Tablet', 'Android 4.3 Tablet'),
(7260, 'Android 5.0', 'Android 5.0', 'Android 5.0'),
(7261, 'Android 5.0 Tablet', 'Android 5.0 Tablet', 'Android 5.0 Tablet'),
(7262, 'Crawler', 'Crawler', 'Crawler'),
(7263, 'App', 'App', 'App'),
(7264, 'Windows Mobile', 'Windows Mobile', 'Windows Mobile'),
(7265, 'Nexian Device', 'Nexian Device', 'Nexian Device'),
(7266, 'unrecognized OVI Browser', 'unrecognized OVI Browser', 'unrecognized OVI Browser'),
(7267, 'Symbian Client', 'Symbian Client', 'Symbian Client'),
(7268, 'Skyfire Browser', 'Skyfire Browser', 'Skyfire Browser'),
(7269, 'Unrecognized Vertu', 'Unrecognized Vertu', 'Unrecognized Vertu'),
(7270, 'Generic Maemo with Fennec', 'Generic Maemo with Fennec', 'Generic Maemo with Fennec'),
(7271, 'iPhone 2G', 'A1203', 'iPhone 2G A1203'),
(7272, 'iPod Touch Gen 1', 'iPod Touch Gen 1', 'iPod Touch Gen 1'),
(7273, 'iPhone 3G', 'A1241', 'iPhone 3G A1241'),
(7274, 'iPod Touch Gen 2', 'A1288', 'iPod Touch Gen 2 A1288'),
(7275, 'iPhone 3GS', 'A1303', 'iPhone 3GS A1303'),
(7276, 'iPod Touch Gen 3', 'A1318', 'iPod Touch Gen 3 A1318'),
(7277, 'iPad Gen 1', 'A1429', 'iPad Gen 1 A1429'),
(7278, 'iPhone 4', 'iPhone 4', 'iPhone 4'),
(7279, 'iPod Touch Gen 4', 'iPod Touch Gen 4', 'iPod Touch Gen 4');
INSERT INTO `smdevicenames` (`DeviceNameID`, `DeviceName`, `DeviceModel`, `MarketingName`) VALUES
(7280, 'iPad Gen 2', 'A1395', 'iPad Gen 2 A1395'),
(7281, 'iPhone 4S', 'A1387', 'iPhone 4S A1387'),
(7282, 'iPad Gen 3', 'A1416', 'iPad Gen 3 A1416'),
(7283, 'iPhone 5', 'A1429', 'iPhone 5 A1429'),
(7284, 'iPad Gen 4', 'iPad Gen 4', 'iPad Gen 4'),
(7285, 'iPad mini Gen 1', 'iPad mini Gen 1', 'iPad mini Gen 1'),
(7286, 'iPod Touch Gen 5', 'iPod Touch Gen 5', 'iPod Touch Gen 5'),
(7287, 'Thunderbird', 'Thunderbird', 'Thunderbird'),
(7288, 'Office', 'Office', 'Office'),
(7289, 'NetFront Ver. 3.1', 'NetFront Ver. 3.1', 'NetFront Ver. 3.1'),
(7290, 'NetFront Ver. 3.2', 'NetFront Ver. 3.2', 'NetFront Ver. 3.2'),
(7291, 'NetFront Ver. 3.3', 'NetFront Ver. 3.3', 'NetFront Ver. 3.3'),
(7292, 'NetFront Ver. 3.4', 'NetFront Ver. 3.4', 'NetFront Ver. 3.4'),
(7293, 'NetFront Ver. 4.0', 'NetFront Ver. 4.0', 'NetFront Ver. 4.0'),
(7294, 'NetFront Ver. 4.1', 'NetFront Ver. 4.1', 'NetFront Ver. 4.1'),
(7295, 'Generic Maemo', 'Generic Maemo', 'Generic Maemo'),
(7296, 'Mobi', 'Mobi', 'Mobi'),
(7297, 'Outlook Express', 'Outlook Express', 'Outlook Express'),
(7298, 'HTML Web browser', 'HTML Web browser', 'HTML Web browser'),
(7299, 'Mercury Web Gateway', 'Mercury Web Gateway', 'Mercury Web Gateway'),
(7300, 'Windows CE 1.0', 'Windows CE 1.0', 'Windows CE 1.0'),
(7301, 'Windows CE 2.0', 'Windows CE 2.0', 'Windows CE 2.0'),
(7302, 'Windows CE 3.0', 'Windows CE 3.0', 'Windows CE 3.0'),
(7303, 'Windows CE 4.0', 'Windows CE 4.0', 'Windows CE 4.0'),
(7304, 'Windows CE 5.0', 'Windows CE 5.0', 'Windows CE 5.0'),
(7305, 'Windows CE 6.0', 'Windows CE 6.0', 'Windows CE 6.0'),
(7306, 'Windows CE 7.0', 'Windows CE 7.0', 'Windows CE 7.0'),
(7307, 'Windows Mobile 5', 'Windows Mobile 5', 'Windows Mobile 5'),
(7308, 'Windows Mobile 6', 'Windows Mobile 6', 'Windows Mobile 6'),
(7309, 'Windows Mobile 6.1', 'Windows Mobile 6.1', 'Windows Mobile 6.1'),
(7310, 'Windows Mobile 6.5', 'Windows Mobile 6.5', 'Windows Mobile 6.5'),
(7311, 'Pocket PC 2000', 'Pocket PC 2000', 'Pocket PC 2000'),
(7312, 'Pocket PC 2002', 'Pocket PC 2002', 'Pocket PC 2002'),
(7313, 'G83', 'G83', 'G83'),
(7314, '595', '595', '595'),
(7315, '818Pro', '818Pro', '818Pro'),
(7316, '577W', '577W', '577W'),
(7317, '838', '838', '838'),
(7318, '838Pro', '838Pro', '838Pro'),
(7319, '900', '900', '900'),
(7320, 'C720W', 'C720W', 'C720W'),
(7321, 'Herald/Wing/Atlas', 'C800', 'Herald/Wing/Atlas C800'),
(7322, 'D600', 'D600', 'D600'),
(7323, 'D810', 'D810', 'D810'),
(7324, 'D818c', 'D818c', 'D818c'),
(7325, 'M700', 'M700', 'M700'),
(7326, 'P800W', 'P800W', 'P800W'),
(7327, 'S300', 'S300', 'S300'),
(7328, 'Web Browser', 'Web Browser', 'Web Browser'),
(7329, 'U626', 'U626', 'U626'),
(7330, 'Duplii', 'Duplii', 'Duplii'),
(7331, 'KWC-E1000', 'KWC-E1000', 'KWC-E1000'),
(7332, 'E300', 'E300', 'E300'),
(7333, 'Nucleus', 'C888', 'Nucleus C888'),
(7334, 'EL370', 'EL370', 'EL370'),
(7335, 'EL399', 'EL399', 'EL399'),
(7336, 'EL480', 'EL480', 'EL480'),
(7337, 'EL490', 'EL490', 'EL490'),
(7338, 'EL520', 'EL520', 'EL520'),
(7339, 'EL550', 'EL550', 'EL550'),
(7340, 'EL580', 'EL580', 'EL580'),
(7341, 'EL600Dual', 'EL600', 'EL600Dual EL600'),
(7342, 'EL680', 'EL680', 'EL680'),
(7343, 'A1228c-2', 'A1228c-2', 'A1228c-2'),
(7344, 'R278D', 'R278D', 'R278D'),
(7345, 'T60c', 'T60c', 'T60c'),
(7346, 'T61c', 'T61c', 'T61c'),
(7347, 'R280', 'R280', 'R280'),
(7348, 'ES1', 'ES1', 'ES1'),
(7349, 'ESL808', 'ESL808', 'ESL808'),
(7350, 'EVE', 'EVE', 'EVE'),
(7351, 'EZ400', 'EZ400', 'EZ400'),
(7352, 'EZ501', 'EZ501', 'EZ501'),
(7353, 'EZ600', 'EZ600', 'EZ600'),
(7354, 'EZ700', 'EZ700', 'EZ700'),
(7355, 'EZIO-E800', 'EZIO-E800', 'EZIO-E800'),
(7356, 'MP500', 'MP500', 'MP500'),
(7357, 'SL388', 'SL388', 'SL388'),
(7358, 'M5', 'M5', 'M5'),
(7359, 'MP100', 'MP100', 'MP100'),
(7360, 'EZ100', 'EZ100', 'EZ100'),
(7361, 'SL308', 'SL308', 'SL308'),
(7362, 'Emgeton Enzo', 'Emgeton Enzo', 'Emgeton Enzo'),
(7363, 'Emgeton Noble', 'Emgeton Noble', 'Emgeton Noble'),
(7364, 'MM60', 'MM60', 'MM60'),
(7365, 'R1a', 'R1a', 'R1a'),
(7366, 'A2618', 'A2618', 'A2618'),
(7367, 'A2628', 'A2628', 'A2628'),
(7368, 'R320', 'R320', 'R320'),
(7369, 'R520', 'R520', 'R520'),
(7370, 'R600', 'R600', 'R600'),
(7371, 'T20e', 'T20e', 'T20e'),
(7372, 'T29s', 'T29s', 'T29s'),
(7373, 'T60d', 'T60d', 'T60d'),
(7374, 'T65', 'T65', 'T65'),
(7375, 'T66', 'T66', 'T66'),
(7376, 'T68', 'T68', 'T68'),
(7377, 'SDA', 'SDA', 'SDA'),
(7378, 'T68m', 'T68m', 'T68m'),
(7379, 'F106-ChinaUnicom', 'F106-ChinaUnicom', 'F106-ChinaUnicom'),
(7380, 'F230', 'F230', 'F230'),
(7381, 'Sidekick', 'Sidekick 3', 'Sidekick Sidekick 3'),
(7382, 'GF-600', 'GF-600', 'GF-600'),
(7383, 'Concept GX-2', 'Concept GX-2', 'Concept GX-2'),
(7384, 'VI600', 'VI600', 'VI600'),
(7385, 'RL-7300', 'RL-7300', 'RL-7300'),
(7386, 'VI-2300', 'VI-2300', 'VI-2300'),
(7387, 'VM-4500', 'VM-4500', 'VM-4500'),
(7388, 'VM-4050', 'VM-4050', 'VM-4050'),
(7389, 'Fastweb', 'F188', 'Fastweb F188'),
(7390, 'XM', 'XM', 'XM'),
(7391, 'B700 Duo', 'B700 Duo', 'B700 Duo'),
(7392, 'M130', 'M130', 'M130'),
(7393, 'MP600', 'MP600', 'MP600'),
(7394, 'MV 124 Phone Theatre', 'MV 124', 'MV 124 Phone Theatre MV 124'),
(7395, '2040', '2040', '2040'),
(7396, '2040L', '2040L', '2040L'),
(7397, '2040i', '2040i', '2040i'),
(7398, 'B720 Duo', 'B720 Duo', 'B720 Duo'),
(7399, 'DS400', 'DS400', 'DS400'),
(7400, 'MX200i', 'MX200i', 'MX200i'),
(7401, 'MX230', 'MX230', 'MX230'),
(7402, 'MX330', 'MX330', 'MX330'),
(7403, 'SL110', 'SL110', 'SL110'),
(7404, 'SL300m', 'SL300m', 'SL300m'),
(7405, 'SL399e', 'SL399e', 'SL399e'),
(7406, 'SL500i', 'SL500i', 'SL500i'),
(7407, 'SL500m', 'SL500m', 'SL500m'),
(7408, 'SL600', 'SL600', 'SL600'),
(7409, 'SX205', 'SX205', 'SX205'),
(7410, 'SX210', 'SX210', 'SX210'),
(7411, 'SX220', 'SX220', 'SX220'),
(7412, 'SX300', 'SX300', 'SX300'),
(7413, 'SX305', 'SX305', 'SX305'),
(7414, 'SX310', 'SX310', 'SX310'),
(7415, 'SX390', 'SX390', 'SX390'),
(7416, 'PG2100', 'PG2100', 'PG2100'),
(7417, '2080', '2080', '2080'),
(7418, 'MC100', 'MC100', 'MC100'),
(7419, 'MC110', 'MC110', 'MC110'),
(7420, 'SX240', 'SX240', 'SX240'),
(7421, 'Fly V100', 'Fly V100', 'Fly V100'),
(7422, 'V71', 'V71', 'V71'),
(7423, 'B400', 'B400', 'B400'),
(7424, 'DS500', 'DS500', 'DS500'),
(7425, 'E105', 'E105', 'E105'),
(7426, 'Attitude', 'E310', 'Attitude E310'),
(7427, 'Fly HUMMER HT1', 'HT1', 'Fly HUMMER HT1 HT1'),
(7428, 'LX500', 'LX500', 'LX500'),
(7429, 'Mega', 'LX600', 'Mega LX600'),
(7430, 'Fly-LX610', 'Fly-LX610', 'Fly-LX610'),
(7431, 'SX100', 'SX100', 'SX100'),
(7432, 'SX200', 'SX200', 'SX200'),
(7433, 'Fly-SX225', 'Fly-SX225', 'Fly-SX225'),
(7434, 'SX230', 'SX230', 'SX230'),
(7435, 'Fly-SX315', 'Fly-SX315', 'Fly-SX315'),
(7436, 'Fly HUMMER HT2', 'HT2', 'Fly HUMMER HT2 HT2'),
(7437, 'B300', 'B300', 'B300'),
(7438, 'DS120', 'DS120', 'DS120'),
(7439, 'DS123', 'DS123', 'DS123'),
(7440, 'DS150', 'DS150', 'DS150'),
(7441, 'DS155', 'DS155', 'DS155'),
(7442, 'DS170', 'DS170', 'DS170'),
(7443, 'DS185', 'DS185', 'DS185'),
(7444, 'DS186', 'DS186', 'DS186'),
(7445, 'E133', 'E133', 'E133'),
(7446, 'E134', 'E134', 'E134'),
(7447, 'E140', 'E140', 'E140'),
(7448, 'E141_TV', 'E141_TV', 'E141_TV'),
(7449, 'E146', 'E146', 'E146'),
(7450, 'E147_TV', 'E147_TV', 'E147_TV'),
(7451, 'E150', 'E150', 'E150'),
(7452, 'E154', 'E154', 'E154'),
(7453, 'E155', 'E155', 'E155'),
(7454, 'E170', 'E170', 'E170'),
(7455, 'E171', 'E171', 'E171'),
(7456, 'E176', 'E176', 'E176'),
(7457, 'M140', 'M140', 'M140'),
(7458, 'MC150ds', 'MC150ds', 'MC150ds'),
(7459, 'MC170DS', 'MC170DS', 'MC170DS'),
(7460, 'Fly_MC175_DS', 'Fly_MC175_DS', 'Fly_MC175_DS'),
(7461, 'MC180', 'MC180', 'MC180'),
(7462, 'Fly_MC300', 'Fly_MC300', 'Fly_MC300'),
(7463, 'Q110_TV', 'Q110_TV', 'Q110_TV'),
(7464, 'Q115', 'Q115', 'Q115'),
(7465, 'Q120_TV', 'Q120_TV', 'Q120_TV'),
(7466, 'Q200', 'Q200', 'Q200'),
(7467, 'Fly_Q300', 'Fly_Q300', 'Fly_Q300'),
(7468, 'Q400', 'Q400', 'Q400'),
(7469, 'Q410', 'Q410', 'Q410'),
(7470, 'Q420', 'Q420', 'Q420'),
(7471, 'SL130', 'SL130', 'SL130'),
(7472, 'Fly_ST230', 'Fly_ST230', 'Fly_ST230'),
(7473, 'TS100', 'TS100', 'TS100'),
(7474, 'TS105', 'TS105', 'TS105'),
(7475, '777', '777', '777'),
(7476, 'G3', 'G3', 'G3'),
(7477, 'G710', 'G710', 'G710'),
(7478, 'GF950', 'GF950', 'GF950'),
(7479, 'GF970', 'GF970', 'GF970'),
(7480, 'Chat', 'Chat', 'Chat'),
(7481, 'G-Smart', 'G-Smart', 'G-Smart'),
(7482, 'A280', 'A280', 'A280'),
(7483, 'D001', 'D001', 'D001'),
(7484, 'F6', 'F6', 'F6'),
(7485, 'I9', 'I9', 'I9'),
(7486, 'L10', 'L10', 'L10'),
(7487, 'L6', 'L6', 'L6'),
(7488, 'L7', 'L7', 'L7'),
(7489, 'L906', 'L906', 'L906'),
(7490, 'M902', 'M902', 'M902'),
(7491, 'M003', 'M003', 'M003'),
(7492, 'GM T3', 'GM T3', 'GM T3'),
(7493, 'GPFM1238', 'GPFM1238', 'GPFM1238'),
(7494, 'GPF198', 'GPF198', 'GPF198'),
(7495, 'GC-202X', 'GC-202X', 'GC-202X'),
(7496, 'GC370', 'GC370', 'GC370'),
(7497, 'GTX-212', 'GTX-212', 'GTX-212'),
(7498, 'GU1100', 'GU1100', 'GU1100'),
(7499, 'DoCoMo 2.0', 'DoCoMo 2.0', 'DoCoMo 2.0'),
(7500, 'Gigaset SL74', 'Gigaset SL74', 'Gigaset SL74'),
(7501, 'Concept GX2', 'Concept GX2', 'Concept GX2'),
(7502, 'GC300', 'GC300', 'GC300'),
(7503, 'GF-690', 'GF-690', 'GF-690'),
(7504, 'GF760', 'GF760', 'GF760'),
(7505, 'GF-910', 'GF-910', 'GF-910'),
(7506, 'GF-930', 'GF-930', 'GF-930'),
(7507, 'GV-230', 'GV-230', 'GV-230'),
(7508, 'GV-690', 'GV-690', 'GV-690'),
(7509, 'Vibe', 'Vibe', 'Vibe'),
(7510, 'Q100', 'X990', 'Q100 X990'),
(7511, 'TTPComRef', 'TTPComRef', 'TTPComRef'),
(7512, 'H888', 'H888', 'H888'),
(7513, 'H899', 'H899', 'H899'),
(7514, 'CDM-8200', 'CDM-8200', 'CDM-8200'),
(7515, 'MMD1010', 'MMD1010', 'MMD1010'),
(7516, 'MMP1020', 'MMP1020', 'MMP1020'),
(7517, 'PD20', 'PD20', 'PD20'),
(7518, 'TX20b0011a', 'TX20b0011a', 'TX20b0011a'),
(7519, 'H777', 'H777', 'H777'),
(7520, 'H797', 'H797', 'H797'),
(7521, 'M881', 'M881', 'M881'),
(7522, 'HGC600E', 'HGC600E', 'HGC600E'),
(7523, 'HG7000', 'HG7000', 'HG7000'),
(7524, 'iPAQ HW6500', 'iPAQ HW6500', 'iPAQ HW6500'),
(7525, 'iPAQ HW6510', 'iPAQ HW6510', 'iPAQ HW6510'),
(7526, 'iPAQ HW6515', 'iPAQ HW6515', 'iPAQ HW6515'),
(7527, 'iPAQ HW6925', 'iPAQ HW6925', 'iPAQ HW6925'),
(7528, 'iPAQ 910', 'iPAQ 910', 'iPAQ 910'),
(7529, 'iPAQ Data Messenger', 'iPAQ Data Messenger', 'iPAQ Data Messenger'),
(7530, 'iPAQ 6900', 'iPAQ 6900', 'iPAQ 6900'),
(7531, 'iPAQ HW6915', 'iPAQ HW6915', 'iPAQ HW6915'),
(7532, 'iPAQ hw692x', 'iPAQ hw692x', 'iPAQ hw692x'),
(7533, 'iPAQ rw6800', 'iPAQ rw6800', 'iPAQ rw6800'),
(7534, 'iPAQ rw6815', 'iPAQ rw6815', 'iPAQ rw6815'),
(7535, 'C1110', 'C1110', 'C1110'),
(7536, 'HS C3698', 'HS C3698', 'HS C3698'),
(7537, 'HT-1', 'HT-1', 'HT-1'),
(7538, 'G111', 'G111', 'G111'),
(7539, 'HTIL-S210', 'HTIL-S210', 'HTIL-S210'),
(7540, 'HTIL V70', 'HTIL V70', 'HTIL V70'),
(7541, 'Dual Sim Card', 'Double Z702', 'Dual Sim Card Double Z702'),
(7542, 'G7300', 'G7300', 'G7300'),
(7543, 'M228', 'M228', 'M228'),
(7544, 'M318', 'M318', 'M318'),
(7545, 'M328', 'M328', 'M328'),
(7546, 'M635', 'M635', 'M635'),
(7547, 'U2800', 'U2800', 'U2800'),
(7548, 'HUAWEI U2900', 'HUAWEI U2900', 'HUAWEI U2900'),
(7549, 'U5110', 'U5110', 'U5110'),
(7550, 'U6020', 'U6020', 'U6020'),
(7551, 'U6150', 'U6150', 'U6150'),
(7552, 'G7002', 'G7002', 'G7002'),
(7553, 'C5700', 'C5700', 'C5700'),
(7554, 'EG-8080', 'EG-8080', 'EG-8080'),
(7555, '1200P', '1200P', '1200P'),
(7556, 'HG-A7', 'HG-A7', 'HG-A7'),
(7557, 'HG M301', 'HG M301', 'HG M301'),
(7558, 'HG V70', 'HG V70', 'HG V70'),
(7559, 'M1610', 'M1610', 'M1610'),
(7560, 'M260', 'M260', 'M260'),
(7561, 'P7', 'P7', 'P7'),
(7562, 'T10C', 'T10C', 'T10C'),
(7563, 'V7000', 'V7000', 'V7000'),
(7564, 'Z3000', 'Z3000', 'Z3000'),
(7565, 'P300', 'P300', 'P300'),
(7566, 'U9120', 'U9120', 'U9120'),
(7567, 'T209', 'T209', 'T209'),
(7568, 'U526', 'U526', 'U526'),
(7569, 'U528', 'U528', 'U528'),
(7570, 'U121', 'U121', 'U121'),
(7571, 'Beeline A103', 'Beeline A103', 'Beeline A103'),
(7572, 'U1300', 'U1300', 'U1300'),
(7573, 'U7315', 'U7315', 'U7315'),
(7574, 'HUAWEI U9100', 'HUAWEI U9100', 'HUAWEI U9100'),
(7575, 'Vodafone Huawei U1280', 'U1280', 'Vodafone Huawei U1280 U1280'),
(7576, 'U6100', 'U6100', 'U6100'),
(7577, 'HUAWEI G3510', 'HUAWEI G3510', 'HUAWEI G3510'),
(7578, 'G6610V', 'G6610V', 'G6610V'),
(7579, 'G6620', 'G6620', 'G6620'),
(7580, 'Pillar', 'M615', 'Pillar M615'),
(7581, 'U1305', 'U1305', 'U1305'),
(7582, 'U1307', 'U1307', 'U1307'),
(7583, 'U1310', 'U1310', 'U1310'),
(7584, 'U1315', 'U1315', 'U1315'),
(7585, 'U3307', 'U3307', 'U3307'),
(7586, 'U3311', 'U3311', 'U3311'),
(7587, 'U3315', 'U3315', 'U3315'),
(7588, 'U5700', 'U5700', 'U5700'),
(7589, 'HUAWEI U5705', 'HUAWEI U5705', 'HUAWEI U5705'),
(7590, 'U5900', 'U5900', 'U5900'),
(7591, 'U7200', 'U7200', 'U7200'),
(7592, 'MTC 752', 'MTC 752', 'MTC 752'),
(7593, 'G3500', 'G3500', 'G3500'),
(7594, 'G5510', 'G5510', 'G5510'),
(7595, 'G5730', 'G5730', 'G5730'),
(7596, 'G6600', 'G6600', 'G6600'),
(7597, 'G7007', 'G7007', 'G7007'),
(7598, 'Huawei-G7010', 'Huawei-G7010', 'Huawei-G7010'),
(7599, 'G7105', 'G7105', 'G7105'),
(7600, 'H11HW', 'H11HW', 'H11HW'),
(7601, 'G6608', 'G6608', 'G6608'),
(7602, 'U1250', 'U1250', 'U1250'),
(7603, 'U550', 'U550', 'U550'),
(7604, 'T7200', 'T7200', 'T7200'),
(7605, 'U1005', 'U1005', 'U1005'),
(7606, 'U1107', 'U1107', 'U1107'),
(7607, 'U1205', 'U1205', 'U1205'),
(7608, 'U1211', 'U1211', 'U1211'),
(7609, 'U1215', 'U1215', 'U1215'),
(7610, 'HUAWEI U3100', 'HUAWEI U3100', 'HUAWEI U3100'),
(7611, 'U3200s', 'U3200s', 'U3200s'),
(7612, 'U7510', 'U7510', 'U7510'),
(7613, 'HUAWEI U7515', 'HUAWEI U7515', 'HUAWEI U7515'),
(7614, 'U7517', 'U7517', 'U7517'),
(7615, 'U7519', 'U7519', 'U7519'),
(7616, 'U7520', 'U7520', 'U7520'),
(7617, 'HUAWEI U7525', 'HUAWEI U7525', 'HUAWEI U7525'),
(7618, 'HUAWEI U7527', 'HUAWEI U7527', 'HUAWEI U7527'),
(7619, 'U9130', 'U9130', 'U9130'),
(7620, 'e808', 'e808', 'e808'),
(7621, 'i-GO 610', 'i-GO 610', 'i-GO 610'),
(7622, 'i-GO 620', 'i-GO 620', 'i-GO 620'),
(7623, 'JAM', 'JAM', 'JAM'),
(7624, 'I2300', 'I2300', 'I2300'),
(7625, 'KM65', 'KM65', 'KM65'),
(7626, 'KM63', 'KM63', 'KM63'),
(7627, 'T880', 'T880', 'T880'),
(7628, 'IN 2010 Nano2', 'IN 2010 Nano2', 'IN 2010 Nano2'),
(7629, 'INNO30', 'INNO30', 'INNO30'),
(7630, 'INNO35', 'INNO35', 'INNO35'),
(7631, 'INNO50', 'INNO50', 'INNO50'),
(7632, 'INNO55', 'INNO55', 'INNO55'),
(7633, 'INNO80', 'INNO80', 'INNO80'),
(7634, 'INNO89', 'INNO89', 'INNO89'),
(7635, 'INNO90', 'INNO90', 'INNO90'),
(7636, 'INNO98', 'INNO98', 'INNO98'),
(7637, 'Inno 99', 'Inno 99', 'Inno 99'),
(7638, 'INNOA10', 'INNOA10', 'INNOA10'),
(7639, 'INNOA10_W2', 'INNOA10_W2', 'INNOA10_W2'),
(7640, 'B1 200H', 'B1 200H', 'B1 200H'),
(7641, 'Q1 200H', 'Q1 200H', 'Q1 200H'),
(7642, 'Chat 3G', 'INQ Q1-200H', 'Chat 3G INQ Q1-200H'),
(7643, 'Q1 218H', 'Q1 218H', 'Q1 218H'),
(7644, 'INQ1', 'INQ1', 'INQ1'),
(7645, 'IN 2040 NX V.DO Power', 'IN 2040 NX', 'IN 2040 NX V.DO Power IN 2040 NX'),
(7646, 'IT2500', 'IT2500', 'IT2500'),
(7647, 'CT25', 'CT25', 'CT25'),
(7648, 'CT 25m', 'CT 25m', 'CT 25m'),
(7649, 'Ice', 'Ice', 'Ice'),
(7650, 'Indie', 'Indie', 'Indie'),
(7651, '2130', '2130', '2130'),
(7652, 'J-DN02', 'J-DN02', 'J-DN02'),
(7653, 'J-P02', 'J-P02', 'J-P02'),
(7654, 'J-P03', 'J-P03', 'J-P03'),
(7655, 'J-SA02', 'J-SA02', 'J-SA02'),
(7656, 'J-SH02', 'J-SH02', 'J-SH02'),
(7657, 'J-SH03', 'J-SH03', 'J-SH03'),
(7658, 'J-T04', 'J-T04', 'J-T04'),
(7659, 'J-D03', 'J-D03', 'J-D03'),
(7660, 'J-D04', 'J-D04', 'J-D04'),
(7661, 'J-D05', 'J-D05', 'J-D05'),
(7662, 'J-D06', 'J-D06', 'J-D06'),
(7663, 'J-D07', 'J-D07', 'J-D07'),
(7664, 'J-D08', 'J-D08', 'J-D08'),
(7665, 'J-D31', 'J-D31', 'J-D31'),
(7666, 'J-DN03', 'J-DN03', 'J-DN03'),
(7667, 'J-K03', 'J-K03', 'J-K03'),
(7668, 'J-K04', 'J-K04', 'J-K04'),
(7669, 'J-K05', 'J-K05', 'J-K05'),
(7670, 'J-N03', 'J-N03', 'J-N03'),
(7671, 'J-N04', 'J-N04', 'J-N04'),
(7672, 'J-N05', 'J-N05', 'J-N05'),
(7673, 'J-NM01', 'J-NM01', 'J-NM01'),
(7674, 'J-NM02', 'J-NM02', 'J-NM02'),
(7675, 'J-PE03', 'J-PE03', 'J-PE03'),
(7676, 'J-PE03II', 'J-PE03II', 'J-PE03II'),
(7677, 'J-SA03', 'J-SA03', 'J-SA03'),
(7678, 'J-SA04', 'J-SA04', 'J-SA04'),
(7679, 'J-SA05', 'J-SA05', 'J-SA05'),
(7680, 'J-SA06', 'J-SA06', 'J-SA06'),
(7681, 'J-SH04', 'J-SH04', 'J-SH04'),
(7682, 'J-SH04B', 'J-SH04B', 'J-SH04B'),
(7683, 'J-SH05', 'J-SH05', 'J-SH05'),
(7684, 'J-SH06', 'J-SH06', 'J-SH06'),
(7685, 'J-SH07', 'J-SH07', 'J-SH07'),
(7686, 'J-SH08', 'J-SH08', 'J-SH08'),
(7687, 'J-SH09', 'J-SH09', 'J-SH09'),
(7688, 'J-SH010', 'J-SH010', 'J-SH010'),
(7689, 'J-T05', 'J-T05', 'J-T05'),
(7690, 'J-T06', 'J-T06', 'J-T06'),
(7691, 'J-T07', 'J-T07', 'J-T07'),
(7692, 'J-T08', 'J-T08', 'J-T08'),
(7693, 'J-T09', 'J-T09', 'J-T09'),
(7694, 'J-T010', 'J-T010', 'J-T010'),
(7695, 'V102D', 'V102D', 'V102D'),
(7696, 'V201SH', 'V201SH', 'V201SH'),
(7697, 'V301D', 'V301D', 'V301D'),
(7698, 'V301SH', 'V301SH', 'V301SH'),
(7699, 'V301T', 'V301T', 'V301T'),
(7700, 'V302SH', 'V302SH', 'V302SH'),
(7701, 'V302T', 'V302T', 'V302T'),
(7702, 'V303T', 'V303T', 'V303T'),
(7703, '304T', '304T', '304T'),
(7704, 'V401D', 'V401D', 'V401D'),
(7705, 'V401SA', 'V401SA', 'V401SA'),
(7706, 'V401SH', 'V401SH', 'V401SH'),
(7707, 'V401T', 'V401T', 'V401T'),
(7708, 'V402SH', 'V402SH', 'V402SH'),
(7709, 'V403SH', 'V403SH', 'V403SH'),
(7710, 'J-K51', 'J-K51', 'J-K51'),
(7711, 'J-P51', 'J-P51', 'J-P51'),
(7712, 'J-SH51', 'J-SH51', 'J-SH51'),
(7713, 'J-T51', 'J-T51', 'J-T51'),
(7714, 'J-SA51', 'J-SA51', 'J-SA51'),
(7715, 'J-SH52', 'J-SH52', 'J-SH52'),
(7716, 'J-N51', 'J-N51', 'J-N51'),
(7717, 'J-SH53', 'J-SH53', 'J-SH53'),
(7718, 'V601N', 'V601N', 'V601N'),
(7719, 'V601SH', 'V601SH', 'V601SH'),
(7720, 'V501SH', 'V501SH', 'V501SH'),
(7721, 'V501T', 'V501T', 'V501T'),
(7722, 'V502T', 'V502T', 'V502T'),
(7723, 'V601T', 'V601T', 'V601T'),
(7724, 'V602SH', 'V602SH', 'V602SH'),
(7725, 'V602T', 'V602T', 'V602T'),
(7726, 'V603SH', 'V603SH', 'V603SH'),
(7727, 'V603T', 'V603T', 'V603T'),
(7728, 'V604SH', 'V604SH', 'V604SH'),
(7729, 'V604T', 'V604T', 'V604T'),
(7730, 'JATULC2', 'JATULC2', 'JATULC2'),
(7731, 'Updater', 'Updater', 'Updater'),
(7732, 'Shadow', 'Shadow', 'Shadow'),
(7733, 'K1000', 'K1000', 'K1000'),
(7734, 'K3000', 'K3000', 'K3000'),
(7735, 'K38', 'K38', 'K38'),
(7736, 'K444', 'K444', 'K444'),
(7737, 'K451', 'K451', 'K451'),
(7738, 'k505', 'k505', 'k505'),
(7739, 'Presto', 'S1350', 'Presto S1350'),
(7740, 'S2100', 'S2100', 'S2100'),
(7741, 'Generic WAP 2', 'Generic WAP 2', 'Generic WAP 2'),
(7742, 'D161', 'D161', 'D161'),
(7743, 'D263', 'D263', 'D263'),
(7744, 'D319', 'D319', 'D319'),
(7745, 'D363', 'D363', 'D363'),
(7746, 'M526', 'M526', 'M526'),
(7747, 'CG001', 'CG001', 'CG001'),
(7748, 'SD-528', 'SD-528', 'SD-528'),
(7749, 'SD588', 'SD588', 'SD588'),
(7750, 'S2000i', 'S2000i', 'S2000i'),
(7751, 'Streak', 'Streak', 'Streak Streak'),
(7752, 'Titan', 'K4+', 'Titan K4+'),
(7753, 'Mighty', 'K45', 'Mighty K45'),
(7754, 'Thump', 'KT66', 'Thump KT66'),
(7755, 'Kingcom Injoy MS02', 'Kingcom Injoy MS02', 'Kingcom Injoy MS02'),
(7756, 'C4700', 'C4700', 'C4700'),
(7757, 'c908', 'c908', 'c908'),
(7758, 'LX11', 'LX11', 'LX11'),
(7759, 'LX14', 'LX14', 'LX14'),
(7760, 'LX5', 'LX5', 'LX5'),
(7761, 'LX6', 'LX6', 'LX6'),
(7762, 'R10', 'R10', 'R10'),
(7763, 'T99', 'T99', 'T99'),
(7764, 'Z20', 'Z20', 'Z20'),
(7765, 'Z11', 'Z11', 'Z11'),
(7766, 'KKT35', 'KKT35', 'KKT35'),
(7767, 'L300B', 'L300B', 'L300B'),
(7768, 'L310B', 'L310B', 'L310B'),
(7769, 'N500B', 'N500B', 'N500B'),
(7770, 'TV320B', 'TV320B', 'TV320B'),
(7771, 'X700B', 'X700B', 'X700B'),
(7772, 'X845B', 'X845B', 'X845B'),
(7773, 'X880B', 'X880B', 'X880B'),
(7774, 'X901A', 'X901A', 'X901A'),
(7775, 'IQ 707', 'IQ 707', 'IQ 707'),
(7776, 'E303', 'E303', 'E303'),
(7777, 'E307', 'E307', 'E307'),
(7778, 'E308', 'E308', 'E308'),
(7779, 'i720', 'i720', 'i720'),
(7780, 'P708', 'P708', 'P708'),
(7781, 'P709', 'P709', 'P709'),
(7782, 'P768', 'P768', 'P768'),
(7783, 'P780', 'P780', 'P780'),
(7784, 'P960', 'P960', 'P960'),
(7785, 'S5', 'S5', 'S5'),
(7786, 'S9', 'S9', 'S9'),
(7787, 'V528', 'V528', 'V528'),
(7788, 'V707', 'V707', 'V707'),
(7789, 'i908', 'i908', 'i908'),
(7790, 'i919', 'i919', 'i919'),
(7791, 'i921', 'i921', 'i921'),
(7792, 'Lenovo i966', 'K700c', 'Lenovo i966 K700c'),
(7793, 'TAB4000', 'TAB4000', 'TAB4000'),
(7794, 'SK16D', 'SK16D', 'SK16D'),
(7795, 'SK18', 'SK18', 'SK18'),
(7796, 'X1', 'X1', 'X1'),
(7797, 'LX20', 'LX20', 'LX20'),
(7798, 'iT 515', 'iT 515', 'iT 515'),
(7799, 'Duo 339 Super', 'Duo 339 Super', 'Duo 339 Super'),
(7800, 'P707', 'P707', 'P707'),
(7801, 'P790', 'P790', 'P790'),
(7802, 'P90W', 'P90W', 'P90W'),
(7803, 'i300', 'i300', 'i300'),
(7804, 'i325wg', 'i325wg', 'i325wg'),
(7805, 'i817', 'i817', 'i817'),
(7806, 'I906', 'I906', 'I906'),
(7807, 'i909', 'i909', 'i909'),
(7808, 'A689', 'A689', 'A689'),
(7809, 'ET600', 'ET600', 'ET600'),
(7810, 'ET860', 'ET860', 'ET860'),
(7811, 'Levi\'s - the original', 'Levi\'s - the original', 'Levi\'s - the original'),
(7812, 'Levis The Original', 'Levis The Original', 'Levis The Original'),
(7813, 'M-Three', 'M-Three', 'M-Three'),
(7814, 'M200i', 'M200i', 'M200i'),
(7815, 'SS220', 'SS220', 'SS220'),
(7816, 'M4U', 'M4U', 'M4U'),
(7817, 'M590', 'M590', 'M590'),
(7818, 'M72', 'M72', 'M72'),
(7819, 'M901', 'M901', 'M901'),
(7820, 'MAUI WAP Browser', 'MAUI WAP Browser', 'MAUI WAP Browser'),
(7821, 'T8167', 'T8167', 'T8167'),
(7822, 'MC218', 'MC218', 'MC218'),
(7823, 'ST7867', 'ST7867', 'ST7867'),
(7824, 'MomoDesign MD-302', 'MD-302', 'MomoDesign MD-302 MD-302'),
(7825, 'MomoDesign MD Cube', 'MD-Cube', 'MomoDesign MD Cube MD-Cube'),
(7826, 'MD2', 'MD2', 'MD2'),
(7827, 'MD3', 'F912', 'MD3 F912'),
(7828, 'MomoDesign Touch', 'MD Touch', 'MomoDesign Touch MD Touch'),
(7829, 'MD301H', 'MD301H', 'MD301H'),
(7830, 'ME701', 'ME701', 'ME701'),
(7831, 'ME702', 'ME702', 'ME702'),
(7832, '2860', '2860', '2860'),
(7833, 'X3', 'X3', 'X3'),
(7834, 'Q5', 'Q5', 'Q5'),
(7835, 'Digi Walker', 'Mio 8390', 'Digi Walker Mio 8390'),
(7836, 'Digi Walker', 'Mio A700', 'Digi Walker Mio A700'),
(7837, 'MK99', 'MK99', 'MK99'),
(7838, 'MW200', 'MW200', 'MW200'),
(7839, 'i700plus', 'i700plus', 'i700plus'),
(7840, 'WTE320', 'WTE320', 'WTE320'),
(7841, 'MOT-V176', 'MOT-V176', 'MOT-V176'),
(7842, 'Treo 700p', 'Treo 700p', 'Treo 700p'),
(7843, 'MQ606', 'MQ606', 'MQ606'),
(7844, 'Play', 'MSD7', 'Play MSD7'),
(7845, 'MTC', 'U1250', 'MTC U1250'),
(7846, 'V736', 'V736', 'V736'),
(7847, 'V835', 'V835', 'V835'),
(7848, 'MTC 535', 'MTC 535', 'MTC 535'),
(7849, 'MTC 655', 'MTC 655', 'MTC 655'),
(7850, 'MTV 3.0', 'MTV 3.0', 'MTV 3.0'),
(7851, 'MTV 4.0', 'MTV 4.0', 'MTV 4.0'),
(7852, 'U3310', 'U3310', 'U3310'),
(7853, 'MX8', 'MX8', 'MX8'),
(7854, 'Majestic1', 'Majestic1', 'Majestic1'),
(7855, 'O2-X1', 'O2-X1', 'O2-X1'),
(7856, 'X113', 'X113', 'X113'),
(7857, 'Q1', 'Q1', 'Q1'),
(7858, 'X235', 'X235', 'X235'),
(7859, 'X395', 'X395', 'X395'),
(7860, 'X225', 'X225', 'X225'),
(7861, 'Ezpad', 'Q3 Plus', 'Ezpad Q3 Plus'),
(7862, 'Q50', 'Q50', 'Q50'),
(7863, 'Q6', 'Q6', 'Q6'),
(7864, 'Q7 EZPAD', 'Q7', 'Q7 EZPAD Q7'),
(7865, 'MicromaxQ75', 'MicromaxQ75', 'MicromaxQ75'),
(7866, 'X210', 'X210', 'X210'),
(7867, 'X222', 'X222', 'X222'),
(7868, 'X228+', 'X228+', 'X228+'),
(7869, 'X263', 'X263', 'X263'),
(7870, 'X265', 'X265', 'X265'),
(7871, 'X266', 'X266', 'X266'),
(7872, 'X285', 'X285', 'X285'),
(7873, 'X288', 'X288', 'X288'),
(7874, 'X330', 'X330', 'X330'),
(7875, 'X410', 'X410', 'X410'),
(7876, 'X505', 'X505', 'X505'),
(7877, 'X510', 'X510', 'X510'),
(7878, 'X550 QUBE', 'X550', 'X550 QUBE X550'),
(7879, 'X560', 'X560', 'X560'),
(7880, 'BITS updater', 'BITS updater', 'BITS updater'),
(7881, 'Mio A701', 'Mio A701', 'Mio A701'),
(7882, 'Mobile Explorer', 'Mobile Explorer', 'Mobile Explorer'),
(7883, '1', '1', '1'),
(7884, 'Sprint', 'MP6900 SP', 'Sprint MP6900 SP'),
(7885, 'Eudora client for Palm III', 'Eudora client for Palm III', 'Eudora client for Palm III'),
(7886, 'WX330J', 'WX330J', 'WX330J'),
(7887, 'Sweetia', 'WX02K', 'Sweetia WX02K'),
(7888, 'Liberio', 'WX03K', 'Liberio WX03K'),
(7889, 'WX340K', 'WX340K', 'WX340K'),
(7890, 'Pantone WX01SH', 'WX01SH', 'Pantone WX01SH WX01SH'),
(7891, 'Incognito', 'SCP6760', 'Incognito SCP6760'),
(7892, 'SCP3810', 'SCP3810', 'SCP3810'),
(7893, 'Incognito', 'SCP-6760', 'Incognito SCP-6760'),
(7894, 'SCP2700', 'SCP2700', 'SCP2700'),
(7895, 'Innuendo', 'SCP6780', 'Innuendo SCP6780'),
(7896, 'Taho', 'E4100', 'Taho E4100'),
(7897, 'Vero', 'SCP3820', 'Vero SCP3820'),
(7898, 'Innuendo', 'SCP-6780', 'Innuendo SCP-6780'),
(7899, 'P526', 'P526', 'P526'),
(7900, 'PEG-UX50', 'PEG-UX50', 'PEG-UX50'),
(7901, 'Playstation 3', 'Playstation 3', 'Playstation 3'),
(7902, 'PSP', 'PlayStation Portable', 'PSP PlayStation Portable'),
(7903, 'KS500', 'KS500', 'KS500'),
(7904, 'OGO-CT1X', 'OGO-CT1X', 'OGO-CT1X'),
(7905, 'Xda Graphite', 'Xda Graphite', 'Xda Graphite'),
(7906, 'Xda II Mini', 'Xda II Mini', 'Xda II Mini'),
(7907, 'Xda IIs', 'Xda IIs', 'Xda IIs'),
(7908, 'Xda Atom Exec', 'Xda Atom Exec', 'Xda Atom Exec'),
(7909, 'Xda Atom', 'Xda Atom', 'Xda Atom'),
(7910, 'XDA Stealth', 'XDA Stealth', 'XDA Stealth'),
(7911, 'Xda Zinc', 'Xda Zinc', 'Xda Zinc'),
(7912, 'JAMA', 'JAMA', 'JAMA'),
(7913, 'Pebble', 'Jaq3', 'Pebble Jaq3'),
(7914, 'JAQ', 'JAQ', 'JAQ'),
(7915, 'PDA L', 'PDA L', 'PDA L'),
(7916, 'Voice Messenger', 'iPAQ 510', 'Voice Messenger iPAQ 510'),
(7917, 'Pocket PC', 'Pocket PC', 'Pocket PC'),
(7918, 'iPAQ H5450 series', 'iPAQ H5450 series', 'iPAQ H5450 series'),
(7919, 'iPAQ H6300 series', 'iPAQ H6300 series', 'iPAQ H6300 series'),
(7920, 'A9100', 'A9100', 'A9100'),
(7921, 'Apache', '6700', 'Apache 6700'),
(7922, 'MDA Compact', 'MDA Compact', 'MDA Compact'),
(7923, 'MDA III', 'MDA III', 'MDA III'),
(7924, 'MDA Pro', 'MDA Pro', 'MDA Pro'),
(7925, 'MDA Vario', 'MDA Vario', 'MDA Vario'),
(7926, 'MDA Vario II', 'MDA Vario II', 'MDA Vario II'),
(7927, 'MDA compact II', 'MDA compact II', 'MDA compact II'),
(7928, 'XDA/Exec', 'XDA/Exec', 'XDA/Exec'),
(7929, 'Prophet', 'Prophet', 'Prophet'),
(7930, 'i920B', 'i920B', 'i920B'),
(7931, 'Vision', 'PPC 6600', 'Vision PPC 6600'),
(7932, 'SPH-ip830w', 'SPH-ip830w', 'SPH-ip830w'),
(7933, 'XDA/Mini', 'XDA/Mini', 'XDA/Mini'),
(7934, 'Xda Cosmo', 'Xda Cosmo', 'Xda Cosmo'),
(7935, 'XDA/NEO', 'XDA/NEO', 'XDA/NEO'),
(7936, 'JamIn', 'JamIn', 'JamIn'),
(7937, 'Hermes', 'JASJAM', 'Hermes JASJAM'),
(7938, 'JASJAR', 'JASJAR', 'JASJAR'),
(7939, 'Xda Flame', 'Xda Flame', 'Xda Flame'),
(7940, 'Zaurus', 'Sharp', 'Zaurus Sharp'),
(7941, 'A925', 'A925', 'A925'),
(7942, 'Treo 600', 'Treo 600', 'Treo 600'),
(7943, 'TX', 'TX', 'TX'),
(7944, 'Treo 680', 'Treo 680', 'Treo 680'),
(7945, 'Treo 755p', 'Treo 755p', 'Treo 755p'),
(7946, 'Centro', 'Centro', 'Centro'),
(7947, 'Treo 650', 'Treo 650', 'Treo 650'),
(7948, 'Tunx', 'Tunx', 'Tunx'),
(7949, 'Treo700p', 'Treo700p', 'Treo700p'),
(7950, 'Asus Otto', 'Treo 500v', 'Asus Otto Treo 500v'),
(7951, 'P525', 'P525', 'P525'),
(7952, 'P735', 'P735', 'P735'),
(7953, 'M530w', 'M530w', 'M530w'),
(7954, 'M930', 'M930', 'M930'),
(7955, 'C500', 'C500', 'C500'),
(7956, 'C730', 'C730', 'C730'),
(7957, 'XDA/Atom Life', 'XDA/Atom Life', 'XDA/Atom Life'),
(7958, 'CHT 9100', 'CHT 9100', 'CHT 9100'),
(7959, 'MDA Touch', 'MDA Touch', 'MDA Touch'),
(7960, 'P5800', 'P5800', 'P5800'),
(7961, 'Titan', 'P6800', 'Titan P6800'),
(7962, 'EM-ONE', 'S01SH', 'EM-ONE S01SH'),
(7963, 'Dash', 'Dash', 'Dash'),
(7964, 'Herald/Wing/Atlas', 'Atlas', 'Herald/Wing/Atlas Atlas'),
(7965, 'Softbank X01T', 'X01T/G900', 'Softbank X01T X01T/G900'),
(7966, 'Advanced W-Zero', 'WS011SH', 'Advanced W-Zero WS011SH'),
(7967, 'XDA Comet', 'XDA Comet', 'XDA Comet'),
(7968, 'Zune HD', 'Zune HD', 'Zune HD'),
(7969, 'KIN One', 'KIN One', 'KIN One'),
(7970, 'KIN Two', 'KIN Two', 'KIN Two'),
(7971, 'U1000', 'U1000', 'U1000'),
(7972, 'Xda Atom Life', 'Xda Atom Life', 'Xda Atom Life'),
(7973, 'Ameo', 'Ameo', 'Ameo'),
(7974, 'Mail', 'Mail', 'Mail'),
(7975, 'Panda', 'Xda Argon', 'Panda Xda Argon'),
(7976, 'XDA/Trion', 'XDA/Trion', 'XDA/Trion'),
(7977, 'SCH-i760', 'SCH-i760', 'SCH-i760'),
(7978, 'G810', 'G810', 'G810'),
(7979, 'Verizon', 'XV6800', 'Verizon XV6800'),
(7980, 'XV6850', 'XV6850', 'XV6850'),
(7981, 'GalaxyMini', 'GalaxyMini', 'GalaxyMini'),
(7982, 'P527', 'P527', 'P527'),
(7983, 'P552', 'P552', 'P552'),
(7984, 'ASUS-GalaxyMini2', 'ASUS-GalaxyMini2', 'ASUS-GalaxyMini2'),
(7985, 'P552w', 'P552w', 'P552w'),
(7986, 'P750', 'P750', 'P750'),
(7987, 'iPAQ 610', 'iPAQ 610', 'iPAQ 610'),
(7988, 'DoCoMo Pro Series HT-02A', 'DoCoMo Pro Series HT-02A', 'DoCoMo Pro Series HT-02A'),
(7989, 'e810', 'e810', 'e810'),
(7990, 'Zinc II', 'Zinc II', 'Zinc II'),
(7991, 'MDA  Ameo', 'MDA  Ameo', 'MDA  Ameo'),
(7992, 'MDA Vario III', 'MDA Vario III', 'MDA Vario III'),
(7993, 'MDA Vario IV', 'MDA Vario IV', 'MDA Vario IV'),
(7994, 'MDA Compact IV', 'MDA Compact IV', 'MDA Compact IV'),
(7995, 'S21HT', 'S21HT', 'S21HT'),
(7996, 'Sprint', 'MP6950 SP', 'Sprint MP6950 SP'),
(7997, 'Touch Pro', 'Sprint PPC6850SP', 'Touch Pro Sprint PPC6850SP'),
(7998, 'Mogul', 'Titan', 'Mogul Titan'),
(7999, 'Shadow II / Cleopatra', 'Shadow II / Cleopatra', 'Shadow II / Cleopatra'),
(8000, 'Leo', 'Leo', 'Leo'),
(8001, '103 VGA', '103 VGA', '103 VGA'),
(8002, 'Saga', 'SCH-I770', 'Saga SCH-I770'),
(8003, 'Viewty', 'KS20', 'Viewty KS20'),
(8004, 'Vodafone 1231', 'Vodafone 1231', 'Vodafone 1231'),
(8005, 'Willcom 03', 'WS020SH', 'Willcom 03 WS020SH'),
(8006, '9502', '9502', '9502'),
(8007, 'E4000', 'E4000', 'E4000'),
(8008, 'MS20', 'MS20', 'MS20'),
(8009, 'MS25', 'MS25', 'MS25'),
(8010, 'GSmart MS800', 'GSmart MS800', 'GSmart MS800'),
(8011, 'MDA Touch Plus', 'MDA Touch Plus', 'MDA Touch Plus'),
(8012, 'MDA Compact III', 'MDA Compact III', 'MDA Compact III'),
(8013, 'ACE', 'SPH-I325', 'ACE SPH-I325'),
(8014, 'Treo 700VX', 'Treo 700VX', 'Treo 700VX'),
(8015, 'VDA GPS', 'VDA GPS', 'VDA GPS'),
(8016, 'Polaris', 'SFR V3650', 'Polaris SFR V3650'),
(8017, 'VPA Touch', 'VPA Touch', 'VPA Touch'),
(8018, '8502', '8502', '8502'),
(8019, 'XV6900', 'XV6900', 'XV6900'),
(8020, 'P550', 'P550', 'P550'),
(8021, 'FOMA HT1100', 'Neon', 'FOMA HT1100 Neon'),
(8022, 'g-Smart', 'T600', 'g-Smart T600'),
(8023, 'Emonster', 'S11HT', 'Emonster S11HT'),
(8024, 'EMonster Lite (S12HT)', 'S12HT', 'EMonster Lite (S12HT) S12HT'),
(8025, 'G910_G920', 'G910_G920', 'G910_G920'),
(8026, 'Vodafone 1520', 'Vodafone 1520', 'Vodafone 1520'),
(8027, 'XV6175', 'XV6175', 'XV6175'),
(8028, 'Acer P400', 'Acer P400', 'Acer P400'),
(8029, 'Treo Pro', 'Treo850e', 'Treo Pro Treo850e'),
(8030, 'GW550', 'GW550', 'GW550'),
(8031, 'Snap', 'S511', 'Snap S511'),
(8032, 'TouchFLO', 'T7380', 'TouchFLO T7380'),
(8033, 'Intrepid', 'Sprint SPH i350', 'Intrepid Sprint SPH i350'),
(8034, 'Dash 3G', 'Dash 3G', 'Dash 3G'),
(8035, 'MDA Vario V', 'MDA Vario V', 'MDA Vario V'),
(8036, 'beTouch E200', 'Acer E200', 'beTouch E200 Acer E200'),
(8037, 'Acer F900', 'Acer F900', 'Acer F900'),
(8038, 'X960', 'X960', 'X960'),
(8039, 'garmin-asus-Nuvifone-M10', 'garmin-asus-Nuvifone-M10', 'garmin-asus-Nuvifone-M10'),
(8040, 'Fathom', 'VS750', 'Fathom VS750'),
(8041, 'Windows Mobile (Opera)', 'Windows Mobile (Opera)', 'Windows Mobile (Opera)'),
(8042, 'N2', 'N2', 'N2'),
(8043, '770', '770', '770'),
(8044, 'Chocolate Touch', '8575', 'Chocolate Touch 8575'),
(8045, 'MPx', 'MPx', 'MPx'),
(8046, 'Cute 547', '547', 'Cute 547 547'),
(8047, 'Cute 547i', '547i', 'Cute 547i 547i'),
(8048, '8575 Touch', '8575', '8575 Touch 8575'),
(8049, '740SC', '740SC', '740SC'),
(8050, '815SH', '815SH', '815SH'),
(8051, 'The Premium', '820SH', 'The Premium 820SH'),
(8052, '821SC', '821SC', '821SC'),
(8053, '910SH', '910SH', '910SH'),
(8054, '911SH', '911SH', '911SH'),
(8055, '912SH', '912SH', '912SH'),
(8056, 'Fullface', '913SH', 'Fullface 913SH'),
(8057, 'Photos', '920SC', 'Photos 920SC'),
(8058, 'Exlim', '930CA', 'Exlim 930CA'),
(8059, 'Omnia', '930SC', 'Omnia 930SC'),
(8060, 'Viera Ketai', '941P', 'Viera Ketai 941P'),
(8061, 'Nec N906imyu', 'Nec N906imyu', 'Nec N906imyu'),
(8062, 'Viera', 'P905iTV', 'Viera P905iTV'),
(8063, 'PEG-TH55', 'PEG-TH55', 'PEG-TH55'),
(8064, 'PEG-TJ37', 'PEG-TJ37', 'PEG-TJ37'),
(8065, 'Opera for Series 60', 'Opera for Series 60', 'Opera for Series 60'),
(8066, 'Twist', '7705', 'Twist 7705'),
(8067, 'Prestige', 'AN510', 'Prestige AN510'),
(8068, 'Banter Touch', 'MN510', 'Banter Touch MN510'),
(8069, 'Banter Touch', 'UN510', 'Banter Touch UN510'),
(8070, 'CX10000', 'CX10000', 'CX10000'),
(8071, 'CX700', 'CX700', 'CX700'),
(8072, 'Tungsten C', 'Tungsten C', 'Tungsten C'),
(8073, 'Tungsten T3', 'Tungsten T3', 'Tungsten T3'),
(8074, '001SH', '001SH', '001SH'),
(8075, 'Aquos Shot 002SH', '002SH', 'Aquos Shot 002SH 002SH'),
(8076, '004SH', '004SH', '004SH'),
(8077, 'Pantone Slide', '825SH', 'Pantone Slide 825SH'),
(8078, 'Pantone', '830SH', 'Pantone 830SH'),
(8079, '841SHs', '841SHs', '841SHs'),
(8080, 'Communicator', '922SH', 'Communicator 922SH'),
(8081, 'Aquos FullTouch', '931SH', 'Aquos FullTouch 931SH'),
(8082, '933SH', '933SH', '933SH'),
(8083, '940SH', '940SH', '940SH'),
(8084, '941SC', '941SC', '941SC'),
(8085, '941SH', '941SH', '941SH'),
(8086, 'Premium 5 942SH', '942SH', 'Premium 5 942SH 942SH'),
(8087, '943SH', '943SH', '943SH'),
(8088, '944SH', '944SH', '944SH'),
(8089, 'Aquos Shot 945SH', '945SH', 'Aquos Shot 945SH 945SH'),
(8090, 'Bold', 'Bold', 'Bold'),
(8091, 'Q10', 'Q10', 'Q10'),
(8092, 'Z10', 'Z10', 'Z10'),
(8093, 'Sidekick', 'Sidekick II', 'Sidekick Sidekick II'),
(8094, 'Sidekick', 'Sidekick 4', 'Sidekick Sidekick 4'),
(8095, 'Sidekick', 'LX', 'Sidekick LX'),
(8096, 'NWZ-X1060', 'NWZ-X1060', 'NWZ-X1060'),
(8097, 'Melody', 'U3220', 'Melody U3220'),
(8098, 'Athena', 'U5200', 'Athena U5200'),
(8099, 'U5300', 'U5300', 'U5300'),
(8100, 'LG-C195', 'LG-C195', 'LG-C195'),
(8101, 'C330', 'C330', 'C330'),
(8102, 'LG-C360', 'LG-C360', 'LG-C360'),
(8103, 'LG-C365', 'LG-C365', 'LG-C365'),
(8104, 'C375 Cookie Tweet', 'C375', 'C375 Cookie Tweet C375'),
(8105, 'Marimba', 'E300', 'Marimba E300'),
(8106, 'Mini', 'GD880', 'Mini GD880'),
(8107, 'LG-T370', 'LG-T370', 'LG-T370'),
(8108, 'LG-T375', 'LG-T375', 'LG-T375'),
(8109, 'T385', 'T385', 'T385'),
(8110, 'T500', 'T500', 'T500'),
(8111, 'T505', 'T505', 'T505'),
(8112, 'T515 Cookie Duo', 'T515', 'T515 Cookie Duo T515'),
(8113, 'Garmin nuvifone', 'Nuvifone G60', 'Garmin nuvifone Nuvifone G60'),
(8114, 'Sony Reader Wi-Fi', 'PRST1', 'Sony Reader Wi-Fi PRST1'),
(8115, 'MTS Alive', 'E390', 'MTS Alive E390'),
(8116, 'Nec N01A', 'Nec N01A', 'Nec N01A'),
(8117, 'PUMA Phone M1', 'PUMA Phone M1', 'PUMA Phone M1'),
(8118, 'JOY', 'KT610', 'JOY KT610'),
(8119, 'kt615', 'kt615', 'kt615'),
(8120, 'Quest', 'Constellation', 'Quest Constellation'),
(8121, 'KT770', 'KT770', 'KT770'),
(8122, 'T385B', 'T385B', 'T385B'),
(8123, 'Viper T565', 'LG-T565b', 'Viper T565 LG-T565b'),
(8124, 'Fennec', 'Firefox Mobile', 'Fennec Firefox Mobile'),
(8125, 'Bolt Browser', 'Bolt Browser', 'Bolt Browser'),
(8126, 'ChromeBook', 'ChromeBook', 'ChromeBook'),
(8127, 'Octane', 'VN530', 'Octane VN530'),
(8128, 'Crux', 'CDM8999', 'Crux CDM8999'),
(8129, 'Sidekick', 'Hiptop', 'Sidekick Hiptop'),
(8130, '235', '235', '235'),
(8131, 'AURA', 'AURA', 'AURA'),
(8132, 'MOTOROKR E8', 'MOTOROKR E8', 'MOTOROKR E8'),
(8133, 'Spider 2', 'AX840', 'Spider 2 AX840'),
(8134, 'Bliss', '700', 'Bliss 700'),
(8135, 'UX700', 'UX700', 'UX700'),
(8136, 'Tritan', 'UX840', 'Tritan UX840'),
(8137, 'Dare', 'VX9700', 'Dare VX9700'),
(8138, 'Bliss - Volt', 'MX700', 'Bliss - Volt MX700'),
(8139, 'Versa', 'VX9600', 'Versa VX9600'),
(8140, 'enV3', 'VX-9200', 'enV3 VX-9200'),
(8141, 'Suede', 'SCH-R710', 'Suede SCH-R710'),
(8142, 'Caliber', 'R860', 'Caliber R860'),
(8143, 'SCH-R800', 'SCH-R800', 'SCH-R800'),
(8144, 'Layla', 'GM750', 'Layla GM750'),
(8145, 'Zire 72', 'Zire 72', 'Zire 72'),
(8146, 'C721', 'C721', 'C721'),
(8147, 'XStream E781A', 'E781A', 'XStream E781A E781A'),
(8148, 'B21', 'B21', 'B21'),
(8149, 'B22 Duo', 'B22 Duo', 'B22 Duo'),
(8150, 'Duo', 'B23', 'Duo B23'),
(8151, 'B31', 'B31', 'B31'),
(8152, 'MS28', 'MS28', 'MS28'),
(8153, 'Q19i Duo', 'Q19i Duo', 'Q19i Duo'),
(8154, 'Q21', 'Q21', 'Q21'),
(8155, 'Duo', 'Q22', 'Duo Q22'),
(8156, 'Q22', 'Q22', 'Q22'),
(8157, 'S21', 'S21', 'S21'),
(8158, 'DUO', 'TV21', 'DUO TV21'),
(8159, 'N1000i', 'N1000i', 'N1000i'),
(8160, 'N1010', 'N1010', 'N1010'),
(8161, 'N1020', 'N1020', 'N1020'),
(8162, 'N1030', 'N1030', 'N1030'),
(8163, 'N130', 'N130', 'N130'),
(8164, 'N2020', 'N2020', 'N2020'),
(8165, 'N2030', 'N2030', 'N2030'),
(8166, 'N213', 'N213', 'N213'),
(8167, 'N215', 'N215', 'N215'),
(8168, 'N235W', 'N235W', 'N235W'),
(8169, 'N3000', 'N3000', 'N3000'),
(8170, 'N3020', 'N3020', 'N3020'),
(8171, 'N5000', 'N5000', 'N5000'),
(8172, 'N5010', 'N5010', 'N5010'),
(8173, 'N5020', 'N5020', 'N5020'),
(8174, 'N5050', 'N5050', 'N5050'),
(8175, 'N6000', 'N6000', 'N6000'),
(8176, 'N7000', 'N7000', 'N7000'),
(8177, 'N7010', 'N7010', 'N7010'),
(8178, 'N7100', 'N7100', 'N7100'),
(8179, 'C260', 'C260', 'C260'),
(8180, 'Mega-X', 'Mega-X', 'Mega-X'),
(8181, 'Topaz', 'Topaz', 'Topaz'),
(8182, 'NEX 800', 'NEX 800', 'NEX 800'),
(8183, 'NX-G911', 'NX-G911', 'NX-G911'),
(8184, 'Ocean', 'Ocean', 'Ocean'),
(8185, 'SOAP', 'SOAP', 'SOAP'),
(8186, 'Supreme', 'Supreme', 'Supreme'),
(8187, 'Argo', 'Argo', 'Argo'),
(8188, 'Alittle', 'Alittle', 'Alittle'),
(8189, 'Billy', 'Billy', 'Billy'),
(8190, 'Class', 'Class', 'Class'),
(8191, 'Clio', 'Clio', 'Clio'),
(8192, 'Coffee', 'Coffee', 'Coffee'),
(8193, 'MC220', 'MC220', 'MC220'),
(8194, 'Enjoy', 'Enjoy', 'Enjoy'),
(8195, 'Metal Devil', 'Metal Devil', 'Metal Devil'),
(8196, 'MetalSoap', 'MetalSoap', 'MetalSoap'),
(8197, 'Mito', 'Mito', 'Mito'),
(8198, 'Pixy', 'Pixy', 'Pixy'),
(8199, 'Play', 'Play', 'Play'),
(8200, 'Premier', 'Premier', 'Premier'),
(8201, 'Prestige', 'Prestige', 'Prestige'),
(8202, 'Rock', 'Rock', 'Rock'),
(8203, 'Soapqwerty', 'Soapqwerty', 'Soapqwerty'),
(8204, 'Vanity', 'Vanity', 'Vanity'),
(8205, 'VanityEVO', 'VanityEVO', 'VanityEVO'),
(8206, 'Vanityqwerty', 'Vanityqwerty', 'Vanityqwerty'),
(8207, 'Vanitytouch', 'Vanitytouch', 'Vanitytouch'),
(8208, 'Vanityyoung', 'Vanityyoung', 'Vanityyoung'),
(8209, 'Internet Security Updater', 'Internet Security Updater', 'Internet Security Updater'),
(8210, '6256i', '6256i', '6256i'),
(8211, 'Nhp 2Ax', 'Nhp 2Ax', 'Nhp 2Ax'),
(8212, '2280/2285', '2280/2285', '2280/2285'),
(8213, '2285', '2285', '2285'),
(8214, '2270', '2270', '2270'),
(8215, '3586i', '3586i', '3586i'),
(8216, '3105', '3105', '3105'),
(8217, '3205 SPR', '3205 SPR', '3205 SPR'),
(8218, 'N1', 'N1', 'N1'),
(8219, 'Lotus Elite', 'LX610', 'Lotus Elite LX610'),
(8220, 'Remarq', 'LN240', 'Remarq LN240'),
(8221, 'Rumor Reflex', 'LG272', 'Rumor Reflex LG272'),
(8222, 'Rumor Reflex', 'LN272', 'Rumor Reflex LN272'),
(8223, 'NewYork', 'NewYork', 'NewYork'),
(8224, 'x7', 'x7', 'x7'),
(8225, 'Rhoma-Rhido', 'NX-G505', 'Rhoma-Rhido NX-G505'),
(8226, 'Nidji', 'NX-G508', 'Nidji NX-G508'),
(8227, 'SoundBox', 'NX-G509', 'SoundBox NX-G509'),
(8228, 'Beat TV', 'NX-T905', 'Beat TV NX-T905'),
(8229, 'TeleMAX', 'NX-T909', 'TeleMAX NX-T909'),
(8230, 'NX250 D', 'NX250 D', 'NX250 D'),
(8231, 'Batman', 'NXG777', 'Batman NXG777'),
(8232, 'Yahoo', 'NX G821', 'Yahoo NX G821'),
(8233, 'NX D980', 'NX D980', 'NX D980'),
(8234, 'NX-D981', 'NX-D981', 'NX-D981'),
(8235, 'Ferro', 'NX G225', 'Ferro NX G225'),
(8236, 'ColorBox', 'NX-G236', 'ColorBox NX-G236'),
(8237, 'Steel', 'NX G268', 'Steel NX G268'),
(8238, 'Dynamic', 'NX-G353', 'Dynamic NX-G353'),
(8239, 'Lolie', 'NX-G730', 'Lolie NX-G730'),
(8240, 'NX G801', 'NX G801', 'NX G801'),
(8241, 'Snap', 'NX-G857', 'Snap NX-G857'),
(8242, 'Tap NX-G868', 'NX-G868', 'Tap NX-G868 NX-G868'),
(8243, 'Tap TV NX-G868T', 'NX-G868T', 'Tap TV NX-G868T NX-G868T'),
(8244, 'Cappucino', 'NX-G869', 'Cappucino NX-G869'),
(8245, 'Princess', 'NX-G889', 'Princess NX-G889'),
(8246, 'NX G900', 'NX G900', 'NX G900'),
(8247, 'XTV', 'NX G901', 'XTV NX G901'),
(8248, 'NX G912', 'NX G912', 'NX G912'),
(8249, 'Music Phone', 'NX-G915', 'Music Phone NX-G915'),
(8250, 'Hits TV', 'NX G921', 'Hits TV NX G921'),
(8251, 'Nexianberry', 'NX G922', 'Nexianberry NX G922'),
(8252, 'Verde', 'NX-G933', 'Verde NX-G933'),
(8253, 'Champion', 'NX G965', 'Champion NX G965'),
(8254, 'Spade', 'NX G988', 'Spade NX G988'),
(8255, 'NX-NXT901', 'NX-NXT901', 'NX-NXT901'),
(8256, 'NX T780', 'NX T780', 'NX T780'),
(8257, 'NX T911', 'NX T911', 'NX T911'),
(8258, 'Berry', 'NX T922', 'Berry NX T922'),
(8259, 'Speed', 'NX-W701', 'Speed NX-W701'),
(8260, 'Speed2', 'NX-W750', 'Speed2 NX-W750'),
(8261, 'Njoy', 'Njoy', 'Njoy'),
(8262, 'O140', 'O140', 'O140'),
(8263, 'X1b', 'X1b', 'X1b'),
(8264, 'O2-X1i', 'O2-X1i', 'O2-X1i'),
(8265, 'X2i', 'X2i', 'X2i'),
(8266, 'X4', 'X4', 'X4'),
(8267, 'Jet', 'Jet', 'Jet'),
(8268, 'Konnect', 'OGO O-77', 'Konnect OGO O-77'),
(8269, 'Touch', 'OGO O-78', 'Touch OGO O-78'),
(8270, 'N131', 'N131', 'N131'),
(8271, 'OPPOA201', 'OPPOA201', 'OPPOA201'),
(8272, 'OPPOA520', 'OPPOA520', 'OPPOA520'),
(8273, 'OPPOU525', 'OPPOU525', 'OPPOU525'),
(8274, 'OPPOU529', 'OPPOU529', 'OPPOU529'),
(8275, 'OPPOA115K', 'OPPOA115K', 'OPPOA115K'),
(8276, 'OPPOF15', 'OPPOF15', 'OPPOF15'),
(8277, 'OPWV-SDK/70', 'OPWV-SDK/70', 'OPWV-SDK/70'),
(8278, 'OPWV-SDK/7.0.2.3', 'OPWV-SDK/7.0.2.3', 'OPWV-SDK/7.0.2.3'),
(8279, 'OPWV-SDK/60', 'OPWV-SDK/60', 'OPWV-SDK/60'),
(8280, 'OPWV-SDK/61', 'OPWV-SDK/61', 'OPWV-SDK/61'),
(8281, 'OPWV-SDK/62', 'OPWV-SDK/62', 'OPWV-SDK/62'),
(8282, 'OT S680', 'OT S680', 'OT S680'),
(8283, 'OT S686', 'OT S686', 'OT S686'),
(8284, 'OT S692', 'OT S692', 'OT S692'),
(8285, '6750', '6750', '6750'),
(8286, 'Tabbee', 'HomeManager', 'Tabbee HomeManager'),
(8287, 'T-Hub', 'HomeManager', 'T-Hub HomeManager'),
(8288, 'Mobile 10 Windows', 'Mobile 10 Windows', 'Mobile 10 Windows'),
(8289, 'Seville', 'Seville', 'Seville'),
(8290, 'M88', 'M88', 'M88'),
(8291, '775', '775', '775'),
(8292, 'PN-215', 'PN-215', 'PN-215'),
(8293, 'PN-E330', 'PN-E330', 'PN-E330'),
(8294, 'LX265', 'LX265', 'LX265'),
(8295, 'LX370', 'LX370', 'LX370'),
(8296, 'Porsche Design', 'P9521', 'Porsche Design P9521'),
(8297, 'Porsche Design', 'P\'9522', 'Porsche Design P\'9522'),
(8298, 'S901', 'S901', 'S901'),
(8299, 'DX900', 'DX900', 'DX900'),
(8300, 'PU-C600', 'PU-C600', 'PU-C600'),
(8301, 'PU-C710', 'PU-C710', 'PU-C710'),
(8302, 'PURPLE A700', 'PURPLE A700', 'PURPLE A700'),
(8303, 'Treo850', 'Treo850', 'Treo850'),
(8304, 'Treo680', 'Treo680', 'Treo680'),
(8305, 'Treo 750w', 'Treo 750w', 'Treo 750w'),
(8306, 'Treo 750', 'Treo 750', 'Treo 750'),
(8307, 'Treo 850', 'Treo 850', 'Treo 850'),
(8308, 'Panama-orange', 'Panama-orange', 'Panama-orange'),
(8309, 'M401', 'M401', 'M401'),
(8310, 'DH910/DP-L10', 'DH910/DP-L10', 'DH910/DP-L10'),
(8311, 'PW6000Q', 'PW6000Q', 'PW6000Q'),
(8312, 'W601', 'W601', 'W601'),
(8313, 'Cpw', 'Cpw', 'Cpw'),
(8314, 'Q61', 'Q61', 'Q61'),
(8315, 'F220', 'F220', 'F220'),
(8316, 'Q151', 'Q151', 'Q151'),
(8317, 'Q5C', 'Q5C', 'Q5C'),
(8318, 'OPWV 4', 'OPWV 4', 'OPWV 4'),
(8319, 'OPWV 5', 'OPWV 5', 'OPWV 5'),
(8320, 'OPWV 6', 'OPWV 6', 'OPWV 6'),
(8321, 'QS200', 'QS200', 'QS200'),
(8322, 'R228', 'R228', 'R228'),
(8323, 'R236', 'R236', 'R236'),
(8324, 'R237', 'R237', 'R237'),
(8325, 'R260', 'R260', 'R260'),
(8326, 'R380e', 'R380e', 'R380e'),
(8327, 'R830', 'R830', 'R830'),
(8328, '7530', '7530', '7530'),
(8329, '176x220', '176x220', '176x220'),
(8330, 'X850', 'X850', 'X850'),
(8331, 'RX600', 'RX600', 'RX600'),
(8332, 'Midlet', 'Midlet', 'Midlet'),
(8333, 'DVP', 'DVP', 'DVP'),
(8334, 'SCH-M569', 'SCH-M569', 'SCH-M569'),
(8335, 'JetSet', 'SCH R550', 'JetSet SCH R550'),
(8336, 'SCH S379', 'SCH S379', 'SCH S379'),
(8337, 'A670', 'A670', 'A670'),
(8338, 'SCH-3500', 'SCH-3500', 'SCH-3500'),
(8339, 'SE-02', 'SE-02', 'SE-02'),
(8340, 'SPH-i500', 'SPH-i500', 'SPH-i500'),
(8341, 'T206', 'T206', 'T206'),
(8342, 'U3300', 'U3300', 'U3300'),
(8343, 'SFR 114', 'R220', 'SFR 114 R220'),
(8344, 'G X960', 'G X960', 'G X960'),
(8345, 'Alice', 'SH0037D', 'Alice SH0037D'),
(8346, 'SFG75', 'SFG75', 'SFG75'),
(8347, '83AT', '83AT', '83AT'),
(8348, 'T650', 'T650', 'T650'),
(8349, 'SL900', 'SL900', 'SL900'),
(8350, 'slide99', 'slide99', 'slide99'),
(8351, 'SLT100', 'SLT100', 'SLT100'),
(8352, 'XP1', 'XP1', 'XP1'),
(8353, 'SP710', 'SP710', 'SP710'),
(8354, 'S101', 'S101', 'S101'),
(8355, 'M940', 'M940', 'M940'),
(8356, 'S920', 'S920', 'S920'),
(8357, 'S940', 'S940', 'S940'),
(8358, 'M6464', 'M6464', 'M6464'),
(8359, 'S555', 'S555', 'S555'),
(8360, 'S640', 'S640', 'S640'),
(8361, 'S8', 'S8', 'S8'),
(8362, 'S800', 'S800', 'S800'),
(8363, 'S808', 'S808', 'S808'),
(8364, 'S900', 'S900', 'S900'),
(8365, 'X900', 'X900', 'X900'),
(8366, 'Messager', 'R450', 'Messager R450'),
(8367, 'J530', 'J530', 'J530'),
(8368, 'M550', 'M550', 'M550'),
(8369, 'M570', 'M570', 'M570'),
(8370, 'P600', 'P600', 'P600'),
(8371, 'S251', 'S251', 'S251'),
(8372, 'S330', 'S330', 'S330'),
(8373, 'S360', 'S360', 'S360'),
(8374, 'S620', 'S620', 'S620'),
(8375, 'V663', 'V663', 'V663'),
(8376, 'X', 'X', 'X'),
(8377, 'Feed Parser', 'Feed Parser', 'Feed Parser'),
(8378, 'SX813', 'SX813', 'SX813'),
(8379, 'S7400', 'S7400', 'S7400'),
(8380, 'Generic', 'Generic', 'Generic'),
(8381, '001N', '001N', '001N'),
(8382, '001P', '001P', '001P'),
(8383, '001SC', '001SC', '001SC'),
(8384, '002P', '002P', '002P'),
(8385, '002P for Biz', '002P for Biz', '002P for Biz'),
(8386, '705N', '705N', '705N'),
(8387, '705NK', '705NK', '705NK'),
(8388, '705P', '705P', '705P'),
(8389, '705SC', '705SC', '705SC'),
(8390, '706N', '706N', '706N'),
(8391, '706P', '706P', '706P'),
(8392, '706SC', '706SC', '706SC'),
(8393, '707SC', '707SC', '707SC'),
(8394, '707SC2', '707SC2', '707SC2'),
(8395, '708SC', '708SC', '708SC'),
(8396, '709SC', '709SC', '709SC'),
(8397, '731SC', '731SC', '731SC'),
(8398, '805SC', '805SC', '805SC'),
(8399, '810P', '810P', '810P'),
(8400, '810SH', '810SH', '810SH'),
(8401, '810T', '810T', '810T'),
(8402, '811SH', '811SH', '811SH'),
(8403, '811T', '811T', '811T'),
(8404, '812SH', '812SH', '812SH'),
(8405, 'Gent', '812SH s2', 'Gent 812SH s2'),
(8406, '812T', '812T', '812T'),
(8407, '813SH', '813SH', '813SH'),
(8408, '813T', '813T', '813T'),
(8409, '814SH', '814SH', '814SH'),
(8410, '814T', '814T', '814T'),
(8411, 'Fan Fan', '815T', 'Fan Fan 815T'),
(8412, '816SH', '816SH', '816SH'),
(8413, '820N', '820N', '820N'),
(8414, '820P', '820P', '820P'),
(8415, '820SC', '820SC', '820SC'),
(8416, '820T', '820T', '820T'),
(8417, '821N', '821N', '821N'),
(8418, '821P', '821P', '821P'),
(8419, '821SH', '821SH', '821SH'),
(8420, '821T', '821T', '821T'),
(8421, '822P', '822P', '822P'),
(8422, 'Aquos', '822SH', 'Aquos 822SH'),
(8423, '822T', '822T', '822T'),
(8424, 'Tropical', '823P', 'Tropical 823P'),
(8425, 'The Premium Texture', '823SH', 'The Premium Texture 823SH'),
(8426, '823T', '823T', '823T'),
(8427, 'Mirror II', '824P', 'Mirror II 824P'),
(8428, 'The Premium', '824SH', 'The Premium 824SH'),
(8429, '824T', '824T', '824T'),
(8430, '830CA', '830CA', '830CA'),
(8431, '830N', '830N', '830N'),
(8432, '830P', '830P', '830P'),
(8433, 'Night Effect', '830SC', 'Night Effect 830SC'),
(8434, '830SH for Biz', '830SH for Biz', '830SH for Biz'),
(8435, 'Premium', '830SH Premium', 'Premium 830SH Premium'),
(8436, 'Gent', '830SH s', 'Gent 830SH s'),
(8437, 'Fanfun.2', '830T', 'Fanfun.2 830T'),
(8438, '831N', '831N', '831N'),
(8439, '831P', '831P', '831P'),
(8440, '831SH KT', '831SH KT', '831SH KT'),
(8441, 'Gent', '831SH s', 'Gent 831SH s'),
(8442, 'Fanfun petit', '831T', 'Fanfun petit 831T'),
(8443, '832P', '832P', '832P'),
(8444, '832SH', '832SH', '832SH'),
(8445, '832SH s', '832SH s', '832SH s'),
(8446, '832T', '832T', '832T'),
(8447, '840N', '840N', '840N'),
(8448, '840P', '840P', '840P'),
(8449, '840P for Biz', '840P for Biz', '840P for Biz'),
(8450, '840SC', '840SC', '840SC'),
(8451, '840SH', '840SH', '840SH'),
(8452, '840Z', '840Z', '840Z'),
(8453, '841N', '841N', '841N'),
(8454, '841P', '841P', '841P'),
(8455, '841SH', '841SH', '841SH'),
(8456, '842P', '842P', '842P'),
(8457, '842SH', '842SH', '842SH'),
(8458, '843SH', '843SH', '843SH'),
(8459, 'Softbank 910T', '910T', 'Softbank 910T 910T'),
(8460, '911T', '911T', '911T'),
(8461, '912T', '912T', '912T'),
(8462, 'Viera', '920P', 'Viera 920P'),
(8463, '920SH YK', '920SH YK', '920SH YK'),
(8464, '920T', '920T', '920T'),
(8465, 'Viera', '921P', 'Viera 921P'),
(8466, 'Fullface2', '921SH', 'Fullface2 921SH'),
(8467, '921T', '921T', '921T'),
(8468, 'Aquos', '923SH', 'Aquos 923SH'),
(8469, '930N', '930N', '930N'),
(8470, '930P', '930P', '930P'),
(8471, '930SH', '930SH', '930SH'),
(8472, '931N', '931N', '931N'),
(8473, 'Viera', '931P', 'Viera 931P'),
(8474, 'Omnia Pop', '931SC', 'Omnia Pop 931SC'),
(8475, 'Aquos', '932SH', 'Aquos 932SH'),
(8476, '934SH', '934SH', '934SH'),
(8477, 'Premium Waterproof', '935SH', 'Premium Waterproof 935SH'),
(8478, 'Solar Hybrid', '936SH', 'Solar Hybrid 936SH'),
(8479, '940N', '940N', '940N'),
(8480, '940P', '940P', '940P'),
(8481, '940SC', '940SC', '940SC'),
(8482, '942P', '942P', '942P'),
(8483, 'DM001SH', 'DM001SH', 'DM001SH'),
(8484, 'Disney Cinderella', 'DM002SH', 'Disney Cinderella DM002SH'),
(8485, 'DM003SH', 'DM003SH', 'DM003SH'),
(8486, 'DM004SH', 'DM004SH', 'DM004SH'),
(8487, 'GALAPAGOS 005SH for Softbank', 'DM005SH', 'GALAPAGOS 005SH for Softbank DM005SH'),
(8488, 'DM006SH', 'DM006SH', 'DM006SH'),
(8489, 'GALAPAGOS 007SH for Softbank', 'DM007SH', 'GALAPAGOS 007SH for Softbank DM007SH'),
(8490, 'Aquos Sharp 945SH', '945SH', 'Aquos Sharp 945SH 945SH'),
(8491, 'GALAPAGOS 007SH for Softbank', 'DM008SH', 'GALAPAGOS 007SH for Softbank DM008SH'),
(8492, 'XP3.20', 'XP3.20', 'XP3.20'),
(8493, 'C 810', 'C 810', 'C 810'),
(8494, 'D90', 'D90', 'D90'),
(8495, 'D-88', 'D-88', 'D-88'),
(8496, 'M5100', 'M5100', 'M5100'),
(8497, 'M 5170', 'M 5170', 'M 5170'),
(8498, 'M5252', 'M5252', 'M5252'),
(8499, 'M5445', 'M5445', 'M5445'),
(8500, '5570', '5570', '5570'),
(8501, 'M5700 Flo', 'M5700', 'M5700 Flo M5700'),
(8502, 'M5750', 'M5750', 'M5750'),
(8503, 'M6200', 'M6200', 'M6200'),
(8504, 'M6700 Cappuccino', 'M6700', 'M6700 Cappuccino M6700'),
(8505, 'M9000', 'M9000', 'M9000'),
(8506, 'Q57', 'Q57', 'Q57'),
(8507, 'S5330', 'S5330', 'S5330'),
(8508, '5420', '5420', '5420'),
(8509, 'S590', 'S590', 'S590'),
(8510, 'S650', 'S650', 'S650'),
(8511, 'S705', 'S705', 'S705'),
(8512, 'S707', 'S707', 'S707'),
(8513, 'S820', 'S820', 'S820'),
(8514, 'S7', 'S7', 'S7'),
(8515, 'XP', 'XP', 'XP'),
(8516, 'T-Mobile Vairy Touch II', 'T-Mobile Vairy Touch II', 'T-Mobile Vairy Touch II'),
(8517, 'T218', 'T218', 'T218'),
(8518, 'T250', 'T250', 'T250'),
(8519, 'T618X', 'T618X', 'T618X'),
(8520, 'Skin', '7110', 'Skin 7110'),
(8521, '718', '718', '718'),
(8522, 'D308', 'D308', 'D308'),
(8523, 'D628', 'D628', 'D628'),
(8524, 'e767', 'e767', 'e767'),
(8525, 'e787', 'e787', 'e787'),
(8526, 'A228', 'A228', 'A228'),
(8527, 'TDG-9920', 'TDG-9920', 'TDG-9920'),
(8528, 'T420', 'T420', 'T420'),
(8529, 'T918', 'T918', 'T918'),
(8530, 'T919', 'T919', 'T919'),
(8531, 'B892', 'B892', 'B892'),
(8532, 'A615', 'A615', 'A615'),
(8533, 'B830', 'B830', 'B830'),
(8534, 'B832', 'B832', 'B832'),
(8535, 'A662', 'A662', 'A662'),
(8536, 'A665', 'A665', 'A665'),
(8537, 'A691', 'A691', 'A691'),
(8538, 'A907', 'A907', 'A907'),
(8539, 'A930', 'A930', 'A930'),
(8540, 'B2012', 'B2012', 'B2012'),
(8541, 'B2015', 'B2015', 'B2015'),
(8542, 'C800', 'C800', 'C800'),
(8543, 'D172', 'D172', 'D172'),
(8544, 'D702', 'D702', 'D702'),
(8545, 'D770', 'D770', 'D770'),
(8546, 'D780', 'D780', 'D780'),
(8547, 'D788', 'D788', 'D788'),
(8548, 'DT28', 'DT28', 'DT28'),
(8549, 'KTOUCH H699', 'KTOUCH H699', 'KTOUCH H699'),
(8550, 'KTOUCH H711', 'KTOUCH H711', 'KTOUCH H711'),
(8551, 'H800', 'H800', 'H800'),
(8552, 'H877', 'H877', 'H877'),
(8553, 'H999', 'H999', 'H999'),
(8554, 'V760', 'V760', 'V760'),
(8555, 'KTouch V908', 'KTouch V908', 'KTouch V908'),
(855